(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30355,        761]
NotebookOptionsPosition[     23132,        632]
NotebookOutlinePosition[     24599,        682]
CellTagsIndexPosition[     24556,        679]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Events from a ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 " Slider\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(v1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{{3.6365882471710567`*^9, 3.636588257202427*^9}, 
   3.793769988671091*^9},
 TextAlignment->Left,ExpressionUUID->"d303efac-a076-47f3-87ec-fdf1b1af42bf"],

Cell[TextData[{
 "When the JavaView display is opened, drag the slider to modify, first, the \
shape of a sine curve and, second, radius of the torus. The update events of \
the slider are caught by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to initiate a recomputation of the geometry."
}], "Text",ExpressionUUID->"53e780c1-dc9c-451d-ab2c-a5dd8e40ee9b"],

Cell[CellGroupData[{

Cell["Frequency of a Sine Curve", "Subsection",ExpressionUUID->"f0e4c9d5-709c-416f-bc82-88a1291c41eb"],

Cell["\<\
This notebook demonstrates the update listener class \
\"jvx.math.MathUpdateListener\" of JavaView. This listener operates \
asynchronously by starting another thread for the event handling. This avoids \
delays during the rotation and user perception of the ongoing event handling.\
\>", "Text",
 CellChangeTimes->{
  3.7937700582395277`*^9},ExpressionUUID->"7c46a1e3-6ee8-446d-8fb9-\
b7e5d512d858"],

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and load JavaView."
}], "MathCaption",ExpressionUUID->"e7d047cf-7fc1-4b16-a1ea-694cd34ccb27"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"a1bf2ffa-d4ce-47d5-a830-eb284c0905fc"],

Cell[BoxData[
 TemplateBox[{
  "General", "obs", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"WorldPlot`\\\\\\\"\\\"}]\\) has been \
superseded by \\!\\(\\*RowBox[{\\\"GeoGraphics\\\"}]\\), and is now obsolete. \
It will not be included in future versions of the Wolfram Language.\"", 2, 1, 
   1, 33085231965500057629, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7937807110245605`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5af04305-1170-4d95-9122-323bafb21c72"],

Cell[BoxData["\<\"JavaView`RunThrough` v3.0.3\"\>"], "Print",
 CellChangeTimes->{
  3.6365849402248125`*^9, {3.793780684296548*^9, 3.793780711352672*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"eb20c17f-8273-449f-b29a-4a6761cbe8a3"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{
  3.6365849402248125`*^9, {3.793780684296548*^9, 3.7937807113995132`*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4b8c69d6-c739-4c9f-8756-365c9884a541"]
}, Open  ]],

Cell["Create a JavaView slider and its info panel.", "MathCaption",ExpressionUUID->"4b1ff939-9f43-4196-b375-6c1464f783db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"slider", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.number.PuInteger\>\"", ",", "\"\<Frequency\>\""}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sliderIP", "=", 
   RowBox[{"slider", "[", 
    RowBox[{"getInfoPanel", "[", "]"}], "]"}]}], ";"}]}], "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[3]:=",ExpressionUUID->"4703e87d-9ffb-4f95-bd65-4a3116f00dff"],

Cell["\<\
We used the JavaView class PsMainFrame since it allows to dispose itself by \
clicking on the window dispose button (since the Java class java.awt.Frame \
would not react on such a click).\
\>", "Text",ExpressionUUID->"38e6f08e-f1ee-4fea-a454-c5e870018c78"],

Cell["Show the slider panel in a new frame.", "MathCaption",ExpressionUUID->"85e6b407-bbb0-44b8-b23f-002f84b9c4b7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"frame", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.object.PsMainFrame\>\"", ",", "\"\<Slider Frame\>\""}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"frame", "[", 
   RowBox[{"add", "[", 
    RowBox[{"\"\<Center\>\"", ",", "sliderIP"}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"frame", "[", 
   RowBox[{"setSize", "[", 
    RowBox[{"400", ",", "70"}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"JavaShow", "[", "frame", "]"}], ";"}]}], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"8539aad2-aa5a-46bb-b072-148d16aff4cc"],

Cell["\<\
Before installing an event handler for the slider, we open the display and \
draw an initial curve.\
\>", "Text",ExpressionUUID->"91140e1b-3415-42a2-b638-0c85004b2643"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sinCurve", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6365846616767964`*^9, 3.6365846655675907`*^9}, {
  3.7937807488274813`*^9, 3.793780770701573*^9}, {3.793780802651949*^9, 
  3.7937808133448677`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"23d006bc-3537-45aa-8fc7-ccf630555a26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sinGeom", "=", 
   RowBox[{"JavaView", "[", "sinCurve", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6365846616767964`*^9, 3.6365846655675907`*^9}, {
  3.7937807488274813`*^9, 3.793780770701573*^9}, {3.793780802651949*^9, 
  3.7937808246935472`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"9f2eb567-6399-483c-b57c-9b28fad09f34"],

Cell[BoxData[
 TemplateBox[{
  "JavaView", "load", 
   "\"JavaView: loading failed, \
graphics=\\!\\(\\*RowBox[{\\\"\\\\\\\"Graphics[{{{{},\\\\\\\\n {},\\\\\\\\n \
Annotation[{Directive[Opacity[1.],\\\\\\\\n RGBColor[0.368417, 0.506779, \
0.709798],\\\\\\\\n AbsoluteThickness[1.6]],\\\\\\\\n \
Line[{{1.0204081632653061e-7, 1.0204081632653043e-7},\\\\\\\\n \
{0.0015335896027981336, 0.0015335890016573888},\\\\\\\\n \
{0.0030670771647799406, 0.003067072356135641},\\\\\\\\n \
{0.006134052288743555, 0.006134013821563192},\\\\\\\\n {0.012268002536670784, \
0.01226769480864348},\\\\\\\\n {0.\\\\\\\"\\\", \\\"\[Ellipsis]\\\", \\\"\\\\\
\\\"-> ({(Identity[#1] & )[#1[[1]]],\\\\\\\\n (Identity[#1] & )[#1[[2]]]} & \
), \\\\\\\\\\\\\\\"CopiedValueFunction\\\\\\\\\\\\\\\" -> ({(Identity[#1] & \
)[#1[[1]]],\\\\\\\\n (Identity[#1] & )[#1[[2]]]} & )}},\\\\\\\\n PlotRange -> \
{{0, 5.},\\\\\\\\n {-0.999999949169892, 0.9999998405767353}},\\\\\\\\n \
PlotRangeClipping -> True, PlotRangePadding -> {{Scaled[0.02],\\\\\\\\n \
Scaled[0.02]},\\\\\\\\n {Scaled[0.02],\\\\\\\\n Scaled[0.02]}},\\\\\\\\n \
Ticks -> {Automatic, Automatic}}]\\\\\\\"\\\"}]\\)\"", 2, 23, 9, 
   33085231965500057629, "Local", "JavaView`RunThrough`JavaView"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{{3.793780693481643*^9, 3.793780825563651*^9}},
 CellLabel->
  "During evaluation of \
In[23]:=",ExpressionUUID->"d9672d31-8a7d-40b4-83b6-a5dc35a74a7c"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The following function is an event handler and will be called a listener when \
the slider is modified. The argument evt is the slider object which is then \
queried for its current value. Here we interpret the value as frequency of a \
sine curve. When the sine curve is recomputed, the method geom@update[geom] \
ensures that the display and other panels depending on the curve are updated.
Replace the body of the event handler method with your own calculations.\
\>", "Text",ExpressionUUID->"b522f365-f3f3-4a55-b145-bf2816860a65"],

Cell["Compute a sine curve using the current value of the slider.", \
"MathCaption",ExpressionUUID->"9b942e22-0065-465c-857c-474201587568"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"evalSinCurve", "[", 
    RowBox[{"evt_", ",", "message_"}], "]"}], "InlineInput"], 
  StyleBox[":=", "InlineInput"], 
  StyleBox["\[IndentingNewLine]", "InlineInput"], 
  StyleBox["\t", "InlineInput"], 
  RowBox[{
   StyleBox["JavaBlock", "InlineInput"], 
   StyleBox["[", "InlineInput"], 
   StyleBox["\[IndentingNewLine]", "InlineInput"], "\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     StyleBox[
      RowBox[{"{", 
       RowBox[{"sinArr", ",", "sinCurve", ",", "val"}], "}"}], "InlineInput"], 
     StyleBox[",", "InlineInput"], 
     StyleBox["\[IndentingNewLine]", "InlineInput"], "\t", 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"val", "=", 
         RowBox[{"evt", "@", 
          RowBox[{"getValue", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
       "\t", 
       RowBox[{
        RowBox[{"sinCurve", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"val", "*", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"sinArr", "=", 
         RowBox[{"ToJavaView", "[", "sinCurve", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"sinGeom", "@", 
         RowBox[{"copy", "[", 
          RowBox[{"sinArr", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"sinGeom", "@", 
         RowBox[{"update", "[", "sinGeom", "]"}]}], ";"}]}], "InlineInput"]}],
     "\[IndentingNewLine]", 
    StyleBox["\t", "InlineInput"], 
    StyleBox["]", "InlineInput"]}], 
   StyleBox["\[IndentingNewLine]", "InlineInput"], "\t", 
   StyleBox["]", "InlineInput"]}]}]], "Input",
 CellChangeTimes->{{3.636584039088395*^9, 3.6365840559536104`*^9}, {
   3.6365846771460085`*^9, 3.636584740168107*^9}, {3.63658477518445*^9, 
   3.6365848231545725`*^9}, {3.6365848594211135`*^9, 3.636584902755061*^9}, 
   3.636585039907075*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"afafb8b8-7a2e-4796-8737-a1e93b3f2e0c"],

Cell["\<\
Register a listener to receive update events whenever the slider changes its \
state.\
\>", "MathCaption",ExpressionUUID->"ae45cb4d-02e4-4869-a404-f0c4807f4861"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listenerSin", "=", 
   RowBox[{"JavaNew", "[", "\"\<jvx.math.MathUpdateListener\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listenerSin", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<update\>\"", ",", "\"\<evalSinCurve\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slider", "@", 
   RowBox[{"addUpdateListener", "[", "listenerSin", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"8bf9fe36-f565-4bb5-aeb0-8c51c9446771"],

Cell[TextData[{
 "The JavaView and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " thread must run at the same time, if a JavaView event shall be processed \
by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Therefore, ShareKernel[] must be invoked before the slider has any \
effect. After invoking ShareKernel[] change the value of the slider and see \
how the frequency of the sine curve changes."
}], "Text",
 CellChangeTimes->{{3.6365845222469563`*^9, 
  3.636584534408123*^9}},ExpressionUUID->"cf946afc-89fb-4c42-b394-\
5fb6cffa2d72"],

Cell["\<\
Share the kernel to allow further interaction with the slider and display. \
After invoking ShareKernel[] change the value of the slider and see how the \
torus changes in size.\
\>", "MathCaption",ExpressionUUID->"4f61dccc-e91a-45c4-a671-bdd2b752600c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"ee6d5d73-8fda-47d8-8e66-0f383da9b766"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.6365841069934835`*^9, 3.6365849811806297`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"61dbd85f-dba1-4939-aeb2-6a08fab80bd1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"97847e92-1121-4bb7-a416-1f1b4ed465c3"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->
  "In[199]:=",ExpressionUUID->"04e39fef-3ec5-49f4-a560-14e6d32f8514"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing the Radius of a Torus", "Subsection",ExpressionUUID->"34ed1f07-9865-42f5-98a6-2f2fb89bf304"],

Cell[TextData[{
 "In the above example the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics was always recreated and the JavaView display cleared before \
adding the new version of the graphics as a new JavaView geometry. The next \
example creates a more permanent JavaView geometry first and recalculates it \
whenever the slider sends an update event. Note, the geometry remains the \
same, only its coordinates are changed."
}], "Text",ExpressionUUID->"c5227625-3a60-4e47-9b8f-4a5c3bfd557f"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and load JavaView."
}], "MathCaption",ExpressionUUID->"eed59a8a-bf19-41f7-9007-d8c442ff72a7"],

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"522867a2-8265-48d8-b70f-fcfcd4dc2c99"]
}, Open  ]],

Cell["Create a JavaView slider and its info panel.", "MathCaption",ExpressionUUID->"339c9218-74cc-4f97-8324-c6934922b8d0"],

Cell["\<\
slider = JavaNew[\"jv.number.PuInteger\", \"Radius\"];
sliderIP = slider@getInfoPanel[];\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[22]:=",ExpressionUUID->"bfd44570-3e48-4374-b045-5f9e2583d879"],

Cell["\<\
We used the JavaView class PsMainFrame since it allows to dispose itself by \
clicking on the window dispose button (since the Java class java.awt.Frame \
would not react on such a click).\
\>", "Text",ExpressionUUID->"32ebcf96-4264-40f4-b810-2be5b9827e22"],

Cell["Show the slider panel in a new frame.", "MathCaption",ExpressionUUID->"655c47a2-5818-4038-af20-1b41bde128b1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"frame", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.object.PsMainFrame\>\"", ",", "\"\<Slider Frame\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "@", 
   RowBox[{"add", "[", 
    RowBox[{"\"\<Center\>\"", ",", "sliderIP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "@", 
   RowBox[{"setSize", "[", 
    RowBox[{"400", ",", "70"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JavaShow", "[", "frame", "]"}], ";"}]}], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"7a9ad265-e30a-41c4-b0e4-982486bf57a4"],

Cell["\<\
When this example is executed right after the sine-curve example then the \
display might still be in xy-projection mode. Here we reinitialize the \
display.\
\>", "Text",
 CellChangeTimes->{{3.636585265417303*^9, 3.6365852695482845`*^9}, {
  3.6365880777944856`*^9, 
  3.636588086997738*^9}},ExpressionUUID->"3626ef04-969a-4a60-b92b-\
3cd5575e4e17"],

Cell["Reinitialize the display.", "MathCaption",
 CellChangeTimes->{{3.6365881079984045`*^9, 
  3.63658811302978*^9}},ExpressionUUID->"3ac940df-ae37-45d1-a21b-\
65755bbe45d2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"init", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"setLightingModel", "[", "PvLightIf`MODELULIGHT", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellChangeTimes->{{3.63658552873602*^9, 3.636585535142434*^9}, {
  3.6365867236786284`*^9, 3.6365867241629143`*^9}, {3.636587488000486*^9, 
  3.6365874951726885`*^9}, {3.6365876529339457`*^9, 3.6365876732627993`*^9}, {
  3.6365879633376412`*^9, 3.63658799665108*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"e91adef8-62a5-4714-a116-268a6518dcb7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.636587742967905*^9, 3.636587788216465*^9, 
  3.636587981947509*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"2adcd35d-fbf9-4113-9df7-62386e503eba"]
}, Open  ]],

Cell["Create a sample, permanent geometry and show it.", "MathCaption",ExpressionUUID->"59ac8598-55be-45ea-af5f-dd35b89248b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", " ", "=", " ", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Dynamic Torus\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"20", ",", "20", ",", "2.", ",", "1."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "geom", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"fit", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"update", "[", "disp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.636587800343986*^9, 3.636587810359931*^9}, {
  3.636588132854437*^9, 3.6365881477923107`*^9}, {3.6365881797301445`*^9, 
  3.636588183198903*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"63eeb6ce-237f-428a-8643-995217e4df54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject31404503576084481]], "Output",
 CellChangeTimes->{
  3.6365851112570252`*^9, 3.6365851880184855`*^9, 3.6365855152354593`*^9, 
   3.6365856237396865`*^9, 3.636586738289936*^9, 3.636586869660719*^9, 
   3.636586985866872*^9, 3.6365877517963104`*^9, 3.636587791029071*^9, {
   3.636588125733287*^9, 3.636588149557962*^9}, 3.636588184370694*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"cc0576fe-f166-4e1e-9529-4781f1ffbd6c"]
}, Open  ]],

Cell["Possibly switch display to 3D perspective mode.", "Subsubsection",ExpressionUUID->"1f7ca2e2-21c7-438a-aa5e-ff13ea3323d9"],

Cell["\<\
The following function is an event handler and will be called a listener when \
the slider is modified. The argument evt is the slider object which is then \
queried for its current value. Here we interpret the value as radius of a \
torus geometry. When the torus is recomputed, the method geom@update[geom] \
ensures that the display and other panels depending on the torus are updated.
Replace the body of the event handler method with your own calculations.\
\>", "Text",ExpressionUUID->"20c8cdc9-8062-4c88-bae0-f047ec5c09bf"],

Cell["Compute a torus using the current value of the slider.", "MathCaption",ExpressionUUID->"eb417807-59bd-4e97-b5d3-3cced3922a39"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"evalTorus", "[", 
    RowBox[{"evt_", ",", "message_"}], "]"}], "InlineInput"], 
  StyleBox[":=", "InlineInput"], 
  StyleBox["\[IndentingNewLine]", "InlineInput"], 
  StyleBox["\t", "InlineInput"], 
  RowBox[{
   StyleBox["JavaBlock", "InlineInput"], 
   StyleBox["[", "InlineInput"], 
   StyleBox["\[IndentingNewLine]", "InlineInput"], "\t\t", 
   RowBox[{
    StyleBox[
     RowBox[{"val", "=", 
      RowBox[{"evt", "@", 
       RowBox[{"getValue", "[", "]"}]}]}], "InlineInput"], 
    StyleBox[";", "InlineInput"], 
    StyleBox["\[IndentingNewLine]", "InlineInput"], "\t\t", 
    RowBox[{"geom", "@", 
     RowBox[{"computeTorus", "[", 
      RowBox[{"20", ",", "20", ",", "val", ",", "1."}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{"geom", "@", 
     RowBox[{"update", "[", "geom", "]"}]}], ";"}], "\[IndentingNewLine]", 
   StyleBox["\t", "InlineInput"], 
   StyleBox["]", "InlineInput"]}]}]], "Input",
 CellChangeTimes->{
  3.6365854421868377`*^9, {3.636588189247347*^9, 3.636588191044058*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"9c8e4275-864d-4eee-9cdb-b4047fa11582"],

Cell["\<\
Register a listener to receive update events whenever the slider changes its \
state.\
\>", "MathCaption",ExpressionUUID->"388b5f7d-2f43-4c2b-892b-186f5093040c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listenerTorus", "=", 
   RowBox[{"JavaNew", "[", "\"\<jvx.math.MathUpdateListener\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listenerTorus", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<update\>\"", ",", "\"\<evalTorus\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"slider", "@", 
   RowBox[{"addUpdateListener", "[", "listenerTorus", "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"72143f8b-2746-4933-b85a-e635d246e08e"],

Cell[TextData[{
 "The JavaView and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " thread must run at the same time, if a JavaView event shall be processed \
by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Therefore, ShareKernel[] must be invoked before the slider has any \
effect. After invoking ShareKernel[] change the value of the slider and see \
how the torus changes in size."
}], "Text",ExpressionUUID->"ebf622fc-3482-4d35-b11e-69f2b01f6b54"],

Cell["\<\
Start sharing the kernel. After invoking ShareKernel[] change the value of \
the slider and see how the torus changes in size.\
\>", "MathCaption",ExpressionUUID->"1dd91a8a-8cc7-4be2-a52d-41d4b6a5e185"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->
  "In[167]:=",ExpressionUUID->"526c002f-6987-455f-b36c-9000f9410166"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.636585470765588*^9, 3.636588166760765*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"390aabbc-5aad-4607-b6a1-2af1e75512cd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"9c48ad23-7838-4765-be14-dc07a4d30321"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"a044f8fc-768a-4379-a7be-9431b585c103"]
}, Open  ]]
},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{895.875, 708.375},
WindowMargins->{{Automatic, 0.375}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}}},
CellLabelAutoDelete->False,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"50963bed-779b-4df2-83a1-70a2b1846485"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 536, 16, 95, "Chapter",ExpressionUUID->"d303efac-a076-47f3-87ec-fdf1b1af42bf",
 CellGroupingRules->"SectionGrouping"],
Cell[1097, 38, 366, 7, 26, "Text",ExpressionUUID->"53e780c1-dc9c-451d-ab2c-a5dd8e40ee9b"],
Cell[CellGroupData[{
Cell[1488, 49, 102, 0, 28, "Subsection",ExpressionUUID->"f0e4c9d5-709c-416f-bc82-88a1291c41eb"],
Cell[1593, 51, 410, 8, 28, "Text",ExpressionUUID->"7c46a1e3-6ee8-446d-8fb9-b7e5d512d858"],
Cell[2006, 61, 189, 5, 30, "MathCaption",ExpressionUUID->"e7d047cf-7fc1-4b16-a1ea-694cd34ccb27"],
Cell[CellGroupData[{
Cell[2220, 70, 233, 5, 32, "Input",ExpressionUUID->"a1bf2ffa-d4ce-47d5-a830-eb284c0905fc"],
Cell[2456, 77, 509, 11, 17, "Message",ExpressionUUID->"5af04305-1170-4d95-9122-323bafb21c72"],
Cell[2968, 90, 258, 5, 16, "Print",ExpressionUUID->"eb20c17f-8273-449f-b29a-4a6761cbe8a3"],
Cell[3229, 97, 255, 5, 16, "Print",ExpressionUUID->"4b8c69d6-c739-4c9f-8756-365c9884a541"]
}, Open  ]],
Cell[3499, 105, 122, 0, 30, "MathCaption",ExpressionUUID->"4b1ff939-9f43-4196-b375-6c1464f783db"],
Cell[3624, 107, 443, 12, 32, "Input",ExpressionUUID->"4703e87d-9ffb-4f95-bd65-4a3116f00dff"],
Cell[4070, 121, 267, 4, 18, "Text",ExpressionUUID->"38e6f08e-f1ee-4fea-a454-c5e870018c78"],
Cell[4340, 127, 115, 0, 30, "MathCaption",ExpressionUUID->"85e6b407-bbb0-44b8-b23f-002f84b9c4b7"],
Cell[4458, 129, 590, 16, 57, "Input",ExpressionUUID->"8539aad2-aa5a-46bb-b072-148d16aff4cc"],
Cell[5051, 147, 178, 3, 18, "Text",ExpressionUUID->"91140e1b-3415-42a2-b638-0c85004b2643"],
Cell[CellGroupData[{
Cell[5254, 154, 478, 11, 20, "Input",ExpressionUUID->"23d006bc-3537-45aa-8fc7-ccf630555a26"],
Cell[CellGroupData[{
Cell[5757, 169, 367, 7, 20, "Input",ExpressionUUID->"9f2eb567-6399-483c-b57c-9b28fad09f34"],
Cell[6127, 178, 1439, 24, 284, "Message",ExpressionUUID->"d9672d31-8a7d-40b4-83b6-a5dc35a74a7c"]
}, Open  ]]
}, Open  ]],
Cell[7593, 206, 544, 7, 48, "Text",ExpressionUUID->"b522f365-f3f3-4a55-b145-bf2816860a65"],
Cell[8140, 215, 139, 1, 30, "MathCaption",ExpressionUUID->"9b942e22-0065-465c-857c-474201587568"],
Cell[8282, 218, 2181, 57, 133, "Input",ExpressionUUID->"afafb8b8-7a2e-4796-8737-a1e93b3f2e0c"],
Cell[10466, 277, 171, 3, 30, "MathCaption",ExpressionUUID->"ae45cb4d-02e4-4869-a404-f0c4807f4861"],
Cell[10640, 282, 534, 13, 44, "Input",ExpressionUUID->"8bf9fe36-f565-4bb5-aeb0-8c51c9446771"],
Cell[11177, 297, 556, 14, 28, "Text",ExpressionUUID->"cf946afc-89fb-4c42-b394-5fb6cffa2d72"],
Cell[11736, 313, 263, 4, 30, "MathCaption",ExpressionUUID->"4f61dccc-e91a-45c4-a671-bdd2b752600c"],
Cell[CellGroupData[{
Cell[12024, 321, 138, 2, 20, "Input",ExpressionUUID->"ee6d5d73-8fda-47d8-8e66-0f383da9b766"],
Cell[12165, 325, 175, 2, 19, "Output",ExpressionUUID->"61dbd85f-dba1-4939-aeb2-6a08fab80bd1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12389, 333, 359, 9, 30, "MathCaption",ExpressionUUID->"97847e92-1121-4bb7-a416-1f1b4ed465c3"],
Cell[12751, 344, 144, 3, 20, "Input",ExpressionUUID->"04e39fef-3ec5-49f4-a560-14e6d32f8514"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12932, 352, 107, 0, 28, "Subsection",ExpressionUUID->"34ed1f07-9865-42f5-98a6-2f2fb89bf304"],
Cell[13042, 354, 510, 9, 28, "Text",ExpressionUUID->"c5227625-3a60-4e47-9b8f-4a5c3bfd557f"],
Cell[CellGroupData[{
Cell[13577, 367, 189, 5, 30, "MathCaption",ExpressionUUID->"eed59a8a-bf19-41f7-9007-d8c442ff72a7"],
Cell[13769, 374, 234, 5, 32, "Input",ExpressionUUID->"522867a2-8265-48d8-b70f-fcfcd4dc2c99"]
}, Open  ]],
Cell[14018, 382, 122, 0, 30, "MathCaption",ExpressionUUID->"339c9218-74cc-4f97-8324-c6934922b8d0"],
Cell[14143, 384, 248, 6, 33, "Input",ExpressionUUID->"bfd44570-3e48-4374-b045-5f9e2583d879"],
Cell[14394, 392, 267, 4, 18, "Text",ExpressionUUID->"32ebcf96-4264-40f4-b810-2be5b9827e22"],
Cell[14664, 398, 115, 0, 30, "MathCaption",ExpressionUUID->"655c47a2-5818-4038-af20-1b41bde128b1"],
Cell[14782, 400, 634, 17, 57, "Input",ExpressionUUID->"7a9ad265-e30a-41c4-b0e4-982486bf57a4"],
Cell[15419, 419, 360, 8, 28, "Text",ExpressionUUID->"3626ef04-969a-4a60-b92b-3cd5575e4e17"],
Cell[15782, 429, 175, 3, 28, "MathCaption",ExpressionUUID->"3ac940df-ae37-45d1-a21b-65755bbe45d2"],
Cell[CellGroupData[{
Cell[15982, 436, 812, 19, 57, "Input",ExpressionUUID->"e91adef8-62a5-4714-a116-268a6518dcb7"],
Cell[16797, 457, 203, 4, 16, "Output",ExpressionUUID->"2adcd35d-fbf9-4113-9df7-62386e503eba"]
}, Open  ]],
Cell[17015, 464, 126, 0, 28, "MathCaption",ExpressionUUID->"59ac8598-55be-45ea-af5f-dd35b89248b8"],
Cell[CellGroupData[{
Cell[17166, 468, 1021, 28, 83, "Input",ExpressionUUID->"63eeb6ce-237f-428a-8643-995217e4df54"],
Cell[18190, 498, 638, 13, 16, "Output",ExpressionUUID->"cc0576fe-f166-4e1e-9529-4781f1ffbd6c"]
}, Open  ]],
Cell[18843, 514, 127, 0, 24, "Subsubsection",ExpressionUUID->"1f7ca2e2-21c7-438a-aa5e-ff13ea3323d9"],
Cell[18973, 516, 540, 7, 52, "Text",ExpressionUUID->"20c8cdc9-8062-4c88-bae0-f047ec5c09bf"],
Cell[19516, 525, 132, 0, 28, "MathCaption",ExpressionUUID->"eb417807-59bd-4e97-b5d3-3cced3922a39"],
Cell[19651, 527, 1157, 30, 84, "Input",ExpressionUUID->"9c8e4275-864d-4eee-9cdb-b4047fa11582"],
Cell[20811, 559, 171, 3, 28, "MathCaption",ExpressionUUID->"388b5f7d-2f43-4c2b-892b-186f5093040c"],
Cell[20985, 564, 544, 15, 45, "Input",ExpressionUUID->"72143f8b-2746-4933-b85a-e635d246e08e"],
Cell[21532, 581, 469, 11, 39, "Text",ExpressionUUID->"ebf622fc-3482-4d35-b11e-69f2b01f6b54"],
Cell[22004, 594, 212, 3, 28, "MathCaption",ExpressionUUID->"1dd91a8a-8cc7-4be2-a52d-41d4b6a5e185"],
Cell[CellGroupData[{
Cell[22241, 601, 142, 3, 18, "Input",ExpressionUUID->"526c002f-6987-455f-b36c-9000f9410166"],
Cell[22386, 606, 175, 3, 16, "Output",ExpressionUUID->"390aabbc-5aad-4607-b6a1-2af1e75512cd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22610, 615, 359, 9, 40, "MathCaption",ExpressionUUID->"9c48ad23-7838-4765-be14-dc07a4d30321"],
Cell[22972, 626, 144, 3, 18, "Input",ExpressionUUID->"a044f8fc-768a-4379-a7be-9431b585c103"]
}, Open  ]]
}
]
*)

