(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16510,        445]
NotebookOptionsPosition[     11841,        357]
NotebookOutlinePosition[     13201,        403]
CellTagsIndexPosition[     13158,        400]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Timer Events from ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 "\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(v1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{3.7937699795422163`*^9},
 TextAlignment->Left,ExpressionUUID->"8363afd9-83e4-4a72-8a08-345b3c94a4e0"],

Cell[TextData[{
 "In this notebook ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " catches timer events issued from the JavaView animation class to recompute \
the position of a satellite orbiting around a torus."
}], "Text",ExpressionUUID->"e0ed0878-3362-47a3-a247-5ed89f0f88e0"],

Cell[TextData[{
 "To check performance of the event handling we provide two alternative \
methods to let the satellite move.\n1. A simple loop in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is used to trigger the event handling routine directly without any event \
handling in between.\n2. The standard event handling mechanism. The animation \
may be started either by button press in animation panel of JavaView, or in \
share-kernel mode by issuing a command from this notebook. See below."
}], "Text",
 CellChangeTimes->{
  3.793770079223363*^9},ExpressionUUID->"ecbe8aaa-81da-4768-9feb-\
862986f127e6"],

Cell["\<\
Usage: First execute the upper command group with the outer bracket. Then \
scroll down the notebook and execute the commands following the upper outer \
bracket successively.\
\>", "Text",ExpressionUUID->"8f7024b9-4eca-4ad2-9740-35a3c80fd5a6"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and load JavaView."
}], "MathCaption",ExpressionUUID->"433fca90-ba7e-4316-b82b-17955e38a51d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"451d28a5-5606-4a54-ae98-e93f403c6a3e"],

Cell[BoxData[
 TemplateBox[{
  "General", "obs", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"WorldPlot`\\\\\\\"\\\"}]\\) has been \
superseded by \\!\\(\\*RowBox[{\\\"GeoGraphics\\\"}]\\), and is now obsolete. \
It will not be included in future versions of the Wolfram Language.\"", 2, 1, 
   1, 33085238335048447889, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7937816827982473`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"813c42c7-3377-46a6-b543-e3465dd688bc"],

Cell[BoxData["\<\"JavaView`RunThrough` v3.0.3\"\>"], "Print",
 CellChangeTimes->{3.7937816831263294`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5a39b763-8f6a-48f8-ac7f-769a4e2d5baf"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{3.7937816831799684`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"37b10bbf-fbec-4f9f-8f9a-c61a2d77a3d0"]
}, Open  ]],

Cell["Create an empty geometry to become the world.", "MathCaption",ExpressionUUID->"177a0297-7732-43c6-b8b0-d99317c37fa1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"geom", " ", "=", " ", 
    RowBox[{"JavaNew", "[", 
     RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"9f55922f-14d1-4bde-b0be-d59232d89efe"],

Cell["\<\
Compute a sample torus geometry and register it inside the display.\
\>", "MathCaption",ExpressionUUID->"6bff570e-a2c3-448a-8c6c-15f9b0d87014"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"innerRadius", " ", "=", "2."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tubeRadius", "=", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"20", ",", "15", ",", "innerRadius", ",", "tubeRadius"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Torus World\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showTransparency", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["JavaView",
    FontSlant->"Plain"], "[", "geom", "]"}], ";"}]}], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"65f39428-7b49-4fc9-a7dc-29843062dbc5"],

Cell["\<\
Get the active JavaView 3d-display to be able to register the satellite \
additionally to the torus geometry.\
\>", "MathCaption",ExpressionUUID->"41d8d96e-52fb-4344-abe1-aadccf64476a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"62231aa7-5854-4ca3-8cdf-ca82a1f5bb2f"],

Cell["Create another empty geometry to become a satellite.", "MathCaption",ExpressionUUID->"cbf64b75-be5f-48ea-a934-923f5a79b976"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sat", " ", "=", " ", 
   RowBox[{"JavaNew", "[", "\"\<jv.geom.PgElementSet\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"be2936be-db21-49a4-aeb7-a0b55d1ab700"],

Cell["Compute the satellite and register it inside the display.", \
"MathCaption",ExpressionUUID->"af59f433-c351-4049-8968-d576174f6fee"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadClass", "[", "\"\<jvx.geom.PwPlatonic\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PwPlatonic`getSolid", "[", 
   RowBox[{"sat", ",", "PwPlatonic`DODECAHEDRON"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"setName", "[", "\"\<Satellite\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sat", "@", 
  RowBox[{"setGlobalElementColor", "[", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<java.awt.Color\>\"", ",", " ", "255", ",", "150", ",", "0"}],
     "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"scale", "[", 
    RowBox[{"1.", "/", "5."}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"showVertexNormals", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"showVertices", "[", "False", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", "sat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"update", "[", "sat", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"e7a8a934-2e20-4a58-853b-47e9c70c5387"],

Cell["\<\
Event handler command invoked from JavaView upon timer events. This method \
calls setTime[time] to do the work.\
\>", "MathCaption",ExpressionUUID->"652c6e2e-1aad-4860-b85f-b3584e922500"],

Cell["\<\
setTime[evt_,message_] :=
\tJavaBlock[
\t\tsetTime[N[evt]];
\t\tReleaseObject[evt]
\t]
\t
(* Keep this variable outside to avoid frequent allocations. *)
center = JavaNew[\"jv.vecmath.PdVector\",3];
(* Initial number of time steps per flight. (Pending) Should be overwritten \
by settings in the animation panel. *)
numTics = 100;
(* This function will be called upon timer events, or it may be invoked \
directly from Mathematica, see below. *)
setTime[time_] :=
\tJavaBlock[
\t\tir = innerRadius;
\t\ttr = tubeRadius;
\t\theight = tubeRadius/3.; (* Height of Satellite over Torus. *)
\t\tnumUWindings = 1;
\t\tnumZWindings = 13;
\t\tu = time*2.*Pi*numUWindings/(numTics-1.);
\t\tv = time*2.*Pi*numZWindings/(numTics-1.);
\t\tcenter@set[
\t\t\tN[Cos[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[Sin[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[(tr+tubeRadius/3.)*Sin[v]]];
\t\tPwPlatonic`setSolid[sat,PwPlatonic`DODECAHEDRON];
\t\tsat@scale[1./5.];
\t\tsat@translate[center];
\t\tsat@update[Null];
\t]\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[27]:=",ExpressionUUID->"85cf53f3-eccc-49d7-8ce8-bdd50e668391"],

Cell[TextData[{
 "The animation panel often appears behind the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook and must be brought to font manually."
}], "Text",ExpressionUUID->"faaba4d3-8967-43ad-bd96-458ce29cea9f"],

Cell["Register a listener of timer events.", "MathCaption",ExpressionUUID->"2c4215f4-5e80-4548-9996-a2497132e340"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listener", "=", 
   RowBox[{"JavaNew", "[", "\"\<jvx.math.MathTimerListener\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<setTime\>\"", ",", "\"\<setTime\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anim", " ", "=", " ", 
   RowBox[{"JavaNew", "[", "\"\<jv.anim.PsAnimation\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anim", "@", 
   RowBox[{"setName", "[", "\"\<Satellite Animation\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anim", "@", 
   RowBox[{"addTimeListener", "[", "listener", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JavaShow", "[", 
   RowBox[{"anim", "@", 
    RowBox[{"getAnimationPanel", "[", "]"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"9c2676c1-a7ba-4ee7-b54e-72e9bf7b89c6"],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display.\
\>", "MathCaption",ExpressionUUID->"95cba39c-211b-406a-9061-3db8986014c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->
  "(sharing) \
In[161]:=",ExpressionUUID->"274f34da-7b73-4886-ba35-215550049a7d"],

Cell[BoxData["7"], "Output",
 CellLabel->
  "Out[161]=",ExpressionUUID->"9c5c3df4-8f4d-4e3f-91d0-89862c94f227"]
}, Open  ]],

Cell["\<\
When sharing the kernel we can control the animation from this notebook.\
\>", "MathCaption",ExpressionUUID->"db491fe6-2ca4-4430-9ed2-3fd4977ca716"],

Cell[BoxData[
 RowBox[{"anim", "@", 
  RowBox[{"start", "[", "]"}]}]], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"9417c5e1-8fb0-45d6-a7c1-48416e531139"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"anim", "@", 
  RowBox[{"stop", "[", "]"}]}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"1dee2794-c885-4e6b-b3b0-991979c17369"],

Cell[CellGroupData[{

Cell["\<\
It is also possible to use a direct invocation of the event handler from a \
Mathematica loop.\
\>", "MathCaption",ExpressionUUID->"6c0f392b-706d-4515-9bd2-8c12054b348b"],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "0."}], ",", 
   RowBox[{"i", "<", "numTics"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"setTime", "[", "i", "]"}]}], "]"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"ba6bd21f-3070-48ce-8ee4-40b16cba59f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"c71899d0-6c03-456e-8d3f-2919caf1ef29"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->
  "(sharing) \
In[169]:=",ExpressionUUID->"fb742855-bd6a-4377-b127-2d84ad619c14"]
}, Open  ]]
},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{813.75, 708.375},
WindowMargins->{{Automatic, -187.125}, {-2.625, Automatic}},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, 56.6875}}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"75075929-7270-455e-9f58-2a41b9a26454"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 483, 15, 95, "Chapter",ExpressionUUID->"8363afd9-83e4-4a72-8a08-345b3c94a4e0",
 CellGroupingRules->"SectionGrouping"],
Cell[1044, 37, 287, 6, 16, "Text",ExpressionUUID->"e0ed0878-3362-47a3-a247-5ed89f0f88e0"],
Cell[1334, 45, 618, 12, 56, "Text",ExpressionUUID->"ecbe8aaa-81da-4768-9feb-862986f127e6"],
Cell[1955, 59, 254, 4, 18, "Text",ExpressionUUID->"8f7024b9-4eca-4ad2-9740-35a3c80fd5a6"],
Cell[CellGroupData[{
Cell[2234, 67, 189, 5, 30, "MathCaption",ExpressionUUID->"433fca90-ba7e-4316-b82b-17955e38a51d"],
Cell[CellGroupData[{
Cell[2448, 76, 233, 5, 32, "Input",ExpressionUUID->"451d28a5-5606-4a54-ae98-e93f403c6a3e"],
Cell[2684, 83, 509, 11, 17, "Message",ExpressionUUID->"813c42c7-3377-46a6-b543-e3465dd688bc"],
Cell[3196, 96, 209, 4, 16, "Print",ExpressionUUID->"5a39b763-8f6a-48f8-ac7f-769a4e2d5baf"],
Cell[3408, 102, 204, 4, 16, "Print",ExpressionUUID->"37b10bbf-fbec-4f9f-8f9a-c61a2d77a3d0"]
}, Open  ]],
Cell[3627, 109, 123, 0, 30, "MathCaption",ExpressionUUID->"177a0297-7732-43c6-b8b0-d99317c37fa1"],
Cell[3753, 111, 269, 7, 20, "Input",ExpressionUUID->"9f55922f-14d1-4bde-b0be-d59232d89efe"],
Cell[4025, 120, 153, 2, 30, "MathCaption",ExpressionUUID->"6bff570e-a2c3-448a-8c6c-15f9b0d87014"],
Cell[4181, 124, 791, 22, 82, "Input",ExpressionUUID->"65f39428-7b49-4fc9-a7dc-29843062dbc5"],
Cell[4975, 148, 195, 3, 30, "MathCaption",ExpressionUUID->"41d8d96e-52fb-4344-abe1-aadccf64476a"],
Cell[5173, 153, 212, 5, 20, "Input",ExpressionUUID->"62231aa7-5854-4ca3-8cdf-ca82a1f5bb2f"],
Cell[5388, 160, 130, 0, 30, "MathCaption",ExpressionUUID->"cbf64b75-be5f-48ea-a934-923f5a79b976"],
Cell[5521, 162, 223, 5, 20, "Input",ExpressionUUID->"be2936be-db21-49a4-aeb7-a0b55d1ab700"],
Cell[5747, 169, 137, 1, 30, "MathCaption",ExpressionUUID->"af59f433-c351-4049-8968-d576174f6fee"],
Cell[5887, 172, 1257, 35, 120, "Input",ExpressionUUID->"e7a8a934-2e20-4a58-853b-47e9c70c5387"],
Cell[7147, 209, 198, 3, 30, "MathCaption",ExpressionUUID->"652c6e2e-1aad-4860-b85f-b3584e922500"],
Cell[7348, 214, 1160, 35, 404, "Input",ExpressionUUID->"85cf53f3-eccc-49d7-8ce8-bdd50e668391"],
Cell[8511, 251, 232, 5, 18, "Text",ExpressionUUID->"faaba4d3-8967-43ad-bd96-458ce29cea9f"],
Cell[8746, 258, 114, 0, 30, "MathCaption",ExpressionUUID->"2c4215f4-5e80-4548-9996-a2497132e340"],
Cell[8863, 260, 947, 26, 82, "Input",ExpressionUUID->"9c2676c1-a7ba-4ee7-b54e-72e9bf7b89c6"],
Cell[9813, 288, 162, 2, 30, "MathCaption",ExpressionUUID->"95cba39c-211b-406a-9061-3db8986014c2"],
Cell[CellGroupData[{
Cell[10000, 294, 154, 4, 20, "Input",ExpressionUUID->"274f34da-7b73-4886-ba35-215550049a7d"],
Cell[10157, 300, 111, 2, 19, "Output",ExpressionUUID->"9c5c3df4-8f4d-4e3f-91d0-89862c94f227"]
}, Open  ]],
Cell[10283, 305, 158, 2, 30, "MathCaption",ExpressionUUID->"db491fe6-2ca4-4430-9ed2-3fd4977ca716"],
Cell[10444, 309, 158, 3, 20, "Input",ExpressionUUID->"9417c5e1-8fb0-45d6-a7c1-48416e531139"]
}, Open  ]],
Cell[10617, 315, 157, 3, 20, "Input",ExpressionUUID->"1dee2794-c885-4e6b-b3b0-991979c17369"],
Cell[CellGroupData[{
Cell[10799, 322, 180, 3, 30, "MathCaption",ExpressionUUID->"6c0f392b-706d-4515-9bd2-8c12054b348b"],
Cell[10982, 327, 288, 7, 20, "Input",ExpressionUUID->"ba6bd21f-3070-48ce-8ee4-40b16cba59f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11307, 339, 359, 9, 30, "MathCaption",ExpressionUUID->"c71899d0-6c03-456e-8d3f-2919caf1ef29"],
Cell[11669, 350, 156, 4, 20, "Input",ExpressionUUID->"fb742855-bd6a-4377-b127-2d84ad619c14"]
}, Open  ]]
}
]
*)

