(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    271392,       6912]
NotebookOptionsPosition[    231344,       6344]
NotebookOutlinePosition[    231856,       6364]
CellTagsIndexPosition[    231813,       6361]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["JavaView\[CloseCurlyQuote]JLink",
  FontSlant->"Italic"],
 " - Overview"
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{{3.794948055202882*^9, 3.794948075742371*^9}},
 TextAlignment->Center,
 TextJustification->0,ExpressionUUID->"7cee7c83-ad2a-4135-9baa-90a50a6e88ea"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\nKonrad Polthier\n2020-04-03, v3.4.2", "SB"]],
 CellChangeTimes->{{3.6363884470141587`*^9, 3.6363884563891687`*^9}, 
   3.636546616292836*^9, {3.7932563846147366`*^9, 3.7932563945730143`*^9}, {
   3.7935217060219784`*^9, 3.793521708870801*^9}, {3.7936122013615556`*^9, 
   3.793612207818183*^9}, {3.7943470299961696`*^9, 3.7943470311817617`*^9}, {
   3.794855997280572*^9, 3.794856002791869*^9}, {3.7948560957844105`*^9, 
   3.794856096554339*^9}, {3.7949401365398326`*^9, 3.794940141019806*^9}},
 TextAlignment->Center,ExpressionUUID->"697e8632-b9a3-4e25-9994-ed9720a47e71"],

Cell[TextData[{
 "\n\n\nCopyright (C) 2001-2020 by Konrad Polthier. All rights reserved.\n",
 StyleBox["Mathematica", "TI"],
 " and ",
 StyleBox["J/Link", "TI"],
 " are trademarks of Wolfram Research.\nJava and JDK are trademarks of \
Oracle.\nUse of the software is bound by the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " license agreement available from the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " website ",
 ButtonBox["www.javaview.de",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.javaview.de"], None}],
 ".\nLatest revision: [2020-04-03, v3.4.2]. Compatibility with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 12.1"
}], "Text",
 CellChangeTimes->{{3.63638843792035*^9, 3.636388437967064*^9}, {
  3.6363884762387123`*^9, 3.636388505989788*^9}, {3.6363989122175865`*^9, 
  3.6363989224009104`*^9}, {3.6366385087660046`*^9, 3.6366385284543295`*^9}, {
  3.7932563485725703`*^9, 3.793256348634606*^9}, {3.7936152408337574`*^9, 
  3.79361524178312*^9}, {3.7943470379585886`*^9, 3.7943470507774076`*^9}, {
  3.7948560083207593`*^9, 3.7948560132727313`*^9}, {3.794856079409357*^9, 
  3.794856090319687*^9}, {3.7949408804921007`*^9, 
  3.7949408878163834`*^9}},ExpressionUUID->"41a9aaaa-25f8-4b57-bc19-\
3ab025c81622"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Section",ExpressionUUID->"0dfe02cf-a865-4093-9c52-c9253dccfbc7"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is an interactive geometry viewer and a visualization toolkit. Its main \
focus is to supply visualization tools simultaneously for local applications \
as well as interactive online publications. These notes describe how to use ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " as an integrated viewer for ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "graphics, as an online publication tool, and as a geometric toolbox to \
enhance ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " can be used either as an external program using the JavaView`RunThrough` \
package, or fully integrated with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " using the JavaView`JLink` package."
}], "Text",
 CellChangeTimes->{
  3.636564222468127*^9},ExpressionUUID->"ad8c6b3b-c7d8-4705-b9bf-\
519dd6249b94"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is designed for end-users and developers. End-users may work with the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " control panels and dialogs, or steer ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " from ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "by calling documented commands from a notebook. Developers may additionally \
access the full functionality of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " user interface and algorithms via the open programming API of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " either from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or from Java. Using ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires little familiarity with Java like the notion of classes and \
methods."
}], "Text",
 CellChangeTimes->{{3.794941941698418*^9, 
  3.794941942450529*^9}},ExpressionUUID->"9bcd19d0-23af-4b68-bb61-\
be2dff7f9200"],

Cell[BoxData[
 FormBox[
  FrameBox[GridBox[{
     {"\<\"\[FilledSmallSquare]  View Mathematica graphics in an interactive \
3D JavaView display \"\>"},
     {
      RowBox[{
       RowBox[{"\[FilledSmallSquare]", "  ", "Apply", " ", "transparency"}], 
       ",", " ", 
       RowBox[{
       "smooth", " ", "shading", " ", "and", " ", "texture", " ", "images", 
        " ", "to", " ", "Mathematica", " ", "graphics"}]}]},
     {"\<\"\[FilledSmallSquare]  Write Mathematica programs that use pick \
information from the JavaView display\"\>"},
     {"\<\"\[FilledSmallSquare]  Export Mathematica graphics to a variety of \
file formats (e.g. VRML, Maple, JavaView JVX, STL, OBJ, ...) \"\>"},
     {"\<\"\[FilledSmallSquare]  Apply advanced geometry algorithms and \
visualization operations on Mathematica graphics\"\>"},
     {"\<\"\[FilledSmallSquare]  Create webpages and webMathematica services \
with interactive Mathematica graphics \"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}]], TraditionalForm]], "Text",
 PageWidth->WindowWidth,
 CellMargins->{{Inherited, Inherited}, {2, Inherited}},
 CellFrameMargins->8,
 CellChangeTimes->{{3.6363889295932503`*^9, 
  3.636388938749668*^9}},ExpressionUUID->"371a8e70-a042-4046-852f-\
f60e97fcb466"],

Cell[TextData[{
 "Some uses for ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Caption",ExpressionUUID->"f4f23a8d-f5e4-4958-82dc-781c02a8da93"],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is an add-on package of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " developed by Todd Gayley allowing realtime interaction between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java programs. It is a great achievement for the seamless integration \
of mathematical software, and I am very excited about the diversity of its \
applications."
}], "Text",
 CellChangeTimes->{3.6365638446927547`*^9, 
  3.7932613640165157`*^9},ExpressionUUID->"3a2e9758-1b3a-4439-81ae-\
6296674e40ed"],

Cell[TextData[{
 "The two ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " packages JavaView`RunThrough` and JavaView`JLink` extend ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with interactive 3D visualization functionality and the integration of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics into online publications. The main focus here lies on the package \
JavaView`JLink` which provides simple commands for viewing and modifying ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics by making use of the 2-way connection between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " provided by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". The simpler package JavaView`RunThrough` restricts to utility commands to \
export and view ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics in the classical way via files; it does not need a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " installation."
}], "Text",
 CellChangeTimes->{{3.6365642584433193`*^9, 
  3.636564262865334*^9}},ExpressionUUID->"d10a9b1b-23d4-4ae6-933c-\
49ca2df4bd0b"],

Cell[TextData[{
 "Note, the commands in both packages are provided as a convenience to \
simplify calling ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". For example, experts may directly access the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " classes and methods using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " as described in more detail in the notebook ",
 ButtonBox["Applications.nb",
  BaseStyle->"Hyperlink",
  ButtonData:>{"Applications.nb", None}],
 "."
}], "Text",
 CellChangeTimes->{
  3.6365638540679803`*^9},ExpressionUUID->"1f8f8ffd-1a39-4b99-a1e2-\
9ed510d8a24a"],

Cell[TextData[{
 "These tutorial paragraphs are user's notes and provide first steps to use ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " as 3D viewer of ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "graphics. The basic ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " keyboard shortcuts are listed at the end of this document."
}], "Text",ExpressionUUID->"0a457766-f3c6-46bf-b10c-fd2de575920d"]
}, Closed]],

Cell[CellGroupData[{

Cell["Requirements", "Section",ExpressionUUID->"e930f944-7a79-4cc8-8cdc-fb1ac236faf7"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is an add-on package of ",
 StyleBox["Mathematica", "TI"],
 " which is available from Wolfram Research and which is compatible with all \
platforms on which ",
 StyleBox["Mathematica", "TI"],
 " is available. ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " has the same requirements as ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{
  3.6365639253591876`*^9, 3.6365639782203555`*^9, 3.636564269209268*^9, {
   3.7936125234077225`*^9, 3.79361252368072*^9}, 
   3.7949410141452026`*^9},ExpressionUUID->"d0f1d15e-cbc7-4f5a-bde7-\
ee9437965ec4"],

Cell[TextData[{
 "Requirements for ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "MathCaption",ExpressionUUID->"bb6ac4ef-6ee5-4e1d-9a4a-88fd7e33eb58"],

Cell[TextData[{
 "1. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 12.1 or higher, including ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "; Java runtime 1.2 or higher."
}], "NumberedEquation",
 CellChangeTimes->{
  3.636389143914673*^9, {3.6363894780070486`*^9, 3.636389512942623*^9}, 
   3.636563982267456*^9, 3.793612486658677*^9, {3.794347085599867*^9, 
   3.7943471139943733`*^9}, {3.794940951328578*^9, 3.794940984961545*^9}, {
   3.7949411838541117`*^9, 
   3.794941207917899*^9}},ExpressionUUID->"9fb39432-b849-415e-bd9c-\
c182b6252ba9"],

Cell[TextData[{
 "2. ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " 5.04 or higher (download ",
 StyleBox["jv_math.zip",
  FontFamily->"Courier New"],
 " from www.javaview.de/download/data/ )."
}], "NumberedEquation",
 CellChangeTimes->{{3.636389153930419*^9, 3.63638915635223*^9}, {
   3.6363892645612974`*^9, 3.636389267498843*^9}, {3.636558315357196*^9, 
   3.6365583177166367`*^9}, {3.793612495896165*^9, 3.7936125124952364`*^9}, {
   3.794942078485857*^9, 3.7949420899005194`*^9}, {3.7949422338769712`*^9, 
   3.7949423060166607`*^9}, {3.7949423854059753`*^9, 3.794942385406937*^9}, {
   3.7949424774447193`*^9, 3.7949424843121977`*^9}, {3.794942530573798*^9, 
   3.7949425709947925`*^9}, {3.7949426018786516`*^9, 
   3.7949426733838825`*^9}, {3.7949427148891697`*^9, 
   3.7949427276569543`*^9}, {3.794942785276811*^9, 3.794942785278773*^9}, {
   3.7949428781804867`*^9, 3.7949429260297217`*^9}, 3.794943007340556*^9, {
   3.794943075309558*^9, 
   3.7949430826792393`*^9}},ExpressionUUID->"3be72625-444e-4258-8ef3-\
6604061b23b0"],

Cell[TextData[{
 "The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " package ",
 StyleBox["JavaView`JLink`",
  FontWeight->"Bold"],
 " provides a full integration of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " with ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". This package requires ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 12.1 or higher and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to be installed. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " must be installed in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation before installing ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " comes pre-installed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and higher. The newest version of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can be obtained from ",
 ButtonBox["www.wolfram.com/solutions/mathlink/jlink",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/mathlink/jlink"], None}],
 "."
}], "Text",
 CellChangeTimes->{{3.636389538887892*^9, 3.6363895503189197`*^9}, 
   3.636390195483328*^9, 3.6365639890799494`*^9, {3.793612528216443*^9, 
   3.793612528330147*^9}, 3.7949410429322157`*^9, 
   3.7949421398546968`*^9},ExpressionUUID->"286d9b34-1a0b-41c2-af67-\
7f17ab39be14"],

Cell[TextData[{
 "The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " package ",
 StyleBox["JavaView`RunThrough`",
  FontWeight->"Bold"],
 " provides a simpler integration of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that uses ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " as external standalone program and that does not require and use the \
advanced ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " integration. When using this package then ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is able to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics but does not provide feedback into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nor does is allow scripting of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". Although this package works without an installation of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " it does require a separate Java runtime outside of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.6363902239522457`*^9, 3.6363902447804*^9}, 
   3.636563828692177*^9, {3.793612547283063*^9, 3.7936126468899717`*^9}, {
   3.793612682314269*^9, 3.793612695984187*^9}, {3.794941067531963*^9, 
   3.794941096339965*^9}, {3.7949411368162837`*^9, 
   3.794941169578781*^9}},ExpressionUUID->"9a5f7560-7569-4f6f-9b9c-\
de7eb24c20ba"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " requires a Java runtime that is version 1.2 or later. A Java runtime is \
included in all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " distributions since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2."
}], "Text",
 CellChangeTimes->{3.6365640349564576`*^9, 3.793612268628728*^9, 
  3.794941212861885*^9},ExpressionUUID->"bd54f819-ade7-4f6b-9f7d-\
7fd62b4ae857"],

Cell[TextData[{
 "The sample notebooks provided with this ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " package were adjusted to comply with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 12.1. Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 12.1 has broken compatibility with earlier ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versions, such as packages were reorganized and methods renamed, several \
sample notebooks will have issues with earlier versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Still, the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " packages keeps some processing abilities and might be able to perform \
commands in earlier ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versions."
}], "Text",
 CellChangeTimes->{{3.6365640691196394`*^9, 3.6365641824668546`*^9}, {
  3.793612281154642*^9, 3.793612458392233*^9}, {3.7943471523239303`*^9, 
  3.7943472062284546`*^9}, {3.7943472439157734`*^9, 3.7943473119001093`*^9}, {
  3.7943473420892816`*^9, 3.794347402383956*^9}, {3.7949412346156826`*^9, 
  3.794941501122346*^9}},ExpressionUUID->"f8b1f198-c809-4971-8036-\
d21b49d56bc2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellChangeTimes->{{3.636565410620265*^9, 
  3.636565415636211*^9}},ExpressionUUID->"393d3f88-a7d2-4695-b086-\
d94504c7654d"],

Cell[TextData[{
 "The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " packages for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " include the standard ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " libraries and some documentary notebooks which are available for download \
from the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " homepage ",
 ButtonBox["www.javaview.de",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.javaview.de"], None}],
 " and uncompressed to the application directory of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.6363902741869216`*^9, 3.636390324394376*^9}, {
  3.6363903781136484`*^9, 3.636390379754122*^9}, {3.7949419003539686`*^9, 
  3.7949419008264885`*^9}},ExpressionUUID->"866f38fc-468c-4a54-99e5-\
6234c9fdcaaf"],

Cell[TextData[{
 "The required libraries for the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " system consists of two Java archives javaview.jar and jvx.jar. If ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " runs within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then two initialization files RunThrough.m and JLink.m plus this \
Overview.nb notebook must be available. Optionally, some models, localization \
files, and a tutorial directory with source code for Java programming may be \
downloaded."
}], "Text",ExpressionUUID->"89bdf5d7-7946-4064-8ada-cff01aaa5001"],

Cell[CellGroupData[{

Cell[TextData[{
 "Windows Installation of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.636564517191002*^9, 
  3.6365645189566855`*^9}},ExpressionUUID->"325ba2f2-e3ea-4747-a265-\
772507fcf3da"],

Cell["1. Goto http://www.javaview.de/.", "NumberedEquation",ExpressionUUID->"7dff3123-c717-405f-8c54-e70347380a13"],

Cell["2. Goto menu \"Download\".", "NumberedEquation",ExpressionUUID->"da9dac7a-44cf-4a8e-ae32-ddde03919ea2"],

Cell["3. Download the Windows installer \"javaviewWin_setup.exe\".", \
"NumberedEquation",
 CellChangeTimes->{{3.6365645895740447`*^9, 
  3.6365646106060314`*^9}},ExpressionUUID->"16a5180f-81fa-414b-9c27-\
1f66eb562649"],

Cell[TextData[{
 "4. Runing the installer will install both the standalone ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " application and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. During installation store the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package in\[LineSeparator]\t<path to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ">\\AddOns\\Applications\\\\JavaView\\\\\[LineSeparator]i.e.\[LineSeparator]\
\t$InstallationDirectory<>\[CloseCurlyDoubleQuote]\\\\AddOns\\\\Applications\\\
\\JavaView\\\\\[CloseCurlyDoubleQuote]"
}], "NumberedEquation",
 CellChangeTimes->{{3.63656462482532*^9, 3.636564717703071*^9}, {
   3.636564779412849*^9, 3.6365647861005597`*^9}, {3.793613948759094*^9, 
   3.793613982997733*^9}, 3.793614137988207*^9, {3.793614218515525*^9, 
   3.793614225021758*^9}, {3.793614257258815*^9, 3.793614338648406*^9}, {
   3.793614564005618*^9, 3.7936145646229634`*^9}, 3.7936146049250975`*^9, {
   3.794941640869484*^9, 
   3.794941644606713*^9}},ExpressionUUID->"aea7eb62-9fb8-42e0-9bd9-\
dcc693c7bc52"],

Cell[TextData[{
 "5. Register at www.javaview.de and store e-mail attached license file ",
 StyleBox["jv-lic.lic",
  FontSlant->"Italic"],
 " at:\[LineSeparator]\t<path to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dir>\\AddOns\\Applications\\JavaView\\Java\\rsrc\\jv-lic.lic\
\[LineSeparator]i.e.\[LineSeparator]\t$InstallationDirectory<>\
\[CloseCurlyDoubleQuote]\\\\AddOns\\\\Applications\\\\JavaView\\\\Java\\\\\
rsrc\\\\jv-lic.lic\[CloseCurlyDoubleQuote]"
}], "NumberedEquation",
 CellChangeTimes->{{3.636390718556693*^9, 3.636390837988346*^9}, {
  3.6365651944837646`*^9, 3.6365651956555176`*^9}, {3.7936137850720644`*^9, 
  3.7936137876488767`*^9}, {3.7936143664091673`*^9, 3.793614399019389*^9}, {
  3.7936145674020805`*^9, 
  3.793614568581875*^9}},ExpressionUUID->"3480af2b-19b8-43c2-8d7e-\
87896529246b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Alternate Installation of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.636564517191002*^9, 3.6365645189566855`*^9}, {
  3.63656456322371*^9, 
  3.6365645647237263`*^9}},ExpressionUUID->"0a496111-c556-412a-ab89-\
066972e8a72a"],

Cell["1. Goto http://www.javaview.de/.", "NumberedEquation",ExpressionUUID->"7b8f44c2-80f8-4630-8ef7-a0a7b2ad4ccd"],

Cell["2. Goto menu \"Download\".", "NumberedEquation",ExpressionUUID->"4a3bfcec-1cf4-4956-a7ee-9dceff4478f7"],

Cell["\<\
3. Download and uncompress the archive \"jv_math.zip\" to a temporary place, \
say /tmp. This will generate a new directory /tmp/JavaView including \
subdirectories. Assure that uncompression keeps the directory structure and \
is case sensitive on filenames.\
\>", "NumberedEquation",
 CellChangeTimes->{{3.6365648008511205`*^9, 3.6365648117107477`*^9}, {
   3.636565127242042*^9, 3.6365651323409615`*^9}, 
   3.7936145263296227`*^9},ExpressionUUID->"faee2d8b-70af-4c17-b028-\
3b31261712c5"],

Cell[TextData[{
 "4. Move the whole directory /tmp/JavaView to:\[LineSeparator]\t<path to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dir>/AddOns/Applications/JavaView/\[LineSeparator]i.e.\[LineSeparator]\t\
$InstallationDirectory<>\[CloseCurlyDoubleQuote]/AddOns/Applications/JavaView/\
\[CloseCurlyDoubleQuote]"
}], "NumberedEquation",
 CellChangeTimes->{
  3.6365648213830185`*^9, {3.6365651382630744`*^9, 3.636565146982073*^9}, {
   3.7936144358432875`*^9, 3.793614469231532*^9}, {3.793614557679134*^9, 
   3.7936145593327117`*^9}, {3.793614765090661*^9, 
   3.79361476848975*^9}},ExpressionUUID->"40899d84-5b50-4d79-aceb-\
1e0fe5d857e2"],

Cell[TextData[{
 "5. Register at www.javaview.de and store the e-mail attached license file \
jv-lic.lic at:\[LineSeparator]\t<path to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dir>/AddOns/Applications/JavaView/Java/rsrc/jv-lic.lic\[LineSeparator]i.e.\
\[LineSeparator]\t\
$InstallationDirectory<>\[CloseCurlyDoubleQuote]/AddOns/Applications/JavaView/\
Java/rsrc/jv-lic.lic\[CloseCurlyDoubleQuote]"
}], "NumberedEquation",
 CellChangeTimes->{{3.636390718556693*^9, 3.636390837988346*^9}, {
   3.636565151201047*^9, 3.636565186264595*^9}, {3.7936137939403553`*^9, 
   3.7936137958458624`*^9}, {3.7936144784104414`*^9, 
   3.7936144935376124`*^9}, {3.7936145725980177`*^9, 3.793614573277199*^9}, 
   3.7936147811124587`*^9},ExpressionUUID->"3433dbfe-8c1b-4bf5-856b-\
541bf66f7f84"]
}, Open  ]],

Cell[TextData[{
 "The directory <path to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dir>\\AddOns\\Applications\\JavaView\\Java will contain the",
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " jar-archives. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will locate the",
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " jar-archives automatically, i.e. there is no need to worry about classpath \
settings."
}], "Text",
 CellChangeTimes->{{3.793614654669811*^9, 
  3.793614655509118*^9}},ExpressionUUID->"b585105b-a563-45b1-8d10-\
ce73243c68d9"],

Cell[TextData[{
 "Note on compression: on MS Windows you may use the program ",
 StyleBox["winzip",
  FontSlant->"Italic"],
 ". On Unix, use the shell command \"unzip -U javaview.zip\" where the \
argument -U ensures that decompression works case sensitive on filenames."
}], "Text",
 CellChangeTimes->{{3.7932613810087643`*^9, 
  3.793261381161355*^9}},ExpressionUUID->"ce3e0aa5-9389-4ea8-b70a-\
7d4ea6f47831"],

Cell[TextData[{
 "Note, for the display of precomputed geometries there exists an additional \
light version ",
 StyleBox["jvLite",
  FontSlant->"Italic"],
 " of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " which is optimized for fast download and startup time (currently about 217 \
KB). The light version includes the full functionality of the display and a \
subset of the file loaders such as the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " parser, but it does not include the control window, dialogs, or more \
sophisticated geometry classes and algorithms. ",
 StyleBox["jvLite",
  FontSlant->"Italic"],
 " is intended to run as applet showing precomputed geometries inside web \
pages and also runs as standalone program. ",
 StyleBox["jvLite",
  FontSlant->"Italic"],
 " is included with the installation of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.636390460681468*^9, 3.6363904777439127`*^9}, {
  3.79494171711128*^9, 3.7949417184652104`*^9}, {3.7949417912268367`*^9, 
  3.7949418746900806`*^9}},ExpressionUUID->"fddf2bf8-cee1-4eff-a1f0-\
f527e23d15e1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Testing a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " Installation (optional)"
}], "Section",
 CellChangeTimes->{{3.636391291100824*^9, 3.636391292038267*^9}, {
  3.7949431263924203`*^9, 
  3.7949431290241838`*^9}},ExpressionUUID->"f426655e-7721-42d4-aacc-\
1e301cc8f9f6"],

Cell[TextData[{
 "Different reasons may lead to a failure of a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " installation. Some are related to the installation of the Java runtime \
system, some to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package J/Link, and finally some to the installation of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". Here we provide some step by step directions to locate the source of \
trouble. Note, failures appearing in step 1 of this section are not related \
to ",
 StyleBox["JavaView.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.636391176173068*^9},ExpressionUUID->"24ad8689-95ad-48b4-8ab0-\
59aaca172e06"],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Test the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Installation"
}], "Subsection",
 CellChangeTimes->{
  3.6363912125218515`*^9, {3.7949434224273643`*^9, 
   3.7949434240532293`*^9}},ExpressionUUID->"20005b9e-f42f-4e62-93d2-\
996a621a64e5"],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is a package of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which provides the link between JavaView and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". J/Link is pre-installed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later."
}], "Text",
 CellChangeTimes->{
  3.6363910135447965`*^9},ExpressionUUID->"0928735a-60fa-4e8d-a8ed-\
4249023fbffd"],

Cell[CellGroupData[{

Cell[TextData[{
 "1.1  Loading the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Package"
}], "Subsubsection",
 CellChangeTimes->{
  3.6363912139747934`*^9},ExpressionUUID->"0fcf634a-f15f-47cb-8877-\
9048056acbd8"],

Cell[TextData[{
 "The first step is to load the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package file. If you have installed ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", you will be able to load the package with the following line:"
}], "Text",ExpressionUUID->"12c237e5-90b6-4568-b1c4-098643c8152c"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<JLink`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"aee0ac12-0319-436b-8296-084f95bbf1a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2  Version Information", "Subsubsection",
 CellChangeTimes->{
  3.6363912156311007`*^9},ExpressionUUID->"099515be-cad2-46f5-a15f-\
2ad9ddb202d0"],

Cell[TextData[{
 StyleBox["Check the version number of ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". You must need J/Link v2.0.0 or higher.",
 " "
}], "Text",ExpressionUUID->"03b4661d-272c-411c-ad83-9a19fb88d1ad"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox["JLink`Information`$Version", "MR"], 
     StyleBox[
      RowBox[{
      "a", " ", "string", " ", "giving", " ", "full", " ", "version", " ", 
       "information"}], "Text"]}
   }], TextForm]], "DefinitionBox",ExpressionUUID->"6db20853-5632-4231-98b3-\
a71c0e2e09f7"],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " version information."
}], "Caption",ExpressionUUID->"30436e31-3e09-4232-9891-6f637b3d8ed0"],

Cell["Check the version number of J/Link.", "MathCaption",
 CellChangeTimes->{{3.794943235426599*^9, 
  3.7949432502183123`*^9}},ExpressionUUID->"a446c897-8e17-4688-a0cb-\
bee8347fd51a"],

Cell[BoxData["JLink`Information`$Version"], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"1e8534ac-7f87-4d29-bb96-dcb8aaa113db"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3 InstallJava", "Subsubsection",
 CellChangeTimes->{
  3.636391218115507*^9},ExpressionUUID->"ad360108-2ce5-4abc-9bb3-\
eb763f13cb27"],

Cell[TextData[{
 "The next step is to launch the Java runtime and \
\[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it into ",
 StyleBox["Mathematica", "TI"],
 ". The function for this is ",
 StyleBox["InstallJava", "MR"],
 StyleBox[".", "MR",
  FontFamily->"Arial"]
}], "Text",ExpressionUUID->"a1848941-dcff-49b7-be2b-8988f887c9cb"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"InstallJava", "[", "]"}], "MR"], Cell[TextData[{
      "launch the Java runtime and prepare it for use from ",
      StyleBox["Mathematica",
       FontSlant->"Italic"]
     }], "Text",
      CellTags->"jlug:5.2.2.1",ExpressionUUID->
      "b5fb9fb3-a1a2-4f8b-a2f3-afa46d08fc8e"]}
   }], TextForm]], "DefinitionBox",ExpressionUUID->"8fed496f-fe30-416b-9e6b-\
fefe4f04254f"],

Cell["Launching the Java runtime.", "Caption",ExpressionUUID->"d8657a3b-d23f-41e5-8497-0cb221184f7d"],

Cell["Check if J/Link can be loaded and returns a LinkObject.", "MathCaption",
 CellChangeTimes->{{3.794943202614012*^9, 
  3.7949432112803125`*^9}},ExpressionUUID->"8d26d6f9-247c-45a0-ae0a-\
f8a9f5f84dda"],

Cell[BoxData[
 RowBox[{"InstallJava", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7937904125614367`*^9, 3.793790418954855*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"fd27fbf9-5798-4d19-b072-17ec60cb56ca"],

Cell[TextData[{
 "If ",
 StyleBox["InstallJava", "MR"],
 " succeeds, it will return a ",
 StyleBox["LinkObject", "MR"],
 ". The most common failure mode is that ",
 StyleBox["InstallJava", "MR"],
 " does not return. If this happens, use the ",
 StyleBox["Kernel/Abort Evaluation", "SR",
  FontFamily->"Courier New"],
 " menu command to abort the call. If you have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 or later, then ",
 StyleBox["InstallJava[]", "MR"],
 " should work when called with the default options. If it fails, have a look \
at the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " documentation of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.636391085140319*^9, 3.636391085734087*^9}, {
  3.7949433560524797`*^9, 
  3.7949434032193594`*^9}},ExpressionUUID->"563fc2ec-9ed9-4169-bcf5-\
464ff07c3093"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "2. Test the ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " Installation"
}], "Subsection",
 CellChangeTimes->{
  3.636391220209447*^9, {3.7949434811338873`*^9, 
   3.794943482717778*^9}},ExpressionUUID->"614be978-6666-49fa-bdfe-\
cd1936d42ed3"],

Cell[TextData[{
 StyleBox["The package ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["JavaView`",
  FontSlant->"Italic"],
 "JLink` is an Add-On application of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and must be installed separately after a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation. Two-way communication between ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is established via ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.6365614718010416`*^9, 3.636561473394862*^9}, {
  3.636561519099469*^9, 3.6365615932477903`*^9}, {3.636561707901711*^9, 
  3.6365617215121317`*^9}},ExpressionUUID->"01dfe816-93ca-4ea9-99a1-\
fd60cd5f918c"],

Cell[CellGroupData[{

Cell[TextData[{
 "2.1  Loading the ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " Package"
}], "Subsubsection",
 CellChangeTimes->{
  3.636391221724923*^9, {3.79494348953834*^9, 
   3.794943490603009*^9}},ExpressionUUID->"1c7d2e4b-44f0-4eb5-bf1c-\
212561f1a9a8"],

Cell[TextData[{
 "The first step is to load the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " package file. If you have installed ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ", you will be able to load the package with the following command:"
}], "Text",
 CellChangeTimes->{{3.793703286113327*^9, 
  3.7937032888427787`*^9}},ExpressionUUID->"cc10b22a-1b0c-481b-b4cb-\
4fecd2d3e8d0"],

Cell[BoxData[
 RowBox[{"<<", "JavaView`JLink`"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"b22e0e7e-b5ae-46f1-9a92-590bfb1ea21f"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2  Version Information", "Subsubsection",
 CellChangeTimes->{3.6363912156311007`*^9, 
  3.6365601136256666`*^9},ExpressionUUID->"2f3c478c-0379-43d4-a00a-\
8de2109efe02"],

Cell[TextData[{
 StyleBox["Check the version number of the ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " package. You must need ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " v2.0.0 or higher. "
}], "Text",
 CellChangeTimes->{{3.6365601352357235`*^9, 3.636560164705413*^9}, {
  3.63656020597228*^9, 3.6365602077692347`*^9}, {3.6365606853860617`*^9, 
  3.6365607005761113`*^9}},ExpressionUUID->"ca4f35bc-c4c5-4820-8566-\
9dc195782232"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox["JavaView`$Version", "MR"], 
     StyleBox[
      RowBox[{
      "a", " ", "string", " ", "giving", " ", "full", " ", "version", " ", 
       "information"}], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellChangeTimes->{{3.6365602175195494`*^9, 3.6365602199570975`*^9}, {
  3.636560331965921*^9, 3.6365603332315855`*^9}, {3.6365606716850715`*^9, 
  3.636560672891947*^9}},ExpressionUUID->"fc710736-333e-4af9-9599-\
7938656bb7a5"],

Cell[TextData[{
 StyleBox["JavaView`JLink`",
  FontSlant->"Italic"],
 " version information."
}], "Caption",
 CellChangeTimes->{{3.6365607090432887`*^9, 3.6365607122666297`*^9}, {
  3.7937034141806326`*^9, 
  3.7937034231877785`*^9}},ExpressionUUID->"ba0021af-f268-402a-b111-\
33e5065f19eb"],

Cell["Check the version number of JavaView`JLink.", "MathCaption",
 CellChangeTimes->{{3.636560344013235*^9, 
  3.636560349200899*^9}},ExpressionUUID->"a0324755-881a-4368-aafb-\
54587b643b57"],

Cell[BoxData["JavaView`$Version"], "Input",
 CellChangeTimes->{{3.6365603804831486`*^9, 3.636560385952036*^9}, {
  3.636560665069248*^9, 3.6365606662130537`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0c3c3e15-e360-46d8-a8a0-0cfed6a54a3c"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3 Launching the JavaView Package", "Subsubsection",
 CellChangeTimes->{
  3.6363912234907336`*^9, {3.636560077452645*^9, 3.636560108766143*^9}, {
   3.7937033080429907`*^9, 
   3.7937033110383587`*^9}},ExpressionUUID->"9aa9461d-b3d0-4e7c-bb77-\
8ebca8843879"],

Cell[TextData[{
 "The next step is to launch the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " runtime and connect it to ",
 StyleBox["Mathematica", "TI"],
 ". The function for this is ",
 StyleBox["InstallJavaView", "MR"],
 StyleBox[".", "MR",
  FontFamily->"Arial"]
}], "Text",
 CellChangeTimes->{{3.7937033266714764`*^9, 
  3.793703367112591*^9}},ExpressionUUID->"66aadb06-ed95-44f1-8eb5-\
e47fc7216bb1"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"InstallJavaView", "[", "]"}], "MR"], 
     RowBox[{
      RowBox[{Cell[TextData[{
        "launch the Java runtime and prepare ",
        StyleBox["JavaView",
         FontSlant->"Italic"],
        " for use from ",
        StyleBox["Mathematica",
         FontSlant->"Italic"]
       }], "Text",
        CellTags->"jlug:5.2.2.1",ExpressionUUID->
        "bc165e05-25e4-4880-a6f6-30bfde537086"], 
       StyleBox[".",
        FontSlant->"Plain"], 
       StyleBox[" ",
        FontSlant->"Plain"], 
       StyleBox["The",
        FontSlant->"Plain"]}], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["command",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["returns",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["the",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["viewer",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["manager",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      StyleBox["of",
       FontSlant->"Plain"], 
      StyleBox[" ",
       FontSlant->"Plain"], 
      RowBox[{
       StyleBox["JavaView",
        FontSlant->"Italic"], 
       StyleBox[".",
        FontSlant->"Plain"]}]}]}
   }], TextForm]], "DefinitionBox",
 CellChangeTimes->{
  3.63655255477973*^9, {3.636563770877914*^9, 
   3.636563770877914*^9}},ExpressionUUID->"161e90e1-8521-438a-b40d-\
1c0dd8c28e97"],

Cell["Launching the JavaView runtime.", "Caption",
 CellChangeTimes->{{3.79370337785362*^9, 
  3.793703378308484*^9}},ExpressionUUID->"d632cfb0-a152-4c86-b640-\
553cc6179bc6"],

Cell[TextData[{
 "Launch the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " runtime."
}], "MathCaption",
 CellChangeTimes->{{3.794945152611021*^9, 
  3.7949451673939114`*^9}},ExpressionUUID->"360503c1-582f-46a8-a3b3-\
93f04184c209"],

Cell[BoxData[
 RowBox[{"viewer", "=", 
  RowBox[{"InstallJavaView", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.636638736484274*^9, 3.636638739656237*^9}, {
   3.7932580643131895`*^9, 3.793258065031935*^9}, {3.7932582810132065`*^9, 
   3.793258299948347*^9}, {3.7937034647487926`*^9, 3.793703466234672*^9}, {
   3.7949449335210648`*^9, 3.79494493604469*^9}, 3.7949450161818686`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"ce286408-5dfc-4c72-8062-09b7cc620a6a"],

Cell[TextData[{
 "For more information, in case of issues, consider the verbose mode of ",
 StyleBox["InstallJavaView", "MR"],
 StyleBox[".", "MR",
  FontFamily->"Arial"]
}], "Text",
 CellChangeTimes->{{3.7937033266714764`*^9, 3.793703367112591*^9}, {
  3.794945026114071*^9, 
  3.794945069842286*^9}},ExpressionUUID->"42bc08e6-a0b4-4e41-bf45-\
fc4fcdcf6276"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"InstallJavaView", "[", 
       RowBox[{"Verbose", "->", "True"}], "]"}], "MR"], 
     RowBox[{"use", " ", "the", " ", "verbose", " ", "mode", " ", "of", " ", 
      RowBox[{"InstallJavaView", "[", "]"}], " ", "to", " ", "investigate", 
      " ", 
      RowBox[{"issues", 
       StyleBox[".",
        FontSlant->"Plain"]}]}]}
   }], TextForm]], "DefinitionBox",
 CellChangeTimes->{
  3.63655255477973*^9, {3.636563770877914*^9, 3.636563770877914*^9}, {
   3.7949450735792065`*^9, 
   3.794945113507842*^9}},ExpressionUUID->"5fb2882d-4e9c-4f1b-98a8-\
5c5ad13855df"],

Cell["Launching the JavaView runtime in verbose mode.", "Caption",
 CellChangeTimes->{{3.79370337785362*^9, 3.793703378308484*^9}, {
  3.7949451202976775`*^9, 
  3.79494512310617*^9}},ExpressionUUID->"08255995-be34-4e4f-8ee8-\
1af7068b3142"],

Cell[TextData[{
 "Launch the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " runtime in verbose mode."
}], "MathCaption",
 CellChangeTimes->{{3.7949451306670227`*^9, 3.794945131756222*^9}, {
  3.794945184439842*^9, 
  3.7949451878271713`*^9}},ExpressionUUID->"f6c32459-7b07-4617-91d4-\
bdfcf14bc3e6"],

Cell[BoxData[
 RowBox[{"viewer", "=", 
  RowBox[{"InstallJavaView", "[", 
   RowBox[{"Verbose", "\[Rule]", "True"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.636638736484274*^9, 3.636638739656237*^9}, {
  3.7932580643131895`*^9, 3.793258065031935*^9}, {3.7932582810132065`*^9, 
  3.793258299948347*^9}, {3.7937034647487926`*^9, 3.793703466234672*^9}, {
  3.7949449335210648`*^9, 3.79494493604469*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"e72e0a99-ea3d-4857-b272-4525bd61f854"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "3. Test the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " Display"
}], "Subsection",
 CellChangeTimes->{
  3.6363912313345785`*^9, 3.6365601059847975`*^9, {3.7949453200554733`*^9, 
   3.794945332007253*^9}},ExpressionUUID->"01ddf1c2-28cf-46b7-bd6d-\
edc4ff65142f"],

Cell[TextData[{
 "If the installation steps above were successful, then the command \
JavaView[] opens a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display respectively shows a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics as an interactive 3D geometry in a separate windows."
}], "Text",
 CellChangeTimes->{{3.636561240432908*^9, 3.636561289465665*^9}, 
   3.636563560898186*^9},ExpressionUUID->"b1857f3a-913b-4f6d-bb08-\
7fb9d603bd7d"],

Cell[TextData[{
 "Open an empty ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display in a separate window."
}], "MathCaption",
 CellChangeTimes->{{3.6365611539879093`*^9, 3.6365611685243855`*^9}, {
   3.636561293809594*^9, 3.6365613018879757`*^9}, 
   3.636563556007606*^9},ExpressionUUID->"79a23464-296d-4bdf-afe7-\
e726d40e6d05"],

Cell[BoxData[
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "]"}]], "Input",
 CellChangeTimes->{{3.636392567334077*^9, 3.6363925706941338`*^9}, {
  3.63656115817554*^9, 3.6365611618054137`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"5a23c898-1729-434e-a493-5692d9965b03"],

Cell[TextData[{
 "Create a sample geometry and view it in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "MathCaption",
 CellChangeTimes->{{3.6365613103726172`*^9, 3.636561310591343*^9}, 
   3.6365635590387955`*^9},ExpressionUUID->"afbcac6d-6863-4c22-a69a-\
4190a214baaa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dode", "=", " ", 
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "dode", "]"}]}], "Input",
 CellChangeTimes->{{3.636392567334077*^9, 3.6363925706941338`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"1807918f-3099-43d9-a7ea-e04037852b23"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`JLink`", "Section",ExpressionUUID->"37901c4a-f542-458c-9b49-ab99b0df3256"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "`JLink is a powerful add-on package to enable the tight integration between \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The package ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "`JLink` makes use of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package J/Link. In this section we introduce two simple commands to setup \
an initial connection, and then explore in more detail the interaction \
possibilities. "
}], "Text",
 CellChangeTimes->{{3.7936121634957886`*^9, 
  3.793612168808406*^9}},ExpressionUUID->"a3b6a9dd-ced9-4361-878b-\
f7ca4877e30f"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"InstallJavaView", "[", "]"}], "MR",
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{
     "launch", " ", "the", " ", "Java", " ", "runtime", " ", "and", " ", 
      "prepare", " ", "it", " ", "for", " ", "use", " ", "for", " ", 
      StyleBox["JavaView",
       FontSlant->"Italic"], " ", "from", " ", 
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["Mathematic",
          FontSlant->"Italic"], "a"}]], ".", "\[LineSeparator]", "Create"}], 
      " ", "a", " ", 
      StyleBox["JavaView",
       FontSlant->"Italic"], " ", "viewer", " ", "manager", " ", "and", " ", 
      "preload", " ", "some", " ", "static", " ", 
      RowBox[{"classes", "."}]}]},
    {
     StyleBox[
      RowBox[{
       StyleBox["JavaView",
        FontVariations->{"CompatibilityType"->0}], 
       StyleBox["[", "MR"], 
       StyleBox[
        FormBox["g",
         TraditionalForm], "TI"], 
       StyleBox["]", "MR"]}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{"show", " ", "a", " ", 
      StyleBox[
       RowBox[{
        StyleBox["Mathematic",
         FontSlant->"Italic"], "a"}]], " ", "graphics", " ", "in", " ", "a", 
      " ", 
      StyleBox["JavaView",
       FontSlant->"Italic"], " ", 
      RowBox[{"display", ".", " ", "The"}], " ", "same", " ", "command", " ", 
      "accepts", " ", 
      StyleBox["JavaView",
       FontSlant->"Italic"], " ", "geometries", " ", 
      RowBox[{"too", "."}]}]},
    {
     RowBox[{
      StyleBox["JavaView",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"CompatibilityType"->0,
       "StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]], 
      StyleBox["[",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        StyleBox["{",
         FontFamily->"Courier New",
         FontSize->12,
         FontWeight->"Plain",
         FontVariations->{"StrikeThrough"->False,
         "Underline"->False},
         FontColor->GrayLevel[0]], 
        RowBox[{
         StyleBox[
          SubscriptBox["g", "1"], "InlineFormula"], ",", 
         StyleBox[
          SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}], " ", 
        StyleBox["}",
         FontFamily->"Courier New",
         FontSize->12,
         FontWeight->"Plain",
         FontVariations->{"StrikeThrough"->False,
         "Underline"->False},
         FontColor->GrayLevel[0]]}],
       FontSlant->"Italic"], 
      StyleBox["]",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]]}], 
     RowBox[{"show", " ", "a", " ", "list", " ", "of", " ", 
      StyleBox["Mathematica",
       FontSlant->"Italic"], " ", "graphics", " ", "together", " ", "in", " ",
       "a", " ", 
      StyleBox["JavaView",
       FontSlant->"Italic"], " ", 
      RowBox[{"display", "."}]}]},
    {
     RowBox[{
      StyleBox["JavaView",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"CompatibilityType"->0,
       "StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]], 
      StyleBox["[",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        RowBox[{
         StyleBox["{",
          FontFamily->"Courier New",
          FontSize->12,
          FontWeight->"Plain",
          FontVariations->{"StrikeThrough"->False,
          "Underline"->False},
          FontColor->GrayLevel[0]], 
         RowBox[{
          StyleBox[
           SubscriptBox["g", "1"], "InlineFormula"], ",", 
          StyleBox[
           SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}], " ", 
         StyleBox["}",
          FontFamily->"Courier New",
          FontSize->12,
          FontWeight->"Plain",
          FontVariations->{"StrikeThrough"->False,
          "Underline"->False},
          FontColor->GrayLevel[0]]}], 
        StyleBox[",",
         FontFamily->"Courier New",
         FontSize->12,
         FontWeight->"Plain",
         FontVariations->{"StrikeThrough"->False,
         "Underline"->False},
         FontColor->GrayLevel[0]], 
        StyleBox[
         RowBox[{"Animatable", "\[Rule]", "True"}],
         FontFamily->"Courier New",
         FontSize->12,
         FontWeight->"Plain",
         FontVariations->{"StrikeThrough"->False,
         "Underline"->False},
         FontColor->GrayLevel[0]]}],
       FontSlant->"Italic"], 
      StyleBox["]",
       FontFamily->"Courier",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontVariations->{"StrikeThrough"->False,
       "Underline"->False},
       FontColor->GrayLevel[0]]}], 
     RowBox[{"show", " ", "a", " ", "list", " ", "of", " ", 
      StyleBox["Mathematica",
       FontSlant->"Italic"], " ", "graphics", " ", "as", " ", "a", " ", 
      "smooth", " ", "animation", " ", "with", " ", "animation", " ", 
      RowBox[{"dialog", "."}]}]}
   }], NotebookDefault]], "DefinitionBox",
 CellChangeTimes->{{3.7949456142297106`*^9, 3.7949456446543703`*^9}, {
  3.794945705022932*^9, 3.7949457091028447`*^9}},
 TextAlignment->Left,
 TextJustification->0,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"497a17c9-8728-4b6a-88c5-475f0f93c78a"],

Cell[TextData[{
 "Start ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics."
}], "Caption",ExpressionUUID->"a1f68a79-e7a9-4bdf-bcbb-baa9ccd30033"],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package which must be loaded before using ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The package JavaView`JLink` loads ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " automatically with a default configuration. A user may set different \
options to load and configure ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " before loading ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". Loading of JavaView`JLink` does not modify the previous configuration of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " since the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " command ",
 StyleBox["InstallJava",
  FontFamily->"Courier New"],
 " does nothing on its second and later invocations."
}], "Text",ExpressionUUID->"58238769-50e4-46a5-8f0b-c61de766d2f6"],

Cell[CellGroupData[{

Cell[TextData[{
 "Optionally: configure ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " before loading the JavaView package by using ",
 StyleBox["SetOptions[]",
  FontFamily->"Courier New"],
 "."
}], "Text",ExpressionUUID->"d84eeda7-a2a4-47be-a633-e3192565f3d0"],

Cell[TextData[{
 "The package ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " automatically loads the package ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". By default, the command ",
 StyleBox["InstallJavaView",
  FontFamily->"Courier New"],
 " uses the default settings of the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " initialization command ",
 StyleBox["InstallJava",
  FontFamily->"Courier New"],
 " to load a Java runtime. This behaviour can be adjusted by using the \
command ",
 StyleBox["SetOptions",
  FontFamily->"Courier New"],
 " BEFORE calling either ",
 StyleBox["InstallJava",
  FontFamily->"Courier New"],
 " or ",
 StyleBox["InstallJavaView",
  FontFamily->"Courier New"],
 ". The following options enable the use of a different Java runtime than \
provided by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellChangeTimes->{{3.6363930604435205`*^9, 3.6363930828667965`*^9}, 
   3.7949457802390003`*^9},ExpressionUUID->"ec25fda8-5909-4550-ab18-\
db7397f66fc5"],

Cell["\<\
<<JLink`
SetOptions[InstallJava, ClassPath->\[CloseCurlyDoubleQuote]some path\
\[CloseCurlyDoubleQuote]]
SetOptions[InstallJava, CommandLine->java]\
\>", "Program",
 CellChangeTimes->{{3.6363931001337852`*^9, 
  3.6363931176973467`*^9}},ExpressionUUID->"a2470739-2e22-4647-bc7a-\
beebe6b013df"]
}, Closed]],

Cell[TextData[{
 StyleBox["InstallJavaView[]",
  FontFamily->"Courier New"],
 " creates a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " viewer manager and must be called prior to the first usage of ",
 StyleBox["JavaView[g]",
  FontFamily->"Courier New"],
 ". The command also pre-loads some ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " classes to simplify later access to static methods and constants. Its \
return value is the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " viewer manager which is an instance of the class jv.viewer.PvViewer, and \
which may be queried, for example, for the current display.\nIn contrast to \
the command ",
 StyleBox["RunJavaView[g]",
  FontFamily->"Courier New"],
 " discussed in the next section, this ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " connection to ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " does not block the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. Instead, it allows a realtime exchange of interactive data."
}], "Text",
 CellChangeTimes->{{3.793615490304999*^9, 
  3.793615501081424*^9}},ExpressionUUID->"3b7ce41c-b1cd-4592-ae50-\
afb22704ccdb"],

Cell[CellGroupData[{

Cell[TextData[{
 "First ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display"
}], "Subsection",ExpressionUUID->"32044154-00c7-4ed6-a4c1-37a07ee04f1b"],

Cell[TextData[{
 "Load the ",
 StyleBox["JavaView`JLink",
  FontSlant->"Italic"],
 " package including the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellChangeTimes->{
  3.7949460928924465`*^9},ExpressionUUID->"dbd419f5-185e-4372-980f-\
dba595de0105"],

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"viewer", " ", "=", " ", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.793583634263507*^9, 3.793583638778162*^9}, {
   3.79360158622178*^9, 3.7936016033581557`*^9}, {3.793601694935973*^9, 
   3.7936016955469294`*^9}, {3.79360422221586*^9, 3.7936042226823854`*^9}, 
   3.7936053589781866`*^9, {3.7936099838155584`*^9, 3.793609984561761*^9}, {
   3.7936108303187823`*^9, 3.793610830956053*^9}, {3.793790259632756*^9, 
   3.79379027648283*^9}, {3.794412889557067*^9, 3.7944128907124777`*^9}, 
   3.7948590386147375`*^9, {3.7949459058778706`*^9, 3.794945906366513*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d05be3b3-8478-4bbd-bf73-d0c745ef7c19"],

Cell[TextData[{
 "Now we are ready to display the first geometry via the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " connection. The command ",
 StyleBox["JavaView[g]",
  FontFamily->"Courier New"],
 " displays a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The first invocation of the command ",
 StyleBox["JavaView",
  FontFamily->"Courier New"],
 " will open a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "Text",ExpressionUUID->"09f4fc14-9fc0-4a85-8db6-099c4c49e4eb"],

Cell["Create a sample geometry and view it in a JavaView display.", \
"MathCaption",ExpressionUUID->"8a768287-1934-4d04-9e2b-6135630cee9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dode", "=", " ", 
  RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}]], "Input",
 CellChangeTimes->{3.636393192393165*^9, 3.7943297405163875`*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"7e5ecf2d-8178-429d-be3e-9b9b5b575341"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417602, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417602, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]],
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{3.794329741339804*^9, 3.794412906493286*^9, 
  3.7944995913750134`*^9, 3.7944998385311565`*^9, 3.794501354844761*^9, 
  3.79450246702732*^9, 3.794506412399393*^9, 3.794508817796178*^9, 
  3.7946484491202335`*^9, 3.794650514041132*^9, 3.7946618031884584`*^9, 
  3.794857321499511*^9, 3.794926329520169*^9, 3.794946128604992*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"1ede1d1b-4eb9-4997-b093-7320ec16acff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "dode", "]"}]], "Input",
 CellChangeTimes->{3.794946134919077*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"1f2f5fee-f7d3-4a6b-8e8f-d22e673f1477"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject2787263184371713]], "Output",
 CellChangeTimes->{3.7949461357139397`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"ae329b75-dd1d-4423-8b2d-47da189ef79e"]
}, Open  ]],

Cell[TextData[{
 "As a rule of thumb, the command JavaView[] can be used whenever the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command Show[] would apply."
}], "MathCaption",ExpressionUUID->"2e894d3e-4eb0-4d20-aceb-1146feaeacc2"],

Cell[BoxData[
 RowBox[{"Show", "[", "dode", "]"}]], "Input",
 CellChangeTimes->{3.6363932077373266`*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"9f2b6ef4-be6f-4441-be75-af81e68a827d"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417602, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417602, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]]]], "Output",
 CellChangeTimes->{3.7943297855658984`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"53e798df-1f73-49a7-8b13-3f342ff9caf6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Simple graphics examples displayed by JavaView", "Subsection",ExpressionUUID->"e54f7f68-9c57-41f0-9bb3-1f46dc4a4e5e"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " understands most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics type such as Graphics, Graphics3D, SurfaceGraphics, and others. \
Subsequent invocations of the command JavaView[g] replace the previous \
geometry in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display. This is done intentionally to simplify the use of the command \
JavaView[g] although ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is able to visualize a whole scene of multiple geometries and animations. \
An option exists to keep the current scene shown in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "Text",ExpressionUUID->"497d6bb3-4e50-4d83-b7fa-4d17ec6fe315"],

Cell[TextData[{
 "A detailed list of graphics examples is provided in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " user's guide."
}], "Text",ExpressionUUID->"82bf27b9-d3ae-4882-93fa-8a4700b1cd7a"],

Cell["Visualizing a function curve as a set of points. ", "MathCaption",ExpressionUUID->"f7b3a87a-2257-40a8-a9ae-e7ae45c2355f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"2", 
          RowBox[{"Sin", "[", 
           RowBox[{"1", "/", 
            StyleBox["x", "MathCaption"]}], "]"}]}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi", ",", ".01"}], "}"}]}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.794329800169346*^9, 3.794329800740777*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"cd403c96-3fe8-4d00-9d5c-8e5d52a4a95c"],

Cell[BoxData[
 GraphicsBox[{PointBox[{-3.141592653589793, -0.6259235924155733}], 
   PointBox[{-3.1315926535897933`, -0.6278540423143991}], 
   PointBox[{-3.121592653589793, -0.6297962056499042}], 
   PointBox[{-3.1115926535897933`, -0.6317501869688606}], 
   PointBox[{-3.101592653589793, -0.633716092031906}], 
   PointBox[{-3.0915926535897933`, -0.635694027830586}], 
   PointBox[{-3.081592653589793, -0.6376841026046705}], 
   PointBox[{-3.0715926535897933`, -0.6396864258597472}], 
   PointBox[{-3.061592653589793, -0.6417011083851003}], 
   PointBox[{-3.0515926535897933`, -0.6437282622718744}], 
   PointBox[{-3.041592653589793, -0.6457680009315345}], 
   PointBox[{-3.0315926535897932`, -0.6478204391146213}], 
   PointBox[{-3.021592653589793, -0.6498856929298115}], 
   PointBox[{-3.0115926535897932`, -0.6519638798632857}], 
   PointBox[{-3.001592653589793, -0.6540551187984105}], 
   PointBox[{-2.991592653589793, -0.6561595300357389}], 
   PointBox[{-2.981592653589793, -0.6582772353133372}], 
   PointBox[{-2.971592653589793, -0.6604083578274386}], 
   PointBox[{-2.961592653589793, -0.6625530222534379}], 
   PointBox[{-2.951592653589793, -0.664711354767222}], 
   PointBox[{-2.941592653589793, -0.666883483066853}], 
   PointBox[{-2.931592653589793, -0.6690695363946008}], 
   PointBox[{-2.921592653589793, -0.6712696455593377}], 
   PointBox[{-2.911592653589793, -0.6734839429592975}], 
   PointBox[{-2.901592653589793, -0.6757125626052061}], 
   PointBox[{-2.891592653589793, -0.6779556401437913}], 
   PointBox[{-2.8815926535897933`, -0.6802133128816757}], 
   PointBox[{-2.871592653589793, -0.6824857198096619}], 
   PointBox[{-2.861592653589793, -0.6847730016274134}], 
   PointBox[{-2.851592653589793, -0.687075300768542}], 
   PointBox[{-2.8415926535897933`, -0.6893927614261043}], 
   PointBox[{-2.831592653589793, -0.6917255295785172}], 
   PointBox[{-2.8215926535897933`, -0.6940737530158967}], 
   PointBox[{-2.811592653589793, -0.6964375813668309}], 
   PointBox[{-2.8015926535897933`, -0.6988171661255886}], 
   PointBox[{-2.791592653589793, -0.701212660679778}], 
   PointBox[{-2.7815926535897932`, -0.7036242203384543}], 
   PointBox[{-2.771592653589793, -0.7060520023606925}], 
   PointBox[{-2.7615926535897932`, -0.7084961659846251}], 
   PointBox[{-2.751592653589793, -0.7109568724569575}], 
   PointBox[{-2.741592653589793, -0.7134342850629657}], 
   PointBox[{-2.731592653589793, -0.7159285691569869}], 
   PointBox[{-2.721592653589793, -0.718439892193406}], 
   PointBox[{-2.711592653589793, -0.720968423758152}], 
   PointBox[{-2.701592653589793, -0.7235143356007068}], 
   PointBox[{-2.691592653589793, -0.7260778016666386}], 
   PointBox[{-2.681592653589793, -0.7286589981306638}], 
   PointBox[{-2.671592653589793, -0.7312581034302496}], 
   PointBox[{-2.661592653589793, -0.733875298299762}], 
   PointBox[{-2.651592653589793, -0.7365107658051709}], 
   PointBox[{-2.641592653589793, -0.7391646913793157}], 
   PointBox[{-2.6315926535897933`, -0.7418372628577459}], 
   PointBox[{-2.621592653589793, -0.7445286705151384}], 
   PointBox[{-2.611592653589793, -0.7472391071023055}], 
   PointBox[{-2.601592653589793, -0.7499687678837973}], 
   PointBox[{-2.5915926535897933`, -0.7527178506761115}], 
   PointBox[{-2.581592653589793, -0.7554865558865141}], 
   PointBox[{-2.571592653589793, -0.7582750865524824}], 
   PointBox[{-2.561592653589793, -0.7610836483817778}], 
   PointBox[{-2.5515926535897933`, -0.7639124497931566}], 
   PointBox[{-2.541592653589793, -0.7667617019577273}], 
   PointBox[{-2.5315926535897932`, -0.7696316188409601}], 
   PointBox[{-2.521592653589793, -0.7725224172453621}], 
   PointBox[{-2.5115926535897932`, -0.7754343168538192}], 
   PointBox[{-2.501592653589793, -0.7783675402736184}], 
   PointBox[{-2.491592653589793, -0.7813223130811537}], 
   PointBox[{-2.481592653589793, -0.7842988638673276}], 
   PointBox[{-2.471592653589793, -0.7872974242836497}], 
   PointBox[{-2.461592653589793, -0.7903182290890467}], 
   PointBox[{-2.451592653589793, -0.7933615161973833}], 
   PointBox[{-2.441592653589793, -0.7964275267257063}], 
   PointBox[{-2.431592653589793, -0.7995165050432158}], 
   PointBox[{-2.4215926535897934`, -0.8026286988209695}], 
   PointBox[{-2.411592653589793, -0.8057643590823268}], 
   PointBox[{-2.401592653589793, -0.8089237402541358}], 
   PointBox[{-2.391592653589793, -0.8121071002186725}], 
   PointBox[{-2.3815926535897933`, -0.8153147003663318}], 
   PointBox[{-2.371592653589793, -0.818546805649077}], 
   PointBox[{-2.361592653589793, -0.8218036846346501}], 
   PointBox[{-2.351592653589793, -0.8250856095615472}], 
   PointBox[{-2.3415926535897933`, -0.8283928563947592}], 
   PointBox[{-2.331592653589793, -0.8317257048822813}], 
   PointBox[{-2.321592653589793, -0.8350844386123885}], 
   PointBox[{-2.311592653589793, -0.8384693450716825}], 
   PointBox[{-2.3015926535897933`, -0.841880715703904}], 
   PointBox[{-2.291592653589793, -0.8453188459695111}], 
   PointBox[{-2.2815926535897932`, -0.8487840354060182}], 
   PointBox[{-2.271592653589793, -0.8522765876890962}], 
   PointBox[{-2.2615926535897932`, -0.8557968106944217}], 
   PointBox[{-2.251592653589793, -0.8593450165602758}], 
   PointBox[{-2.241592653589793, -0.8629215217508781}], 
   PointBox[{-2.231592653589793, -0.8665266471204509}], 
   PointBox[{-2.221592653589793, -0.8701607179779985}], 
   PointBox[{-2.211592653589793, -0.8738240641527936}], 
   PointBox[{-2.201592653589793, -0.8775170200605491}], 
   PointBox[{-2.191592653589793, -0.8812399247702661}], 
   PointBox[{-2.181592653589793, -0.884993122071732}], 
   PointBox[{-2.1715926535897934`, -0.8887769605436521}], 
   PointBox[{-2.161592653589793, -0.8925917936223886}], 
   PointBox[{-2.151592653589793, -0.8964379796712801}], 
   PointBox[{-2.141592653589793, -0.9003158820505147}], 
   PointBox[{-2.1315926535897933`, -0.9042258691875199}], 
   PointBox[{-2.121592653589793, -0.9081683146478378}], 
   PointBox[{-2.111592653589793, -0.9121435972064424}], 
   PointBox[{-2.101592653589793, -0.9161521009194589}], 
   PointBox[{-2.0915926535897933`, -0.9201942151962355}], 
   PointBox[{-2.081592653589793, -0.9242703348717175}], 
   PointBox[{-2.071592653589793, -0.9283808602790651}], 
   PointBox[{-2.061592653589793, -0.9325261973224575}], 
   PointBox[{-2.0515926535897933`, -0.9367067575500132}], 
   PointBox[{-2.041592653589793, -0.9409229582267558}], 
   PointBox[{-2.031592653589793, -0.9451752224075451}], 
   PointBox[{-2.021592653589793, -0.9494639790098931}], 
   PointBox[{-2.0115926535897932`, -0.9537896628865663}], 
   PointBox[{-2.001592653589793, -0.9581527148978808}], 
   PointBox[{-1.991592653589793, -0.9625535819835789}], 
   PointBox[{-1.9815926535897932`, -0.9669927172341736}], 
   PointBox[{-1.9715926535897932`, -0.9714705799616357}], 
   PointBox[{-1.9615926535897932`, -0.9759876357692853}], 
   PointBox[{-1.9515926535897932`, -0.9805443566207485}], 
   PointBox[{-1.9415926535897932`, -0.9851412209078164}], 
   PointBox[{-1.9315926535897932`, -0.9897787135170439}], 
   PointBox[{-1.9215926535897931`, -0.9944573258949002}], 
   PointBox[{-1.9115926535897931`, -0.9991775561112839}], 
   PointBox[{-1.9015926535897931`, -1.0039399089211867`}], 
   PointBox[{-1.8915926535897931`, -1.0087448958242837`}], 
   PointBox[{-1.881592653589793, -1.0135930351222082`}], 
   PointBox[{-1.871592653589793, -1.0184848519732494`}], 
   PointBox[{-1.861592653589793, -1.0234208784441974`}], 
   PointBox[{-1.851592653589793, -1.0284016535590308`}], 
   PointBox[{-1.841592653589793, -1.0334277233441316`}], 
   PointBox[{-1.831592653589793, -1.0384996408696785`}], 
   PointBox[{-1.821592653589793, -1.0436179662868486`}], 
   PointBox[{-1.811592653589793, -1.048783266860433}], 
   PointBox[{-1.801592653589793, -1.05399611699644}], 
   PointBox[{-1.791592653589793, -1.059257098264226}], 
   PointBox[{-1.781592653589793, -1.0645667994126713`}], 
   PointBox[{-1.771592653589793, -1.0699258163798702`}], 
   PointBox[{-1.761592653589793, -1.0753347522957746`}], 
   PointBox[{-1.751592653589793, -1.0807942174771914`}], 
   PointBox[{-1.741592653589793, -1.0863048294144804`}], 
   PointBox[{-1.7315926535897932`, -1.0918672127492672`}], 
   PointBox[{-1.7215926535897932`, -1.0974819992424227`}], 
   PointBox[{-1.7115926535897932`, -1.1031498277315166`}], 
   PointBox[{-1.7015926535897932`, -1.1088713440768878`}], 
   PointBox[{-1.6915926535897932`, -1.1146472010954216`}], 
   PointBox[{-1.6815926535897932`, -1.1204780584810479`}], 
   PointBox[{-1.6715926535897931`, -1.1263645827109126`}], 
   PointBox[{-1.6615926535897931`, -1.1323074469360928`}], 
   PointBox[{-1.6515926535897931`, -1.1383073308556484`}], 
   PointBox[{-1.6415926535897931`, -1.1443649205727144`}], 
   PointBox[{-1.631592653589793, -1.1504809084312415`}], 
   PointBox[{-1.621592653589793, -1.1566559928318998`}], 
   PointBox[{-1.611592653589793, -1.162890878025541}], 
   PointBox[{-1.601592653589793, -1.1691862738825098`}], 
   PointBox[{-1.591592653589793, -1.1755428956359628`}], 
   PointBox[{-1.581592653589793, -1.1819614635972195`}], 
   PointBox[{-1.571592653589793, -1.188442702841031}], 
   PointBox[{-1.561592653589793, -1.1949873428584912`}], 
   PointBox[{-1.551592653589793, -1.2015961171751508`}], 
   PointBox[{-1.541592653589793, -1.208269762931717}], 
   PointBox[{-1.531592653589793, -1.215009020424519}], 
   PointBox[{-1.521592653589793, -1.2218146326027313`}], 
   PointBox[{-1.511592653589793, -1.2286873445190956`}], 
   PointBox[{-1.501592653589793, -1.2356279027306658`}], 
   PointBox[{-1.491592653589793, -1.242637054645825}], 
   PointBox[{-1.481592653589793, -1.2497155478135487`}], 
   PointBox[{-1.4715926535897932`, -1.2568641291505864`}], 
   PointBox[{-1.4615926535897932`, -1.264083544101908}], 
   PointBox[{-1.4515926535897932`, -1.271374535729403}], 
   PointBox[{-1.4415926535897932`, -1.278737843723456}], 
   PointBox[{-1.4315926535897932`, -1.2861742033315946`}], 
   PointBox[{-1.4215926535897931`, -1.293684344197978}], 
   PointBox[{-1.4115926535897931`, -1.3012689891070062`}], 
   PointBox[{-1.4015926535897931`, -1.3089288526238223`}], 
   PointBox[{-1.3915926535897931`, -1.3166646396239121`}], 
   PointBox[{-1.381592653589793, -1.3244770437034137`}], 
   PointBox[{-1.371592653589793, -1.3323667454610841`}], 
   PointBox[{-1.361592653589793, -1.3403344106421728`}], 
   PointBox[{-1.351592653589793, -1.3483806881336826`}], 
   PointBox[{-1.341592653589793, -1.3565062077996708`}], 
   PointBox[{-1.331592653589793, -1.364711578144345}], 
   PointBox[{-1.321592653589793, -1.3729973837897387`}], 
   PointBox[{-1.311592653589793, -1.3813641827536918`}], 
   PointBox[{-1.301592653589793, -1.3898125035127207`}], 
   PointBox[{-1.291592653589793, -1.3983428418331239`}], 
   PointBox[{-1.281592653589793, -1.4069556573523136`}], 
   PointBox[{-1.271592653589793, -1.4156513698909112`}], 
   PointBox[{-1.261592653589793, -1.4244303554745454`}], 
   PointBox[{-1.251592653589793, -1.433292942042572}], 
   PointBox[{-1.241592653589793, -1.4422394048190526`}], 
   PointBox[{-1.231592653589793, -1.4512699613192857`}], 
   PointBox[{-1.2215926535897932`, -1.4603847659629647`}], 
   PointBox[{-1.2115926535897932`, -1.4695839042626113`}], 
   PointBox[{-1.2015926535897932`, -1.478867386553303}], 
   PointBox[{-1.1915926535897932`, -1.488235141226839}], 
   PointBox[{-1.1815926535897932`, -1.4976870074303548`}], 
   PointBox[{-1.1715926535897931`, -1.5072227271859866`}], 
   PointBox[{-1.1615926535897931`, -1.5168419368844606`}], 
   PointBox[{-1.1515926535897931`, -1.5265441581014092`}], 
   PointBox[{-1.1415926535897931`, -1.536328787680789}], 
   PointBox[{-1.1315926535897929`, -1.5461950870249077`}], 
   PointBox[{-1.121592653589793, -1.5561421705252763`}], 
   PointBox[{-1.1115926535897929`, -1.5661689930627039`}], 
   PointBox[{-1.101592653589793, -1.5762743364986944`}], 
   PointBox[{-1.0915926535897933`, -1.5864567950732824`}], 
   PointBox[{-1.081592653589793, -1.5967147596168196`}], 
   PointBox[{-1.0715926535897933`, -1.6070464004749079`}], 
   PointBox[{-1.061592653589793, -1.6174496490365426`}], 
   PointBox[{-1.0515926535897933`, -1.6279221777455049`}], 
   PointBox[{-1.041592653589793, -1.6384613784640816`}], 
   PointBox[{-1.0315926535897932`, -1.6490643390461135`}], 
   PointBox[{-1.021592653589793, -1.6597278179631567`}], 
   PointBox[{-1.0115926535897932`, -1.6704482168129875`}], 
   PointBox[{-1.001592653589793, -1.6812215505237196`}], 
   PointBox[{-0.9915926535897932, -1.6920434150492225`}], 
   PointBox[{-0.981592653589793, -1.7029089523322285`}], 
   PointBox[{-0.9715926535897932, -1.7138128122902394`}], 
   PointBox[{-0.961592653589793, -1.7247491115559785`}], 
   PointBox[{-0.9515926535897932, -1.7357113886783415`}], 
   PointBox[{-0.9415926535897929, -1.7466925554614592`}], 
   PointBox[{-0.9315926535897932, -1.7576848440882038`}], 
   PointBox[{-0.9215926535897929, -1.7686797496400386`}], 
   PointBox[{-0.9115926535897931, -1.7796679675871163`}], 
   PointBox[{-0.9015926535897929, -1.7906393257806859`}], 
   PointBox[{-0.8915926535897931, -1.801582710433659}], 
   PointBox[{-0.8815926535897929, -1.8124859855243007`}], 
   PointBox[{-0.8715926535897931, -1.8233359050017877`}], 
   PointBox[{-0.8615926535897929, -1.8341180171104718`}], 
   PointBox[{-0.8515926535897931, -1.8448165600812965`}], 
   PointBox[{-0.8415926535897928, -1.8554143483634986`}], 
   PointBox[{-0.8315926535897931, -1.865892648486611}], 
   PointBox[{-0.8215926535897933, -1.8762310435512384`}], 
   PointBox[{-0.811592653589793, -1.886407285246188}], 
   PointBox[{-0.8015926535897933, -1.8963971321785134`}], 
   PointBox[{-0.791592653589793, -1.9061741731808861`}], 
   PointBox[{-0.7815926535897932, -1.915709634126478}], 
   PointBox[{-0.771592653589793, -1.924972166634282}], 
   PointBox[{-0.7615926535897932, -1.9339276168863755`}], 
   PointBox[{-0.751592653589793, -1.942538772602184}], 
   PointBox[{-0.7415926535897932, -1.950765086022213}], 
   PointBox[{-0.731592653589793, -1.958562370544288}], 
   PointBox[{-0.7215926535897932, -1.965882468428251}], 
   PointBox[{-0.711592653589793, -1.9726728867400372`}], 
   PointBox[{-0.7015926535897932, -1.9788763984429818`}], 
   PointBox[{-0.6915926535897929, -1.9844306052637941`}], 
   PointBox[{-0.6815926535897932, -1.989267458664196}], 
   PointBox[{-0.6715926535897929, -1.9933127349394297`}], 
   PointBox[{-0.6615926535897931, -1.9964854601457045`}], 
   PointBox[{-0.6515926535897929, -1.9986972802365226`}], 
   PointBox[{-0.6415926535897931, -1.9998517714716786`}], 
   PointBox[{-0.6315926535897929, -1.9998436858654995`}], 
   PointBox[{-0.6215926535897931, -1.9985581261804366`}], 
   PointBox[{-0.6115926535897929, -1.995869644773071}], 
   PointBox[{-0.6015926535897931, -1.9916412604953693`}], 
   PointBox[{-0.5915926535897928, -1.9857233878897285`}], 
   PointBox[{-0.5815926535897931, -1.9779526731525234`}], 
   PointBox[{-0.5715926535897933, -1.9681507318582117`}], 
   PointBox[{-0.561592653589793, -1.9561227843420579`}], 
   PointBox[{-0.5515926535897933, -1.9416561860766146`}], 
   PointBox[{-0.541592653589793, -1.9245188525338315`}], 
   PointBox[{-0.5315926535897932, -1.9044575811502207`}], 
   PointBox[{-0.521592653589793, -1.8811962774355502`}], 
   PointBox[{-0.5115926535897932, -1.8544340984196315`}], 
   PointBox[{-0.501592653589793, -1.8238435350876898`}], 
   PointBox[{-0.4915926535897932, -1.7890684669645602`}], 
   PointBox[{-0.481592653589793, -1.7497222375604915`}], 
   PointBox[{-0.4715926535897932, -1.7053858202881784`}], 
   PointBox[{-0.46159265358979296`, -1.6556061724116917`}], 
   PointBox[{-0.45159265358979317`, -1.599894911839948}], 
   PointBox[{-0.44159265358979294`, -1.537727501076865}], 
   PointBox[{-0.43159265358979315`, -1.4685431882478466`}], 
   PointBox[{-0.4215926535897929, -1.3917460418818388`}], 
   PointBox[{-0.41159265358979313`, -1.3067075306119036`}], 
   PointBox[{-0.4015926535897929, -1.2127712496864442`}], 
   PointBox[{-0.3915926535897931, -1.109260594140232}], 
   PointBox[{-0.3815926535897929, -0.9954904376828901}], 
   PointBox[{-0.3715926535897931, -0.8707842145050668}], 
   PointBox[{-0.36159265358979287`, -0.7344982401539857}], 
   PointBox[{-0.3515926535897931, -0.5860556736924495}], 
   PointBox[{-0.34159265358979285`, -0.42499324672163535`}], 
   PointBox[{-0.33159265358979306`, -0.25102479744833955`}], 
   PointBox[{-0.3215926535897933, -0.06412677808687244}], 
   PointBox[{-0.31159265358979304`, 0.1353477353849564}], 
   PointBox[{-0.30159265358979326`, 0.34651843564114615`}], 
   PointBox[{-0.291592653589793, 0.5677808171377764}], 
   PointBox[{-0.28159265358979324`, 0.7965515902486145}], 
   PointBox[{-0.271592653589793, 1.028944458111129}], 
   PointBox[{-0.2615926535897932, 1.2593653493879247`}], 
   PointBox[{-0.251592653589793, 1.4800213105414166`}], 
   PointBox[{-0.2415926535897932, 1.6803502427854267`}], 
   PointBox[{-0.23159265358979297`, 1.8464063596033777`}], 
   PointBox[{-0.2215926535897932, 1.9602903500961415`}], 
   PointBox[{-0.21159265358979296`, 1.9998130513967354`}], 
   PointBox[{-0.20159265358979317`, 1.9387569405255805`}], 
   PointBox[{-0.19159265358979294`, 1.7483929093480703`}], 
   PointBox[{-0.18159265358979315`, 1.4013663833809658`}], 
   PointBox[{-0.17159265358979292`, 0.8796970260174892}], 
   PointBox[{-0.16159265358979313`, 0.18928660587013985`}], 
   PointBox[{-0.1515926535897929, -0.6166665201022588}], 
   PointBox[{-0.14159265358979312`, -1.4056030513115432`}], 
   PointBox[{-0.13159265358979289`, -1.935440948594362}], 
   PointBox[{-0.1215926535897931, -1.8645104152710774`}], 
   PointBox[{-0.11159265358979287`, -0.8943681210547733}], 
   PointBox[{-0.10159265358979308`, 0.8126956760101163}], 
   PointBox[{-0.09159265358979285, 1.9939706991320856`}], 
   PointBox[{-0.08159265358979306, 0.6108129139198437}], 
   PointBox[{-0.07159265358979283, -1.9714216285655397`}], 
   PointBox[{-0.061592653589793045`, 1.0071628924373}], 
   PointBox[{-0.05159265358979326, -1.0163226581634548`}], 
   PointBox[{-0.04159265358979303, 1.7732851239948257`}], 
   PointBox[{-0.03159265358979324, -0.4695785926495873}], 
   PointBox[{-0.02159265358979301, -1.4511123374791604`}], 
   PointBox[{-0.011592653589793223`, 1.9825298681648371`}], 
   PointBox[{-0.0015926535897929917`, 0.8439129682170385}], 
   PointBox[{0.008407346410206795, -0.8463135924718367}], 
   PointBox[{0.018407346410207026`, -1.5900643785419624`}], 
   PointBox[{0.028407346410206813`, -1.2018253593789932`}], 
   PointBox[{0.038407346410207044`, 1.571545237038979}], 
   PointBox[{0.04840734641020683, 1.9437787502289336`}], 
   PointBox[{0.05840734641020706, -1.9752055481809707`}], 
   PointBox[{0.06840734641020685, 1.7729302464603316`}], 
   PointBox[{0.07840734641020708, 0.37287798304942094`}], 
   PointBox[{0.08840734641020687, -1.9011567527662223`}], 
   PointBox[{0.0984073464102071, -1.3442352044583399`}], 
   PointBox[{0.10840734641020688`, 0.3979479773782495}], 
   PointBox[{0.11840734641020711`, 1.66027698629952}], 
   PointBox[{0.1284073464102069, 1.9956105278892056`}], 
   PointBox[{0.13840734641020713`, 1.617312954046735}], 
   PointBox[{0.14840734641020692`, 0.8789706148161388}], 
   PointBox[{0.15840734641020715`, 0.05929775637862495}], 
   PointBox[{0.16840734641020694`, -0.6767736669361173}], 
   PointBox[{0.17840734641020717`, -1.254527696127484}], 
   PointBox[{0.18840734641020696`, -1.6560058347056794`}], 
   PointBox[{0.19840734641020674`, -1.8935400391605481`}], 
   PointBox[{0.20840734641020697`, -1.9926246341020204`}], 
   PointBox[{0.21840734641020676`, -1.9821273432471453`}], 
   PointBox[{0.228407346410207, -1.8893158077456156`}], 
   PointBox[{0.23840734641020678`, -1.7377339387680903`}], 
   PointBox[{0.248407346410207, -1.5466300628642031`}], 
   PointBox[{0.2584073464102068, -1.3311535463239998`}], 
   PointBox[{0.268407346410207, -1.102877255439297}], 
   PointBox[{0.2784073464102068, -0.8704111332476279}], 
   PointBox[{0.28840734641020704`, -0.6399922618414313}], 
   PointBox[{0.29840734641020683`, -0.41600290525541594`}], 
   PointBox[{0.30840734641020706`, -0.20140256288992012`}], 
   PointBox[{0.31840734641020685`, 0.00192319861706779}], 
   PointBox[{0.3284073464102071, 0.1928872813057634}], 
   PointBox[{0.33840734641020687`, 0.37098701622352864`}], 
   PointBox[{0.3484073464102071, 0.5361399269488313}], 
   PointBox[{0.3584073464102069, 0.6885590200215288}], 
   PointBox[{0.3684073464102071, 0.828658978421514}], 
   PointBox[{0.3784073464102069, 0.9569862495539682}], 
   PointBox[{0.38840734641020713`, 1.0741674509156498`}], 
   PointBox[{0.3984073464102069, 1.180871719975432}], 
   PointBox[{0.40840734641020715`, 1.2777836140320753`}], 
   PointBox[{0.41840734641020694`, 1.365583946014372}], 
   PointBox[{0.42840734641020717`, 1.4449365549329312`}], 
   PointBox[{0.43840734641020696`, 1.5164794860714805`}], 
   PointBox[{0.44840734641020674`, 1.5808194236736812`}], 
   PointBox[{0.458407346410207, 1.638528501122819}], 
   PointBox[{0.46840734641020676`, 1.690142829394926}], 
   PointBox[{0.478407346410207, 1.7361622490138287`}], 
   PointBox[{0.4884073464102068, 1.7770509357342459`}], 
   PointBox[{0.498407346410207, 1.8132385849728045`}], 
   PointBox[{0.5084073464102068, 1.8451219717390097`}], 
   PointBox[{0.518407346410207, 1.873066736979363}], 
   PointBox[{0.5284073464102068, 1.8974092920422057`}], 
   PointBox[{0.538407346410207, 1.918458763611167}], 
   PointBox[{0.5484073464102068, 1.9364989243904462`}], 
   PointBox[{0.5584073464102071, 1.9517900719215922`}], 
   PointBox[{0.5684073464102068, 1.964570830588285}], 
   PointBox[{0.5784073464102071, 1.975059861202734}], 
   PointBox[{0.5884073464102069, 1.983457469384911}], 
   PointBox[{0.5984073464102071, 1.9899471088674785`}], 
   PointBox[{0.6084073464102069, 1.994696779357966}], 
   PointBox[{0.6184073464102071, 1.9978603210247021`}], 
   PointBox[{0.6284073464102069, 1.9995786093162788`}], 
   PointBox[{0.6384073464102071, 1.9999806548820833`}], 
   PointBox[{0.6484073464102069, 1.999184613989439}], 
   PointBox[{0.6584073464102072, 1.9972987151487347`}], 
   PointBox[{0.6684073464102069, 1.9944221077500601`}], 
   PointBox[{0.6784073464102072, 1.9906456384496642`}], 
   PointBox[{0.688407346410207, 1.9860525608715864`}], 
   PointBox[{0.6984073464102067, 1.9807191839458702`}], 
   PointBox[{0.708407346410207, 1.9747154639170312`}], 
   PointBox[{0.7184073464102068, 1.9681055447447282`}], 
   PointBox[{0.728407346410207, 1.9609482512971987`}], 
   PointBox[{0.7384073464102068, 1.9532975394171699`}], 
   PointBox[{0.748407346410207, 1.9452029066266123`}], 
   PointBox[{0.7584073464102068, 1.9367097669357027`}], 
   PointBox[{0.768407346410207, 1.927859792935614}], 
   PointBox[{0.7784073464102068, 1.918691228086081}], 
   PointBox[{0.788407346410207, 1.9092391718578618`}], 
   PointBox[{0.7984073464102068, 1.899535840157478}], 
   PointBox[{0.8084073464102071, 1.889610803246575}], 
   PointBox[{0.8184073464102068, 1.8794912031704323`}], 
   PointBox[{0.8284073464102071, 1.869201952528611}], 
   PointBox[{0.8384073464102069, 1.8587659162546726`}], 
   PointBox[{0.8484073464102071, 1.8482040779202067`}], 
   PointBox[{0.8584073464102069, 1.8375356919401635`}], 
   PointBox[{0.8684073464102067, 1.8267784229305815`}], 
   PointBox[{0.8784073464102073, 1.8159484733553517`}], 
   PointBox[{0.8884073464102071, 1.8050607004946346`}], 
   PointBox[{0.8984073464102069, 1.7941287236730978`}], 
   PointBox[{0.9084073464102067, 1.7831650226004716`}], 
   PointBox[{0.9184073464102074, 1.7721810275991456`}], 
   PointBox[{0.9284073464102072, 1.7611872024230502`}], 
   PointBox[{0.938407346410207, 1.7501931203081227`}], 
   PointBox[{0.9484073464102067, 1.7392075338367305`}], 
   PointBox[{0.9584073464102065, 1.7282384391458532`}], 
   PointBox[{0.9684073464102072, 1.7172931349612013`}], 
   PointBox[{0.978407346410207, 1.7063782768962608`}], 
   PointBox[{0.9884073464102068, 1.6954999274160476`}], 
   PointBox[{0.9984073464102066, 1.6846636018298673`}], 
   PointBox[{1.0084073464102072`, 1.6738743106450926`}], 
   PointBox[{1.018407346410207, 1.663136598584739}], 
   PointBox[{1.0284073464102068`, 1.652454580545036}], 
   PointBox[{1.0384073464102066`, 1.6418319747450905`}], 
   PointBox[{1.0484073464102073`, 1.6312721332988107`}], 
   PointBox[{1.058407346410207, 1.6207780704193473`}], 
   PointBox[{1.0684073464102068`, 1.6103524884482014`}], 
   PointBox[{1.0784073464102066`, 1.5999978018847016`}], 
   PointBox[{1.0884073464102073`, 1.5897161595765399`}], 
   PointBox[{1.098407346410207, 1.5795094652184536`}], 
   PointBox[{1.1084073464102069`, 1.569379396293687}], 
   PointBox[{1.1184073464102067`, 1.5593274215815907`}], 
   PointBox[{1.1284073464102073`, 1.5493548173443747`}], 
   PointBox[{1.1384073464102071`, 1.5394626822966515`}], 
   PointBox[{1.148407346410207, 1.5296519514528046`}], 
   PointBox[{1.1584073464102067`, 1.5199234089394227`}], 
   PointBox[{1.1684073464102074`, 1.5102776998528602`}], 
   PointBox[{1.1784073464102072`, 1.5007153412354794`}], 
   PointBox[{1.188407346410207, 1.49123673223814}], 
   PointBox[{1.1984073464102067`, 1.4818421635310743`}], 
   PointBox[{1.2084073464102074`, 1.4725318260202707`}], 
   PointBox[{1.2184073464102072`, 1.4633058189219328`}], 
   PointBox[{1.228407346410207, 1.454164157243393}], 
   PointBox[{1.2384073464102068`, 1.445106778715042}], 
   PointBox[{1.2484073464102066`, 1.4361335502143084`}], 
   PointBox[{1.2584073464102072`, 1.4272442737195152`}], 
   PointBox[{1.268407346410207, 1.4184386918284895`}], 
   PointBox[{1.2784073464102068`, 1.4097164928740777`}], 
   PointBox[{1.2884073464102066`, 1.401077315666256}], 
   PointBox[{1.2984073464102073`, 1.3925207538882203`}], 
   PointBox[{1.308407346410207, 1.3840463601717559`}], 
   PointBox[{1.3184073464102068`, 1.3756536498752423`}], 
   PointBox[{1.3284073464102066`, 1.367342104585897}], 
   PointBox[{1.3384073464102073`, 1.3591111753662088`}], 
   PointBox[{1.348407346410207, 1.3509602857630254`}], 
   PointBox[{1.3584073464102069`, 1.3428888345963552`}], 
   PointBox[{1.3684073464102067`, 1.3348961985437051`}], 
   PointBox[{1.3784073464102073`, 1.3269817345345587`}], 
   PointBox[{1.3884073464102071`, 1.3191447819685596`}], 
   PointBox[{1.398407346410207, 1.3113846647699239`}], 
   PointBox[{1.4084073464102067`, 1.3037006932897282`}], 
   PointBox[{1.4184073464102074`, 1.2960921660668334`}], 
   PointBox[{1.4284073464102072`, 1.288558371457447}], 
   PointBox[{1.438407346410207, 1.2810985891425721`}], 
   PointBox[{1.4484073464102067`, 1.2737120915219642`}], 
   PointBox[{1.4584073464102074`, 1.26639814500255}], 
   PointBox[{1.4684073464102072`, 1.2591560111887303`}], 
   PointBox[{1.478407346410207, 1.2519849479814287`}], 
   PointBox[{1.4884073464102068`, 1.2448842105922853`}], 
   PointBox[{1.4984073464102066`, 1.2378530524789186`}], 
   PointBox[{1.5084073464102072`, 1.2308907262067712`}], 
   PointBox[{1.518407346410207, 1.223996484242667}], 
   PointBox[{1.5284073464102068`, 1.2171695796848345`}], 
   PointBox[{1.5384073464102066`, 1.210409266933837}], 
   PointBox[{1.5484073464102073`, 1.2037148023085222`}], 
   PointBox[{1.558407346410207, 1.1970854446108286`}], 
   PointBox[{1.5684073464102068`, 1.1905204556430111`}], 
   PointBox[{1.5784073464102066`, 1.184019100680611}], 
   PointBox[{1.5884073464102073`, 1.177580648904257}], 
   PointBox[{1.598407346410207, 1.1712043737931777`}], 
   PointBox[{1.6084073464102069`, 1.1648895534830983`}], 
   PointBox[{1.6184073464102067`, 1.1586354710910263`}], 
   PointBox[{1.6284073464102073`, 1.152441415009244}], 
   PointBox[{1.6384073464102071`, 1.1463066791706795`}], 
   PointBox[{1.648407346410207, 1.1402305632876675`}], 
   PointBox[{1.6584073464102067`, 1.1342123730659872`}], 
   PointBox[{1.6684073464102074`, 1.1282514203959297`}], 
   PointBox[{1.6784073464102072`, 1.1223470235220283`}], 
   PointBox[{1.688407346410207, 1.1164985071929718`}], 
   PointBox[{1.6984073464102067`, 1.1107052027931312`}], 
   PointBox[{1.7084073464102074`, 1.104966448457016}], 
   PointBox[{1.7184073464102072`, 1.0992815891679015`}], 
   PointBox[{1.728407346410207, 1.093649976841774}], 
   PointBox[{1.7384073464102068`, 1.0880709703976754`}], 
   PointBox[{1.7484073464102066`, 1.0825439358154458`}], 
   PointBox[{1.7584073464102072`, 1.0770682461818}], 
   PointBox[{1.768407346410207, 1.071643281725613}], 
   PointBox[{1.7784073464102068`, 1.0662684298432228`}], 
   PointBox[{1.7884073464102066`, 1.0609430851145183`}], 
   PointBox[{1.7984073464102073`, 1.0556666493105111`}], 
   PointBox[{1.808407346410207, 1.050438531393064}], 
   PointBox[{1.8184073464102068`, 1.0452581475073783`}], 
   PointBox[{1.8284073464102066`, 1.040124920967827}], 
   PointBox[{1.8384073464102073`, 1.0350382822376665`}], 
   PointBox[{1.848407346410207, 1.029997668903125}], 
   PointBox[{1.8584073464102069`, 1.0250025256423354`}], 
   PointBox[{1.8684073464102067`, 1.0200523041895502`}], 
   PointBox[{1.8784073464102073`, 1.0151464632950415`}], 
   PointBox[{1.8884073464102071`, 1.010284468681068}], 
   PointBox[{1.898407346410207, 1.0054657929942525`}], 
   PointBox[{1.9084073464102067`, 1.0006899157547122`}], 
   PointBox[{1.9184073464102074`, 0.995956323302238}], 
   PointBox[{1.9284073464102072`, 0.9912645087398124}], 
   PointBox[{1.938407346410207, 0.9866139718747272}], 
   PointBox[{1.9484073464102067`, 0.9820042191575568}], 
   PointBox[{1.9584073464102074`, 0.977434763619209}], 
   PointBox[{1.9684073464102072`, 0.9729051248062748}], 
   PointBox[{1.978407346410207, 0.9684148287148681}], 
   PointBox[{1.9884073464102068`, 0.9639634077231507}], 
   PointBox[{1.9984073464102066`, 0.9595504005227081}], 
   PointBox[{2.0084073464102072`, 0.9551753520489384}], 
   PointBox[{2.018407346410207, 0.950837813410605}], 
   PointBox[{2.028407346410207, 0.9465373418186857}], 
   PointBox[{2.0384073464102066`, 0.9422735005146535}], 
   PointBox[{2.0484073464102073`, 0.9380458586983029}], 
   PointBox[{2.058407346410207, 0.9338539914552342}], 
   PointBox[{2.068407346410207, 0.9296974796840948}], 
   PointBox[{2.0784073464102066`, 0.9255759100236757}], 
   PointBox[{2.0884073464102073`, 0.9214888747799473}], 
   PointBox[{2.098407346410207, 0.9174359718531179}], 
   PointBox[{2.108407346410207, 0.9134168046647833}], 
   PointBox[{2.1184073464102067`, 0.909430982085244}], 
   PointBox[{2.1284073464102073`, 0.9054781183610462}], 
   PointBox[{2.138407346410207, 0.9015578330428096}], 
   PointBox[{2.148407346410207, 0.8976697509133879}], 
   PointBox[{2.1584073464102067`, 0.8938135019164205}], 
   PointBox[{2.1684073464102074`, 0.8899887210853117}], 
   PointBox[{2.178407346410207, 0.8861950484726822}], 
   PointBox[{2.188407346410207, 0.8824321290803264}], 
   PointBox[{2.1984073464102067`, 0.8786996127897154}], 
   PointBox[{2.2084073464102074`, 0.8749971542930677}], 
   PointBox[{2.218407346410207, 0.8713244130250244}], 
   PointBox[{2.228407346410207, 0.8676810530949433}], 
   PointBox[{2.2384073464102068`, 0.8640667432198443}], 
   PointBox[{2.2484073464102066`, 0.8604811566580195}], 
   PointBox[{2.2584073464102072`, 0.8569239711433257}], 
   PointBox[{2.268407346410207, 0.8533948688201813}], 
   PointBox[{2.278407346410207, 0.8498935361792694}], 
   PointBox[{2.2884073464102066`, 0.8464196639939721}], 
   PointBox[{2.2984073464102073`, 0.8429729472575361}], 
   PointBox[{2.308407346410207, 0.839553085120985}], 
   PointBox[{2.318407346410207, 0.836159780831778}], 
   PointBox[{2.3284073464102066`, 0.8327927416732291}], 
   PointBox[{2.3384073464102073`, 0.8294516789046862}], 
   PointBox[{2.348407346410207, 0.8261363077024739}], 
   PointBox[{2.358407346410207, 0.8228463471016033}], 
   PointBox[{2.3684073464102067`, 0.8195815199382502}], 
   PointBox[{2.3784073464102073`, 0.8163415527930016}], 
   PointBox[{2.388407346410207, 0.813126175934871}], 
   PointBox[{2.398407346410207, 0.8099351232660786}], 
   PointBox[{2.4084073464102067`, 0.806768132267598}], 
   PointBox[{2.4184073464102074`, 0.8036249439454641}], 
   PointBox[{2.428407346410207, 0.8005053027778423}], 
   PointBox[{2.438407346410207, 0.7974089566628485}], 
   PointBox[{2.4484073464102067`, 0.7943356568671244}], 
   PointBox[{2.4584073464102074`, 0.7912851579751563}], 
   PointBox[{2.468407346410207, 0.7882572178393373}], 
   PointBox[{2.478407346410207, 0.7852515975307607}], 
   PointBox[{2.4884073464102068`, 0.7822680612907479}], 
   PointBox[{2.4984073464102066`, 0.7793063764830951}], 
   PointBox[{2.5084073464102072`, 0.7763663135470397}], 
   PointBox[{2.518407346410207, 0.7734476459509351}], 
   PointBox[{2.528407346410207, 0.7705501501466275}], 
   PointBox[{2.5384073464102066`, 0.7676736055245298}], 
   PointBox[{2.5484073464102073`, 0.7648177943693822}], 
   PointBox[{2.558407346410207, 0.7619825018166947}], 
   PointBox[{2.568407346410207, 0.7591675158098594}], 
   PointBox[{2.5784073464102066`, 0.7563726270579314}], 
   PointBox[{2.5884073464102073`, 0.7535976289940628}], 
   PointBox[{2.598407346410207, 0.7508423177345888}], 
   PointBox[{2.608407346410207, 0.7481064920387508}], 
   PointBox[{2.6184073464102067`, 0.7453899532690552}], 
   PointBox[{2.6284073464102073`, 0.7426925053522535}], 
   PointBox[{2.638407346410207, 0.7400139547409413}], 
   PointBox[{2.648407346410207, 0.737354110375761}], 
   PointBox[{2.6584073464102067`, 0.7347127836482069}], 
   PointBox[{2.6684073464102074`, 0.7320897883640195}], 
   PointBox[{2.678407346410207, 0.7294849407071636}], 
   PointBox[{2.688407346410207, 0.7268980592043787}], 
   PointBox[{2.6984073464102067`, 0.7243289646902973}], 
   PointBox[{2.7084073464102074`, 0.7217774802731202}], 
   PointBox[{2.718407346410207, 0.7192434313008415}], 
   PointBox[{2.728407346410207, 0.7167266453280141}], 
   PointBox[{2.7384073464102068`, 0.71422695208305}], 
   PointBox[{2.7484073464102066`, 0.7117441834360443}], 
   PointBox[{2.7584073464102072`, 0.7092781733671177}], 
   PointBox[{2.768407346410207, 0.7068287579352677}], 
   PointBox[{2.778407346410207, 0.7043957752477201}], 
   PointBox[{2.7884073464102066`, 0.7019790654297771}], 
   PointBox[{2.7984073464102073`, 0.6995784705951468}], 
   PointBox[{2.808407346410207, 0.6971938348167562}], 
   PointBox[{2.818407346410207, 0.6948250040980299}], 
   PointBox[{2.8284073464102066`, 0.6924718263446357}], 
   PointBox[{2.8384073464102073`, 0.6901341513366829}], 
   PointBox[{2.848407346410207, 0.6878118307013723}], 
   PointBox[{2.858407346410207, 0.6855047178860846}], 
   PointBox[{2.8684073464102067`, 0.6832126681319036}], 
   PointBox[{2.8784073464102073`, 0.6809355384475675}], 
   PointBox[{2.888407346410207, 0.6786731875838391}], 
   PointBox[{2.898407346410207, 0.6764254760082892}], 
   PointBox[{2.9084073464102067`, 0.6741922658804868}], 
   PointBox[{2.9184073464102074`, 0.671973421027588}], 
   PointBox[{2.928407346410207, 0.6697688069203203}], 
   PointBox[{2.938407346410207, 0.6675782906493498}], 
   PointBox[{2.9484073464102067`, 0.6654017409020315}], 
   PointBox[{2.9584073464102074`, 0.6632390279395322}], 
   PointBox[{2.968407346410207, 0.661090023574321}], 
   PointBox[{2.978407346410207, 0.6589546011480211}], 
   PointBox[{2.9884073464102068`, 0.6568326355096168}], 
   PointBox[{2.9984073464102075`, 0.6547240029940108}], 
   PointBox[{3.0084073464102072`, 0.652628581400924}], 
   PointBox[{3.018407346410207, 0.6505462499741326}], 
   PointBox[{3.028407346410207, 0.6484768893810388}], 
   PointBox[{3.0384073464102066`, 0.6464203816925669}], 
   PointBox[{3.0484073464102073`, 0.6443766103633793}], 
   PointBox[{3.058407346410207, 0.6423454602124112}], 
   PointBox[{3.068407346410207, 0.6403268174037106}], 
   PointBox[{3.0784073464102066`, 0.6383205694275877}], 
   PointBox[{3.0884073464102073`, 0.6363266050820613}], 
   PointBox[{3.098407346410207, 0.6343448144546009}], 
   PointBox[{3.108407346410207, 0.6323750889041578}], 
   PointBox[{3.1184073464102067`, 0.6304173210434811}], 
   PointBox[{3.1284073464102073`, 0.6284714047217138}], 
   PointBox[{3.138407346410207, 0.6265372350072635}]},
  Axes->Automatic]], "Output",
 CellChangeTimes->{{3.794329795696754*^9, 3.7943298021044416`*^9}, 
   3.79450644034839*^9, 3.7949462316561007`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"66d78989-7727-4211-a02c-51d751ad105b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaView", "[", "pts", "]"}]], "Input",
 CellChangeTimes->{3.794946239792268*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"1c823a29-4ea0-4474-9784-581a74ae20fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgPointSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject9877049971834881]], "Output",
 CellChangeTimes->{3.7949462405991545`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"6237a0b9-5cc0-48ee-94ed-78807b37fa0c"]
}, Open  ]],

Cell["\<\
Visualized several cuboids, and an additional cuboid with different surface \
color. \
\>", "MathCaption",ExpressionUUID->"b1aef2ed-b23e-4749-8cb2-6babfde6d253"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cub", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SurfaceColor", "[", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "1", ",", "0"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Cuboid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.25", ",", "0.25", ",", "0.25"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.75", ",", "0.75", ",", "0.75"}], "}"}]}], "]"}]}], 
      "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7943298167640486`*^9, 3.794329830364217*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"dbb3b284-e343-45c7-a13f-e92d96c19a70"],

Cell[BoxData[
 Graphics3DBox[{CuboidBox[{0, 0, 0}], CuboidBox[{0, 0, 1}], 
   CuboidBox[{0, 1, 1}], CuboidBox[{1, 1, 1}], 
   {RGBColor[0, 1, 0], Glow[], Specularity[], 
    CuboidBox[{1.25, 0.25, 0.25}, {1.75, 0.75, 0.75}]}}]], "Output",
 CellChangeTimes->{{3.794329821127079*^9, 3.7943298319220023`*^9}, 
   3.7949463490831213`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"8c47ea2e-ad82-4061-ba46-79d8e1c7e6d0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"JavaView", "[", "cub", "]"}], ";"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"afe6bf18-4163-428d-8576-73f79dbe712c"],

Cell["Visualize a color image as rectangular grid of cells.", "MathCaption",ExpressionUUID->"88f2627a-99bb-426e-bd03-316cceef8106"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rsa", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"RasterArray", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{".1", 
          RowBox[{"Mod", "[", 
           RowBox[{"i", ",", "j"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", "rsa", "]"}], ";"}]}], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"8f73c87f-5038-46c7-a944-a28c4a294b92"],

Cell[BoxData[
 TemplateBox[{
  "RasterArray", "obs", "\"RasterArray is obsolete. Translating to Raster.\"",
    2, 9, 2, 33092868442850417025, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.794946332694731*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"903f85aa-ff27-44c9-8637-3ee47db69751"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaView", "[", "rsa", "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"ec2d5b28-05d5-4a74-81b2-8b55c5a1d557"],

Cell[BoxData[
 TemplateBox[{
  "JavaView", "load", 
   "\"JavaView: loading failed, \
graphics=\\!\\(\\*RowBox[{\\\"\\\\\\\"Graphics[Raster[{{0, 0.2, 0.2, 0.2, \
0.2, 0.2, 0.2, 0.2, 0.2},\\\\\\\\n {0.1, 0, 0.30000000000000004, \
0.30000000000000004, 0.30000000000000004, 0.30000000000000004, \
0.30000000000000004, 0.30000000000000004, 0.30000000000000004},\\\\\\\\n {0, \
0.1, 0, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4},\\\\\\\\n \\\\\\\"\\\", \\\"\[Ellipsis]\
\\\", \\\"\\\\\\\"7000000000000001, 0.7000000000000001},\\\\\\\\n {0, 0.2, 0, \
0.30000000000000004, 0.2, 0.1, 0, 0.8, 0.8},\\\\\\\\n {0.1, 0, 0.1, 0.4, \
0.30000000000000004, 0.2, 0.1, 0, 0.9},\\\\\\\\n {0, 0.1, 0.2, 0, 0.4, \
0.30000000000000004, 0.2, 0.1, 0}},\\\\\\\\n ColorFunction -> Hue],\\\\\\\\n \
AspectRatio -> Automatic]\\\\\\\"\\\"}]\\)\"", 2, 11, 3, 33092868442850417025,
    "Local", "JavaView`RunThrough`JavaView"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.794946335481227*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"bb7b6747-3520-4ffa-b78b-ef54f6790942"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Simple examples of graphics options understood by JavaView", \
"Subsection",ExpressionUUID->"914f1760-cdaf-4e56-a905-fa95b2b86782"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " understands a large set of graphics options of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. A detailed list of graphics options is provided in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " user's guide."
}], "Text",ExpressionUUID->"8fa98783-cfec-4b8a-872d-4586c622578a"],

Cell[CellGroupData[{

Cell["Adjust the focus and viewing direction of the camera.", "MathCaption",ExpressionUUID->"ed7b391d-8e39-4c29-94ee-3a398fb9a501"],

Cell[BoxData[{
 RowBox[{"gp", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ViewCenter", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ViewVertical", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["JavaView",
    FontSlant->"Plain"], "[", "gp", "]"}], ";"}]}], "Input",
 CellChangeTimes->{3.636396145795495*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"ba4db28d-1fd6-451c-89ac-ad0dab49d888"]
}, Closed]],

Cell[CellGroupData[{

Cell["Position a few light sources for illumination.", "MathCaption",ExpressionUUID->"5d67e2b9-4443-4dd9-962e-2c71134f41da"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ls", " ", "=", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Directional\>\"", ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"1.", ",", "0.0", ",", "0.4"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.", ",", "0.", ",", "0."}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.0", ",", "1.", ",", "0.0"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.", ",", "2.", ",", "0."}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.0", ",", "0.0", ",", "1."}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.", ",", 
            RowBox[{"-", "2."}], ",", "0."}], "}"}]}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "ls", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JavaView", "[", "ls", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.636393758018217*^9, 3.636393796774704*^9, {3.6363940225833855`*^9, 
   3.636394038438616*^9}, {3.636394068574046*^9, 3.6363941204711647`*^9}, {
   3.6363942681041393`*^9, 3.6363942706709433`*^9}, {3.6363943368438854`*^9, 
   3.636394346702898*^9}, {3.6363944157518625`*^9, 3.6363945156307473`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"151975d0-f01d-4e06-b752-9aa6c2e6d52a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The option ",
 StyleBox["PlotRange", "MR"],
 " restricts the shown graphics to a box bounded in x,y and z direction."
}], "MathCaption",
 CellChangeTimes->{{3.7936156282205706`*^9, 
  3.793615646891714*^9}},ExpressionUUID->"43d720ab-2e1b-4d0f-b3ee-\
a54c55a93be6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pr", " ", "=", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<GreatStellatedDodecahedron\>\"", ",", "\"\<Faces\>\""}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"0.", ",", "2."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.7"}], ",", "0.5"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "pr", "]"}]}], "Input",
 CellChangeTimes->{{3.636393617703665*^9, 3.6363936318446445`*^9}, {
  3.6363937193987164`*^9, 3.6363937233517494`*^9}, {3.6363937819982214`*^9, 
  3.6363937861961985`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"f22a14bb-d176-4568-bb26-2e92cd1858d1"],

Cell[BoxData[
 RowBox[{"JavaView", "[", "pr", "]"}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"9cdaa875-2468-4da6-9078-0da3f3c9ceaa"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Multiple geometries in a JavaView display", "Subsection",ExpressionUUID->"5a4e698f-d462-4c01-8d98-158e826aaf4b"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " can display several graphics objects at once. The graphics objects may \
either be loaded at once, or one after another."
}], "Text",ExpressionUUID->"93841ec5-b6fb-4cd2-977a-c05f4d9924b6"],

Cell["Load two geometries at once.", "MathCaption",ExpressionUUID->"b103fe8d-5dff-4641-a03a-8e5f94917076"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dode", "=", 
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ico", "=", " ", 
   RowBox[{"PolyhedronData", "[", "\"\<Icosahedron\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.636393473118765*^9, 3.636393482993743*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"fa91d625-7232-4f07-a530-81b698ee49c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", 
  RowBox[{"{", 
   RowBox[{"dode", ",", "ico"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{3.794946560790388*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"a132be71-a91b-41a7-ae2b-83a210ee5a87"],

Cell[BoxData[
 TemplateBox[{
  "Java", "argx1", 
   "\"Method named \\!\\(\\*RowBox[{\\\"\\\\\\\"setAnimated\\\\\\\"\\\"}]\\) \
defined in class \
\\!\\(\\*RowBox[{\\\"\\\\\\\"jv.loader.PgLoader\\\\\\\"\\\"}]\\) was called \
with an incorrect number or type of arguments. The argument was \
\\!\\(\\*RowBox[{\\\"JavaView`JLink`Private`animation\\\"}]\\).\"", 2, 24, 4, 
   33092868442850417025, "Local", "JLink`Java"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.794946561318347*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"80788bc9-fffc-4dbf-84c6-a8b490eff69f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Removed", "[", "\<\"JavaObject25895850177724417\"\>", "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"Removed", "[", "\<\"JavaObject33437609896181761\"\>", "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.7949465615778146`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"e8e2bc71-8331-430f-bbe0-3f117a449c48"]
}, Open  ]],

Cell["Load two geometries one after another.", "MathCaption",ExpressionUUID->"ac243a41-ca5e-4324-86d6-c351b5d8e023"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"octa", "=", " ", 
   RowBox[{"PolyhedronData", "[", "\"\<Octahedron\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cube", "=", " ", 
   RowBox[{"PolyhedronData", "[", "\"\<Cube\>\"", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.636393491837697*^9, 3.63639350541607*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"2ee19db2-37c9-4498-90c2-e61c42d5e95d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "octa", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", 
  RowBox[{"cube", ",", 
   RowBox[{"Replace", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.794946779882614*^9, 3.794946785102457*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"dc789550-15ee-44c9-a1fe-8e1a5fc69ebf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject15963828416151553]], "Output",
 CellChangeTimes->{{3.7949467808397503`*^9, 3.794946786003886*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"495c9fef-7893-4437-ab0d-3a4f5f1ee239"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject12169255009124353]], "Output",
 CellChangeTimes->{{3.7949467808397503`*^9, 3.7949467860907235`*^9}},
 CellLabel->"Out[34]=",ExpressionUUID->"f54d2af8-6774-466e-81a8-a1eb054187b2"]
}, Open  ]],

Cell[TextData[{
 "When surfaces overlap or have intersections then switch on z-buffered \
rendering, for example, by pressing <shift-z> inside the JavaView display. \
The z-buffer can also be enabled from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook by calling appropriate methods of the JavaView display objects. \
First, get the display object from the viewer manager, then enabled \
z-buffered rendering and finally initiate an update of the display to refresh \
the scene. "
}], "Text",
 CellChangeTimes->{{3.793615673746689*^9, 
  3.793615674482692*^9}},ExpressionUUID->"2c92e65e-2d05-4bbd-bd08-\
9376cdf15ed0"],

Cell["\<\
Get the JavaView viewer manager (in case we did not keep a reference at the \
beginning).\
\>", "MathCaption",ExpressionUUID->"484b0811-204f-4fab-8cb3-79f72c03f0b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"viewer", " ", "=", " ", 
  RowBox[{"InstallJavaView", "[", "]"}]}]], "Input",
 CellChangeTimes->{3.794946770520939*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"c94c47ca-049f-483f-aa5b-af8820af95b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "viewer", ".", "PvViewer"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject31395949477625857]], "Output",
 CellChangeTimes->{3.7949467711673408`*^9, 3.7949468019919844`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"9c58d1d3-6f24-42d7-8fa3-9827fd99f09a"]
}, Open  ]],

Cell["For demonstration, we disable z-buffered rendering.", "MathCaption",
 CellChangeTimes->{{3.7949468263123336`*^9, 
  3.7949468352320523`*^9}},ExpressionUUID->"d46617c8-0149-409b-bff8-\
63240646dde8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"setEnabledZBuffer", "[", "False", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellChangeTimes->{{3.794946820674411*^9, 3.7949468217605124`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"3fcb5e65-b763-4633-b43d-701207f994c3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7949467971810117`*^9, 3.7949468425238633`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"18983696-a1c1-49d8-8c10-09cb463563c9"]
}, Open  ]],

Cell["\<\
Having the display object at hand provide many more useful ways to interact \
with a JavaView scene. For example, it allows to change the currently active \
geometry. Normally, the first geometry added to a display is the active \
geometry. Inside the JavaView display the active geometry may be changed \
either inside the display inspector panel, or by a shortcut keeping ctrl-key \
pressed and left-clicking the geometry.
The active geometry may also be changed from within a notebook in different. \
For example, when adding a geometry to JavaView then keep a reference to the \
returned JavaView geometry object. (note, open the JavaView display inspector \
panel to see the change of the selection.)\
\>", "Text",ExpressionUUID->"ddf471ff-d209-430c-abc0-95b07c059c59"],

Cell["Select a known other geometry as active geometry.", "MathCaption",ExpressionUUID->"3b8f1367-78a9-42cb-9b8d-aeb3af82bcf1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"jvOcta", "=", 
   RowBox[{
    StyleBox["JavaView",
     FontSlant->"Plain"], "[", "octa", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jvCube", "=", 
   RowBox[{
    StyleBox["JavaView",
     FontSlant->"Plain"], "[", 
    RowBox[{"cube", ",", 
     RowBox[{"Replace", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"43c5f705-9502-4050-a1bc-d41a9d2dcdb2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"selectGeometry", "[", "jvCube", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"5a0cd49c-5ee1-4543-b13a-fcfba97f3ab7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.794946870782866*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"f2c5731d-ad62-46a8-b3c5-b4e90afe032a"]
}, Open  ]],

Cell[TextData[{
 "Sometime the geometry are not known as JavaView objects. For example, when \
multiple geometries have been added to JavaView from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics with many geometries. In this case the display can provide a list \
of all registered geometries."
}], "Text",ExpressionUUID->"468efe83-2d09-4719-9c43-bae7949acefd"],

Cell["Select an unknown other geometry.", "MathCaption",ExpressionUUID->"71d1beb4-f0a7-4ec6-b04f-e311642ae462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"geomArr", "=", 
  RowBox[{"disp", "@", 
   RowBox[{"getGeometries", "[", "]"}]}]}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"f7de1634-a62d-498f-b89a-a1a8c94cedb2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject11682692223467521], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject34717569659174913]}], "}"}]], "Output",
 CellChangeTimes->{3.7949469212860346`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"73e00a57-adb4-461c-8e42-961aa0ff5b65"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"selectGeometry", "[", 
    RowBox[{"geomArr", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"22e173ad-c94b-458e-834b-1f87a0414127"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7949469234199586`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"268abea9-981c-4ea4-8614-0fa458adc179"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Simple modifications of a geometry inside ",
 StyleBox["JavaView",
  FontSlant->"Italic"]
}], "Subsection",ExpressionUUID->"204de47e-43df-4322-92ec-1df8b3e88448"],

Cell[TextData[{
 "The return value of ",
 StyleBox["JavaView",
  FontFamily->"Courier New",
  FontSlant->"Italic"],
 StyleBox["[]",
  FontFamily->"Courier New"],
 " is the geometry object used in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The type of the geometry class depends on the source material obtained \
from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. Typically the geometry is an instance of jv.geom.PgElementSet \
for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " polygons and other surface primitives or it is an instance of \
jv.geom.PgPolygonSet for lines, circle, etc. The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " documentation contains information about the functionality of these \
geometry classes and the set of visualization tools operating on them. Using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " it is now possible to inspect the geometry classes, modify their material \
and appearance in the viewer, change the geometry, or return data to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{
  3.7936157123452663`*^9},ExpressionUUID->"bac02213-ef1b-476a-bd78-\
0ca5bdfe4fce"],

Cell["\<\
The syntax of the invocation of Java methods is explained in detail in the \
J/Link manual. For convenience, a summary is included in these note. \
\>", "Text",ExpressionUUID->"7af0a03d-0604-4b70-89ac-822d333c8b1e"],

Cell[TextData[{
 "View another geometry in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " which replaces the previous one. This time we catch the returned ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometry."
}], "MathCaption",ExpressionUUID->"b9a8e560-95fb-49c6-89fe-6599b37722ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"geom", "=", 
  RowBox[{
   StyleBox["JavaView",
    FontSlant->"Plain"], "[", 
   RowBox[{"PolyhedronData", "[", "\"\<Icosahedron\>\"", "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.6363949003856454`*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"e510a41e-f53a-4327-807f-a34d5dce344d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject1377102930640897]], "Output",
 CellChangeTimes->{3.794947354571106*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"29202233-625a-4da3-b9e7-3e6cabdeb9b6"]
}, Open  ]],

Cell[TextData[{
 "Enable semi-transparent drawing in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The degree of transparency is in the interval [0,1]."
}], "MathCaption",ExpressionUUID->"d75fa71a-90a9-4d03-adb5-d4b11ef720d1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setTransparency", "[", "0.4", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showTransparency", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"geom", "@", 
  RowBox[{"update", "[", "geom", "]"}]}]}], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"15cd7cc6-73bb-471d-b59c-a30845a955ff"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7949473620510464`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"ebffbd8a-56ac-4687-8fcf-3fd04886fcb5"]
}, Open  ]],

Cell[TextData[{
 "Query the geometry for its combinatorial structure, like number of \
vertices, edges, or elements. The name 'element' is used in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for a face similar to the notation in finite element numerics."
}], "MathCaption",ExpressionUUID->"7f4ee918-1ba0-47f7-8502-d6081aaf26d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"geom", "@", 
  RowBox[{"getNumElements", "[", "]"}]}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"b70b4ed6-cb67-4363-a716-28d88ff9767f"],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.794947423374339*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"fea94d9d-16b7-4543-b549-76cd8e0ee40c"]
}, Open  ]],

Cell["\<\
Query the geometry for geometric properties like surface area or enclosed \
oriented volume.\
\>", "MathCaption",ExpressionUUID->"e9d61fdf-a80c-479b-aad9-31b85f8c5bb7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"geom", "@", 
  RowBox[{"getVolume", "[", "]"}]}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"9dccd731-2ee1-4fc4-a9c7-efb99aec7ccd"],

Cell[BoxData["2.181694990624913`"], "Output",
 CellChangeTimes->{3.794947425640642*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"39bcd529-1c8f-403b-b69b-7383cb131ce5"]
}, Open  ]],

Cell[TextData[{
 "Modify the appearance and material properties. Here we switch off showing \
of faces but keep the display of edges. Note, whenever the geometry is \
changed in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " by a command from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " then its update method be called to invoke a redraw of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "MathCaption",ExpressionUUID->"a1743c8e-b756-4dbf-a7d7-28fb7a30eee9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showElements", "[", "False", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"geom", "@", 
  RowBox[{"update", "[", "geom", "]"}]}]}], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"4dd0b151-251e-4813-8a78-6b64f8e758c4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7949474283662386`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"0f905350-f858-4309-971b-b1893bcbeffe"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`RunThrough`", "Section",
 CellChangeTimes->{{3.6365753750328817`*^9, 3.6365753766734877`*^9}, {
  3.7936160587438335`*^9, 
  3.793616060242828*^9}},ExpressionUUID->"82745ee5-cb81-475d-86d5-\
d6d8290ebb56"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can launch external programs using the RunThrough[] command and feed them \
with data via the pipe mechanism. For example, this allows to launch the \
standalone JavaView application and pass a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics object or animation to JavaView. JavaView then reads the graphics \
data from stdin."
}], "Text",
 CellChangeTimes->{{3.6365613950173626`*^9, 3.636561405658317*^9}, {
  3.6365614370343676`*^9, 
  3.636561449159751*^9}},ExpressionUUID->"d09d9001-0ea2-40cb-9478-\
13ad3e01c745"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["RunJavaView", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       FormBox["g",
        TraditionalForm], "TI"], 
      StyleBox["]", "MR"]}], 
     RowBox[{
     "invoke", " ", "JavaView", " ", "as", " ", "external", " ", "program", 
      " ", "to", " ", "view", " ", "a", " ", "Mathematica", " ", 
      RowBox[{"graphics", "."}]}]},
    {
     RowBox[{
      StyleBox["RunJavaView",
       FontFamily->"Courier"], 
      StyleBox["[",
       FontFamily->"Courier"], 
      RowBox[{"{", 
       RowBox[{
        StyleBox[
         SubscriptBox["g", "1"], "InlineFormula",
         FontSlant->"Italic"], 
        StyleBox[",",
         FontSlant->"Italic"], 
        StyleBox[
         SubscriptBox["g", "2"], "InlineFormula",
         FontSlant->"Italic"], ",", " ", "..."}], " ", "}"}], 
      StyleBox["]",
       FontFamily->"Courier"]}], 
     RowBox[{
     "show", " ", "several", " ", "Mathematica", " ", "graphics", " ", 
      "together", " ", "in", " ", 
      RowBox[{"JavaView", "."}]}]},
    {
     RowBox[{
      StyleBox["RunJavaView",
       FontFamily->"Courier"], 
      StyleBox["[",
       FontFamily->"Courier"], 
      StyleBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox[
           SubscriptBox["g", "1"], "InlineFormula"], ",", 
          StyleBox[
           SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}], " ", 
         "}"}], ",", "\n", " ", 
        RowBox[{"Animatable", "->", "True"}]}],
       FontSlant->"Italic"], 
      StyleBox["]",
       FontFamily->"Courier",
       FontSlant->"Italic"]}], 
     RowBox[{"show", " ", "a", " ", "list", " ", "of", " ", "geometries", " ", 
      RowBox[{"{", 
       StyleBox[
        RowBox[{
         StyleBox[
          SubscriptBox["g", "1"], "InlineFormula"], ",", 
         StyleBox[
          SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}],
        FontSlant->"Italic"], "}"}], " ", "as", " ", "smooth", " ", 
      "animation", " ", "in", " ", 
      RowBox[{"JavaView", 
       StyleBox[" ",
        FontSlant->"Italic"], 
       StyleBox[".",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["WriteMgs", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       FormBox[
        RowBox[{"g", ",", " ", "file"}],
        TraditionalForm], "TI"], 
      StyleBox["]", "MR"]}], 
     StyleBox[
      RowBox[{
      "save", " ", "a", " ", "Mathematica", " ", "graphics", " ", "to", " ", 
       "a", " ", 
       RowBox[{"file", "."}]}], "Text"]},
    {
     RowBox[{
      StyleBox["WriteMgs",
       FontFamily->"Courier"], 
      StyleBox["[",
       FontFamily->"Courier"], 
      StyleBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox[
           SubscriptBox["g", "1"], "InlineFormula"], ",", 
          StyleBox[
           SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}], " ", 
         "}"}], ",", " ", "file"}],
       FontSlant->"Italic"], 
      StyleBox["]",
       FontFamily->"Courier"]}], 
     RowBox[{
     "save", " ", "several", " ", "graphics", " ", "to", " ", "a", " ", 
      RowBox[{"file", "."}]}]},
    {
     RowBox[{
      StyleBox["WriteAnim",
       FontFamily->"Courier"], 
      StyleBox["[",
       FontFamily->"Courier"], 
      StyleBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox[
           SubscriptBox["g", "1"], "InlineFormula"], ",", 
          StyleBox[
           SubscriptBox["g", "2"], "InlineFormula"], ",", " ", "..."}], " ", 
         "}"}], ",", " ", "file"}],
       FontSlant->"Italic"], 
      StyleBox["]",
       FontFamily->"Courier",
       FontColor->GrayLevel[0]]}], 
     RowBox[{
     "save", " ", "a", " ", "list", " ", "of", " ", "graphics", " ", "as", 
      " ", "animation", " ", "to", " ", "a", " ", 
      RowBox[{"file", "."}]}]},
    {
     RowBox[{
      StyleBox["WriteHtml", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"g", ",", " ", "file"}], "TI"], 
      StyleBox["]", "MR"]}], 
     StyleBox[
      RowBox[{
      "create", " ", "an", " ", "Html", " ", "page", " ", "to", " ", "show", 
       " ", "a", " ", "Mathematica", " ", "graphics", " ", "in", " ", "a", 
       " ", "JavaView", " ", 
       RowBox[{"applet", "."}]}], "Text"]},
    {
     RowBox[{
      StyleBox["FormatGraphics", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox["g",
       FontSlant->"Italic"], 
      StyleBox["]", "MR"]}], 
     RowBox[{
     "internal", " ", "helper", " ", "routine", " ", "to", " ", "format", " ",
       "a", " ", "Mathematica", " ", "graphics", " ", "into", " ", "a", " ", 
      RowBox[{"string", "."}]}]}
   }], NotebookDefault]], "DefinitionBox",
 TextAlignment->Left,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"490e5793-49a7-433f-9cdb-f5b043fdf8bb"],

Cell["Invoking JavaView via RunThrough.", "Caption",ExpressionUUID->"72217adf-7a7f-4e70-a0dc-a50a40f2516c"],

Cell[TextData[{
 "A drawback of using RunThrough is the missing feedback ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to obtain from user interaction in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". Further, on some operating systems the RunThrough[] command blocks the \
kernel until ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " exists.\nWe provide the RunThrough mechanism because of its simplicity but \
encourage advanced users to use our J/Link-based package JavaView`JLink`. The \
commands in the package JavaView`RunThrough` are available in the package \
JavaView`JLink` too."
}], "Text",ExpressionUUID->"e7b30895-c450-44e2-be62-bd471a707f76"],

Cell[CellGroupData[{

Cell["Load the package JavaView`RunThrough`. ", "MathCaption",ExpressionUUID->"81912f59-8f26-4626-b791-279ca96b9d05"],

Cell[BoxData[
 RowBox[{"<<", "JavaView`RunThrough`"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"79950c7f-b90b-481a-a43e-5bb0a9570b45"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show a sample cube in a JavaView display. ", "MathCaption",ExpressionUUID->"b5394d2b-abf7-4912-bc65-7bf8c3416da2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cube", " ", "=", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"RunJavaView", "[", "cube", "]"}]}], "Input",
 CellChangeTimes->{{3.7933968761499214`*^9, 3.793396881883133*^9}, 
   3.7936159478478785`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"f7fe1f92-c823-4534-a397-bf000248d899"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some options. ", "MathCaption",ExpressionUUID->"274620f5-b7d6-4eb3-95d9-c630efccb383"],

Cell[BoxData[
 RowBox[{"Options", "[", "RunJavaView", "]"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"a308ed8f-7e2a-4810-b288-7d2cef346371"]
}, Open  ]],

Cell[TextData[{
 "A list of geometries of the same type are displayed in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " either as a collection of individual geometries or as an animation of a \
single geometry."
}], "Text",ExpressionUUID->"efc582c9-e7de-4c25-a1c5-9816bdc1c1b4"],

Cell[CellGroupData[{

Cell[TextData[{
 "Display a list of cuboids in an external ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display as a set of individual ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometries."
}], "MathCaption",ExpressionUUID->"33128e93-ebef-48be-9b8c-6f145f780166"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"randCube", " ", ":=", " ", 
   RowBox[{"Cuboid", "[", 
    RowBox[{"10", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Random", "[", "]"}], ",", 
       RowBox[{"Random", "[", "]"}], ",", 
       RowBox[{"Random", "[", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cubes", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", "randCube", "]"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RunJavaView", "[", "cubes", "]"}], ";"}]}], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"3419b558-c870-413e-b07e-6a16db21ad2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Display the same list of cuboids as an animation of a single cube.\
\>", "MathCaption",ExpressionUUID->"0e73cfa5-fbe6-44f7-ae20-055094a33fc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RunJavaView", "[", 
   RowBox[{"cubes", ",", " ", 
    RowBox[{"Animatable", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"18d3617e-43c0-4f5b-a90a-9f6cd6ab5abc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Here is the smooth animation of a catenoid deforming into a helicoid.\
\>", "MathCaption",ExpressionUUID->"b0c6c97f-06fe-4638-a91e-32214e9b11c4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"numFrames", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"anim", "=", 
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], " ", 
          RowBox[{"Cos", "[", "x", "]"}], " ", 
          RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}], " ", 
          RowBox[{"Sinh", "[", "y", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cos", "[", "t", "]"}]}], " ", 
          RowBox[{"Sin", "[", "x", "]"}], " ", 
          RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], " ", 
          RowBox[{"Cos", "[", "x", "]"}], " ", 
          RowBox[{"Sinh", "[", "y", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], " ", "y"}], "+", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], " ", "x"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{
         RowBox[{"-", "Pi"}], "/", "2"}], ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"Boxed", "->", "False"}], ",", 
      RowBox[{"Axes", "->", "False"}], ",", 
      RowBox[{"PlotPoints", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{"13", ",", "7"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0.", ",", 
      RowBox[{"Pi", "/", "2."}], ",", 
      RowBox[{
       RowBox[{"Pi", "/", "2."}], "/", 
       RowBox[{"(", 
        RowBox[{"numFrames", "-", "1"}], ")"}]}]}], "}"}]}], 
   "]"}]}]}], "Input",
 AnimationCycleOffset->1,
 AnimationCycleRepetitions->Infinity,
 CellLabel->"In[11]:=",ExpressionUUID->"b0b19e32-351d-4550-a660-b8fbc09314aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show a list of surfaces as smooth animation.", "MathCaption",ExpressionUUID->"bcee3ebf-c34a-4b8d-a07c-eb92f08005e3"],

Cell[BoxData[
 RowBox[{"RunJavaView", "[", 
  RowBox[{"anim", ",", " ", 
   RowBox[{"Animatable", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"06eb79cf-1371-46b4-9c62-673369fe4d87"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command RunJavaView[g]", "Subsection",ExpressionUUID->"cbb50cc8-f62e-4c9c-a410-7a27f526d0b5"],

Cell[TextData[{
 "The command RunJavaView[g] launches",
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " to display a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics object. The graphics object may be of type Graphics, Graphics3D, \
SurfaceGraphics, and others. \nOn some operating systems, this command blocks \
further execution of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel until ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " exits. In this case, during the life time of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " process the kernel is waiting for ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " to exit."
}], "Text",ExpressionUUID->"2ca20555-5e3b-4bc6-9238-6db025827b05"],

Cell[TextData[{
 "Create a sample ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and invoke ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " for display. "
}], "MathCaption",ExpressionUUID->"b51e6a6f-be81-40bc-b6e6-8a687b4d79ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"geom", " ", "=", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7934234853444004`*^9, 3.7934235027012177`*^9}, {
  3.7934416799549236`*^9, 3.793441681285277*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"61abbcac-1b85-419e-bffc-2b62a09df428"],

Cell[BoxData[
 RowBox[{"RunJavaView", "[", "geom", "]"}]], "Input",
 CellChangeTimes->{{3.793443571969643*^9, 3.793443586230283*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"a40b0ff8-79a7-4389-a497-0b4d73bb5d48"],

Cell[TextData[{
 StyleBox["RunJavaView",
  FontFamily->"Courier New"],
 " invokes the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 StyleBox["RunThrough",
  FontFamily->"Courier New"],
 " which launches \"javaview\" as an external process using a Java \
installation. Therefore, the path to the 'java' executable must be set such \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to find it. Further, the command ",
 StyleBox["RunJavaView",
  FontFamily->"Courier New"],
 " converts a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics into InputForm and replaces the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " specific floating point representation of numbers with conventional C form \
to simplify the parsing process in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.793421328499399*^9, 
  3.7934213287645063`*^9}},ExpressionUUID->"2a474672-0b04-406b-a4ef-\
4cb126d4261e"],

Cell[TextData[{
 StyleBox["The ",
  FontFamily->"Courier New"],
 StyleBox["JavaView",
  FontFamily->"Courier New",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontFamily->"Courier New"],
 "archives ",
 StyleBox["./Java/*.jar",
  FontSlant->"Italic"],
 " are searched relative to the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " installation directory:"
}], "MathCaption",ExpressionUUID->"0c3c5887-219f-46ac-97f3-098d69324ffc"],

Cell[BoxData[
 RowBox[{"GetInstallationPath", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"b584e55d-7360-4696-951f-c18cbc1b3d27"],

Cell[TextData[{
 "Experts Only: How to launch ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " by hand?"
}], "Subsubsection",ExpressionUUID->"2aa7f167-dd38-40fe-a4dc-23a121d25d34"],

Cell[TextData[{
 "Experts may directly use the command ",
 StyleBox["RunThrough",
  FontFamily->"Courier New"],
 " but should ensure that the number representation in the graphics object \
are correctly formatted. ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " requires data in InputForm. Note, that it is necessary to adjust the path \
to ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ".\nThe handling of directory and filenames with blanks was changed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.2 under MS-Windows. Therefore additional quotes have been added around \
codebase."
}], "Text",ExpressionUUID->"6c3a8339-24bf-40f3-bd1d-cfc0bd20859e"],

Cell["Load the package JavaView`RunThrough`, if not loaded yet ", \
"MathCaption",
 CellChangeTimes->{{3.7934212114596395`*^9, 
  3.7934212148803034`*^9}},ExpressionUUID->"846c07d1-b79e-4845-bfd2-\
2bb0f0276515"],

Cell[BoxData[
 RowBox[{"<<", "JavaView`RunThrough`"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"2fa07060-c833-4d68-a5f5-aa0367143a59"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " codebase from package installation."
}], "MathCaption",ExpressionUUID->"1118be96-720a-42aa-9c73-b42327615c71"],

Cell[BoxData[
 RowBox[{"jvCB", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{
    RowBox[{"GetInstallationPath", "[", "]"}], ",", 
    RowBox[{"$PathnameSeparator", "\[Rule]", "\"\</\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.793420715496879*^9, 3.79342072773009*^9}, 
   3.793420819804878*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"b70ac8ef-c29c-4c3a-877c-d41cce17e6fe"],

Cell[TextData[{
 "Enclose in extra quotes since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.2 and later handle blanks in filenames differently under MS-Windows."
}], "MathCaption",
 CellChangeTimes->{{3.7934206703364773`*^9, 
  3.7934206780766606`*^9}},ExpressionUUID->"d85afe20-146c-4035-bcf9-\
5e7835680220"],

Cell[BoxData[
 RowBox[{"jvCodebase", "=", 
  RowBox[{"\"\<\\\"\>\"", "<>", "jvCB", "<>", "\"\<\\\"\>\""}]}]], "Input",
 CellChangeTimes->{
  3.7934126712824907`*^9, 3.7934127530156355`*^9, 3.79341279741527*^9, {
   3.7934128433354793`*^9, 3.7934128447400637`*^9}, {3.7934207319684553`*^9, 
   3.793420737785535*^9}, {3.793420803512616*^9, 3.7934208539252224`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"52f18a07-5090-485d-89bf-fe2e2f9957fd"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " archives (here only javaview.jar is specified)."
}], "MathCaption",ExpressionUUID->"a1a7d80b-1afa-44f3-9d9d-a61d12f5c2e7"],

Cell[BoxData[
 RowBox[{"jvJARS", "=", 
  RowBox[{
  "\"\<\\\"\>\"", "<>", "jvCB", "<>", "\"\<javaview.jar\>\"", "<>", 
   "\"\<\\\"\>\""}]}]], "Input",
 CellChangeTimes->{{3.7934126864351096`*^9, 3.793412687663826*^9}, {
  3.793412885138094*^9, 3.793412891227623*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"3de6032e-aab1-4228-af9f-f01bdd225c52"],

Cell[TextData[{
 "Combine the Java runtime with ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " jar archives and options."
}], "MathCaption",
 CellChangeTimes->{{3.793617417591519*^9, 
  3.7936174181740065`*^9}},ExpressionUUID->"5fe1b508-83ad-450a-aa5d-\
0c5b6f516275"],

Cell[BoxData[
 RowBox[{"jvCmd0", "=", 
  RowBox[{
  "\"\<javaw -cp \>\"", "<>", "jvJARS", "<>", "\"\< javaview codebase=\>\"", "<>",
    "jvCodebase"}]}]], "Input",
 CellChangeTimes->{
  3.793412855301577*^9, 3.793412986726931*^9, 3.7934130774397335`*^9, {
   3.793413360828531*^9, 3.793413370583887*^9}, 3.7934134087200627`*^9, {
   3.7934209495788765`*^9, 3.793420979885563*^9}, {3.7934210172297544`*^9, 
   3.7934210439996567`*^9}, {3.7934242020778103`*^9, 3.793424227754122*^9}, 
   3.7934440194322367`*^9, {3.7934494447152553`*^9, 3.793449445909066*^9}, {
   3.793449698403609*^9, 3.7934496984933653`*^9}, {3.793616249820077*^9, 
   3.7936162503696656`*^9}, 3.7936172037391973`*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"44c1df54-c090-4207-aaa4-e5845c4124b2"],

Cell["As a test, launch JavaView, without current sample geometry.", \
"MathCaption",
 CellChangeTimes->{{3.793421399024864*^9, 3.793421424731415*^9}, {
  3.793617287524375*^9, 
  3.7936172999045277`*^9}},ExpressionUUID->"f032115f-ebbc-430f-b25b-\
9caaeec03244"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Run", "[", "jvCmd0", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.793413485805659*^9, 3.7934134936733837`*^9}, 
   3.79341377949175*^9, {3.7934497023270197`*^9, 3.7934497024247465`*^9}, {
   3.793616257202979*^9, 3.793616257719599*^9}, 3.793617205600258*^9, 
   3.79361734175075*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"687e793f-7f77-4846-bd2a-d83f8c7fc138"],

Cell[CellGroupData[{

Cell["\<\
Another test, launch JavaView batch file, without current sample geometry.\
\>", "MathCaption",
 CellChangeTimes->{{3.793421399024864*^9, 3.793421424731415*^9}, {
   3.7936166828273196`*^9, 3.79361669515329*^9}, 3.793617308504409*^9, {
   3.7936173684162865`*^9, 
   3.7936173693937263`*^9}},ExpressionUUID->"f8c53688-32f1-44f6-a655-\
67bc555f32a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"jvBat", "=", "\"\<c:/JavaView/srcBase/bin/javaview.bat\>\""}], ";", 
  RowBox[{"Run", "[", "jvBat", "]"}]}]], "Input",
 CellChangeTimes->{{3.793617322864035*^9, 3.7936173298338737`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"cc9358ee-7657-4d4b-9aa6-c30b7fc3660e"]
}, Open  ]],

Cell[TextData[{
 "Direct ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " to read from ",
 StyleBox["stdin",
  FontSlant->"Italic"],
 " a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics."
}], "MathCaption",
 CellChangeTimes->{{3.793421399024864*^9, 3.793421424731415*^9}, {
   3.7936166828273196`*^9, 3.79361669515329*^9}, 3.793617308504409*^9, {
   3.7936173684162865`*^9, 3.7936173693937263`*^9}, {3.793617469931424*^9, 
   3.793617496871269*^9}},ExpressionUUID->"98e4b250-e97b-4c9b-a69b-\
68d8f82c4a60"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"jvOptions", " ", "=", " ", "\"\< file=stdin format=mgs\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"jvCmd", "=", 
  RowBox[{"jvCmd0", "<>", "jvOptions"}]}]}], "Input",
 CellChangeTimes->{{3.7934449024720273`*^9, 3.793444923822359*^9}, {
  3.793447452180176*^9, 3.7934474572179613`*^9}, {3.7934497085244017`*^9, 
  3.7934497119619226`*^9}, {3.7936167189499836`*^9, 3.7936167192212505`*^9}, {
  3.7936172094629154`*^9, 3.7936172121496277`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"1091a0b9-9dc3-41ca-b565-40933d0a8faa"],

Cell[TextData[{
 "Convert ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics to InputForm."
}], "MathCaption",
 CellChangeTimes->{
  3.7936175393192153`*^9},ExpressionUUID->"3f5737c7-7b0c-430a-94e3-\
636d01c919c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fmtGeom", "=", 
   RowBox[{"InputForm", "[", 
    RowBox[{
     RowBox[{"N", "[", "geom", "]"}], "/.", 
     RowBox[{"x_Real", "\[RuleDelayed]", 
      RowBox[{"CForm", "[", 
       RowBox[{"Chop", "[", "x", "]"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.793423459779557*^9, 3.7934243781000457`*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"a77035d5-4cb0-4816-aac5-49d2ec29c2b4"],

Cell[TextData[{
 "Launch ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 "graphics in InputForm."
}], "MathCaption",
 CellChangeTimes->{{3.7936175480600066`*^9, 
  3.7936175520397353`*^9}},ExpressionUUID->"4fdc65e9-7ffd-478b-aed8-\
1e9eed319dab"],

Cell[BoxData[
 RowBox[{"RunThrough", "[", 
  RowBox[{"jvCmd", ",", "fmtGeom"}], "]"}]], "Input",
 CellChangeTimes->{{3.793449715512019*^9, 3.7934497157763147`*^9}, {
  3.79361672959064*^9, 3.793616731276169*^9}, {3.793617009890969*^9, 
  3.793617010049543*^9}, {3.7936172163106394`*^9, 3.793617216658228*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"d5937167-44a3-45f4-93d7-a59b66b9716a"],

Cell[TextData[{
 "Second attempt to launch ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics, if the user\[CloseCurlyQuote]s working directory contains blanks \
in Windows. RunThroughOK provides additional quotes around temporary internal \
filenames."
}], "MathCaption",
 CellChangeTimes->{{3.7936168028838253`*^9, 3.793616873968912*^9}, {
  3.793617111855593*^9, 
  3.793617180785056*^9}},ExpressionUUID->"f7f05d30-2c20-4f74-9ce3-\
137be4a42aa2"],

Cell[BoxData[
 RowBox[{"RunThroughOK", "[", 
  RowBox[{"jvCmd", ",", "fmtGeom"}], "]"}]], "Input",
 CellChangeTimes->{{3.793449715512019*^9, 3.7934497157763147`*^9}, {
  3.79361672959064*^9, 3.793616731276169*^9}, {3.793616877819982*^9, 
  3.7936168779191275`*^9}, {3.793617081158278*^9, 3.793617081299899*^9}, {
  3.7936172195207047`*^9, 3.793617219760066*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"16527eb6-34ba-4288-a050-1b1895c7e188"],

Cell[TextData[{
 "Experts may adjust this setup in the package ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "`RunThrough`."
}], "Text",
 CellChangeTimes->{{3.793421551817916*^9, 
  3.7934215527045484`*^9}},ExpressionUUID->"54147dbf-2d46-4fa9-b4bd-\
52d6319b7192"]
}, Closed]],

Cell[CellGroupData[{

Cell["Command WriteMgs[g, file]", "Subsection",ExpressionUUID->"9bc48fb5-829b-46b9-8e14-e6a1896abacc"],

Cell[TextData[{
 "WriteMgs[g,file] saves a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics in the given file, which may later be viewed with ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " using the shell command 'javaview file'. The filename may specify a file \
relative to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics object into a formatted string.\nThe saved file may later be \
viewed from command line using 'javaview myDode.mgs' or loaded into a running \
",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " from the File-Open menu."
}], "Text",ExpressionUUID->"a4442e47-32c0-4b47-9de0-c08b16b6a1f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dode", "=", " ", 
  RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}]], "Input",
 CellChangeTimes->{
  3.6363927705624905`*^9, {3.7943319996653147`*^9, 3.794332001447237*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"3821cae3-7318-448d-ba42-7c0a6ca5fafd"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417602, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417602, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]]]], "Output",
 CellChangeTimes->{3.7943320023840947`*^9, 3.794335191977891*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"83909e0d-fb6f-4c36-8ca3-799b1ca1a200"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetWorkingPath", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7935238001715965`*^9, 3.7935238042393413`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"1542b8d9-84be-4408-956e-2dea7e73e6ac"],

Cell[BoxData["\<\"C:\\\\Users\\\\Polthier\\\\Documents\\\\\"\>"], "Output",
 CellChangeTimes->{3.794332007352785*^9, 3.794335209118532*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"dc917855-3382-473f-b254-b228b100ef48"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Saving a sample graphics as ASCII file relative to the working path.\
\>", "MathCaption",ExpressionUUID->"2ca0bfae-a709-45d2-a45e-098790754f8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteMgs", "[", 
  RowBox[{"dode", ",", "\"\<mgs\\\\myDode.mgs\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.793523718678794*^9, 3.7935237241877575`*^9}, {
  3.7943353801831503`*^9, 3.7943353836966934`*^9}, {3.794338186284463*^9, 
  3.794338194104864*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"204b626a-6b5d-4991-befb-f8901707e0e0"],

Cell[BoxData["\<\"C:\\\\Users\\\\Polthier\\\\Documents\\\\mgs\\\\myDode.mgs\"\
\>"], "Output",
 CellChangeTimes->{
  3.7943351670717983`*^9, 3.7943352119466095`*^9, {3.794335384540549*^9, 
   3.7943354024312115`*^9}, 3.7943381957589283`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"f0a1d706-1ba0-4d05-9e39-a4f8db7c6c02"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Re-import the previously saved geometry file as a regular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. There is no difference between the original \"cube\" and \
\"importCube\"."
}], "MathCaption",ExpressionUUID->"ff043dd0-7830-4ef4-abc6-ef5ed8367ffb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"importDode", " ", "=", " ", 
  RowBox[{"Get", "[", 
   RowBox[{
    RowBox[{"GetWorkingPath", "[", "]"}], "<>", "fileName"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7936179739391837`*^9, 3.7936179824444923`*^9}, {
   3.7936180124878874`*^9, 3.793618013361554*^9}, 3.794335160822135*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"0ddab3cb-bf87-44cb-af1b-c93d19586ef3"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{-1.3763819204711736`, 0, 0.2628655560595668}, {
    1.3763819204711736`, 
     0, -0.2628655560595668}, {-0.42532540417602, -1.3090169943749475`, 
    0.2628655560595668}, {-0.42532540417602, 1.3090169943749475`, 
    0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
    0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
    0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
    1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
    1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
    1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
    0.85065080835204, 
     0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
    0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
     1.1135163644116066`}, {
    0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
    0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
    0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
    0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}, 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]]]], "Output",
 CellChangeTimes->{{3.794335161712248*^9, 3.7943351700249815`*^9}, 
   3.7943352153841414`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"f7f6fde7-8f66-4066-939f-dcaf37f18c51"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"RunJavaView", "[", "importDode", "]"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"4912eb89-fec5-42af-8ffc-0db4972a65db"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Command WriteAnim[{g1, g2, ... },file]", "Subsection",ExpressionUUID->"2fa795cb-95b9-47c2-ab58-2b0b86f0110e"],

Cell[TextData[{
 "WriteAnim[{g1, g2, ... },file] saves a list of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics as animation in the given file, which may later be viewed with \
JavaView using the shell command 'javaview file'. The filename may specify a \
file relative to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics objects into a formatted string."
}], "Text",ExpressionUUID->"9b1f6b83-cdd6-4a43-9fa4-7915d4ff17b7"],

Cell[TextData[{
 "The saved file may later be viewed from the DOS command line using \
'javaview c:\\myAnim.mgs' or loaded into a running ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " from the File-Open menu."
}], "Text",ExpressionUUID->"c65125bb-1128-428d-b7bf-795132fa619a"],

Cell[TextData[{
 "Create a list of cuboids in an external ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display as a set of individual ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometries."
}], "MathCaption",ExpressionUUID->"d88a43b1-4578-46f3-9f4a-74c9d696bd2c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"rcoord", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Random", "[", "]"}], ",", 
    RowBox[{"Random", "[", "]"}], ",", 
    RowBox[{"Random", "[", "]"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"cubeAnim", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics3D", "[", 
     RowBox[{"Cuboid", "[", 
      RowBox[{"10", "rcoord"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{3.794335302775751*^9},
 CellLabel->"In[74]:=",ExpressionUUID->"278daa1a-2b1e-478a-9d71-806728c3cc1a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    CuboidBox[{4.463935564505331, 9.118689163013048, 1.694998871502861}]], 
   ",", 
   Graphics3DBox[
    CuboidBox[{4.984576372826646, 1.4990773660220669`, 8.547694053790869}]], 
   ",", 
   Graphics3DBox[
    CuboidBox[{3.7471848235613905`, 0.6444770814887834, 8.21115016324743}]]}],
   "}"}]], "Output",
 CellChangeTimes->{3.794335303321828*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"dbfcc026-2514-48af-86b3-46f2bdac850c"]
}, Open  ]],

Cell["\<\
Save the cuboids as animation in a geometry file cuboidAnim.mgs relative to \
the working path.\
\>", "MathCaption",ExpressionUUID->"9e6ed21c-9236-45f2-8c03-dbd99ba0002a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fileName", " ", "=", " ", "\"\<cubeAnim.mgs\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteAnim", "[", 
  RowBox[{"cubeAnim", ",", "fileName"}], "]"}]}], "Input",
 CellChangeTimes->{3.7935239119437327`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"89cb42fe-ef06-49e0-a4f8-591a62ee2b45"],

Cell[BoxData["\<\"C:\\\\Users\\\\Polthier\\\\Documents\\\\cubeAnim.mgs\"\>"], \
"Output",
 CellChangeTimes->{3.7935239151386533`*^9, 3.794335248227657*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"185c9acb-ee4b-4db5-9ea0-47fa32de9b89"]
}, Open  ]],

Cell[TextData[{
 "As a test, load the previously saved animation back and playback in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",ExpressionUUID->"9777c3a5-494f-47ad-a7cb-780e68959f84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"testAnim", "=", 
  RowBox[{"Get", "[", 
   RowBox[{
    RowBox[{"GetWorkingPath", "[", "]"}], "<>", "fileName"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7943352611817923`*^9, 3.7943352659316635`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"c99c79af-c034-415d-b0b3-1d89dc535b8d"],

Cell[BoxData[
 RowBox[{"ShowAnimation", "[", 
  RowBox[{"{", 
   RowBox[{
    Graphics3DBox[
     CuboidBox[{7.9478140479414705`, 4.340099291337863, 3.287927202774637}]], 
    ",", 
    Graphics3DBox[
     CuboidBox[{9.709884987208783, 8.575596947164891, 7.478598863267934}]], 
    ",", 
    Graphics3DBox[
     CuboidBox[{0.8125598540660762, 6.080007735174419, 7.104215268285275}]]}],
    "}"}], "]"}]], "Output",
 CellChangeTimes->{3.7943352664310226`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"af874b27-ecf2-497c-958e-e64c8e705d80"]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["WriteAnim",
  FontFamily->"Courier New"],
 " saves an animation using the command ",
 StyleBox["ShowAnimation",
  FontFamily->"Courier New"],
 "."
}], "Text",ExpressionUUID->"2b9d9772-fb96-4e0a-beb5-ff066e358cdc"]
}, Closed]],

Cell[CellGroupData[{

Cell["Command WriteHtml[g,file]", "Subsection",ExpressionUUID->"992901ee-e27c-4866-9e2b-3add2b2e3fc9"],

Cell[TextData[{
 "The following commands save a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics in a web page with a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " applet. This web page may be opened in a web browser, or published on a \
web site."
}], "Text",ExpressionUUID->"79d7b0f9-6d8e-467b-ae0b-782d680fca9b"],

Cell[TextData[{
 "WriteHtml[g,file] creates a Html page showing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics as interactive ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " applet. The method uses FormatGraphics[g] to avoid very long lines. Long \
lines are annoying to web designers who post-process the file. The filename \
may specify a file relative to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or may be an absolute path.\nNote, the applet contains no codebase \
setting. Either the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " archives must be included in the classpath or manually added in a codebase \
directive of this applet."
}], "Text",
 CellChangeTimes->{{3.793523937958267*^9, 
  3.793523970478923*^9}},ExpressionUUID->"84581a26-d8d7-4977-94a9-\
cbe1046f5c7a"],

Cell["Generate a cuboid as working example.", "MathCaption",ExpressionUUID->"b9b91355-3e98-4dc4-a647-bd3f1df7832f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cube", " ", "=", " ", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Cuboid\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.794335326775284*^9},
 CellLabel->"In[77]:=",ExpressionUUID->"bbb68e95-0c75-4ea2-8e4d-fc15cdf45b62"],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{5, 2, 1}],
  PlotLabel->FormBox["\"Cuboid\"", TraditionalForm]]], "Output",
 CellChangeTimes->{3.7943353271965446`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"7d018ed6-e934-41dc-8b6a-d3ac74046bd4"]
}, Open  ]],

Cell[TextData[{
 "Create an Html page which displays the cuboid in a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " applet relative to the working path. The web page can be opened in any web \
browser."
}], "MathCaption",ExpressionUUID->"3fc1e321-f9a4-4156-aa6e-8980e750dbc5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteHtml", "[", 
  RowBox[{"cube", ",", "\"\<html\\\\myCube.html\>\""}], "]"}]], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"b8041206-0ea7-43d9-b82e-1e9ef4d00915"],

Cell[BoxData["\<\"C:\\\\Users\\\\Polthier\\\\Documents\\\\html\\\\myCube.html\
\"\>"], "Output",
 CellChangeTimes->{3.794335331774734*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"591f49b3-92e2-4569-bc20-f9f89f471261"]
}, Open  ]],

Cell[TextData[{
 "Note, it is essential to have a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " installation in the target directory unless the path options of \
WriteHtml[] are adjusted as explained below."
}], "Text",ExpressionUUID->"aa683f4c-0302-45f8-bfb5-866354ee43ac"],

Cell[TextData[{
 "The commands presented in this section are rather simple but very \
convenient in the daily use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " if J/Link is not available, or if no feedback from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is needed. The following section gives a glimpse of the tight integration \
J/Link offers for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{
  3.7935240128562813`*^9},ExpressionUUID->"53fa16f8-77e1-45b5-b368-\
66c19326f06c"],

Cell[CellGroupData[{

Cell["Adjusting the Codebase of Applet", "Subsubsection",ExpressionUUID->"5b40455d-196e-47a7-b0fd-c8560325d022"],

Cell[TextData[{
 "The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " applet in the Html page needs the Java library 'javaview.jar' which \
contains the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " viewer. A web browser finds the location of the library by concatenating \
two string attributes of the applet: codebase and archive. The codebase \
attribute may either be an absolute or relative URL, and the archive \
attribute is a relative URL. If the codebase attribute is a relative URL then \
it is relative to the URL of the Html page.\nThe option \"Codebase\" \
specifies the codebase attribute of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " applet. The codebase attribute is \"./\" on default, i.e. it refers to the \
directory of the Html page."
}], "Text",ExpressionUUID->"b807cf8b-3ced-404b-b2f8-d46ac227517b"],

Cell[TextData[{
 "The option \"PathToArchive\" specifies the path of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " archive relative to the codebase of the applet. A default installation of \
JavaView in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation puts the Java archive to <<mathematica \
root>>\\AddOns\\Applications\\JavaView\\Java\\javaview.jar, and the default \
value of PathToArchive is \"Java/\".\nThe path name separators in the archive \
attributes must always be a slash \"/\". "
}], "Text",ExpressionUUID->"010eaa4a-15d7-4afe-9c8f-2d7ba81805a1"],

Cell["\<\
Save the web page in a non-standard directory and adjust the codebase and \
archive attributes of the applet.\
\>", "MathCaption",ExpressionUUID->"68ce4e48-dd49-469c-bf84-cafcb9ad67bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"htmlFile", " ", "=", " ", "\"\<html\\\\myCube.html\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"codebase", " ", "=", " ", "\"\<../\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"archive", "=", " ", "\"\<Java/\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteHtml", "[", 
  RowBox[{"cube", ",", "htmlFile", ",", 
   RowBox[{"Codebase", "\[Rule]", "codebase"}], ",", 
   RowBox[{"PathToArchive", "\[Rule]", "archive"}]}], "]"}]}], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"e8cc4403-6d1b-4bee-8fce-33cc5638e1cf"],

Cell[TextData[{
 "Note, if the web page is published on a web site, then the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " archives in .\\Java must be published as well."
}], "Text",ExpressionUUID->"14e6fb3f-f1a0-43d9-8373-a7dca65dd4f1"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Basics of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " Display"
}], "Section",
 CellChangeTimes->{{3.636562896679442*^9, 3.636562898163769*^9}, {
  3.636563542335206*^9, 
  3.636563544835288*^9}},ExpressionUUID->"05e6a4ff-b3dc-4106-8bd6-\
ef43b9fc893e"],

Cell[TextData[{
 "The best introduction to the features of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " and the interaction with its display is to browse through the \
demonstrations given at the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " homepage ",
 ButtonBox["http://www.javaview.de/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.javaview.de"], None}],
 ". Here we provide a basic reference list."
}], "Text",ExpressionUUID->"7bbb1f8a-9461-4689-8b2a-90983b1a291e"],

Cell[TextData[{
 "The ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display always has a major interaction mode in which you can either \
rotate, scale, or translate a geometry. You press a shortcut key to switch to \
another mode temporarily. When releasing the key, the previous major mode is \
re-installed.\nNote, selecting an interaction mode with the popup menu \
switches the major mode."
}], "Text",
 CellDingbat->None,ExpressionUUID->"c5b31166-d574-4633-adef-853889e621dc"],

Cell["\<\
Each display opens a popup menu by clicking with the right mouse. This is a \
convenient shortcut for a few basic tasks avoiding to know keyboard shortcuts \
or to open the control window. For example, to switch the interaction mode \
(without using keyboard shortcut), access to help dialog (without using \
control window), open another display (without using control window), or open \
the control window. \
\>", "Text",ExpressionUUID->"a76a92f5-ef27-4602-b608-cc41ab39952a"],

Cell[CellGroupData[{

Cell[TextData[{
 "Popup menu in any ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display using right-mouse click."
}], "MathCaption",ExpressionUUID->"10005c73-986a-4556-b0a5-ea68e2333099"],

Cell[TextData[{
 "You can always get a listing of available keyboard shortcuts by opening the \
popup menu in any ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display and select the Help menu item. Here is a list of most commands. \
While focus over the display keep either of the following keys pressed while \
dragging with the mouse."
}], "Text",
 CellDingbat->None,ExpressionUUID->"0984e649-3612-41dd-8322-39ceb79a379b"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox["Transformation", "MR",
      FontWeight->"Bold"], "\[Placeholder]"},
    {"o", 
     RowBox[{"Rotation", " ", "mode", " ", 
      RowBox[{"(", 
       StyleBox[
        RowBox[{
         StyleBox["O",
          FontWeight->"Bold"], "rbit"}]], ")"}]}]},
    {"v", 
     RowBox[{
      RowBox[{"Rotation", " ", "with", " ", "fixed", " ", 
       StyleBox[
        RowBox[{
         StyleBox["v",
          FontWeight->"Bold"], "ertical"}]], " ", "z"}], "-", "axis"}]},
    {"s", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["S",
         FontWeight->"Bold"], "caling"}]], " ", "mode"}]},
    {"t", 
     RowBox[{"xy", "-", 
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["T",
          FontWeight->"Bold"], "ranslation"}]], " ", "mode"}]}]},
    {"z", 
     RowBox[{
      StyleBox["Z",
       FontWeight->"Bold"], "-", 
      RowBox[{"Translation", " ", "mode"}]}]},
    {"f", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["F",
         FontWeight->"Bold"], "it"}]], " ", "scene", " ", "to", " ", "fill", 
      " ", "display"}]},
    {"c", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["C",
         FontWeight->"Bold"], "enter"}]], " ", "geometry", " ", "in", " ", 
      "display"}]},
    {"x", 
     RowBox[{"Drag", " ", "rectangle", " ", "to", " ", "zoom", " ", "in"}]},
    {"r", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["R",
         FontWeight->"Bold"], "eset"}]], " ", "display", " ", "and", " ", 
      "camera"}]},
    {
     RowBox[{"Left", " ", "Mouse"}], 
     RowBox[{
      RowBox[{"Depending", " ", "on", " ", "the", " ", "mode"}], ",", "drag", 
      ",", 
      RowBox[{
      "pick", " ", "and", " ", "select", " ", "the", " ", "geometry", " ", 
       "in", " ", "the", " ", "viewer"}]}]},
    {
     RowBox[{"Right", " ", "Mouse"}], 
     RowBox[{
     "Show", " ", "popup", " ", "menu", " ", "to", " ", "select", " ", 
      "major", " ", "modes", " ", "and", " ", "others", " ", "actions"}]},
    {
     StyleBox["Animation",
      FontWeight->"Bold"], 
     StyleBox["\[Placeholder]",
      FontWeight->"Bold"]},
    {"w", 
     RowBox[{
      RowBox[{"Start", " ", "auto"}], "-", 
      RowBox[{"rotation", " ", "of", " ", "geometry"}]}]},
    {"q", 
     RowBox[{
      RowBox[{"Stop", " ", "auto"}], "-", "rotation"}]},
    {
     RowBox[{"Ctrl", "-", "a"}], 
     RowBox[{"Show", " ", "animation", " ", "panel", " ", 
      RowBox[{"(", 
       RowBox[{"if", " ", "animatable"}], ")"}]}]},
    {
     RowBox[{"Ctrl", "-", "k"}], 
     RowBox[{
     "Create", " ", "animation", " ", "by", " ", "storing", " ", "current", 
      " ", "geometry", " ", "as", " ", "keyframe"}]},
    {
     StyleBox["Modelling",
      FontWeight->"Bold"], 
     StyleBox["\[Placeholder]",
      FontWeight->"Bold"]},
    {"a", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["A",
         FontWeight->"Bold"], "dd"}]], " ", "vertex", " ", "to", " ", 
      "current", " ", "geometry", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"enable", "'"}], "show", " ", 
        RowBox[{"vertices", "'"}]}], ")"}]}]},
    {"e", 
     RowBox[{"Add", " ", 
      StyleBox[
       RowBox[{
        StyleBox["e",
         FontWeight->"Bold"], "lement"}]], " ", "or", " ", "polygon", " ", 
      "by", " ", "picking", " ", "existing", " ", "or", " ", "new", " ", 
      "vertices"}]},
    {"d", 
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["D",
           FontWeight->"Bold"], "uplicate"}]], " ", "geometry", " ", "by", 
        " ", "reflection", " ", "depending", " ", "on", " ", "the", " ", 
        "number", " ", "of", " ", "marked", " ", 
        RowBox[{"vertices", ":", " ", 
         RowBox[{"1", " ", "vertex"}]}]}], " ", "=", " ", 
       RowBox[{"inversion", " ", "in", " ", "point"}]}], ",", " ", 
      RowBox[{
       RowBox[{"2", " ", "vertices"}], " ", "=", " ", 
       RowBox[{"180", " ", "rotation", " ", "around", " ", "line"}]}], ",", 
      " ", 
      RowBox[{
       RowBox[{"3", " ", "vertices"}], " ", "=", " ", 
       RowBox[{"mirror", " ", "reflection", " ", "in", " ", 
        RowBox[{"plane", "."}]}]}]}]},
    {"i", 
     RowBox[{"Pick", " ", 
      StyleBox[
       RowBox[{
        StyleBox["I",
         FontWeight->"Bold"], "nital"}]], " ", "points", " ", "in", " ", 
      "some", " ", "applets"}]},
    {"m", 
     RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
      StyleBox[
       RowBox[{
        StyleBox["M",
         FontWeight->"Bold"], "ark"}]], " ", "vertices", " ", "inside"}]},
    {"n", 
     RowBox[{
     "Pick", " ", "or", " ", "drag", " ", "rectangle", " ", "to", " ", "mark",
       " ", "elements", " ", "inside"}]},
    {"p", 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["P",
         FontWeight->"Bold"], "ick"}]], " ", "a", " ", "vertex", " ", "and", 
      " ", "drag", " ", "it"}]},
    {"u", 
     RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
      StyleBox[
       RowBox[{
        StyleBox["U",
         FontWeight->"Bold"], "nmark"}]], " ", "vertices", " ", "inside"}]},
    {
     RowBox[{"Shift", "-", "u"}], 
     RowBox[{
     "Drag", " ", "rectangle", " ", "to", " ", "unmark", " ", "elements", " ",
       "inside"}]},
    {
     StyleBox[
      RowBox[{"Display", " ", "Flags"}],
      FontWeight->"Bold"], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"toggle", " ", 
        RowBox[{"on", "/", "off"}]}], ")"}],
      FontWeight->"Bold"]},
    {
     RowBox[{"Shift", "-", "a"}], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["A",
         FontWeight->"Bold"], "ura"}]], " ", "around", " ", "edges", " ", 
      RowBox[{"(", 
       RowBox[{
       "only", " ", "if", " ", "elements", " ", "are", " ", "switched", " ", 
        "off"}], ")"}]}]},
    {
     RowBox[{"Shift", "-", "b"}], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["B",
         FontWeight->"Bold"], "ounding"}]], " ", "box", " ", "of", " ", 
      "current", " ", "geometry"}]},
    {
     RowBox[{"Shift", "-", "c"}], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["C",
         FontWeight->"Bold"], "enter"}]], " ", "of", " ", "current", " ", 
      "geometry", " ", 
      RowBox[{"(", "pending", ")"}]}]},
    {
     RowBox[{"Shift", "-", "d"}], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox["D",
         FontWeight->"Bold"], "epthcue"}]], " ", "fading", " ", "off", " ", 
      "items", " ", "farer", " ", "away"}]},
    {
     RowBox[{"Shift", "-", "f"}], 
     RowBox[{"Coordinate", " ", 
      StyleBox[
       RowBox[{
        StyleBox["F",
         FontWeight->"Bold"], "rame"}]]}]},
    {
     RowBox[{"Shift", "-", "g"}], 
     RowBox[{"xy", "-", 
      StyleBox[
       RowBox[{
        StyleBox["G",
         FontWeight->"Bold"], "rid"}]]}]},
    {
     RowBox[{"Shift", "-", "h"}], 
     RowBox[{
      RowBox[{"Information", " ", "at", " ", "mouse", " ", "cursor"}], ",", 
      " ", 
      StyleBox[
       RowBox[{
        StyleBox["H",
         FontWeight->"Bold"], "ighlight"}]]}]},
    {
     RowBox[{"Shift", "-", "i"}], 
     RowBox[{"Background", " ", 
      StyleBox[
       RowBox[{
        StyleBox["I",
         FontWeight->"Bold"], "mage"}]]}]},
    {
     RowBox[{"Shift", "-", "j"}], 
     RowBox[{"Toggle", " ", "usage", " ", "of", " ", "lights"}]},
    {
     RowBox[{"Shift", "-", "l"}], 
     RowBox[{
      StyleBox[
       RowBox[{"Border", 
        StyleBox["l",
         FontWeight->"Bold"], "ine"}]], " ", "around", " ", "display"}]},
    {
     RowBox[{"Shift", "-", "m"}], 
     RowBox[{
      RowBox[{
      "Toggle", " ", "magnet", " ", "mode", " ", "of", " ", "vertices"}], ",", 
      RowBox[{
       RowBox[{"i", ".", "e", ".", "highlight"}], " ", "if", " ", "nearby", 
       " ", "vertices"}]}]},
    {
     RowBox[{"Shift", "-", "o"}], 
     RowBox[{
      RowBox[{"Direct", " ", "select", " ", "mode"}], ",", 
      RowBox[{
      "geometries", " ", "are", " ", "automatically", " ", "selected", " ", 
       "when", " ", "picked"}]}]},
    {
     RowBox[{"Shift", "-", "p"}], 
     RowBox[{
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["P",
          FontWeight->"Bold"], "ainter"}]], "'"}], "s", " ", "algorithm", " ",
       "for", " ", "depthsort"}]},
    {
     RowBox[{"Shift", "-", "q"}], 
     RowBox[{
     "Toggle", " ", "display", " ", "of", " ", "title", " ", "information"}]},
    {
     RowBox[{"Shift", "-", "r"}], 
     RowBox[{
      RowBox[{"Backface", " ", "culling"}], ",", " ", 
      RowBox[{"show", " ", 
       StyleBox[
        RowBox[{
         StyleBox["R",
          FontWeight->"Bold"], "ear"}]], " ", "elements"}]}]},
    {
     RowBox[{"Shift", "-", "s"}], 
     RowBox[{
      RowBox[{"Toggle", " ", "anti"}], "-", 
      RowBox[{"aliased", " ", "rendering"}]}]},
    {
     RowBox[{"Shift", "-", "t"}], 
     RowBox[{
     "Toggle", " ", "tag", " ", "mode", " ", "to", " ", "move", " ", "all", 
      " ", "marked", " ", "vertices"}]},
    {
     RowBox[{"Shift", "-", "x"}], 
     RowBox[{"Coordinate", " ", 
      StyleBox[
       RowBox[{"A", 
        StyleBox["x",
         FontWeight->"Bold"], "es"}]], " ", "around", " ", "scene"}]},
    {
     RowBox[{"Shift", "-", "y"}], 
     RowBox[{
      RowBox[{"(", "beta", ")"}], " ", "Fly", " ", "mode"}]},
    {
     RowBox[{"Shift", "-", "z"}], 
     RowBox[{
      RowBox[{"Toggle", " ", "z"}], "-", 
      RowBox[{"buffer", " ", "mode"}]}]},
    {
     StyleBox["Selecting",
      FontWeight->"Bold"], 
     StyleBox["\[Placeholder]",
      FontWeight->"Bold"]},
    {
     RowBox[{"Ctrl", "-", 
      RowBox[{"Left", " ", "Mouse"}]}], 
     RowBox[{
     "Pick", " ", "geometry", " ", "with", " ", "left", " ", "mouse", " ", 
      "while", " ", "holding", " ", "control", " ", "key", " ", "to", " ", 
      "select", " ", "geometry", " ", "in", " ", "display"}]},
    {
     RowBox[{"Ctrl", "-", "tab"}], 
     RowBox[{
     "Cycle", " ", "through", " ", "the", " ", "registered", " ", 
      "geometries", " ", "of", " ", "a", " ", "scene"}]},
    {
     StyleBox["Deleting",
      FontWeight->"Bold"], "\[Placeholder]"},
    {
     RowBox[{"Backspace", "-", 
      RowBox[{"Left", " ", "Mouse"}]}], 
     RowBox[{
     "Pick", " ", "geometry", " ", "with", " ", "left", " ", "mouse", " ", 
      "while", " ", "holding", " ", "delete", " ", "key", " ", "to", " ", 
      "delete", " ", "geometry", " ", "in", " ", "display"}]},
    {
     StyleBox["Panels",
      FontWeight->"Bold"], 
     StyleBox["\[Placeholder]",
      FontWeight->"Bold"]},
    {"F1", 
     RowBox[{
     "Open", " ", "control", " ", "window", " ", "with", " ", "default", " ", 
      "panel"}]},
    {"F2", 
     RowBox[{"Close", " ", "control", " ", "window"}]},
    {
     RowBox[{"Ctrl", "-", "a"}], 
     RowBox[{"Show", " ", 
      StyleBox[
       RowBox[{
        StyleBox["A",
         FontWeight->"Bold"], "nimation"}]], " ", "Control", " ", "Panel", 
      " ", 
      RowBox[{"(", 
       RowBox[{"if", " ", "project", " ", "allows"}], ")"}]}]},
    {
     RowBox[{"Ctrl", "-", "c"}], 
     RowBox[{
      RowBox[{"Show", " ", 
       StyleBox[
        RowBox[{
         StyleBox["C",
          FontWeight->"Bold"], "amera"}]], " ", "panel"}], ",", " ", 
      RowBox[{"info", " ", "panel", " ", "of", " ", "camera"}]}]},
    {
     RowBox[{"Ctrl", "-", "d"}], 
     RowBox[{
      RowBox[{"Show", " ", 
       StyleBox[
        RowBox[{
         StyleBox["D",
          FontWeight->"Bold"], "ebug"}]], " ", "console"}], ",", " ", 
      RowBox[{
       RowBox[{
        StyleBox["JavaView",
         FontWeight->"Bold",
         FontSlant->"Italic",
         FontColor->RGBColor[0, 0.250004, 0.500008]], "'"}], "s", " ", 
       "console"}]}]},
    {
     RowBox[{"Ctrl", "-", "e"}], 
     RowBox[{
      RowBox[{
      "Show", " ", "vector", " ", "panel", " ", "of", " ", "geometry"}], ",", 
      " ", 
      RowBox[{"if", " ", "any"}]}]},
    {
     RowBox[{"Ctrl", "-", "f"}], 
     RowBox[{
      RowBox[{
      "Show", " ", "configuration", " ", "panel", " ", "of", " ", 
       "geometry"}], ",", " ", 
      RowBox[{"if", " ", "any"}]}]},
    {
     RowBox[{"Ctrl", "-", "i"}], 
     RowBox[{"Show", " ", 
      StyleBox[
       RowBox[{
        StyleBox["I",
         FontWeight->"Bold"], "nfo"}]], " ", "panel", " ", "of", " ", 
      "geometry"}]},
    {
     RowBox[{"Ctrl", "-", "l"}], 
     RowBox[{"Show", " ", 
      StyleBox[
       RowBox[{
        StyleBox["l",
         FontWeight->"Bold"], "ight"}]], " ", "panel"}]},
    {
     RowBox[{"Ctrl", "-", "m"}], 
     RowBox[{"Show", " ", 
      StyleBox[
       RowBox[{
        StyleBox["M",
         FontWeight->"Bold"], "aterial"}]], " ", "panel", " ", "of", " ", 
      "geometry"}]},
    {
     RowBox[{"Ctrl", "-", "p"}], 
     RowBox[{
      RowBox[{"Show", " ", "project", " ", "panel"}], ",", 
      RowBox[{"if", " ", "any"}]}]},
    {
     RowBox[{"Ctrl", "-", "t"}], 
     RowBox[{
      RowBox[{
      "Show", " ", "texture", " ", "panel", " ", "of", " ", "geometry"}], ",", 
      RowBox[{"if", " ", "any"}]}]},
    {
     RowBox[{"Ctrl", "-", "v"}], 
     RowBox[{
      RowBox[{"Show", " ", 
       StyleBox[
        RowBox[{
         StyleBox["V",
          FontWeight->"Bold"], "iewer"}]], " ", "panel"}], ",", " ", 
      RowBox[{"info", " ", "panel", " ", "of", " ", "display"}]}]},
    {
     RowBox[{"Ctrl", "-", "x"}], 
     RowBox[{"Show", " ", "axis", " ", "panel"}]},
    {
     StyleBox[
      RowBox[{"Menu", " ", "Shortcuts"}],
      FontWeight->"Bold"], "\[Placeholder]"},
    {
     RowBox[{"Ctrl", "-", "n"}], 
     RowBox[{"New", " ", "geometry", " ", "dialog"}]},
    {
     RowBox[{"Ctrl", "-", 
      RowBox[{"Shift", ".", "n"}]}], 
     RowBox[{
     "Load", " ", "a", " ", "JVD", " ", "file", " ", "with", " ", "same", " ",
       "base", " ", "name", " ", "as", " ", "recently", " ", "loaded", " ", 
      "model", " ", "file"}]},
    {
     RowBox[{"Ctrl", "-", "o"}], 
     RowBox[{
     "Open", " ", "file", " ", "import", " ", "dialog", " ", "to", " ", 
      "load", " ", "any", " ", "geometry", " ", "or", " ", "jvd", " ", 
      "file"}]},
    {
     RowBox[{"Ctrl", "-", "Shift", "-", "o"}], 
     RowBox[{
      RowBox[{
       RowBox[{"Same", " ", "as", " ", "Ctrl"}], "-", "o"}], ",", " ", 
      RowBox[{
      "but", " ", "additionally", " ", "load", " ", "a", " ", "JVD", " ", 
       "file", " ", "with", " ", "same", " ", "name", " ", "if", " ", "it", 
       " ", "exists"}]}]},
    {
     RowBox[{"Ctrl", "-", "s"}], 
     RowBox[{
     "Save", " ", "geometry", " ", "using", " ", "export", " ", "dialog"}]},
    {"\[Placeholder]", "\[Placeholder]"},
    {
     StyleBox["System",
      FontWeight->"Bold"], "\[Placeholder]"},
    {
     RowBox[{"Right", " ", "mouse"}], 
     RowBox[{"Open", " ", "popup", " ", "menu"}]},
    {
     RowBox[{"Ctrl", "-", "Shift", "-", "x"}], 
     RowBox[{"Immediate", " ", 
      StyleBox[
       RowBox[{"e", 
        StyleBox["X",
         FontWeight->"Bold"], "it"}]], " ", "of", " ", "a", " ", 
      StyleBox["JavaView",
       FontWeight->"Bold",
       FontSlant->"Italic",
       FontColor->RGBColor[0, 0.250004, 0.500008]], " ", "application"}]}
   }], NotebookDefault]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"781b457b-2830-4cf2-9fbb-debc81470d95"],

Cell[TextData[{
 "Keyboard shortcuts in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display (an excerpt). "
}], "Caption",ExpressionUUID->"5cc17618-8beb-47a5-88d6-933ecd2f03eb"]
}, Closed]],

Cell[CellGroupData[{

Cell["Different camera views, different display settings.", "MathCaption",ExpressionUUID->"516899b2-3f2a-4242-905c-20e2ec939152"],

Cell[TextData[{
 "Each ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display maintains its own settings. If you like to have different views on \
the same scene then just open another display and select your preferred \
camera and display settings. Or go to the camera inspector and enable the \
synchronized display of four displays with different projection settings."
}], "Text",ExpressionUUID->"560a8635-9503-4160-b3e4-922ac5a9f135"],

Cell["\<\
Different displays may also show a different set of geometries. But if a \
geometry is shared by displays, then it has the same shape and material in \
all displays. Therefore, if you have four displays with top, front, right, \
perspective view, then moving a vertex in either display will move the vertex \
in the other views too as you expect.\
\>", "Text",ExpressionUUID->"d5668904-5860-4096-ac74-5ed512f74a17"],

Cell["\<\
The control panel always views the camera and display panel of the currently \
active display. The current display is selected by moving the mouse over it. \
If there are many displays then this automatic selection might be annoying \
but it ensures that keyboard events are received by the display with mouse \
focus as expected (so we know about this problem).\
\>", "Text",ExpressionUUID->"bda91091-517d-4acc-a2ac-7da0cfec479e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Current geometry of a display.", "MathCaption",ExpressionUUID->"e141dc94-9a02-4f71-a8b3-049c63ed3c6c"],

Cell[TextData[{
 "Each ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display is able to display a scene with many geometries. One of these \
geometries is the active geometry. For example, you can pick vertices only of \
the active geometry."
}], "Text",
 CellDingbat->None,ExpressionUUID->"1c72d3c4-353e-493e-9073-5633e0244342"],

Cell["\<\
Note, the control panel shows the info and material panel of the current \
geometry.\
\>", "Text",
 CellDingbat->None,ExpressionUUID->"489d5880-2da2-4415-a290-3fe056ae8efd"],

Cell[TextData[{
 "The current geometry may be selected in different ways:\n1. Using keyboard \
shortcut Ctrl-tab or Ctrl-left mouse. This does not allow to select so-called \
",
 StyleBox["special geometries",
  FontSlant->"Italic"],
 " like the coordinate frame, xy-grid or bounding box.\n2. On the display \
panel select the active geometry. Here it is allowed to select special \
geometries too, and, for example, modify their appearance using their \
info/material/control panels.\n3. Via method call disp@selectGeometry[geom]."
}], "Text",
 CellDingbat->None,ExpressionUUID->"794e9022-a16e-48d1-9359-c325226f948e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Control Panel", "Subsection",ExpressionUUID->"92fff840-81ae-4748-895c-1c565b695843"],

Cell[TextData[{
 "The control window contains a set of panels to inspect the current geometry \
object, modify its material properties, select different camera type and to \
configure the active display.\nThe control panel may be opened in different \
ways:\n1. Click inside a display with the right mouse button and select the \
item 'Control Panel' from the popup menu.\n2. Ask the viewer manager to show \
the control panel, see below.\n3. If ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is called from the command line as in the command ",
 StyleBox["RunJavaView",
  FontFamily->"Courier New"],
 " then command line arguments may be specified like 'javaview panel=material \
control=show myDode.mgs' additional to a possible geometry file.\n4. If ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " runs inside an applet the applet parameters can be used to configure the \
initial setup like '<param name=config value=show>'."
}], "Text",ExpressionUUID->"51251304-3cc1-4599-88fc-96f08bef7f5c"],

Cell["\<\
If you did not keep your JavaView link from a session above then generate a \
new one.\
\>", "MathCaption",ExpressionUUID->"1e6d25fb-77ea-460e-830b-76a657ef6334"],

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\[IndentingNewLine]", 
 RowBox[{"viewer", " ", "=", " ", 
  RowBox[{"InstallJavaView", "[", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"b2a51fd0-1c26-44c5-a597-5682ead9dc65"],

Cell[TextData[{
 "Show the control window to inspect and configure the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " scene. Here we make use of the viewer obtained from command ",
 StyleBox["InstallJavaView",
  FontFamily->"Courier New"],
 " and the automatic pre-loading of the interface class PsViewerIf."
}], "MathCaption",
 CellChangeTimes->{
  3.7936182857065*^9},ExpressionUUID->"125cef04-c542-47c5-8539-705e1f114340"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"viewer", "@", 
   RowBox[{"showPanel", "[", "PsViewerIf`DISPLAY", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"viewer", "@", 
  RowBox[{"showDialog", "[", "PsViewerIf`CONTROL", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6363987588658175`*^9, 3.6363987762261143`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"ba2e1a70-a6de-4f68-8c9c-081a5b282adb"],

Cell[TextData[{
 "Java has some problems in bringing windows to the front, so the control \
panel might be hidden behind other windows. J/Link provides a special frame \
subclass to bring windows in front of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " but the current version of the viewer manager creates an own specialized \
frame."
}], "Text",ExpressionUUID->"03b467f9-2131-488f-8184-f0d1a4ec1115"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Pre-Configuration of a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " Display"
}], "Subsection",ExpressionUUID->"02cfee9a-f922-4747-b7c3-dfc7dc422b68"],

Cell[TextData[{
 "Normally, the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display is initialized during each invocation such that all previous \
interactive configurations of a display are removed and reset to their \
default state. In some cases, a pre-configuration of the display is wanted \
were, for example, bounding box, axes frame and background image are enabled \
and visible when ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "[] is launched.\nThe pre-configuration of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display is possible by configuration of the ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object. The ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object represents the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display and can be obtained from the viewer manager. A large number of \
methods allow to configure even more feature than are available through the \
interactive display inspector.\nA configuration of the ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object must be followed by an ",
 StyleBox["update",
  FontSlant->"Italic"],
 " of the display in order to take effect.\nThe ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object received from the viewer manager becomes void if a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " window is closed. When closing a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " window the ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object is removed from the viewer and destroyed, although the reference \
from inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will still exist but no longer work. Therefore, after closing a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " window the ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object must be obtained again from the viewer manager."
}], "Text",
 CellChangeTimes->{{3.793618260852037*^9, 
  3.793618276177472*^9}},ExpressionUUID->"20c6cee9-4b25-4038-893a-\
c2de0582da75"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load the JavaView`JLink` package including the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.636574831214822*^9, 
  3.636574831246012*^9}},ExpressionUUID->"29fec58f-fae0-4a46-a7ec-\
55413918bccd"],

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"viewer", " ", "=", " ", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"a42488c7-e9bd-47e6-8e7e-5dee8bcd378e"],

Cell[CellGroupData[{

Cell["Get the disp object from the viewer manager.", "MathCaption",ExpressionUUID->"1d1357cf-9747-462e-b07f-918780dd8892"],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"14a2d77d-9486-400f-b869-c0cb130d7de8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Configure the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display, and invoke update[] to enable the changes."
}], "MathCaption",ExpressionUUID->"6ef90668-a45f-4bbc-aec3-400d86a74c1a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"showFrame", "[", "True", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"showAxes", "[", "True", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"showBndBox", "[", "True", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"showBackImage", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"e04416f6-d773-4dad-9208-4292850f8572"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The parameter ",
 StyleBox["KeepView->True",
  FontSlant->"Italic"],
 " prevents an initialization of the display"
}], "MathCaption",ExpressionUUID->"71644b6b-c20f-4d24-8fb9-d04c6c877154"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dode", "=", " ", 
   RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", 
  RowBox[{"dode", ",", 
   RowBox[{"KeepView", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6363984517151394`*^9, 3.6363984624287586`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"5c86c2ff-46ee-4369-9480-0d3df31daacb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "There exist many methods to configure a ",
 StyleBox["disp",
  FontSlant->"Italic"],
 " object which can be shown with the command Methods[]. The listing includes \
many more methods which are not useful in this context, but the relevant \
configuration methods have the form setEnableXxxx[] or showXxxx[]. The \
methods are not documented within the ",
 StyleBox["JavaView`JLink`",
  FontSlant->"Italic"],
 " package but at the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " website in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " reference documentation at ",
 StyleBox["http://www.javaview.de/doc/reference/index.html",
  FontFamily->"Courier New",
  FontSize->10,
  FontVariations->{"Underline"->True},
  FontColor->RGBColor[0, 0, 0.996109]],
 ". The configuration methods are described in the class jv.viewer.PvDisplay \
available at ",
 StyleBox["http://www.javaview.de/doc/reference/jv/viewer/PvDisplay.html",
  FontFamily->"Courier New",
  FontSize->10,
  FontVariations->{"Underline"->True},
  FontColor->RGBColor[0, 0, 0.996109]],
 "."
}], "Text",ExpressionUUID->"0fd760f7-753f-4412-81dd-6492aa432cf9"],

Cell[TextData[{
 "Show all available methods of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display (many more than you might ever use)."
}], "MathCaption",
 CellChangeTimes->{{3.6363985003766627`*^9, 
  3.6363985067842197`*^9}},ExpressionUUID->"24e52eb9-39a4-47e7-8802-\
b73986d9c02d"],

Cell[BoxData[
 RowBox[{"Methods", "[", "disp", "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"9d183979-eed0-44f3-b8c4-8e0aaffe33cf"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Basics of Using Java in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (optional)"
}], "Section",
 CellChangeTimes->{{3.6365628808820667`*^9, 3.636562890366578*^9}, {
  3.6365653461806693`*^9, 3.6365653624780846`*^9}, {3.7949478683957253`*^9, 
  3.7949478708270807`*^9}},ExpressionUUID->"d4f0968e-2384-4011-bef4-\
78d32202fcb9"],

Cell[CellGroupData[{

Cell["Launching J/Link", "Subsection",ExpressionUUID->"273068c7-c46f-494e-abf2-84fc7e9ba9ff"],

Cell[TextData[{
 "The first step is to load the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package file. If you have installed ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " as described in the installation chapter of the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " manual, you will be able to load the package:"
}], "Text",
 CellChangeTimes->{{3.6365635710079236`*^9, 
  3.6365635805550485`*^9}},ExpressionUUID->"5da75c35-7757-4b9e-88c8-\
a5d8ddf5171b"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"<<", "JLink`"}], "MR",
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox[
      RowBox[{"load", " ", "the", " ", 
       RowBox[{"J", "/", "Link"}], " ", "package"}], "Text"]},
    {
     StyleBox[
      RowBox[{"InstallJava", "[", "]"}], "MR",
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox[
      RowBox[{
       RowBox[{
       "launch", " ", "the", " ", "Java", " ", "runtime", " ", "and", " ", 
        "prepare", " ", "it", " ", "for", " ", "use", " ", "from"}], "\n", 
       "Mathematica"}], "Text"]},
    {
     StyleBox[
      RowBox[{
       StyleBox["UninstallJava",
        FontFamily->"Courier New",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontVariations->{"StrikeThrough"->False,
        "Underline"->False},
        FontColor->GrayLevel[0]], "[", "]"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{"quit", " ", "the", " ", "Java", " ", "runtime"}]}
   }], NotebookDefault]], "DefinitionBox",
 CellChangeTimes->{{3.6365637429708824`*^9, 3.63656374947092*^9}},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"98916880-383c-4991-9ad9-9bf2f5c6b7af"],

Cell[TextData[{
 "Launching ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and Java."
}], "Caption",
 CellChangeTimes->{
  3.63656375956499*^9},ExpressionUUID->"3a1d1003-8889-48f8-b2f6-dd86cc7e72ef"],

Cell["Load J/Link.", "MathCaption",
 CellChangeTimes->{{3.636563757596342*^9, 
  3.636563762315076*^9}},ExpressionUUID->"3022511b-0bef-417a-9b36-\
428a169f2742"],

Cell[BoxData[
 RowBox[{"<<", "JLink`"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"0d5889f3-3c0c-4269-934c-d2a35b82f42d"],

Cell[TextData[{
 "The command ",
 StyleBox["InstallJava",
  FontFamily->"Courier New"],
 " launches the Java runtime which may be selected by providing additional \
options."
}], "Text",
 CellChangeTimes->{{3.6365623567298384`*^9, 
  3.636562358042387*^9}},ExpressionUUID->"75d91d0f-f7f1-4659-9abf-\
4136fbd7ec6c"],

Cell["Launch the Java runtime with default options.", "MathCaption",
 CellChangeTimes->{{3.636562291289859*^9, 
  3.6365622959306507`*^9}},ExpressionUUID->"5f31eff6-22ec-4764-b6cd-\
ba7698ffde5e"],

Cell[BoxData[
 RowBox[{"InstallJava", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"d19798fa-4e41-48f2-a230-a6e0d8a73cfb"],

Cell["\<\
InstallJava can be called more than once in a session. On every call after \
the first, it does nothing. Thus, it is safe to call InstallJava in any \
program you write, without considering whether the user has already called \
it. Only one Java runtime will ever be in use.\
\>", "Text",
 CellChangeTimes->{{3.636561972485295*^9, 3.6365619737354136`*^9}, 
   3.6365623321819715`*^9},ExpressionUUID->"d201fddf-a637-482f-87ec-\
b90c9bd51b2a"],

Cell["\<\
Calling the Java runtime with special options requires a prior uninstalling \
respectively re-installation.\
\>", "Text",
 CellChangeTimes->{{3.6365623567298384`*^9, 3.636562358042387*^9}, {
   3.6365624627229643`*^9, 3.6365625459912825`*^9}, 
   3.7936183453368273`*^9},ExpressionUUID->"8b9a246d-6a79-4cd9-b354-\
ef38ffcd0e58"],

Cell[TextData[{
 "A different invocation explicitly selects the Java runtime through options \
of ",
 StyleBox["InstallJava",
  FontFamily->"Courier New"],
 "."
}], "MathCaption",ExpressionUUID->"526f0fd6-1713-4e6b-b657-da34459d0ff2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UninstallJava", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InstallJava", "[", 
  RowBox[{"CommandLine", "->", "\"\<javaw\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.636398545050351*^9, 3.6363985546731963`*^9}, {
  3.6365621057770414`*^9, 3.63656211057413*^9}, {3.6365623874496994`*^9, 
  3.636562433737486*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"2c2df6f1-01c5-4921-bc2b-4d907f9f8d11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Java Objects", "Subsection",ExpressionUUID->"9c6b07da-23ee-44c6-9103-b0cd4709bdb9"],

Cell["\<\
To instantiate Java objects, use the JavaNew[] function. The first argument \
to JavaNew is the object\[CloseCurlyQuote]s class, specified either as a \
JavaClass expression returned from LoadClass or as a string giving the \
fully-qualified class name (i.e., having the full package prefix with all the \
periods). If you wish to supply any arguments to the \
object\[CloseCurlyQuote]s constructor, they follow as a sequence after the \
class.\
\>", "Text",ExpressionUUID->"651aee5a-8597-42ba-a1f3-7c9469fa5708"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{
       StyleBox["JavaNew", "MR"], 
       StyleBox["[", "MR"], 
       RowBox[{
        StyleBox[
         FormBox["classname",
          TraditionalForm], "TI"], ",", " ", "arg1", ",", " ", "..."}], 
       StyleBox["]", "MR"]}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{
      RowBox[{
      "construct", " ", "a", " ", "new", " ", "object", " ", "of", " ", "the",
        " ", "specified", " ", "class", " ", "and", " ", "return"}], "\n", 
      RowBox[{"it", " ", "to", " ", "Mathematica"}]}]},
    {
     StyleBox[
      RowBox[{
       StyleBox["LoadClass", "MR"], 
       StyleBox["[", "MR"], 
       StyleBox[
        FormBox["classname",
         TraditionalForm], "TI"], 
       StyleBox["]", "MR"]}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox[
      RowBox[{
      "load", " ", "the", " ", "specified", " ", "class", " ", "into", " ", 
       "Java", " ", "and", " ", "Mathematica"}], "Text"]},
    {
     StyleBox[
      RowBox[{
       StyleBox["ReleaseObject",
        FontFamily->"Courier New",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontVariations->{"StrikeThrough"->False,
        "Underline"->False},
        FontColor->GrayLevel[0]], "[", 
       StyleBox["obj",
        FontSlant->"Italic"], "]"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     RowBox[{
     "let", " ", "Java", " ", "know", " ", "that", " ", "you", " ", "are", 
      " ", "done", " ", "using", " ", 
      StyleBox["obj",
       FontSlant->"Italic"], " ", "in", " ", "Mathematica"}]}
   }], TextForm]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"223a5340-2096-4cf1-9bbc-48a565e3036d"],

Cell["Creating Java classes in Mathematica.", "Caption",ExpressionUUID->"a9a26172-f5f6-4681-8a49-66ddaab6bdf4"],

Cell[TextData[{
 "Now we create a linear algebra vector in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " which mainly consists of an array of double values. The initial length of \
the array may be given as constructor argument. Double and integer vectors \
are the base classes used in all geometry classes of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"e77854a2-9e95-48af-9ad9-3e634c4f04f0"],

Cell["Create a new vector with different constructors.", "MathCaption",ExpressionUUID->"031ed2ea-3f65-4485-8c9b-b6dee866f84b"],

Cell[BoxData[{
 RowBox[{"vec0", "=", 
  RowBox[{
  "JavaNew", "[", "\"\<jv.vecmath.PdVector\>\"", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"vec3", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<jv.vecmath.PdVector\>\"", ",", "3"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"1cfbedab-1a54-4ba6-803c-1fa698c4b806"],

Cell["We check the length of the return vectors.", "MathCaption",ExpressionUUID->"1f24b00a-33a7-4ede-ba9a-4d08660203e5"],

Cell[BoxData[{
 RowBox[{"vec0", "@", 
  RowBox[{"getSize", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"vec3", "@", 
  RowBox[{"getSize", "[", "]"}]}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"cdc7b9c3-53f4-4d69-b291-893192a66456"],

Cell[BoxData[
 RowBox[{"vec3", "@", 
  RowBox[{"setEntry", "[", 
   RowBox[{"2", ",", " ", "17."}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"711666f3-daa4-4c2b-9780-e87d11cdfa96"],

Cell[BoxData[
 RowBox[{"vec3", "@", 
  RowBox[{"getEntries", "[", "]"}]}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"f800f007-d0c4-415f-a2bf-c5f874b6bf96"],

Cell["\<\
The return value from JavaNew[] can be considered as a reference to the Java \
object, although it is a strange expression internally that will be referred \
to as JavaObject expression. JavaNew[] is not the only way to get a reference \
to a Java object in Mathematica. Many methods and fields return objects. Such \
objects can be used in the same way as ones you explicitly construct with \
JavaNew[].\
\>", "Text",
 CellChangeTimes->{{3.6365636234627094`*^9, 
  3.6365636279630175`*^9}},ExpressionUUID->"f2cdcbfd-791b-48ef-b611-\
4ed671a19522"]
}, Closed]],

Cell[CellGroupData[{

Cell["Naming Conventions", "Subsection",ExpressionUUID->"0cff18d3-4b98-4a7f-acfe-4e88808175e4"],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " strictly follows the rules of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming language. This has certain implications how Java is accessed."
}], "Text",
 CellChangeTimes->{
  3.636563632212984*^9},ExpressionUUID->"1ecf5064-2429-41af-808a-\
d15c32b9d937"],

Cell["\<\
Access to public fields and methods follows the same rules as in Java with a \
slight difference in notation. Instead of '.' J/Link uses '@' for non-static \
respectively '`' for static fields and methods. Further, argument brackets [] \
are used instead of ().\
\>", "Text",ExpressionUUID->"a22f4d5a-cf6e-490e-ab61-87ee90fc6b81"],

Cell["\<\
Note, there is an issue with underscores used in method and variable names. \
They must be replaced by a capital 'U' unless the name appears inside of a \
string.\
\>", "Text",ExpressionUUID->"17abdf41-536b-4051-85aa-fb594ec817f3"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox["Java", "MR",
      FontVariations->{"Underline"->True}], 
     StyleBox["Mathematica",
      FontVariations->{"Underline"->True}]},
    {
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"obj", ".", "methodName"}], 
        RowBox[{"(", "args", ")"}]}], ";"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox[
      RowBox[{
       RowBox[{"obj", "@", 
        RowBox[{"methodName", "[", "args", "]"}]}], ";"}], "Text",
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]]},
    {
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"MyClass", ".", "staticMethod"}], 
        RowBox[{"(", "args", ")"}]}], ";"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox[
      RowBox[{
       RowBox[{"MyClass`staticMethod", "[", "args", "]"}], ";"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]]},
    {
     StyleBox[
      RowBox[{"MyClass", ".", "UNDER_SCORE"}],
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]], 
     StyleBox["MyClass`UNDERUSCORE",
      FontFamily->"Courier New",
      FontSize->12,
      FontWeight->"Plain",
      FontSlant->"Plain",
      FontVariations->{"StrikeThrough"->False,
      "Underline"->False},
      FontColor->GrayLevel[0]]}
   }], TextForm]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> \
{}}},ExpressionUUID->"531603d4-c585-4757-86c2-5679d6270ad9"],

Cell["Naming conventions used by J/Link.", "Caption",ExpressionUUID->"458712a8-ce82-40ab-8483-ed592e9ea715"],

Cell[TextData[{
 "Before accessing a static variables the class must be loaded once. The \
command ",
 StyleBox["InstallJavaView",
  FontFamily->"Courier New"],
 " of the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " pre-loads some basic ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " classes but we repeat the loading here for completeness."
}], "Text",ExpressionUUID->"0a56586a-de5f-474d-a6be-4b5013b34fba"],

Cell["\<\
Load static classes prior to access of static variables. Notice the 'U'.\
\>", "MathCaption",ExpressionUUID->"64cf0735-85ef-47da-a586-42d555822737"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadClass", "[", "\"\<jv.object.PsObject\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", "PsObject`ISUSELECTED"}], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"b9d95e41-398e-4470-8fe6-0f753a6c4dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Arrays in Java and Lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",ExpressionUUID->"7a9ba4c3-09ed-417d-8ea7-d78208131dab"],

Cell[TextData[{
 "The level of exchange of larger data between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java is usually done on the basis of arrays in Java and lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as their counterparts.\nThe vector classes PdVector and PiVector used in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " have the functionality of double respectively integer arrays of arbitrary \
size. Basically, they contain a data fields 'double [] data' respectively \
'int [] data'."
}], "Text",ExpressionUUID->"bc72e023-087c-4364-836a-c7375363d5cf"],

Cell[TextData[{
 "Here we call some basic linear algebra methods. Java objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " behave like usual Java instances."
}], "MathCaption",ExpressionUUID->"336c51d5-be10-402d-a490-7d563f327733"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec0", "@", 
   RowBox[{"setSize", "[", "3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec0", "@", 
   RowBox[{"setConstant", "[", "1.", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec3", "@", 
   RowBox[{"add", "[", "vec0", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec3", "@", 
    RowBox[{"setEntry", "[", 
     RowBox[{"0", ",", "17"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"JavaView", " ", "converts", " ", "argument", " ", "to", " ", 
    RowBox[{"double", "."}]}], " ", "*)"}]}]}], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"472bad01-36c3-42f8-90e3-2b50a658d4d9"],

Cell[TextData[{
 "Note, Java arrays start with index 0 while ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists start at index 1. This is essential when converting between Java \
arrays and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists."
}], "Text",ExpressionUUID->"603a811a-dd6d-4083-8880-66bbc309841e"],

Cell[TextData[{
 "The content of the vector can be converted back and forth to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list."
}], "MathCaption",ExpressionUUID->"55a4d1d9-bc92-4669-a193-e770dd8e99d0"],

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"vec3", "@", 
   RowBox[{"getEntries", "[", "]"}]}]}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"751b0b6e-abaa-4530-b2ea-f550b0c00b2d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", "19."}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vec3", "@", 
   RowBox[{"set", "[", "v", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vec3", "@", 
  RowBox[{"getEntries", "[", "]"}]}]}], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"c8c8ce70-5e46-4ab6-bb05-01a3b3d4d920"],

Cell["\<\
Create a new vector which is initialized with the data of the existing vector \
v.\
\>", "MathCaption",ExpressionUUID->"6183b543-3b09-4f39-b1d4-0d65788e6b1e"],

Cell[BoxData[
 RowBox[{"kh", "=", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<jv.vecmath.PdVector\>\"", ",", " ", "v"}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"3ca55fa1-f544-461b-978c-3e1fb6adff23"],

Cell[BoxData[
 RowBox[{"kh", "@", 
  RowBox[{"getEntries", "[", "]"}]}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"58edd1ec-b75f-4c4d-bebc-54f5eaec2f1c"],

Cell["Create a new empty surface.", "MathCaption",ExpressionUUID->"bf24126f-e535-45f2-b0a3-141d477d3382"],

Cell[BoxData[{
 RowBox[{"torus", " ", "=", " ", 
  RowBox[{"JavaNew", "[", 
   RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", " ", "3"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"torus", "@", 
   RowBox[{"setName", "[", "\"\<fancy torus\>\"", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"00ecc47e-7148-421a-9a6a-c2017a295b01"],

Cell["\<\
Use a helper routine to create a torus over a 10*10 grid and radii 2 and 1.\
\>", "MathCaption",ExpressionUUID->"8440f221-34af-48ae-b3ee-85f2d147e1ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"torus", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"10", ",", " ", "10", ",", " ", "2.", ",", " ", "1."}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"950442a2-6dbb-4c02-b609-0972c419382b"],

Cell["\<\
Here we are just accessing the 16th vertex of the torus. Note, array counting \
starts at 0 in Java.\
\>", "MathCaption",ExpressionUUID->"74c2dfc5-2736-49b6-9ae4-80a56f2bebd5"],

Cell[BoxData[
 RowBox[{"torus", "@", 
  RowBox[{
   RowBox[{"getVertex", "[", "16", "]"}], "@", 
   RowBox[{"getEntries", "[", "]"}]}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"4ad94461-60e4-4e24-892b-ff6207978c51"],

Cell[TextData[{
 "Note, J/Link converts a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list to an array of doubles only if ALL entries are floating point numbers."
}], "Text",ExpressionUUID->"21c48a3f-325f-4490-92b0-12964635b62c"],

Cell[TextData[{
 "If the list v contains an integer then the setting fails since ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does not find the Java method. "
}], "MathCaption",
 CellChangeTimes->{
  3.6365637093291874`*^9},ExpressionUUID->"6c949692-b286-41f6-bf3d-\
13bf333b36dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", "19"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec3", "@", 
    RowBox[{"set", "[", "v", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"!", 
    RowBox[{"!", 
     RowBox[{"!", " ", 
      RowBox[{"v", " ", "contains", " ", "an", " ", "integer", " ", 
       RowBox[{"component", "."}]}]}]}]}], " ", "*)"}]}]}], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"4b67cea6-4a1c-456a-9adf-022eec30cf75"],

Cell[BoxData[
 RowBox[{"vec3", "@", 
  RowBox[{"set", "[", 
   RowBox[{"17.", ",", "19", ",", "1."}], "]"}]}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"2710346a-7160-424d-bd3f-9d9b2c57f1b0"],

Cell[TextData[{
 "When transferring large arrays of geometric data back and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " it is time to read the section on performance issues in the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " manual."
}], "Text",
 CellChangeTimes->{{3.6365636511822853`*^9, 
  3.636563653901329*^9}},ExpressionUUID->"e6f9dc3e-ff03-4c46-9d22-\
134def51f6ba"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Section",ExpressionUUID->"ed12dff2-60b3-44a4-966c-8c2dcd421792"],

Cell[TextData[{
 "Although this text consists of informal notes, I would like use the \
opportunity to include thanks to Paul Wellin and Tom Wickham-Jones from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for pointing my attention to J/Link and providing a development edition of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and to Todd Gayley who designed the marvellous ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " package and answered my numerous questions. In many aspects, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is this perfect interface to allow true interactive, high level \
integration of mathematical software which I was looking for a long time."
}], "Text",
 CellChangeTimes->{3.636563661307822*^9, 
  3.6365636953756247`*^9},ExpressionUUID->"0cee0d06-defc-4cc0-9bbb-\
64717e682af4"],

Cell[TextData[{
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is software written by Konrad Polthier and contributors as listed in the \
About menu of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics parser in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " is written by Ulrich Reitebuch. The ",
 StyleBox["JavaView\[CloseCurlyQuote]JLink",
  FontSlant->"Italic"],
 " packages for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are designed and written by Konrad Polthier."
}], "Text",
 CellChangeTimes->{{3.63656185553796*^9, 3.6365619136389847`*^9}, {
   3.6365636662921877`*^9, 3.6365636912502975`*^9}, 3.7943470108869896`*^9, {
   3.794947953822672*^9, 
   3.7949479593985806`*^9}},ExpressionUUID->"5133ab52-505b-46dc-8912-\
19f501ec3748"]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{687., 842.5},
WindowMargins->{{461, Automatic}, {Automatic, 24}},
ShowCellTags->True,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"da7f0fc3-8e2c-4925-9882-d83795384fc5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 321, 8, 64, "Chapter",ExpressionUUID->"7cee7c83-ad2a-4135-9baa-90a50a6e88ea",
 CellGroupingRules->"SectionGrouping"],
Cell[CellGroupData[{
Cell[926, 34, 600, 7, 40, InheritFromParent,ExpressionUUID->"697e8632-b9a3-4e25-9994-ed9720a47e71"],
Cell[1529, 43, 1264, 30, 147, "Text",ExpressionUUID->"41a9aaaa-25f8-4b57-bc19-3ab025c81622"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2830, 78, 86, 0, 47, "Section",ExpressionUUID->"0dfe02cf-a865-4093-9c52-c9253dccfbc7"],
Cell[2919, 80, 994, 29, 48, "Text",ExpressionUUID->"ad8c6b3b-c7d8-4705-b9bf-519dd6249b94"],
Cell[3916, 111, 1034, 33, 48, "Text",ExpressionUUID->"9bcd19d0-23af-4b68-bb61-be2dff7f9200"],
Cell[4953, 146, 1342, 29, 89, "Text",ExpressionUUID->"371a8e70-a042-4046-852f-f60e97fcb466"],
Cell[6298, 177, 188, 6, 14, "Caption",ExpressionUUID->"f4f23a8d-f5e4-4958-82dc-781c02a8da93"],
Cell[6489, 185, 567, 15, 26, "Text",ExpressionUUID->"3a2e9758-1b3a-4439-81ae-6296674e40ed"],
Cell[7059, 202, 1161, 34, 59, "Text",ExpressionUUID->"d10a9b1b-23d4-4ae6-933c-49ca2df4bd0b"],
Cell[8223, 238, 597, 19, 26, "Text",ExpressionUUID->"1f8f8ffd-1a39-4b99-a1e2-9ed510d8a24a"],
Cell[8823, 259, 413, 11, 26, "Text",ExpressionUUID->"0a457766-f3c6-46bf-b10c-fd2de575920d"]
}, Closed]],
Cell[CellGroupData[{
Cell[9273, 275, 86, 0, 28, "Section",ExpressionUUID->"e930f944-7a79-4cc8-8cdc-fb1ac236faf7"],
Cell[9362, 277, 875, 32, 26, "Text",ExpressionUUID->"d0f1d15e-cbc7-4f5a-bde7-ee9437965ec4"],
Cell[10240, 311, 221, 8, 30, "MathCaption",ExpressionUUID->"bb6ac4ef-6ee5-4e1d-9a4a-88fd7e33eb58"],
Cell[10464, 321, 557, 15, 22, "NumberedEquation",ExpressionUUID->"9fb39432-b849-415e-bd9c-c182b6252ba9"],
Cell[11024, 338, 1042, 21, 22, "NumberedEquation",ExpressionUUID->"3be72625-444e-4258-8ef3-6604061b23b0"],
Cell[12069, 361, 1415, 51, 37, "Text",ExpressionUUID->"286d9b34-1a0b-41c2-af67-7f17ab39be14"],
Cell[13487, 414, 1407, 45, 48, "Text",ExpressionUUID->"9a5f7560-7569-4f6f-9b9c-de7eb24c20ba"],
Cell[14897, 461, 450, 14, 18, "Text",ExpressionUUID->"bd54f819-ade7-4f6b-9f7d-7fd62b4ae857"],
Cell[15350, 477, 1176, 31, 48, "Text",ExpressionUUID->"f8b1f198-c809-4971-8036-d21b49d56bc2"]
}, Closed]],
Cell[CellGroupData[{
Cell[16563, 513, 281, 11, 28, "Section",ExpressionUUID->"393d3f88-a7d2-4695-b086-d94504c7654d"],
Cell[16847, 526, 828, 27, 26, "Text",ExpressionUUID->"866f38fc-468c-4a54-99e5-6234c9fdcaaf"],
Cell[17678, 555, 592, 14, 37, "Text",ExpressionUUID->"89bdf5d7-7946-4064-8ada-cff01aaa5001"],
Cell[CellGroupData[{
Cell[18295, 573, 301, 11, 30, "MathCaption",ExpressionUUID->"325ba2f2-e3ea-4747-a265-772507fcf3da"],
Cell[18599, 586, 115, 0, 22, "NumberedEquation",ExpressionUUID->"7dff3123-c717-405f-8c54-e70347380a13"],
Cell[18717, 588, 109, 0, 22, "NumberedEquation",ExpressionUUID->"da9dac7a-44cf-4a8e-ae32-ddde03919ea2"],
Cell[18829, 590, 220, 4, 22, "NumberedEquation",ExpressionUUID->"16a5180f-81fa-414b-9c27-1f66eb562649"],
Cell[19052, 596, 1079, 24, 63, "NumberedEquation",ExpressionUUID->"aea7eb62-9fb8-42e0-9bd9-dcc693c7bc52"],
Cell[20134, 622, 827, 17, 52, "NumberedEquation",ExpressionUUID->"3480af2b-19b8-43c2-8d7e-87896529246b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20998, 644, 353, 12, 30, "MathCaption",ExpressionUUID->"0a496111-c556-412a-ab89-066972e8a72a"],
Cell[21354, 658, 115, 0, 22, "NumberedEquation",ExpressionUUID->"7b8f44c2-80f8-4630-8ef7-a0a7b2ad4ccd"],
Cell[21472, 660, 109, 0, 22, "NumberedEquation",ExpressionUUID->"4a3bfcec-1cf4-4956-a7ee-9dceff4478f7"],
Cell[21584, 662, 502, 9, 31, "NumberedEquation",ExpressionUUID->"faee2d8b-70af-4c17-b028-3b31261712c5"],
Cell[22089, 673, 653, 13, 52, "NumberedEquation",ExpressionUUID->"40899d84-5b50-4d79-aceb-1e0fe5d857e2"],
Cell[22745, 688, 792, 15, 52, "NumberedEquation",ExpressionUUID->"3433dbfe-8c1b-4bf5-856b-541bf66f7f84"]
}, Open  ]],
Cell[23552, 706, 738, 24, 26, "Text",ExpressionUUID->"b585105b-a563-45b1-8d10-ce73243c68d9"],
Cell[24293, 732, 411, 9, 26, "Text",ExpressionUUID->"ce3e0aa5-9389-4ea8-b70a-7d4ea6f47831"],
Cell[24707, 743, 1127, 29, 48, "Text",ExpressionUUID->"fddf2bf8-cee1-4eff-a1f0-f527e23d15e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[25871, 777, 298, 9, 28, "Section",ExpressionUUID->"f426655e-7721-42d4-aacc-1e301cc8f9f6"],
Cell[26172, 788, 686, 19, 37, "Text",ExpressionUUID->"24ad8689-95ad-48b4-8ab0-59aaca172e06"],
Cell[CellGroupData[{
Cell[26883, 811, 324, 12, 28, "Subsection",ExpressionUUID->"20005b9e-f42f-4e62-93d2-996a621a64e5"],
Cell[27210, 825, 450, 16, 18, "Text",ExpressionUUID->"0928735a-60fa-4e8d-a8ed-4249023fbffd"],
Cell[CellGroupData[{
Cell[27685, 845, 218, 8, 25, "Subsubsection",ExpressionUUID->"0fcf634a-f15f-47cb-8877-9048056acbd8"],
Cell[27906, 855, 314, 8, 18, "Text",ExpressionUUID->"12c237e5-90b6-4568-b1c4-098643c8152c"],
Cell[28223, 865, 149, 2, 20, "Input",ExpressionUUID->"aee0ac12-0319-436b-8296-084f95bbf1a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28409, 872, 153, 3, 25, "Subsubsection",ExpressionUUID->"099515be-cad2-46f5-a15f-2ad9ddb202d0"],
Cell[28565, 877, 263, 7, 18, "Text",ExpressionUUID->"03b4661d-272c-411c-ad83-9a19fb88d1ad"],
Cell[28831, 886, 322, 9, 30, "DefinitionBox",ExpressionUUID->"6db20853-5632-4231-98b3-a71c0e2e09f7"],
Cell[29156, 897, 154, 4, 14, "Caption",ExpressionUUID->"30436e31-3e09-4232-9891-6f637b3d8ed0"],
Cell[29313, 903, 186, 3, 30, "MathCaption",ExpressionUUID->"a446c897-8e17-4688-a0cb-bee8347fd51a"],
Cell[29502, 908, 130, 1, 20, "Input",ExpressionUUID->"1e8534ac-7f87-4d29-bb96-dcb8aaa113db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29669, 914, 142, 3, 25, "Subsubsection",ExpressionUUID->"ad360108-2ce5-4abc-9bb3-eb763f13cb27"],
Cell[29814, 919, 340, 8, 18, "Text",ExpressionUUID->"a1848941-dcff-49b7-be2b-8988f887c9cb"],
Cell[30157, 929, 442, 12, 30, "DefinitionBox",ExpressionUUID->"8fed496f-fe30-416b-9e6b-fefe4f04254f"],
Cell[30602, 943, 101, 0, 14, "Caption",ExpressionUUID->"d8657a3b-d23f-41e5-8497-0cb221184f7d"],
Cell[30706, 945, 206, 3, 30, "MathCaption",ExpressionUUID->"8d26d6f9-247c-45a0-ae0a-f8a9f5f84dda"],
Cell[30915, 950, 205, 3, 20, "Input",ExpressionUUID->"fd27fbf9-5798-4d19-b072-17ec60cb56ca"],
Cell[31123, 955, 876, 27, 39, "Text",ExpressionUUID->"563fc2ec-9ed9-4169-bcf5-464ff07c3093"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32048, 988, 273, 9, 28, "Subsection",ExpressionUUID->"614be978-6666-49fa-bdfe-cd1936d42ed3"],
Cell[32324, 999, 786, 25, 26, "Text",ExpressionUUID->"01dfe816-93ca-4ea9-99a1-fd60cd5f918c"],
Cell[CellGroupData[{
Cell[33135, 1028, 273, 9, 25, "Subsubsection",ExpressionUUID->"1c7d2e4b-44f0-4eb5-bf1c-212561f1a9a8"],
Cell[33411, 1039, 394, 11, 18, "Text",ExpressionUUID->"cc10b22a-1b0c-481b-b4cb-4fecd2d3e8d0"],
Cell[33808, 1052, 137, 2, 20, "Input",ExpressionUUID->"b22e0e7e-b5ae-46f1-9a92-590bfb1ea21f"]
}, Closed]],
Cell[CellGroupData[{
Cell[33982, 1059, 177, 3, 25, "Subsubsection",ExpressionUUID->"2f3c478c-0379-43d4-a00a-8de2109efe02"],
Cell[34162, 1064, 502, 13, 18, "Text",ExpressionUUID->"ca4f35bc-c4c5-4820-8566-9dc195782232"],
Cell[34667, 1079, 485, 12, 30, "DefinitionBox",ExpressionUUID->"fc710736-333e-4af9-9599-7938656bb7a5"],
Cell[35155, 1093, 291, 8, 14, "Caption",ExpressionUUID->"ba0021af-f268-402a-b111-33e5065f19eb"],
Cell[35449, 1103, 192, 3, 30, "MathCaption",ExpressionUUID->"a0324755-881a-4368-aafb-54587b643b57"],
Cell[35644, 1108, 240, 3, 20, "Input",ExpressionUUID->"0c3c3e15-e360-46d8-a8a0-0cfed6a54a3c"]
}, Closed]],
Cell[CellGroupData[{
Cell[35921, 1116, 267, 5, 25, "Subsubsection",ExpressionUUID->"9aa9461d-b3d0-4e7c-bb77-8ebca8843879"],
Cell[36191, 1123, 413, 13, 18, "Text",ExpressionUUID->"66aadb06-ed95-44f1-8eb5-e47fc7216bb1"],
Cell[36607, 1138, 1600, 57, 41, "DefinitionBox",ExpressionUUID->"161e90e1-8521-438a-b40d-1c0dd8c28e97"],
Cell[38210, 1197, 175, 3, 14, "Caption",ExpressionUUID->"d632cfb0-a152-4c86-b640-553cc6179bc6"],
Cell[38388, 1202, 237, 8, 30, "MathCaption",ExpressionUUID->"360503c1-582f-46a8-a3b3-93f04184c209"],
Cell[38628, 1212, 462, 7, 20, "Input",ExpressionUUID->"ce286408-5dfc-4c72-8062-09b7cc620a6a"],
Cell[39093, 1221, 359, 9, 18, "Text",ExpressionUUID->"42bc08e6-a0b4-4e41-bf45-fc4fcdcf6276"],
Cell[39455, 1232, 634, 17, 30, "DefinitionBox",ExpressionUUID->"5fb2882d-4e9c-4f1b-98a8-5c5ad13855df"],
Cell[40092, 1251, 241, 4, 14, "Caption",ExpressionUUID->"08255995-be34-4e4f-8ee8-1af7068b3142"],
Cell[40336, 1257, 304, 9, 30, "MathCaption",ExpressionUUID->"f6c32459-7b07-4617-91d4-bdfcf14bc3e6"],
Cell[40643, 1268, 479, 8, 20, "Input",ExpressionUUID->"e72e0a99-ea3d-4857-b272-4525bd61f854"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41171, 1282, 288, 9, 28, "Subsection",ExpressionUUID->"01ddf1c2-28cf-46b7-bd6d-edc4ff65142f"],
Cell[41462, 1293, 464, 12, 26, "Text",ExpressionUUID->"b1857f3a-913b-4f6d-bb08-7fb9d603bd7d"],
Cell[41929, 1307, 338, 9, 30, "MathCaption",ExpressionUUID->"79a23464-296d-4bdf-afe7-e726d40e6d05"],
Cell[42270, 1318, 288, 6, 20, "Input",ExpressionUUID->"5a23c898-1729-434e-a493-5692d9965b03"],
Cell[42561, 1326, 295, 8, 30, "MathCaption",ExpressionUUID->"afbcac6d-6863-4c22-a69a-4190a214baaa"],
Cell[42859, 1336, 389, 9, 32, "Input",ExpressionUUID->"1807918f-3099-43d9-a7ea-e04037852b23"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[43297, 1351, 95, 0, 28, "Section",ExpressionUUID->"37901c4a-f542-458c-9b49-ab99b0df3256"],
Cell[43395, 1353, 702, 22, 26, "Text",ExpressionUUID->"a3b6a9dd-ced9-4361-878b-f7ca4877e30f"],
Cell[44100, 1377, 6309, 193, 96, "DefinitionBox",ExpressionUUID->"497a17c9-8728-4b6a-88c5-475f0f93c78a"],
Cell[50412, 1572, 279, 11, 14, "Caption",ExpressionUUID->"a1f68a79-e7a9-4bdf-bcbb-baa9ccd30033"],
Cell[50694, 1585, 890, 29, 38, "Text",ExpressionUUID->"58238769-50e4-46a5-8f0b-c61de766d2f6"],
Cell[CellGroupData[{
Cell[51609, 1618, 265, 8, 18, "Text",ExpressionUUID->"d84eeda7-a2a4-47be-a633-e3192565f3d0"],
Cell[51877, 1628, 1087, 37, 40, "Text",ExpressionUUID->"ec25fda8-5909-4550-ab18-db7397f66fc5"],
Cell[52967, 1667, 304, 8, 45, "Program",ExpressionUUID->"a2470739-2e22-4647-bc7a-beebe6b013df"]
}, Closed]],
Cell[53286, 1678, 1155, 34, 67, "Text",ExpressionUUID->"3b7ce41c-b1cd-4592-ae50-afb22704ccdb"],
Cell[CellGroupData[{
Cell[54466, 1716, 157, 5, 28, "Subsection",ExpressionUUID->"32044154-00c7-4ed6-a4c1-37a07ee04f1b"],
Cell[54626, 1723, 347, 14, 30, "MathCaption",ExpressionUUID->"dbd419f5-185e-4372-980f-dba595de0105"],
Cell[54976, 1739, 777, 12, 32, "Input",ExpressionUUID->"d05be3b3-8478-4bbd-bf73-d0c745ef7c19"],
Cell[55756, 1753, 573, 20, 28, "Text",ExpressionUUID->"09f4fc14-9fc0-4a85-8db6-099c4c49e4eb"],
Cell[56332, 1775, 139, 1, 30, "MathCaption",ExpressionUUID->"8a768287-1934-4d04-9e2b-6135630cee9b"],
Cell[CellGroupData[{
Cell[56496, 1780, 261, 4, 20, "Input",ExpressionUUID->"7e5ecf2d-8178-429d-be3e-9b9b5b575341"],
Cell[56760, 1786, 4906, 85, 277, "Output",ExpressionUUID->"1ede1d1b-4eb9-4997-b093-7320ec16acff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61703, 1876, 220, 5, 20, "Input",ExpressionUUID->"1f2f5fee-f7d3-4a6b-8e8f-d22e673f1477"],
Cell[61926, 1883, 365, 8, 19, "Output",ExpressionUUID->"ae329b75-dd1d-4423-8b2d-47da189ef79e"]
}, Open  ]],
Cell[62306, 1894, 243, 5, 30, "MathCaption",ExpressionUUID->"2e894d3e-4eb0-4d20-aceb-1146feaeacc2"],
Cell[62552, 1901, 182, 3, 20, "Input",ExpressionUUID->"9f2b6ef4-be6f-4441-be75-af81e68a827d"],
Cell[62737, 1906, 4543, 79, 277, "Output",ExpressionUUID->"53e798df-1f73-49a7-8b13-3f342ff9caf6"]
}, Closed]],
Cell[CellGroupData[{
Cell[67317, 1990, 123, 0, 28, "Subsection",ExpressionUUID->"e54f7f68-9c57-41f0-9bb3-1f46dc4a4e5e"],
Cell[67443, 1992, 759, 20, 37, "Text",ExpressionUUID->"497d6bb3-4e50-4d83-b7fa-4d17ec6fe315"],
Cell[68205, 2014, 207, 5, 18, "Text",ExpressionUUID->"82bf27b9-d3ae-4882-93fa-8a4700b1cd7a"],
Cell[68415, 2021, 127, 0, 30, "MathCaption",ExpressionUUID->"f7b3a87a-2257-40a8-a9ae-e7ae45c2355f"],
Cell[CellGroupData[{
Cell[68567, 2025, 685, 18, 20, "Input",ExpressionUUID->"cd403c96-3fe8-4d00-9d5c-8e5d52a4a95c"],
Cell[69255, 2045, 36358, 633, 183, "Output",ExpressionUUID->"66d78989-7727-4211-a02c-51d751ad105b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105650, 2683, 183, 3, 20, "Input",ExpressionUUID->"1c823a29-4ea0-4474-9784-581a74ae20fd"],
Cell[105836, 2688, 363, 8, 19, "Output",ExpressionUUID->"6237a0b9-5cc0-48ee-94ed-78807b37fa0c"]
}, Open  ]],
Cell[106214, 2699, 171, 3, 30, "MathCaption",ExpressionUUID->"b1aef2ed-b23e-4749-8cb2-6babfde6d253"],
Cell[CellGroupData[{
Cell[106410, 2706, 1190, 32, 46, "Input",ExpressionUUID->"dbb3b284-e343-45c7-a13f-e92d96c19a70"],
Cell[107603, 2740, 413, 7, 300, "Output",ExpressionUUID->"8c47ea2e-ad82-4061-ba46-79d8e1c7e6d0"]
}, Open  ]],
Cell[108031, 2750, 160, 3, 20, "Input",ExpressionUUID->"afe6bf18-4163-428d-8576-73f79dbe712c"],
Cell[108194, 2755, 131, 0, 30, "MathCaption",ExpressionUUID->"88f2627a-99bb-426e-bd03-316cceef8106"],
Cell[CellGroupData[{
Cell[108350, 2759, 757, 21, 46, "Input",ExpressionUUID->"8f73c87f-5038-46c7-a944-a28c4a294b92"],
Cell[109110, 2782, 339, 8, 17, "Message",ExpressionUUID->"903f85aa-ff27-44c9-8637-3ee47db69751"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109486, 2795, 142, 2, 20, "Input",ExpressionUUID->"ec2d5b28-05d5-4a74-81b2-8b55c5a1d557"],
Cell[109631, 2799, 1072, 19, 146, "Message",ExpressionUUID->"bb7b6747-3520-4ffa-b78b-ef54f6790942"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110752, 2824, 137, 1, 28, "Subsection",ExpressionUUID->"914f1760-cdaf-4e56-a905-fa95b2b86782"],
Cell[110892, 2827, 365, 10, 18, "Text",ExpressionUUID->"8fa98783-cfec-4b8a-872d-4586c622578a"],
Cell[CellGroupData[{
Cell[111282, 2841, 131, 0, 30, "MathCaption",ExpressionUUID->"ed7b391d-8e39-4c29-94ee-3a398fb9a501"],
Cell[111416, 2843, 796, 22, 46, "Input",ExpressionUUID->"ba4db28d-1fd6-451c-89ac-ad0dab49d888"]
}, Closed]],
Cell[CellGroupData[{
Cell[112249, 2870, 124, 0, 19, "MathCaption",ExpressionUUID->"5d67e2b9-4443-4dd9-962e-2c71134f41da"],
Cell[112376, 2872, 1763, 41, 85, "Input",ExpressionUUID->"151975d0-f01d-4e06-b752-9aa6c2e6d52a"]
}, Closed]],
Cell[CellGroupData[{
Cell[114176, 2918, 282, 7, 19, "MathCaption",ExpressionUUID->"43d720ab-2e1b-4d0f-b3ee-a54c55a93be6"],
Cell[114461, 2927, 861, 21, 46, "Input",ExpressionUUID->"f22a14bb-d176-4568-bb26-2e92cd1858d1"],
Cell[115325, 2950, 141, 2, 20, "Input",ExpressionUUID->"9cdaa875-2468-4da6-9078-0da3f3c9ceaa"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[115515, 2958, 118, 0, 28, "Subsection",ExpressionUUID->"5a4e698f-d462-4c01-8d98-158e826aaf4b"],
Cell[115636, 2960, 253, 5, 18, "Text",ExpressionUUID->"93841ec5-b6fb-4cd2-977a-c05f4d9924b6"],
Cell[115892, 2967, 106, 0, 30, "MathCaption",ExpressionUUID->"b103fe8d-5dff-4641-a03a-8e5f94917076"],
Cell[116001, 2969, 419, 10, 32, "Input",ExpressionUUID->"fa91d625-7232-4f07-a530-81b698ee49c6"],
Cell[CellGroupData[{
Cell[116445, 2983, 270, 7, 20, "Input",ExpressionUUID->"a132be71-a91b-41a7-ae2b-83a210ee5a87"],
Cell[116718, 2992, 607, 13, 31, "Message",ExpressionUUID->"80788bc9-fffc-4dbf-84c6-a8b490eff69f"],
Cell[117328, 3007, 424, 12, 19, "Output",ExpressionUUID->"e8e2bc71-8331-430f-bbe0-3f117a449c48"]
}, Open  ]],
Cell[117767, 3022, 116, 0, 30, "MathCaption",ExpressionUUID->"ac243a41-ca5e-4324-86d6-c351b5d8e023"],
Cell[117886, 3024, 412, 9, 32, "Input",ExpressionUUID->"2ee19db2-37c9-4498-90c2-e61c42d5e95d"],
Cell[CellGroupData[{
Cell[118323, 3037, 411, 10, 32, "Input",ExpressionUUID->"dc789550-15ee-44c9-a1fe-8e1a5fc69ebf"],
Cell[118737, 3049, 391, 8, 19, "Output",ExpressionUUID->"495c9fef-7893-4437-ab0d-3a4f5f1ee239"],
Cell[119131, 3059, 393, 8, 19, "Output",ExpressionUUID->"f54d2af8-6774-466e-81a8-a1eb054187b2"]
}, Open  ]],
Cell[119539, 3070, 639, 13, 37, "Text",ExpressionUUID->"2c92e65e-2d05-4bbd-bd08-9376cdf15ed0"],
Cell[120181, 3085, 175, 3, 30, "MathCaption",ExpressionUUID->"484b0811-204f-4fab-8cb3-79f72c03f0b6"],
Cell[CellGroupData[{
Cell[120381, 3092, 222, 4, 20, "Input",ExpressionUUID->"c94c47ca-049f-483f-aa5b-af8820af95b6"],
Cell[120606, 3098, 389, 8, 19, "Output",ExpressionUUID->"9c58d1d3-6f24-42d7-8fa3-9827fd99f09a"]
}, Open  ]],
Cell[121010, 3109, 204, 3, 30, "MathCaption",ExpressionUUID->"d46617c8-0149-409b-bff8-63240646dde8"],
Cell[CellGroupData[{
Cell[121239, 3116, 494, 12, 46, "Input",ExpressionUUID->"3fcb5e65-b763-4633-b43d-701207f994c3"],
Cell[121736, 3130, 178, 2, 19, "Output",ExpressionUUID->"18983696-a1c1-49d8-8c10-09cb463563c9"]
}, Open  ]],
Cell[121929, 3135, 784, 11, 67, "Text",ExpressionUUID->"ddf471ff-d209-430c-abc0-95b07c059c59"],
Cell[122716, 3148, 127, 0, 30, "MathCaption",ExpressionUUID->"3b8f1367-78a9-42cb-9b8d-aeb3af82bcf1"],
Cell[122846, 3150, 451, 13, 32, "Input",ExpressionUUID->"43c5f705-9502-4050-a1bc-d41a9d2dcdb2"],
Cell[CellGroupData[{
Cell[123322, 3167, 290, 7, 32, "Input",ExpressionUUID->"5a0cd49c-5ee1-4543-b13a-fcfba97f3ab7"],
Cell[123615, 3176, 152, 2, 19, "Output",ExpressionUUID->"f2c5731d-ad62-46a8-b3c5-b4e90afe032a"]
}, Open  ]],
Cell[123782, 3181, 379, 7, 26, "Text",ExpressionUUID->"468efe83-2d09-4719-9c43-bae7949acefd"],
Cell[124164, 3190, 111, 0, 30, "MathCaption",ExpressionUUID->"71d1beb4-f0a7-4ec6-b04f-e311642ae462"],
Cell[CellGroupData[{
Cell[124300, 3194, 196, 4, 20, "Input",ExpressionUUID->"f7de1634-a62d-498f-b89a-a1a8c94cedb2"],
Cell[124499, 3200, 652, 16, 19, "Output",ExpressionUUID->"73e00a57-adb4-461c-8e42-961aa0ff5b65"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125188, 3221, 344, 8, 32, "Input",ExpressionUUID->"22e173ad-c94b-458e-834b-1f87a0414127"],
Cell[125535, 3231, 154, 2, 19, "Output",ExpressionUUID->"268abea9-981c-4ea4-8614-0fa458adc179"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125738, 3239, 180, 4, 28, "Subsection",ExpressionUUID->"204de47e-43df-4322-92ec-1df8b3e88448"],
Cell[125921, 3245, 1198, 34, 60, "Text",ExpressionUUID->"bac02213-ef1b-476a-bd78-0ca5bdfe4fce"],
Cell[127122, 3281, 225, 3, 18, "Text",ExpressionUUID->"7af0a03d-0604-4b70-89ac-822d333c8b1e"],
Cell[127350, 3286, 296, 8, 30, "MathCaption",ExpressionUUID->"b9a8e560-95fb-49c6-89fe-6599b37722ab"],
Cell[CellGroupData[{
Cell[127671, 3298, 312, 8, 20, "Input",ExpressionUUID->"e510a41e-f53a-4327-807f-a34d5dce344d"],
Cell[127986, 3308, 364, 8, 19, "Output",ExpressionUUID->"29202233-625a-4da3-b9e7-3e6cabdeb9b6"]
}, Open  ]],
Cell[128365, 3319, 233, 5, 30, "MathCaption",ExpressionUUID->"d75fa71a-90a9-4d03-adb5-d4b11ef720d1"],
Cell[CellGroupData[{
Cell[128623, 3328, 409, 11, 46, "Input",ExpressionUUID->"15cd7cc6-73bb-471d-b59c-a30845a955ff"],
Cell[129035, 3341, 154, 2, 19, "Output",ExpressionUUID->"ebffbd8a-56ac-4687-8fcf-3fd04886fcb5"]
}, Open  ]],
Cell[129204, 3346, 336, 6, 39, "MathCaption",ExpressionUUID->"7f4ee918-1ba0-47f7-8502-d6081aaf26d9"],
Cell[CellGroupData[{
Cell[129565, 3356, 167, 3, 20, "Input",ExpressionUUID->"b70b4ed6-cb67-4363-a716-28d88ff9767f"],
Cell[129735, 3361, 150, 2, 19, "Output",ExpressionUUID->"fea94d9d-16b7-4543-b549-76cd8e0ee40c"]
}, Open  ]],
Cell[129900, 3366, 178, 3, 30, "MathCaption",ExpressionUUID->"e9d61fdf-a80c-479b-aad9-31b85f8c5bb7"],
Cell[CellGroupData[{
Cell[130103, 3373, 162, 3, 20, "Input",ExpressionUUID->"9dccd731-2ee1-4fc4-a9c7-efb99aec7ccd"],
Cell[130268, 3378, 166, 2, 19, "Output",ExpressionUUID->"39bcd529-1c8f-403b-b69b-7383cb131ce5"]
}, Open  ]],
Cell[130449, 3383, 497, 13, 39, "MathCaption",ExpressionUUID->"a1743c8e-b756-4dbf-a7d7-28fb7a30eee9"],
Cell[CellGroupData[{
Cell[130971, 3400, 287, 7, 32, "Input",ExpressionUUID->"4dd0b151-251e-4813-8a78-6b64f8e758c4"],
Cell[131261, 3409, 154, 2, 19, "Output",ExpressionUUID->"0f905350-f858-4309-971b-b1893bcbeffe"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[131476, 3418, 226, 4, 28, "Section",ExpressionUUID->"82745ee5-cb81-475d-86d5-d6d8290ebb56"],
Cell[131705, 3424, 602, 14, 26, "Text",ExpressionUUID->"d09d9001-0ea2-40cb-9478-13ad3e01c745"],
Cell[132310, 3440, 4989, 160, 142, "DefinitionBox",ExpressionUUID->"490e5793-49a7-433f-9cdb-f5b043fdf8bb"],
Cell[137302, 3602, 107, 0, 14, "Caption",ExpressionUUID->"72217adf-7a7f-4e70-a0dc-a50a40f2516c"],
Cell[137412, 3604, 683, 15, 56, "Text",ExpressionUUID->"e7b30895-c450-44e2-be62-bd471a707f76"],
Cell[CellGroupData[{
Cell[138120, 3623, 117, 0, 30, "MathCaption",ExpressionUUID->"81912f59-8f26-4626-b791-279ca96b9d05"],
Cell[138240, 3625, 142, 2, 20, "Input",ExpressionUUID->"79950c7f-b90b-481a-a43e-5bb0a9570b45"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138419, 3632, 120, 0, 30, "MathCaption",ExpressionUUID->"b5394d2b-abf7-4912-bc65-7bf8c3416da2"],
Cell[138542, 3634, 539, 14, 32, "Input",ExpressionUUID->"f7fe1f92-c823-4534-a397-bf000248d899"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139118, 3653, 92, 0, 30, "MathCaption",ExpressionUUID->"274620f5-b7d6-4eb3-95d9-c630efccb383"],
Cell[139213, 3655, 149, 2, 20, "Input",ExpressionUUID->"a308ed8f-7e2a-4810-b288-7d2cef346371"]
}, Open  ]],
Cell[139377, 3660, 283, 6, 18, "Text",ExpressionUUID->"efc582c9-e7de-4c25-a1c5-9816bdc1c1b4"],
Cell[CellGroupData[{
Cell[139685, 3670, 280, 8, 30, "MathCaption",ExpressionUUID->"33128e93-ebef-48be-9b8c-6f145f780166"],
Cell[139968, 3680, 687, 19, 46, "Input",ExpressionUUID->"3419b558-c870-413e-b07e-6a16db21ad2f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140692, 3704, 152, 2, 30, "MathCaption",ExpressionUUID->"0e73cfa5-fbe6-44f7-ae20-055094a33fc9"],
Cell[140847, 3708, 237, 5, 20, "Input",ExpressionUUID->"18d3617e-43c0-4f5b-a90a-9f6cd6ab5abc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141121, 3718, 155, 2, 30, "MathCaption",ExpressionUUID->"b0c6c97f-06fe-4638-a91e-32214e9b11c4"],
Cell[141279, 3722, 2582, 70, 98, "Input",ExpressionUUID->"b0b19e32-351d-4550-a660-b8fbc09314aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143898, 3797, 122, 0, 30, "MathCaption",ExpressionUUID->"bcee3ebf-c34a-4b8d-a07c-eb92f08005e3"],
Cell[144023, 3799, 216, 4, 20, "Input",ExpressionUUID->"06eb79cf-1371-46b4-9c62-673369fe4d87"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144276, 3808, 99, 0, 28, "Subsection",ExpressionUUID->"cbb50cc8-f62e-4c9c-a410-7a27f526d0b5"],
Cell[144378, 3810, 822, 25, 56, "Text",ExpressionUUID->"2ca20555-5e3b-4bc6-9238-6db025827b05"],
Cell[145203, 3837, 249, 8, 30, "MathCaption",ExpressionUUID->"b51e6a6f-be81-40bc-b6e6-8a687b4d79ae"],
Cell[145455, 3847, 512, 13, 20, "Input",ExpressionUUID->"61abbcac-1b85-419e-bffc-2b62a09df428"],
Cell[145970, 3862, 212, 3, 20, "Input",ExpressionUUID->"a40b0ff8-79a7-4389-a497-0b4d73bb5d48"],
Cell[146185, 3867, 982, 31, 39, "Text",ExpressionUUID->"2a474672-0b04-406b-a4ef-4cb126d4261e"],
Cell[147170, 3900, 430, 15, 30, "MathCaption",ExpressionUUID->"0c3c5887-219f-46ac-97f3-098d69324ffc"],
Cell[147603, 3917, 145, 2, 20, "Input",ExpressionUUID->"b584e55d-7360-4696-951f-c18cbc1b3d27"],
Cell[147751, 3921, 183, 5, 25, "Subsubsection",ExpressionUUID->"2aa7f167-dd38-40fe-a4dc-23a121d25d34"],
Cell[147937, 3928, 673, 17, 55, "Text",ExpressionUUID->"6c3a8339-24bf-40f3-bd1d-cfc0bd20859e"],
Cell[148613, 3947, 212, 4, 30, "MathCaption",ExpressionUUID->"846c07d1-b79e-4845-bfd2-2bb0f0276515"],
Cell[148828, 3953, 142, 2, 20, "Input",ExpressionUUID->"2fa07060-c833-4d68-a5f5-aa0367143a59"],
Cell[148973, 3957, 175, 4, 30, "MathCaption",ExpressionUUID->"1118be96-720a-42aa-9c73-b42327615c71"],
Cell[149151, 3963, 388, 9, 20, "Input",ExpressionUUID->"b70ac8ef-c29c-4c3a-877c-d41cce17e6fe"],
Cell[149542, 3974, 323, 8, 30, "MathCaption",ExpressionUUID->"d85afe20-146c-4035-bcf9-5e7835680220"],
Cell[149868, 3984, 442, 7, 20, "Input",ExpressionUUID->"52f18a07-5090-485d-89bf-fe2e2f9957fd"],
Cell[150313, 3993, 187, 4, 30, "MathCaption",ExpressionUUID->"a1a7d80b-1afa-44f3-9d9d-a61d12f5c2e7"],
Cell[150503, 3999, 346, 7, 20, "Input",ExpressionUUID->"3de6032e-aab1-4228-af9f-f01bdd225c52"],
Cell[150852, 4008, 273, 8, 30, "MathCaption",ExpressionUUID->"5fe1b508-83ad-450a-aa5d-0c5b6f516275"],
Cell[151128, 4018, 766, 13, 20, "Input",ExpressionUUID->"44c1df54-c090-4207-aaa4-e5845c4124b2"],
Cell[151897, 4033, 262, 5, 30, "MathCaption",ExpressionUUID->"f032115f-ebbc-430f-b25b-9caaeec03244"],
Cell[152162, 4040, 398, 7, 20, "Input",ExpressionUUID->"687e793f-7f77-4846-bd2a-d83f8c7fc138"],
Cell[CellGroupData[{
Cell[152585, 4051, 359, 7, 30, "MathCaption",ExpressionUUID->"f8c53688-32f1-44f6-a655-67bc555f32a3"],
Cell[152947, 4060, 300, 5, 20, "Input",ExpressionUUID->"cc9358ee-7657-4d4b-9aa6-c30b7fc3660e"]
}, Open  ]],
Cell[153262, 4068, 525, 16, 30, "MathCaption",ExpressionUUID->"98e4b250-e97b-4c9b-a69b-68d8f82c4a60"],
Cell[153790, 4086, 564, 10, 32, "Input",ExpressionUUID->"1091a0b9-9dc3-41ca-b565-40933d0a8faa"],
Cell[154357, 4098, 227, 8, 30, "MathCaption",ExpressionUUID->"3f5737c7-7b0c-430a-94e3-636d01c919c0"],
Cell[154587, 4108, 431, 10, 20, "Input",ExpressionUUID->"a77035d5-4cb0-4816-aac5-49d2ec29c2b4"],
Cell[155021, 4120, 320, 12, 30, "MathCaption",ExpressionUUID->"4fdc65e9-7ffd-478b-aed8-1e9eed319dab"],
Cell[155344, 4134, 388, 6, 20, "Input",ExpressionUUID->"d5937167-44a3-45f4-93d7-a59b66b9716a"],
Cell[155735, 4142, 525, 14, 39, "MathCaption",ExpressionUUID->"f7f05d30-2c20-4f74-9ce3-137be4a42aa2"],
Cell[156263, 4158, 441, 7, 20, "Input",ExpressionUUID->"16527eb6-34ba-4288-a050-1b1895c7e188"],
Cell[156707, 4167, 268, 8, 18, "Text",ExpressionUUID->"54147dbf-2d46-4fa9-b4bd-52d6319b7192"]
}, Closed]],
Cell[CellGroupData[{
Cell[157012, 4180, 102, 0, 28, "Subsection",ExpressionUUID->"9bc48fb5-829b-46b9-8e14-e6a1896abacc"],
Cell[157117, 4182, 727, 18, 45, "Text",ExpressionUUID->"a4442e47-32c0-4b47-9de0-c08b16b6a1f5"],
Cell[CellGroupData[{
Cell[157869, 4204, 291, 5, 20, "Input",ExpressionUUID->"3821cae3-7318-448d-ba42-7c0a6ca5fafd"],
Cell[158163, 4211, 4566, 79, 277, "Output",ExpressionUUID->"83909e0d-fb6f-4c36-8ca3-799b1ca1a200"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162766, 4295, 211, 3, 20, "Input",ExpressionUUID->"1542b8d9-84be-4408-956e-2dea7e73e6ac"],
Cell[162980, 4300, 218, 2, 19, "Output",ExpressionUUID->"dc917855-3382-473f-b254-b228b100ef48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163235, 4307, 154, 2, 30, "MathCaption",ExpressionUUID->"2ca0bfae-a709-45d2-a45e-098790754f8e"],
Cell[CellGroupData[{
Cell[163414, 4313, 364, 7, 20, "Input",ExpressionUUID->"204b626a-6b5d-4991-befb-f8901707e0e0"],
Cell[163781, 4322, 324, 6, 19, "Output",ExpressionUUID->"f0a1d706-1ba0-4d05-9e39-a4f8db7c6c02"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164154, 4334, 290, 6, 30, "MathCaption",ExpressionUUID->"ff043dd0-7830-4ef4-abc6-ef5ed8367ffb"],
Cell[CellGroupData[{
Cell[164469, 4344, 395, 8, 20, "Input",ExpressionUUID->"0ddab3cb-bf87-44cb-af1b-c93d19586ef3"],
Cell[164867, 4354, 1762, 28, 277, "Output",ExpressionUUID->"f7f6fde7-8f66-4066-939f-dcaf37f18c51"]
}, Open  ]],
Cell[166644, 4385, 152, 2, 20, "Input",ExpressionUUID->"4912eb89-fec5-42af-8ffc-0db4972a65db"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166845, 4393, 115, 0, 28, "Subsection",ExpressionUUID->"2fa795cb-95b9-47c2-ab58-2b0b86f0110e"],
Cell[166963, 4395, 534, 11, 37, "Text",ExpressionUUID->"9b1f6b83-cdd6-4a43-9fa4-7915d4ff17b7"],
Cell[167500, 4408, 282, 6, 18, "Text",ExpressionUUID->"c65125bb-1128-428d-b7bf-795132fa619a"],
Cell[167785, 4416, 279, 8, 30, "MathCaption",ExpressionUUID->"d88a43b1-4578-46f3-9f4a-74c9d696bd2c"],
Cell[CellGroupData[{
Cell[168089, 4428, 612, 16, 32, "Input",ExpressionUUID->"278daa1a-2b1e-478a-9d71-806728c3cc1a"],
Cell[168704, 4446, 486, 13, 144, "Output",ExpressionUUID->"dbfcc026-2514-48af-86b3-46f2bdac850c"]
}, Open  ]],
Cell[169205, 4462, 181, 3, 30, "MathCaption",ExpressionUUID->"9e6ed21c-9236-45f2-8c03-dbd99ba0002a"],
Cell[CellGroupData[{
Cell[169411, 4469, 331, 7, 32, "Input",ExpressionUUID->"89cb42fe-ef06-49e0-a4f8-591a62ee2b45"],
Cell[169745, 4478, 234, 3, 19, "Output",ExpressionUUID->"185c9acb-ee4b-4db5-9ea0-47fa32de9b89"]
}, Open  ]],
Cell[169994, 4484, 214, 5, 30, "MathCaption",ExpressionUUID->"9777c3a5-494f-47ad-a7cb-780e68959f84"],
Cell[CellGroupData[{
Cell[170233, 4493, 309, 7, 20, "Input",ExpressionUUID->"c99c79af-c034-415d-b0b3-1d89dc535b8d"],
Cell[170545, 4502, 537, 14, 77, "Output",ExpressionUUID->"af874b27-ecf2-497c-958e-e64c8e705d80"]
}, Open  ]],
Cell[171097, 4519, 257, 8, 18, "Text",ExpressionUUID->"2b9d9772-fb96-4e0a-beb5-ff066e358cdc"]
}, Closed]],
Cell[CellGroupData[{
Cell[171391, 4532, 102, 0, 28, "Subsection",ExpressionUUID->"992901ee-e27c-4866-9e2b-3add2b2e3fc9"],
Cell[171496, 4534, 336, 9, 26, "Text",ExpressionUUID->"79d7b0f9-6d8e-467b-ae0b-782d680fca9b"],
Cell[171835, 4545, 820, 21, 45, "Text",ExpressionUUID->"84581a26-d8d7-4977-94a9-cbe1046f5c7a"],
Cell[172658, 4568, 115, 0, 30, "MathCaption",ExpressionUUID->"b9b91355-3e98-4dc4-a647-bd3f1df7832f"],
Cell[CellGroupData[{
Cell[172798, 4572, 394, 9, 20, "Input",ExpressionUUID->"bbb68e95-0c75-4ea2-8e4d-fc15cdf45b62"],
Cell[173195, 4583, 238, 4, 311, "Output",ExpressionUUID->"7d018ed6-e934-41dc-8b6a-d3ac74046bd4"]
}, Open  ]],
Cell[173448, 4590, 281, 6, 30, "MathCaption",ExpressionUUID->"3fc1e321-f9a4-4156-aa6e-8980e750dbc5"],
Cell[CellGroupData[{
Cell[173754, 4600, 193, 3, 20, "Input",ExpressionUUID->"b8041206-0ea7-43d9-b82e-1e9ef4d00915"],
Cell[173950, 4605, 217, 3, 19, "Output",ExpressionUUID->"591f49b3-92e2-4569-bc20-f9f89f471261"]
}, Open  ]],
Cell[174182, 4611, 280, 6, 18, "Text",ExpressionUUID->"aa683f4c-0302-45f8-bfb5-866354ee43ac"],
Cell[174465, 4619, 597, 19, 26, "Text",ExpressionUUID->"53fa16f8-77e1-45b5-b368-66c19326f06c"],
Cell[CellGroupData[{
Cell[175087, 4642, 112, 0, 25, "Subsubsection",ExpressionUUID->"5b40455d-196e-47a7-b0fd-c8560325d022"],
Cell[175202, 4644, 844, 18, 67, "Text",ExpressionUUID->"b807cf8b-3ced-404b-b2f8-d46ac227517b"],
Cell[176049, 4664, 591, 12, 45, "Text",ExpressionUUID->"010eaa4a-15d7-4afe-9c8f-2d7ba81805a1"],
Cell[176643, 4678, 195, 3, 30, "MathCaption",ExpressionUUID->"68ce4e48-dd49-469c-bf84-cafcb9ad67bb"],
Cell[176841, 4683, 594, 14, 59, "Input",ExpressionUUID->"e8cc4403-6d1b-4bee-8fce-33cc5638e1cf"],
Cell[177438, 4699, 243, 5, 18, "Text",ExpressionUUID->"14e6fb3f-f1a0-43d9-8373-a7dca65dd4f1"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[177742, 4711, 282, 9, 28, "Section",ExpressionUUID->"05e6a4ff-b3dc-4106-8bd6-ef43b9fc893e"],
Cell[178027, 4722, 501, 14, 26, "Text",ExpressionUUID->"7bbb1f8a-9461-4689-8b2a-90983b1a291e"],
Cell[178531, 4738, 488, 10, 45, "Text",ExpressionUUID->"c5b31166-d574-4633-adef-853889e621dc"],
Cell[179022, 4750, 488, 7, 37, "Text",ExpressionUUID->"a76a92f5-ef27-4602-b608-cc41ab39952a"],
Cell[CellGroupData[{
Cell[179535, 4761, 195, 5, 30, "MathCaption",ExpressionUUID->"10005c73-986a-4556-b0a5-ea68e2333099"],
Cell[179733, 4768, 431, 9, 26, "Text",ExpressionUUID->"0984e649-3612-41dd-8322-39ceb79a379b"],
Cell[180167, 4779, 15595, 512, 1150, "DefinitionBox",ExpressionUUID->"781b457b-2830-4cf2-9fbb-debc81470d95"],
Cell[195765, 5293, 185, 5, 14, "Caption",ExpressionUUID->"5cc17618-8beb-47a5-88d6-933ecd2f03eb"]
}, Closed]],
Cell[CellGroupData[{
Cell[195987, 5303, 129, 0, 19, "MathCaption",ExpressionUUID->"516899b2-3f2a-4242-905c-20e2ec939152"],
Cell[196119, 5305, 443, 8, 26, "Text",ExpressionUUID->"560a8635-9503-4160-b3e4-922ac5a9f135"],
Cell[196565, 5315, 425, 6, 37, "Text",ExpressionUUID->"d5668904-5860-4096-ac74-5ed512f74a17"],
Cell[196993, 5323, 441, 6, 37, "Text",ExpressionUUID->"bda91091-517d-4acc-a2ac-7da0cfec479e"]
}, Closed]],
Cell[CellGroupData[{
Cell[197471, 5334, 108, 0, 19, "MathCaption",ExpressionUUID->"e141dc94-9a02-4f71-a8b3-049c63ed3c6c"],
Cell[197582, 5336, 335, 8, 26, "Text",ExpressionUUID->"1c72d3c4-353e-493e-9073-5633e0244342"],
Cell[197920, 5346, 183, 4, 18, "Text",ExpressionUUID->"489d5880-2da2-4415-a290-3fe056ae8efd"],
Cell[198106, 5352, 619, 11, 83, "Text",ExpressionUUID->"794e9022-a16e-48d1-9359-c325226f948e"]
}, Closed]],
Cell[CellGroupData[{
Cell[198762, 5368, 90, 0, 28, "Subsection",ExpressionUUID->"92fff840-81ae-4748-895c-1c565b695843"],
Cell[198855, 5370, 1005, 18, 132, "Text",ExpressionUUID->"51251304-3cc1-4599-88fc-96f08bef7f5c"],
Cell[199863, 5390, 172, 3, 30, "MathCaption",ExpressionUUID->"1e6d25fb-77ea-460e-830b-76a657ef6334"],
Cell[200038, 5395, 241, 4, 32, "Input",ExpressionUUID->"b2a51fd0-1c26-44c5-a597-5682ead9dc65"],
Cell[200282, 5401, 430, 10, 40, "MathCaption",ExpressionUUID->"125cef04-c542-47c5-8539-705e1f114340"],
Cell[200715, 5413, 388, 8, 32, "Input",ExpressionUUID->"ba2e1a70-a6de-4f68-8c9c-081a5b282adb"],
Cell[201106, 5423, 412, 8, 26, "Text",ExpressionUUID->"03b467f9-2131-488f-8184-f0d1a4ec1115"]
}, Closed]],
Cell[CellGroupData[{
Cell[201555, 5436, 174, 5, 28, "Subsection",ExpressionUUID->"02cfee9a-f922-4747-b7c3-dfc7dc422b68"],
Cell[201732, 5443, 1966, 57, 126, "Text",ExpressionUUID->"20c6cee9-4b25-4038-893a-c2de0582da75"],
Cell[CellGroupData[{
Cell[203723, 5504, 327, 11, 30, "MathCaption",ExpressionUUID->"29fec58f-fae0-4a46-a7ec-55413918bccd"],
Cell[204053, 5517, 260, 5, 32, "Input",ExpressionUUID->"a42488c7-e9bd-47e6-8e7e-5dee8bcd378e"],
Cell[CellGroupData[{
Cell[204338, 5526, 122, 0, 30, "MathCaption",ExpressionUUID->"1d1357cf-9747-462e-b07f-918780dd8892"],
Cell[204463, 5528, 211, 5, 20, "Input",ExpressionUUID->"14a2d77d-9486-400f-b869-c0cb130d7de8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204711, 5538, 210, 5, 30, "MathCaption",ExpressionUUID->"6ef90668-a45f-4bbc-aec3-400d86a74c1a"],
Cell[204924, 5545, 619, 16, 72, "Input",ExpressionUUID->"e04416f6-d773-4dad-9208-4292850f8572"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205580, 5566, 206, 5, 30, "MathCaption",ExpressionUUID->"71644b6b-c20f-4d24-8fb9-d04c6c877154"],
Cell[205789, 5573, 436, 11, 32, "Input",ExpressionUUID->"5c86c2ff-46ee-4369-9480-0d3df31daacb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[206274, 5590, 1146, 30, 48, "Text",ExpressionUUID->"0fd760f7-753f-4412-81dd-6492aa432cf9"],
Cell[207423, 5622, 298, 8, 30, "MathCaption",ExpressionUUID->"24e52eb9-39a4-47e7-8802-b73986d9c02d"],
Cell[207724, 5632, 142, 2, 20, "Input",ExpressionUUID->"9d183979-eed0-44f3-b8c4-8e0aaffe33cf"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[207927, 5641, 354, 9, 28, "Section",ExpressionUUID->"d4f0968e-2384-4011-bef4-78d32202fcb9"],
Cell[CellGroupData[{
Cell[208306, 5654, 93, 0, 28, "Subsection",ExpressionUUID->"273068c7-c46f-494e-abf2-84fc7e9ba9ff"],
Cell[208402, 5656, 470, 14, 26, "Text",ExpressionUUID->"5da75c35-7757-4b9e-88c8-a5d8ddf5171b"],
Cell[208875, 5672, 1837, 57, 70, "DefinitionBox",ExpressionUUID->"98916880-383c-4991-9ad9-9bf2f5c6b7af"],
Cell[210715, 5731, 202, 7, 14, "Caption",ExpressionUUID->"3a1d1003-8889-48f8-b2f6-dd86cc7e72ef"],
Cell[210920, 5740, 161, 3, 30, "MathCaption",ExpressionUUID->"3022511b-0bef-417a-9b36-428a169f2742"],
Cell[211084, 5745, 128, 2, 20, "Input",ExpressionUUID->"0d5889f3-3c0c-4269-934c-d2a35b82f42d"],
Cell[211215, 5749, 314, 9, 18, "Text",ExpressionUUID->"75d91d0f-f7f1-4659-9abf-4136fbd7ec6c"],
Cell[211532, 5760, 196, 3, 30, "MathCaption",ExpressionUUID->"5f31eff6-22ec-4764-b6cd-ba7698ffde5e"],
Cell[211731, 5765, 137, 2, 20, "Input",ExpressionUUID->"d19798fa-4e41-48f2-a230-a6e0d8a73cfb"],
Cell[211871, 5769, 451, 8, 26, "Text",ExpressionUUID->"d201fddf-a637-482f-87ec-b90c9bd51b2a"],
Cell[212325, 5779, 338, 7, 18, "Text",ExpressionUUID->"8b9a246d-6a79-4cd9-b354-ef38ffcd0e58"],
Cell[212666, 5788, 234, 6, 30, "MathCaption",ExpressionUUID->"526f0fd6-1713-4e6b-b657-da34459d0ff2"],
Cell[212903, 5796, 440, 8, 32, "Input",ExpressionUUID->"2c2df6f1-01c5-4921-bc2b-4d907f9f8d11"]
}, Closed]],
Cell[CellGroupData[{
Cell[213380, 5809, 98, 0, 28, "Subsection",ExpressionUUID->"9c6b07da-23ee-44c6-9103-b0cd4709bdb9"],
Cell[213481, 5811, 523, 8, 37, "Text",ExpressionUUID->"651aee5a-8597-42ba-a1f3-7c9469fa5708"],
Cell[214007, 5821, 2375, 75, 70, "DefinitionBox",ExpressionUUID->"223a5340-2096-4cf1-9bbc-48a565e3036d"],
Cell[216385, 5898, 111, 0, 14, "Caption",ExpressionUUID->"a9a26172-f5f6-4681-8a49-66ddaab6bdf4"],
Cell[216499, 5900, 437, 10, 26, "Text",ExpressionUUID->"e77854a2-9e95-48af-9ad9-3e634c4f04f0"],
Cell[216939, 5912, 126, 0, 30, "MathCaption",ExpressionUUID->"031ed2ea-3f65-4485-8c9b-b6dee866f84b"],
Cell[217068, 5914, 336, 8, 32, "Input",ExpressionUUID->"1cfbedab-1a54-4ba6-803c-1fa698c4b806"],
Cell[217407, 5924, 120, 0, 30, "MathCaption",ExpressionUUID->"1f24b00a-33a7-4ede-ba9a-4d08660203e5"],
Cell[217530, 5926, 243, 5, 32, "Input",ExpressionUUID->"cdc7b9c3-53f4-4d69-b291-893192a66456"],
Cell[217776, 5933, 196, 4, 20, "Input",ExpressionUUID->"711666f3-daa4-4c2b-9780-e87d11cdfa96"],
Cell[217975, 5939, 162, 3, 20, "Input",ExpressionUUID->"f800f007-d0c4-415f-a2bf-c5f874b6bf96"],
Cell[218140, 5944, 558, 10, 37, "Text",ExpressionUUID->"f2cdcbfd-791b-48ef-b611-4ed671a19522"]
}, Closed]],
Cell[CellGroupData[{
Cell[218735, 5959, 95, 0, 28, "Subsection",ExpressionUUID->"0cff18d3-4b98-4a7f-acfe-4e88808175e4"],
Cell[218833, 5961, 340, 10, 18, "Text",ExpressionUUID->"1ecf5064-2429-41af-808a-d15c32b9d937"],
Cell[219176, 5973, 340, 5, 26, "Text",ExpressionUUID->"a22f4d5a-cf6e-490e-ab61-87ee90fc6b81"],
Cell[219519, 5980, 241, 4, 18, "Text",ExpressionUUID->"17abdf41-536b-4051-85aa-fb594ec817f3"],
Cell[219763, 5986, 2322, 78, 74, "DefinitionBox",ExpressionUUID->"531603d4-c585-4757-86c2-5679d6270ad9"],
Cell[222088, 6066, 108, 0, 14, "Caption",ExpressionUUID->"458712a8-ce82-40ab-8483-ed592e9ea715"],
Cell[222199, 6068, 420, 12, 27, "Text",ExpressionUUID->"0a56586a-de5f-474d-a6be-4b5013b34fba"],
Cell[222622, 6082, 158, 2, 30, "MathCaption",ExpressionUUID->"64cf0735-85ef-47da-a586-42d555822737"],
Cell[222783, 6086, 235, 4, 32, "Input",ExpressionUUID->"b9d95e41-398e-4470-8fe6-0f753a6c4dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[223055, 6095, 169, 4, 28, "Subsection",ExpressionUUID->"7a9ba4c3-09ed-417d-8ea7-d78208131dab"],
Cell[223227, 6101, 601, 13, 45, "Text",ExpressionUUID->"bc72e023-087c-4364-836a-c7375363d5cf"],
Cell[223831, 6116, 245, 5, 30, "MathCaption",ExpressionUUID->"336c51d5-be10-402d-a490-7d563f327733"],
Cell[224079, 6123, 697, 18, 59, "Input",ExpressionUUID->"472bad01-36c3-42f8-90e3-2b50a658d4d9"],
Cell[224779, 6143, 329, 9, 18, "Text",ExpressionUUID->"603a811a-dd6d-4083-8880-66bbc309841e"],
Cell[225111, 6154, 216, 5, 30, "MathCaption",ExpressionUUID->"55a4d1d9-bc92-4669-a193-e770dd8e99d0"],
Cell[225330, 6161, 197, 4, 20, "Input",ExpressionUUID->"751b0b6e-abaa-4530-b2ea-f550b0c00b2d"],
Cell[225530, 6167, 394, 11, 46, "Input",ExpressionUUID->"c8c8ce70-5e46-4ab6-bb05-01a3b3d4d920"],
Cell[225927, 6180, 168, 3, 30, "MathCaption",ExpressionUUID->"6183b543-3b09-4f39-b1d4-0d65788e6b1e"],
Cell[226098, 6185, 218, 4, 20, "Input",ExpressionUUID->"3ca55fa1-f544-461b-978c-3e1fb6adff23"],
Cell[226319, 6191, 161, 3, 20, "Input",ExpressionUUID->"58edd1ec-b75f-4c4d-bebc-54f5eaec2f1c"],
Cell[226483, 6196, 105, 0, 30, "MathCaption",ExpressionUUID->"bf24126f-e535-45f2-b0a3-141d477d3382"],
Cell[226591, 6198, 342, 7, 32, "Input",ExpressionUUID->"00ecc47e-7148-421a-9a6a-c2017a295b01"],
Cell[226936, 6207, 161, 2, 30, "MathCaption",ExpressionUUID->"8440f221-34af-48ae-b3ee-85f2d147e1ef"],
Cell[227100, 6211, 257, 6, 20, "Input",ExpressionUUID->"950442a2-6dbb-4c02-b609-0972c419382b"],
Cell[227360, 6219, 186, 3, 30, "MathCaption",ExpressionUUID->"74c2dfc5-2736-49b6-9ae4-80a56f2bebd5"],
Cell[227549, 6224, 226, 5, 20, "Input",ExpressionUUID->"4ad94461-60e4-4e24-892b-ff6207978c51"],
Cell[227778, 6231, 240, 5, 18, "Text",ExpressionUUID->"21c48a3f-325f-4490-92b0-12964635b62c"],
Cell[228021, 6238, 286, 8, 30, "MathCaption",ExpressionUUID->"6c949692-b286-41f6-bf3d-13bf333b36dc"],
Cell[228310, 6248, 532, 15, 32, "Input",ExpressionUUID->"4b67cea6-4a1c-456a-9adf-022eec30cf75"],
Cell[228845, 6265, 199, 4, 20, "Input",ExpressionUUID->"2710346a-7160-424d-bd3f-9d9b2c57f1b0"],
Cell[229047, 6271, 459, 14, 26, "Text",ExpressionUUID->"e6f9dc3e-ff03-4c46-9d22-134def51f6ba"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[229555, 6291, 90, 0, 28, "Section",ExpressionUUID->"ed12dff2-60b3-44a4-966c-8c2dcd421792"],
Cell[229648, 6293, 834, 20, 48, "Text",ExpressionUUID->"0cee0d06-defc-4cc0-9bbb-64717e682af4"],
Cell[230485, 6315, 831, 25, 26, "Text",ExpressionUUID->"5133ab52-505b-46dc-8912-19f501ec3748"]
}, Open  ]]
}, Open  ]]
}
]
*)

