(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     12353,        332]
NotebookOptionsPosition[      8315,        245]
NotebookOutlinePosition[      9746,        294]
CellTagsIndexPosition[      9703,        291]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Mouse Events from ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 " Display\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(v1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{3.793769927995916*^9},
 TextAlignment->Left,ExpressionUUID->"489d7f39-852e-47cb-a110-ee9ffc99cd0f"],

Cell["\<\
When the Java panel is opened, click and drag the mouse in the middle \
display. The 2d pixel coordinates of the mouse position are interpreted by \
the handling routine below to evaluate the expression given in the bottom \
window. This example is built after the real-time algebra example in the \
J/Link manual.\
\>", "Text",ExpressionUUID->"37b477af-ee34-4a66-be2d-850dae257dbb"],

Cell[TextData[{
 "This notebook experiments with the standard mouse listener class \
\"com.wolfram.jlink.MathMouseListener\" of J/Link. This listener operates \
synchronously and reports all mouse movements in the display to the handling \
routine in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"48e2c3b4-902d-447b-951b-4b319ae119c3"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and initialize JavaView."
}], "MathCaption",ExpressionUUID->"d0eb4de2-b008-4d3c-93c8-bb4d1bb90dc6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"d2168b7c-ed35-4470-af61-2f54db010cf5"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{{3.79377907490401*^9, 3.7937790865731697`*^9}, 
   3.793779276137726*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"464a6d6f-611d-4b6f-ad14-983b1946c69f"]
}, Open  ]],

Cell["\<\
Create a new display in pick mode. The display is later used as 2D input \
device issuing mouse pick events. The class jv.project.PvDisplayIf is already \
preloaded inside InstallJavaView[].\
\>", "MathCaption",ExpressionUUID->"ce9bcf9c-cf0e-418d-8399-9aadb0cbe043"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"newDisplay", "[", 
     RowBox[{"\"\<Pick and drag in this area\>\"", ",", " ", "False"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"setMajorMode", "[", "PvDisplayIf`MODEUINITIALUPICK", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"showTitle", "[", "True", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"e265c713-e1d1-406d-831b-6498738f3bf5"],

Cell["\<\
This function will be called upon mouse pick and drag events. Here we just \
interpret the 2d mouse position in pixel coordinates of the display.\
\>", "MathCaption",ExpressionUUID->"11c2ce11-f7f9-44a0-b7b7-0645be9d47b9"],

Cell["\<\
evalMousePosition[evt_,xa_Integer,ya_Integer,click_Integer] :=
\tJavaBlock[
\t\toutText@setText[
\t\t\tBlock[{x=N[evt@getX[]],y=N[evt@getY[]]},
\t\t\t\t\"x =\"<>ToString[x]<>\", y=\"<>ToString[y]<>\"\\n\"<>
\t\t\t\tinText@getText[]<>\"=\"<>
\t\t\t\tToString[ToExpression[inText@getText[]]]
\t\t\t]
\t\t];
\t\tReleaseObject[evt]
\t]\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[6]:=",ExpressionUUID->"bfa1693a-c046-45cb-bb8e-59d66d833d15"],

Cell["Register a mouse listener in the 2D-display.", "MathCaption",ExpressionUUID->"63b61d7d-24cb-4f6e-b9e5-a1f38e9a0cf5"],

Cell["\<\
listener = JavaNew[\"com.wolfram.jlink.MathMouseListener\"];
listener@setHandler[\"mousePressed\", \"evalMousePosition\"];
disp@addMouseListener[listener];
listener = JavaNew[\"com.wolfram.jlink.MathMouseMotionListener\"];
listener@setHandler[\"mouseDragged\", \"evalMousePosition\"];
disp@addMouseMotionListener[listener];\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[7]:=",ExpressionUUID->"f976e898-77b1-499f-bc69-dd487785966e"],

Cell["\<\
Show two text area components. The function in text area inText will be \
evaluated depending on the camera position, and the result displayed in \
outText.\
\>", "MathCaption",ExpressionUUID->"f61e8f4f-b0e4-4d37-9bc6-7dcb9108f67e"],

Cell["\<\
inText = JavaNew[\"java.awt.TextArea\", \"Sin[x*y]\", 8, 40];
outText = JavaNew[\"java.awt.TextArea\", 8, 40];
frame = JavaNew[\"com.wolfram.jlink.MathFrame\", \"Evaluate Mouse Position\"];
frame@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
frame@add[outText, ByRef[BorderLayout`NORTH]];
frame@add[disp, ByRef[BorderLayout`CENTER]];
frame@add[inText, ByRef[BorderLayout`SOUTH]];
frame@pack[];
frame@setBounds[200, 200, 400, 400];
frame@setModal[];
JavaShow[frame]\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[13]:=",ExpressionUUID->"deddbc91-f895-4fa4-905a-fd8e66c10b04"],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display. \
After executing this command, start dragging inside the middle panel with the \
left mouse keeping pressed.\
\>", "MathCaption",ExpressionUUID->"96cc8b17-34b6-42c6-b552-bb1e24c4eb2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"84b5a3bf-dc04-4092-8cb5-90617a8e8a29"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.793779220322411*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"5ee4560a-e396-4053-8621-a664ac488e9e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"0a3fd8d9-d790-46fd-bb0c-32dbdfbf99db"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"1c98fbdc-e357-424e-abd4-72f93ffcc86d"]
}, Open  ]],

Cell["\<\
Just test that the notebook still is available. This is in contrast to the \
usage of RunJavaView[] which may block execution of.the notebook.\
\>", "MathCaption",ExpressionUUID->"188bc533-2d6c-40c4-8393-6c8de93e6a81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"viewer", "@", 
  RowBox[{
   RowBox[{"getDisplay", "[", "]"}], "@", 
   RowBox[{"getName", "[", "]"}]}]}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"4623e88e-346d-465b-9c85-726112e8ce05"],

Cell[BoxData["\<\"Pick and drag in this area\"\>"], "Output",
 CellChangeTimes->{3.793779232745189*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"c715f53a-2408-4100-8902-3345c2ba7870"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Or get in modal mode and pick/drag in JavaView window. But this command \
blocks further execution of this notebook until JavaView has exited. \
Therefore, we prefer ShareKernel[].\
\>", "MathCaption",ExpressionUUID->"bd6e344f-8201-4222-a9bf-5a0cd4495b0f"],

Cell[BoxData[
 RowBox[{"DoModal", "[", "]"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"40e0d80c-5914-4482-9915-b04cd075e2d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Clear ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from all Java processes. After calling UninstallJava[] the package \
<<JavaView`JLink` must be loaded again."
}], "MathCaption",ExpressionUUID->"6fd4e696-c42a-4b7b-b8f9-743293666a6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UninstallJava", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"7c94e6b3-3b01-4e1c-a544-5dad9199b3c2"]
}, Open  ]]
},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{854, 958},
WindowMargins->{{Automatic, 4}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, 56.6875}}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"4a9ad795-5de9-4add-82b5-f976376e9394"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 489, 15, 95, "Chapter",ExpressionUUID->"489d7f39-852e-47cb-a110-ee9ffc99cd0f",
 CellGroupingRules->"SectionGrouping"],
Cell[1050, 37, 393, 6, 26, "Text",ExpressionUUID->"37b477af-ee34-4a66-be2d-850dae257dbb"],
Cell[1446, 45, 374, 8, 28, "Text",ExpressionUUID->"48e2c3b4-902d-447b-951b-4b319ae119c3"],
Cell[CellGroupData[{
Cell[1845, 57, 195, 5, 30, "MathCaption",ExpressionUUID->"d0eb4de2-b008-4d3c-93c8-bb4d1bb90dc6"],
Cell[CellGroupData[{
Cell[2065, 66, 234, 5, 32, "Input",ExpressionUUID->"d2168b7c-ed35-4470-af61-2f54db010cf5"],
Cell[2302, 73, 254, 5, 16, "Print",ExpressionUUID->"464a6d6f-611d-4b6f-ad14-983b1946c69f"]
}, Open  ]],
Cell[2571, 81, 276, 4, 30, "MathCaption",ExpressionUUID->"ce9bcf9c-cf0e-418d-8399-9aadb0cbe043"],
Cell[2850, 87, 526, 13, 44, "Input",ExpressionUUID->"e265c713-e1d1-406d-831b-6498738f3bf5"],
Cell[3379, 102, 231, 3, 30, "MathCaption",ExpressionUUID->"11c2ce11-f7f9-44a0-b7b7-0645be9d47b9"],
Cell[3613, 107, 490, 15, 156, "Input",ExpressionUUID->"bfa1693a-c046-45cb-bb8e-59d66d833d15"],
Cell[4106, 124, 122, 0, 30, "MathCaption",ExpressionUUID->"63b61d7d-24cb-4f6e-b9e5-a1f38e9a0cf5"],
Cell[4231, 126, 482, 10, 88, "Input",ExpressionUUID->"f976e898-77b1-499f-bc69-dd487785966e"],
Cell[4716, 138, 242, 4, 30, "MathCaption",ExpressionUUID->"f61e8f4f-b0e4-4d37-9bc6-7dcb9108f67e"],
Cell[4961, 144, 625, 15, 156, "Input",ExpressionUUID->"deddbc91-f895-4fa4-905a-fd8e66c10b04"],
Cell[5589, 161, 272, 4, 30, "MathCaption",ExpressionUUID->"96cc8b17-34b6-42c6-b552-bb1e24c4eb2e"],
Cell[CellGroupData[{
Cell[5886, 169, 138, 2, 20, "Input",ExpressionUUID->"84b5a3bf-dc04-4092-8cb5-90617a8e8a29"],
Cell[6027, 173, 149, 2, 19, "Output",ExpressionUUID->"5ee4560a-e396-4053-8621-a664ac488e9e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6225, 181, 359, 9, 30, "MathCaption",ExpressionUUID->"0a3fd8d9-d790-46fd-bb0c-32dbdfbf99db"],
Cell[6587, 192, 140, 2, 20, "Input",ExpressionUUID->"1c98fbdc-e357-424e-abd4-72f93ffcc86d"]
}, Open  ]],
Cell[6742, 197, 228, 3, 30, "MathCaption",ExpressionUUID->"188bc533-2d6c-40c4-8393-6c8de93e6a81"],
Cell[CellGroupData[{
Cell[6995, 204, 219, 5, 20, "Input",ExpressionUUID->"4623e88e-346d-465b-9c85-726112e8ce05"],
Cell[7217, 211, 182, 2, 19, "Output",ExpressionUUID->"c715f53a-2408-4100-8902-3345c2ba7870"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7436, 218, 266, 4, 30, "MathCaption",ExpressionUUID->"bd6e344f-8201-4222-a9bf-5a0cd4495b0f"],
Cell[7705, 224, 134, 2, 20, "Input",ExpressionUUID->"40e0d80c-5914-4482-9915-b04cd075e2d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7876, 231, 262, 6, 30, "MathCaption",ExpressionUUID->"6fd4e696-c42a-4b7b-b8f9-743293666a6e"],
Cell[8141, 239, 158, 3, 20, "Input",ExpressionUUID->"7c94e6b3-3b01-4e1c-a544-5dad9199b3c2"]
}, Open  ]]
}
]
*)

