/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgFaceStar;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jvx.volume.PgCubeBndElementSet;

public class PgCubeSet
extends PgPointSet {
    public static final int[][] LOCAL_EDGE_TO_VERTEX = new int[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {0, 2}, {1, 3}, {4, 6}, {5, 7}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};
    public static final int[][] LOCAL_FACE_TO_VERTEX = new int[][]{{0, 2, 6, 4}, {3, 1, 5, 7}, {1, 0, 4, 5}, {2, 3, 7, 6}, {0, 1, 3, 2}, {5, 4, 6, 7}};
    protected boolean m_bShowCubeLabels;
    protected static final int m_dimOfCubes = 8;
    protected int m_numCubes;
    protected int m_maxNumCubes;
    protected PiVector[] m_cube;
    protected Color[] m_cubeColor;
    protected PiVector[] m_neighbour;
    protected PgCubeBndElementSet[] m_bndList;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected boolean m_bShowCubeTexture;
    protected PdVector[][] m_cubeTexture;
    protected boolean m_bShowEdges;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeColorFromCubes;
    protected boolean m_bShowEdgeColorFromVertices;
    protected PdColor m_globalEdgeColor;
    protected PuDouble m_globalEdgeSize;
    protected PuDouble m_scaleCubePaint;
    protected boolean m_bShowCubes;
    protected boolean m_bShowTaggedCubes;
    protected boolean m_bShowCubeColors;
    protected PdColor m_globalCubeColor;
    protected PdColor m_globalCubeTagColor;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bShowSmoothCubeColors;
    protected boolean m_bShowCubeColorFromVertices;
    protected int m_numFaces;
    protected PiVector[] m_face;
    protected Color[] m_faceColor;
    protected boolean m_bShowSmallCubes = false;
    protected boolean m_bOctagonsForCubes = true;
    protected boolean m_bHackCubeShrinkingFactor = true;
    static /* synthetic */ Class class$jvx$volume$PgCubeSet;

    public PgCubeSet() {
        this(3);
        this.m_bShowVertices = true;
    }

    public PgCubeSet(int n) {
        super(n);
        this.setType(34);
        this.setTag(7);
        this.addGeometryItem("Cube");
        this.setDimOfSimplex(2);
        this.m_cube = new PiVector[0];
        this.m_neighbour = null;
        this.m_cubeTexture = null;
        this.m_globalCubeColor = new PdColor(PsConfig.getMessage((int)24017), (PsUpdateIf)this);
        this.m_globalCubeTagColor = new PdColor(PsConfig.getMessage((int)24019), (PsUpdateIf)this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage((int)24023), (PsUpdateIf)this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage((int)24025), (PsUpdateIf)this);
        this.m_scaleCubePaint = new PuDouble(PsConfig.getMessage((boolean)true, (int)24000, (String)"Cube Scaling"), (PsUpdateIf)this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage((int)24026), (PsUpdateIf)this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage((int)24027), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PgCubeSet == null ? (class$jvx$volume$PgCubeSet = PgCubeSet.class$("jvx.volume.PgCubeSet")) : class$jvx$volume$PgCubeSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowCubeLabels = false;
        this.m_bShowVertices = false;
        this.setMaxNumCubes(0);
        this.m_bShowCubes = false;
        this.m_bShowTaggedCubes = true;
        this.m_cubeColor = null;
        this.m_bShowCubeColors = false;
        this.m_globalCubeColor.setColor(new Color(255, 225, 0));
        this.m_globalCubeTagColor.setColor(Color.magenta);
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothCubeColors = false;
        this.m_bShowCubeColorFromVertices = false;
        this.m_bShowEdges = true;
        this.m_bShowEdgeColors = false;
        this.m_bShowSmoothEdgeColors = false;
        this.m_bShowEdgeColorFromCubes = false;
        this.m_bShowEdgeColorFromVertices = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_scaleCubePaint.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_scaleCubePaint.setDefValue(0.5);
        this.m_scaleCubePaint.init();
        this.m_bndList = null;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_cubeTexture = null;
        this.m_bShowCubeTexture = false;
        this.m_dimOfTextures = 3;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(34);
        pgJvxSrc.showElementLabels(this.isShowingCubeLabels());
        pgJvxSrc.showTaggedElements(this.isShowingTaggedCubes());
        pgJvxSrc.showElements(this.isShowingCubes());
        pgJvxSrc.setNumElements(this.getNumCubes());
        pgJvxSrc.setElements(this.getCubes());
        pgJvxSrc.setNeighbours(this.getNeighbours());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothCubeColors());
        pgJvxSrc.showElementColorFromVertices(this.isShowingCubeFromVertexColors());
        pgJvxSrc.showElementColors(this.isShowingCubeColors());
        pgJvxSrc.setGlobalElementColor(this.getGlobalCubeColor());
        pgJvxSrc.setGlobalElementTagColor(this.getGlobalCubeTagColor());
        if (this.hasCubeTextures()) {
            pgJvxSrc.showElementTexture(this.isShowingCubeTexture());
            pgJvxSrc.setElementTextures(this.getCubeTextures());
        } else {
            pgJvxSrc.showElementTexture(false);
        }
        pgJvxSrc.showEdges(this.isShowingEdges());
        pgJvxSrc.showEdgeColors(this.isShowingEdgeColors());
        pgJvxSrc.showEdgeColorFromElements(this.isShowingEdgeColorFromCubes());
        pgJvxSrc.showEdgeColorFromVertices(this.isShowingEdgeColorFromVertices());
        pgJvxSrc.showSmoothEdgeColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgJvxSrc.showBoundaries(this.isShowingBoundaries());
        pgJvxSrc.setGlobalBndColor(this.getGlobalBndColor());
        pgJvxSrc.setGlobalBndTagColor(this.getGlobalBndTagColor());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showCubeLabels(pgJvxSrc.isShowingElementLabels());
        this.showTaggedCubes(pgJvxSrc.isShowingTaggedElements());
        this.showCubes(pgJvxSrc.isShowingElements());
        this.setNumCubes(pgJvxSrc.getNumElements());
        this.setCubes(pgJvxSrc.getElements());
        if (pgJvxSrc.getNeighbours() != null) {
            this.setNeighbours(pgJvxSrc.getNeighbours());
        } else if (PsJavaView.m_bAutoNeighbour) {
            this.makeNeighbour();
        } else {
            this.setNeighbours(null);
        }
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothCubeColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showCubeFromVertexColors(pgJvxSrc.isShowingElementColorFromVertices());
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalCubeColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalCubeTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        this.showCubeColors(pgJvxSrc.isShowingElementColors());
        this.setCubeTextures(pgJvxSrc.getElementTextures());
        this.showCubeTexture(pgJvxSrc.isShowingElementTexture());
        this.showEdges(pgJvxSrc.isShowingEdges());
        this.showEdgeColors(pgJvxSrc.isShowingEdgeColors());
        this.showEdgeColorFromCubes(pgJvxSrc.isShowingEdgeColorFromElements());
        this.showEdgeColorFromVertices(pgJvxSrc.isShowingEdgeColorFromVertices());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothEdgeColors());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        if (pgJvxSrc.getNumVectorFields() > 0) {
            int n = pgJvxSrc.getNumVectorFields();
            for (int i = 0; i < n; ++i) {
                if (!pgJvxSrc.isVectorElementBased(i)) continue;
                PgVectorField pgVectorField = this.getVectorField(i);
                PdVector[] pdVectorArray = pgJvxSrc.getVectors(i);
                if (pdVectorArray == null) {
                    PsDebug.warning((String)("missing vectors in vector field[" + i + "]."));
                    return;
                }
                int n2 = pdVectorArray.length;
                pgVectorField.setGeometry((PgPointSet)this);
                pgVectorField.setBasedOn(1);
                pgVectorField.setNumVectors(n2);
                pgVectorField.setVectorColors(pgJvxSrc.getVectorFieldColors(i));
                pgVectorField.setVectors(pdVectorArray);
            }
        }
    }

    public boolean applyModelingMatrix() {
        if (!this.hasModelMatrix()) {
            return false;
        }
        if (this.hasBoundary()) {
            int n = this.getNumBoundaries();
            for (int i = 0; i < n; ++i) {
                this.m_bndList[i].setModelMatrix(((PgGeometry)this).m_modelMatrix);
                this.m_bndList[i].applyModelingMatrix();
            }
        }
        return super.applyModelingMatrix();
    }

    public Object clone() {
        PgCubeSet pgCubeSet = (PgCubeSet)((Object)super.clone());
        if (pgCubeSet == null) {
            return null;
        }
        pgCubeSet.m_globalCubeColor = (PdColor)this.m_globalCubeColor.clone();
        pgCubeSet.m_globalCubeTagColor = (PdColor)this.m_globalCubeTagColor.clone();
        pgCubeSet.m_globalCubeColor.setParent((PsUpdateIf)pgCubeSet);
        pgCubeSet.m_globalCubeTagColor.setParent((PsUpdateIf)pgCubeSet);
        pgCubeSet.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        pgCubeSet.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        pgCubeSet.m_globalBndColor.setParent((PsUpdateIf)pgCubeSet);
        pgCubeSet.m_globalBndTagColor.setParent((PsUpdateIf)pgCubeSet);
        pgCubeSet.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgCubeSet.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgCubeSet.m_globalEdgeSize.setParent((PsUpdateIf)pgCubeSet);
        pgCubeSet.m_globalEdgeColor.setParent((PsUpdateIf)pgCubeSet);
        if (this.m_cube != null) {
            pgCubeSet.m_cube = (PiVector[])P_Vector.clone((P_Vector[])this.m_cube);
        }
        if (this.m_cubeColor != null) {
            pgCubeSet.m_cubeColor = (Color[])this.m_cubeColor.clone();
        }
        if (this.m_cubeTexture != null) {
            pgCubeSet.m_cubeTexture = (PdVector[][])P_Vector.clone((P_Vector[][])this.m_cubeTexture);
        }
        if (this.m_neighbour != null) {
            pgCubeSet.m_neighbour = (PiVector[])P_Vector.clone((P_Vector[])this.m_neighbour);
        }
        if (this.m_bndList != null) {
            pgCubeSet.m_bndList = null;
            int n = this.getNumBoundaries();
            if (n > 0) {
                PgCubeBndElementSet[] pgCubeBndElementSetArray = (PgCubeBndElementSet[])this.m_bndList.clone();
                for (int i = 0; i < n; ++i) {
                    pgCubeBndElementSetArray[i] = (PgCubeBndElementSet)((Object)pgCubeBndElementSetArray[i].clone());
                }
                pgCubeSet.setBoundary(pgCubeBndElementSetArray);
            }
        }
        return pgCubeSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgCubeSet)) {
            return;
        }
        PgCubeSet pgCubeSet = (PgCubeSet)psObject;
        this.m_bShowCubeLabels = pgCubeSet.m_bShowCubeLabels;
        this.m_bShowBoundaries = pgCubeSet.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgCubeSet.m_bShowTaggedBoundaries;
        this.m_bShowCubeTexture = pgCubeSet.m_bShowCubeTexture;
        this.m_bShowEdges = pgCubeSet.m_bShowEdges;
        this.m_bShowEdgeColors = pgCubeSet.m_bShowEdgeColors;
        this.m_bShowCubes = pgCubeSet.m_bShowCubes;
        this.m_bShowTaggedCubes = pgCubeSet.m_bShowTaggedCubes;
        this.m_bShowCubeColors = pgCubeSet.m_bShowCubeColors;
        this.m_globalBndColor.copy(pgCubeSet.m_globalBndColor);
        this.m_globalBndTagColor.copy(pgCubeSet.m_globalBndTagColor);
        this.m_globalEdgeColor.copy(pgCubeSet.m_globalEdgeColor);
        this.m_globalEdgeSize.copy(pgCubeSet.m_globalEdgeSize);
        this.m_globalCubeColor.copy(pgCubeSet.m_globalCubeColor);
        this.m_globalCubeTagColor.copy(pgCubeSet.m_globalCubeTagColor);
        this.copyCubeSet(pgCubeSet);
        int n = this.getNumVectorFields();
        for (int i = 0; i < n; ++i) {
            PgVectorField pgVectorField = this.getVectorField(i);
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setGeometry((PgPointSet)this);
        }
    }

    public void copyCubeSet(PgCubeSet pgCubeSet) {
        this.setNumCubes(pgCubeSet.getNumCubes());
        PiVector.copy((PiVector[])this.m_cube, (int)0, (PiVector[])pgCubeSet.getCubes(), (int)0, (int)this.m_numCubes);
        PiVector[] piVectorArray = pgCubeSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy((PiVector[])this.m_neighbour, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numCubes);
        } else {
            this.m_neighbour = null;
        }
        if (pgCubeSet.m_cubeColor != null) {
            this.assureCubeColors();
            PdColor.copy((Color[])this.m_cubeColor, (int)0, (Color[])pgCubeSet.getCubeColors(), (int)0, (int)this.m_numCubes);
        } else {
            this.m_cubeColor = null;
        }
        if (pgCubeSet.m_cubeTexture != null) {
            this.assureCubeTextures();
            for (int i = 0; i < this.m_numCubes; ++i) {
                PdVector.copy((PdVector[])this.m_cubeTexture[i], (int)0, (PdVector[])pgCubeSet.m_cubeTexture[i], (int)0, (int)pgCubeSet.m_cubeTexture[i].length);
            }
        } else {
            this.m_cubeTexture = null;
        }
        if (pgCubeSet.hasBoundary()) {
            PgCubeBndElementSet[] pgCubeBndElementSetArray = pgCubeSet.getBoundaries();
            this.assureBoundary(pgCubeBndElementSetArray.length);
            for (int i = 0; i < this.m_bndList.length; ++i) {
                this.m_bndList[i].copy((PsObject)pgCubeBndElementSetArray[i]);
            }
        } else {
            this.m_bndList = null;
        }
    }

    public void copyConnectivity(PgCubeSet pgCubeSet) {
        this.setNumCubes(pgCubeSet.getNumCubes());
        PiVector.copy((PiVector[])this.m_cube, (int)0, (PiVector[])pgCubeSet.getCubes(), (int)0, (int)this.m_numCubes);
        PiVector[] piVectorArray = pgCubeSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy((PiVector[])this.m_neighbour, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numCubes);
        } else {
            this.m_neighbour = null;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgCubeSet *********\n");
        stringBuffer.append("\t m_numCubes    = " + this.m_numCubes + " (max = " + this.m_maxNumCubes + ")\n");
        stringBuffer.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        stringBuffer.append("\t ******* m_cube *******\n");
        if (this.m_cube != null) {
            for (n = 0; n < this.m_numCubes; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_cube[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_cube = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            for (n = 0; n < this.m_numCubes; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        stringBuffer.append("\t ******* m_cubeTexture *******\n");
        if (this.m_cubeTexture != null && this.m_numCubes > 0) {
            for (n = 0; n < this.m_numCubes; ++n) {
                if (this.m_cubeTexture[n] == null) {
                    stringBuffer.append("\t [" + n + "] = null");
                    continue;
                }
                for (int i = 0; i < this.m_cubeTexture[n].length; ++i) {
                    stringBuffer.append("\t [" + n + "][" + i + "] = " + this.m_cubeTexture[n][i].toShortString());
                }
            }
        } else {
            stringBuffer.append("\t m_cubeTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == null || object == this) {
            return super.update(object);
        }
        if (object == this.m_globalBndColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_scaleCubePaint) {
            return super.update(null);
        }
        if (object == this.m_globalCubeColor) {
            return super.update(null);
        }
        if (object == this.m_globalCubeTagColor) {
            return super.update(null);
        }
        return super.update(object);
    }

    public int addCube(PiVector piVector) {
        if (piVector == null || piVector.getSize() != 8) {
            PsDebug.warning((String)"argument tetrahedron too small.");
            return -1;
        }
        int n = this.getNumCubes();
        if (this.m_numCubes == this.m_maxNumCubes) {
            this.setMaxNumCubes((int)((double)(this.m_numCubes + 1) * 1.2));
        }
        this.setNumCubes(n + 1);
        this.setCube(n, piVector);
        if (this.m_cubeColor != null) {
            this.m_cubeColor[n] = this.m_globalCubeColor.getColor();
        }
        return n;
    }

    public Color getGlobalCubeColor() {
        return this.m_globalCubeColor.getColor();
    }

    public Color getGlobalCubeTagColor() {
        return this.m_globalCubeTagColor.getColor();
    }

    public void setGlobalCubeColor(Color color) {
        this.m_globalCubeColor.setColor(color);
    }

    public void setGlobalCubeTagColor(Color color) {
        this.m_globalCubeTagColor.setColor(color);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public PiVector[] getCubes() {
        return this.m_cube;
    }

    public Color[] getCubeColors() {
        return this.m_cubeColor;
    }

    public PdVector[] getCubeTexture(int n) {
        if (!this.hasCubeTextures()) {
            PsDebug.warning((String)"missing cube textures");
            return null;
        }
        if (n < 0 || this.m_numCubes <= n) {
            PsDebug.warning((String)("index out of range, ind = " + n));
            return null;
        }
        return this.m_cubeTexture[n];
    }

    public PdVector[][] getCubeTextures() {
        return this.m_cubeTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasCubeTextures()) {
            return null;
        }
        int n = this.getNumCubeIndices();
        PdVector[] pdVectorArray = new PdVector[n];
        n = 0;
        for (int i = 0; i < this.m_numCubes; ++i) {
            for (int j = 0; j < 8; ++j) {
                pdVectorArray[n++] = this.m_cubeTexture[i][j];
            }
        }
        return pdVectorArray;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public int getNumBoundaries() {
        this.removeDeletedBoundaries();
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public boolean hasBoundary() {
        return this.getNumBoundaries() > 0;
    }

    public PgCubeBndElementSet[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
            return this.m_bndList;
        }
        this.removeDeletedBoundaries();
        return this.m_bndList;
    }

    public void removeBoundaries() {
        if (this.m_bndList == null) {
            return;
        }
        for (int i = 0; i < this.m_bndList.length; ++i) {
            this.m_bndList[i].setCubeSet(null);
        }
        this.m_bndList = null;
    }

    public int removeDeletedBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_bndList.length; ++i) {
            if (this.m_bndList[i].hasTag(2)) continue;
            ++n;
        }
        if (n == this.m_bndList.length) {
            return 0;
        }
        PgCubeBndElementSet[] pgCubeBndElementSetArray = this.m_bndList;
        this.m_bndList = new PgCubeBndElementSet[n];
        int n2 = 0;
        for (int i = 0; i < pgCubeBndElementSetArray.length; ++i) {
            if (pgCubeBndElementSetArray[i].hasTag(2)) {
                pgCubeBndElementSetArray[i].setCubeSet(null);
                continue;
            }
            this.m_bndList[n2++] = pgCubeBndElementSetArray[i];
        }
        return pgCubeBndElementSetArray.length - n;
    }

    public void setBoundary(PgCubeBndElementSet[] pgCubeBndElementSetArray) {
        if (pgCubeBndElementSetArray == null) {
            this.removeBoundaries();
            return;
        }
        this.m_bndList = new PgCubeBndElementSet[pgCubeBndElementSetArray.length];
        for (int i = 0; i < pgCubeBndElementSetArray.length; ++i) {
            this.m_bndList[i] = pgCubeBndElementSetArray[i];
            this.m_bndList[i].setCubeSet(this);
        }
        this.removeDeletedBoundaries();
    }

    public void assureBoundary(int n) {
        int n2;
        if (this.m_bndList != null && this.m_bndList.length == n) {
            return;
        }
        PgCubeBndElementSet[] pgCubeBndElementSetArray = this.m_bndList;
        this.m_bndList = new PgCubeBndElementSet[n];
        int n3 = 0;
        if (pgCubeBndElementSetArray != null) {
            n3 = pgCubeBndElementSetArray.length;
            for (n2 = 0; n2 < Math.min(n3, n); ++n2) {
                this.m_bndList[n2] = pgCubeBndElementSetArray[n2];
                this.m_bndList[n2].clearTag(2);
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.m_bndList[n2] = new PgCubeBndElementSet(((PgGeometry)this).m_dim);
            this.m_bndList[n2].setName("Boundary_" + String.valueOf(n2));
            this.m_bndList[n2].setCubeSet(this);
            this.m_bndList[n2].setDimOfVectors(this.getDimOfVectors());
        }
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromCubes() {
        return this.m_bShowEdgeColorFromCubes;
    }

    public void showEdgeColorFromCubes(boolean bl) {
        this.m_bShowEdgeColorFromCubes = bl;
        if (bl && this.m_bShowEdgeColorFromVertices) {
            this.m_bShowEdgeColorFromVertices = false;
        }
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromVertices() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeColorFromVertices(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
        if (bl && this.m_bShowEdgeColorFromCubes) {
            this.m_bShowEdgeColorFromCubes = false;
        }
    }

    public boolean isShowingCubeLabels() {
        return this.m_bShowCubeLabels;
    }

    public boolean isShowingCubes() {
        return this.m_bShowCubes;
    }

    public boolean isShowingTaggedCubes() {
        return this.m_bShowTaggedCubes;
    }

    public boolean isShowingCubeTexture() {
        return this.m_bShowCubeTexture;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public boolean isShowingCubeColors() {
        return this.m_bShowCubeColors;
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public boolean isShowingSmoothCubeColors() {
        return this.m_bShowSmoothCubeColors;
    }

    public void showSmoothCubeColors(boolean bl) {
        this.m_bShowSmoothCubeColors = bl;
    }

    public boolean isShowingCubeColorFromVertices() {
        return this.m_bShowCubeColorFromVertices;
    }

    public void showCubeColorFromVertices(boolean bl) {
        this.m_bShowCubeColorFromVertices = bl;
    }

    public boolean isShowingCubeFromVertexColors() {
        return this.isShowingCubeColorFromVertices();
    }

    public void showCubeFromVertexColors(boolean bl) {
        this.showCubeColorFromVertices(bl);
    }

    public void showCubeLabels(boolean bl) {
        this.m_bShowCubeLabels = bl;
    }

    public void showCubes(boolean bl) {
        this.m_bShowCubes = bl;
    }

    public void showTaggedCubes(boolean bl) {
        this.m_bShowTaggedCubes = bl;
    }

    public void showCubeTexture(boolean bl) {
        this.m_bShowCubeTexture = bl;
        if (bl && this.isShowingVertexTexture()) {
            this.showVertexTexture(false);
        }
    }

    public void showVertexTexture(boolean bl) {
        if (bl && this.isShowingCubeTexture()) {
            this.showCubeTexture(false);
        }
        super.showVertexTexture(bl);
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void showTaggedBoundaries(boolean bl) {
        this.m_bShowTaggedBoundaries = bl;
    }

    public void showCubeColors(boolean bl) {
        this.m_bShowCubeColors = bl;
    }

    private int computeNumFaces() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numCubes * 8;
        } else {
            for (int i = 0; i < this.m_numCubes; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.m_neighbour[i].m_data[j] >= i) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumFaces() {
        this.m_numFaces = this.computeNumFaces();
        return this.m_numFaces;
    }

    public void setNumFaces(int n) {
        if (this.m_numFaces == n) {
            return;
        }
        this.m_face = PiVector.realloc((PiVector[])this.m_face, (int)n, (int)4);
        this.m_numFaces = n;
        if (this.hasCubeColors()) {
            this.assureCubeColors();
        }
    }

    protected void assureFaceColors() {
        if (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces) {
            this.m_faceColor = PdColor.realloc((Color[])this.m_faceColor, (int)this.m_numFaces);
        }
    }

    public int getMaxNumCubes() {
        return this.m_maxNumCubes;
    }

    public void setMaxNumCubes(int n) {
        if (this.m_maxNumCubes == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumCubes = n;
            return;
        }
        this.m_cube = PiVector.realloc((PiVector[])this.m_cube, (int)n, (int)8);
        if (this.m_maxNumCubes < n) {
            this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)n, (int)6);
            for (int i = this.m_maxNumCubes; i < n; ++i) {
                this.m_neighbour[i].setConstant(-1);
            }
        }
        this.m_maxNumCubes = n;
        this.assureNeighbours();
        if (this.m_cubeColor != null) {
            this.assureCubeColors();
        }
        if (this.m_cubeTexture != null) {
            this.assureCubeTextures();
        }
        if (this.m_maxNumCubes < this.m_numCubes) {
            this.m_numCubes = this.m_maxNumCubes;
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setMaxNumVectors(this.m_maxNumCubes);
            }
        }
    }

    public int getNumCubes() {
        return this.m_numCubes;
    }

    public int getNumCubeIndices() {
        return 8 * this.m_numCubes;
    }

    public void setNumCubes(int n) {
        if (this.m_numCubes == n) {
            return;
        }
        if (n > this.m_maxNumCubes || n < this.m_maxNumCubes / 2 && n < this.m_maxNumCubes - 100) {
            this.setMaxNumCubes(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numCubes = n;
            return;
        }
        if (this.m_neighbour != null) {
            int n2;
            if (n < this.m_numCubes) {
                for (n2 = 0; n2 < n; ++n2) {
                    for (int i = this.m_neighbour[n2].getSize() - 1; i >= 0; --i) {
                        if (this.m_neighbour[n2].m_data[i] < n) continue;
                        this.m_neighbour[n2].m_data[i] = -1;
                    }
                }
            } else {
                for (n2 = this.m_numCubes; n2 < n; ++n2) {
                    this.m_neighbour[n2].setConstant(-1);
                }
            }
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n);
            }
        }
        this.m_numCubes = n;
    }

    public int getDimOfCubes() {
        return 8;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == ((PgGeometry)this).m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.hasBoundary()) {
            for (int i = 0; i < this.m_bndList.length; ++i) {
                if (this.m_bndList[i] == null) continue;
                this.m_bndList[i].setDimOfVectors(n);
            }
        }
    }

    protected void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumCubes) {
            for (n = 0; n < this.m_maxNumCubes; ++n) {
                if (this.m_neighbour[n].m_data != null && this.m_cube[n].m_data != null && this.m_neighbour[n].m_data.length == 6) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)this.m_maxNumCubes, (int)6);
        if (bl) {
            for (n = 0; n < this.m_maxNumCubes; ++n) {
                this.m_neighbour[n].setConstant(-1);
            }
        }
    }

    public boolean hasCubeColors() {
        return this.m_cubeColor != null && this.m_cubeColor.length == this.m_maxNumCubes;
    }

    public boolean hasCubeTextures() {
        return this.m_cubeTexture != null && this.m_cubeTexture.length == this.m_maxNumCubes;
    }

    public void assureCubeColors() {
        if (this.m_cubeColor == null || this.m_cubeColor.length != this.m_maxNumCubes) {
            this.m_cubeColor = PdColor.realloc((Color[])this.m_cubeColor, (int)this.m_maxNumCubes);
        }
    }

    public void assureCubeTextures() {
        if (this.m_cubeTexture == null) {
            this.m_cubeTexture = new PdVector[this.m_maxNumCubes][];
        }
        if (this.m_cubeTexture.length != this.m_maxNumCubes) {
            PdVector[][] pdVectorArrayArray = new PdVector[this.m_maxNumCubes][];
            int n = this.m_cubeTexture.length;
            if (n > this.m_maxNumCubes) {
                n = this.m_maxNumCubes;
            }
            for (int i = 0; i < n; ++i) {
                pdVectorArrayArray[i] = this.m_cubeTexture[i];
            }
            this.m_cubeTexture = pdVectorArrayArray;
        }
        for (int i = 0; i < this.m_maxNumCubes; ++i) {
            this.m_cubeTexture[i] = PdVector.realloc((PdVector[])this.m_cubeTexture[i], (int)this.m_cube[i].getSize(), (int)this.m_dimOfTextures);
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    public boolean isShowingSmallCubes() {
        return this.m_bShowSmallCubes;
    }

    public void showSmallCubes(boolean bl) {
        this.m_bShowSmallCubes = bl;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        PdVector[] pdVectorArray = new PdVector[]{};
        int n = this.m_numVertices;
        int n2 = this.m_numCubes;
        if (this.m_bShowSmallCubes) {
            double d = this.m_scaleCubePaint.getValue();
            pdVectorArray = (PdVector[])this.m_vertex.clone();
            this.setNumVertices(8 * n2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 8; ++j) {
                    this.m_vertex[8 * i + j] = PdVector.blendNew((double)(0.125 + 0.875 * d), (PdVector)pdVectorArray[this.m_cube[i].m_data[j]], (double)(0.125 - 0.125 * d), (PdVector)pdVectorArray[this.m_cube[i].m_data[(j + 1) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 2) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 3) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 4) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 5) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 6) % 8]]);
                    this.m_vertex[8 * i + j].blendBase(this.m_vertex[8 * i + j], 0.125 - 0.125 * d, pdVectorArray[this.m_cube[i].m_data[(j + 7) % 8]]);
                }
            }
        }
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(84, this.isShowingCubeLabels());
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(104, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(94, this.m_bShowEdgeColors);
        pvGeometryIf.setState(95, this.m_bShowEdgeColorFromCubes);
        pvGeometryIf.setState(96, this.m_bShowEdgeColorFromVertices);
        if (this.m_globalEdgeColor != null) {
            pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
        }
        if (this.m_globalEdgeSize != null) {
            pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
        }
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_globalBndColor != null) {
            pvGeometryIf.setGlobalBndColor(this.m_globalBndColor.getColor());
        }
        if (this.m_globalBndTagColor != null) {
            pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
        }
        pvGeometryIf.setState(56, this.m_bShowCubes);
        pvGeometryIf.setState(57, this.m_bShowTaggedCubes);
        pvGeometryIf.setState(103, this.isShowingSmoothLighting());
        pvGeometryIf.setState(105, this.isShowingSmoothCubeColors());
        pvGeometryIf.setState(106, this.isShowingCubeFromVertexColors());
        pvGeometryIf.setState(98, this.m_bShowCubeColors);
        if (this.m_globalCubeColor != null) {
            pvGeometryIf.setGlobalElementColor(this.m_globalCubeColor.getColor());
        }
        if (this.m_globalCubeTagColor != null) {
            pvGeometryIf.setGlobalElementTagColor(this.m_globalCubeTagColor.getColor());
        }
        if (this.m_bShowSmallCubes) {
            int n3;
            this.m_face = new PiVector[n2 * 6];
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_face[6 * n3 + 0] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[0][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[0][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[0][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[0][3]);
                this.m_face[6 * n3 + 1] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[1][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[1][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[1][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[1][3]);
                this.m_face[6 * n3 + 2] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[2][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[2][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[2][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[2][3]);
                this.m_face[6 * n3 + 3] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[3][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[3][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[3][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[3][3]);
                this.m_face[6 * n3 + 4] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[4][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[4][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[4][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[4][3]);
                this.m_face[6 * n3 + 5] = new PiVector(8 * n3 + LOCAL_FACE_TO_VERTEX[5][0], 8 * n3 + LOCAL_FACE_TO_VERTEX[5][1], 8 * n3 + LOCAL_FACE_TO_VERTEX[5][2], 8 * n3 + LOCAL_FACE_TO_VERTEX[5][3]);
            }
            this.m_numFaces = 6 * n2;
            if (this.hasCubeColors() && (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces)) {
                this.assureFaceColors();
            }
            if (this.hasCubeColors()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    for (int i = 0; i < 6; ++i) {
                        this.m_faceColor[6 * n3 + i] = this.getCubeColor(n3);
                    }
                }
            }
        } else {
            if (this.hasCubeColors() && (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces)) {
                this.assureFaceColors();
            }
            this.computeFaces();
        }
        if (this.m_bOctagonsForCubes) {
            if (this.m_bHackCubeShrinkingFactor) {
                pvGeometryIf.setGlobalBndSize(this.m_scaleCubePaint.getValue());
            }
            pvGeometryIf.setNumElements(this.m_numCubes);
            pvGeometryIf.setElements(this.m_cube);
            pvGeometryIf.setElementColors(this.m_cubeColor);
        } else {
            pvGeometryIf.setNumElements(this.m_numFaces);
            pvGeometryIf.setElements(this.m_face);
            pvGeometryIf.setElementColors(this.m_faceColor);
        }
        if (this.m_bShowSmallCubes) {
            this.setNumVertices(n);
            this.setVertices(pdVectorArray);
        }
    }

    public void makeCubeConn(int n, int n2, int n3) {
        if (n < 2 || n2 < 2 || n3 < 2) {
            PsDebug.warning((String)"discretization smaller than 2.");
            return;
        }
        this.setNumCubes((n - 1) * (n2 - 1) * (n3 - 1));
        int n4 = 0;
        int[] nArray = new int[8];
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                for (int k = 0; k < n3 - 1; ++k) {
                    nArray[0] = (i + 0) * n2 * n3 + (j + 0) * n3 + (k + 0);
                    nArray[1] = (i + 0) * n2 * n3 + (j + 0) * n3 + (k + 1);
                    nArray[2] = (i + 0) * n2 * n3 + (j + 1) * n3 + (k + 1);
                    nArray[3] = (i + 0) * n2 * n3 + (j + 1) * n3 + (k + 0);
                    nArray[4] = (i + 1) * n2 * n3 + (j + 0) * n3 + (k + 0);
                    nArray[5] = (i + 1) * n2 * n3 + (j + 0) * n3 + (k + 1);
                    nArray[6] = (i + 1) * n2 * n3 + (j + 1) * n3 + (k + 1);
                    nArray[7] = (i + 1) * n2 * n3 + (j + 1) * n3 + (k + 0);
                    for (int i2 = 0; i2 < 8; ++i2) {
                        this.m_cube[n4].setEntry(i2, nArray[i2]);
                    }
                    ++n4;
                }
            }
        }
        this.makeNeighbour();
    }

    public void flipOrientation() {
        int n;
        super.flipOrientation();
        for (n = 0; n < this.m_numCubes; ++n) {
            this.m_cube[n].invert();
        }
        if (this.m_cubeTexture != null) {
            for (n = 0; n < this.m_numCubes; ++n) {
                PuData.invert((Object[])this.m_cubeTexture[n]);
            }
        }
    }

    public static PiVector getVertexValence(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumVertices();
        int n2 = pgCubeSet.getNumCubes();
        PiVector[] piVectorArray = pgCubeSet.getCubes();
        PiVector[] piVectorArray2 = pgCubeSet.getNeighbours();
        PiVector piVector = new PiVector(n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (piVectorArray2[i].m_data[j] > i) continue;
                int n3 = piVectorArray[i].m_data[(j + 1) % 8];
                piVector.m_data[n3] = piVector.m_data[n3] + 1;
                int n4 = piVectorArray[i].m_data[(j + 2) % 8];
                piVector.m_data[n4] = piVector.m_data[n4] + 1;
            }
        }
        return piVector;
    }

    public void buildCube(PdVector[] pdVectorArray, int n, int n2, int n3) {
        if (pdVectorArray == null || pdVectorArray.length < 8) {
            PsDebug.error((String)"no initial vertices or wrong number", (Object)((Object)this));
            return;
        }
        if (n < 2 || n2 < 2 || n3 < 2) {
            PsDebug.warning((String)"discretization smaller than 2.");
            return;
        }
        this.setNumVertices(n * n2 * n3);
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector2 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector3 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector4 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector5 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector6 = new PdVector(((PgGeometry)this).m_dim);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            double d = (double)i / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[4]);
            pdVector2.blend(1.0 - d, pdVectorArray[1], d, pdVectorArray[5]);
            pdVector3.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[6]);
            pdVector4.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[7]);
            for (int j = 0; j < n2; ++j) {
                double d2 = (double)j / ((double)n2 - 1.0);
                pdVector5.blend(1.0 - d2, pdVector, d2, pdVector3);
                pdVector6.blend(1.0 - d2, pdVector2, d2, pdVector4);
                for (int k = 0; k < n3; ++k) {
                    double d3 = (double)k / ((double)n3 - 1.0);
                    this.m_vertex[n4++].blend(1.0 - d3, pdVector5, d3, pdVector6);
                }
            }
        }
        this.makeCubeConn(n, n2, n3);
    }

    public int getNumUnusedVertices() {
        int n;
        int n2;
        boolean[] blArray = new boolean[this.m_numVertices];
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 0; n2 < this.m_numCubes; ++n2) {
            for (n = 0; n < 8; ++n) {
                blArray[this.m_cube[n2].m_data[n]] = false;
            }
        }
        n2 = 0;
        for (n = 0; n < this.m_numVertices; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        return n2;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        for (n2 = 0; n2 < this.m_numCubes; ++n2) {
            for (n = 0; n < 8; ++n) {
                nArray[this.m_cube[n2].m_data[n]] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] != n3) continue;
            nArray[n2] = n5++;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
            this.m_vertex[nArray[n2]] = this.m_vertex[n2];
        }
        for (n2 = 0; n2 < this.m_numCubes; ++n2) {
            for (n = 0; n < 8; ++n) {
                this.m_cube[n2].m_data[n] = nArray[this.m_cube[n2].m_data[n]];
            }
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexNormal[nArray[n2]] = this.m_vertexNormal[n2];
            }
        }
        if (this.m_vertexColor != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexColor[nArray[n2]] = this.m_vertexColor[n2];
            }
        }
        if (this.m_vertexTexture != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexTexture[nArray[n2]] = this.m_vertexTexture[n2];
            }
        }
        int n6 = this.getNumVectorFields();
        for (n2 = 0; n2 < n6; ++n2) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n4 || nArray[n] >= n) continue;
                pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
            }
            pgVectorField.setNumVectors(n5);
        }
        if (this.m_bndList != null) {
            for (n2 = 0; n2 < this.m_bndList.length; ++n2) {
                if (this.m_bndList[n2].hasTag(2)) continue;
                int n7 = this.m_bndList[n2].getNumVertices();
                boolean bl = true;
                for (n = 0; n < n7; ++n) {
                    if (this.m_bndList[n2].getVertexInd().m_data[n] != -1 && this.m_bndList[n2].getVertexInd().m_data[n] < this.m_numVertices) continue;
                    this.m_bndList[n2].setTag(2);
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n = 0; n < n7; ++n) {
                    this.m_bndList[n2].getVertexInd().m_data[n] = nArray[this.m_bndList[n2].getVertexInd().m_data[n]];
                }
                this.m_bndList[n2].assignVertices();
            }
        }
        PsDebug.notify((String)("number of deleted vertices = " + (this.m_numVertices - n5)));
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public int[] removeMarkedVertices() {
        int n;
        int n2;
        int n3 = -1;
        int[] nArray = super.removeMarkedVertices();
        block0: for (n2 = 0; n2 < this.m_numCubes; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (nArray[this.m_cube[n2].m_data[n]] == n3) {
                    this.m_cube[n2].setTag(2);
                    continue block0;
                }
                this.m_cube[n2].m_data[n] = nArray[this.m_cube[n2].m_data[n]];
            }
        }
        if (this.m_bndList != null) {
            for (n2 = 0; n2 < this.m_bndList.length; ++n2) {
                if (this.m_bndList[n2].hasTag(2)) continue;
                n = this.m_bndList[n2].getNumVertices();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    if (nArray[this.m_bndList[n2].getVertexInd().m_data[i]] == n3) continue;
                    this.m_bndList[n2].getVertexInd().m_data[n4++] = nArray[this.m_bndList[n2].getVertexInd().m_data[i]];
                }
                if (n4 >= n) continue;
                this.m_bndList[n2].setNumVertices(n4);
            }
        }
        this.removeMarkedCubes();
        return nArray;
    }

    public int[] removeCube(int n) {
        this.m_cube[n].setTag(2);
        return this.removeMarkedCubes();
    }

    public int[] removeMarkedCubes() {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        int n5 = -1;
        PiVector piVector = new PiVector(this.m_numCubes);
        int[] nArray = piVector.m_data;
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            nArray[n3] = this.m_cube[n3].hasTag(2) ? n5 : n4;
        }
        int n6 = 0;
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            if (nArray[n3] != n4) continue;
            nArray[n3] = n6++;
        }
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            if (nArray[n3] == n5) continue;
            for (n2 = 0; n2 < 6; ++n2) {
                if (this.m_neighbour[n3].m_data[n2] <= -1) continue;
                this.m_neighbour[n3].m_data[n2] = nArray[this.m_neighbour[n3].m_data[n2]];
            }
        }
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
            this.m_cube[nArray[n3]].copy(this.m_cube[n3]);
            this.m_neighbour[nArray[n3]].copy(this.m_neighbour[n3]);
        }
        if (this.m_cubeColor != null) {
            for (n3 = 0; n3 < this.m_numCubes; ++n3) {
                if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
                this.m_cubeColor[nArray[n3]] = this.m_cubeColor[n3];
            }
        }
        if (this.m_cubeTexture != null) {
            for (n3 = 0; n3 < this.m_numCubes; ++n3) {
                if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
                this.m_cubeTexture[nArray[n3]] = PdVector.copyNew((PdVector[])this.m_cubeTexture[n3]);
            }
        }
        if (this.m_bndList != null) {
            n = 0;
            block7: for (n3 = 0; n3 < this.m_bndList.length; ++n3) {
                if (this.m_bndList[n3].hasTag(2)) continue;
                int n7 = this.m_bndList[n3].getNumElements();
                int n8 = 0;
                for (n2 = 0; n2 < n7; ++n2) {
                    if (nArray[this.m_bndList[n3].m_cubeInd.m_data[n2]] == n5) {
                        this.m_bndList[n3].setTag(2);
                        n = 1;
                        continue block7;
                    }
                    this.m_bndList[n3].m_cubeInd.m_data[n8++] = nArray[this.m_bndList[n3].m_cubeInd.m_data[n2]];
                }
            }
            if (n != 0) {
                this.removeDeletedBoundaries();
            }
        }
        n = this.getNumVectorFields();
        for (n3 = 0; n3 < n; ++n3) {
            PgVectorField pgVectorField = this.getVectorField(n3);
            if (pgVectorField.getBasedOn() == 0) continue;
            for (n2 = 0; n2 < this.m_numCubes; ++n2) {
                if (nArray[n2] == n5 || nArray[n2] >= n2) continue;
                pgVectorField.setVector(nArray[n2], pgVectorField.getVector(n2));
            }
            pgVectorField.setNumVectors(n6);
        }
        PsDebug.notify((String)("number of deleted cubes = " + (this.m_numCubes - n6)));
        this.setNumCubes(n6);
        this.setMaxNumCubes(n6);
        return nArray;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        int n;
        int n2;
        int n3 = this.m_numVertices;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgCubeSet)) {
            return false;
        }
        PgCubeSet pgCubeSet = (PgCubeSet)pgGeometryIf;
        int n4 = this.m_numCubes;
        int n5 = this.m_numCubes + pgCubeSet.m_numCubes;
        this.setNumCubes(n5);
        PiVector.copy((PiVector[])this.m_cube, (int)n4, (PiVector[])pgCubeSet.m_cube, (int)0, (int)pgCubeSet.m_numCubes);
        for (n2 = 0; n2 < pgCubeSet.m_numCubes; ++n2) {
            n = 0;
            while (n < 8) {
                int n6 = n++;
                this.m_cube[n4 + n2].m_data[n6] = this.m_cube[n4 + n2].m_data[n6] + n3;
            }
        }
        if (pgCubeSet.m_neighbour != null) {
            PiVector.copy((PiVector[])this.m_neighbour, (int)n4, (PiVector[])pgCubeSet.m_neighbour, (int)0, (int)pgCubeSet.m_numCubes);
            for (n2 = 0; n2 < pgCubeSet.m_numCubes; ++n2) {
                for (n = 0; n < 6; ++n) {
                    if (pgCubeSet.m_neighbour[n2].m_data[n] <= -1) continue;
                    int n7 = n;
                    this.m_neighbour[n4 + n2].m_data[n7] = this.m_neighbour[n4 + n2].m_data[n7] + n4;
                }
            }
        }
        Color color = this.getGlobalCubeColor();
        Color color2 = pgCubeSet.getGlobalCubeColor();
        boolean bl2 = color.getRGB() != color2.getRGB() || this.hasCubeColors() || pgCubeSet.hasCubeColors();
        boolean bl3 = color.getRGB() == color2.getRGB() && !this.isShowingCubeColors() && !pgCubeSet.isShowingCubeColors();
        boolean bl4 = bl2 && !this.isShowingCubeColors();
        boolean bl5 = bl = bl2 && !pgCubeSet.isShowingCubeColors();
        if (!bl3) {
            this.showCubeColors(true);
        }
        if (bl2) {
            this.assureCubeColors();
            if (bl4) {
                for (n2 = 0; n2 < n4; ++n2) {
                    this.setCubeColor(n2, color);
                }
            }
            if (bl) {
                for (n2 = n4; n2 < n5; ++n2) {
                    this.setCubeColor(n2, color2);
                }
            } else {
                PdColor.copy((Color[])this.m_cubeColor, (int)n4, (Color[])pgCubeSet.m_cubeColor, (int)0, (int)pgCubeSet.m_numCubes);
            }
        }
        if (pgCubeSet.m_cubeTexture != null) {
            this.assureCubeTextures();
            for (n2 = 0; n2 < pgCubeSet.m_numCubes; ++n2) {
                PdVector.copy((PdVector[])this.m_cubeTexture[n4 + n2], (int)0, (PdVector[])pgCubeSet.m_cubeTexture[n2], (int)0, (int)8);
            }
        }
        if (pgCubeSet.m_bndList != null) {
            PgCubeBndElementSet[] pgCubeBndElementSetArray = this.getBoundaries();
            this.m_bndList = new PgCubeBndElementSet[pgCubeBndElementSetArray.length + pgCubeSet.m_bndList.length];
            for (n2 = 0; n2 < pgCubeBndElementSetArray.length; ++n2) {
                this.m_bndList[n2] = pgCubeBndElementSetArray[n2];
            }
            for (n2 = 0; n2 < pgCubeSet.m_bndList.length; ++n2) {
                this.m_bndList[pgCubeBndElementSetArray.length + n2] = pgCubeSet.m_bndList[n2];
            }
            for (n2 = pgCubeBndElementSetArray.length; n2 < this.m_bndList.length; ++n2) {
                int n8 = this.m_bndList[n2].getNumVertices();
                if (this.m_bndList[n2].getVertexInd() != null) {
                    n = 0;
                    while (n < n8) {
                        int n9 = n++;
                        this.m_bndList[n2].getVertexInd().m_data[n9] = this.m_bndList[n2].getVertexInd().m_data[n9] + n3;
                    }
                }
                if (this.m_bndList[n2].getCubeInd() != null) {
                    n = 0;
                    while (n < n8 - 1) {
                        int n10 = n++;
                        this.m_bndList[n2].getCubeInd().m_data[n10] = this.m_bndList[n2].getCubeInd().m_data[n10] + n4;
                    }
                }
                this.m_bndList[n2].setCubeSet(this);
                this.m_bndList[n2].assignVertices();
            }
        }
        return true;
    }

    public int getCubeWithEdge(int n, int n2) {
        for (int i = 0; i < this.m_numCubes; ++i) {
            int[] nArray = this.m_cube[i].m_data;
            for (int j = 0; j < 12; ++j) {
                if ((nArray[LOCAL_EDGE_TO_VERTEX[j][0]] != n || nArray[LOCAL_EDGE_TO_VERTEX[j][1]] != n2) && (nArray[LOCAL_EDGE_TO_VERTEX[j][0]] != n2 || nArray[LOCAL_EDGE_TO_VERTEX[j][1]] != n)) continue;
                return i;
            }
        }
        return -1;
    }

    public void clearTagCube(int n, int n2) {
        if (n < 0 || n > this.m_numCubes - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return;
        }
        this.m_cube[n].clearTag(n2);
    }

    public boolean hasTagCube(int n, int n2) {
        if (n < 0 || n > this.m_numCubes - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        return this.m_cube[n].hasTag(n2);
    }

    public void setTagCube(int n, int n2) {
        if (n < 0 || n > this.m_numCubes - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return;
        }
        this.m_cube[n].setTag(n2);
    }

    public PdVector[] getCubeVertices(int n) {
        if (n < 0 || this.m_numCubes <= n) {
            PsDebug.warning((String)("cubeInd out of bounds, cubeInd = " + n));
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[8];
        for (int i = 0; i < 8; ++i) {
            pdVectorArray[i] = this.m_vertex[this.m_cube[n].m_data[i]];
        }
        return pdVectorArray;
    }

    public PiVector getCube(int n) {
        if (n < 0 || n >= this.m_numCubes) {
            return null;
        }
        return this.m_cube[n];
    }

    public PiVector getNeighbour(int n) {
        if (this.m_neighbour == null || n < 0 || n >= this.m_numCubes) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public Color getCubeColor(int n) {
        if (this.m_cubeColor == null || n < 0 || n >= this.m_numCubes) {
            return null;
        }
        return this.m_cubeColor[n];
    }

    public boolean setCubeVertices(int n, PdVector[] pdVectorArray) {
        PiVector piVector = this.m_cube[n];
        if (8 != pdVectorArray.length) {
            PsDebug.warning((String)"tetra and array have different length");
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            this.setVertex(piVector.m_data[i], pdVectorArray[i]);
        }
        return true;
    }

    public boolean setCube(int n, int[] nArray) {
        if (8 != nArray.length) {
            PsDebug.warning((String)"tetra and array have different length");
            return false;
        }
        if (n >= this.m_numCubes) {
            this.setNumCubes(n + 1);
        }
        this.m_cube[n].copy(nArray, 8);
        return true;
    }

    public boolean setCube(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.warning((String)"index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numCubes) {
            PsDebug.warning((String)("index=" + n + " > " + this.m_numCubes + "=m_numCubes, bad programming style"));
            this.setNumCubes(n + 1);
        }
        this.m_cube[n].copy(piVector);
        return true;
    }

    public boolean setNeighbour(int n, PiVector piVector) {
        if (n < 0 || n >= this.m_numCubes) {
            PsDebug.warning((String)("cube index out of range, ind = " + n));
            return false;
        }
        if (piVector == null || piVector.getSize() != 6) {
            PsDebug.warning((String)("size of given neighbour array is not 6, cubeInd = " + n));
            return false;
        }
        this.m_neighbour[n].copyArray(piVector);
        return true;
    }

    public boolean setCubeColor(int n, Color color) {
        if (n < 0 || n >= this.m_numCubes) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        if (color == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        if (this.m_cubeColor == null || n >= this.m_cubeColor.length) {
            this.assureCubeColors();
        }
        this.m_cubeColor[n] = color;
        return true;
    }

    public boolean setCubeTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n >= this.m_numCubes) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        if (this.m_cubeTexture == null || n >= this.m_cubeTexture.length) {
            this.assureCubeTextures();
        }
        this.m_cubeTexture[n] = PdVector.copyNew((PdVector[])pdVectorArray, (int)pdVectorArray.length);
        return true;
    }

    public void setCubes(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numCubes == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numCubes) {
            PsDebug.warning((String)"void length of cube array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_cube = piVectorArray;
            if (this.m_maxNumCubes != piVectorArray.length) {
                this.setMaxNumCubes(piVectorArray.length);
            }
            return;
        }
        PiVector.copy((PiVector[])this.m_cube, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numCubes);
    }

    public void removeCubeColors() {
        this.setCubeColors(null);
    }

    public void setCubeColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_cubeColor = null;
            return;
        }
        if (colorArray.length < this.m_numCubes) {
            PsDebug.warning((String)"void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_cubeColor = colorArray;
            return;
        }
        this.assureCubeColors();
        PdColor.copy((Color[])this.m_cubeColor, (int)0, (Color[])colorArray, (int)0, (int)this.m_numCubes);
    }

    public void setCubeTextures(PdVector[][] pdVectorArray) {
        int n;
        if (pdVectorArray == null) {
            this.m_cubeTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numCubes) {
            PsDebug.warning((String)"void length of tex array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_cubeTexture = pdVectorArray;
            return;
        }
        for (n = 0; n < this.m_numCubes; ++n) {
            if (pdVectorArray[n] != null && pdVectorArray[n].length == 8) continue;
            PsDebug.warning((String)("void length of texCoords[" + n + "]"));
            return;
        }
        this.assureCubeTextures();
        for (n = 0; n < this.m_numCubes; ++n) {
            PdVector.copy((PdVector[])this.m_cubeTexture[n], (int)0, (PdVector[])pdVectorArray[n], (int)0, (int)8);
        }
    }

    public void setCubeTexturesFromList(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_cubeTexture = null;
            return;
        }
        if (pdVectorArray.length < this.getNumCubeIndices()) {
            PsDebug.warning((String)"void length of argument array");
            return;
        }
        this.assureCubeTextures();
        int n = 0;
        for (int i = 0; i < this.m_numCubes; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.m_cubeTexture[i][j].copy(pdVectorArray[n++]);
            }
        }
    }

    public void removeTexture() {
        this.setCubeTextures(null);
        this.showCubeTexture(false);
        super.removeTexture();
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numCubes) {
            PsDebug.warning((String)"void length of neighbour array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_neighbour = piVectorArray;
            return;
        }
        this.assureNeighbours();
        PiVector.copy((PiVector[])this.m_neighbour, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numCubes);
    }

    public int getNeighbourLocInd(int n, int n2, int n3) {
        PsDebug.warning((String)"Method with elementSet signature called in cubeSet.");
        return -1;
    }

    public int getOppVertexInd(int n, int n2) {
        int n3 = this.getOppVertexLocInd(n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n].m_data[n2];
        if (n4 < 0) {
            return -1;
        }
        return this.m_cube[n4].m_data[n3];
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            return -2;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.m_neighbour[n3].m_data[i] != n) continue;
            return i;
        }
        PsDebug.error((String)("cannot find opp vertex of (" + n2 + ") in cube[" + n + "]"));
        return -1;
    }

    public double getEdgeLength(int n, int n2, int n3) {
        int[] nArray = this.m_cube[n].m_data;
        double d = PdVector.dist((PdVector)this.m_vertex[nArray[n2]], (PdVector)this.m_vertex[nArray[n3]]);
        return d;
    }

    public int getNumBoundaryFaces() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numCubes * 6;
        } else {
            for (int i = 0; i < this.m_numCubes; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.m_neighbour[i].m_data[j] != -1) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numCubes * 12;
        } else {
            PgEdgeStar[] pgEdgeStarArray = this.makeEdgeStars();
            n = pgEdgeStarArray.length;
        }
        return n;
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(14)) continue;
            ++n;
        }
        return n;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgCubeSet) || !(pgGeometry2 instanceof PgCubeSet)) {
            return false;
        }
        PgCubeSet pgCubeSet = (PgCubeSet)pgGeometry;
        PgCubeSet pgCubeSet2 = (PgCubeSet)pgGeometry2;
        if (pgCubeSet.m_numCubes != pgCubeSet2.m_numCubes) {
            PsDebug.warning((String)"unequal number of tetras");
            return false;
        }
        double d4 = Math.abs(d);
        PgCubeSet pgCubeSet3 = d4 > (d3 = Math.abs(d2)) ? pgCubeSet : pgCubeSet2;
        this.m_bShowCubeLabels = pgCubeSet3.m_bShowCubeLabels;
        this.m_bShowBoundaries = pgCubeSet3.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgCubeSet3.m_bShowTaggedBoundaries;
        this.m_bShowCubeTexture = pgCubeSet3.m_bShowCubeTexture;
        this.m_bShowEdges = pgCubeSet3.m_bShowEdges;
        this.m_bShowEdgeColors = pgCubeSet3.m_bShowEdgeColors;
        this.m_bShowCubes = pgCubeSet3.m_bShowCubes;
        this.m_bShowTaggedCubes = pgCubeSet3.m_bShowTaggedCubes;
        this.m_bShowCubeColors = pgCubeSet3.m_bShowCubeColors;
        this.m_globalBndColor.blend(d4, pgCubeSet.m_globalBndColor, d3, pgCubeSet2.m_globalBndColor);
        this.m_globalBndTagColor.blend(d4, pgCubeSet.m_globalBndTagColor, d3, pgCubeSet2.m_globalBndTagColor);
        this.m_globalEdgeColor.blend(d4, pgCubeSet.m_globalEdgeColor, d3, pgCubeSet2.m_globalEdgeColor);
        this.m_globalEdgeSize.blend(d4, pgCubeSet.m_globalEdgeSize, d3, pgCubeSet2.m_globalEdgeSize);
        this.m_globalCubeColor.blend(d4, pgCubeSet.m_globalCubeColor, d3, pgCubeSet2.m_globalCubeColor);
        this.m_globalCubeTagColor.blend(d4, pgCubeSet.m_globalCubeTagColor, d3, pgCubeSet2.m_globalCubeTagColor);
        this.setNumCubes(pgCubeSet3.getNumCubes());
        for (n = 0; n < this.m_numCubes; ++n) {
            this.m_cube[n].copy(pgCubeSet3.m_cube[n]);
        }
        if (pgCubeSet3.m_neighbour != null) {
            for (n = 0; n < this.m_numCubes; ++n) {
                this.m_neighbour[n].copy(pgCubeSet3.m_neighbour[n]);
            }
        }
        if (pgCubeSet.m_cubeColor != null && pgCubeSet2.m_cubeColor != null) {
            this.assureCubeColors();
            for (n = 0; n < this.m_numCubes; ++n) {
                this.m_cubeColor[n] = PdColor.blend((double)d4, (Color)pgCubeSet.m_cubeColor[n], (double)d3, (Color)pgCubeSet2.m_cubeColor[n]);
            }
        } else {
            this.m_cubeColor = null;
        }
        if (pgCubeSet.m_cubeTexture != null && pgCubeSet2.m_cubeTexture != null) {
            this.assureCubeTextures();
            for (n = 0; n < this.m_numCubes; ++n) {
                int n2 = pgCubeSet3.m_cube[n].getSize();
                for (int i = 0; i < n2; ++i) {
                    this.m_cubeTexture[n][i].blend(d4, pgCubeSet.m_cubeTexture[n][i], d3, pgCubeSet2.m_cubeTexture[n][i]);
                }
            }
        } else {
            this.m_cubeTexture = null;
        }
        if (pgCubeSet.hasBoundary() && pgCubeSet2.hasBoundary()) {
            this.assureBoundary(pgCubeSet3.m_bndList.length);
            for (n = 0; n < this.m_bndList.length; ++n) {
                this.m_bndList[n].blend(d, (PgGeometry)pgCubeSet.m_bndList[n], d2, (PgGeometry)pgCubeSet2.m_bndList[n]);
            }
        } else {
            this.m_bndList = null;
        }
        return true;
    }

    public boolean checkNeighbour(boolean bl) {
        if (this.m_neighbour == null) {
            PsDebug.warning((String)"missing neighbour information");
            return false;
        }
        int n = -1;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.m_numCubes; ++i) {
            if (!bl2 && stringBuffer.length() > 50000) {
                stringBuffer.append("---- message exceeded max message size, message truncated -----\n");
                break;
            }
            for (int j = 0; j < 6; ++j) {
                int n2;
                int n3;
                int n4 = this.m_neighbour[i].m_data[j];
                if (n4 == -1) continue;
                if (n4 == i) {
                    bl2 = false;
                    stringBuffer.append("tetrahedron has itself as neighbour\n");
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + " = " + i + " " + PsConfig.getMessage((int)33013) + " = " + this.m_cube[i].m_data[j] + "\n");
                    for (n3 = 0; n3 < 6; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + "[" + i + "][" + n3 + "] = " + this.m_cube[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                if (n4 >= this.m_numCubes) {
                    bl2 = false;
                    stringBuffer.append(PsConfig.getMessage((int)33014) + "\n");
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + " = " + i + " " + PsConfig.getMessage((int)33013) + " = " + this.m_cube[i].m_data[j] + " >= m_numTetras.\n");
                    for (n3 = 0; n3 < 6; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + "[" + i + "][" + n3 + "] = " + this.m_cube[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                n3 = 0;
                for (n2 = 0; n2 < 6; ++n2) {
                    if (this.m_neighbour[n4].m_data[n2] != i) continue;
                    n3 = 1;
                    n = n2;
                    break;
                }
                if (n3 != 0) continue;
                bl2 = false;
                stringBuffer.append(PsConfig.getMessage((int)33015) + "\n");
                stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + " = " + i + " " + PsConfig.getMessage((int)33013) + " = " + this.m_cube[i].m_data[j] + "\n");
                for (n2 = 0; n2 < 6; ++n2) {
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + "[" + i + "][" + n2 + "] = " + this.m_cube[i].m_data[n2] + ", " + PsConfig.getMessage((int)33016) + "[" + i + "][" + n2 + "] = " + this.m_neighbour[i].m_data[n2] + "\n");
                }
                if (n3 == 1) {
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + " = " + n4 + " " + PsConfig.getMessage((int)33013) + " = " + this.m_cube[n4].m_data[n] + "\n");
                } else {
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + " = " + n4 + " " + PsConfig.getMessage((int)33017) + "\n");
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    stringBuffer.append("\t" + PsConfig.getMessage((int)33010) + "[" + n4 + "][" + n2 + "] = " + this.m_cube[n4].m_data[n2] + ", " + PsConfig.getMessage((int)33016) + "[" + n4 + "][" + n2 + "] = " + this.m_neighbour[n4].m_data[n2] + "\n");
                }
            }
        }
        if (bl) {
            if (!bl2) {
                PsDebug.message((String)stringBuffer.toString());
            } else {
                PsDebug.message((String)PsConfig.getMessage((int)33018));
            }
        }
        return bl2;
    }

    public boolean makeCubeColorsFromXYZ() {
        int n;
        if (this.m_numCubes == 0) {
            return true;
        }
        if (((PgGeometry)this).m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureCubeColors();
        Color[] colorArray = this.getCubeColors();
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector2 = new PdVector(((PgGeometry)this).m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (n = 0; n < ((PgGeometry)this).m_dim; ++n) {
            if (!(dArray[n] < 1.0E-10)) continue;
            dArray[n] = 1.0;
        }
        n = Math.min(3, ((PgGeometry)this).m_dim);
        float[] fArray = new float[n];
        for (int i = 0; i < this.m_numCubes; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])this.m_vertex, (int[])this.m_cube[i].m_data), pdVectorArray[0]);
            for (int j = 0; j < n; ++j) {
                fArray[j] = (float)(pdVector.m_data[j] / dArray[j]);
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public boolean makeCubeColorsFromZ() {
        if (this.m_numCubes == 0) {
            return true;
        }
        if (((PgGeometry)this).m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, ((PgGeometry)this).m_dim - 1);
        this.assureCubeColors();
        Color[] colorArray = this.getCubeColors();
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector2 = new PdVector(((PgGeometry)this).m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numCubes; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])this.m_vertex, (int[])this.m_cube[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(f2, 0.0f, 1.0f - f2);
        }
        return true;
    }

    public boolean makeCubeColorsFromZHue() {
        if (this.m_numCubes == 0) {
            return true;
        }
        if (((PgGeometry)this).m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, ((PgGeometry)this).m_dim - 1);
        this.assureCubeColors();
        Color[] colorArray = this.getCubeColors();
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector2 = new PdVector(((PgGeometry)this).m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numCubes; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])this.m_vertex, (int[])this.m_cube[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public boolean makeCubeFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning((String)"missing vertex colors");
            return false;
        }
        if (this.m_numCubes == 0) {
            return true;
        }
        this.assureCubeColors();
        for (int i = 0; i < this.m_numCubes; ++i) {
            int n = this.m_cube[i].getSize();
            if (n == 0) continue;
            if (n == 1) {
                this.setCubeColor(i, this.m_vertexColor[this.m_cube[i].m_data[0]]);
                continue;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n2 = this.m_vertexColor[this.m_cube[i].m_data[j]].getRGB();
                f += (float)(n2 >> 16 & 0xFF);
                f2 += (float)(n2 >> 8 & 0xFF);
                f3 += (float)(n2 & 0xFF);
            }
            this.setCubeColor(i, new Color((int)(f /= (float)n), (int)(f2 /= (float)n), (int)(f3 /= (float)n)));
        }
        return true;
    }

    public boolean makeVertexFromCubeColors() {
        int n;
        if (!this.hasCubeColors()) {
            PsDebug.warning((String)"missing cube colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numCubes == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        for (n = 0; n < this.m_numCubes; ++n) {
            int n2 = this.m_cube[n].getSize();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.m_cube[n].m_data[i];
                int n4 = this.m_cubeColor[n].getRGB();
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + (n4 >> 16 & 0xFF);
                int[] nArray4 = nArray[n3];
                nArray4[1] = nArray4[1] + (n4 >> 8 & 0xFF);
                int[] nArray5 = nArray[n3];
                nArray5[2] = nArray5[2] + (n4 & 0xFF);
                int n5 = n3;
                nArray2[n5] = nArray2[n5] + 1;
            }
        }
        this.assureVertexColors();
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
                continue;
            }
            this.setVertexColor(n, Color.black);
        }
        return true;
    }

    public boolean makeCubeFromVertexTexture() {
        if (!this.hasVertexTextures()) {
            PsDebug.warning((String)"missing vertexTextures.");
            return false;
        }
        PdVector[] pdVectorArray = this.getVertexTextures();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning((String)"missing vertexTextures.");
            return false;
        }
        this.assureCubeTextures();
        for (int i = 0; i < this.m_numCubes; ++i) {
            int n = this.m_cube[i].getSize();
            for (int j = 0; j < n; ++j) {
                this.m_cubeTexture[i][j] = PdVector.copyNew((PdVector)this.m_vertexTexture[this.m_cube[i].m_data[j]]);
            }
        }
        this.showCubeTexture(true);
        this.showVertexTexture(false);
        this.setVertexTextures(null);
        return true;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        PiVector piVector;
        PiVector[] piVectorArray;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning((String)("missing or wrong transformation matrix mat = " + pdMatrix));
            return null;
        }
        PgCubeSet pgCubeSet = (PgCubeSet)super.reflect(pdMatrix, bl, bl2);
        if (!bl) {
            piVectorArray = pgCubeSet.getCubes();
            for (int i = 0; i < this.m_numCubes; ++i) {
                piVectorArray[i].invert();
            }
            piVector = pgCubeSet.getNeighbours();
            if (piVector != null) {
                for (n3 = 0; n3 < this.m_numCubes; ++n3) {
                    piVector[n3].invert();
                    n2 = piVector[n3].getSize();
                    for (n = 3; n < n2; ++n) {
                        piVector[n3].shift(1);
                    }
                }
            }
        }
        if (!bl && this.hasCubeTextures()) {
            piVectorArray = pgCubeSet.getCubeTextures();
            for (n3 = 0; n3 < this.m_numCubes; ++n3) {
                n2 = ((PiVector)piVectorArray[n3]).length;
                n = n2 / 2;
                for (int i = 0; i < n; ++i) {
                    piVector = piVectorArray[n3][i];
                    piVectorArray[n3][i] = piVectorArray[n3][n2 - 1 - i];
                    piVectorArray[n3][n2 - 1 - i] = piVector;
                }
            }
        }
        return pgCubeSet;
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning((String)"missing vertex normals");
            return false;
        }
        for (int i = 0; i < this.m_numCubes; ++i) {
            int n = this.m_cube[i].getSize();
            for (int j = 0; j < n; ++j) {
                if (this.m_neighbour[i].m_data[j] != -1) continue;
                this.m_vertexNormal[this.m_cube[i].m_data[(j + 1) % n]].setConstant(0.0);
                this.m_vertexNormal[this.m_cube[i].m_data[(j + 2) % n]].setConstant(0.0);
                this.m_vertexNormal[this.m_cube[i].m_data[(j + 3) % n]].setConstant(0.0);
            }
        }
        return true;
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int[] nArray2 = PuData.realloc((int[])nArray, (int)(nArray.length + 3));
        nArray2[nArray.length] = this.getNumEdges();
        nArray2[nArray.length + 1] = this.getNumFaces();
        nArray2[nArray.length + 2] = this.getNumCubes();
        return nArray2;
    }

    public boolean checkNeighbour() {
        if (this.m_neighbour == null) {
            PsDebug.warning((String)"Missing neighbour information.");
            return false;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.m_numCubes; ++i) {
            for (int j = 0; j < 6; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = this.m_neighbour[i].m_data[j];
                if (n5 == -1) continue;
                if (n5 == i) {
                    bl = false;
                    stringBuffer.append("\n\tCube has itself as neighbour\n");
                    stringBuffer.append("\t\tCube " + i + " (" + this.m_cube[i].m_data[0] + ", " + this.m_cube[i].m_data[1] + ", " + this.m_cube[i].m_data[2] + ", " + this.m_cube[i].m_data[3] + ", " + this.m_cube[i].m_data[4] + ", " + this.m_cube[i].m_data[5] + ", " + this.m_cube[i].m_data[6] + ", " + this.m_cube[i].m_data[7] + ") with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", , " + this.m_neighbour[i].m_data[3] + ", " + this.m_neighbour[i].m_data[4] + ", " + this.m_neighbour[i].m_data[5] + ".\n");
                    continue;
                }
                int n6 = -1;
                for (int k = 0; k < 6 && n6 == -1; ++k) {
                    if (this.m_neighbour[n5].m_data[k] != i) continue;
                    n6 = k;
                    break;
                }
                if (n6 == -1) {
                    bl = false;
                    stringBuffer.append("\n\tTwo adjacent cubes do not reference each other.\n\t\tCube " + i + " (" + this.m_cube[i].m_data[0] + ", " + this.m_cube[i].m_data[1] + ", " + this.m_cube[i].m_data[2] + ", " + this.m_cube[i].m_data[3] + ", " + this.m_cube[i].m_data[4] + ", " + this.m_cube[i].m_data[5] + ", " + this.m_cube[i].m_data[6] + ", " + this.m_cube[i].m_data[7] + ") with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", , " + this.m_neighbour[i].m_data[3] + ", " + this.m_neighbour[i].m_data[4] + ", " + this.m_neighbour[i].m_data[5] + " at face opposite to vertex " + this.m_cube[i].m_data[j] + ".\n\t\tCube " + n5 + " (" + this.m_cube[n5].m_data[0] + ", " + this.m_cube[n5].m_data[1] + ", " + this.m_cube[n5].m_data[2] + ", " + this.m_cube[n5].m_data[3] + ", " + this.m_cube[n5].m_data[4] + ", " + this.m_cube[n5].m_data[5] + ", " + this.m_cube[n5].m_data[6] + ", " + this.m_cube[n5].m_data[7] + ") with neighbours " + this.m_neighbour[n5].m_data[0] + ", " + this.m_neighbour[n5].m_data[1] + ", " + this.m_neighbour[n5].m_data[2] + ", " + this.m_neighbour[n5].m_data[3] + ", " + this.m_neighbour[n5].m_data[4] + ", " + this.m_neighbour[n5].m_data[5] + " does not reference back.\n");
                    continue;
                }
                int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
                block3: for (n4 = 0; n4 < 8; ++n4) {
                    n3 = this.m_cube[i].m_data[n4];
                    for (n2 = 0; n2 < 8; ++n2) {
                        if (nArray[n2] == -1) {
                            nArray[n2] = n3;
                            continue block3;
                        }
                        if (n3 >= nArray[n2]) continue;
                        for (n = 7; n > n2; --n) {
                            nArray[n] = nArray[n - 1];
                        }
                        nArray[n2] = n3;
                        continue block3;
                    }
                }
                if (nArray[7] == -1) {
                    bl = false;
                    stringBuffer.append("\n\tCube with double vertex found.\n\t\tCube " + i + " (" + this.m_cube[i].m_data[0] + ", " + this.m_cube[i].m_data[1] + ", " + this.m_cube[i].m_data[2] + ", " + this.m_cube[i].m_data[3] + ", " + this.m_cube[i].m_data[4] + ", " + this.m_cube[i].m_data[5] + ", " + this.m_cube[i].m_data[6] + ", " + this.m_cube[i].m_data[7] + ").\n");
                    continue;
                }
                n4 = 0;
                block6: for (n3 = 0; n3 < 8; ++n3) {
                    n2 = this.m_cube[n5].m_data[n3];
                    for (n = 0; n < 8; ++n) {
                        if (n2 != nArray[n]) continue;
                        ++n4;
                        nArray[n] = -1;
                        continue block6;
                    }
                }
                if (n4 == 8) {
                    bl = false;
                    stringBuffer.append("\n\tTwo identical cubes found.\n\t\tCube " + i + " (" + this.m_cube[i].m_data[0] + ", " + this.m_cube[i].m_data[1] + ", " + this.m_cube[i].m_data[2] + ", " + this.m_cube[i].m_data[3] + ", " + this.m_cube[i].m_data[4] + ", " + this.m_cube[i].m_data[5] + ", " + this.m_cube[i].m_data[6] + ", " + this.m_cube[i].m_data[7] + ").\n\t\tCube " + n5 + " (" + this.m_cube[n5].m_data[0] + ", " + this.m_cube[n5].m_data[1] + ", " + this.m_cube[n5].m_data[2] + ", " + this.m_cube[n5].m_data[3] + ", " + this.m_cube[n5].m_data[4] + ", " + this.m_cube[n5].m_data[5] + ", " + this.m_cube[n5].m_data[6] + ", " + this.m_cube[n5].m_data[7] + ").\n");
                    continue;
                }
                if (n4 >= 4) continue;
                bl = false;
                stringBuffer.append("\n\tTwo adjacent cubes reference each other but have no common face.\n\t\tCube " + i + " (" + this.m_cube[i].m_data[0] + ", " + this.m_cube[i].m_data[1] + ", " + this.m_cube[i].m_data[2] + ", " + this.m_cube[i].m_data[3] + ", " + this.m_cube[i].m_data[4] + ", " + this.m_cube[i].m_data[5] + ", " + this.m_cube[i].m_data[6] + ", " + this.m_cube[i].m_data[7] + ")  with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", " + this.m_neighbour[i].m_data[3] + ", " + this.m_neighbour[i].m_data[4] + ", " + this.m_neighbour[i].m_data[5] + ".\n\t\tCube " + n5 + " (" + this.m_cube[n5].m_data[0] + ", " + this.m_cube[n5].m_data[1] + ", " + this.m_cube[n5].m_data[2] + ", " + this.m_cube[n5].m_data[3] + ", " + this.m_cube[n5].m_data[4] + ", " + this.m_cube[n5].m_data[5] + ", " + this.m_cube[n5].m_data[6] + ", " + this.m_cube[n5].m_data[7] + ")  with neighbours " + this.m_neighbour[n5].m_data[0] + ", " + this.m_neighbour[n5].m_data[1] + ", " + this.m_neighbour[n5].m_data[2] + ", " + this.m_neighbour[n5].m_data[3] + ", " + this.m_neighbour[n5].m_data[4] + ", " + this.m_neighbour[n5].m_data[5] + ".\n");
            }
        }
        if (!bl) {
            PsDebug.warning((String)stringBuffer.toString());
        }
        return bl;
    }

    public void computeBox(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6) {
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)8, (int)((PgGeometry)this).m_dim);
        pdVectorArray[0].set(d, d2, d3);
        pdVectorArray[1].set(d, d2, d6);
        pdVectorArray[2].set(d, d5, d3);
        pdVectorArray[3].set(d, d5, d6);
        pdVectorArray[4].set(d4, d2, d3);
        pdVectorArray[5].set(d4, d2, d6);
        pdVectorArray[6].set(d4, d5, d3);
        pdVectorArray[7].set(d4, d5, d6);
        this.buildCube(pdVectorArray, n, n2, n3);
    }

    public PgElementSet getSurface(PgElementSet pgElementSet) {
        PgElementSet pgElementSet2 = pgElementSet == null ? new PgElementSet(((PgGeometry)this).m_dim) : pgElementSet;
        pgElementSet2.copy((PsObject)this);
        pgElementSet2.setNumElements(this.m_numFaces);
        this.computeFaces();
        pgElementSet2.setElements(this.m_face);
        pgElementSet2.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgElementSet2.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgElementSet2.setGlobalElementColor(this.getGlobalCubeColor());
        pgElementSet2.makeElementNormals();
        return pgElementSet2;
    }

    public PgEdgeStar[] makeEdgeStars() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_numCubes < 1) {
            return null;
        }
        int n5 = 0;
        for (int i = 0; i < this.m_numCubes; ++i) {
            int n6 = this.m_cube[i].getSize();
            for (int j = 0; j < n6; ++j) {
                if (this.m_cube[i].m_data[j] < n5) continue;
                n5 = this.m_cube[i].m_data[j] + 1;
            }
        }
        Vector[] vectorArray = new Vector[n5];
        PgEdgeStar pgEdgeStar = null;
        int[] nArray = new int[2];
        int n7 = 12;
        int n8 = 0;
        for (int i = 0; i < this.m_numCubes; ++i) {
            for (n4 = 0; n4 < n7; ++n4) {
                nArray[0] = this.m_cube[i].m_data[LOCAL_EDGE_TO_VERTEX[n4][0]];
                nArray[1] = this.m_cube[i].m_data[LOCAL_EDGE_TO_VERTEX[n4][1]];
                if (nArray[0] > nArray[1]) {
                    n3 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n3;
                }
                n3 = 0;
                if (vectorArray[nArray[0]] == null) {
                    vectorArray[nArray[0]] = new Vector();
                } else {
                    n2 = vectorArray[nArray[0]].size();
                    for (n = 0; n < n2; ++n) {
                        pgEdgeStar = (PgEdgeStar)vectorArray[nArray[0]].elementAt(n);
                        if (pgEdgeStar.getVertexInd(1) != nArray[1]) continue;
                        n3 = 1;
                        pgEdgeStar.addElement(i, n4);
                        break;
                    }
                }
                if (n3 != 0) continue;
                ++n8;
                pgEdgeStar = new PgEdgeStar(nArray[0], nArray[1]);
                pgEdgeStar.setMaxValence(10);
                pgEdgeStar.addElement(i, n4);
                vectorArray[nArray[0]].addElement(pgEdgeStar);
            }
        }
        PgEdgeStar[] pgEdgeStarArray = new PgEdgeStar[n8];
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (vectorArray[n3] == null) continue;
            n2 = vectorArray[n3].size();
            for (n = 0; n < n2; ++n) {
                pgEdgeStarArray[n4] = (PgEdgeStar)vectorArray[n3].elementAt(n);
                ++n4;
            }
        }
        if (n4 != n8) {
            PsDebug.warning((String)"numEdgeStars is wrong, edge list is void");
            PsDebug.warning((String)("\t numEdgeStars = " + n8 + ", countEdges = " + n4));
        }
        return pgEdgeStarArray;
    }

    private PgFaceStar[] makeFaceStars() {
        int n;
        int n2;
        int n3;
        if (this.m_numCubes < 1) {
            return null;
        }
        PgFaceStar pgFaceStar = null;
        PiVector piVector = new PiVector(4);
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                if (this.m_cube[n3].m_data[n2] < n5) continue;
                n5 = this.m_cube[n3].m_data[n2] + 1;
            }
        }
        Vector[] vectorArray = new Vector[n5];
        for (n3 = 0; n3 < this.m_numCubes; ++n3) {
            for (n2 = 0; n2 < 6; ++n2) {
                piVector.set(this.m_cube[n3].m_data[LOCAL_FACE_TO_VERTEX[n2][0]], this.m_cube[n3].m_data[LOCAL_FACE_TO_VERTEX[n2][1]], this.m_cube[n3].m_data[LOCAL_FACE_TO_VERTEX[n2][2]], this.m_cube[n3].m_data[LOCAL_FACE_TO_VERTEX[n2][3]]);
                piVector.sort();
                boolean bl = false;
                if (vectorArray[piVector.m_data[0]] == null) {
                    vectorArray[piVector.m_data[0]] = new Vector();
                } else {
                    int n6 = vectorArray[piVector.m_data[0]].size();
                    for (n = 0; n < n6; ++n) {
                        pgFaceStar = (PgFaceStar)vectorArray[piVector.m_data[0]].elementAt(n);
                        if (pgFaceStar.getVertexInd(1) != piVector.m_data[1] || pgFaceStar.getVertexInd(2) != piVector.m_data[2] || pgFaceStar.getVertexInd(3) != piVector.m_data[3]) continue;
                        bl = true;
                        pgFaceStar.addElement(n3, n2);
                        break;
                    }
                }
                if (bl) continue;
                ++n4;
                pgFaceStar = new PgFaceStar(piVector.m_data[0], piVector.m_data[1], piVector.m_data[2], piVector.m_data[3]);
                pgFaceStar.addElement(n3, n2);
                vectorArray[piVector.m_data[0]].addElement(pgFaceStar);
            }
        }
        PgFaceStar[] pgFaceStarArray = new PgFaceStar[n4];
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (vectorArray[n3] == null) continue;
            int n8 = vectorArray[n3].size();
            for (n = 0; n < n8; ++n) {
                if (pgFaceStarArray[n7] != null) {
                    pgFaceStarArray[n7].copy((PiVector)((PgFaceStar)vectorArray[n3].elementAt(n)));
                } else {
                    pgFaceStarArray[n7] = (PgFaceStar)vectorArray[n3].elementAt(n);
                }
                ++n7;
            }
        }
        if (n7 != n4) {
            PsDebug.warning((String)"numFaceStars is wrong, face list is void");
            PsDebug.warning((String)("\t numFaceStars = " + n4 + ", countEdges = " + n7));
        }
        return pgFaceStarArray;
    }

    private void computeFaces() {
        int n = this.computeNumFaces();
        this.setNumFaces(n);
        int n2 = 0;
        for (int i = 0; i < this.m_numCubes; ++i) {
            int[] nArray = this.m_cube[i].m_data;
            for (int j = 0; j < 6; ++j) {
                if (this.m_neighbour != null && this.m_neighbour[i].getEntry(j) > i) continue;
                if (n2 == n) {
                    PsDebug.warning((String)"found too many faces");
                    continue;
                }
                this.m_face[n2++].set(nArray[LOCAL_FACE_TO_VERTEX[j][0]], nArray[LOCAL_FACE_TO_VERTEX[j][1]], nArray[LOCAL_FACE_TO_VERTEX[j][2]], nArray[LOCAL_FACE_TO_VERTEX[j][3]]);
            }
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numCubes < 1) {
            return true;
        }
        this.assureNeighbours();
        PgFaceStar[] pgFaceStarArray = this.makeFaceStars();
        if (pgFaceStarArray == null) {
            PsDebug.notify((String)"missing face list");
            return false;
        }
        int n = 0;
        for (int i = 0; i < pgFaceStarArray.length; ++i) {
            PiVector piVector = pgFaceStarArray[i].getElementInd();
            if (piVector == null) continue;
            int n2 = pgFaceStarArray[i].getValence();
            if (n2 > n) {
                n = n2;
            }
            if (n2 == 1) {
                this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].getNeighbourLocInd((int)0)] = -1;
                continue;
            }
            if (n2 == 2) {
                this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].getNeighbourLocInd((int)0)] = piVector.m_data[1];
                this.m_neighbour[piVector.m_data[1]].m_data[pgFaceStarArray[i].getNeighbourLocInd((int)1)] = piVector.m_data[0];
                continue;
            }
            this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].getNeighbourLocInd((int)0)] = piVector.m_data[1];
            this.m_neighbour[piVector.m_data[1]].m_data[pgFaceStarArray[i].getNeighbourLocInd((int)1)] = piVector.m_data[0];
        }
        if (n > 2) {
            PsDebug.warning((String)("Valence of tetra face is too high, valence = " + n));
        }
        return true;
    }

    public void markBoundary() {
        int n;
        for (n = 0; n < this.m_numVertices; ++n) {
            this.m_vertex[n].clearTag(14);
        }
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_cube.length) {
            PsDebug.warning((String)"void neighbour connectivity");
            return;
        }
        for (n = 0; n < this.m_numCubes; ++n) {
            for (int i = 0; i < 6; ++i) {
                if (this.m_neighbour[n].m_data[i] >= 0) continue;
                this.m_vertex[LOCAL_FACE_TO_VERTEX[i][0]].setTag(14);
                this.m_vertex[LOCAL_FACE_TO_VERTEX[i][1]].setTag(14);
                this.m_vertex[LOCAL_FACE_TO_VERTEX[i][2]].setTag(14);
                this.m_vertex[LOCAL_FACE_TO_VERTEX[i][3]].setTag(14);
            }
        }
    }

    public int getEdgeVertex0(int n, int n2) {
        return this.m_cube[n].m_data[LOCAL_EDGE_TO_VERTEX[n2][0]];
    }

    public int getEdgeVertex1(int n, int n2) {
        return this.m_cube[n].m_data[LOCAL_EDGE_TO_VERTEX[n2][1]];
    }

    public int addElement(PiVector piVector) {
        if (piVector.getSize() == 8) {
            this.addCube(piVector);
        }
        return this.m_numCubes - 1;
    }

    public PdVector getCenterOfCube(int n) {
        PdVector pdVector = new PdVector(3);
        PiVector piVector = this.getCube(n);
        for (int i = 0; i < 8; ++i) {
            pdVector.add(this.m_vertex[piVector.m_data[i]]);
        }
        pdVector.multScalar(0.125);
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

