/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.volume.PgCubeSet;

public class PgCubeBndElementSet
extends PgElementSet {
    protected PgCubeSet m_geom;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_cubeInd = new PiVector();
    protected PiVector m_neighbourLocInd = new PiVector();
    protected PgBndConstraint m_bndConstraint;
    static /* synthetic */ Class class$jvx$volume$PgCubeBndElementSet;

    public PgCubeBndElementSet(int n) {
        super(n);
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PgCubeBndElementSet == null ? (class$jvx$volume$PgCubeBndElementSet = PgCubeBndElementSet.class$("jvx.volume.PgCubeBndElementSet")) : class$jvx$volume$PgCubeBndElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.clearTag(2);
        this.m_bndConstraint = null;
    }

    public Object clone() {
        PgCubeBndElementSet pgCubeBndElementSet = (PgCubeBndElementSet)((Object)super.clone());
        if (pgCubeBndElementSet == null) {
            return null;
        }
        pgCubeBndElementSet.m_geom = null;
        if (this.m_vertexInd != null) {
            pgCubeBndElementSet.m_vertexInd = (PiVector)this.m_vertexInd.clone();
        }
        if (this.m_cubeInd != null) {
            pgCubeBndElementSet.m_cubeInd = (PiVector)this.m_cubeInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgCubeBndElementSet.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        if (this.m_bndConstraint != null) {
            pgCubeBndElementSet.m_bndConstraint = (PgBndConstraint)this.m_bndConstraint.clone();
        }
        return pgCubeBndElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgCubeBndElementSet)) {
            return;
        }
        PgCubeBndElementSet pgCubeBndElementSet = (PgCubeBndElementSet)psObject;
        this.m_vertexInd.copy(0, pgCubeBndElementSet.getVertexInd(), 0, ((PgPointSet)this).m_numVertices);
        this.m_cubeInd.copy(0, pgCubeBndElementSet.getCubeInd(), 0, this.m_numElements);
        this.m_cubeInd.copy(0, pgCubeBndElementSet.getCubeInd(), 0, this.m_numElements);
        PgBndConstraint pgBndConstraint = pgCubeBndElementSet.getBndConstraint();
        if (pgBndConstraint != null) {
            if (this.m_bndConstraint == null) {
                this.m_bndConstraint = new PgBndConstraint(pgBndConstraint.getDim());
            }
            this.m_bndConstraint.copy((PsObject)pgBndConstraint);
        } else {
            this.m_bndConstraint = null;
        }
        this.assignVertices();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgBndElementSet *********\n");
        stringBuffer.append("\t ******* m_vertexInd *******\n");
        if (this.m_vertexInd == null) {
            stringBuffer.append("\t m_vertexInd = null\n");
        } else {
            stringBuffer.append("\t m_vertexInd" + this.m_vertexInd.toShortString());
        }
        stringBuffer.append("\t ******* m_tetraInd *******\n");
        if (this.m_cubeInd == null) {
            stringBuffer.append("\t m_tetraInd = null\n");
        } else {
            stringBuffer.append("\t m_tetraInd = " + this.m_cubeInd.toShortString());
        }
        stringBuffer.append("\t ******* m_neighbourLocInd *******\n");
        if (this.m_neighbourLocInd == null) {
            stringBuffer.append("\t m_neighbourLocInd = null\n");
        } else {
            stringBuffer.append("\t m_neighbourLocInd = " + this.m_neighbourLocInd.toShortString());
        }
        stringBuffer.append("\t ******* m_bndConstraint *******\n");
        if (this.m_bndConstraint == null) {
            stringBuffer.append("\t m_bndConstraint = null\n");
        } else {
            stringBuffer.append("\t " + this.m_bndConstraint.toString());
        }
        return stringBuffer.toString();
    }

    public boolean applyModelingMatrix() {
        if (this.m_bndConstraint == null) {
            return true;
        }
        if (!this.hasModelMatrix()) {
            return false;
        }
        return this.m_bndConstraint.applyModelingMatrix(((PgGeometry)this).m_modelMatrix);
    }

    public PgCubeSet getCubeSet() {
        return this.m_geom;
    }

    public PiVector getVertexInd() {
        return this.m_vertexInd;
    }

    public void setVertexInd(PiVector piVector) {
        this.m_vertexInd = piVector;
    }

    public PiVector getCubeInd() {
        return this.m_cubeInd;
    }

    public void setCubeInd(PiVector piVector) {
        this.m_cubeInd = piVector;
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public PgBndConstraint getBndConstraint() {
        return this.m_bndConstraint;
    }

    public void setBndConstraint(PgBndConstraint pgBndConstraint) {
        this.m_bndConstraint = pgBndConstraint;
    }

    public void setCubeSet(PgCubeSet pgCubeSet) {
        this.m_geom = pgCubeSet;
    }

    public void setMaxNumVertices(int n) {
        if (((PgPointSet)this).m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexInd.setSize(n);
    }

    public void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        super.setMaxNumElements(n);
        if (n > 0) {
            this.m_cubeInd.setSize(n - 1);
            this.m_neighbourLocInd.setSize(n - 1);
        }
    }

    public boolean assignVertices() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing tetra set");
            return false;
        }
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            if (this.m_vertexInd.m_data[i] == -1 || this.m_vertexInd.m_data[i] >= n) {
                this.setTag(2);
                return false;
            }
            ((PgPointSet)this).m_vertex[i].copy(this.m_geom.getVertex(this.m_vertexInd.m_data[i]));
        }
        return true;
    }

    public boolean makeCubeInd() {
        PsDebug.message((String)"dev.volume.PgBndElementSet.makeTetraInd() called - method is not yet implemented.");
        return true;
    }

    public boolean merge(PgCubeBndElementSet pgCubeBndElementSet) {
        if (pgCubeBndElementSet == null) {
            PsDebug.warning((String)"missing argument", (Object)((Object)this));
            return false;
        }
        if (this.m_geom != pgCubeBndElementSet.m_geom) {
            PsDebug.warning((String)"bnd's associated to different tetraSets", (Object)((Object)this));
            return false;
        }
        if (this.m_numElements < 1 || pgCubeBndElementSet.m_numElements < 1) {
            PsDebug.warning((String)"bnd has no elements", (Object)((Object)this));
            return false;
        }
        int n = ((PgPointSet)this).m_numVertices;
        int n2 = this.m_numElements;
        super.merge((PgGeometryIf)pgCubeBndElementSet);
        this.m_vertexInd.copy(n, pgCubeBndElementSet.m_vertexInd, 0, ((PgPointSet)pgCubeBndElementSet).m_numVertices);
        this.m_cubeInd.copy(n2, pgCubeBndElementSet.m_cubeInd, 0, pgCubeBndElementSet.m_numElements);
        this.m_neighbourLocInd.copy(n2, pgCubeBndElementSet.m_neighbourLocInd, 0, pgCubeBndElementSet.m_numElements);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgElementSet)) {
            return false;
        }
        PgCubeBndElementSet pgCubeBndElementSet = (PgCubeBndElementSet)pgGeometry;
        PgCubeBndElementSet pgCubeBndElementSet2 = (PgCubeBndElementSet)pgGeometry2;
        double d4 = Math.abs(d);
        PgCubeBndElementSet pgCubeBndElementSet3 = d4 > (d3 = Math.abs(d2)) ? pgCubeBndElementSet : pgCubeBndElementSet2;
        this.m_vertexInd.copy(pgCubeBndElementSet3.m_vertexInd);
        this.m_cubeInd.copy(pgCubeBndElementSet3.m_cubeInd);
        this.m_neighbourLocInd.copy(pgCubeBndElementSet3.m_neighbourLocInd);
        if (pgCubeBndElementSet.m_bndConstraint == null || pgCubeBndElementSet2.m_bndConstraint != null) {
            // empty if block
        }
        return true;
    }

    public boolean constrain() {
        if (this.m_bndConstraint == null) {
            PsDebug.notify((String)"boundary has no constraint");
            return true;
        }
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing tetra set.");
            return true;
        }
        PdVector pdVector = this.m_bndConstraint.m_start;
        PdVector pdVector2 = this.m_bndConstraint.m_dir;
        PdVector pdVector3 = this.m_bndConstraint.m_vec1;
        PdVector pdVector4 = this.m_bndConstraint.m_vec2;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_bndConstraint.hasShape(4)) {
            for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
                PuVectorGeom.projectPointToLine((PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVector, (PdVector)pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(5)) {
            for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
                PuVectorGeom.projectPointToPlane((PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVector, (PdVector)pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(11)) {
            double d = pdVector3.dist(pdVector);
            for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
                PuVectorGeom.projectPointToCircle((PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVectorArray[this.m_vertexInd.m_data[i]], (PdVector)pdVector3, (PdVector)pdVector4, (double)d);
            }
        } else {
            PsDebug.warning((String)"not implemented for this shape");
            return false;
        }
        this.assignVertices();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

