/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnEnergy;

public class PnVolumeEnergy
extends PnEnergy {
    protected int m_noe;
    protected PdVector m_origin;
    protected PdVector m_normal;
    protected PdVector[] m_v;
    static /* synthetic */ Class class$jvx$numeric$PnVolumeEnergy;

    public PnVolumeEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnVolumeEnergy == null ? (class$jvx$numeric$PnVolumeEnergy = PnVolumeEnergy.class$("jvx.numeric.PnVolumeEnergy")) : class$jvx$numeric$PnVolumeEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_v = null;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
        this.m_noe = this.m_surface.getNumElements();
        this.m_normal = new PdVector(this.m_dim);
        this.m_origin = new PdVector(this.m_dim);
        this.m_origin.setConstant(0.0);
        return true;
    }

    public double eval(PdVector pdVector) {
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.m_noe; ++i) {
            for (int j = 0; j < 3; ++j) {
                n = this.m_dim * piVectorArray[i].getEntry(j);
                for (int k = 0; k < this.m_dim; ++k) {
                    this.m_v[j].m_data[k] = pdVector.m_data[n++];
                }
            }
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d2 = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d3 = PdVector.area((PdVector[])this.m_v);
            d += d3 * d2 / 3.0;
        }
        return d * d;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        double d;
        int n;
        int n2;
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n3 = 0;
        double d2 = 0.0;
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            for (int i = 0; i < 3; ++i) {
                n3 = this.m_dim * piVectorArray[n2].getEntry(i);
                for (n = 0; n < this.m_dim; ++n) {
                    this.m_v[i].m_data[n] = pdVector.m_data[n3++];
                }
            }
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            d = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d3 = PdVector.area((PdVector[])this.m_v);
            d2 += d3 * d / 3.0;
        }
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            for (int i = 0; i < 3; ++i) {
                n3 = this.m_dim * piVectorArray[n2].getEntry(i);
                for (n = 0; n < this.m_dim; ++n) {
                    this.m_v[i].m_data[n] = pdVector.m_data[n3++];
                }
            }
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            d = d2 * PdVector.area((PdVector[])this.m_v) / 3.0;
            for (int i = 0; i < 3; ++i) {
                n3 = this.m_dim * piVectorArray[n2].getEntry(i);
                for (int j = 0; j < this.m_dim; ++j) {
                    int n4 = n3++;
                    pdVector2.m_data[n4] = pdVector2.m_data[n4] + d * this.m_normal.m_data[j];
                }
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

