/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.function.PuFunction;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PnRootFinder {
    public static double[] findZero(PuFunction puFunction, double[] dArray, double[] dArray2) {
        return PnRootFinder.findValue(puFunction, dArray, dArray2, 0.0);
    }

    /*
     * Unable to fully structure code
     */
    public static double[] findValue(PuFunction var0, double[] var1_1, double[] var2_2, double var3_3) {
        var5_4 = var1_1.length;
        if (var5_4 == 0) {
            PsDebug.warning((String)"vertex dimension is zero, returning first vertex");
            return var1_1;
        }
        if (var2_2.length != var5_4) {
            PsDebug.warning((String)"vertices have different dimension, returning first vertex");
            return var1_1;
        }
        var6_5 = new double[1];
        var0.eval(var6_5, var1_1);
        var7_6 = var6_5[0] - var3_3;
        if (Math.abs(var7_6) < 1.0E-10) {
            return (double[])var1_1.clone();
        }
        var0.eval(var6_5, var2_2);
        var9_7 = var6_5[0] - var3_3;
        if (Math.abs(var9_7) < 1.0E-10) {
            return (double[])var2_2.clone();
        }
        if (var7_6 * var9_7 > 0.0) {
            PsDebug.warning((String)"differences between the points function values and the\n\tgiven value have same sign, returning first vertex");
            return var1_1;
        }
        var11_8 = (double[])var1_1.clone();
        var12_9 = (double[])var2_2.clone();
        var13_10 = new double[var5_4];
        while (true) lbl-1000:
        // 4 sources

        {
            for (var16_12 = 0; var16_12 < var5_4; ++var16_12) {
                var13_10[var16_12] = (var11_8[var16_12] + var12_9[var16_12]) / 2.0;
            }
            var0.eval(var6_5, var13_10);
            var14_11 = var6_5[0] - var3_3;
            if (Math.abs(var14_11) < 1.0E-10) {
                return var13_10;
            }
            if (var14_11 * var7_6 < 0.0) {
                for (var16_12 = 0; var16_12 < var5_4; ++var16_12) {
                    var12_9[var16_12] = var13_10[var16_12];
                }
                var9_7 = var14_11;
                ** continue;
            }
            for (var16_12 = 0; var16_12 < var5_4; ++var16_12) {
                var11_8[var16_12] = var13_10[var16_12];
            }
            var7_6 = var14_11;
        }
    }

    public static PdVector findRoots(PuFunction puFunction, double d, double d2, int n) {
        double d3 = 1.0E-12;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = PnRootFinder.zbrak(puFunction, d, d2, n, dArray, dArray2, n);
        PdVector pdVector = new PdVector(n2);
        for (int i = 0; i < n2; ++i) {
            double d4 = PnRootFinder.zbrent(puFunction, dArray[i], dArray2[i], d3);
            pdVector.setEntry(i, d4);
        }
        return pdVector;
    }

    public static double[] zbrac(PuFunction puFunction, double d, double d2) {
        double d3 = 1.6;
        int n = 50;
        double[] dArray = new double[]{d, d2};
        if (d == d2) {
            PsDebug.warning((String)"bad initial interval.");
            return null;
        }
        double d4 = puFunction.eval(d);
        double d5 = puFunction.eval(d2);
        for (int i = 0; i < n; ++i) {
            if (d4 * d5 < 0.0) {
                return dArray;
            }
            if (Math.abs(d4) < Math.abs(d5)) {
                dArray[0] = dArray[0] + d3 * (d - d2);
                d4 = puFunction.eval(dArray[0]);
                continue;
            }
            dArray[1] = dArray[1] + d3 * (d2 - d);
            d5 = puFunction.eval(dArray[1]);
        }
        return null;
    }

    public static int zbrak(PuFunction puFunction, double d, double d2, int n, double[] dArray, double[] dArray2, int n2) {
        int n3 = n2;
        n2 = 0;
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        double d5 = puFunction.eval(d4);
        for (int i = 0; i < n; ++i) {
            double d6 = puFunction.eval(d4 += d3);
            if (d6 * d5 < 0.0) {
                dArray[n2] = d4 - d3;
                dArray2[n2++] = d4;
            }
            d5 = d6;
            if (n3 != n2) continue;
            return n2;
        }
        return n2;
    }

    public static double zbrent(PuFunction puFunction, double d, double d2, double d3) {
        int n = 100;
        double d4 = 3.0E-12;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d;
        double d9 = d2;
        double d10 = puFunction.eval(d8);
        double d11 = puFunction.eval(d9);
        if (d11 * d10 > 0.0) {
            PsDebug.warning((String)"root must be bracketed in initial interval.");
            return d - 1.0;
        }
        double d12 = d11;
        for (int i = 0; i < n; ++i) {
            if (d11 * d12 > 0.0) {
                d5 = d8;
                d12 = d10;
                d7 = d6 = d9 - d8;
            }
            if (Math.abs(d12) < Math.abs(d11)) {
                d8 = d9;
                d9 = d5;
                d5 = d8;
                d10 = d11;
                d11 = d12;
                d12 = d10;
            }
            double d13 = 2.0 * d4 * Math.abs(d9) + 0.5 * d3;
            double d14 = 0.5 * (d5 - d9);
            if (Math.abs(d14) <= d13 || d11 == 0.0) {
                return d9;
            }
            if (Math.abs(d7) >= d13 && Math.abs(d10) > Math.abs(d11)) {
                double d15;
                double d16;
                double d17;
                double d18 = d11 / d10;
                if (d8 == d5) {
                    d17 = 2.0 * d14 * d18;
                    d16 = 1.0 - d18;
                } else {
                    d16 = d10 / d12;
                    double d19 = d11 / d12;
                    d17 = d18 * (2.0 * d14 * d16 * (d16 - d19) - (d9 - d8) * (d19 - 1.0));
                    d16 = (d16 - 1.0) * (d19 - 1.0) * (d18 - 1.0);
                }
                if (d17 > 0.0) {
                    d16 = -d16;
                }
                d17 = Math.abs(d17);
                double d20 = 3.0 * d14 * d16 - Math.abs(d13 * d16);
                double d21 = d20 < (d15 = Math.abs(d7 * d16)) ? d20 : d15;
                if (2.0 * d17 < d21) {
                    d7 = d6;
                    d6 = d17 / d16;
                } else {
                    d7 = d6 = d14;
                }
            } else {
                d7 = d6 = d14;
            }
            d8 = d9;
            d10 = d11;
            d9 = Math.abs(d6) > d13 ? (d9 += d6) : (d9 += d14 > 0.0 ? Math.abs(d13) : -Math.abs(d13));
            d11 = puFunction.eval(d9);
        }
        PsDebug.warning((String)"maximum number of iterations exceeded");
        return d - 1.0;
    }
}

