/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.util.Date;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PnJacobi
extends PsObject {
    public static final int FAILURE = -1;
    public static final int INTERRUPTED = -2;
    protected static boolean m_bInterrupted;
    protected boolean m_bDoublePrecision = true;

    public static void setInterrupted(boolean bl) {
        m_bInterrupted = bl;
    }

    public static boolean isInterrupted() {
        return m_bInterrupted;
    }

    public void setDoublePrecision(boolean bl) {
        this.m_bDoublePrecision = bl;
    }

    public boolean isDoublePrecision() {
        return this.m_bDoublePrecision;
    }

    public static int computeEigenvectors(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2;
        int n3;
        int n4;
        double[] dArray = pdVector.m_data;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[][] dArray4 = new double[n][n];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                dArray4[n4][n3] = pdMatrix.m_data[n4][n3];
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            pdVectorArray[n2].setConstant(0.0);
            pdVectorArray[n2].setEntry(n2, 1.0);
            dArray2[n2] = dArray4[n2][n2];
            dArray[n2] = dArray2[n2];
            dArray3[n2] = 0.0;
        }
        int n5 = 0;
        for (n4 = 0; n4 < 50; ++n4) {
            int n6;
            double d = 0.0;
            for (n2 = 0; n2 < n - 1; ++n2) {
                for (n6 = n2 + 1; n6 < n; ++n6) {
                    d += Math.abs(dArray4[n2][n6]);
                }
            }
            if (d < 1.0E-10) {
                return n5;
            }
            double d2 = n4 < 3 ? 0.2 * d / (double)(n * n) : 0.0;
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (m_bInterrupted) {
                    return -2;
                }
                for (n6 = n2 + 1; n6 < n; ++n6) {
                    double d3;
                    double d4 = 100.0 * Math.abs(dArray4[n2][n6]);
                    if (n4 > 3 && (float)(Math.abs(dArray[n2]) + d4) == (float)Math.abs(dArray[n2]) && (float)(Math.abs(dArray[n6]) + d4) == (float)Math.abs(dArray[n6])) {
                        dArray4[n2][n6] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(dArray4[n2][n6]) > d2)) continue;
                    double d5 = dArray[n6] - dArray[n2];
                    if ((float)(Math.abs(d5) + d4) == (float)Math.abs(d5)) {
                        d3 = dArray4[n2][n6] / d5;
                    } else {
                        double d6 = 0.5 * d5 / dArray4[n2][n6];
                        d3 = 1.0 / (Math.abs(d6) + Math.sqrt(1.0 + d6 * d6));
                        if (d6 < 0.0) {
                            d3 = -d3;
                        }
                    }
                    double d7 = 1.0 / Math.sqrt(1.0 + d3 * d3);
                    double d8 = d3 * d7;
                    double d9 = d8 / (1.0 + d7);
                    d5 = d3 * dArray4[n2][n6];
                    int n7 = n2;
                    dArray3[n7] = dArray3[n7] - d5;
                    int n8 = n6;
                    dArray3[n8] = dArray3[n8] + d5;
                    int n9 = n2;
                    dArray[n9] = dArray[n9] - d5;
                    int n10 = n6;
                    dArray[n10] = dArray[n10] + d5;
                    dArray4[n2][n6] = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        d4 = dArray4[n3][n2];
                        d5 = dArray4[n3][n6];
                        dArray4[n3][n2] = d4 - d8 * (d5 + d4 * d9);
                        dArray4[n3][n6] = d5 + d8 * (d4 - d5 * d9);
                    }
                    for (n3 = n2 + 1; n3 < n6; ++n3) {
                        d4 = dArray4[n2][n3];
                        d5 = dArray4[n3][n6];
                        dArray4[n2][n3] = d4 - d8 * (d5 + d4 * d9);
                        dArray4[n3][n6] = d5 + d8 * (d4 - d5 * d9);
                    }
                    for (n3 = n6 + 1; n3 < n; ++n3) {
                        d4 = dArray4[n2][n3];
                        d5 = dArray4[n6][n3];
                        dArray4[n2][n3] = d4 - d8 * (d5 + d4 * d9);
                        dArray4[n6][n3] = d5 + d8 * (d4 - d5 * d9);
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        d4 = pdVectorArray[n2].m_data[n3];
                        d5 = pdVectorArray[n6].m_data[n3];
                        pdVectorArray[n2].m_data[n3] = d4 - d8 * (d5 + d4 * d9);
                        pdVectorArray[n6].m_data[n3] = d5 + d8 * (d4 - d5 * d9);
                    }
                    ++n5;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n11 = n2;
                dArray2[n11] = dArray2[n11] + dArray3[n2];
                dArray[n2] = dArray2[n2];
                dArray3[n2] = 0.0;
            }
        }
        PsDebug.warning((String)"Too many iterations in routine jacobi");
        return n5;
    }

    public static int fcomputeEigenvectors(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2;
        int n3;
        int n4;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[][] fArray4 = new float[n][n];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                fArray4[n4][n3] = (float)pdMatrix.m_data[n4][n3];
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            pdVectorArray[n2].setConstant(0.0);
            pdVectorArray[n2].setEntry(n2, 1.0);
            fArray2[n2] = fArray4[n2][n2];
            fArray[n2] = fArray2[n2];
            fArray3[n2] = 0.0f;
        }
        int n5 = 0;
        double d = new Date().getTime();
        for (n4 = 0; n4 < 50; ++n4) {
            int n6;
            PsDebug.message((String)("Jacobi iteration = " + String.valueOf(n4)));
            float f = 0.0f;
            for (n2 = 0; n2 < n - 1; ++n2) {
                for (n6 = n2 + 1; n6 < n; ++n6) {
                    f += Math.abs(fArray4[n2][n6]);
                }
            }
            if ((double)f < 1.0E-10) {
                for (n2 = 0; n2 < n; ++n2) {
                    pdVector.m_data[n2] = fArray[n2];
                }
                return n5;
            }
            float f2 = n4 < 3 ? 0.2f * f / (float)(n * n) : 0.0f;
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (m_bInterrupted) {
                    return -2;
                }
                for (n6 = n2 + 1; n6 < n; ++n6) {
                    float f3;
                    float f4 = 100.0f * Math.abs(fArray4[n2][n6]);
                    if (n4 > 3 && Math.abs(fArray[n2]) + f4 == Math.abs(fArray[n2]) && Math.abs(fArray[n6]) + f4 == Math.abs(fArray[n6])) {
                        fArray4[n2][n6] = 0.0f;
                        continue;
                    }
                    if (!(Math.abs(fArray4[n2][n6]) > f2)) continue;
                    float f5 = fArray[n6] - fArray[n2];
                    if (Math.abs(f5) + f4 == Math.abs(f5)) {
                        f3 = fArray4[n2][n6] / f5;
                    } else {
                        float f6 = 0.5f * f5 / fArray4[n2][n6];
                        f3 = 1.0f / (Math.abs(f6) + (float)Math.sqrt(1.0f + f6 * f6));
                        if (f6 < 0.0f) {
                            f3 = -f3;
                        }
                    }
                    float f7 = 1.0f / (float)Math.sqrt(1.0f + f3 * f3);
                    float f8 = f3 * f7;
                    float f9 = f8 / (1.0f + f7);
                    f5 = f3 * fArray4[n2][n6];
                    int n7 = n2;
                    fArray3[n7] = fArray3[n7] - f5;
                    int n8 = n6;
                    fArray3[n8] = fArray3[n8] + f5;
                    int n9 = n2;
                    fArray[n9] = fArray[n9] - f5;
                    int n10 = n6;
                    fArray[n10] = fArray[n10] + f5;
                    fArray4[n2][n6] = 0.0f;
                    for (n3 = 0; n3 < n2; ++n3) {
                        f4 = fArray4[n3][n2];
                        f5 = fArray4[n3][n6];
                        fArray4[n3][n2] = f4 - f8 * (f5 + f4 * f9);
                        fArray4[n3][n6] = f5 + f8 * (f4 - f5 * f9);
                    }
                    for (n3 = n2 + 1; n3 < n6; ++n3) {
                        f4 = fArray4[n2][n3];
                        f5 = fArray4[n3][n6];
                        fArray4[n2][n3] = f4 - f8 * (f5 + f4 * f9);
                        fArray4[n3][n6] = f5 + f8 * (f4 - f5 * f9);
                    }
                    for (n3 = n6 + 1; n3 < n; ++n3) {
                        f4 = fArray4[n2][n3];
                        f5 = fArray4[n6][n3];
                        fArray4[n2][n3] = f4 - f8 * (f5 + f4 * f9);
                        fArray4[n6][n3] = f5 + f8 * (f4 - f5 * f9);
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        f4 = (float)pdVectorArray[n2].m_data[n3];
                        f5 = (float)pdVectorArray[n6].m_data[n3];
                        pdVectorArray[n2].m_data[n3] = f4 - f8 * (f5 + f4 * f9);
                        pdVectorArray[n6].m_data[n3] = f5 + f8 * (f4 - f5 * f9);
                    }
                    ++n5;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n11 = n2;
                fArray2[n11] = fArray2[n11] + fArray3[n2];
                fArray[n2] = fArray2[n2];
                fArray3[n2] = 0.0f;
            }
            double d2 = new Date().getTime();
            PsDebug.message((String)("\tDuration of Loop (ms, float) = " + String.valueOf((float)(d2 - d))));
            d = d2;
        }
        PsDebug.warning((String)"Too many iterations in routine jacobi");
        return n5;
    }

    public static void printEigenvectors(int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63025) + ":\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)i, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[i])));
            stringBuffer.append(" eVector[" + PuString.intToString((int)i, (int)n2) + "] = ");
            stringBuffer.append(pdVectorArray[nArray[i]].toShortString());
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public static void printEigenvalues(int n, PdVector pdVector) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63026) + ":\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)i, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[i])) + "\n");
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public static boolean test(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        boolean bl = true;
        PdVector pdVector2 = new PdVector(n);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63027) + ":\n");
        for (int i = 0; i < n; ++i) {
            pdVector2.setConstant(0.0);
            pdVector2.leftMultMatrix(pdMatrix, pdVectorArray[i]);
            pdVectorArray[i].multScalar(pdVector.getEntry(i));
            pdVector2.sub(pdVectorArray[i]);
            double d = pdVector2.length();
            stringBuffer.append("\t Abs(Mat*eVec[" + PuString.intToString((int)i, (int)n2) + "]-eValue[" + PuString.intToString((int)i, (int)n2) + "]*eVec[" + PuString.intToString((int)i, (int)n2) + "]) = " + d + "\n");
            if (!(d > 1.0E-10)) continue;
            bl = false;
        }
        PsDebug.message((String)stringBuffer.toString());
        return bl;
    }
}

