/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import jv.function.PuFunction;
import jv.loader.PgAbstractLoader;
import jv.loader.PgJvxLoader;
import jv.loader.PsXmlLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Parser;
import jv.thirdParty.expr.Syntax_error;
import jv.thirdParty.expr.Variable;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.primitive.PgCircleF;
import jvx.primitive.PgCurveF;
import jvx.primitive.PgGraphF;
import jvx.primitive.PgPlotF;
import jvx.primitive.PgPointF;
import jvx.primitive.PgSegmentF;
import jvx.primitive.PgSphere;
import jvx.primitive.PuIntervalDescr;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;
import jvx.surface.PgParmSurface;

public class PgJvfLoader
extends PgAbstractLoader {
    private int m_jvVersion = -1;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public boolean load(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing buffered reader");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read((BufferedReader)bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return false;
        }
        this.m_specialArr = this.parseRsrcTree(psXmlSrc);
        if (this.m_specialArr == null) {
            PsDebug.warning((String)"failed to interpret JVF tree");
            return false;
        }
        return true;
    }

    public static PgGeometryIf[] readSpecial(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgJvfLoader pgJvfLoader = new PgJvfLoader();
        boolean bl = pgJvfLoader.load(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            PsDebug.warning((String)"failed to parse XML stream");
            return null;
        }
        return pgJvfLoader.getSpecializedGeometries();
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning((String)"missing geometries.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write((Writer)writer, (PsXmlSrc)psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"failed to write XML tree", (Object)iOException);
            return false;
        }
    }

    protected PuDouble[] parseParm(PsXmlNode psXmlNode) {
        PsXmlNode[] psXmlNodeArray = psXmlNode.getChildren("parm");
        if (psXmlNodeArray == null) {
            return null;
        }
        PuDouble[] puDoubleArray = new PuDouble[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            String string = psXmlNodeArray[i].getAttribute("name");
            if (string == null) {
                string = "Slider" + String.valueOf(PsObject.getNumObjects() + 1);
            }
            puDoubleArray[i] = new PuDouble(string);
            String string2 = psXmlNodeArray[i].getAttribute("symbol");
            puDoubleArray[i].setSymbol(string2);
            double d = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[i], "min");
            double d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[i], "max");
            puDoubleArray[i].setBounds(d, d2);
            puDoubleArray[i].setDefBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 10.0);
            double d3 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[i], "value");
            puDoubleArray[i].setValue(d3);
            puDoubleArray[i].setDefValue(d3);
            Variable variable = Variable.make((String)string2);
            variable.setValue(d3);
        }
        return puDoubleArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected PgGeometryIf[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning((String)"missing root node.");
            return null;
        }
        if (psXmlNode.getType() == null || !psXmlNode.getType().equalsIgnoreCase("jvf-model")) {
            PsDebug.warning((String)"missing <jvf-model> element,\nthis is not a valid JavaView geometry file.");
            return null;
        }
        String string = null;
        String string2 = null;
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"version");
        if (psXmlNode2 == null) {
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode2.getContent();
            string2 = psXmlNode2.getAttribute("type");
        }
        String string3 = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)"title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode3 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.setXmlNode(psXmlNode3);
        }
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"description");
        PsGeometryInfo psGeometryInfo = null;
        if (psXmlNode4 != null) {
            psGeometryInfo = new PsGeometryInfo();
            psGeometryInfo.setXmlNode(psXmlNode4, null);
        }
        PgGeometryIf[] pgGeometryIfArray = null;
        String[] stringArray = new String[]{"tag", "name"};
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"geometries");
        if (psXmlNode5 == null) {
            PsDebug.warning((String)"missing node 'geometries'.");
            return pgGeometryIfArray;
        }
        PuDouble[] puDoubleArray = this.parseParm(psXmlNode5);
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode5, (String)"geometry");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        pgGeometryIfArray = new PgGeometryIf[psXmlNodeArray.length];
        int n = 0;
        while (true) {
            block258: {
                PgJvxSrc pgJvxSrc;
                block279: {
                    PsXmlNode psXmlNode6;
                    Object object;
                    block255: {
                        String string4;
                        block282: {
                            Object object2;
                            block283: {
                                int n2;
                                block281: {
                                    block280: {
                                        PsXmlNode psXmlNode7;
                                        int n3;
                                        PiVector[] piVectorArray;
                                        double d;
                                        PsXmlNode psXmlNode8;
                                        PdVector[] pdVectorArray;
                                        PsXmlNode psXmlNode9;
                                        String string5;
                                        PiVector[] piVectorArray2;
                                        PdVector[] pdVectorArray2;
                                        Object object3;
                                        Object object4;
                                        Object object5;
                                        int n4;
                                        int n5;
                                        block272: {
                                            PsXmlNode psXmlNode10;
                                            block273: {
                                                PsXmlNode psXmlNode11;
                                                PsXmlNode psXmlNode12;
                                                block254: {
                                                    block277: {
                                                        block278: {
                                                            block253: {
                                                                block275: {
                                                                    block276: {
                                                                        block252: {
                                                                            block274: {
                                                                                Color[] colorArray;
                                                                                String[] stringArray2;
                                                                                block269: {
                                                                                    PgParmSurface pgParmSurface;
                                                                                    PuDouble[] puDoubleArray2;
                                                                                    Object object6;
                                                                                    double d2;
                                                                                    block271: {
                                                                                        PsXmlNode[] psXmlNodeArray2;
                                                                                        block270: {
                                                                                            block265: {
                                                                                                PuFunction puFunction;
                                                                                                PsXmlNode psXmlNode13;
                                                                                                block267: {
                                                                                                    block266: {
                                                                                                        block262: {
                                                                                                            PuFunction puFunction2;
                                                                                                            Object object7;
                                                                                                            block264: {
                                                                                                                PsXmlNode[] psXmlNodeArray3;
                                                                                                                block263: {
                                                                                                                    block259: {
                                                                                                                        PsXmlNode[] psXmlNodeArray4;
                                                                                                                        Object object8;
                                                                                                                        block261: {
                                                                                                                            PsXmlNode psXmlNode14;
                                                                                                                            block260: {
                                                                                                                                PsXmlNode[] psXmlNodeArray5;
                                                                                                                                Object object9;
                                                                                                                                PgSphere pgSphere;
                                                                                                                                block256: {
                                                                                                                                    block257: {
                                                                                                                                        if (n >= psXmlNodeArray.length) return pgGeometryIfArray;
                                                                                                                                        PsXmlNode psXmlNode15 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"sphere");
                                                                                                                                        if (psXmlNode15 == null) break block256;
                                                                                                                                        pgSphere = new PgSphere();
                                                                                                                                        pgGeometryIfArray[n] = pgSphere;
                                                                                                                                        if (psXmlNode15.hasChild("base")) {
                                                                                                                                            object9 = PsXmlLoader.parsePdVector((PsXmlNode)psXmlNode15, (String)"base", null);
                                                                                                                                            pgSphere.setBase((PdVector)object9);
                                                                                                                                        }
                                                                                                                                        if (psXmlNode15.hasChild("radius")) {
                                                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNode15, "radius");
                                                                                                                                            pgSphere.setRadius(d2);
                                                                                                                                        }
                                                                                                                                        object9 = pgSphere.getDomainDescr();
                                                                                                                                        psXmlNodeArray5 = psXmlNode15.getChildren("var");
                                                                                                                                        if (psXmlNodeArray5 != null && psXmlNodeArray5.length == 2) break block257;
                                                                                                                                        PsDebug.warning((String)"missing var elements.");
                                                                                                                                        break block258;
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[0].hasChild("min")) {
                                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[0], "min");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setUMin(d2);
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[0].hasChild("max")) {
                                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[0], "max");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setUMax(d2);
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[0].hasChild("discr")) {
                                                                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray5[0], (String)"discr");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setNumULines(n5);
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[1].hasChild("min")) {
                                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[1], "min");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setVMin(d2);
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[1].hasChild("max")) {
                                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[1], "max");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setVMax(d2);
                                                                                                                                    }
                                                                                                                                    if (psXmlNodeArray5[1].hasChild("discr")) {
                                                                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray5[1], (String)"discr");
                                                                                                                                        ((PgDomainDescr)((Object)object9)).setNumVLines(n5);
                                                                                                                                    }
                                                                                                                                    pgSphere.compute();
                                                                                                                                }
                                                                                                                                if ((pgSphere = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"circleF")) != null) {
                                                                                                                                    int n6 = PgJvfLoader.parseDimension((PsXmlNode)pgSphere, 2);
                                                                                                                                    psXmlNodeArray5 = new PgCircleF(n6);
                                                                                                                                    pgGeometryIfArray[n] = psXmlNodeArray5;
                                                                                                                                    object8 = pgSphere.getChild("baseF");
                                                                                                                                    object7 = psXmlNodeArray5.getBaseF();
                                                                                                                                    psXmlNode14 = object8.getAttribute("name");
                                                                                                                                    if (psXmlNode14 != null) {
                                                                                                                                        object7.setName((String)psXmlNode14);
                                                                                                                                    }
                                                                                                                                    object6 = object8.getContent();
                                                                                                                                    String[] stringArray3 = PuString.splitString((String)object6, (char)';');
                                                                                                                                    object7.setExpressions(stringArray3);
                                                                                                                                    psXmlNode14 = pgSphere.getChild("radiusF");
                                                                                                                                    object6 = psXmlNodeArray5.getRadiusF();
                                                                                                                                    String string6 = object8.getAttribute("name");
                                                                                                                                    if (string6 != null) {
                                                                                                                                        object6.setName(string6);
                                                                                                                                    }
                                                                                                                                    String string7 = psXmlNode14.getContent();
                                                                                                                                    object6.setExpression(string7);
                                                                                                                                    puDoubleArray2 = this.parseParm((PsXmlNode)pgSphere);
                                                                                                                                    if (puDoubleArray2 != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                                                            object7.addParameter(puDoubleArray2[n4]);
                                                                                                                                            object6.addParameter(puDoubleArray2[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (puDoubleArray != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                                                            object7.addParameter(puDoubleArray[n4]);
                                                                                                                                            object6.addParameter(puDoubleArray[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    psXmlNodeArray5.compute();
                                                                                                                                }
                                                                                                                                if ((object9 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"pointF")) != null) {
                                                                                                                                    int n7 = PgJvfLoader.parseDimension((PsXmlNode)object9, 2);
                                                                                                                                    object8 = new PgPointF(n7);
                                                                                                                                    pgGeometryIfArray[n] = object8;
                                                                                                                                    object7 = object9.getChild("baseF");
                                                                                                                                    psXmlNode14 = ((PgPointF)((Object)object8)).getBaseF();
                                                                                                                                    object6 = object7.getAttribute("name");
                                                                                                                                    if (object6 != null) {
                                                                                                                                        psXmlNode14.setName((String)object6);
                                                                                                                                    }
                                                                                                                                    String string8 = object7.getContent();
                                                                                                                                    String[] stringArray4 = PuString.splitString((String)string8, (char)';');
                                                                                                                                    psXmlNode14.setExpressions(stringArray4);
                                                                                                                                    puDoubleArray2 = this.parseParm((PsXmlNode)object9);
                                                                                                                                    if (puDoubleArray2 != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                                                            psXmlNode14.addParameter(puDoubleArray2[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (puDoubleArray != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                                                            psXmlNode14.addParameter(puDoubleArray[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    ((PgPointF)((Object)object8)).compute();
                                                                                                                                }
                                                                                                                                if ((psXmlNodeArray5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"segmentF")) != null) {
                                                                                                                                    int n8 = PgJvfLoader.parseDimension((PsXmlNode)psXmlNodeArray5, 2);
                                                                                                                                    object7 = new PgSegmentF(n8);
                                                                                                                                    pgGeometryIfArray[n] = object7;
                                                                                                                                    psXmlNode14 = psXmlNodeArray5.getChild("baseF");
                                                                                                                                    object6 = ((PgSegmentF)((Object)object7)).getBaseF();
                                                                                                                                    String string9 = psXmlNode14.getAttribute("name");
                                                                                                                                    if (string9 != null) {
                                                                                                                                        object6.setName(string9);
                                                                                                                                    }
                                                                                                                                    String string10 = psXmlNode14.getContent();
                                                                                                                                    object5 = PuString.splitString((String)string10, (char)';');
                                                                                                                                    object6.setExpressions((String[])object5);
                                                                                                                                    PsXmlNode psXmlNode16 = psXmlNodeArray5.getChild("tipF");
                                                                                                                                    PuFunction puFunction3 = ((PgSegmentF)((Object)object7)).getTipF();
                                                                                                                                    object5 = psXmlNode16.getAttribute("name");
                                                                                                                                    if (object5 != null) {
                                                                                                                                        puFunction3.setName((String)object5);
                                                                                                                                    }
                                                                                                                                    stringArray2 = psXmlNode16.getContent();
                                                                                                                                    object4 = PuString.splitString((String)stringArray2, (char)';');
                                                                                                                                    puFunction3.setExpressions((String[])object4);
                                                                                                                                    puDoubleArray2 = this.parseParm((PsXmlNode)psXmlNodeArray5);
                                                                                                                                    if (puDoubleArray2 != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                                                            object6.addParameter(puDoubleArray2[n4]);
                                                                                                                                            puFunction3.addParameter(puDoubleArray2[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (puDoubleArray != null) {
                                                                                                                                        for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                                                            object6.addParameter(puDoubleArray[n4]);
                                                                                                                                            puFunction3.addParameter(puDoubleArray[n4]);
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    ((PgSegmentF)((Object)object7)).compute();
                                                                                                                                }
                                                                                                                                if ((object8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"plotF")) == null) break block259;
                                                                                                                                object7 = new PgPlotF();
                                                                                                                                pgGeometryIfArray[n] = object7;
                                                                                                                                psXmlNode14 = object8.getChildren("funExpr");
                                                                                                                                object6 = ((PgPlotF)((Object)object7)).getFunction();
                                                                                                                                if (psXmlNode14 != null && ((PsXmlNode)psXmlNode14).length == 1) break block260;
                                                                                                                                PsDebug.warning((String)"missing function elements.");
                                                                                                                                break block258;
                                                                                                                            }
                                                                                                                            for (n4 = 0; n4 < ((PsXmlNode)psXmlNode14).length; ++n4) {
                                                                                                                                String string11 = psXmlNode14[n4].getContent();
                                                                                                                                object6.setExpression(n4, string11);
                                                                                                                                String string12 = psXmlNode14[n4].getAttribute("name");
                                                                                                                                if (string12 == null) continue;
                                                                                                                                object6.setExpressionName(n4, string12);
                                                                                                                            }
                                                                                                                            psXmlNodeArray4 = object8.getChildren("var");
                                                                                                                            if (psXmlNodeArray4 != null && psXmlNodeArray4.length == 1) break block261;
                                                                                                                            PsDebug.warning((String)"missing var elements.");
                                                                                                                            break block258;
                                                                                                                        }
                                                                                                                        object6.setNumVariables(psXmlNodeArray4.length);
                                                                                                                        String[] stringArray5 = new String[psXmlNodeArray4.length];
                                                                                                                        for (n4 = 0; n4 < psXmlNodeArray4.length; ++n4) {
                                                                                                                            stringArray5[n4] = psXmlNodeArray4[n4].getAttribute("symbol");
                                                                                                                        }
                                                                                                                        object6.setVariables(stringArray5);
                                                                                                                        object5 = ((PgPlotF)((Object)object7)).getInterval();
                                                                                                                        if (psXmlNodeArray4[0].hasChild("min")) {
                                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray4[0], "min");
                                                                                                                            ((PuIntervalDescr)((Object)object5)).setUMin(d2);
                                                                                                                        }
                                                                                                                        if (psXmlNodeArray4[0].hasChild("max")) {
                                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray4[0], "max");
                                                                                                                            ((PuIntervalDescr)((Object)object5)).setUMax(d2);
                                                                                                                        }
                                                                                                                        if (psXmlNodeArray4[0].hasChild("discr")) {
                                                                                                                            n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray4[0], (String)"discr");
                                                                                                                            ((PuIntervalDescr)((Object)object5)).setDiscr(n5);
                                                                                                                        }
                                                                                                                        if ((puDoubleArray2 = this.parseParm((PsXmlNode)object8)) != null) {
                                                                                                                            for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                                                object6.addParameter(puDoubleArray2[n4]);
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (puDoubleArray != null) {
                                                                                                                            for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                                                object6.addParameter(puDoubleArray[n4]);
                                                                                                                            }
                                                                                                                        }
                                                                                                                        ((PgPlotF)((Object)object7)).compute();
                                                                                                                    }
                                                                                                                    if ((object7 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"curveF")) == null) break block262;
                                                                                                                    int n9 = PgJvfLoader.parseDimension((PsXmlNode)object7, 2);
                                                                                                                    object6 = new PgCurveF(n9);
                                                                                                                    pgGeometryIfArray[n] = object6;
                                                                                                                    psXmlNodeArray3 = object7.getChildren("funExpr");
                                                                                                                    puFunction2 = ((PgCurveF)((Object)object6)).getFunction();
                                                                                                                    if (psXmlNodeArray3 != null && psXmlNodeArray3.length == n9) break block263;
                                                                                                                    PsDebug.warning((String)"missing function elements.");
                                                                                                                    break block258;
                                                                                                                }
                                                                                                                for (n4 = 0; n4 < psXmlNodeArray3.length; ++n4) {
                                                                                                                    object5 = psXmlNodeArray3[n4].getContent();
                                                                                                                    puFunction2.setExpression(n4, (String)object5);
                                                                                                                    stringArray2 = psXmlNodeArray3[n4].getAttribute("name");
                                                                                                                    if (stringArray2 == null) continue;
                                                                                                                    puFunction2.setExpressionName(n4, (String)stringArray2);
                                                                                                                }
                                                                                                                object5 = object7.getChildren("var");
                                                                                                                if (object5 != null && ((PsXmlNode[])object5).length == 1) break block264;
                                                                                                                PsDebug.warning((String)"missing var elements.");
                                                                                                                break block258;
                                                                                                            }
                                                                                                            puFunction2.setNumVariables(((PsXmlNode[])object5).length);
                                                                                                            stringArray2 = new String[((PsXmlNode[])object5).length];
                                                                                                            for (n4 = 0; n4 < ((PsXmlNode[])object5).length; ++n4) {
                                                                                                                stringArray2[n4] = object5[n4].getAttribute("symbol");
                                                                                                            }
                                                                                                            puFunction2.setVariables(stringArray2);
                                                                                                            object4 = ((PgCurveF)((Object)object6)).getInterval();
                                                                                                            if (object5[0].hasChild("min")) {
                                                                                                                d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[0], "min");
                                                                                                                ((PuIntervalDescr)((Object)object4)).setUMin(d2);
                                                                                                            }
                                                                                                            if (object5[0].hasChild("max")) {
                                                                                                                d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[0], "max");
                                                                                                                ((PuIntervalDescr)((Object)object4)).setUMax(d2);
                                                                                                            }
                                                                                                            if (object5[0].hasChild("discr")) {
                                                                                                                n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[0], (String)"discr");
                                                                                                                ((PuIntervalDescr)((Object)object4)).setDiscr(n5);
                                                                                                            }
                                                                                                            if ((puDoubleArray2 = this.parseParm((PsXmlNode)object7)) != null) {
                                                                                                                for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                                    puFunction2.addParameter(puDoubleArray2[n4]);
                                                                                                                }
                                                                                                            }
                                                                                                            if (puDoubleArray != null) {
                                                                                                                for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                                    puFunction2.addParameter(puDoubleArray[n4]);
                                                                                                                }
                                                                                                            }
                                                                                                            ((PgCurveF)((Object)object6)).compute();
                                                                                                        }
                                                                                                        if ((psXmlNode13 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"graphF")) == null) break block265;
                                                                                                        object6 = new PgGraphF();
                                                                                                        pgGeometryIfArray[n] = object6;
                                                                                                        PsXmlNode psXmlNode17 = psXmlNode13.getChild("funExpr");
                                                                                                        puFunction = ((PgGraphF)((Object)object6)).getFunction();
                                                                                                        if (psXmlNode17 != null) {
                                                                                                            object5 = psXmlNode17.getContent();
                                                                                                            puFunction.setExpression((String)object5);
                                                                                                            stringArray2 = psXmlNode17.getAttribute("name");
                                                                                                            if (stringArray2 != null) {
                                                                                                                puFunction.setExpressionName((String)stringArray2);
                                                                                                            }
                                                                                                        }
                                                                                                        if ((object5 = psXmlNode13.getChildren("var")) != null && ((PuFunction)object5).length == 2) break block266;
                                                                                                        PsDebug.warning((String)"missing var elements.");
                                                                                                        break block258;
                                                                                                    }
                                                                                                    puFunction.setNumVariables(((PsXmlNode[])object5).length);
                                                                                                    stringArray2 = new String[((PsXmlNode[])object5).length];
                                                                                                    for (n4 = 0; n4 < ((PsXmlNode[])object5).length; ++n4) {
                                                                                                        stringArray2[n4] = object5[n4].getAttribute("symbol");
                                                                                                    }
                                                                                                    puFunction.setVariables(stringArray2);
                                                                                                    object4 = psXmlNode13.getChildren("flag");
                                                                                                    if (object4 == null) break block267;
                                                                                                    for (n4 = 0; n4 < ((String[])object4).length; ++n4) {
                                                                                                        boolean bl;
                                                                                                        object3 = object4[n4].getAttribute("name");
                                                                                                        if (object3 == null) {
                                                                                                            PsDebug.warning((String)"missing name of flag.");
                                                                                                            continue;
                                                                                                        }
                                                                                                        boolean bl2 = bl = PgJvfLoader.parseFlag((PsXmlNode)object4[n4]) == 1;
                                                                                                        if (((String)object3).equals("Domain.Visible")) {
                                                                                                            ((PgGraphF)((Object)object6)).setShowingDomain(bl);
                                                                                                            continue;
                                                                                                        }
                                                                                                        if (((String)object3).equals("Domain.SynchronizeColor")) {
                                                                                                            ((PgGraphF)((Object)object6)).setEnabledSynchronization(bl);
                                                                                                            continue;
                                                                                                        }
                                                                                                        PsDebug.warning((String)("unknown flag = " + (String)object3));
                                                                                                    }
                                                                                                }
                                                                                                if ((object3 = psXmlNode13.getChildren("ctrl")) != null) {
                                                                                                    for (n4 = 0; n4 < ((PsXmlNode[])object3).length; ++n4) {
                                                                                                        String string13 = object3[n4].getAttribute("name");
                                                                                                        if (string13 == null) {
                                                                                                            PsDebug.warning((String)"missing name of ctrl.");
                                                                                                            continue;
                                                                                                        }
                                                                                                        pdVectorArray2 = new PuDouble(string13, (PsUpdateIf)object6);
                                                                                                        piVectorArray2 = object3[n4].getAttribute("symbol");
                                                                                                        if (piVectorArray2 != null) {
                                                                                                            pdVectorArray2.setSymbol((String)piVectorArray2);
                                                                                                        }
                                                                                                        double d3 = PgJvfLoader.getRsrcAsDoubleF(object3[n4], "min");
                                                                                                        double d4 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object3[n4], "max");
                                                                                                        pdVectorArray2.setBounds(d3, d4);
                                                                                                        pdVectorArray2.setDefBounds(d3, d4, (d4 - d3) / 100.0, (d4 - d3) / 10.0);
                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object3[n4], "value");
                                                                                                        pdVectorArray2.setValue(d2);
                                                                                                        pdVectorArray2.setDefValue(d2);
                                                                                                        if (!string13.equals("Domain.Offset")) continue;
                                                                                                        ((PgGraphF)((Object)object6)).getOffsetSlider().copy((PuDouble)pdVectorArray2);
                                                                                                    }
                                                                                                }
                                                                                                if ((puDoubleArray2 = this.parseParm(psXmlNode13)) != null) {
                                                                                                    for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                                        puFunction.addParameter(puDoubleArray2[n4]);
                                                                                                    }
                                                                                                }
                                                                                                if (puDoubleArray != null) {
                                                                                                    for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                                        puFunction.addParameter(puDoubleArray[n4]);
                                                                                                    }
                                                                                                }
                                                                                                PgDomain pgDomain = ((PgGraphF)((Object)object6)).getDomain();
                                                                                                pdVectorArray2 = pgDomain.getDescr();
                                                                                                if (object5[0].hasChild("min")) {
                                                                                                    d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[0], "min");
                                                                                                    pdVectorArray2.setUMin(d2);
                                                                                                }
                                                                                                if (object5[0].hasChild("max")) {
                                                                                                    d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[0], "max");
                                                                                                    pdVectorArray2.setUMax(d2);
                                                                                                }
                                                                                                if (object5[0].hasChild("discr")) {
                                                                                                    n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[0], (String)"discr");
                                                                                                    pdVectorArray2.setNumULines(n5);
                                                                                                }
                                                                                                if (object5[1].hasChild("min")) {
                                                                                                    d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[1], "min");
                                                                                                    pdVectorArray2.setVMin(d2);
                                                                                                }
                                                                                                if (object5[1].hasChild("max")) {
                                                                                                    d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object5[1], "max");
                                                                                                    pdVectorArray2.setVMax(d2);
                                                                                                }
                                                                                                if (object5[1].hasChild("discr")) {
                                                                                                    n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object5[1], (String)"discr");
                                                                                                    pdVectorArray2.setNumVLines(n5);
                                                                                                }
                                                                                                pgDomain.update(pdVectorArray2);
                                                                                                ((PgGraphF)((Object)object6)).update((Object)pgDomain);
                                                                                            }
                                                                                            if ((object6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"surfaceF")) == null) break block269;
                                                                                            pgParmSurface = new PgParmSurface();
                                                                                            pgGeometryIfArray[n] = pgParmSurface;
                                                                                            psXmlNodeArray2 = object6.getChildren("funExpr");
                                                                                            object5 = pgParmSurface.getFunctionExpr();
                                                                                            if (psXmlNodeArray2 != null && psXmlNodeArray2.length == 3) break block270;
                                                                                            PsDebug.warning((String)"missing function elements.");
                                                                                            break block258;
                                                                                        }
                                                                                        for (n4 = 0; n4 < psXmlNodeArray2.length; ++n4) {
                                                                                            stringArray2 = psXmlNodeArray2[n4].getContent();
                                                                                            object5.setExpression(n4, (String)stringArray2);
                                                                                            object5.setDefExpression(n4, (String)stringArray2);
                                                                                            object4 = psXmlNodeArray2[n4].getAttribute("name");
                                                                                            if (object4 == null) continue;
                                                                                            object5.setExpressionName(n4, (String)object4);
                                                                                        }
                                                                                        stringArray2 = object6.getChildren("var");
                                                                                        if (stringArray2 != null && stringArray2.length == 2) break block271;
                                                                                        PsDebug.warning((String)"missing var elements.");
                                                                                        break block258;
                                                                                    }
                                                                                    object5.setNumVariables(stringArray2.length);
                                                                                    object4 = new String[stringArray2.length];
                                                                                    for (n4 = 0; n4 < stringArray2.length; ++n4) {
                                                                                        object4[n4] = stringArray2[n4].getAttribute("symbol");
                                                                                    }
                                                                                    object5.setVariables((String[])object4);
                                                                                    puDoubleArray2 = this.parseParm((PsXmlNode)object6);
                                                                                    if (puDoubleArray2 != null) {
                                                                                        for (n4 = 0; n4 < puDoubleArray2.length; ++n4) {
                                                                                            object5.addParameter(puDoubleArray2[n4]);
                                                                                        }
                                                                                    }
                                                                                    if (puDoubleArray != null) {
                                                                                        for (n4 = 0; n4 < puDoubleArray.length; ++n4) {
                                                                                            object5.addParameter(puDoubleArray[n4]);
                                                                                        }
                                                                                    }
                                                                                    object3 = pgParmSurface.getDomainDescr();
                                                                                    if (stringArray2[0].hasChild("min")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[0], "min");
                                                                                        ((PgDomainDescr)((Object)object3)).setUMin(d2);
                                                                                    }
                                                                                    if (stringArray2[0].hasChild("max")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[0], "max");
                                                                                        ((PgDomainDescr)((Object)object3)).setUMax(d2);
                                                                                    }
                                                                                    if (stringArray2[0].hasChild("discr")) {
                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)stringArray2[0], (String)"discr");
                                                                                        ((PgDomainDescr)((Object)object3)).setNumULines(n5);
                                                                                    }
                                                                                    if (stringArray2[1].hasChild("min")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[1], "min");
                                                                                        ((PgDomainDescr)((Object)object3)).setVMin(d2);
                                                                                    }
                                                                                    if (stringArray2[1].hasChild("max")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[1], "max");
                                                                                        ((PgDomainDescr)((Object)object3)).setVMax(d2);
                                                                                    }
                                                                                    if (stringArray2[1].hasChild("discr")) {
                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)stringArray2[1], (String)"discr");
                                                                                        ((PgDomainDescr)((Object)object3)).setNumVLines(n5);
                                                                                    }
                                                                                    pgParmSurface.update(object3);
                                                                                    pgParmSurface.compute();
                                                                                }
                                                                                pgJvxSrc = pgGeometryIfArray[n].getJvx();
                                                                                if (psAuthorInfo != null) {
                                                                                    pgJvxSrc.setAuthorInfo(psAuthorInfo);
                                                                                }
                                                                                if (psGeometryInfo != null) {
                                                                                    pgJvxSrc.setGeometryInfo(psGeometryInfo);
                                                                                }
                                                                                pgJvxSrc.setVersion(string);
                                                                                pgJvxSrc.setVersionType(string2);
                                                                                pgJvxSrc.setTitle(string3);
                                                                                String string14 = psXmlNodeArray[n].getAttribute("name");
                                                                                if (string14 != null) {
                                                                                    pgJvxSrc.setName(string14);
                                                                                }
                                                                                pgJvxSrc.setVisible(PgJvfLoader.parseVisibility(psXmlNodeArray[n].getAttribute("visible")) != 0);
                                                                                object5 = null;
                                                                                if (psXmlNodeArray[n].hasChild("labelAtt")) {
                                                                                    stringArray2 = psXmlNodeArray[n].getChild("labelAtt");
                                                                                    object5 = this.parseLabelAtt((PsXmlNode)stringArray2);
                                                                                    if (object5 != null) {
                                                                                        pgJvxSrc.setLabelAttribute(5, (PiVector)object5);
                                                                                        pgJvxSrc.showName(object5.getEntry(5) == 1);
                                                                                    }
                                                                                    if (stringArray2.hasChild("color")) {
                                                                                        object4 = PsXmlLoader.parseColorRGB((PsXmlNode)stringArray2, (String)"color");
                                                                                        pgJvxSrc.setLabelColor(5, (Color)object4);
                                                                                    }
                                                                                }
                                                                                if ((stringArray2 = psXmlNodeArray[n].getChild("material")) != null) {
                                                                                    object4 = stringArray2.getAttribute("shading");
                                                                                    if (object4 != null && ((String)object4).equalsIgnoreCase("gouraud")) {
                                                                                        pgJvxSrc.showSmoothLighting(true);
                                                                                    } else {
                                                                                        pgJvxSrc.showSmoothLighting(false);
                                                                                    }
                                                                                    if (stringArray2.hasChild("specular")) {
                                                                                        object3 = PsXmlLoader.parseColorRGB((PsXmlNode)stringArray2.getChild("specular"), (String)"color");
                                                                                        pgJvxSrc.setSpecularColor((Color)object3);
                                                                                    }
                                                                                    if ((object3 = stringArray2.getChild("transparency")) != null) {
                                                                                        double d5 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2, "transparency");
                                                                                        pgJvxSrc.setTransparency(d5);
                                                                                        if (this.m_jvVersion < 280000) {
                                                                                            pgJvxSrc.showTransparency(true);
                                                                                        } else {
                                                                                            pgJvxSrc.showTransparency(PgJvfLoader.parseVisibility(object3.getAttribute("visible")) == 1);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                object3 = null;
                                                                                psXmlNode10 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"pointSet");
                                                                                if (psXmlNode10 == null) break block272;
                                                                                string5 = psXmlNode10.getAttribute("dim");
                                                                                if (string5 == null) {
                                                                                    PsDebug.warning((String)("missing dimension of geometry[" + n + "]"));
                                                                                    return null;
                                                                                }
                                                                                pgJvxSrc.setDimOfVertices(Integer.parseInt(string5));
                                                                                pgJvxSrc.showVertices(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("point")) != 0);
                                                                                pgJvxSrc.showVertexColors(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("color")) == 1);
                                                                                pgJvxSrc.showVertexNormals(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("normal")) == 1);
                                                                                pgJvxSrc.showVertexNormalArrow(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("normalArrow")) == 1);
                                                                                pgJvxSrc.showVertexSizes(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("thicknesses")) == 1);
                                                                                pgJvxSrc.showTaggedVertices(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("pointMark")) != 0);
                                                                                pgJvxSrc.showVertexOutline(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("pointOutline")) != 0);
                                                                                pgJvxSrc.setType(30);
                                                                                psXmlNode9 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode10, (String)"points");
                                                                                if (psXmlNode9 != null) {
                                                                                    pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode9, (String)"p", (String[])stringArray);
                                                                                    if (pdVectorArray != null) {
                                                                                        pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
                                                                                        pgJvxSrc.setNumVertices(pdVectorArray.length);
                                                                                        pgJvxSrc.setVertices(pdVectorArray);
                                                                                    } else {
                                                                                        psXmlNode8 = PgJvxLoader.parseFunList((PsXmlNode)psXmlNode9, (String)"pf", (String[])stringArray);
                                                                                        if (psXmlNode8 != null) {
                                                                                            pgJvxSrc.setDimOfVertices(psXmlNode8[0].length);
                                                                                            pgJvxSrc.setNumVertices(((String[][])psXmlNode8).length);
                                                                                            pgJvxSrc.setVertexFunctions((String[][])psXmlNode8);
                                                                                        }
                                                                                    }
                                                                                    if (psXmlNode9.hasChild("thickness")) {
                                                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode9, "thickness");
                                                                                        pgJvxSrc.setGlobalVertexSize(d);
                                                                                    }
                                                                                    if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode9, (String)"color")) != null) {
                                                                                        pgJvxSrc.setGlobalVertexColor((Color)object3);
                                                                                    }
                                                                                    if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode9, (String)"colorTag")) != null) {
                                                                                        pgJvxSrc.setGlobalVertexTagColor((Color)object3);
                                                                                    }
                                                                                    if (psXmlNode9.hasChild("labelAtt")) {
                                                                                        psXmlNode8 = psXmlNode9.getChild("labelAtt");
                                                                                        object5 = this.parseLabelAtt(psXmlNode8);
                                                                                        if (object5 != null) {
                                                                                            pgJvxSrc.setLabelAttribute(0, (PiVector)object5);
                                                                                            pgJvxSrc.showVertexLabels(object5.getEntry(5) == 1);
                                                                                        }
                                                                                        if (psXmlNode8.hasChild("color")) {
                                                                                            Color color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"color");
                                                                                            pgJvxSrc.setLabelColor(0, color);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if ((pdVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode10, (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)pdVectorArray, (String)"c")) != null) {
                                                                                    pgJvxSrc.setVertexColors(colorArray);
                                                                                }
                                                                                if ((psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode10, (String)"normals")) != null) {
                                                                                    pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode8, (String)"n", null);
                                                                                    if (pdVectorArray2 != null) {
                                                                                        pgJvxSrc.setVertexNormals(pdVectorArray2);
                                                                                    }
                                                                                    if (psXmlNode8.hasChild("thickness")) {
                                                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode8, "thickness");
                                                                                        pgJvxSrc.setGlobalVertexNormalSize(d);
                                                                                    }
                                                                                    if (psXmlNode8.hasChild("length")) {
                                                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode8, "length");
                                                                                        pgJvxSrc.setGlobalVertexNormalLength(d);
                                                                                    }
                                                                                    if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"color")) != null) {
                                                                                        pgJvxSrc.setGlobalVertexNormalColor((Color)object3);
                                                                                    }
                                                                                }
                                                                                if ((psXmlNode12 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode10, (String)"textures")) == null) break block273;
                                                                                pgJvxSrc.showVertexTexture(PgJvfLoader.parseVisibility(psXmlNode10.getAttribute("texture")) == 1);
                                                                                object = psXmlNode12.getAttribute("blend");
                                                                                if (object == null) break block274;
                                                                                if (((String)object).equals("replace")) {
                                                                                    pgJvxSrc.setBlendingMode(0);
                                                                                    break block252;
                                                                                } else if (((String)object).equals("material")) {
                                                                                    pgJvxSrc.setBlendingMode(1);
                                                                                    break block252;
                                                                                } else {
                                                                                    PsDebug.warning((String)("Unknown texture attribute: blend = " + (String)object));
                                                                                }
                                                                                break block252;
                                                                            }
                                                                            pgJvxSrc.setBlendingMode(0);
                                                                        }
                                                                        piVectorArray = psXmlNode12.getAttribute("filter");
                                                                        if (piVectorArray == null) break block275;
                                                                        if (!piVectorArray.equals("direct")) break block276;
                                                                        pgJvxSrc.setFilterType(0);
                                                                        break block253;
                                                                    }
                                                                    if (piVectorArray.equals("linear")) {
                                                                        pgJvxSrc.setFilterType(1);
                                                                        break block253;
                                                                    } else if (piVectorArray.equals("quadratic")) {
                                                                        pgJvxSrc.setFilterType(2);
                                                                        break block253;
                                                                    } else {
                                                                        PsDebug.warning((String)("Unknown texture attribute: filter = " + (String)piVectorArray));
                                                                    }
                                                                    break block253;
                                                                }
                                                                pgJvxSrc.setFilterType(0);
                                                            }
                                                            string4 = psXmlNode12.getAttribute("side");
                                                            if (string4 == null) break block277;
                                                            if (!string4.equals("both")) break block278;
                                                            pgJvxSrc.setTextureSide(3);
                                                            break block254;
                                                        }
                                                        if (string4.equals("front")) {
                                                            pgJvxSrc.setTextureSide(1);
                                                            break block254;
                                                        } else if (string4.equals("back")) {
                                                            pgJvxSrc.setTextureSide(2);
                                                            break block254;
                                                        } else {
                                                            PsDebug.warning((String)("Unknown texture attribute: side = " + string4));
                                                        }
                                                        break block254;
                                                    }
                                                    pgJvxSrc.setTextureSide(3);
                                                }
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode12, (String)"t", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setVertexTextures(pdVectorArray2);
                                                }
                                                if ((object2 = psXmlNode12.getChild("image")) != null) {
                                                    PsXmlNode psXmlNode18 = PsXmlSrc.getRsrcNode((PsXmlNode)object2, (String)"url");
                                                    if (psXmlNode18 != null) {
                                                        object4 = psXmlNode18.getContent();
                                                    } else {
                                                        object4 = object2.getContent();
                                                        if (object4 != null) {
                                                            PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                        }
                                                    }
                                                    psXmlNode6 = object2.getAttribute("repeat");
                                                    if (psXmlNode6 != null && !"no".equals(psXmlNode6)) {
                                                        PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                    }
                                                    if (object4 != null) {
                                                        pgJvxSrc.setTextureImageName((String)object4);
                                                    }
                                                }
                                                if ((psXmlNode11 = psXmlNode12.getChild("imageCoords")) != null && (psXmlNode6 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode11, (String)"p", null)) != null) {
                                                    pgJvxSrc.setTextureImageBnd((PdVector[])psXmlNode6);
                                                }
                                            }
                                            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode10, (String)"thicknesses")) != null && (pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)object, (String)"th", null)) != null) {
                                                piVectorArray = new PdVector(pdVectorArray2.length);
                                                for (n3 = 0; n3 < pdVectorArray2.length; ++n3) {
                                                    piVectorArray.setEntry(n3, pdVectorArray2[n3].getEntry(0));
                                                }
                                                pgJvxSrc.setVertexSizes((PdVector)piVectorArray);
                                            }
                                        }
                                        if ((string5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"lineSet")) != null) {
                                            Color[] colorArray;
                                            PsXmlNode psXmlNode19;
                                            pgJvxSrc.showPolygonStartArrow(PgJvfLoader.parseVisibility(string5.getAttribute("arrowStart")) == 1);
                                            pgJvxSrc.showPolygonEndArrow(PgJvfLoader.parseVisibility(string5.getAttribute("arrow")) == 1);
                                            pgJvxSrc.showPolygons(PgJvfLoader.parseVisibility(string5.getAttribute("line")) != 0);
                                            boolean bl = PgJvfLoader.parseVisibility(string5.getAttribute("color")) == 1;
                                            boolean bl3 = PgJvfLoader.parseVisibility(string5.getAttribute("colorFromPoints")) == 1;
                                            pgJvxSrc.showPolygonColors(bl);
                                            pgJvxSrc.showElementColorFromVertices(bl3);
                                            if (!bl && bl3 && PgJvfLoader.parseVisibility(string5.getAttribute("color")) == -1) {
                                                PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.50 or later.");
                                                pgJvxSrc.showPolygonColors(true);
                                            }
                                            pgJvxSrc.showPolygonNormals(PgJvfLoader.parseVisibility(string5.getAttribute("normal")) == 1);
                                            pgJvxSrc.showPolygonNormalArrow(PgJvfLoader.parseVisibility(string5.getAttribute("normalArrow")) == 1);
                                            pgJvxSrc.showPolygonSizes(PgJvfLoader.parseVisibility(string5.getAttribute("thicknesses")) == 1);
                                            pgJvxSrc.showSmoothElementColors(PgJvfLoader.parseVisibility(string5.getAttribute("colorSmooth")) == 1);
                                            pgJvxSrc.showTaggedPolygons(PgJvfLoader.parseVisibility(string5.getAttribute("lineMark")) != 0);
                                            pgJvxSrc.setType(32);
                                            psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"lines");
                                            if (psXmlNode8 != null) {
                                                PiVector[] piVectorArray3 = PsXmlLoader.parseIntegerList((PsXmlNode)psXmlNode8, (String)"l", (String[])stringArray);
                                                if (piVectorArray3 != null) {
                                                    pgJvxSrc.setDimOfPolygons(-1);
                                                    pgJvxSrc.setNumPolygons(piVectorArray3.length);
                                                    pgJvxSrc.setPolygons(piVectorArray3);
                                                }
                                                if (psXmlNode8.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode8, "thickness");
                                                    pgJvxSrc.setGlobalPolygonSize(d);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalPolygonColor((Color)object3);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalPolygonTagColor((Color)object3);
                                                }
                                                if (psXmlNode8.hasChild("labelAtt")) {
                                                    object = psXmlNode8.getChild("labelAtt");
                                                    object5 = this.parseLabelAtt(psXmlNode8);
                                                    if (object5 != null) {
                                                        pgJvxSrc.setLabelAttribute(2, (PiVector)object5);
                                                        pgJvxSrc.showPolygonLabels(object5.getEntry(5) == 1);
                                                    }
                                                    if (object.hasChild("color")) {
                                                        piVectorArray = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color");
                                                        pgJvxSrc.setLabelColor(2, (Color)piVectorArray);
                                                    }
                                                }
                                            }
                                            if ((psXmlNode19 = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)psXmlNode19, (String)"c")) != null) {
                                                pgJvxSrc.setPolygonColors(colorArray);
                                            }
                                            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"normals")) != null) {
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)object, (String)"n", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setPolygonNormals(pdVectorArray2);
                                                }
                                                if (object.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "thickness");
                                                    pgJvxSrc.setGlobalPolygonNormalSize(d);
                                                }
                                                if (object.hasChild("length")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "length");
                                                    pgJvxSrc.setGlobalPolygonNormalLength(d);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalPolygonNormalColor((Color)object3);
                                                }
                                            }
                                            if ((piVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"thicknesses")) != null && (pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray, (String)"th", null)) != null) {
                                                string4 = new PdVector(pdVectorArray2.length);
                                                for (n3 = 0; n3 < pdVectorArray2.length; ++n3) {
                                                    string4.setEntry(n3, pdVectorArray2[n3].getEntry(0));
                                                }
                                                pgJvxSrc.setPolygonSizes((PdVector)string4);
                                            }
                                        }
                                        if ((psXmlNode9 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"faceSet")) != null) {
                                            PdVector[] pdVectorArray3;
                                            boolean bl;
                                            Color[] colorArray;
                                            PsXmlNode psXmlNode20;
                                            Color[] colorArray2;
                                            pgJvxSrc.showElements(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("face")) != 0);
                                            pgJvxSrc.showEdges(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("edge")) != 0);
                                            pgJvxSrc.showElementNormals(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("normal")) == 1);
                                            pgJvxSrc.showElementNormalArrow(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("normalArrow")) == 1);
                                            boolean bl4 = PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("color")) == 1;
                                            boolean bl5 = PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorFromPoints")) == 1;
                                            pgJvxSrc.showElementColors(bl4);
                                            pgJvxSrc.showElementColorFromVertices(bl5);
                                            if (!bl4 && bl5 && PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("color")) == -1) {
                                                PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.50 or later.");
                                                pgJvxSrc.showElementColors(true);
                                            }
                                            pgJvxSrc.showElementBackColor(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorBackGlobal")) == 1);
                                            pgJvxSrc.showElementBackColors(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorBackLocal")) == 1);
                                            pgJvxSrc.showSmoothElementColors(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorSmooth")) == 1);
                                            pgJvxSrc.showEdgeColors(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorEdge")) == 1);
                                            pgJvxSrc.showEdgeColorFromElements(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("colorEdgeInduced")) == 1);
                                            boolean bl6 = PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("backface")) != 0;
                                            pgJvxSrc.showBackface(bl6);
                                            pgJvxSrc.showBoundaries(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("boundary")) == 1);
                                            pgJvxSrc.showSilhouette(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("silhouette")) == 1);
                                            pgJvxSrc.showTaggedElements(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("faceMark")) != 0);
                                            pgJvxSrc.showTaggedElements(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("faceMark")) != 0);
                                            pgJvxSrc.setType(33);
                                            object = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"faces");
                                            if (object != null) {
                                                piVectorArray = PsXmlLoader.parseIntegerList((PsXmlNode)object, (String)"f", (String[])stringArray);
                                                if (piVectorArray != null) {
                                                    pgJvxSrc.setDimOfElements(-1);
                                                    pgJvxSrc.setNumElements(piVectorArray.length);
                                                    pgJvxSrc.setElements(piVectorArray);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalElementColor((Color)object3);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"colorBack")) != null) {
                                                    pgJvxSrc.setGlobalElementBackColor((Color)object3);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalElementTagColor((Color)object3);
                                                }
                                                if (object.hasChild("creaseAngle")) {
                                                    double d6 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "creaseAngle");
                                                    pgJvxSrc.setCreaseAngle(d6);
                                                }
                                                if (object.hasChild("labelAtt")) {
                                                    PsXmlNode psXmlNode21 = object.getChild("labelAtt");
                                                    object5 = this.parseLabelAtt(psXmlNode21);
                                                    if (object5 != null) {
                                                        pgJvxSrc.setLabelAttribute(3, (PiVector)object5);
                                                        pgJvxSrc.showElementLabels(object5.getEntry(5) == 1);
                                                    }
                                                    if (psXmlNode21.hasChild("color")) {
                                                        object2 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode21, (String)"color");
                                                        pgJvxSrc.setLabelColor(3, (Color)object2);
                                                    }
                                                }
                                            }
                                            if ((piVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"neighbours")) != null) {
                                                PiVector[] piVectorArray4 = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray, (String)"nb", null);
                                                if (piVectorArray4 != null) {
                                                    pgJvxSrc.setNeighbours(piVectorArray4);
                                                }
                                            } else {
                                                this.m_bIsEnabledOptimization = true;
                                            }
                                            string4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"edges");
                                            if (string4 != null) {
                                                piVectorArray2 = PsXmlLoader.parseIntegerList((PsXmlNode)string4, (String)"e", null);
                                                if (piVectorArray2 != null) {
                                                    pgJvxSrc.setEdges(piVectorArray2);
                                                }
                                                if (string4.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)string4, "thickness");
                                                    pgJvxSrc.setGlobalEdgeSize(d);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)string4, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalEdgeColor((Color)object3);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)string4, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalEdgeTagColor((Color)object3);
                                                }
                                                if ((object2 = string4.getChild("labelAtt")) != null) {
                                                    object5 = this.parseLabelAtt((PsXmlNode)object2);
                                                    if (object5 != null) {
                                                        pgJvxSrc.setLabelAttribute(1, (PiVector)object5);
                                                        pgJvxSrc.showEdgeLabels(object5.getEntry(5) == 1);
                                                    }
                                                    if (object2.hasChild("color")) {
                                                        Color color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, (String)"color");
                                                        pgJvxSrc.setLabelColor(1, color);
                                                    }
                                                }
                                            }
                                            if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"colors")) != null && (colorArray2 = PsXmlLoader.parseColorList((PsXmlNode)object2, (String)"c")) != null) {
                                                pgJvxSrc.setElementColors(colorArray2);
                                            }
                                            if ((psXmlNode20 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"colorsBack")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)psXmlNode20, (String)"c")) != null) {
                                                pgJvxSrc.setElementBackColors(colorArray);
                                            }
                                            if ((psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"normals")) != null) {
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode6, (String)"n", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setElementNormals(pdVectorArray2);
                                                }
                                                if (psXmlNode6.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode6, "thickness");
                                                    pgJvxSrc.setGlobalElementNormalSize(d);
                                                }
                                                if (psXmlNode6.hasChild("length")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode6, "length");
                                                    pgJvxSrc.setGlobalElementNormalLength(d);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode6, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalElementNormalColor((Color)object3);
                                                }
                                            } else if ((!bl6 || pgJvxSrc.isShowingElementNormals()) && pgJvxSrc.getDimOfVertices() == 3) {
                                                pgJvxSrc.makeElementNormals();
                                            }
                                            PsXmlNode psXmlNode22 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"textures");
                                            boolean bl7 = bl = PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("texture")) == 1;
                                            if (psXmlNode22 != null) {
                                                pgJvxSrc.showElementTexture(bl);
                                            } else {
                                                pgJvxSrc.showVertexTexture(bl);
                                            }
                                            if (psXmlNode22 != null) {
                                                PdVector[] pdVectorArray4;
                                                PiVector[] piVectorArray5;
                                                PdVector[][] pdVectorArray5;
                                                pdVectorArray3 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode22, (String)"t", null);
                                                int n10 = pgJvxSrc.getNumElements();
                                                if (pdVectorArray3 != null && n10 > 0) {
                                                    pgJvxSrc.assureElementTextures();
                                                    pdVectorArray5 = pgJvxSrc.getElementTextures();
                                                    n5 = 0;
                                                    piVectorArray5 = pgJvxSrc.getElements();
                                                    for (n3 = 0; n3 < n10; ++n3) {
                                                        int n11 = piVectorArray5[n3].getSize();
                                                        for (int i = 0; i < n11; ++i) {
                                                            pdVectorArray5[n3][i].copy(pdVectorArray3[n5++]);
                                                        }
                                                    }
                                                    if (n5 != pdVectorArray3.length) {
                                                        PsDebug.warning((String)"element texture coordinates do not match elements.");
                                                        pgJvxSrc.setElementTextures((PdVector[][])null);
                                                    } else {
                                                        pgJvxSrc.setVertexTextures(null);
                                                    }
                                                }
                                                if ((pdVectorArray5 = psXmlNode22.getChild("image")) != null) {
                                                    piVectorArray5 = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray5, (String)"url");
                                                    if (piVectorArray5 != null) {
                                                        object4 = piVectorArray5.getContent();
                                                    } else {
                                                        object4 = pdVectorArray5.getContent();
                                                        if (object4 != null) {
                                                            PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                        }
                                                    }
                                                    String string15 = pdVectorArray5.getAttribute("repeat");
                                                    if (string15 != null && !"no".equals(string15)) {
                                                        PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                    }
                                                    if (object4 != null) {
                                                        pgJvxSrc.setTextureImageName((String)object4);
                                                    }
                                                }
                                                if ((piVectorArray5 = psXmlNode22.getChild("imageCoords")) != null && (pdVectorArray4 = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray5, (String)"p", null)) != null) {
                                                    pgJvxSrc.setTextureImageBnd(pdVectorArray4);
                                                }
                                            }
                                            if ((pdVectorArray3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"boundaries")) != null) {
                                                if (pdVectorArray3.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)pdVectorArray3, "thickness");
                                                    pgJvxSrc.setGlobalBndSize(d);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)pdVectorArray3, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalBndColor((Color)object3);
                                                }
                                                if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)pdVectorArray3, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalBndTagColor((Color)object3);
                                                }
                                            }
                                        }
                                        if ((pdVectorArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNodeArray[n], (String)"vectorField")) != null && pdVectorArray.length > 0) {
                                            pgJvxSrc.setNumVectorFields(pdVectorArray.length);
                                            pgJvxSrc.showVectorFields(true);
                                            for (n4 = 0; n4 < pdVectorArray.length; ++n4) {
                                                Color[] colorArray;
                                                pgJvxSrc.setVectorFieldName(n4, pdVectorArray[n4].getAttribute("name"));
                                                String string16 = pdVectorArray[n4].getAttribute("base");
                                                if (string16 != null) {
                                                    pgJvxSrc.setVectorElementBased(n4, string16.equals("element"));
                                                }
                                                pgJvxSrc.showVectorField(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("vector")) != 0);
                                                pgJvxSrc.showVectorFieldMaterials(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("material")) != 0);
                                                pgJvxSrc.showVectorArrows(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("arrow")) == 1);
                                                pgJvxSrc.showVectorColors(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("color")) == 1);
                                                PsXmlNode psXmlNode23 = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray[n4], (String)"vectors");
                                                if (psXmlNode23 != null) {
                                                    pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode23, (String)"v", (String[])stringArray);
                                                    if (pdVectorArray2 != null && (n5 = pdVectorArray2.length) > 0) {
                                                        pgJvxSrc.setNumVectors(n4, n5, pdVectorArray2[0].getSize());
                                                        pgJvxSrc.setVectors(n4, pdVectorArray2);
                                                    }
                                                    if (psXmlNode23.hasChild("thickness")) {
                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode23, "thickness");
                                                        pgJvxSrc.setGlobalVectorSize(n4, d);
                                                    }
                                                    if (psXmlNode23.hasChild("length")) {
                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode23, "length");
                                                        pgJvxSrc.setGlobalVectorLength(n4, d);
                                                    }
                                                    if ((object3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode23, (String)"color")) != null) {
                                                        pgJvxSrc.setGlobalVectorColor(n4, (Color)object3);
                                                    }
                                                }
                                                if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray[n4], (String)"colors")) == null || (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object, (String)"c")) == null) continue;
                                                pgJvxSrc.setVectorColors(n4, colorArray);
                                            }
                                        }
                                        if ((psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"primitive")) != null) {
                                            PsDebug.warning((String)"parsing of primitives not implemented yet.");
                                        }
                                        if ((psXmlNode7 = psXmlNodeArray[n].getChild("transform")) == null) break block279;
                                        if (psXmlNode7.hasChild("modelMat") && (object = PsXmlLoader.parsePdMatrix((PsXmlNode)psXmlNode7, (String)"modelMat")) != null) {
                                            pgJvxSrc.setModelMatrix((PdMatrix)object);
                                        }
                                        if ((object = psXmlNode7.getChild("ambient")) == null) break block279;
                                        piVectorArray = object.getAttribute("dim");
                                        string4 = object.getAttribute("space");
                                        object2 = object.getAttribute("projection");
                                        if (string4 == null || piVectorArray == null || object2 == null) break block255;
                                        n2 = Integer.parseInt((String)piVectorArray);
                                        if (!string4.equalsIgnoreCase("euclidean")) break block280;
                                        if (n2 == 1) {
                                            pgJvxSrc.setAmbientSpace(0);
                                        } else if (n2 == 2) {
                                            pgJvxSrc.setAmbientSpace(1);
                                        } else if (n2 == 3) {
                                            pgJvxSrc.setAmbientSpace(3);
                                        } else if (n2 == 4) {
                                            pgJvxSrc.setAmbientSpace(6);
                                        } else {
                                            if (n2 != 5) {
                                                PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                                return null;
                                            }
                                            pgJvxSrc.setAmbientSpace(9);
                                        }
                                        if (((String)object2).equalsIgnoreCase("parallel")) {
                                            pgJvxSrc.setAmbientProjection(0);
                                            break block255;
                                        } else {
                                            if (!((String)object2).equalsIgnoreCase("stereographic")) {
                                                PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                                return null;
                                            }
                                            pgJvxSrc.setAmbientProjection(1);
                                        }
                                        break block255;
                                    }
                                    if (!string4.equalsIgnoreCase("spherical")) break block281;
                                    if (n2 == 2) {
                                        pgJvxSrc.setAmbientSpace(2);
                                    } else if (n2 == 3) {
                                        pgJvxSrc.setAmbientSpace(4);
                                    } else if (n2 == 4) {
                                        pgJvxSrc.setAmbientSpace(7);
                                    } else {
                                        if (n2 != 5) {
                                            PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                            return null;
                                        }
                                        pgJvxSrc.setAmbientSpace(10);
                                    }
                                    if (((String)object2).equalsIgnoreCase("parallel")) {
                                        pgJvxSrc.setAmbientProjection(0);
                                        break block255;
                                    } else {
                                        if (!((String)object2).equalsIgnoreCase("stereographic")) {
                                            PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                            return null;
                                        }
                                        pgJvxSrc.setAmbientProjection(1);
                                    }
                                    break block255;
                                }
                                if (!string4.equalsIgnoreCase("hyperbolic")) break block282;
                                if (n2 == 3) {
                                    pgJvxSrc.setAmbientSpace(5);
                                } else if (n2 == 4) {
                                    pgJvxSrc.setAmbientSpace(8);
                                } else {
                                    if (n2 != 5) {
                                        PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                        return null;
                                    }
                                    pgJvxSrc.setAmbientSpace(11);
                                }
                                if (!((String)object2).equalsIgnoreCase("parallel")) break block283;
                                pgJvxSrc.setAmbientProjection(0);
                                break block255;
                            }
                            if (((String)object2).equalsIgnoreCase("poincare")) {
                                pgJvxSrc.setAmbientProjection(1);
                                break block255;
                            } else if (((String)object2).equalsIgnoreCase("klein")) {
                                pgJvxSrc.setAmbientProjection(2);
                                break block255;
                            } else {
                                if (!((String)object2).equalsIgnoreCase("uhs")) {
                                    PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                    return null;
                                }
                                pgJvxSrc.setAmbientProjection(3);
                            }
                            break block255;
                        }
                        if (string4.equalsIgnoreCase("lorentz")) {
                            PsDebug.warning((String)("not implemented yet, ambient space = " + string4));
                            return null;
                        }
                        PsDebug.warning((String)("unknown ambient space = " + string4));
                        return null;
                    }
                    PdMatrix pdMatrix = PsXmlLoader.parsePdMatrix((PsXmlNode)object, (String)"ambientMat");
                    psXmlNode6 = PsXmlLoader.parsePdMatrix((PsXmlNode)object, (String)"ambientInvMat");
                    if (pdMatrix != null && psXmlNode6 != null) {
                        pgJvxSrc.setAmbientMatrix(pdMatrix, (PdMatrix)psXmlNode6);
                    }
                }
                pgGeometryIfArray[n].setJvx(pgJvxSrc);
            }
            ++n;
        }
    }

    protected static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    protected static int parseFlag(PsXmlNode psXmlNode) {
        String string = psXmlNode.getAttribute("value");
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("true")) {
            return 1;
        }
        return 0;
    }

    protected static int parseDimension(PsXmlNode psXmlNode, int n) {
        String string = psXmlNode.getAttribute("dim");
        if (string == null) {
            PsDebug.warning((String)("missing dimension of node " + String.valueOf(psXmlNode.getClass())));
            return n;
        }
        return Integer.parseInt(string);
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        Object object;
        Object object2;
        PsXmlNode psXmlNode;
        PsXmlNode psXmlNode2;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            return null;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jvf-model");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvf-model");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jvf.dtd");
        if (bl) {
            psXmlNode = psXmlNode2.addChild("meta");
            psXmlNode.addAttribute("generator", PsConfig.getProgramAndVersion());
            psXmlNode = psXmlNode2.addChild("meta");
            object2 = PsConfig.getVersion((int)14);
            object = String.valueOf((int)object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf((int)object2[1]);
            if (object2[2] != false) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf((int)object2[2]);
            }
            psXmlNode.addAttribute("dtd", (String)object);
            psXmlNode = psXmlNode2.addChild("meta");
            psXmlNode.addAttribute("date", new Date().toString());
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("version", pgJvxSrc.getVersion());
            psXmlNode3.addAttribute("type", pgJvxSrc.getVersionType());
            if (pgJvxSrc.getTitle() != null) {
                psXmlNode2.addChild("title", pgJvxSrc.getTitle());
            } else {
                psXmlNode2.addChild("title", pgJvxSrc.getName());
            }
        }
        if (bl2 && (psXmlNode = pgJvxSrc.getAuthorInfo()) != null && psXmlNode.getNumAuthors() > 0 && (object2 = psXmlNode.getXmlNode()) != null) {
            psXmlNode2.addChild(object2);
        }
        if (bl3 && (psXmlNode = pgJvxSrc.getGeometryInfo()) != null && (object2 = psXmlNode.getXmlNode()) != null) {
            psXmlNode2.addChild(object2);
        }
        object2 = psXmlNode2.addChild("geometries");
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            pgJvxSrc = pgJvxSrcArray[i];
            object = object2.addChild("geometry");
            object.addAttribute("name", pgJvxSrc.getName());
            if (!pgJvxSrc.isVisible()) {
                object.addAttribute("visible", "hide");
            }
            if (pgJvxSrc.getType() != -1) continue;
            PsDebug.error((String)("geom = " + pgJvxSrc.getName() + " has unknown geometry type, JVF may not conform to jvf.dtd."));
        }
        return psXmlSrc;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode, (String)string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            String string2 = psXmlNodeArray[i].getContent();
            if (string2 == null) continue;
            String[] stringArray3 = PuString.splitString((String)string2, (char)' ');
            stringArray2[i] = new String[stringArray3.length];
            for (int j = 0; j < stringArray3.length; ++j) {
                stringArray2[i][j] = stringArray3[j];
            }
        }
        return stringArray2;
    }

    protected PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(6);
        String string = psXmlNode.getAttribute("visible");
        if (string != null && "hide".equalsIgnoreCase(string)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string2 = psXmlNode.getAttribute("horAlign");
        if (string2 == null || "head".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 2);
        }
        String string3 = psXmlNode.getAttribute("verAlign");
        if ("bottom".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 0);
        } else if (string3 == null || "middle".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 2);
        } else if ("head".equalsIgnoreCase(string3)) {
            PsDebug.warning((String)"Encountered void use of attribute \"verAlign\".\n\tSave JVX file with a newer JavaView such as v.2.99.030");
            piVector.setEntry(3, 1);
        }
        String string4 = psXmlNode.getAttribute("font");
        if (string4 == null || "text".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 2);
        }
        try {
            PsXmlNode psXmlNode2;
            PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"xOffset");
            if (psXmlNode3 != null) {
                piVector.setEntry(0, Integer.parseInt(psXmlNode3.getContent()));
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(psXmlNode2.getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)"wrong format parsing offset");
            return null;
        }
        return piVector;
    }

    public static double getRsrcAsDoubleF(PsXmlNode psXmlNode, String string) {
        String string2 = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)string);
        if (PuString.isEmpty((String)string2)) {
            PsDebug.notify((String)"missing content, return 0. as default.");
            return 0.0;
        }
        try {
            double d = new Double(string2);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Expr expr = Parser.parse((String)string2);
                Variable.make((String)"Pi").setValue(Math.PI);
                Variable.make((String)"pi").setValue(Math.PI);
                return expr.getValue();
            }
            catch (Syntax_error syntax_error) {
                PsDebug.warning((String)("wrong format, rsrc = " + string2));
                return 0.0;
            }
        }
    }
}

