/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;

public class PgPointSetOnPolygon
extends PgPointSet {
    protected PgPolygon m_geom;
    protected static final int m_dimOfBary = 2;
    protected PdBary[] m_vertexBary;
    static /* synthetic */ Class class$jvx$geom$PgPointSetOnPolygon;

    public PgPointSetOnPolygon(PgPolygon pgPolygon) {
        super(pgPolygon.getDimOfVertices());
        this.m_geom = pgPolygon;
        this.m_vertexBary = new PdBary[0];
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgPointSetOnPolygon == null ? (class$jvx$geom$PgPointSetOnPolygon = PgPointSetOnPolygon.class$("jvx.geom.PgPointSetOnPolygon")) : class$jvx$geom$PgPointSetOnPolygon)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public PgPolygon getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgPolygon pgPolygon) {
        this.m_geom = pgPolygon;
    }

    public Object clone() {
        PgPointSetOnPolygon pgPointSetOnPolygon = (PgPointSetOnPolygon)((Object)super.clone());
        if (pgPointSetOnPolygon == null) {
            return null;
        }
        if (this.m_geom != null) {
            pgPointSetOnPolygon.setGeometry(this.m_geom);
        }
        if (this.m_vertexBary != null) {
            pgPointSetOnPolygon.m_vertexBary = (PdBary[])P_Vector.clone((P_Vector[])this.m_vertexBary);
        }
        return pgPointSetOnPolygon;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPointSetOnPolygon)) {
            return;
        }
        PgPointSetOnPolygon pgPointSetOnPolygon = (PgPointSetOnPolygon)psObject;
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pgPointSetOnPolygon.getVertexBary(), (int)0, (int)this.m_numVertices);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPointSetOnPolygon)) {
            return false;
        }
        PgPointSetOnPolygon pgPointSetOnPolygon = (PgPointSetOnPolygon)pgGeometryIf;
        if (pgPointSetOnPolygon.m_geom != this.m_geom) {
            return false;
        }
        int n2 = pgPointSetOnPolygon.getNumVertices();
        PdBary.copy((PdBary[])this.m_vertexBary, (int)n, (PdBary[])pgPointSetOnPolygon.m_vertexBary, (int)0, (int)n2);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPointSetOnPolygon) || !(pgGeometry2 instanceof PgPointSetOnPolygon)) {
            return false;
        }
        PgPointSetOnPolygon pgPointSetOnPolygon = (PgPointSetOnPolygon)pgGeometry;
        PgPointSetOnPolygon pgPointSetOnPolygon2 = (PgPointSetOnPolygon)pgGeometry2;
        int n = pgPointSetOnPolygon.getNumVertices();
        for (int i = 0; i < n; ++i) {
            pgPointSetOnPolygon.m_vertexBary[i].blend(d, pgPointSetOnPolygon.m_vertexBary[i], d2, pgPointSetOnPolygon2.m_vertexBary[i]);
        }
        return true;
    }

    public void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        if (this.isEnabledInstanceSharing()) {
            return;
        }
        this.m_vertexBary = PdBary.realloc((PdBary[])this.m_vertexBary, (int)n, (int)2);
    }

    public PdBary[] getVertexBary() {
        return this.m_vertexBary;
    }

    public void setVertexBary(PdBary[] pdBaryArray) {
        if ((pdBaryArray == null || pdBaryArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdBaryArray == null || pdBaryArray.length == 0 || pdBaryArray.length < this.m_numVertices) {
            PsDebug.warning((String)"void length of argument vertexBary array");
            return;
        }
        if (pdBaryArray[0] == null || this.m_geom != null && pdBaryArray[0].getSize() != 2) {
            PsDebug.warning((String)"wrong dimension at least of first argument vertexBary.");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexBary = pdBaryArray;
            return;
        }
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pdBaryArray, (int)0, (int)this.m_numVertices);
    }

    public PdBary getVertexBary(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return null;
        }
        return this.m_vertexBary[n];
    }

    public int getVertexElemInd(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_vertexBary[n].m_elementInd;
    }

    public void setVertexBary(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return;
        }
        if (n2 < 0 || this.m_geom != null && n2 >= this.m_geom.getNumEdges()) {
            PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
            return;
        }
        if (this.m_geom != null) {
            PdVector pdVector = this.m_geom.getVertex(n2);
            PdVector pdVector2 = this.m_geom.getVertex(n2 + 1);
            pdBary.getVertex(this.m_vertex[n], pdVector, pdVector2);
        }
        this.m_vertexBary[n].copy(pdBary);
        this.m_vertexBary[n].setElementInd(n2);
    }

    public void setVertexBary(int n, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        this.setVertexBary(n, pdBary.getElementInd(), pdBary);
    }

    public void computeVertices() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (this.m_numVertices == 0) {
            return;
        }
        for (int i = 0; i < this.m_numVertices; ++i) {
            int n = this.m_vertexBary[i].getElementInd();
            if (n == -1) {
                PsDebug.warning((String)("Missing element index in vertexBary[" + i + "]"));
                return;
            }
            PdVector pdVector = this.m_geom.getVertex(n);
            PdVector pdVector2 = this.m_geom.getVertex(n + 1);
            this.m_vertexBary[i].getVertex(this.m_vertex[i], pdVector, pdVector2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

