/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.gui;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.vecmath.PdVector;
import jvx.gui.PuHistogram;

public class PaHistogram
extends Applet
implements ActionListener {
    protected Frame m_frame;
    protected PuHistogram m_histogram;
    protected Button m_bStart;
    protected PdVector m_samples;

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\nAuthor: Konrad Polthier\r\nVersion: 1.00\r\nApplet shows usage of histogram\r\n";
    }

    public void init() {
        PsConfig.init((Applet)this, (Frame)this.m_frame);
        this.setLayout(new BorderLayout());
        Label label = new Label("Demo of Histogram");
        label.setFont(PsConfig.getFont((int)4));
        this.add((Component)label, "North");
        this.m_histogram = new PuHistogram("Tutorial Histogram", null);
        this.m_histogram.setClassType(0);
        this.m_histogram.setCountType(0);
        this.m_histogram.setEnabledSampleBnd(true);
        this.m_histogram.setSampleBnd(-4.0, 4.0);
        this.m_histogram.setNumBins(20);
        this.computeSamples();
        this.m_histogram.update((Object)this.m_histogram);
        this.add((Component)this.m_histogram.getInfoPanel(), "Center");
        Panel panel = new Panel(new FlowLayout());
        this.m_bStart = new Button("New Random Set");
        this.m_bStart.addActionListener(this);
        panel.add(this.m_bStart);
        this.add((Component)panel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bStart) {
            this.computeSamples();
            this.m_histogram.update((Object)this.m_histogram);
        }
    }

    private void computeSamples() {
        int n = 5000;
        this.m_samples = new PdVector(n);
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            do {
                d2 = Math.random();
                d = Math.random();
            } while (Math.abs(d3 = Math.sqrt(-2.0 * Math.log(d2)) * Math.cos(Math.PI * 2 * d)) > 10.0);
            this.m_samples.setEntry(i, d3);
        }
        this.m_histogram.setSamples(this.m_samples);
        this.m_histogram.setTitle("Demo Histogram");
        this.m_histogram.setXAxisLabel("Random Numbers");
    }

    public static void main(String[] stringArray) {
        PaHistogram paHistogram = new PaHistogram();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paHistogram, stringArray);
        psMainFrame.setOuterBounds(420, 5, 600, 450);
        paHistogram.m_frame = psMainFrame;
        paHistogram.init();
        ((Component)paHistogram.m_frame).setVisible(true);
    }
}

