/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import java.util.Vector;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public abstract class PgWeierstrassDescr
extends PsObject {
    public static final int REFLECT_PLANE = 0;
    public static final int REFLECT_LINE = 1;
    protected PuInteger[] m_numLines;
    protected int m_vertDim;
    protected int m_numParts;
    public int m_numUserReflections;
    protected int m_markedBndNr;
    protected int[][] m_userReflections;
    static int m_reflectPartNr;
    static int m_partBndNr;
    protected Vector m_parm;
    protected PuDouble m_conjugation;
    protected PuInteger m_intDiscr;
    protected PiVector[] m_refl;
    protected PiVector[][] m_conn;
    protected boolean m_bMarkBnd;
    protected int m_numIntegratedPatches = 1;
    protected PdVector m_uMin;
    protected PdVector m_uMax;
    protected PdVector m_vMin;
    protected PdVector m_vMax;
    protected boolean m_bShowDomain = false;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrassDescr;

    public PgWeierstrassDescr(int n) {
        this(n, 2);
    }

    public PgWeierstrassDescr(int n, int n2) {
        this.setName("Minimal Surface");
        this.m_numLines = new PuInteger[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_numLines[i] = new PuInteger("Number of Lines " + (i + 1), (PsUpdateIf)this);
        }
        if (n2 == 2) {
            this.m_numLines[0].setName("Number u-Lines");
            this.m_numLines[1].setName("Number v-Lines");
        }
        this.m_parm = new Vector();
        this.m_intDiscr = new PuInteger("Integration Accuracy", (PsUpdateIf)this);
        this.m_conjugation = new PuDouble("Conjugation", (PsUpdateIf)this);
        this.m_bMarkBnd = false;
        this.m_numIntegratedPatches = n;
        this.m_uMin = new PdVector(this.m_numIntegratedPatches);
        this.m_uMax = new PdVector(this.m_numIntegratedPatches);
        this.m_vMin = new PdVector(this.m_numIntegratedPatches);
        this.m_vMax = new PdVector(this.m_numIntegratedPatches);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrassDescr == null ? (class$vgp$minimal$weier$PgWeierstrassDescr = PgWeierstrassDescr.class$("vgp.minimal.weier.PgWeierstrassDescr")) : class$vgp$minimal$weier$PgWeierstrassDescr)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_intDiscr.setDefBounds(1, 100, 1, 10);
        this.m_intDiscr.setDefValue(10);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.m_markedBndNr = -1;
        this.m_numUserReflections = 0;
    }

    public boolean update(Object object) {
        for (int i = 0; i < this.m_numLines.length; ++i) {
            if (object != this.m_numLines[i]) continue;
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_intDiscr) {
            return this.m_parent.update((Object)this.m_intDiscr);
        }
        if (object == this.m_conjugation) {
            return this.m_parent.update((Object)this.m_conjugation);
        }
        if (object == null) {
            this.m_markedBndNr = -1;
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public void setNumIntegratedPatches(int n) {
        this.m_numIntegratedPatches = n;
        this.m_uMin.setSize(this.m_numIntegratedPatches);
        this.m_uMax.setSize(this.m_numIntegratedPatches);
        this.m_vMin.setSize(this.m_numIntegratedPatches);
        this.m_vMax.setSize(this.m_numIntegratedPatches);
    }

    public int getNumIntegratedPatches() {
        return this.m_numIntegratedPatches;
    }

    public void setDomain(int n, double d, double d2, double d3, double d4) {
        this.m_uMin.m_data[n] = d;
        this.m_uMax.m_data[n] = d2;
        this.m_vMin.m_data[n] = d3;
        this.m_vMax.m_data[n] = d4;
    }

    public int getNumULines(int n) {
        return this.m_numLines[0].getValue();
    }

    public int getNumVLines(int n) {
        return this.m_numLines[1].getValue();
    }

    public void setUMin(int n, double d) {
        this.m_uMin.m_data[n] = d;
    }

    public double getUMin(int n) {
        return this.m_uMin.m_data[n];
    }

    public void setUMax(int n, double d) {
        this.m_uMax.m_data[n] = d;
    }

    public double getUMax(int n) {
        return this.m_uMax.m_data[n];
    }

    public void setVMin(int n, double d) {
        this.m_vMin.m_data[n] = d;
    }

    public double getVMin(int n) {
        return this.m_vMin.m_data[n];
    }

    public void setVMax(int n, double d) {
        this.m_vMax.m_data[n] = d;
    }

    public double getVMax(int n) {
        return this.m_vMax.m_data[n];
    }

    public void addParameter(PsObject psObject) {
        this.m_parm.addElement(psObject);
    }

    public void setVertDim(int n) {
        this.m_vertDim = n;
    }

    public PuComplex[] fun(PuComplex puComplex) {
        PuComplex puComplex2 = this.f(puComplex);
        PuComplex puComplex3 = this.g(puComplex);
        PuComplex[] puComplexArray = new PuComplex[]{PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.sub((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.sqr((PuComplex)puComplex3))), PuComplex.mult((PuComplex)PuComplex.I, (PuComplex)PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.add((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.sqr((PuComplex)puComplex3)))), PuComplex.mult((PuComplex)PuComplex.mult((PuComplex)puComplex2, (PuComplex)puComplex3), (double)2.0)};
        return puComplexArray;
    }

    public PuComplex transform(PuComplex puComplex) {
        return puComplex;
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        return this.transform(puComplex);
    }

    public abstract PuComplex f(PuComplex var1);

    public abstract PuComplex g(PuComplex var1);

    public int getNumParts() {
        return 1;
    }

    public int getNumParts(PiVector piVector) {
        return this.getNumParts();
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return false;
    }

    public void getConnections() {
    }

    public void setConnections(PiVector[][] piVectorArray) {
        this.m_conn = piVectorArray;
    }

    public void getConnections(PiVector piVector) {
        this.getConnections();
    }

    public PiVector[][] getConnections(PiVector piVector, PiVector[][] piVectorArray, int n) {
        this.m_numParts = n;
        this.m_conn = piVectorArray;
        this.getConnections(piVector);
        for (int i = 0; i < this.m_numParts; ++i) {
            if (this.m_refl[i].m_data[0] <= -1 || !this.connectReflection(piVector, i)) continue;
            this.connectPart(i, this.m_refl[i].m_data[1], this.m_refl[i].m_data[0], this.m_refl[i].m_data[1]);
        }
        return this.m_conn;
    }

    public void connectPart(int n, int n2, int n3, int n4) {
        if (n < this.m_numParts && n3 < this.m_numParts) {
            this.m_conn[n][n2].m_data[0] = n3;
            this.m_conn[n][n2].m_data[1] = n4;
            this.m_conn[n3][n4].m_data[0] = n;
            this.m_conn[n3][n4].m_data[1] = n2;
        }
    }

    public PiVector[] getReflections(PiVector piVector, int n) {
        this.m_numParts = n;
        this.m_refl = PiVector.realloc(null, (int)n, (int)2);
        for (int i = 0; i < n; ++i) {
            this.m_refl[i].m_data[0] = -1;
        }
        this.getReflections(piVector);
        return this.m_refl;
    }

    public void returnUserReflections() {
        if (this.m_numUserReflections == 0) {
            return;
        }
        for (int i = 0; i < this.m_numUserReflections; ++i) {
            this.reflectPart(i + 1, this.m_userReflections[i][0], this.m_userReflections[i][1]);
        }
    }

    public void newReflection() {
        if (this.m_markedBndNr <= -1) {
            return;
        }
        int[][] nArray = new int[this.m_numUserReflections + 1][2];
        for (int i = 0; i < this.m_numUserReflections; ++i) {
            nArray[i][0] = this.m_userReflections[i][0];
            nArray[i][1] = this.m_userReflections[i][1];
        }
        nArray[this.m_numUserReflections][0] = m_reflectPartNr;
        nArray[this.m_numUserReflections][1] = m_partBndNr;
        this.m_userReflections = nArray;
        ++this.m_numUserReflections;
        this.m_markedBndNr = -1;
    }

    public void setReflection(PiVector[] piVectorArray) {
        this.m_refl = piVectorArray;
    }

    public void getReflections(PiVector piVector) {
        this.getReflections();
    }

    public void getReflections() {
    }

    public boolean connectReflection(int n) {
        return true;
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return this.connectReflection(n);
    }

    public void reflectPart(int n, int n2, int n3) {
        if (n < this.m_numParts && n2 < this.m_numParts) {
            this.m_refl[n].m_data[0] = n2;
            this.m_refl[n].m_data[1] = n3;
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
    }

    protected double getConjugationAngle() {
        return this.m_conjugation.getValue();
    }

    protected void setConjugationAngle(double d) {
        this.m_conjugation.setValue(d);
        this.update(this.m_conjugation);
    }

    public int getStartU(PiVector piVector, int n) {
        if (this.m_conn[n][3].m_data[0] < n && this.m_conn[n][3].m_data[0] > -1) {
            return 1;
        }
        return 0;
    }

    public int getStartV(PiVector piVector, int n) {
        if (this.m_conn[n][0].m_data[0] < n && this.m_conn[n][0].m_data[0] > -1) {
            return 1;
        }
        return 0;
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        for (int i = 0; i < this.m_vertDim; ++i) {
            puComplexArray[i] = PuComplex.ZERO;
        }
        return puComplexArray;
    }

    public PuComplex[] getFStart(PiVector piVector, int n) {
        return this.getFStart(n);
    }

    public int getMarkedBndNr() {
        return this.m_markedBndNr;
    }

    public void setMarkedBndNr(int n) {
        this.m_markedBndNr = n;
    }

    public void setReflectPartNr(int n) {
        m_reflectPartNr = n;
    }

    public void setPartBndNr(int n) {
        m_partBndNr = n;
    }

    public boolean isEnabledMarkBnd() {
        return this.m_bMarkBnd;
    }

    public void setEnabledMarkBnd(boolean bl) {
        this.m_bMarkBnd = bl;
    }

    public boolean equals(PiVector piVector, int n) {
        if (piVector == null || piVector.getSize() != 1) {
            return false;
        }
        return piVector.getEntry(0) == n;
    }

    public boolean equals(PiVector piVector, int n, int n2) {
        if (piVector == null || piVector.getSize() != 2) {
            return false;
        }
        return piVector.getEntry(0) == n && piVector.getEntry(1) == n2;
    }

    public boolean equals(PiVector piVector, int[] nArray) {
        if (piVector == null) {
            return nArray == null || nArray.length <= 0;
        }
        if (piVector.getSize() != nArray.length) {
            return false;
        }
        for (int i = 0; i < piVector.getSize(); ++i) {
            if (piVector.m_data[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isShowingDomain() {
        return this.m_bShowDomain;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

