/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.pointCloud;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import vgp.discrete.pointCloud.PjPointCloud;

public class PjPointCloud_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjPointCloud m_pjPointCloud;
    protected PsPanel m_pImport;
    protected PsPanel m_pSlider;
    protected Checkbox m_cUpdateNeigh;
    protected Checkbox m_cSharpCutoff;
    protected Checkbox m_cMaxValence;
    protected Checkbox m_cConstrainInterior;
    protected Checkbox m_cZDensity;
    protected Checkbox m_cAdjustMaxHue;
    protected Choice m_cModelChoices;
    protected TextField m_tMinNeigh;
    protected Button m_bReset;
    protected CheckboxGroup m_gColor;
    protected Checkbox[] m_cColor;
    static /* synthetic */ Class class$vgp$discrete$pointCloud$PjPointCloud_IP;

    public PjPointCloud_IP() {
        if (this.getClass() == (class$vgp$discrete$pointCloud$PjPointCloud_IP == null ? (class$vgp$discrete$pointCloud$PjPointCloud_IP = PjPointCloud_IP.class$("vgp.discrete.pointCloud.PjPointCloud_IP")) : class$vgp$discrete$pointCloud$PjPointCloud_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.m_pImport = new PsPanel();
        this.m_pImport.addTitle("Select Geometry:");
        this.m_cModelChoices = new Choice();
        this.m_cModelChoices.addItemListener(this);
        for (int i = 0; i < PjPointCloud.MODEL_NAMES.length; ++i) {
            this.m_cModelChoices.add(PjPointCloud.MODEL_NAMES[i]);
        }
        this.m_pImport.add(this.m_cModelChoices);
        ((Container)((Object)this)).add((Component)this.m_pImport);
        this.addLine(1);
        PsPanel psPanel = new PsPanel();
        psPanel.addTitle("Enable Properties");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 2));
        this.m_cUpdateNeigh = new Checkbox("Update Neighbours");
        this.m_cUpdateNeigh.addItemListener(this);
        panel.add(this.m_cUpdateNeigh);
        this.m_cSharpCutoff = new Checkbox("Sharp Cutoff");
        this.m_cSharpCutoff.addItemListener(this);
        panel.add(this.m_cSharpCutoff);
        this.m_cMaxValence = new Checkbox("Maximum Valence");
        this.m_cMaxValence.addItemListener(this);
        panel.add(this.m_cMaxValence);
        this.m_cConstrainInterior = new Checkbox("Constrain Interior");
        this.m_cConstrainInterior.addItemListener(this);
        panel.add(this.m_cConstrainInterior);
        this.m_cZDensity = new Checkbox("Z-Density");
        this.m_cZDensity.addItemListener(this);
        panel.add(this.m_cZDensity);
        this.m_cAdjustMaxHue = new Checkbox("Adjust Max Hue");
        this.m_cAdjustMaxHue.addItemListener(this);
        panel.add(this.m_cAdjustMaxHue);
        psPanel.add(panel);
        ((Container)((Object)this)).add((Component)psPanel);
        this.addLine(1);
        this.m_pSlider = new PsPanel();
        this.m_pSlider.addTitle("Parameters");
        ((Container)((Object)this)).add((Component)this.m_pSlider);
        PsPanel psPanel2 = new PsPanel();
        psPanel2.addTitle("Vertex Coloring");
        PsPanel psPanel3 = new PsPanel();
        psPanel3.setLayout(new GridLayout(3, 2));
        this.m_gColor = new CheckboxGroup();
        this.m_cColor = new Checkbox[6];
        this.m_cColor[0] = new Checkbox("Mean", this.m_gColor, false);
        this.m_cColor[0].addItemListener(this);
        psPanel3.add(this.m_cColor[0]);
        this.m_cColor[1] = new Checkbox("MeanAni", this.m_gColor, false);
        this.m_cColor[1].addItemListener(this);
        psPanel3.add(this.m_cColor[1]);
        this.m_cColor[2] = new Checkbox("MaxPrinc", this.m_gColor, false);
        this.m_cColor[2].addItemListener(this);
        psPanel3.add(this.m_cColor[2]);
        this.m_cColor[3] = new Checkbox("PrincQuotient", this.m_gColor, false);
        this.m_cColor[3].addItemListener(this);
        psPanel3.add(this.m_cColor[3]);
        this.m_cColor[4] = new Checkbox("Cov Quotient", this.m_gColor, false);
        this.m_cColor[4].addItemListener(this);
        psPanel3.add(this.m_cColor[4]);
        this.m_cColor[5] = new Checkbox("Max Cov", this.m_gColor, false);
        this.m_cColor[5].addItemListener(this);
        psPanel3.add(this.m_cColor[5]);
        psPanel2.add((Component)psPanel3);
        ((Container)((Object)this)).add((Component)psPanel2);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        Component component = new Label(PsConfig.getMessage((boolean)true, (int)24000, (String)"Min Neighbours"), 0);
        panel2.add(component);
        this.m_tMinNeigh = new TextField("-");
        panel2.add(this.m_tMinNeigh);
        ((Container)((Object)this)).add(panel2);
        component = new Panel();
        ((Container)component).setLayout(new FlowLayout(1));
        ((Container)((Object)this)).add(component);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        ((Container)component).add(this.m_bReset);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pjPointCloud = (PjPointCloud)psUpdateIf;
        this.m_cModelChoices.select(this.m_pjPointCloud.m_currentModel);
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_influence.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_maxValence.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_threshold.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_interior.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_quotient.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_zDensityLevel.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_maxHue.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjPointCloud.m_torusDensity.getInfoPanel());
        this.m_pSlider.validate();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)("PjPointCloud_IP.update: isShowing = " + ((Component)((Object)this)).isShowing()));
        if (this.m_pjPointCloud == object) {
            this.setTitle("Info of " + this.m_pjPointCloud.getName());
            PsPanel.setState((Checkbox)this.m_cUpdateNeigh, (boolean)this.m_pjPointCloud.m_bUpdateNeighbours);
            PsPanel.setState((Checkbox)this.m_cSharpCutoff, (boolean)this.m_pjPointCloud.m_bEnableCutoff);
            PsPanel.setState((Checkbox)this.m_cMaxValence, (boolean)this.m_pjPointCloud.m_bEnableMaxValence);
            PsPanel.setState((Checkbox)this.m_cConstrainInterior, (boolean)this.m_pjPointCloud.m_bConstrainInterior);
            PsPanel.setState((Checkbox)this.m_cZDensity, (boolean)this.m_pjPointCloud.m_bZDensity);
            PsPanel.setState((Checkbox)this.m_cAdjustMaxHue, (boolean)this.m_pjPointCloud.m_bRescaleHue);
            if (this.m_pjPointCloud.m_minNeighCnt == Integer.MAX_VALUE) {
                ((TextComponent)this.m_tMinNeigh).setText("0");
            } else {
                ((TextComponent)this.m_tMinNeigh).setText(String.valueOf(this.m_pjPointCloud.m_minNeighCnt));
            }
            Checkbox checkbox = this.m_gColor.getSelectedCheckbox();
            if (checkbox != this.m_cColor[this.m_pjPointCloud.m_vertexColorType]) {
                this.m_gColor.setSelectedCheckbox(this.m_cColor[this.m_pjPointCloud.m_vertexColorType]);
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjPointCloud == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_pjPointCloud.reset();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_pjPointCloud == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cModelChoices) {
            this.m_pjPointCloud.m_currentModel = this.m_cModelChoices.getSelectedIndex();
            this.m_pjPointCloud.setFileName(this.m_cModelChoices.getSelectedIndex());
            this.m_pjPointCloud.m_import.setFileName(this.m_pjPointCloud.m_fileName);
            this.m_pjPointCloud.m_import.start();
        } else if (object == this.m_cUpdateNeigh) {
            this.m_pjPointCloud.m_bUpdateNeighbours = this.m_cUpdateNeigh.getState();
        } else if (object == this.m_cSharpCutoff) {
            this.m_pjPointCloud.m_bEnableCutoff = this.m_cSharpCutoff.getState();
        } else if (object == this.m_cMaxValence) {
            this.m_pjPointCloud.m_bEnableMaxValence = this.m_cMaxValence.getState();
            this.m_pjPointCloud.m_maxValence.setEnabled(this.m_pjPointCloud.m_bEnableMaxValence);
        } else if (object == this.m_cConstrainInterior) {
            this.m_pjPointCloud.m_bConstrainInterior = this.m_cConstrainInterior.getState();
            this.m_pjPointCloud.m_interior.setEnabled(this.m_pjPointCloud.m_bConstrainInterior);
        } else {
            if (object == this.m_cZDensity) {
                this.m_pjPointCloud.m_bZDensity = this.m_cZDensity.getState();
                this.m_pjPointCloud.m_zDensityLevel.setEnabled(this.m_pjPointCloud.m_bZDensity);
                this.m_pjPointCloud.assureVertexSizes();
                this.m_pjPointCloud.m_cloud.update(null);
                return;
            }
            if (object == this.m_cAdjustMaxHue) {
                this.m_pjPointCloud.m_bRescaleHue = this.m_cAdjustMaxHue.getState();
                if (!this.m_pjPointCloud.m_bRescaleHue) {
                    return;
                }
                this.m_pjPointCloud.computeMaxHue(this.m_pjPointCloud.m_vertexColorType, this.m_pjPointCloud.m_maxHue);
                this.m_pjPointCloud.update(this.m_pjPointCloud.m_maxHue);
                return;
            }
            for (int i = 0; i < 6; ++i) {
                if (object != this.m_cColor[i]) continue;
                if (i < 2) {
                    this.m_pjPointCloud.m_cloud.selectVectorField(this.m_pjPointCloud.getColorVectorField(i));
                }
                this.m_pjPointCloud.m_vertexColorType = i;
                this.m_pjPointCloud.update(this.m_pjPointCloud.m_cloud);
                break;
            }
            return;
        }
        this.m_pjPointCloud.update(this.m_pjPointCloud.m_cloud);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

