/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.curvaturePlot;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import vgp.curve.curvaturePlot.PjCurvaturePlot;

public class PjCurvaturePlot_IP
extends PjProject_IP
implements ItemListener,
ActionListener {
    protected PjCurvaturePlot m_pjCurvPlot;
    protected Button m_bReset;
    protected Button m_bNew;
    protected PsPanel m_pSlider;
    protected PsPanel m_pDisp;
    protected CheckboxGroup m_gType;
    protected Checkbox m_cPlot;
    protected Checkbox m_cVector;
    protected Checkbox m_cAutoFit;
    protected Checkbox m_cScale;
    protected Checkbox m_cColorByLength;
    protected TextField m_tStepsize;
    protected TextField m_tNumSteps;
    protected Button m_bStep;
    protected Button m_bMinimize;
    protected Checkbox[] m_cShowGrad;
    protected Choice m_chEnergy;
    private Color m_bMinimizeColor;
    static /* synthetic */ Class class$vgp$curve$curvaturePlot$PjCurvaturePlot_IP;

    public PjCurvaturePlot_IP() {
        if (this.getClass() == (class$vgp$curve$curvaturePlot$PjCurvaturePlot_IP == null ? (class$vgp$curve$curvaturePlot$PjCurvaturePlot_IP = PjCurvaturePlot_IP.class$("vgp.curve.curvaturePlot.PjCurvaturePlot_IP")) : class$vgp$curve$curvaturePlot$PjCurvaturePlot_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addNotice(this.getNotice());
        this.m_pSlider = new PsPanel((LayoutManager)new GridLayout(2, 1));
        ((Container)((Object)this)).add((Component)this.m_pSlider);
        PsPanel psPanel = new PsPanel();
        Panel panel = new Panel(new GridLayout(2, 2));
        this.m_gType = new CheckboxGroup();
        this.m_cAutoFit = new Checkbox(PsConfig.getMessage((boolean)true, (int)84000, (String)"Auto-Fit"));
        this.m_cAutoFit.addItemListener(this);
        panel.add(this.m_cAutoFit);
        this.m_cScale = new Checkbox(PsConfig.getMessage((boolean)true, (int)84000, (String)"Scale by Length"));
        this.m_cScale.addItemListener(this);
        panel.add(this.m_cScale);
        this.m_cColorByLength = new Checkbox(PsConfig.getMessage((boolean)true, (int)84000, (String)"Color by Length"));
        this.m_cColorByLength.addItemListener(this);
        panel.add(this.m_cColorByLength);
        psPanel.add(panel);
        ((Container)((Object)this)).add((Component)psPanel);
        panel = new PsPanel();
        this.m_chEnergy = new Choice();
        this.m_chEnergy.removeAll();
        for (int i = 0; i < 5; ++i) {
            this.m_chEnergy.add(PjCurvaturePlot.ENERGY_NAMES[i]);
        }
        this.m_chEnergy.addItemListener(this);
        panel.add(this.m_chEnergy);
        Panel panel2 = new Panel(new GridLayout(1, 4));
        panel2.add(new Label(PsConfig.getMessage((boolean)true, (int)84000, (String)"Stepsize")));
        this.m_tStepsize = new TextField();
        panel2.add(this.m_tStepsize);
        panel2.add(new Label(PsConfig.getMessage((boolean)true, (int)84000, (String)"NumSteps")));
        this.m_tNumSteps = new TextField();
        panel2.add(this.m_tNumSteps);
        panel.add(panel2);
        panel2 = new Panel(new GridLayout(3, 2));
        this.m_cShowGrad = new Checkbox[5];
        for (int i = 0; i < 5; ++i) {
            this.m_cShowGrad[i] = new Checkbox(PsConfig.getMessage((boolean)true, (int)84000, (String)"Show") + " " + PjCurvaturePlot.ENERGY_NAMES[i]);
            this.m_cShowGrad[i].addItemListener(this);
            panel2.add(this.m_cShowGrad[i]);
        }
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout());
        this.m_bStep = new Button(PsConfig.getMessage((boolean)true, (int)84000, (String)"Step"));
        this.m_bStep.addActionListener(this);
        panel2.add(this.m_bStep);
        this.m_bMinimize = new Button(PsConfig.getMessage((boolean)true, (int)84000, (String)"Minimize"));
        this.m_bMinimize.addActionListener(this);
        panel2.add(this.m_bMinimize);
        panel.add(panel2);
        ((Container)((Object)this)).add(panel);
        this.m_pDisp = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_pDisp);
        panel2 = new Panel(new FlowLayout(1));
        this.m_bNew = new Button("New");
        this.m_bNew.addActionListener(this);
        panel2.add(this.m_bNew);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        panel2.add(this.m_bReset);
        ((Container)((Object)this)).add(panel2);
    }

    public String getNotice() {
        String string = "Study various curve smoothing energies.";
        return string;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pjCurvPlot = (PjCurvaturePlot)psUpdateIf;
        this.m_pDisp.removeAll();
        if (this.m_pjCurvPlot.m_curvDisp != null) {
            this.m_pDisp.add(this.m_pjCurvPlot.m_curvDisp.getCanvas());
        }
        ((TextComponent)this.m_tNumSteps).setText("" + this.m_pjCurvPlot.getNumSteps());
        ((TextComponent)this.m_tStepsize).setText("" + this.m_pjCurvPlot.getStepSize());
        ((Container)((Object)this)).validate();
    }

    public boolean update(Object object) {
        if (this.m_pjCurvPlot == object) {
            this.setTitle(this.m_pjCurvPlot.getName());
            PsPanel.setState((Checkbox)this.m_cAutoFit, (boolean)this.m_pjCurvPlot.isEnabledAutoFit());
            PsPanel.setState((Checkbox)this.m_cScale, (boolean)this.m_pjCurvPlot.isEnabledMetricScale());
            PsPanel.setState((Checkbox)this.m_cColorByLength, (boolean)this.m_pjCurvPlot.isEnabledColorByLength());
            if (this.m_chEnergy.getSelectedIndex() != this.m_pjCurvPlot.getEnergy()) {
                this.m_chEnergy.select(this.m_pjCurvPlot.getEnergy());
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjCurvPlot == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_pjCurvPlot.init();
            this.m_pjCurvPlot.start();
            this.m_pjCurvPlot.update(this.m_pjCurvPlot);
        } else if (object == this.m_bNew) {
            this.m_pjCurvPlot.newCurve();
            this.m_pjCurvPlot.update(this.m_pjCurvPlot);
        } else if (object == this.m_bStep) {
            this.setValues();
            this.m_pjCurvPlot.step();
            this.m_pjCurvPlot.update(this.m_pjCurvPlot);
        } else if (object == this.m_bMinimize) {
            if (this.m_pjCurvPlot.isMinimize()) {
                this.m_bMinimize.setBackground(this.m_bMinimizeColor);
                this.m_pjCurvPlot.stopMinimize();
            } else {
                this.setValues();
                this.m_bMinimizeColor = this.m_bMinimize.getBackground();
                this.m_bMinimize.setBackground(Color.red);
                this.m_pjCurvPlot.minimize();
            }
        }
    }

    private void setValues() {
        String string = this.m_tStepsize.getText();
        if (string != null && !string.equals("")) {
            try {
                this.m_pjCurvPlot.setStepSize((float)new Double(string).doubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_pjCurvPlot.setEnergy(this.m_chEnergy.getSelectedIndex());
        this.m_pjCurvPlot.setNumSteps(Integer.parseInt(this.m_tNumSteps.getText()));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        boolean bl = true;
        PsDebug.notify((String)"entered");
        if (object == this.m_chEnergy) {
            this.m_pjCurvPlot.setEnergy(this.m_chEnergy.getSelectedIndex());
            this.m_pjCurvPlot.computePlot();
        } else {
            if (object == this.m_cAutoFit) {
                boolean bl2 = this.m_cAutoFit.getState();
                this.m_pjCurvPlot.setEnabledAutoFit(bl2);
                if (bl2) {
                    this.m_pjCurvPlot.m_curvDisp.fit();
                }
                return;
            }
            if (object == this.m_cScale) {
                this.m_pjCurvPlot.setEnabledMetricScale(this.m_cScale.getState());
                this.m_pjCurvPlot.computePlot();
            } else {
                if (object == this.m_cColorByLength) {
                    this.m_pjCurvPlot.setEnabledColorByLength(this.m_cColorByLength.getState());
                    this.m_pjCurvPlot.update(this.m_pjCurvPlot.m_geom);
                    return;
                }
                bl = false;
            }
        }
        if (!bl) {
            for (int i = 0; i < 5; ++i) {
                if (object != this.m_cShowGrad[i]) continue;
                bl = true;
                this.m_pjCurvPlot.m_vfGrad[i].setVisible(this.m_cShowGrad[i].getState());
                break;
            }
        }
        if (!bl) {
            return;
        }
        this.m_pjCurvPlot.update(this.m_pjCurvPlot);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

