/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PvCameraIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

public final class PvCamera
extends PsObject
implements PvCameraIf {
    protected static int Z_STRETCH_FAC = 100;
    protected static int Z_STRETCH = 10000 * Z_STRETCH_FAC;
    protected static double SIZE = 1.0;
    private PdVector m_interest = new PdVector(3);
    private PdVector m_position = new PdVector(3);
    private PdVector m_viewDir = new PdVector(3);
    private PdVector m_viewDirOut = new PdVector(3);
    private PdVector m_upVector = new PdVector(3);
    private PdVector m_wDir = new PdVector(3);
    private PdVector m_zUp = new PdVector(3);
    private PdVector m_defaultUpVector = new PdVector(3);
    protected double m_defRoll = 0.0;
    protected PuDouble m_roll;
    protected double m_defFieldOfView = 0.5;
    protected PuDouble m_fieldOfView;
    protected PuDouble m_nearClip;
    private double m_defNearClip = SIZE;
    protected PuDouble m_farClip;
    private double m_defFarClip = -SIZE;
    protected boolean m_bDefEnableClip;
    protected boolean m_bEnableClip;
    public PdMatrix m_defView = new PdMatrix(4);
    public PdMatrix m_defViewInv = new PdMatrix(4);
    public PdMatrix m_defTrans = new PdMatrix(4);
    public PdMatrix m_defTransInv = new PdMatrix(4);
    protected PdMatrix m_projNon = new PdMatrix(4);
    protected PdMatrix m_projNonInv = new PdMatrix(4);
    public PdMatrix m_transNon = new PdMatrix(4);
    public PdMatrix m_transNonInv = new PdMatrix(4);
    protected PdMatrix m_proj = new PdMatrix(4);
    protected PdMatrix m_projInv = new PdMatrix(4);
    public PdMatrix m_view = new PdMatrix(4);
    public PdMatrix m_viewInv = new PdMatrix(4);
    public PdMatrix m_trans = new PdMatrix(4);
    public PdMatrix m_transInv = new PdMatrix(4);
    protected PdMatrix m_incrView = new PdMatrix(4);
    protected PdMatrix m_incrViewInv = new PdMatrix(4);
    protected int m_mode;
    protected int m_projMode;
    protected double m_heightOff;
    protected double m_widthOff;
    protected int m_heightPick;
    protected int m_widthPick;
    protected double m_sceneRatio;
    protected boolean m_bSceneRatio;
    protected boolean m_bFillDisplay;
    protected PdVector m_boxRatio;
    protected boolean m_bBoxRatio;
    protected double m_fit;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected PdVector m_pick = new PdVector(4);
    private double[] m_prevNormLoc = new double[2];
    private double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;
    private PdVector[] m_allBnd = PdVector.realloc(null, 8, 3);

    public PvCamera(PvDisplay pvDisplay, int n) {
        this.m_display = pvDisplay;
        this.m_projMode = n;
        this.m_fieldOfView = new PuDouble(PsConfig.getMessage(24338), this);
        if (this.m_projMode != 0) {
            this.m_defFieldOfView = 0.0;
        }
        this.m_roll = new PuDouble(PsConfig.getMessage(24219), this);
        this.m_nearClip = new PuDouble(PsConfig.getMessage(24220), this);
        this.m_farClip = new PuDouble(PsConfig.getMessage(24221), this);
        this.init();
    }

    public void init() {
        super.init();
        this.m_fieldOfView.setDefBounds(0.0, 3.0, 0.01, 0.1);
        this.m_fieldOfView.setDefValue(this.m_defFieldOfView);
        this.m_fieldOfView.init();
        this.m_roll.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_roll.setDefValue(this.m_defRoll);
        this.m_roll.init();
        this.m_nearClip.setDefBounds(this.m_defNearClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_nearClip.setDefValue(this.m_defNearClip);
        this.m_nearClip.init();
        this.m_farClip.setDefBounds(this.m_defFarClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_farClip.setDefValue(this.m_defFarClip);
        this.m_farClip.init();
        this.m_bBoxRatio = false;
        this.m_bEnableClip = false;
        this.m_bFillDisplay = false;
        this.m_bSceneRatio = false;
        this.m_fit = -1.0;
        this.m_sceneRatio = 1.0;
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_pick.set(0.0, 0.0, 0.0, 1.0);
        this.m_projNon.setIdentity();
        this.m_projNonInv.setIdentity();
        this.m_proj.setIdentity();
        this.m_projInv.setIdentity();
        this.m_view.setIdentity();
        this.m_viewInv.setIdentity();
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        this.m_trans.setIdentity();
        this.m_transInv.setIdentity();
        this.computeProjection();
        PsDebug.notify("mode = " + this.m_projMode);
        switch (this.m_projMode) {
            case 0: {
                this.m_viewDir.set(0.1, 0.6, -0.4);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.m_viewDir.set(0.0, 0.0, -1.0);
                this.m_defaultUpVector.set(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                this.m_viewDir.set(0.0, 1.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 3: {
                this.m_viewDir.set(-1.0, 0.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            default: {
                PsDebug.error("unknown projection mode = " + this.m_projMode, this);
            }
        }
        this.m_upVector.copy(this.m_defaultUpVector);
        this.setInterest(new PdVector(0.0, 0.0, 0.0));
        this.computeView();
        this.saveAsDefault();
    }

    public void saveAsDefault() {
        this.m_bDefEnableClip = this.m_bEnableClip;
        this.m_defView.copy(this.m_view);
        this.m_defViewInv.copy(this.m_viewInv);
        this.m_defFieldOfView = this.m_fieldOfView.getValue();
    }

    public void reset() {
        this.m_bEnableClip = this.m_bDefEnableClip;
        this.m_view.copy(this.m_defView);
        this.m_viewInv.copy(this.m_defViewInv);
        this.m_fieldOfView.setDefBounds(0.0, 5.0, 0.01, 0.1);
        this.m_fieldOfView.setDefValue(this.m_defFieldOfView);
        this.m_fieldOfView.init();
        this.computeProjection();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == this.m_fieldOfView) {
            this.setFieldOfView(this.m_fieldOfView.getValue());
            this.computeProjection();
            return super.update(null);
        }
        if (object == this.m_roll) {
            this.setRoll(this.m_roll.getValue());
            return super.update(null);
        }
        if (object == this.m_nearClip) {
            if (this.m_nearClip.getValue() < this.m_farClip.getValue()) {
                this.m_farClip.setValue(this.m_nearClip.getValue());
            }
            return super.update(null);
        }
        if (object == this.m_farClip) {
            if (this.m_farClip.getValue() > this.m_nearClip.getValue()) {
                this.m_nearClip.setValue(this.m_farClip.getValue());
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public int getProjectionMode() {
        return this.m_projMode;
    }

    public void setProjectionMode(int n) {
        this.m_projMode = n;
    }

    protected int getMode() {
        return this.m_mode;
    }

    protected void setMode(int n) {
        if (n == 10) {
            return;
        }
        this.m_mode = n;
    }

    public boolean isEnabledClip() {
        return this.m_bEnableClip;
    }

    public void setEnabledClip(boolean bl) {
        this.m_bEnableClip = bl;
    }

    public double getNearClip() {
        return this.m_nearClip.getValue();
    }

    public void setNearClip(double d) {
        this.m_nearClip.setValue(d);
    }

    public double getFarClip() {
        return this.m_farClip.getValue();
    }

    public void setFarClip(double d) {
        this.m_farClip.setValue(d);
    }

    public PdVector getViewDir() {
        int n;
        double d = this.getScale();
        for (n = 0; n < 3; ++n) {
            this.m_viewDir.m_data[n] = -this.m_view.m_data[2][n] / d;
        }
        for (n = 0; n < 3; ++n) {
            this.m_viewDirOut.m_data[n] = this.m_viewDir.m_data[n];
        }
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (n = 0; n < 3; ++n) {
                int n2 = n;
                this.m_viewDirOut.m_data[n2] = this.m_viewDirOut.m_data[n2] / this.m_boxRatio.m_data[n];
            }
        }
        return this.m_viewDirOut;
    }

    protected PdVector getViewDirEuclidean() {
        double d = this.getScale();
        for (int i = 0; i < 3; ++i) {
            this.m_viewDir.m_data[i] = -this.m_view.m_data[2][i] / d;
        }
        return this.m_viewDir;
    }

    public void setViewDir(PdVector pdVector) {
        double d = this.getRoll();
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (int i = 0; i < 3; ++i) {
                this.m_viewDir.m_data[i] = pdVector.m_data[i] * this.m_boxRatio.m_data[i];
            }
        } else {
            this.m_viewDir.copyArray(pdVector);
        }
        this.computeView();
        this.setRoll(d);
    }

    public double getDist() {
        double d = SIZE / this.getScale();
        return d;
    }

    public void setDist(double d) {
        this.setScale(SIZE / d);
    }

    public double getScale() {
        return Math.sqrt(this.m_view.m_data[2][0] * this.m_view.m_data[2][0] + this.m_view.m_data[2][1] * this.m_view.m_data[2][1] + this.m_view.m_data[2][2] * this.m_view.m_data[2][2]);
    }

    public void setScale(double d) {
        double d2 = this.getScale();
        if (d == d2) {
            return;
        }
        double d3 = d / d2;
        for (int i = 0; i < 3; ++i) {
            int n = 0;
            while (n < 3) {
                double[] dArray = this.m_view.m_data[i];
                int n2 = n;
                dArray[n2] = dArray[n2] * d3;
                double[] dArray2 = this.m_viewInv.m_data[i];
                int n3 = n++;
                dArray2[n3] = dArray2[n3] / d3;
            }
            double[] dArray = this.m_view.m_data[i];
            dArray[3] = dArray[3] * d3;
        }
        this.computeTrans();
    }

    public double getFieldOfView() {
        return this.m_fieldOfView.getValue();
    }

    public void setFieldOfView(double d) {
        if (this.m_fieldOfView.getValue() == d) {
            return;
        }
        this.m_fieldOfView.setValue(d);
        this.computeProjection();
    }

    public double getRoll() {
        PdVector pdVector = this.getViewDirEuclidean();
        this.m_zUp = this.m_defaultUpVector.orthogonalPart(this.m_zUp, pdVector);
        if (this.m_zUp.length() > 1.0E-10) {
            PdVector pdVector2 = this.getUpVectorEuclidean();
            this.m_roll.setValue(PdVector.angleWithOrientation(pdVector2, this.m_zUp, pdVector) * 180.0 / Math.PI);
        } else {
            PdVector pdVector3 = PdVector.copyNew(this.m_defaultUpVector);
            double d = pdVector3.getEntry(2);
            pdVector3.setEntry(2, pdVector3.getEntry(1));
            pdVector3.setEntry(1, d);
            this.m_zUp = pdVector3.orthogonalPart(this.m_zUp, pdVector);
            PdVector pdVector4 = this.getUpVectorEuclidean();
            this.m_roll.setValue(PdVector.angleWithOrientation(pdVector4, this.m_zUp, pdVector) * 180.0 / Math.PI);
        }
        return this.m_roll.getValue();
    }

    public void setRoll(double d) {
        if (this.m_roll.getValue() != d) {
            this.m_roll.setValue(d);
        }
        PdVector pdVector = this.getViewDirEuclidean();
        this.m_zUp = this.m_defaultUpVector.orthogonalPart(this.m_zUp, pdVector);
        if (!this.m_zUp.normalize()) {
            PdVector pdVector2 = PdVector.copyNew(this.m_defaultUpVector);
            double d2 = pdVector2.getEntry(2);
            pdVector2.setEntry(2, pdVector2.getEntry(1));
            pdVector2.setEntry(1, d2);
            this.m_zUp = pdVector2.orthogonalPart(this.m_zUp, pdVector);
            if (!this.m_zUp.normalize()) {
                return;
            }
        }
        this.m_wDir.cross(this.m_zUp, pdVector);
        this.m_upVector.blend(Math.cos(d *= Math.PI / 180), this.m_zUp, Math.sin(d), this.m_wDir);
        this.computeView();
    }

    public PdVector getInterest() {
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (int i = 0; i < 3; ++i) {
                this.m_interest.m_data[i] = this.m_viewInv.m_data[i][3] / this.m_boxRatio.m_data[i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.m_interest.m_data[i] = this.m_viewInv.m_data[i][3];
            }
        }
        return this.m_interest;
    }

    protected PdVector getInterestEuclidean() {
        for (int i = 0; i < 3; ++i) {
            this.m_interest.m_data[i] = this.m_viewInv.m_data[i][3];
        }
        return this.m_interest;
    }

    public void setInterest(PdVector pdVector) {
        int n = pdVector.getSize();
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (int i = 0; i < 3; ++i) {
                this.m_view.m_data[i][3] = 0.0;
                for (int j = 0; j < n; ++j) {
                    double[] dArray = this.m_view.m_data[i];
                    dArray[3] = dArray[3] - this.m_view.m_data[i][j] * pdVector.m_data[j] * this.m_boxRatio.m_data[j];
                }
                this.m_viewInv.m_data[i][3] = pdVector.m_data[i] * this.m_boxRatio.m_data[i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.m_view.m_data[i][3] = 0.0;
                for (int j = 0; j < n; ++j) {
                    double[] dArray = this.m_view.m_data[i];
                    dArray[3] = dArray[3] - this.m_view.m_data[i][j] * pdVector.m_data[j];
                }
                this.m_viewInv.m_data[i][3] = pdVector.m_data[i];
            }
        }
        this.computeTrans();
    }

    public PdVector getPosition() {
        double d = this.getDist();
        PdVector pdVector = this.getInterest();
        PdVector pdVector2 = this.getViewDir();
        for (int i = 0; i < 3; ++i) {
            this.m_position.m_data[i] = pdVector.m_data[i] - d * pdVector2.m_data[i];
        }
        return this.m_position;
    }

    protected PdVector getPositionEuclidean() {
        double d = this.getDist();
        PdVector pdVector = this.getInterestEuclidean();
        PdVector pdVector2 = this.getViewDirEuclidean();
        for (int i = 0; i < 3; ++i) {
            this.m_position.m_data[i] = pdVector.m_data[i] - d * pdVector2.m_data[i];
        }
        return this.m_position;
    }

    public void setPosition(PdVector pdVector) {
        double d = this.getRoll();
        this.m_position.copyArray(pdVector);
        this.m_viewDir.sub(this.getInterest(), pdVector);
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                this.m_viewDir.m_data[n] = this.m_viewDir.m_data[n] * this.m_boxRatio.m_data[i];
            }
        }
        double d2 = this.m_viewDir.length();
        this.computeView();
        this.setDist(d2);
        this.setRoll(d);
    }

    public PdVector getUpVector() {
        int n;
        double d = this.getScale();
        for (n = 0; n < 3; ++n) {
            this.m_upVector.m_data[n] = this.m_view.m_data[1][n] / d;
        }
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (n = 0; n < 3; ++n) {
                int n2 = n;
                this.m_upVector.m_data[n2] = this.m_upVector.m_data[n2] / this.m_boxRatio.m_data[n];
            }
        }
        return this.m_upVector;
    }

    protected PdVector getUpVectorEuclidean() {
        double d = this.getScale();
        for (int i = 0; i < 3; ++i) {
            this.m_upVector.m_data[i] = this.m_view.m_data[1][i] / d;
        }
        return this.m_upVector;
    }

    public void setUpVector(PdVector pdVector) {
        this.m_upVector.copyArray(pdVector);
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                this.m_upVector.m_data[n] = this.m_upVector.m_data[n] * this.m_boxRatio.m_data[i];
            }
        }
        this.computeView();
    }

    public void setFullPosition(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        int n;
        this.setInterest(pdVector);
        this.m_upVector.copyArray(pdVector3);
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (n = 0; n < 3; ++n) {
                int n2 = n;
                this.m_upVector.m_data[n2] = this.m_upVector.m_data[n2] * this.m_boxRatio.m_data[n];
            }
        }
        this.m_upVector.normalize();
        this.m_viewDir.sub(pdVector, pdVector2);
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            for (n = 0; n < 3; ++n) {
                int n3 = n;
                this.m_viewDir.m_data[n3] = this.m_viewDir.m_data[n3] * this.m_boxRatio.m_data[n];
            }
        }
        double d = this.m_viewDir.length();
        this.computeView();
        this.setDist(d);
        this.getRoll();
    }

    private void computeView() {
        PdVector pdVector = this.getInterest();
        this.m_viewDir.normalize();
        this.m_zUp = this.m_upVector.orthogonalPart(this.m_zUp, this.m_viewDir);
        if (!this.m_zUp.normalize()) {
            PsDebug.notify("upVector parallel to line of view, modify 1");
            this.m_upVector.m_data[1] = this.m_upVector.m_data[1] + 1.0;
            this.m_zUp = this.m_upVector.orthogonalPart(this.m_zUp, this.m_viewDir);
            if (!this.m_zUp.normalize()) {
                PsDebug.notify("upVector parallel to line of view, modify 2");
                this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                this.m_zUp = this.m_upVector.orthogonalPart(this.m_zUp, this.m_viewDir);
                if (!this.m_zUp.normalize()) {
                    PsDebug.notify("upVector parallel to line of view, modify 3");
                    this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                    this.m_zUp = this.m_upVector.orthogonalPart(this.m_zUp, this.m_viewDir);
                }
            }
        }
        this.m_wDir.cross(this.m_viewDir, this.m_zUp);
        double d = this.getScale();
        for (int i = 0; i < 3; ++i) {
            this.m_view.m_data[0][i] = d * this.m_wDir.m_data[i];
            this.m_view.m_data[1][i] = d * this.m_zUp.m_data[i];
            this.m_view.m_data[2][i] = -d * this.m_viewDir.m_data[i];
            this.m_viewInv.m_data[i][0] = this.m_wDir.m_data[i] / d;
            this.m_viewInv.m_data[i][1] = this.m_zUp.m_data[i] / d;
            this.m_viewInv.m_data[i][2] = -this.m_viewDir.m_data[i] / d;
            this.m_viewInv.m_data[i][3] = -this.m_view.m_data[i][3];
        }
        this.setInterest(pdVector);
    }

    public void fit(double d) {
        this.setScale(SIZE / d);
    }

    protected void resizeImage(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            if (this.m_heightOff > 0.0) {
                PsDebug.warning("target image has dimensions=0");
            }
            return;
        }
        this.m_widthOff = d;
        this.m_heightOff = d2;
        this.computeProjection();
    }

    protected void setSceneRatio(double d) {
        this.m_sceneRatio = d;
    }

    public boolean isEnabledSceneRatio() {
        return this.m_bSceneRatio;
    }

    public void setEnabledSceneRatio(boolean bl) {
        this.m_bSceneRatio = bl;
    }

    protected boolean isEnabledFillDisplay() {
        return this.m_bFillDisplay;
    }

    protected void setEnabledFillDisplay(boolean bl) {
        if (bl == this.m_bFillDisplay) {
            return;
        }
        this.m_bFillDisplay = bl;
        this.computeProjection();
    }

    private void computeProjection() {
        PsDebug.notify("called");
        if (this.m_widthOff <= 0.0 || this.m_heightOff <= 0.0) {
            PsDebug.notify("called with empty window");
            return;
        }
        double d = Math.min(this.m_widthOff, this.m_heightOff) / SIZE;
        double d2 = this.m_widthOff / this.m_heightOff;
        if (this.m_bSceneRatio && this.m_projMode == 1) {
            d = this.m_sceneRatio >= 1.0 ? (d2 <= this.m_sceneRatio ? this.m_widthOff / SIZE : this.m_widthOff * this.m_sceneRatio / d2 / SIZE) : (this.m_sceneRatio <= d2 ? this.m_heightOff / SIZE : this.m_heightOff * d2 / this.m_sceneRatio / SIZE);
        }
        this.m_proj.m_data[0][0] = d;
        if (this.m_bFillDisplay) {
            double[] dArray = this.m_proj.m_data[0];
            dArray[0] = dArray[0] * d2;
        }
        this.m_proj.m_data[1][1] = -d;
        this.m_proj.m_data[0][3] = (this.m_widthOff - 1.0) / 2.0;
        this.m_proj.m_data[1][3] = (this.m_heightOff - 1.0) / 2.0;
        this.m_projInv.m_data[0][0] = 1.0 / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][1] = 1.0 / this.m_proj.m_data[1][1];
        this.m_projInv.m_data[0][3] = -this.m_proj.m_data[0][3] / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][3] = -this.m_proj.m_data[1][3] / this.m_proj.m_data[1][1];
        double d3 = this.m_fieldOfView.getValue() / SIZE;
        this.m_proj.m_data[0][2] = -d3 * this.m_proj.m_data[0][3];
        this.m_proj.m_data[1][2] = -d3 * this.m_proj.m_data[1][3];
        this.m_proj.m_data[3][2] = -d3;
        this.m_proj.m_data[2][2] = Z_STRETCH;
        this.m_projInv.m_data[2][2] = 1.0 / (double)Z_STRETCH;
        this.m_projInv.m_data[3][2] = d3 / (double)Z_STRETCH;
        this.m_projNon.copy(this.m_proj);
        this.m_projNon.m_data[0][2] = 0.0;
        this.m_projNon.m_data[1][2] = 0.0;
        this.m_projNon.m_data[3][2] = 0.0;
        this.m_projNonInv.copy(this.m_projInv);
        this.m_projNonInv.m_data[3][2] = 0.0;
        this.computeTrans();
    }

    protected void resizeImagePick(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            if (this.m_heightPick > 0) {
                PsDebug.warning("picking device has a dimension==0");
            }
            return;
        }
        this.m_widthPick = n;
        this.m_heightPick = n2;
    }

    protected void mousePressed(int n, int n2) {
        PvDisplay.normalizedCoords(this.m_prevNormLoc, n, n2, this.m_widthPick, this.m_heightPick);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    protected void mouseReleased(int n, int n2) {
        this.mousePressed(n, n2);
    }

    public void setEnabledBoxRatio(boolean bl) {
        if (this.m_bBoxRatio == bl) {
            return;
        }
        this.m_bBoxRatio = bl;
        this.computeView();
    }

    public void setBoxRatio(PdVector pdVector) {
        if (pdVector == null) {
            this.m_boxRatio = null;
        } else if (this.m_boxRatio == null) {
            this.m_boxRatio = (PdVector)pdVector.clone();
        } else {
            this.m_boxRatio.copyArray(pdVector);
        }
        if (this.m_bBoxRatio) {
            this.computeView();
        }
    }

    private void computeTrans() {
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
        this.m_transNon.mult(this.m_projNon, this.m_view);
        this.m_transNonInv.mult(this.m_viewInv, this.m_projNonInv);
        if (this.m_bBoxRatio && this.m_boxRatio != null) {
            int n;
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 3; ++n) {
                    double[] dArray = this.m_trans.m_data[n2];
                    int n3 = n;
                    dArray[n3] = dArray[n3] * this.m_boxRatio.getEntry(n);
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                n = 0;
                while (n < 4) {
                    double[] dArray = this.m_transInv.m_data[n2];
                    int n4 = n++;
                    dArray[n4] = dArray[n4] / this.m_boxRatio.getEntry(n2);
                }
            }
        }
    }

    protected void mouseDragged(int n, int n2, boolean bl, int n3) {
        PvDisplay.normalizedCoords(this.m_currNormLoc, n, n2, this.m_widthPick, this.m_heightPick);
        if (this.m_currNormLoc[0] == this.m_prevNormLoc[0] && this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
            return;
        }
        boolean bl2 = this.m_mode == 17 && this.m_projMode == 0 && n3 == 2;
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        if (this.m_mode == 1) {
            double d;
            double d2 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
            this.m_incrView.m_data[0][0] = d = d2 / this.m_scaleValue;
            this.m_incrView.m_data[1][1] = d;
            this.m_incrView.m_data[2][2] = d;
            this.m_incrViewInv.m_data[0][0] = 1.0 / d;
            this.m_incrViewInv.m_data[1][1] = 1.0 / d;
            this.m_incrViewInv.m_data[2][2] = 1.0 / d;
            this.m_scaleTotal *= d;
            this.m_scaleValue = d2;
        } else if (this.m_mode == 3 || this.m_projMode != 0) {
            double d = this.m_currNormLoc[0] * SIZE / 2.0;
            double d3 = this.m_currNormLoc[1] * SIZE / 2.0;
            double d4 = d - this.m_xTransValue;
            double d5 = d3 - this.m_yTransValue;
            this.m_incrView.m_data[0][3] = d4;
            this.m_incrView.m_data[1][3] = d5;
            this.m_incrViewInv.m_data[0][3] = -d4;
            this.m_incrViewInv.m_data[1][3] = -d5;
            this.m_xTransValue = d;
            this.m_yTransValue = d3;
        } else if (this.m_mode == 0 && this.m_projMode == 0) {
            double d;
            this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
            if (bl) {
                int n4 = 0;
                if (n3 == 2) {
                    n4 = 1;
                }
                if (this.m_vecAlt.getEntry(n4) != 0.0) {
                    this.m_vecAlt.setEntry(n4, 0.0);
                    this.m_vecAlt.normalize();
                }
                this.m_vec.setEntry(n4, 0.0);
                this.m_vec.normalize();
            }
            if ((d = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d > 1.0) {
                return;
            }
            double d6 = 1.5 * Math.acos(d);
            if (d6 < 1.0E-10) {
                PsDebug.notify("angle too small");
                return;
            }
            this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
            this.m_vecAlt.copy(this.m_vec);
            if (this.m_rotAxis.length() < 1.0E-10) {
                PsDebug.notify("rotAxis too small");
                return;
            }
            if (!PuReflect.makeRotation(this.m_incrView, this.m_rotAxis, d6)) {
                return;
            }
            this.m_incrViewInv.transpose(this.m_incrView);
        } else if (this.m_mode == 17 && this.m_projMode == 0) {
            double d;
            this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
            int n5 = -1;
            int n6 = -1;
            if (n3 == 1) {
                n5 = 0;
                n6 = 0;
            } else if (n3 == 2) {
                n5 = 2;
                n6 = 1;
            } else {
                return;
            }
            this.m_vec.setEntry(n6, 0.0);
            if (!this.m_vec.normalize()) {
                return;
            }
            if (this.m_vecAlt.getEntry(n6) != 0.0) {
                this.m_vecAlt.setEntry(n6, 0.0);
                if (!this.m_vecAlt.normalize()) {
                    this.m_vecAlt.copy(this.m_vec);
                    return;
                }
            }
            if ((d = PdVector.dot(this.m_vec, this.m_vecAlt)) < -1.0 || d > 1.0) {
                return;
            }
            double d7 = 1.5 * Math.acos(d);
            if (d7 < 1.0E-10) {
                this.m_vecAlt.copy(this.m_vec);
                PsDebug.notify("angle too small");
                return;
            }
            if (bl2 && this.m_upVector.getEntry(2) < 0.0) {
                d7 = -d7;
            }
            this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
            if (this.m_rotAxis.getEntry(n6) < 0.0) {
                this.m_rotAxis.setEntry(n5, -1.0);
            } else {
                this.m_rotAxis.setEntry(n5, 1.0);
            }
            this.m_rotAxis.setEntry((n5 + 1) % 3, 0.0);
            this.m_rotAxis.setEntry((n5 + 2) % 3, 0.0);
            this.m_vecAlt.copy(this.m_vec);
            if (!PuReflect.makeRotation(this.m_incrView, this.m_rotAxis, d7)) {
                return;
            }
            this.m_incrViewInv.transpose(this.m_incrView);
            if (bl2) {
                int n7;
                PdVector pdVector = this.getInterest();
                PdVector pdVector2 = new PdVector(3);
                pdVector2.leftMultAffin(this.m_incrView, pdVector, false);
                pdVector2.sub(pdVector, pdVector2);
                for (n7 = 0; n7 < 3; ++n7) {
                    this.m_incrView.setEntry(n7, 3, pdVector2.getEntry(n7));
                }
                pdVector2.leftMultAffin(this.m_incrViewInv, pdVector, false);
                pdVector2.sub(pdVector, pdVector2);
                for (n7 = 0; n7 < 3; ++n7) {
                    this.m_incrViewInv.setEntry(n7, 3, pdVector2.getEntry(n7));
                }
            }
        } else if (this.m_mode == 4) {
            double d;
            double d8 = this.m_currNormLoc[0] * SIZE / 2.0;
            double d9 = this.m_currNormLoc[1] * SIZE / 2.0;
            double d10 = d8 + d9;
            this.m_incrView.m_data[2][3] = d = d10 - this.m_zTransValue;
            this.m_incrViewInv.m_data[2][3] = -d;
            this.m_xTransValue = d8;
            this.m_yTransValue = d9;
            this.m_zTransValue = d10;
        } else {
            return;
        }
        boolean bl3 = this.m_display.isEnabledLocalTransform() || this.m_mode == 17 && bl2;
        this.mouseAnimate(bl3);
        if (this.m_mode != 1 && this.m_mode != 3 && this.m_projMode == 0) {
            if (this.m_mode == 0 && this.m_projMode == 0) {
                this.getRoll();
            } else if (this.m_mode == 17 && this.m_projMode == 0 && !bl2) {
                this.getRoll();
            }
        }
    }

    protected void mouseAnimate(boolean bl) {
        if (bl) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.computeTrans();
    }

    protected void mouseAnimateGeometry() {
        PuReflect.makeRotation(this.m_incrView, new PdVector(0.0, 0.0, 1.0), 0.06283185307179587);
        this.m_incrViewInv.transpose(this.m_incrView);
        this.mouseAnimate(this.m_display.isEnabledLocalTransform() || this.m_mode == 17);
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = null;
        if (this.m_display != null && this.m_display.m_scene != null) {
            pdVectorArray = this.m_display.m_scene.getBounds();
        }
        if (pdVectorArray == null) {
            return null;
        }
        this.m_allBnd[0].set(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_allBnd[1].set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_allBnd[2].set(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_allBnd[3].set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]);
        this.m_allBnd[4].set(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        this.m_allBnd[5].set(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]);
        this.m_allBnd[6].set(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]);
        this.m_allBnd[7].set(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]);
        int n = 8;
        double[] dArray = new double[3];
        pdVectorArray[0].setConstant(Double.MAX_VALUE);
        pdVectorArray[1].setConstant(Double.NEGATIVE_INFINITY);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d = 0.0;
                for (int k = 0; k < 3; ++k) {
                    d += this.m_trans.m_data[j][k] * this.m_allBnd[i].m_data[k];
                }
                dArray[j] = (int)(d + 0.5 + this.m_trans.m_data[j][3]);
                if (j == 2) {
                    dArray[2] = dArray[2] / (double)Z_STRETCH;
                }
                if (dArray[j] < pdVectorArray[0].m_data[j]) {
                    pdVectorArray[0].m_data[j] = dArray[j];
                }
                if (!(dArray[j] > pdVectorArray[1].m_data[j])) continue;
                pdVectorArray[1].m_data[j] = dArray[j];
            }
        }
        return pdVectorArray;
    }

    public PdMatrix getTransMatrix(int n) {
        switch (n) {
            case 2000: {
                return this.m_transNon;
            }
            case 2003: {
                return this.m_transNonInv;
            }
            case 2001: {
                return this.m_transNon;
            }
            case 2004: {
                return this.m_transNonInv;
            }
            case 2002: {
                return this.m_projNon;
            }
            case 2005: {
                return this.m_projNonInv;
            }
            case 0: {
                return this.m_trans;
            }
            case 16: {
                return this.m_transInv;
            }
            case 1: {
                return this.m_trans;
            }
            case 32: {
                return this.m_transInv;
            }
            case 2: {
                return this.m_proj;
            }
            case 64: {
                return this.m_projInv;
            }
            case 4: {
                return this.m_view;
            }
            case 128: {
                return this.m_viewInv;
            }
        }
        PsDebug.warning("unknown matrix type.");
        return null;
    }

    public void setTransMatrix(int n, PdMatrix pdMatrix) {
        switch (n) {
            case 0: {
                this.m_trans.copy(pdMatrix);
                this.m_defTrans.copy(pdMatrix);
                break;
            }
            case 16: {
                this.m_transInv.copy(pdMatrix);
                this.m_defTransInv.copy(pdMatrix);
                break;
            }
            case 1: {
                this.m_trans.copy(pdMatrix);
                this.m_defTrans.copy(pdMatrix);
                break;
            }
            case 32: {
                this.m_transInv.copy(pdMatrix);
                this.m_defTransInv.copy(pdMatrix);
                this.computeTrans();
                break;
            }
            case 2: {
                this.m_proj.copy(pdMatrix);
                this.computeTrans();
                break;
            }
            case 64: {
                this.m_projInv.copy(pdMatrix);
                this.computeTrans();
                break;
            }
            case 4: {
                this.m_view.copy(pdMatrix);
                this.m_defView.copy(pdMatrix);
                this.computeTrans();
                break;
            }
            case 128: {
                this.m_viewInv.copy(pdMatrix);
                this.m_defViewInv.copy(pdMatrix);
                this.computeTrans();
                break;
            }
            default: {
                PsDebug.warning("unknown matrix type.");
            }
        }
    }
}

