/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.sizePolygon;

import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjSizePolygon
extends PjProject
implements Runnable {
    protected PgPolygonSet m_geom = new PgPolygonSet(3);
    protected int m_numPoly;
    protected PdVector m_delSize;
    protected transient Thread m_thread;
    protected PuDouble m_speed;
    protected PuInteger m_discr;
    static /* synthetic */ Class class$vgp$tutor$sizePolygon$PjSizePolygon;

    public PjSizePolygon() {
        super("Size of Polygon Edges Demo");
        this.m_geom.setName("Polygon Set");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_delSize = new PdVector();
        this.m_discr = new PuInteger(PsConfig.getMessage((boolean)true, (int)84000, (String)"Discretization"), (PsUpdateIf)this);
        this.m_speed = new PuDouble(PsConfig.getMessage((boolean)true, (int)84000, (String)"Speed"), (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$tutor$sizePolygon$PjSizePolygon == null ? (class$vgp$tutor$sizePolygon$PjSizePolygon = PjSizePolygon.class$("vgp.tutor.sizePolygon.PjSizePolygon")) : class$vgp$tutor$sizePolygon$PjSizePolygon)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.setGlobalPolygonSize(15.0);
        this.m_geom.showVertices(false);
        this.m_geom.showPolygonColors(true);
        this.m_geom.showPolygonSizes(true);
        this.m_discr.setDefBounds(2, 20, 1, 5);
        this.m_discr.setDefValue(8);
        this.m_discr.init();
        this.m_speed.setDefBounds(0.2, 5.0, 0.05, 0.1);
        this.m_speed.setDefValue(1.0);
        this.m_speed.init();
        this.compute();
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.m_geom.update((Object)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.setBackgroundColor(Color.black);
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.showEdgeAura(true);
        pvDisplayIf.showScenegraph(false);
        pvDisplayIf.setEnabledZBuffer(true);
        super.start();
    }

    public void compute() {
        int n;
        double d;
        int n2;
        PiVector piVector;
        double d2;
        int n3;
        int n4 = this.m_discr.getValue();
        int n5 = this.m_discr.getValue();
        int n6 = this.m_discr.getValue();
        if (n4 < 2 || n5 < 2 || n6 < 2) {
            return;
        }
        this.m_geom.setNumVertices((n5 + n6) * (n4 + 2));
        this.m_geom.setNumPolygons(n5 + n6);
        double d3 = 10.0;
        double d4 = 10.0;
        double d5 = 3.0;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n7 = 0;
        double d6 = d3 / (-1.0 + (double)n5);
        double d7 = d4 / (-1.0 + (double)n4);
        for (n3 = 0; n3 < n5; ++n3) {
            d2 = d6 * (double)n3;
            piVector = this.m_geom.getPolygon(n3);
            piVector.setSize(n4 + 2);
            for (n2 = 0; n2 < n4 + 2; ++n2) {
                d = d7 * (double)(n2 - 1);
                pdVectorArray[n7].m_data[0] = d2;
                pdVectorArray[n7].m_data[1] = d;
                pdVectorArray[n7].m_data[2] = 0.0;
                piVector.m_data[n2] = n7++;
            }
        }
        d6 = d3 / (-1.0 + (double)n4);
        d7 = d4 / (-1.0 + (double)n6);
        for (n3 = 0; n3 < n6; ++n3) {
            d2 = d7 * (double)n3;
            piVector = this.m_geom.getPolygon(n5 + n3);
            piVector.setSize(n4 + 2);
            for (n2 = 0; n2 < n4 + 2; ++n2) {
                pdVectorArray[n7].m_data[0] = d = d6 * (double)(n2 - 1);
                pdVectorArray[n7].m_data[1] = d2;
                pdVectorArray[n7].m_data[2] = Math.random() < 0.5 ? -d5 : d5;
                piVector.m_data[n2] = n7++;
            }
        }
        n3 = this.m_geom.getNumPolygons();
        this.m_delSize.setSize(n3);
        for (n = 0; n < n3; ++n) {
            if (Math.random() > 0.5) {
                this.m_delSize.setEntry(n, 1.0);
                continue;
            }
            this.m_delSize.setEntry(n, -1.0);
        }
        for (n = 0; n < n3; ++n) {
            this.m_geom.setPolygonSize(n, Math.random());
        }
        this.m_numPoly = n3;
        this.computeColorsFromSize();
    }

    private void computeColorsFromSize() {
        int n = this.m_geom.getNumPolygons();
        this.m_geom.assurePolygonColors();
        Color[] colorArray = this.m_geom.getPolygonColors();
        for (int i = 0; i < n; ++i) {
            double d = this.m_geom.getPolygonSize(i);
            float f = (float)d;
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f), 1.0f, 1.0f));
        }
    }

    public void changePolygonSize(double d) {
        int n = this.m_geom.getNumPolygons();
        if (n != this.m_numPoly) {
            return;
        }
        d /= 30.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.m_geom.getPolygonSize(i);
            double d3 = this.m_delSize.getEntry(i) * d;
            if (d3 > 0.0 && d2 + d3 > 1.0 || d3 < 0.0 && d2 + d3 < 0.0) {
                d3 = -d3;
                this.m_delSize.setEntry(i, -this.m_delSize.getEntry(i));
            }
            this.m_geom.setPolygonSize(i, d2 + d3);
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
        } else {
            if (object == this.m_geom) {
                if (this.m_numPoly != this.m_geom.getNumPolygons()) {
                    this.compute();
                }
                return true;
            }
            if (object == this.m_discr) {
                this.compute();
                this.m_geom.update((Object)this.m_geom);
                return true;
            }
            if (object == this.m_speed) {
                return true;
            }
        }
        return super.update(object);
    }

    public void startAnim() {
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, PsConfig.getProgram() + ": SizePolygons");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stopAnim() {
        this.m_thread = null;
    }

    public void run() {
        while (this.m_thread != null) {
            this.changePolygonSize(this.m_speed.getValue());
            this.m_geom.update((Object)this.m_geom);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

