/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.eventCamera;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;

public class PjEventCamera
extends PjProject
implements PvCameraListenerIf {
    public static final int STEREO_CROSS = 0;
    public static final int STEREO_PARALLEL = 1;
    public static final int STEREO_REDGREEN = 2;
    protected PgElementSet m_geom = new PgElementSet(3);
    protected PvDisplayIf m_dispRight;
    protected PvDisplayIf m_dispLeft;
    protected int m_stereoType;
    protected PuDouble m_parallax = new PuDouble("Parallax", (PsUpdateIf)this);
    protected PvDisplayIf m_currDisp;
    boolean m_bUpdating = false;
    static /* synthetic */ Class class$vgp$tutor$eventCamera$PjEventCamera;

    public PjEventCamera() {
        super("Camera Events for Stereo Viewing Demo");
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$eventCamera$PjEventCamera == null ? (class$vgp$tutor$eventCamera$PjEventCamera = PjEventCamera.class$("vgp.tutor.eventCamera.PjEventCamera")) : class$vgp$tutor$eventCamera$PjEventCamera)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.setName("Torus");
        this.m_geom.computeTorus(10, 10, 2.0, 1.0);
        this.m_geom.setGlobalVertexSize(4.0);
        this.m_geom.setGlobalEdgeSize(2.0);
        this.m_geom.showVertices(true);
        this.m_geom.showElements(false);
        this.m_geom.makeVertexColorsFromZHue();
        this.m_geom.showVertexColors(false);
        this.m_geom.showEdgeColors(true);
        this.m_geom.showEdgeColorFromElements(false);
        PdVector pdVector = this.m_geom.getVertex(74);
        if (pdVector != null) {
            pdVector.setTag(1);
        }
        this.m_stereoType = 1;
        this.m_parallax.setDefBounds(0.0, 30.0, 0.5, 2.0);
        this.m_parallax.setDefValue(6.0);
        this.m_parallax.init();
        this.m_currDisp = this.m_dispRight;
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.getLeftDisplay().addGeometry((PgGeometryIf)this.m_geom);
        this.getRightDisplay().addGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    public void reset() {
        this.init();
        if (!this.m_dispRight.containsGeometry((PgGeometryIf)this.m_geom)) {
            this.m_dispRight.addGeometry((PgGeometryIf)this.m_geom);
        }
        if (!this.m_dispLeft.containsGeometry((PgGeometryIf)this.m_geom)) {
            this.m_dispLeft.addGeometry((PgGeometryIf)this.m_geom);
        }
        this.m_geom.update((Object)this.m_geom);
        this.update((Object)this);
        this.updateDisplay(this.m_currDisp);
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            return true;
        }
        if (object == this.m_parallax) {
            this.updateDisplay(this.m_currDisp);
            return true;
        }
        return super.update(object);
    }

    public PvDisplayIf getRightDisplay() {
        if (this.m_dispRight != null) {
            return this.m_dispRight;
        }
        PvViewerIf pvViewerIf = this.getViewer();
        this.m_dispRight = pvViewerIf.newDisplay("Right Display", false);
        this.m_dispRight.setBackgroundColor(Color.white);
        this.m_dispRight.showDepthcue(true);
        this.m_dispRight.showEdgeAura(false);
        this.m_dispRight.setLightingModel(0);
        this.m_dispRight.addCameraListener((PvCameraListenerIf)this);
        return this.m_dispRight;
    }

    public PvDisplayIf getLeftDisplay() {
        if (this.m_dispLeft != null) {
            return this.m_dispLeft;
        }
        PvViewerIf pvViewerIf = this.getViewer();
        this.m_dispLeft = pvViewerIf.newDisplay("Left Display", false);
        this.m_dispLeft.setBackgroundColor(Color.white);
        this.m_dispLeft.showDepthcue(true);
        this.m_dispLeft.showEdgeAura(false);
        this.m_dispLeft.setLightingModel(0);
        this.m_dispLeft.addCameraListener((PvCameraListenerIf)this);
        return this.m_dispLeft;
    }

    public int getStereoType() {
        return this.m_stereoType;
    }

    public void setStereoType(int n) {
        this.m_stereoType = n;
    }

    public void pickCamera(PvCameraEvent pvCameraEvent) {
        if (this.m_bUpdating) {
            return;
        }
        if (this.m_dispLeft == null || this.m_dispRight == null) {
            return;
        }
        PvDisplayIf pvDisplayIf = pvCameraEvent.getSource();
        this.updateDisplay(pvDisplayIf);
    }

    protected void updateDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            return;
        }
        this.m_currDisp = pvDisplayIf;
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        PdVector pdVector = pvCameraIf.getInterest();
        PdVector pdVector2 = pvCameraIf.getUpVector();
        PdVector pdVector3 = pvCameraIf.getPosition();
        double d = pvCameraIf.getScale();
        PvDisplayIf pvDisplayIf2 = null;
        PvCameraIf pvCameraIf2 = null;
        double d2 = this.m_parallax.getValue() * Math.PI / 180.0;
        double d3 = this.m_stereoType == 0 ? -1 : 1;
        if (pvDisplayIf == this.m_dispRight) {
            pvCameraIf2 = this.m_dispLeft.getCamera();
            pvDisplayIf2 = this.m_dispLeft;
            d2 = -d3 * d2;
        } else {
            pvCameraIf2 = this.m_dispRight.getCamera();
            pvDisplayIf2 = this.m_dispRight;
            d2 = d3 * d2;
        }
        PdVector pdVector4 = (PdVector)pdVector3.clone();
        PuVectorGeom.rotatePointAroundLine((PdVector)pdVector4, (PdVector)pdVector3, (PdVector)pdVector, (PdVector)pdVector2, (double)d2);
        pvCameraIf2.setScale(d);
        pvCameraIf2.setFullPosition(pdVector, pdVector4, pdVector2);
        this.m_bUpdating = true;
        pvDisplayIf2.update((Object)pvCameraIf2);
        this.m_bUpdating = false;
    }

    public void dragCamera(PvCameraEvent pvCameraEvent) {
        this.pickCamera(pvCameraEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

