/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.pointCloud;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Random;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwEvolve;
import jvx.geom.PwNoise;
import jvx.numeric.PnJacobi;

public class PjPointCloud
extends PjProject
implements ActionListener {
    protected PjImportModel m_import;
    protected String m_fileName;
    protected PgElementSet m_tempElemSet;
    protected PwEvolve m_pjEvolve;
    protected PwNoise m_pjNoise;
    protected PgElementSet m_cloud;
    protected PgElementSet m_surface;
    protected PgPointSet m_tangent;
    protected PgVectorField[] m_vf;
    protected PgVectorField m_pcd1;
    protected PgVectorField m_pcd2;
    protected PuInteger m_torusDensity;
    protected int m_defTorusDensity = 10;
    protected boolean m_bDefSmoothVisibility = true;
    protected boolean m_bDefTangentVisibility = false;
    protected PuDouble m_influence;
    protected PuDouble m_quotient;
    protected double m_defThreshold = 0.5;
    protected PuDouble m_threshold;
    protected PiVector[] m_neigh;
    protected PdVector[] m_neighDist;
    protected int m_dim;
    protected boolean m_bUpdateNeighbours = true;
    protected boolean m_bEnableCutoff = false;
    protected boolean m_bConstrainInterior = false;
    protected boolean m_bEnableMaxValence = false;
    protected PuInteger m_maxValence;
    protected int m_defMaxValence = 10;
    protected boolean m_bZDensity = false;
    protected PuDouble m_zDensityLevel;
    protected PuDouble m_interior;
    protected boolean m_bRescaleHue = false;
    protected PuDouble m_maxHue;
    public static final int COLOR_MEAN = 0;
    public static final int COLOR_MEAN_ANI = 1;
    public static final int COLOR_MAX_PRINC = 2;
    public static final int COLOR_PRINC_QUOTIENT = 3;
    public static final int COLOR_COV_QUOTIENT = 4;
    public static final int COLOR_MAX_COV = 5;
    protected int m_vertexColorType = 0;
    public static final int NUM_MODELS = 7;
    public static final int MODEL_VENUS = 0;
    public static final int MODEL_COSTA = 1;
    public static final int MODEL_CYLINDER = 2;
    public static final int MODEL_OCTAHEDRON = 3;
    public static final int MODEL_TORUS = 4;
    public static final int MODEL_TRUNCATED = 5;
    public static final int MODEL_CUBE = 6;
    protected int m_currentModel;
    public static final String[] MODEL_NAMES = new String[]{"Venus Torso", "Costa Surface", "Intersected Cylinder", "Octahedron", "Torus", "Truncated Octahedron", "Cube"};
    public static final String[] FILE_NAME = new String[]{"venusLight.jvx", "costa4918Orig.jvx", "interCylMaxPrincOrig.jvx", "octahedron32768.jvx", "torus4851Orig.jvx", "truncatedOctahedron4608.jvx", "cube438Orig.jvx"};
    public static final double[] INFLUENCE = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.15};
    public static final double[] CURVATURE = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    public static final double[] MAXHUE = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.06};
    protected boolean m_bComputeTorus = false;
    protected boolean m_bProfile = true;
    protected long m_bInitTime;
    protected int[][] m_currMin;
    protected int[][] m_currMax;
    protected int m_minNeighCnt;
    static /* synthetic */ Class class$vgp$discrete$pointCloud$PjPointCloud;

    public PjPointCloud() {
        this(4);
    }

    public PjPointCloud(int n) {
        super("Point Cloud");
        if (n < 0 || 7 <= n) {
            n = 4;
        }
        this.m_currentModel = n;
        this.setFileName(this.m_currentModel);
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.setFileName(this.m_fileName);
        this.m_import.setParent((PsUpdateIf)this);
        this.m_import.addActionListener((ActionListener)this);
        this.m_dim = 3;
        this.m_cloud = new PgElementSet(this.m_dim);
        this.m_cloud.setName("Point Cloud");
        this.m_cloud.setParent((PsUpdateIf)this);
        this.m_surface = new PgElementSet(this.m_dim);
        this.m_surface.setName("Smooth Surface");
        this.m_surface.setParent((PsUpdateIf)this);
        this.m_tangent = new PgPointSet(this.m_dim);
        this.m_tangent.setName("Tangent Planes");
        this.m_vf = new PgVectorField[6];
        for (int i = 0; i < 6; ++i) {
            this.m_vf[i] = new PgVectorField(this.m_tangent.getDimOfVertices(), 0);
            this.m_vf[i].setGeometry(this.m_tangent);
            this.m_vf[i].showIndividualMaterial(true);
            this.m_vf[i].setGlobalVectorLength(0.5);
            this.m_tangent.addVectorField(this.m_vf[i]);
        }
        this.m_vf[0].setGlobalVectorColor(Color.red);
        this.m_vf[0].setName("Normal Covariance");
        this.m_vf[1].setGlobalVectorColor(Color.green);
        this.m_vf[1].setName("Min Covariance Dir");
        this.m_vf[2].setGlobalVectorColor(Color.blue);
        this.m_vf[2].setName("Max Covariance Dir");
        this.m_vf[3].setGlobalVectorColor(Color.yellow);
        this.m_vf[3].setName("Normal Principle");
        this.m_vf[4].setGlobalVectorColor(Color.magenta);
        this.m_vf[4].setName("Min Principle Dir");
        this.m_vf[5].setGlobalVectorColor(Color.cyan);
        this.m_vf[5].setName("Max Principle Dir");
        this.m_torusDensity = new PuInteger("Torus Density", (PsUpdateIf)this);
        this.m_torusDensity.setEnabled(this.m_bComputeTorus);
        this.m_zDensityLevel = new PuDouble("Z-Density Level", (PsUpdateIf)this);
        this.m_influence = new PuDouble("Influence Radius", (PsUpdateIf)this);
        this.m_quotient = new PuDouble("Edge Quotient", (PsUpdateIf)this);
        this.m_threshold = new PuDouble("Curvature Threshold", (PsUpdateIf)this);
        this.m_interior = new PuDouble("Interior Threshold", (PsUpdateIf)this);
        this.m_maxValence = new PuInteger("Maximum Valence", (PsUpdateIf)this);
        this.m_maxHue = new PuDouble("Value of Max Hue", (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$discrete$pointCloud$PjPointCloud == null ? (class$vgp$discrete$pointCloud$PjPointCloud = PjPointCloud.class$("vgp.discrete.pointCloud.PjPointCloud")) : class$vgp$discrete$pointCloud$PjPointCloud)) {
            this.init();
        }
    }

    public void setFileName(int n) {
        String string = "";
        try {
            String string2 = PsConfig.getCodeBase();
            string = PuString.replace((String)string2, (String)"\\", (String)"/") + "/models/pointSet/";
        }
        catch (Exception exception) {
            System.out.println("Exception caught =" + exception.getMessage());
        }
        this.m_fileName = string + FILE_NAME[this.m_currentModel];
    }

    public void init() {
        super.init();
        double d = this.m_cloud.getDiameter();
        if (d == 0.0) {
            d = 10.0;
        }
        this.m_influence.setDefValue(d / 20.0);
        this.m_influence.setDefBounds(0.0, d, 0.001, 0.01);
        this.m_influence.init();
        this.m_maxValence.setDefValue(this.m_defMaxValence);
        this.m_maxValence.setDefBounds(4, 10 * this.m_defMaxValence, 1, 2);
        this.m_maxValence.init();
        this.m_maxValence.setEnabled(this.m_bEnableMaxValence);
        this.m_threshold.setDefValue(this.m_defThreshold);
        this.m_threshold.setDefBounds(0.0, 5.0 * this.m_defThreshold, 0.001, 0.01);
        this.m_threshold.init();
        this.m_interior.setDefValue(this.m_defThreshold);
        this.m_interior.setDefBounds(0.0, 5.0 * this.m_defThreshold, 0.001, 0.01);
        this.m_interior.init();
        this.m_interior.setEnabled(this.m_bConstrainInterior);
        this.m_quotient.setDefValue(1.8);
        this.m_quotient.setDefBounds(0.0, 5.0, 0.001, 0.01);
        this.m_quotient.init();
        this.m_zDensityLevel.setDefValue(0.666666);
        this.m_zDensityLevel.setDefBounds(0.0, 1.8, 0.01, 0.1);
        this.m_zDensityLevel.init();
        this.m_zDensityLevel.setEnabled(this.m_bZDensity);
        this.m_maxHue.setDefValue(1.0);
        this.m_maxHue.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_maxHue.init();
        this.m_torusDensity.setDefValue(this.m_defTorusDensity);
        this.m_torusDensity.setDefBounds(1, 10 * this.m_defTorusDensity, 1, 2);
        this.m_torusDensity.init();
        this.m_cloud.setVisible(true);
        this.m_surface.setVisible(this.m_bDefSmoothVisibility);
        this.m_tangent.setVisible(this.m_bDefTangentVisibility);
        this.m_tangent.setGlobalVertexColor(Color.green);
        this.m_tangent.showVertexNormals(true);
    }

    public void start() {
        this.m_influence.setValue(INFLUENCE[this.m_currentModel]);
        this.m_threshold.setValue(CURVATURE[this.m_currentModel]);
        this.m_maxHue.setValue(MAXHUE[this.m_currentModel]);
        if (this.m_bComputeTorus) {
            this.computeMesh();
        } else if (this.m_fileName != null && !this.m_fileName.equalsIgnoreCase("Type a file name")) {
            this.m_import.start();
        }
        this.addGeometry((PgGeometryIf)this.m_cloud);
        this.addGeometry((PgGeometryIf)this.m_surface);
        this.addGeometry((PgGeometryIf)this.m_tangent);
        this.selectGeometry((PgGeometryIf)this.m_cloud);
        super.start();
    }

    public void reset() {
        this.init();
        this.addGeometry((PgGeometryIf)this.m_cloud);
        this.addGeometry((PgGeometryIf)this.m_surface);
        this.addGeometry((PgGeometryIf)this.m_tangent);
        this.selectGeometry((PgGeometryIf)this.m_cloud);
        this.m_surface.update((Object)this.m_surface);
    }

    public boolean setGeometry(PgGeometryIf pgGeometryIf) {
        if (!(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        this.m_surface.copy((PsObject)((PgElementSet)pgGeometryIf));
        PdVector[] pdVectorArray = this.m_surface.getBounds();
        if (pdVectorArray != null) {
            PdVector pdVector = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]);
            double d = pdVector.length();
            int n = this.m_surface.getNumVertices();
            double d2 = this.m_surface.getDimOfVertices();
            d2 = 4.0;
            double d3 = (double)this.m_maxValence.getValue() * d2 * d / 2.0 / (double)n;
            this.m_influence.setValue(d3);
        }
        this.m_surface.setGlobalElementColor(Color.white);
        this.m_surface.showEdges(false);
        this.m_surface.setTransparency(0.2);
        this.m_surface.showTransparency(true);
        if (this.m_currentModel == 6) {
            this.m_surface.setGlobalVertexSize(19.0);
        }
        this.fitDisplays();
        return true;
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == this.m_import) {
            this.initTime();
            this.setGeometry(this.m_import.getGeometry());
            this.printTime("Set Geometry");
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        if (object == this.m_surface) {
            this.m_cloud.copy((PsObject)this.m_surface);
            this.m_cloud.removeAllVectorFields();
            this.m_cloud.showSingleVectorField(true);
            this.makeStdVectorFields();
            this.assureVertexSizes();
            this.m_cloud.showVertexColors(true);
            this.m_cloud.showElements(false);
            this.m_cloud.showEdges(false);
            this.m_cloud.showVertices(true);
            boolean bl = this.m_bUpdateNeighbours;
            this.m_bUpdateNeighbours = true;
            this.m_cloud.update((Object)this.m_cloud);
            this.m_bUpdateNeighbours = bl;
            return true;
        }
        if (object == this.m_cloud) {
            this.setUpdateSender(true);
            this.initTime();
            if (this.m_bUpdateNeighbours) {
                this.printTime("Neighbour");
                this.computeNeighbour((PgPointSet)this.m_cloud, this.m_influence.getValue());
            }
            this.printTime("Tangents");
            this.computeTangents((PgPointSet)this.m_cloud, this.m_tangent, this.m_neigh);
            this.printTime("Principal Dirs");
            this.computePrincipal((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Anisotropic Laplace");
            this.computeAnisotropicLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Compute Laplace");
            PjPointCloud.computeLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Update Tangent");
            this.m_tangent.update((Object)this.m_tangent);
            if (this.m_bRescaleHue) {
                this.computeMaxHue(this.m_vertexColorType, this.m_maxHue);
            }
            this.makeVertexColors((PgPointSet)this.m_cloud, this.m_vertexColorType, this.m_maxHue.getValue());
            this.printTime("Update Cloud");
            this.m_cloud.update((Object)this.m_cloud);
            this.setUpdateSender(false);
            return true;
        }
        if (object == this.m_maxHue) {
            this.setUpdateSender(true);
            this.makeVertexColors((PgPointSet)this.m_cloud, this.m_vertexColorType, this.m_maxHue.getValue());
            this.m_cloud.update((Object)this.m_cloud);
            this.setUpdateSender(false);
            return true;
        }
        if (object == this.m_zDensityLevel) {
            this.setUpdateSender(true);
            this.assureVertexSizes();
            this.m_cloud.update((Object)this.m_cloud);
            this.setUpdateSender(false);
            return true;
        }
        if (object == this.m_torusDensity) {
            this.setUpdateSender(true);
            this.initTime();
            this.computeMesh();
            this.computeNeighbour((PgPointSet)this.m_cloud, this.m_influence.getValue());
            this.printTime("Neighbour");
            this.computeTangents((PgPointSet)this.m_cloud, this.m_tangent, this.m_neigh);
            this.printTime("Tangents");
            this.computePrincipal((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Principal Dirs");
            this.computeAnisotropicLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Anisotropic Laplace");
            PjPointCloud.computeLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Compute Laplace");
            this.m_tangent.update((Object)this.m_tangent);
            this.printTime("Update Tangent");
            if (this.m_bRescaleHue) {
                this.computeMaxHue(this.m_vertexColorType, this.m_maxHue);
            }
            this.makeVertexColors((PgPointSet)this.m_cloud, this.m_vertexColorType, this.m_maxHue.getValue());
            this.m_cloud.update((Object)this.m_cloud);
            this.m_surface.update((Object)this.m_surface);
            this.printTime("Update Cloud");
            this.setUpdateSender(false);
            return true;
        }
        if (object == this.m_influence) {
            this.setUpdateSender(true);
            this.initTime();
            this.computeNeighbour((PgPointSet)this.m_cloud, this.m_influence.getValue());
            this.printTime("Neighbour");
            this.computeTangents((PgPointSet)this.m_cloud, this.m_tangent, this.m_neigh);
            this.printTime("Tangents");
            this.computePrincipal((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Principal Dirs");
            this.computeAnisotropicLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Anisotropic Laplace");
            PjPointCloud.computeLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Compute Laplace");
            this.m_tangent.update((Object)this.m_tangent);
            this.printTime("Update Tangent");
            if (this.m_bRescaleHue) {
                this.computeMaxHue(this.m_vertexColorType, this.m_maxHue);
            }
            this.makeVertexColors((PgPointSet)this.m_cloud, this.m_vertexColorType, this.m_maxHue.getValue());
            this.m_cloud.update((Object)this.m_cloud);
            this.printTime("Update Cloud");
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_threshold || object == this.m_maxValence || object == this.m_quotient) {
            this.setUpdateSender(true);
            this.initTime();
            this.computeNeighbour((PgPointSet)this.m_cloud, this.m_influence.getValue());
            this.printTime("Neighbour");
            this.computeTangents((PgPointSet)this.m_cloud, this.m_tangent, this.m_neigh);
            this.printTime("Tangents");
            this.computePrincipal((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Principal Dirs");
            this.computeAnisotropicLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Anisotropic Laplace");
            PjPointCloud.computeLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Compute Laplace");
            this.m_tangent.update((Object)this.m_tangent);
            this.printTime("Update Tangent");
            if (this.m_bRescaleHue) {
                this.computeMaxHue(this.m_vertexColorType, this.m_maxHue);
            }
            this.makeVertexColors((PgPointSet)this.m_cloud, this.m_vertexColorType, this.m_maxHue.getValue());
            this.m_cloud.update((Object)this.m_cloud);
            this.printTime("Update Cloud");
            this.setUpdateSender(false);
            return true;
        }
        if (object == this.m_interior) {
            this.setUpdateSender(true);
            this.initTime();
            this.computeAnisotropicLaplace((PgPointSet)this.m_cloud, this.m_neigh);
            this.printTime("Anisotropic Laplace");
            this.m_cloud.update((Object)this.m_cloud);
            this.printTime("Update Cloud");
            this.setUpdateSender(false);
            return true;
        }
        return super.update(object);
    }

    private void makeStdVectorFields() {
        PgVectorField pgVectorField = new PgVectorField(this.m_cloud.getDimOfVertices(), 0);
        pgVectorField.showIndividualMaterial(true);
        pgVectorField.setGlobalVectorColor(Color.magenta);
        pgVectorField.showVectorArrows(true);
        pgVectorField.setName("PointSet Laplacian");
        pgVectorField.setGeometry((PgPointSet)this.m_cloud);
        this.m_cloud.addVectorField(pgVectorField);
        pgVectorField = new PgVectorField(this.m_cloud.getDimOfVertices(), 0);
        pgVectorField.showIndividualMaterial(true);
        pgVectorField.setGlobalVectorColor(Color.green);
        pgVectorField.showVectorArrows(true);
        pgVectorField.setName("Anisotropic Laplacian");
        pgVectorField.setGeometry((PgPointSet)this.m_cloud);
        this.m_cloud.addVectorField(pgVectorField);
    }

    protected void initTime() {
        if (!this.m_bProfile) {
            return;
        }
        this.m_bInitTime = new Date().getTime();
    }

    protected void printTime(String string) {
        if (!this.m_bProfile) {
            return;
        }
        long l = new Date().getTime() - this.m_bInitTime;
        System.out.println("Duration = " + l + " ms for task: " + string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_import) {
            PsDebug.notify((String)"(m_import): called");
            if (this.m_import.getConfirm() == 2) {
                if (this.m_import.getGeometry() instanceof PgElementSet) {
                    this.m_tempElemSet = (PgElementSet)this.m_import.getGeometry();
                    this.addGeometry((PgGeometryIf)this.m_tempElemSet);
                    this.fitDisplays();
                }
            } else if (this.m_import.getConfirm() == 1) {
                if (this.m_tempElemSet != null) {
                    this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                }
                this.m_tempElemSet = null;
            } else if (this.m_import.getConfirm() == 0) {
                if (this.m_tempElemSet != null) {
                    this.removeGeometry((PgGeometryIf)this.m_tempElemSet);
                }
                this.m_tempElemSet = null;
                this.setGeometry(this.m_import.getGeometry());
            }
        }
    }

    protected PgVectorField getColorVectorField(int n) {
        switch (n) {
            case 0: {
                return this.m_cloud.getVectorField("PointSet Laplacian");
            }
            case 1: {
                return this.m_cloud.getVectorField("Anisotropic Laplacian");
            }
            case 2: {
                return this.m_vf[5];
            }
            case 5: {
                return this.m_vf[2];
            }
        }
        return null;
    }

    public void computeMesh() {
        int n = this.m_torusDensity.getValue();
        this.m_cloud.computeTorus(2 * n, n, 2.0, 1.0);
        this.m_surface.computeTorus(2 * n, n, 2.0, 1.0);
        PuCleanMesh.identifyVertices((PgPointSet)this.m_cloud, (double)0.01);
    }

    public void computeNeighbour(PgPointSet pgPointSet, double d) {
        int n;
        int n2;
        int n3 = pgPointSet.getNumVertices();
        int n4 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        this.m_neigh = PiVector.realloc((PiVector[])this.m_neigh, (int)n3);
        PiVector piVector = new PiVector(n3);
        double d2 = d * d;
        PdVector[] pdVectorArray2 = pgPointSet.getBounds();
        if (pdVectorArray2 == null) {
            return;
        }
        PdMatrix pdMatrix = this.computeCovariance(null, pdVectorArray);
        if (pdMatrix == null) {
            PsDebug.warning((String)("missing vertices to compute covariance matrix, geom = " + pgPointSet.getName()));
            return;
        }
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n4, (int)n4);
        PdVector pdVector = new PdVector(n4);
        int[] nArray = this.computeCovarianceSpectrum(pdMatrix, pdVectorArray3, pdVector);
        PdVector[] pdVectorArray4 = new PdVector[n4];
        for (int i = 0; i < n4; ++i) {
            pdVectorArray4[i] = pdVectorArray3[nArray[n4 - 1 - i]];
        }
        PdVector pdVector2 = pdVectorArray4[0];
        PdVector pdVector3 = pdVectorArray4[1];
        PdVector pdVector4 = pdVectorArray4[2];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray[i]);
        }
        PuMath.heapsort((int)n3, (double[])dArray, (int[])nArray2);
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray3[nArray2[i]] = i;
        }
        int[] nArray4 = new int[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray[i]);
        }
        PuMath.heapsort((int)n3, (double[])dArray2, (int[])nArray4);
        int[] nArray5 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray5[nArray4[i]] = i;
        }
        int[] nArray6 = new int[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray3[i] = PdVector.dot((PdVector)pdVector4, (PdVector)pdVectorArray[i]);
        }
        PuMath.heapsort((int)n3, (double[])dArray3, (int[])nArray6);
        int[] nArray7 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray7[nArray6[n2]] = n2;
        }
        n2 = this.m_maxValence.getValue();
        int[] nArray8 = new int[n3];
        double[] dArray4 = new double[n3];
        int n5 = 0;
        this.m_minNeighCnt = Integer.MAX_VALUE;
        for (n = 0; n < n3; ++n) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            while (dArray[nArray2[n]] - dArray[nArray2[n5]] > d) {
                ++n5;
            }
            for (n10 = nArray5[nArray2[n]] - 1; n10 >= 0 && dArray2[nArray2[n]] - dArray2[nArray4[n10]] < d; --n10) {
            }
            ++n10;
            for (n9 = nArray5[nArray2[n]]; n9 < n3 && dArray2[nArray4[n9]] - dArray2[nArray2[n]] < d; ++n9) {
            }
            --n9;
            for (n8 = nArray7[nArray2[n]]; n8 >= 0 && dArray3[nArray2[n]] - dArray3[nArray6[n8]] < d; --n8) {
            }
            ++n8;
            for (n7 = nArray7[nArray2[n]]; n7 < n3 && dArray3[nArray6[n7]] - dArray3[nArray2[n]] < d; ++n7) {
            }
            --n7;
            int n11 = 0;
            for (n6 = n5; !(n6 >= n3 || n < n6 && dArray[nArray2[n6]] - dArray[nArray2[n]] > d); ++n6) {
                double d3;
                if (nArray5[nArray2[n]] < n10 || n9 < nArray5[nArray2[n]] || nArray7[nArray2[n]] < n8 || n7 < nArray7[nArray2[n]] || n6 == n || (d3 = PdVector.sqrDist((PdVector)pdVectorArray[nArray2[n]], (PdVector)pdVectorArray[nArray2[n6]])) > d2) continue;
                piVector.m_data[n11] = nArray2[n6];
                dArray4[n11] = d3;
                ++n11;
            }
            if (n11 < this.m_minNeighCnt) {
                this.m_minNeighCnt = n11;
            }
            if (!this.m_bEnableMaxValence) {
                this.m_neigh[nArray2[n]].setSize(n11);
                this.m_neigh[nArray2[n]].copy(0, piVector, 0, n11);
                continue;
            }
            PuMath.heapsort((int)n11, (double[])dArray4, (int[])nArray8);
            n11 = Math.min(n11, n2);
            this.m_neigh[nArray2[n]].setSize(n11);
            for (n6 = 0; n6 < n11; ++n6) {
                this.m_neigh[nArray2[n]].m_data[n6] = piVector.m_data[nArray8[n6]];
            }
        }
        for (n = 0; n < n3; ++n) {
            pdVectorArray[n].setName(String.valueOf(this.m_neigh[n].getSize()));
        }
    }

    public static void computeLaplace(PgPointSet pgPointSet, PiVector[] piVectorArray) {
        PgVectorField pgVectorField = pgPointSet.getVectorField(0);
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing mean curvature vector field");
            return;
        }
        int n = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        PdVector[] pdVectorArray2 = pgVectorField.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray2[i].setConstant(0.0);
            int n2 = piVectorArray[i].getSize();
            if (n2 == 0) {
                pdVectorArray[i].setName("");
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                pdVectorArray2[i].add(pdVectorArray[piVectorArray[i].m_data[j]]);
            }
            pdVectorArray2[i].blendBase(pdVectorArray[i], -1.0 / (double)n2, pdVectorArray2[i]);
        }
    }

    public void computeAnisotropicLaplace(PgPointSet pgPointSet, PiVector[] piVectorArray) {
        PgVectorField pgVectorField = pgPointSet.getVectorField(1);
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing anisotropic mean curvature vector field");
            return;
        }
        int n = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n2 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertexNormals();
        PdVector[] pdVectorArray3 = pgVectorField.getVectors();
        PdVector pdVector = new PdVector(n2);
        double d = this.m_threshold.getValue();
        double d2 = this.m_interior.getValue();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].clearTag(1);
            pdVectorArray3[i].setConstant(0.0);
            int n3 = piVectorArray[i].getSize();
            if (n3 == 0) continue;
            boolean bl = false;
            double d3 = this.m_vf[5].getVector(i).length();
            if (this.m_bConstrainInterior) {
                bl = d3 < d2;
            }
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                pdVector.sub(pdVectorArray[i], pdVectorArray[piVectorArray[i].m_data[j]]);
                if (!bl) {
                    double d4 = pdVector.length();
                    if (d4 < 1.0E-10) continue;
                    double d5 = Math.abs(PdVector.dot((PdVector)pdVectorArray2[i], (PdVector)pdVector));
                    if ((d5 /= d4) >= d) {
                        if (this.m_bEnableCutoff) continue;
                        d5 = d * d / (d * d + 10.0 * (d5 - d) * (d5 - d));
                        pdVector.multScalar(d5);
                    }
                }
                ++n4;
                pdVectorArray3[i].add(pdVector);
            }
            if (this.m_bConstrainInterior) {
                if (bl) {
                    PuVectorGeom.projectOntoLine((PdVector)pdVectorArray3[i], (PdVector)pdVectorArray2[i]);
                } else {
                    pdVectorArray[i].setTag(1);
                }
            }
            if (n4 <= true) continue;
            pdVectorArray3[i].multScalar(1.0 / (double)n4);
        }
    }

    public PdMatrix computeCovariance(PdMatrix pdMatrix, PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray[0] == null) {
            return null;
        }
        int n = pdVectorArray[0].getSize();
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(n);
        } else {
            pdMatrix.setSize(n);
        }
        int n2 = pdVectorArray.length;
        PdVector pdVector = new PdVector(n);
        for (int i = 0; i < n2; ++i) {
            pdVector.add(pdVectorArray[i]);
        }
        pdVector.multScalar(1.0 / (double)n2);
        PdMatrix pdMatrix2 = new PdMatrix(n);
        PdVector pdVector2 = new PdVector(n);
        for (int i = 0; i < n2; ++i) {
            pdVector2.sub(pdVector, pdVectorArray[i]);
            pdMatrix2.adjoint(pdVector2);
            pdMatrix.add(pdMatrix2);
        }
        return pdMatrix;
    }

    public int[] computeCovarianceSpectrum(PdMatrix pdMatrix, PdVector[] pdVectorArray, PdVector pdVector) {
        if (pdVector == null || pdVector.getSize() == 0) {
            return null;
        }
        int n = pdVector.getSize();
        PnJacobi.computeEigenvectors((PdMatrix)pdMatrix, (int)n, (PdVector)pdVector, (PdVector[])pdVectorArray);
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        return nArray;
    }

    public void computeTangents(PgPointSet pgPointSet, PgPointSet pgPointSet2, PiVector[] piVectorArray) {
        int n = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n2 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertexNormals();
        pgPointSet2.setNumVertices(n);
        pgPointSet2.assureVertexNormals();
        PdVector[] pdVectorArray3 = pgPointSet2.getVertices();
        for (int i = 0; i < n; ++i) {
            pdVectorArray3[i].copyArray(pdVectorArray[i]);
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                pdVectorArray3[i].add(pdVectorArray[piVectorArray[i].m_data[j]]);
            }
            pdVectorArray3[i].multScalar(1.0 / (double)(n3 + 1));
        }
        PdMatrix pdMatrix = new PdMatrix(n2);
        PdMatrix pdMatrix2 = new PdMatrix(n2);
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)n2, (int)n2);
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6;
            pdVector.setConstant(0.0);
            for (n6 = 0; n6 < 3; ++n6) {
                this.m_vf[n6].setVector(i, pdVector);
            }
            pdMatrix.setConstant(0.0);
            pdVector.sub(pdVectorArray3[i], pdVectorArray[i]);
            pdMatrix2.adjoint(pdVector);
            pdMatrix.copy(pdMatrix2);
            n6 = piVectorArray[i].getSize();
            if (n6 == 0) continue;
            for (n5 = 0; n5 < n6; ++n5) {
                pdVector.sub(pdVectorArray3[i], pdVectorArray[piVectorArray[i].m_data[n5]]);
                pdMatrix2.adjoint(pdVector);
                pdMatrix.add(pdMatrix2);
            }
            PnJacobi.computeEigenvectors((PdMatrix)pdMatrix, (int)n2, (PdVector)pdVector2, (PdVector[])pdVectorArray4);
            n5 = pdVector2.indexOfAbsMin();
            pdVectorArray4[n5].normalize();
            if (PdVector.dot((PdVector)pdVectorArray4[n5], (PdVector)pdVectorArray2[i]) < 0.0) {
                for (n4 = 0; n4 < this.m_dim; ++n4) {
                    pdVectorArray4[n4].multScalar(-1.0);
                }
            }
            this.m_vf[0].setVector(i, pdVectorArray4[n5]);
            n4 = pdVector2.indexOfAbsMax();
            pdVectorArray4[n4].setLength(Math.abs(pdVector2.getEntry(n4)));
            this.m_vf[2].setVector(i, pdVectorArray4[n4]);
            int n7 = -1;
            for (int j = 0; j < this.m_dim; ++j) {
                if (j == n5 || j == n4) continue;
                n7 = j;
                break;
            }
            if (n7 != -1) {
                pdVectorArray4[n7].setLength(Math.abs(pdVector2.getEntry(n7)));
                this.m_vf[1].setVector(i, pdVectorArray4[n7]);
            }
            if (n6 < 2) continue;
            pgPointSet.setVertexNormal(i, pdVectorArray4[n5]);
        }
    }

    public void computePrincipal(PgPointSet pgPointSet, PiVector[] piVectorArray) {
        int n = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n2 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertexNormals();
        PdMatrix pdMatrix = new PdMatrix(n2);
        PdMatrix pdMatrix2 = new PdMatrix(n2);
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n2, (int)n2);
        for (int i = 0; i < n; ++i) {
            int n3;
            pdMatrix.setConstant(0.0);
            int n4 = piVectorArray[i].getSize();
            if (n4 == 0) continue;
            double d = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                pdVector.sub(pdVectorArray[i], pdVectorArray[piVectorArray[i].m_data[n3]]);
                double d2 = pdVector.length();
                if (d2 < 1.0E-10) continue;
                double d3 = PdVector.dot((PdVector)pdVectorArray2[i], (PdVector)pdVector);
                pdVector2.blendBase(pdVector, -d3, pdVectorArray2[i]);
                if (!pdVector2.normalize()) continue;
                d += (d3 /= d2);
                pdMatrix2.adjoint(pdVector2);
                pdMatrix2.multScalar(d3);
                pdMatrix.add(pdMatrix2);
            }
            pdMatrix2.adjoint(pdVectorArray2[i]);
            n3 = 0;
            while (n3 < n2) {
                double[] dArray = pdMatrix2.m_data[n3];
                int n5 = n3++;
                dArray[n5] = dArray[n5] - 1.0;
            }
            pdMatrix2.multScalar(d / 4.0);
            pdMatrix.add(pdMatrix2);
            pdMatrix.multScalar(4.0 / (double)n4);
            PnJacobi.computeEigenvectors((PdMatrix)pdMatrix, (int)n2, (PdVector)pdVector3, (PdVector[])pdVectorArray3);
            for (n3 = 0; n3 < this.m_dim; ++n3) {
                pdVectorArray3[n3].setLength(Math.abs(pdVector3.getEntry(n3)));
            }
            n3 = pdVector3.indexOfAbsMin();
            if (PdVector.dot((PdVector)pdVectorArray3[n3], (PdVector)pdVectorArray2[i]) < 0.0) {
                for (int j = 0; j < this.m_dim; ++j) {
                    pdVectorArray3[j].multScalar(-1.0);
                }
            }
            this.m_vf[3].setVector(i, pdVectorArray3[n3]);
            int n6 = pdVector3.indexOfAbsMax();
            this.m_vf[5].setVector(i, pdVectorArray3[n6]);
            int n7 = -1;
            for (int j = 0; j < this.m_dim; ++j) {
                if (j == n3 || j == n6) continue;
                n7 = j;
                break;
            }
            if (n7 == -1) continue;
            this.m_vf[4].setVector(i, pdVectorArray3[n7]);
        }
    }

    protected void assureVertexSizes() {
        this.m_cloud.showVertexSizes(this.m_bZDensity);
        if (this.m_bZDensity) {
            PdVector[] pdVectorArray = this.m_cloud.getBounds();
            if (pdVectorArray == null) {
                return;
            }
            double d = pdVectorArray[0].getEntry(this.m_dim - 1);
            double d2 = pdVectorArray[1].getEntry(this.m_dim - 1);
            double d3 = d2 - d;
            int n = this.m_cloud.getNumVertices();
            PdVector[] pdVectorArray2 = this.m_cloud.getVertices();
            double d4 = this.m_zDensityLevel.getValue();
            Random random = new Random(1L);
            for (int i = 0; i < n; ++i) {
                double d5 = pdVectorArray2[i].getEntry(this.m_dim - 1);
                double d6 = -1.0 + 2.0 * (d5 - d) / d3 + (2.0 - 2.0 * d4) + random.nextDouble();
                if (d6 < 0.5) {
                    d6 = 0.0;
                } else if (d6 >= 0.5) {
                    d6 = 1.0;
                }
                this.m_cloud.setVertexSize(i, d6 * this.m_cloud.getGlobalVertexSize());
            }
        }
    }

    protected void makeVertexColors(PgPointSet pgPointSet, int n, double d) {
        PgVectorField pgVectorField;
        PgVectorField pgVectorField2;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                PgVectorField pgVectorField3 = this.getColorVectorField(n);
                this.makeVertexColors(pgPointSet, pgVectorField3, d);
                return;
            }
        }
        switch (n) {
            case 3: {
                pgVectorField2 = this.m_vf[4];
                pgVectorField = this.m_vf[5];
                break;
            }
            case 4: {
                pgVectorField2 = this.m_vf[1];
                pgVectorField = this.m_vf[2];
                break;
            }
            default: {
                PsDebug.error((String)("unknown type = " + String.valueOf(n)));
                return;
            }
        }
        pgPointSet.assureVertexColors();
        int n2 = pgPointSet.getNumVertices();
        if (d < 1.0E-10) {
            Color color = Color.getHSBColor(0.7f, 1.0f, 1.0f);
            for (int i = 0; i < n2; ++i) {
                pgPointSet.setVertexColor(i, color);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                double d2 = pgVectorField2.getVector(i).length();
                double d3 = pgVectorField.getVector(i).length();
                double d4 = d3 < 1.0E-10 ? 0.7 : 0.7 * (1.0 - Math.min(d, 1.0 - d2 / d3) / d);
                pgPointSet.setVertexColor(i, Color.getHSBColor((float)d4, 1.0f, 1.0f));
            }
        }
    }

    protected void makeVertexColors(PgPointSet pgPointSet, PgVectorField pgVectorField, double d) {
        pgPointSet.assureVertexColors();
        int n = pgPointSet.getNumVertices();
        if (d < 1.0E-10) {
            Color color = Color.getHSBColor(0.7f, 1.0f, 1.0f);
            for (int i = 0; i < n; ++i) {
                pgPointSet.setVertexColor(i, color);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                PdVector pdVector = pgVectorField.getVector(i);
                double d2 = 0.7 * (1.0 - Math.min(1.0, pdVector.length() / d));
                pgPointSet.setVertexColor(i, Color.getHSBColor((float)d2, 1.0f, 1.0f));
            }
        }
    }

    protected void computeMaxHue(int n, PuDouble puDouble) {
        PgVectorField pgVectorField = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                pgVectorField = this.getColorVectorField(n);
            }
        }
        if (pgVectorField != null) {
            int n2 = pgVectorField.getNumVectors();
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                PdVector pdVector = pgVectorField.getVector(i);
                double d2 = pdVector.length();
                if (d2 < d) continue;
                d = d2;
            }
            if (d != puDouble.getValue()) {
                puDouble.setValue(d);
            }
            return;
        }
        puDouble.setValue(1.0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

