/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuComplex;
import jv.number.PuString;
import jv.object.PsDebug;

public class PcMatrix
implements Serializable {
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public PuComplex[][] m_data;

    public Object clone() {
        return PcMatrix.copyNew(this);
    }

    public static PcMatrix copyNew(PcMatrix pcMatrix) {
        if (pcMatrix == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        if (pcMatrix.m_data == null) {
            PsDebug.warning("missing argument data mat.m_data", pcMatrix);
            return null;
        }
        PcMatrix pcMatrix2 = new PcMatrix(pcMatrix.m_iSize, pcMatrix.m_jSize);
        pcMatrix2.copy(pcMatrix);
        return pcMatrix2;
    }

    public PcMatrix() {
        this(0);
    }

    public PcMatrix(int n) {
        this.setSize(n, n);
    }

    public PcMatrix(int n, int n2) {
        this.setSize(n, n2);
    }

    public int getISize() {
        return this.m_iSize;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.isSquare()) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int n) {
        this.setSize(n, n);
    }

    public void setSize(int n, int n2) {
        if (this.m_iSize == n && this.m_jSize == n2) {
            return;
        }
        this.m_iSize = n;
        this.m_jSize = n2;
        this.m_data = new PuComplex[this.m_iSize][this.m_jSize];
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j] = new PuComplex(0.0, 0.0);
            }
        }
    }

    public PuComplex getEntry(int n, int n2) {
        if (n < 0 || this.m_iSize <= n) {
            PsDebug.warning("index i out of range, index=" + n);
            return PuComplex.ZERO;
        }
        if (n2 < 0 || this.m_jSize <= n2) {
            PsDebug.warning("index j out of range, index=" + n2);
            return PuComplex.ZERO;
        }
        return this.m_data[n][n2];
    }

    public void setEntry(int n, int n2, PuComplex puComplex) {
        if (this.m_iSize <= n || this.m_jSize <= n2) {
            this.setSize(n + 1, n2 + 1);
        }
        this.m_data[n][n2] = puComplex;
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public PcMatrix setIdentity() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.m_iSize; ++n2) {
            for (n = 0; n < this.m_jSize; ++n) {
                this.m_data[n2][n].set(0.0, 0.0);
            }
        }
        n2 = Math.min(this.m_iSize, this.m_jSize);
        for (n = 0; n < n2; ++n) {
            this.m_data[n][n].set(1.0, 0.0);
        }
        return this;
    }

    public PcMatrix setConstant(PuComplex puComplex) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].copy(puComplex);
            }
        }
        return this;
    }

    public PcMatrix add(PcMatrix pcMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].add(pcMatrix.m_data[i][j]);
            }
        }
        return this;
    }

    public PcMatrix add(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].copy(pcMatrix.m_data[i][j]);
                this.m_data[i][j].add(pcMatrix2.m_data[i][j]);
            }
        }
        return this;
    }

    public PcMatrix sub(PcMatrix pcMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].sub(pcMatrix.m_data[i][j]);
            }
        }
        return this;
    }

    public PcMatrix sub(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].copy(pcMatrix.m_data[i][j]);
                this.m_data[i][j].sub(pcMatrix2.m_data[i][j]);
            }
        }
        return this;
    }

    public PcMatrix copy(PcMatrix pcMatrix) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].copy(pcMatrix.m_data[i][j]);
            }
        }
        return this;
    }

    public PcMatrix multScalar(PuComplex puComplex) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].mult(puComplex);
            }
        }
        return this;
    }

    public PcMatrix multScalar(PcMatrix pcMatrix, PuComplex puComplex) {
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                this.m_data[i][j].copy(pcMatrix.m_data[i][j]);
                this.m_data[i][j].mult(puComplex);
            }
        }
        return this;
    }

    public PcMatrix leftMult(PcMatrix pcMatrix) {
        int n;
        int n2;
        if (pcMatrix == null || !pcMatrix.isSquare() || pcMatrix.m_iSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return null;
        }
        int n3 = pcMatrix.m_iSize;
        PuComplex[][] puComplexArray = new PuComplex[n3][this.m_jSize];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < this.m_jSize; ++n) {
                puComplexArray[n2][n] = new PuComplex(0.0, 0.0);
                for (int i = 0; i < this.m_iSize; ++i) {
                    puComplexArray[n2][n].add(PuComplex.mult(pcMatrix.m_data[n2][i], this.m_data[i][n]));
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < this.m_jSize; ++n) {
                this.m_data[n2][n] = puComplexArray[n2][n];
            }
        }
        return this;
    }

    public PcMatrix rightMult(PcMatrix pcMatrix) {
        int n;
        int n2;
        if (pcMatrix == null || !pcMatrix.isSquare() || pcMatrix.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return null;
        }
        int n3 = pcMatrix.m_jSize;
        PuComplex[][] puComplexArray = new PuComplex[this.m_iSize][n3];
        for (n2 = 0; n2 < this.m_iSize; ++n2) {
            for (n = 0; n < n3; ++n) {
                puComplexArray[n2][n] = new PuComplex(0.0, 0.0);
                for (int i = 0; i < this.m_jSize; ++i) {
                    puComplexArray[n2][n].add(PuComplex.mult(this.m_data[n2][i], pcMatrix.m_data[i][n]));
                }
            }
        }
        for (n2 = 0; n2 < this.m_iSize; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.m_data[n2][n] = puComplexArray[n2][n];
            }
        }
        return this;
    }

    public PcMatrix mult(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        if (this == pcMatrix || this == pcMatrix2) {
            PsDebug.warning("'this' must be different from argument");
            return null;
        }
        int n = pcMatrix.m_iSize;
        int n2 = pcMatrix2.m_jSize;
        int n3 = pcMatrix.m_jSize;
        if (this.m_iSize != n || this.m_jSize != n2) {
            this.setSize(n, n2);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_data[i][j].set(0.0, 0.0);
                for (int k = 0; k < n3; ++k) {
                    this.m_data[i][j].add(PuComplex.mult(pcMatrix.m_data[i][k], pcMatrix2.m_data[k][j]));
                }
            }
        }
        return this;
    }

    public static PcMatrix multNew(PcMatrix pcMatrix, PcMatrix pcMatrix2) {
        PcMatrix pcMatrix3 = new PcMatrix();
        return pcMatrix3.mult(pcMatrix, pcMatrix2);
    }

    public PcMatrix transpose() {
        PuComplex puComplex = new PuComplex();
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = i + 1; j < this.m_jSize; ++j) {
                puComplex.copy(this.m_data[i][j]);
                this.m_data[i][j].copy(this.m_data[j][i]);
                this.m_data[j][i].copy(puComplex);
            }
        }
        return this;
    }

    public String toString() {
        int n = this.getISize();
        int n2 = this.getJSize();
        StringBuffer stringBuffer = new StringBuffer("PcMatrix(" + n + "," + n2 + "){");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(" " + this.m_data[i][j].toString());
            }
        }
        stringBuffer.append("\n}\n");
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.m_data == null) {
            stringBuffer.append("\t m_data = null\n");
        } else {
            for (int i = 0; i < this.m_iSize; ++i) {
                stringBuffer.append("\t [" + PuString.intToString(i, 3) + "] = {");
                for (int j = 0; j < this.m_jSize; ++j) {
                    stringBuffer.append(" " + this.m_data[i][j].toString());
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public PuComplex[] eigenvalues() {
        if (!this.isSquare() || this.m_iSize != 2) {
            PsDebug.warning("only implemented for 2x2");
            return null;
        }
        PuComplex[] puComplexArray = new PuComplex[2];
        PuComplex puComplex = new PuComplex(this.m_data[0][0]);
        puComplex.sqr();
        puComplex.add(PuComplex.sqr(this.m_data[1][1]));
        puComplex.sub(PuComplex.mult(PuComplex.mult(this.m_data[0][0], this.m_data[1][1]), 2.0));
        puComplex.div(4.0);
        puComplex.add(PuComplex.mult(this.m_data[1][0], this.m_data[0][1]));
        puComplex.sqrt();
        PuComplex puComplex2 = new PuComplex();
        puComplex2.copy(this.m_data[0][0]);
        puComplex2.add(this.m_data[1][1]);
        puComplex2.div(2.0);
        puComplexArray[0] = PuComplex.add(puComplex2, puComplex);
        puComplexArray[1] = PuComplex.sub(puComplex2, puComplex);
        return puComplexArray;
    }

    public PcMatrix minorMatrix(int n, int n2) {
        if (n < 0 || n >= this.m_iSize || n2 < 0 || n2 >= this.m_jSize || this.m_iSize < 2 || this.m_jSize < 2) {
            PsDebug.warning("Illegal minor, row=" + n + ",col=" + n2);
            return null;
        }
        PcMatrix pcMatrix = new PcMatrix(this.m_iSize - 1, this.m_jSize - 1);
        int n3 = 0;
        for (int i = 0; i < this.m_iSize; ++i) {
            if (i == n) continue;
            int n4 = 0;
            for (int j = 0; j < this.m_jSize; ++j) {
                if (j == n2) continue;
                pcMatrix.m_data[n3][n4].copy(this.m_data[i][j]);
                ++n4;
            }
            ++n3;
        }
        return pcMatrix;
    }

    public PuComplex minor(int n, int n2) {
        return this.minorMatrix(n, n2).determinant();
    }

    public PuComplex determinant() {
        if (!this.isSquare()) {
            PsDebug.warning("Matrix must be square");
            return null;
        }
        if (this.m_iSize == 1) {
            return new PuComplex(this.m_data[0][0]);
        }
        PuComplex puComplex = new PuComplex(0.0, 0.0);
        int n = 1;
        for (int i = 0; i < this.m_iSize; ++i) {
            puComplex.add(this.minor(0, i).mult(n).mult(this.m_data[0][i]));
            n *= -1;
        }
        return puComplex;
    }

    public PcMatrix inverse() {
        if (!this.isSquare()) {
            PsDebug.warning("Matrix must be square");
            return null;
        }
        PcMatrix pcMatrix = new PcMatrix(this.m_iSize);
        PuComplex puComplex = this.determinant();
        for (int i = 0; i < this.m_iSize; ++i) {
            for (int j = 0; j < this.m_jSize; ++j) {
                double d = Math.pow(-1.0, i + j);
                pcMatrix.m_data[i][j] = this.minor(j, i).mult(d).div(puComplex);
            }
        }
        return pcMatrix;
    }

    public PuComplex[] aEigenvector(PuComplex puComplex) {
        PuComplex[] puComplexArray = new PuComplex[2];
        PcMatrix pcMatrix = new PcMatrix(2);
        pcMatrix.m_data[0][0].copy(PuComplex.sub(this.m_data[0][0], puComplex));
        pcMatrix.m_data[0][1].copy(this.m_data[0][1]);
        pcMatrix.m_data[1][0].copy(this.m_data[1][0]);
        pcMatrix.m_data[1][1].copy(PuComplex.sub(this.m_data[1][1], puComplex));
        boolean[][] blArray = new boolean[2][2];
        boolean bl = true;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (pcMatrix.m_data[i][j].abs() < 1.0E-10) {
                    blArray[i][j] = true;
                    continue;
                }
                bl = false;
                blArray[i][j] = false;
            }
        }
        if (bl) {
            PsDebug.warning("eigenspace=CxC, eigenvalue=" + puComplex.toString());
            puComplexArray[0] = new PuComplex(1.0, 0.0);
            puComplexArray[1] = new PuComplex(0.0, 0.0);
            return puComplexArray;
        }
        if (blArray[0][0] && blArray[1][0]) {
            PsDebug.warning("eigenspace=Cx{0}, eigenvalue=" + puComplex.toString());
            puComplexArray[0] = new PuComplex(1.0, 0.0);
            puComplexArray[1] = new PuComplex(0.0, 0.0);
            return puComplexArray;
        }
        if (blArray[0][0]) {
            pcMatrix.m_data[0][0].copy(pcMatrix.m_data[1][0]);
            pcMatrix.m_data[1][0].set(0.0, 0.0);
            PuComplex puComplex2 = new PuComplex(pcMatrix.m_data[0][1]);
            pcMatrix.m_data[0][1].copy(pcMatrix.m_data[1][1]);
            pcMatrix.m_data[1][1].copy(puComplex2);
        }
        PuComplex puComplex3 = new PuComplex();
        puComplex3.copy(pcMatrix.m_data[0][1]);
        puComplex3.mult(pcMatrix.m_data[1][0]);
        puComplex3.div(pcMatrix.m_data[0][0]);
        puComplex3.mult(-1.0);
        puComplex3.add(pcMatrix.m_data[1][1]);
        if (puComplex3.abs() > 0.001) {
            PsDebug.warning("eigenspace degenerated, eigenvalue=" + puComplex.toString() + "; botrig=" + puComplex3.toString() + "\n\t" + pcMatrix.toShortString());
            return null;
        }
        puComplexArray[0] = new PuComplex(1.0, 0.0);
        puComplexArray[1] = PuComplex.div(pcMatrix.m_data[0][0], pcMatrix.m_data[0][1]);
        puComplexArray[1].mult(-1.0);
        return puComplexArray;
    }
}

