/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Hashtable;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.objectGui.PsTabsHeader;

public class PsTabPanel
extends PsPanel {
    protected CardLayout m_cardLayout;
    protected PsPanel m_cardPanel;
    protected PsTabsHeader m_tabHeader = new PsTabsHeader(this);
    protected Hashtable m_tabHash;
    static /* synthetic */ Class class$jv$objectGui$PsTabPanel;

    public PsTabPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabHeader, "North");
        this.m_cardLayout = new CardLayout();
        this.m_cardPanel = new PsPanel(this.m_cardLayout);
        this.m_cardPanel.setInsetSize(2);
        this.add((Component)this.m_cardPanel, "Center");
        this.m_tabHash = new Hashtable();
        if (this.getClass() == (class$jv$objectGui$PsTabPanel == null ? (class$jv$objectGui$PsTabPanel = PsTabPanel.class$("jv.objectGui.PsTabPanel")) : class$jv$objectGui$PsTabPanel)) {
            this.init();
        }
    }

    public void init() {
        if (this.m_tabHash.size() > 0) {
            this.m_tabHash.clear();
            this.m_cardPanel.removeAll();
            this.m_tabHeader.init();
        }
    }

    public void addPanel(String string, PsPanel psPanel) {
        if (string == null) {
            PsDebug.warning("missing panel name");
            return;
        }
        if (this.hasPanel(string)) {
            PsDebug.warning("duplicate panel name = " + string);
            return;
        }
        this.m_tabHeader.addPanel(string, null);
        this.m_cardPanel.add(string, psPanel);
        this.m_tabHash.put(string, psPanel);
    }

    public String getCurrentPanel() {
        return this.m_tabHeader.getCurrentPanel();
    }

    public PsPanel getPanel(String string) {
        if (string == null) {
            PsDebug.warning("missing panel name");
            return null;
        }
        if (!this.hasPanel(string)) {
            PsDebug.warning("missing panel, name = " + string);
            return null;
        }
        return (PsPanel)this.m_tabHash.get(string);
    }

    public boolean hasPanel(String string) {
        if (string == null) {
            PsDebug.warning("missing panel name");
            return false;
        }
        return this.m_tabHash.containsKey(string);
    }

    public boolean hasPanel(PsPanel psPanel) {
        if (psPanel == null) {
            PsDebug.warning("missing panel object");
            return false;
        }
        return this.m_tabHash.contains(psPanel);
    }

    public void validate() {
        this.m_cardPanel.validate();
        this.setVisible(this.getCurrentPanel());
        super.validate();
    }

    public void removePanel(String string) {
        if (this.m_tabHash.size() == 0) {
            return;
        }
        if (!this.hasPanel(string)) {
            return;
        }
        PsPanel psPanel = this.getPanel(string);
        this.m_tabHash.remove(string);
        this.m_cardPanel.remove(psPanel);
        this.m_tabHeader.removePanel(string);
    }

    public void setVisible(String string) {
        if (string == null) {
            PsDebug.warning("missing panel name");
            return;
        }
        if (!this.hasPanel(string)) {
            PsDebug.warning("panel not found, name = " + string);
            return;
        }
        this.m_tabHeader.show(string);
        PsPanel psPanel = this.getPanel(string);
        psPanel.update(psPanel.getFather());
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
        this.m_cardLayout.show(this.m_cardPanel, string);
    }

    protected void showFromHeader(String string) {
        if (string == null) {
            PsDebug.warning("missing panel name");
            return;
        }
        if (!this.hasPanel(string)) {
            PsDebug.warning("panel not found, name = " + string);
            return;
        }
        PsPanel psPanel = this.getPanel(string);
        psPanel.update(psPanel.getFather());
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
        this.m_cardLayout.show(this.m_cardPanel, string);
    }

    public void setEnableTab(String string, boolean bl) {
        this.m_tabHeader.setEnabled(string, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

