/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import jv.object.PsDebug;

public final class PsSlotLayout
implements LayoutManager,
Serializable {
    private int m_maxNumSlots;
    private int m_currNumSlots;
    private int m_numComp;
    private Component[] m_comp;
    private int[] m_slot;

    public PsSlotLayout(int n) {
        this.m_maxNumSlots = n;
        this.m_currNumSlots = 0;
        this.m_comp = new Component[this.m_maxNumSlots];
        this.m_slot = new int[this.m_maxNumSlots];
        this.m_numComp = 0;
    }

    public void addLayoutComponent(String string, Component component) {
        int n = 1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong number of slots, name = " + string);
            return;
        }
        if (this.m_currNumSlots + n > this.m_maxNumSlots) {
            PsDebug.warning("too many slots required");
            return;
        }
        this.m_comp[this.m_numComp] = component;
        this.m_slot[this.m_numComp] = n;
        ++this.m_numComp;
        this.m_currNumSlots += n;
    }

    private Dimension computeLayoutSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        if (n != this.m_numComp) {
            PsDebug.warning("number of components differ");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.m_numComp; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            n2 = Math.max(n2, dimension.width / this.m_slot[i]);
            n3 = Math.max(n3, dimension.height);
        }
        n4 = n2 * this.m_maxNumSlots;
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n4, insets.top + insets.bottom + n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, true);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - (insets.left + insets.right);
        int n2 = container.getSize().height - (insets.top + insets.bottom);
        if (this.m_numComp == 0 || this.m_currNumSlots == 0) {
            return;
        }
        int n3 = n / this.m_currNumSlots;
        int n4 = container.getComponentCount();
        if (n4 != this.m_numComp) {
            PsDebug.warning("number of components differ");
        }
        if (n4 == 0) {
            return;
        }
        int n5 = insets.left;
        for (int i = 0; i < n4; ++i) {
            Component component = container.getComponent(i);
            component.setBounds(n5, insets.top, n3 * this.m_slot[i], n2);
            n5 += n3 * this.m_slot[i];
        }
    }

    public void removeLayoutComponent(Component component) {
    }
}

