/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PvCameraIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PvDisplayLoader {
    protected transient int m_monFac = PsConfig.getMonitorScale();
    protected BitSet m_geometryOption;
    private static String m_fileName = "<BufferedReader>";
    private int m_jvdVersion = Integer.MAX_VALUE;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public static PvDisplayOption[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        m_fileName = string;
        PvDisplayLoader pvDisplayLoader = new PvDisplayLoader();
        PvDisplayOption[] pvDisplayOptionArray = pvDisplayLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        m_fileName = "<BufferedReader>";
        if (pvDisplayOptionArray != null && pvDisplayOptionArray.length > 0) {
            String[] stringArray = new String[]{PsUtil.getFilePath(string)};
            for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
                pvDisplayOptionArray[i].setSearchPaths(stringArray);
            }
        }
        return pvDisplayOptionArray;
    }

    public PvDisplayOption[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parsing XML in reader");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = this.parseRsrcTree(psXmlSrc);
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("failed to interpret content of JVD in reader");
            return null;
        }
        return pvDisplayOptionArray;
    }

    public String write(PvDisplayOption[] pvDisplayOptionArray) {
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pvDisplayOptionArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected PvDisplayOption[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        Object object;
        Object object2;
        int n;
        Object[] objectArray;
        Object object3;
        Object object4;
        String[] stringArray;
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        if (psXmlNode2.getType() == null || !psXmlNode2.getType().equalsIgnoreCase("jv-disp")) {
            PsDebug.warning("missing <jv-disp> element,\nthis is not a valid JavaView display file.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "meta");
        if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
            block2: for (int i = 0; i < psXmlNodeArray.length; ++i) {
                int n2;
                stringArray = psXmlNodeArray[i].getAttribute("generator");
                if (stringArray != null && (object4 = stringArray).startsWith("JavaView v.")) {
                    object3 = object4.substring(object4.indexOf(".") + 1);
                    objectArray = PuString.splitString((String)object3, '.');
                    if (objectArray != null && objectArray.length <= 3) {
                        for (n2 = 0; n2 < objectArray.length; ++n2) {
                            if (n2 == 0) {
                                this.m_jvdVersion = 100000 * Integer.parseInt(objectArray[n2]);
                                continue;
                            }
                            if (n2 == 1) {
                                this.m_jvdVersion += 1000 * Integer.parseInt(objectArray[n2]);
                                continue;
                            }
                            if (n2 != 2) continue;
                            try {
                                this.m_jvdVersion += Integer.parseInt(objectArray[n2]);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    } else {
                        PsDebug.warning("void JavaView version information in meta tag, generator = " + (String)object4);
                    }
                }
                if ((stringArray = psXmlNodeArray[i].getAttribute("dtd")) == null || (object4 = PuString.splitString((String)stringArray, '.')) == null || ((String[])object4).length <= 0) continue;
                object3 = new int[((String[])object4).length];
                for (int j = 0; j < ((String[])object4).length; ++j) {
                    if (j == 0) {
                        this.m_jvdVersion = 100000 * Integer.parseInt(object4[j]);
                    } else if (j == 1) {
                        this.m_jvdVersion += 1000 * Integer.parseInt(object4[j]);
                    } else if (j == 2) {
                        this.m_jvdVersion += Integer.parseInt(object4[j]);
                    }
                    object3[j] = Integer.parseInt(object4[j]);
                }
                objectArray = PsConfig.getVersion(12);
                for (n2 = 0; n2 < Math.min(1, ((String[])object4).length); ++n2) {
                    if (objectArray[n2] == object3[n2]) continue;
                    if (objectArray[n2] > object3[n2]) continue block2;
                    PsDebug.message("Parsing a JVD file with jv-disp.dtd version=" + (String)stringArray + " which is newer than\n\tversion=" + (int)objectArray[0] + "." + (int)objectArray[1] + "." + (int)objectArray[2] + " implemented by the loader of this JavaView program.\n\tMight need to upgrade JavaView.", false);
                    continue block2;
                }
            }
        }
        String string = null;
        stringArray = null;
        object4 = null;
        object3 = PsXmlSrc.getRsrcNode(psXmlNode2, "version");
        if (object3 == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            stringArray = "dump";
        } else {
            string = ((PsXmlNode)object3).getContent();
            stringArray = ((PsXmlNode)object3).getAttribute("type");
        }
        objectArray = PsXmlSrc.getRsrc(psXmlNode2, "title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode2, "description");
        object4 = psXmlNode3 != null ? PsXmlSrc.getRsrc(psXmlNode3, "abstract") : PsXmlSrc.getRsrc(psXmlNode2, "abstract");
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode2, "displays");
        if (psXmlNode4 == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] stringArray2 = new String[]{"tag", "name"};
        PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode4, "display");
        if (psXmlNodeArray2 == null || psXmlNodeArray2.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[psXmlNodeArray2.length];
        for (n = 0; n < psXmlNodeArray2.length; ++n) {
            int n3;
            PsXmlNode psXmlNode5;
            Object object5;
            Object object6;
            int n4;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            int n5;
            Object object15;
            Object object16;
            pvDisplayOptionArray[n] = new PvDisplayOption(1);
            pvDisplayOptionArray[n].setVersion(string);
            pvDisplayOptionArray[n].setVersionType((String)stringArray);
            pvDisplayOptionArray[n].setAbstract((String)object4);
            object2 = psXmlNodeArray2[n].getAttribute("name");
            if (objectArray != null) {
                pvDisplayOptionArray[n].setTitle((String)objectArray);
            } else if (object2 != null) {
                pvDisplayOptionArray[n].setTitle((String)object2);
            }
            pvDisplayOptionArray[n].setName((String)object2);
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 1, psXmlNodeArray2[n].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 4, psXmlNodeArray2[n].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 5, psXmlNodeArray2[n].getAttribute("axes"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 6, psXmlNodeArray2[n].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 11, psXmlNodeArray2[n].getAttribute("border"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 12, psXmlNodeArray2[n].getAttribute("boundingBox"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 13, psXmlNodeArray2[n].getAttribute("center"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 44, psXmlNodeArray2[n].getAttribute("clearScreen"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 34, psXmlNodeArray2[n].getAttribute("copyright"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 14, psXmlNodeArray2[n].getAttribute("cross"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 15, psXmlNodeArray2[n].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 16, psXmlNodeArray2[n].getAttribute("doubleBuffer"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 17, psXmlNodeArray2[n].getAttribute("drawing"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 18, psXmlNodeArray2[n].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 40, psXmlNodeArray2[n].getAttribute("edgesOnce"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 46, psXmlNodeArray2[n].getAttribute("fillDisplay"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 20, psXmlNodeArray2[n].getAttribute("frame"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 21, psXmlNodeArray2[n].getAttribute("info"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 39, psXmlNodeArray2[n].getAttribute("integerPick"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 23, psXmlNodeArray2[n].getAttribute("magnet"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 47, psXmlNodeArray2[n].getAttribute("scenegraph"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 24, psXmlNodeArray2[n].getAttribute("single"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 25, psXmlNodeArray2[n].getAttribute("sorting"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 33, psXmlNodeArray2[n].getAttribute("title"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 26, psXmlNodeArray2[n].getAttribute("visible"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 27, psXmlNodeArray2[n].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 28, psXmlNodeArray2[n].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 29, psXmlNodeArray2[n].getAttribute("yzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 30, psXmlNodeArray2[n].getAttribute("zBuffer"));
            object = psXmlNodeArray2[n].getAttribute("3dLook");
            if (object != null) {
                PsDebug.warning("found deprecated display attribute \"3dLook\", change to \"thickLook\"");
                PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 37, (String)object);
            }
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 37, psXmlNodeArray2[n].getAttribute("thickLook"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 38, psXmlNodeArray2[n].getAttribute("adaptiveSize"));
            psXmlNode = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "axes");
            if (psXmlNode != null) {
                object16 = psXmlNode.getAttribute("longHash");
                if (object16 != null && ((String)object16).length() == 6) {
                    object15 = new boolean[6];
                    object16 = ((String)object16).toLowerCase();
                    for (n5 = 0; n5 < 6; ++n5) {
                        object15[n5] = ((String)object16).charAt(n5) == 't';
                    }
                    pvDisplayOptionArray[n].setAxesHash((boolean[])object15);
                }
                object15 = psXmlNode.getAttribute("dim");
                int n6 = 3;
                if (object15 != null && ((String)object15).equalsIgnoreCase("2")) {
                    n6 = 2;
                }
                if ((object14 = psXmlNode.getAttribute("visible")) != null && ((String)object14).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(5, true);
                }
                if ((object13 = psXmlNode.getAttribute("autoBounds")) != null && ((String)object13).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(42, false);
                }
                if ((object12 = psXmlNode.getAttribute("autoHashing")) == null) {
                    object12 = psXmlNode.getAttribute("autoConfigure");
                }
                if (object12 != null && ((String)object12).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(41, false);
                }
                if ((object11 = psXmlNode.getAttribute("autoLayout")) != null && ((String)object11).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(43, false);
                }
                if ((object10 = psXmlNode.getAttribute("coordSystem")) != null) {
                    if (((String)object10).equalsIgnoreCase("adjust")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(0);
                    } else if (((String)object10).equalsIgnoreCase("scene")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(1);
                    } else if (((String)object10).equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(2);
                    } else if (((String)object10).equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[n].setAxesCoordSystem(3);
                    } else {
                        PsDebug.warning("unknown coordinate system of axes, coordSystem = " + (String)object10);
                    }
                }
                if ((object9 = psXmlNode.getAttribute("type")) == null) {
                    object9 = "center";
                }
                if ((object8 = psXmlNode.getAttribute("span")) == null) {
                    object8 = "xy";
                }
                if (((String)object9).equalsIgnoreCase("bndbox")) {
                    if (n6 == 2) {
                        pvDisplayOptionArray[n].setAxesType(9);
                    } else {
                        pvDisplayOptionArray[n].setAxesType(2);
                    }
                } else if (((String)object9).equalsIgnoreCase("center")) {
                    if (n6 == 2) {
                        if (((String)object8).equalsIgnoreCase("xy")) {
                            pvDisplayOptionArray[n].setAxesType(3);
                        } else if (((String)object8).equalsIgnoreCase("yz")) {
                            pvDisplayOptionArray[n].setAxesType(4);
                        } else if (((String)object8).equalsIgnoreCase("zx")) {
                            pvDisplayOptionArray[n].setAxesType(5);
                        } else {
                            PsDebug.warning("unknown span of axes, span = " + (String)object8);
                        }
                    } else {
                        pvDisplayOptionArray[n].setAxesType(0);
                    }
                } else if (((String)object9).equalsIgnoreCase("corner")) {
                    if (n6 == 2) {
                        if (((String)object8).equalsIgnoreCase("xy")) {
                            pvDisplayOptionArray[n].setAxesType(6);
                        } else if (((String)object8).equalsIgnoreCase("yz")) {
                            pvDisplayOptionArray[n].setAxesType(7);
                        } else if (((String)object8).equalsIgnoreCase("zx")) {
                            pvDisplayOptionArray[n].setAxesType(8);
                        } else {
                            PsDebug.warning("unknown span of axes, span = " + (String)object8);
                        }
                    } else {
                        pvDisplayOptionArray[n].setAxesType(1);
                    }
                } else {
                    PsDebug.warning("unknown type of axes, type = " + (String)object9);
                }
                object7 = PsXmlSrc.getRsrcNodes(psXmlNode, "ruler");
                if (object7 != null) {
                    n4 = ((PsXmlNode[])object7).length;
                    pvDisplayOptionArray[n].setNumRulers(n4);
                    for (n5 = 0; n5 < n4; ++n5) {
                        Color color;
                        int n7;
                        object6 = object7[n5].getAttribute("name");
                        if (object6 != null) {
                            pvDisplayOptionArray[n].setRulerName(n5, (String)object6);
                        }
                        if ((object5 = ((PsXmlNode)object7[n5]).getAttribute("mode")) != null) {
                            if (((String)object5).equalsIgnoreCase("fixed")) {
                                pvDisplayOptionArray[n].setRulerMode(n5, 0);
                            } else if (((String)object5).equalsIgnoreCase("partitioned")) {
                                pvDisplayOptionArray[n].setRulerMode(n5, 1);
                            }
                        }
                        pvDisplayOptionArray[n].showRulerArrow(n5, PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "arrow", "show"));
                        pvDisplayOptionArray[n].showRulerName(n5, PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "label", "show"));
                        pvDisplayOptionArray[n].showRulerNumbers(n5, !PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "numbers", "hide"));
                        pvDisplayOptionArray[n].showRulerHashingsNormal(n5, PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "hashsNormal", "show"));
                        pvDisplayOptionArray[n].showRulerHashingsUp(n5, PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "hashsUp", "show"));
                        pvDisplayOptionArray[n].showRulerTicksMajor(n5, !PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "ticksMajor", "hide"));
                        pvDisplayOptionArray[n].showRulerTicksMinor(n5, !PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "ticksMinor", "hide"));
                        pvDisplayOptionArray[n].showRuler(n5, !PvDisplayLoader.hasAttribute((PsXmlNode)object7[n5], "visible", "hide"));
                        double d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n5], "minValue");
                        if (d != 0.0) {
                            pvDisplayOptionArray[n].setRulerMinValue(n5, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n5], "maxValue")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMaxValue(n5, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n5], "minorUnit")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMinorHashUnit(n5, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n5], "majorUnit")) != 0.0) {
                            pvDisplayOptionArray[n].setRulerMajorHashUnit(n5, d);
                        }
                        if (((PsXmlNode)object7[n5]).hasChild("majorHashings") && !((PsXmlNode)object7[n5]).hasChild("minorHashings")) {
                            PsDebug.error("known bug encountered, ruler has majorHashings but no minorHashings.\n\tThis is a known bug of the JavaView, todo: correct your JVD file!");
                        }
                        if ((n7 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7[n5], "minorHashings")) != 0) {
                            pvDisplayOptionArray[n].setRulerNumMinorHashings(n5, n7);
                        }
                        if ((n7 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object7[n5], "majorHashings")) != 0) {
                            pvDisplayOptionArray[n].setRulerNumMajorHashings(n5, n7);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object7[n5], "color")) != null) {
                            pvDisplayOptionArray[n].setRulerColor(n5, color);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object7[n5], "thickness")) == 0.0) continue;
                        pvDisplayOptionArray[n].setRulerSize(n5, d);
                    }
                }
            }
            if ((object16 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "bndbox")) != null) {
                double d;
                Color color;
                object15 = ((PsXmlNode)object16).getAttribute("visible");
                if (object15 != null && ((String)object15).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(12, true);
                }
                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object16, "color")) != null) {
                    pvDisplayOptionArray[n].setBndBoxColor(color);
                }
                if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object16, "thickness")) != 0.0) {
                    pvDisplayOptionArray[n].setBndBoxSize(d);
                }
            }
            if ((object15 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "boxRatio")) != null) {
                String string2 = ((PsXmlNode)object15).getAttribute("visible");
                if (string2 != null && string2.equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(35, true);
                }
                if ((object14 = PsXmlLoader.parsePdVector((PsXmlNode)object15, null)) != null) {
                    pvDisplayOptionArray[n].setBoxRatio((PdVector)object14);
                }
            }
            if ((psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "clipRange")) != null) {
                int n8;
                object14 = new String("XYZ");
                object13 = psXmlNode5.getAttribute("autoBounds");
                if (object13 != null && ((String)object13).equalsIgnoreCase("hide")) {
                    pvDisplayOptionArray[n].setOption(45, false);
                }
                if ((object12 = psXmlNode5.getAttribute("select")) != null) {
                    n8 = ((String)object14).indexOf((String)object12);
                    if (n8 < 0) {
                        PsDebug.warning("unknown range type, select = " + (String)object12);
                        n8 = 0;
                    }
                    pvDisplayOptionArray[n].setClipBoundsType(n8);
                }
                if ((object11 = psXmlNode5.getAttribute("visible")) != null && ((String)object11).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(36, true);
                }
                if ((object10 = PsXmlSrc.getRsrcNodes(psXmlNode5, "range")) != null && ((PsXmlNode[])object10).length > 0) {
                    for (n5 = 0; n5 < ((PsXmlNode[])object10).length; ++n5) {
                        object9 = object10[n5].getAttribute("type");
                        n8 = ((String)object14).indexOf((String)object9);
                        if (n8 < 0) {
                            PsDebug.warning("unknown range type = " + (String)object9);
                            n8 = n5;
                        }
                        if ((object8 = PsXmlLoader.parsePdVector((PsXmlNode)object10[n5], null)) == null || ((PdVector)object8).getSize() != 2) continue;
                        pvDisplayOptionArray[n].setClipBounds(n8, ((PdVector)object8).m_data);
                    }
                }
            }
            if ((object14 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "cameras")) != null) {
                object13 = ((PsXmlNode)object14).getAttribute("select");
                int n9 = -1;
                for (n5 = 0; n5 < PvCameraIf.CAMERA_NAME.length; ++n5) {
                    if (((String)object13).equals(PvCameraIf.CAMERA_NAME[n5])) {
                        n9 = n5;
                        break;
                    }
                    if (!((String)object13).equals(PvCameraIf.CAMERA_NAME[n5] + " Projection")) continue;
                    n9 = n5;
                    break;
                }
                if (n9 == -1) {
                    PsDebug.warning("unknown selected camera type = " + (String)object13);
                    n9 = 0;
                }
                pvDisplayOptionArray[n].setCurrentCamera(n9);
                object11 = PsXmlSrc.getRsrcNodes((PsXmlNode)object14, "camera");
                if (object11 != null) {
                    pvDisplayOptionArray[n].setNumCameras(((Object)object11).length);
                    for (n3 = 0; n3 < ((Object)object11).length; ++n3) {
                        double d;
                        object10 = ((PsXmlNode)object11[n3]).getAttribute("name");
                        if (object10 != null) {
                            pvDisplayOptionArray[n].setCameraName(n3, (String)object10);
                        }
                        if ((object9 = ((PsXmlNode)object11[n3]).getAttribute("sceneRatio")) != null && ((String)object9).equalsIgnoreCase("show")) {
                            pvDisplayOptionArray[n].setEnabledCameraSceneRatio(n3, true);
                        }
                        object13 = ((PsXmlNode)object11[n3]).getAttribute("projection");
                        int n10 = -1;
                        for (n5 = 0; n5 < PvCameraIf.CAMERA_NAME.length; ++n5) {
                            if (((String)object13).equals(PvCameraIf.CAMERA_NAME[n5])) {
                                n10 = n5;
                                break;
                            }
                            if (!((String)object13).equals(PvCameraIf.CAMERA_NAME[n5] + " Projection")) continue;
                            n10 = n5;
                            break;
                        }
                        if (n10 == -1) {
                            PsDebug.warning("unknown type of camera[" + n5 + "], type = " + (String)object13);
                            n10 = 0;
                        }
                        pvDisplayOptionArray[n].setCameraProjection(n3, n10);
                        object7 = PsXmlLoader.parsePdVector((PsXmlNode)object11[n3], "position", stringArray2);
                        if (object7 != null) {
                            pvDisplayOptionArray[n].setCameraPosition(n3, (PdVector)object7);
                        }
                        if ((object7 = PsXmlLoader.parsePdVector((PsXmlNode)object11[n3], "interest", stringArray2)) != null) {
                            pvDisplayOptionArray[n].setCameraInterest(n3, (PdVector)object7);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object11[n3], "fieldOfView")) == 53.13) {
                            d = 0.0;
                        }
                        pvDisplayOptionArray[n].setCameraFieldOfView(n3, d);
                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object11[n3], "roll");
                        if (d != 0.0) {
                            pvDisplayOptionArray[n].setCameraRoll(n3, d);
                        }
                        if ((object5 = PsXmlSrc.getRsrcNode((PsXmlNode)object11[n3], "clipping")) == null) continue;
                        String string3 = ((PsXmlNode)object5).getAttribute("enable");
                        if (string3 != null && string3.equalsIgnoreCase("show")) {
                            pvDisplayOptionArray[n].setEnabledCameraClip(n3, true);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object11[n3], "near")) != 0.0) {
                            pvDisplayOptionArray[n].setCameraNearClip(n3, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object11[n3], "far")) == 0.0) continue;
                        pvDisplayOptionArray[n].setCameraFarClip(n3, d);
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            object13 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "lights");
            if (object13 != null) {
                String string4 = ((PsXmlNode)object13).getAttribute("lightingModel");
                if (string4 != null) {
                    if (string4.equals("Material")) {
                        pvDisplayOptionArray[n].setLightingModel(0);
                    } else if (string4.equals("Light")) {
                        pvDisplayOptionArray[n].setLightingModel(1);
                    } else if (string4.equals("Lighting")) {
                        PsDebug.warning("deprecated lighting model = " + string4 + ", save JVD with newer JavaView version.");
                        pvDisplayOptionArray[n].setLightingModel(1);
                    } else {
                        PsDebug.warning("unknown lighting model = " + string4);
                    }
                } else {
                    pvDisplayOptionArray[n].setLightingModel(0);
                }
                object11 = ((PsXmlNode)object13).getAttribute("select");
                if (object11 != null) {
                    pvDisplayOptionArray[n].setSelectedLight(Integer.parseInt((String)object11));
                }
                if ((object10 = PsXmlSrc.getRsrcNodes((PsXmlNode)object13, "light")) != null) {
                    pvDisplayOptionArray[n].setNumLights(((PsXmlNode[])object10).length);
                    for (n3 = 0; n3 < ((Object)object10).length; ++n3) {
                        double d;
                        Serializable serializable;
                        String string5;
                        object9 = ((PsXmlNode)object10[n3]).getAttribute("name");
                        if (object9 != null) {
                            pvDisplayOptionArray[n].setLightName(n3, (String)object9);
                        }
                        if ((object8 = ((PsXmlNode)object10[n3]).getAttribute("type")) != null) {
                            if (((String)object8).equalsIgnoreCase("ambient")) {
                                pvDisplayOptionArray[n].setLightType(n3, 0);
                            } else if (((String)object8).equalsIgnoreCase("direction")) {
                                pvDisplayOptionArray[n].setLightType(n3, 1);
                            } else if (((String)object8).equalsIgnoreCase("point")) {
                                pvDisplayOptionArray[n].setLightType(n3, 2);
                            } else if (((String)object8).equalsIgnoreCase("spot")) {
                                pvDisplayOptionArray[n].setLightType(n3, 3);
                            } else if (((String)object8).equalsIgnoreCase("shadow")) {
                                pvDisplayOptionArray[n].setLightType(n3, 4);
                            } else if (((String)object8).equalsIgnoreCase("head")) {
                                pvDisplayOptionArray[n].setLightType(n3, 5);
                            } else if (((String)object8).equalsIgnoreCase("sky")) {
                                pvDisplayOptionArray[n].setLightType(n3, 6);
                            } else {
                                PsDebug.warning("unknown light type = " + (String)object8);
                                pvDisplayOptionArray[n].setLightType(n3, 1);
                            }
                        } else {
                            pvDisplayOptionArray[n].setLightType(n3, 1);
                        }
                        object7 = ((PsXmlNode)object10[n3]).getAttribute("highlight");
                        if (object7 != null) {
                            pvDisplayOptionArray[n].setLightHighlight(n3, ((String)object7).equalsIgnoreCase("on"));
                        }
                        if ((string5 = ((PsXmlNode)object10[n3]).getAttribute("reference")) != null) {
                            if (string5.equalsIgnoreCase("camera")) {
                                pvDisplayOptionArray[n].setLightReference(n3, 1);
                            } else if (string5.equalsIgnoreCase("scene")) {
                                pvDisplayOptionArray[n].setLightReference(n3, 0);
                            } else {
                                PsDebug.warning("unknown light reference = " + string5);
                                pvDisplayOptionArray[n].setLightReference(n3, 0);
                            }
                        }
                        if ((object6 = ((PsXmlNode)object10[n3]).getAttribute("shading")) != null) {
                            if (((String)object6).equalsIgnoreCase("symmetric")) {
                                pvDisplayOptionArray[n].setLightShading(n3, 0);
                            } else if (((String)object6).equalsIgnoreCase("halfSphere")) {
                                pvDisplayOptionArray[n].setLightShading(n3, 1);
                            } else if (((String)object6).equalsIgnoreCase("fullSphere")) {
                                pvDisplayOptionArray[n].setLightShading(n3, 2);
                            } else {
                                PsDebug.warning("unknown light shading = " + (String)object6);
                                pvDisplayOptionArray[n].setLightReference(n3, 0);
                            }
                        }
                        object5 = ((PsXmlNode)object10[n3]).getAttribute("switch");
                        pvDisplayOptionArray[n].setLightSwitchedOn(n3, object5 == null || ((String)object5).equalsIgnoreCase("on"));
                        String string6 = ((PsXmlNode)object10[n3]).getAttribute("visible");
                        pvDisplayOptionArray[n].setLightVisible(n3, string6 != null && string6.equalsIgnoreCase("show"));
                        if (object8 != null && ((String)object8).equalsIgnoreCase("head") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[n].setLightReference(n3, 1);
                            pvDisplayOptionArray[n].setLightShading(n3, 0);
                            pvDisplayOptionArray[n].setLightPosition(n3, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[n].setLightInterest(n3, new PdVector(0.0, 0.0, 0.0));
                        } else if (object8 != null && ((String)object8).equalsIgnoreCase("sky") && this.m_jvdVersion < 110000) {
                            pvDisplayOptionArray[n].setLightReference(n3, 0);
                            pvDisplayOptionArray[n].setLightShading(n3, 0);
                            pvDisplayOptionArray[n].setLightPosition(n3, new PdVector(0.0, 0.0, 10.0));
                            pvDisplayOptionArray[n].setLightInterest(n3, new PdVector(0.0, 0.0, 0.0));
                        } else {
                            serializable = PsXmlLoader.parsePdVector((PsXmlNode)object10[n3], "position", stringArray2);
                            if (serializable != null) {
                                pvDisplayOptionArray[n].setLightPosition(n3, (PdVector)serializable);
                            }
                            if ((serializable = PsXmlLoader.parsePdVector((PsXmlNode)object10[n3], "interest", stringArray2)) != null) {
                                pvDisplayOptionArray[n].setLightInterest(n3, (PdVector)serializable);
                            }
                        }
                        serializable = PsXmlLoader.parseColorRGB((PsXmlNode)object10[n3], "color");
                        if (serializable != null) {
                            pvDisplayOptionArray[n].setLightColor(n3, (Color)serializable);
                        }
                        double d2 = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object10[n3], "intensity");
                        pvDisplayOptionArray[n].setLightIntensity(n3, d2);
                        if (((PsXmlNode)object10[n3]).hasChild("angle")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object10[n3], "angle");
                            pvDisplayOptionArray[n].setLightAngle(n3, d);
                        }
                        if (((PsXmlNode)object10[n3]).hasChild("corona")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object10[n3], "corona");
                            pvDisplayOptionArray[n].setLightCorona(n3, d);
                        }
                        if (((PsXmlNode)object10[n3]).hasChild("exponent")) {
                            d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object10[n3], "exponent");
                            pvDisplayOptionArray[n].setLightExponent(n3, d);
                        }
                        if (!((PsXmlNode)object10[n3]).hasChild("falloff")) continue;
                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object10[n3], "falloff");
                        pvDisplayOptionArray[n].setLightFalloff(n3, d);
                    }
                }
            }
            if ((object12 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "transform")) != null) {
                object11 = ((PsXmlNode)object12).getAttribute("majorMode");
                if (object11 != null) {
                    if (((String)object11).equalsIgnoreCase("rotate")) {
                        pvDisplayOptionArray[n].setMajorMode(0);
                    } else if (((String)object11).equalsIgnoreCase("rotate-xy")) {
                        pvDisplayOptionArray[n].setMajorMode(17);
                    } else if (((String)object11).equalsIgnoreCase("scale")) {
                        pvDisplayOptionArray[n].setMajorMode(1);
                    } else if (((String)object11).equalsIgnoreCase("translate")) {
                        pvDisplayOptionArray[n].setMajorMode(3);
                    } else if (((String)object11).equalsIgnoreCase("translate-z")) {
                        pvDisplayOptionArray[n].setMajorMode(4);
                    } else if (((String)object11).equalsIgnoreCase("initial")) {
                        pvDisplayOptionArray[n].setMajorMode(6);
                    } else if (((String)object11).equalsIgnoreCase("pick")) {
                        pvDisplayOptionArray[n].setMajorMode(5);
                    } else {
                        PsDebug.warning("unknown major mode = " + (String)object11);
                    }
                }
                if ((object10 = ((PsXmlNode)object12).getAttribute("localTransform")) != null && ((String)object10).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(31, true);
                }
                if ((object9 = ((PsXmlNode)object12).getAttribute("directSelect")) != null && ((String)object9).equalsIgnoreCase("show")) {
                    pvDisplayOptionArray[n].setOption(32, true);
                }
                if ((object8 = ((PsXmlNode)object12).getAttribute("mode")) != null) {
                    if (((String)object8).equalsIgnoreCase("camera")) {
                        pvDisplayOptionArray[n].setTransformMode(0);
                    } else if (((String)object8).equalsIgnoreCase("model")) {
                        pvDisplayOptionArray[n].setTransformMode(1);
                    } else if (((String)object8).equalsIgnoreCase("ambient")) {
                        pvDisplayOptionArray[n].setTransformMode(2);
                    } else {
                        PsDebug.warning("unknown transform mode = " + (String)object8);
                    }
                }
            }
            if ((object11 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "background")) != null) {
                PsXmlNode psXmlNode6;
                object10 = PsXmlLoader.parseColorRGB((PsXmlNode)object11, "color");
                if (object10 != null) {
                    pvDisplayOptionArray[n].setBackgroundColor((Color)object10);
                }
                object9 = ((PsXmlNode)object11).getAttribute("image");
                pvDisplayOptionArray[n].setOption(10, object9 != null && ((String)object9).equalsIgnoreCase("show"));
                object8 = ((PsXmlNode)object11).getAttribute("imageFit");
                if (object8 != null) {
                    if (((String)object8).equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(0);
                    } else if (((String)object8).equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(1);
                    } else if (((String)object8).equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(2);
                    } else if (((String)object8).equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[n].setBackgroundImageFit(3);
                    }
                }
                if ((object7 = PsXmlSrc.getRsrcNode((PsXmlNode)object11, "image")) != null && (psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)object7, "url")) != null) {
                    pvDisplayOptionArray[n].setBackgroundImageFile(psXmlNode6.getContent());
                }
            }
            if ((object10 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "foreground")) != null) {
                PsXmlNode psXmlNode7;
                object9 = PsXmlLoader.parseColorRGB((PsXmlNode)object10, "color");
                if (object9 != null) {
                    pvDisplayOptionArray[n].setForegroundColor((Color)object9);
                }
                object8 = ((PsXmlNode)object10).getAttribute("image");
                pvDisplayOptionArray[n].setOption(19, object8 != null && ((String)object8).equalsIgnoreCase("show"));
                object7 = ((PsXmlNode)object10).getAttribute("imageFit");
                if (object7 != null) {
                    if (((String)object7).equalsIgnoreCase("center")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(0);
                    } else if (((String)object7).equalsIgnoreCase("fit")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(1);
                    } else if (((String)object7).equalsIgnoreCase("resize")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(2);
                    } else if (((String)object7).equalsIgnoreCase("tesselate")) {
                        pvDisplayOptionArray[n].setForegroundImageFit(3);
                    }
                }
                if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object10, "image")) != null && (object6 = PsXmlSrc.getRsrcNode(psXmlNode7, "url")) != null) {
                    pvDisplayOptionArray[n].setForegroundImageFile(((PsXmlNode)object6).getContent());
                }
            }
            if ((object9 = PsXmlSrc.getRsrcNode(psXmlNodeArray2[n], "window")) == null) continue;
            object8 = PsXmlSrc.getRsrcNode((PsXmlNode)object9, "x");
            if (object8 != null) {
                int n11 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object9, "x") * this.m_monFac;
                n4 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object9, "y") * this.m_monFac;
                pvDisplayOptionArray[n].setWindowPosition(new Point(n11, n4));
            }
            int n12 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object9, "width") * this.m_monFac;
            n4 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object9, "height") * this.m_monFac;
            pvDisplayOptionArray[n].setWindowSize(new Dimension(n12, n4));
        }
        object2 = PsXmlSrc.getRsrcNode(psXmlNode2, "authors");
        object = null;
        if (object2 != null) {
            if (((PsXmlNode)object2).hasChild("licensee")) {
                psXmlNode = ((PsXmlNode)object2).getChild("licensee");
                psXmlNode.setType("author");
                PsDebug.error("tag 'licensee' found instead of tag 'author': save or edit file = " + m_fileName);
                if (!PsDebug.getConsole().isShowing()) {
                    ((Component)PsDebug.getConsole()).setVisible(true);
                }
            }
            object = new PsAuthorInfo();
            ((PsAuthorInfo)object).setXmlNode((PsXmlNode)object2);
        }
        for (n = 0; n < psXmlNodeArray2.length; ++n) {
            pvDisplayOptionArray[n].setAuthorInfo((PsAuthorInfo)object);
        }
        return pvDisplayOptionArray;
    }

    private static boolean hasAttribute(PsXmlNode psXmlNode, String string, String string2) {
        return PvDisplayLoader.hasAttribute(psXmlNode.getAttribute(string), string2);
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    private static void parseOption(PvDisplayOption pvDisplayOption, int n, String string) {
        if (string == null) {
            return;
        }
        pvDisplayOption.setOption(n, string.equalsIgnoreCase("show"));
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PvDisplayOption[] pvDisplayOptionArray) {
        PsXmlNode psXmlNode;
        Object object;
        Object object2;
        Serializable serializable;
        PsXmlNode psXmlNode2;
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jv-disp");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        psXmlSrc.setDocName("jv-disp");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-disp.dtd");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
        }
        if (bl) {
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("generator", PsConfig.getProgramAndVersion());
            serializable = psXmlNode2.addChild("meta");
            object2 = PsConfig.getVersion(12);
            object = String.valueOf(object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf(object2[1]);
            if (object2[2] != 0) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf(object2[2]);
            }
            ((PsXmlNode)serializable).addAttribute("dtd", (String)object);
            serializable = psXmlNode2.addChild("meta");
            ((PsXmlNode)serializable).addAttribute("date", new Date().toString());
            psXmlNode = psXmlNode2.addChild("version", pvDisplayOptionArray[0].getVersion());
            psXmlNode.addAttribute("type", pvDisplayOptionArray[0].getVersionType());
            if (pvDisplayOptionArray[0].getTitle() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getTitle());
            } else if (pvDisplayOptionArray[0].getName() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getName());
            }
        }
        if (bl2 && (serializable = pvDisplayOptionArray[0].getAuthorInfo()) != null && ((PsAuthorInfo)serializable).getNumAuthors() > 0 && (object2 = (Object)((PsAuthorInfo)serializable).getXmlNode()) != null) {
            psXmlNode2.addChild((PsXmlNode)object2);
        }
        if (bl3 && pvDisplayOptionArray[0].getAbstract() != null) {
            serializable = psXmlNode2.addChild("description");
            ((PsXmlNode)serializable).addChild("abstract", pvDisplayOptionArray[0].getAbstract());
        }
        serializable = psXmlNode2.addChild("displays");
        for (int i = 0; i < pvDisplayOptionArray.length; ++i) {
            Dimension dimension;
            Serializable serializable2;
            int n;
            String string;
            PsXmlNode psXmlNode3;
            PsXmlNode psXmlNode4;
            int n2;
            PsXmlNode psXmlNode5;
            int n3;
            int n4;
            Object[] objectArray;
            object = ((PsXmlNode)serializable).addChild("display");
            ((PsXmlNode)object).addAttribute("name", pvDisplayOptionArray[i].getName());
            if (pvDisplayOptionArray[i].getOption(1)) {
                ((PsXmlNode)object).addAttribute("antiAlias", "show");
            }
            if (pvDisplayOptionArray[i].getOption(4)) {
                ((PsXmlNode)object).addAttribute("autoRotate", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(11)) {
                ((PsXmlNode)object).addAttribute("border", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(13)) {
                ((PsXmlNode)object).addAttribute("center", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(44)) {
                ((PsXmlNode)object).addAttribute("clearScreen", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(34)) {
                ((PsXmlNode)object).addAttribute("copyright", "show");
            }
            if (pvDisplayOptionArray[i].getOption(14)) {
                ((PsXmlNode)object).addAttribute("cross", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(15)) {
                ((PsXmlNode)object).addAttribute("depthcue", "hide");
            }
            if (!pvDisplayOptionArray[i].getOption(16)) {
                ((PsXmlNode)object).addAttribute("doubleBuffer", "hide");
            }
            if (!pvDisplayOptionArray[i].getOption(17)) {
                ((PsXmlNode)object).addAttribute("drawing", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(18)) {
                ((PsXmlNode)object).addAttribute("edgeAura", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(40)) {
                ((PsXmlNode)object).addAttribute("edgesOnce", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(46)) {
                ((PsXmlNode)object).addAttribute("fillDisplay", "show");
            }
            if (pvDisplayOptionArray[i].getOption(20)) {
                ((PsXmlNode)object).addAttribute("frame", "show");
            }
            if (pvDisplayOptionArray[i].getOption(21)) {
                ((PsXmlNode)object).addAttribute("info", "show");
            }
            if (pvDisplayOptionArray[i].getOption(39)) {
                ((PsXmlNode)object).addAttribute("integerPick", "show");
            }
            if (pvDisplayOptionArray[i].getOption(23)) {
                ((PsXmlNode)object).addAttribute("magnet", "show");
            }
            if (pvDisplayOptionArray[i].getOption(47)) {
                ((PsXmlNode)object).addAttribute("scenegraph", "show");
            }
            if (pvDisplayOptionArray[i].getOption(24)) {
                ((PsXmlNode)object).addAttribute("single", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(25)) {
                ((PsXmlNode)object).addAttribute("sorting", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(37)) {
                ((PsXmlNode)object).addAttribute("thickLook", "show");
            }
            if (pvDisplayOptionArray[i].getOption(33)) {
                ((PsXmlNode)object).addAttribute("title", "show");
            }
            if (!pvDisplayOptionArray[i].getOption(26)) {
                ((PsXmlNode)object).addAttribute("visible", "hide");
            }
            if (pvDisplayOptionArray[i].getOption(27)) {
                ((PsXmlNode)object).addAttribute("xyGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(28)) {
                ((PsXmlNode)object).addAttribute("xzGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(29)) {
                ((PsXmlNode)object).addAttribute("yzGrid", "show");
            }
            if (pvDisplayOptionArray[i].getOption(30)) {
                ((PsXmlNode)object).addAttribute("zBuffer", "show");
            }
            if (pvDisplayOptionArray[i].getOption(38)) {
                ((PsXmlNode)object).addAttribute("adaptiveSize", "show");
            }
            if (pvDisplayOptionArray[i].getAxes() != null) {
                psXmlNode = ((PsXmlNode)object).addChild("axes");
                psXmlNode.addAttribute("name", pvDisplayOptionArray[i].getAxes().getName());
                objectArray = pvDisplayOptionArray[i].getAxesHash();
                if (objectArray != null) {
                    char[] cArray = new char[6];
                    for (n4 = 0; n4 < 6; ++n4) {
                        cArray[n4] = objectArray[n4] ? 116 : 102;
                    }
                    psXmlNode.addAttribute("longHash", String.valueOf(cArray));
                }
                if (!pvDisplayOptionArray[i].getOption(42)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (!pvDisplayOptionArray[i].getOption(41)) {
                    psXmlNode.addAttribute("autoHashing", "hide");
                }
                if (!pvDisplayOptionArray[i].getOption(43)) {
                    psXmlNode.addAttribute("autoLayout", "hide");
                }
                switch (pvDisplayOptionArray[i].getAxesCoordSystem()) {
                    default: {
                        psXmlNode.addAttribute("coordSystem", "adjust");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("coordSystem", "scene");
                        break;
                    }
                    case 2: {
                        psXmlNode.addAttribute("coordSystem", "model");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("coordSystem", "ambient");
                    }
                }
                psXmlNode.addAttribute("dim", String.valueOf(pvDisplayOptionArray[i].getDimAxes()));
                if (pvDisplayOptionArray[i].getOption(5)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                switch (pvDisplayOptionArray[i].getAxesType()) {
                    case 2: {
                        psXmlNode.addAttribute("type", "bndbox");
                        break;
                    }
                    case 0: {
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 1: {
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 3: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 4: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 5: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "center");
                        break;
                    }
                    case 6: {
                        psXmlNode.addAttribute("span", "xy");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 7: {
                        psXmlNode.addAttribute("span", "yz");
                        psXmlNode.addAttribute("type", "corner");
                        break;
                    }
                    case 8: {
                        psXmlNode.addAttribute("span", "zx");
                        psXmlNode.addAttribute("type", "corner");
                    }
                }
                n3 = pvDisplayOptionArray[i].getNumRulers();
                for (n4 = 0; n4 < n3; ++n4) {
                    psXmlNode5 = psXmlNode.addChild("ruler");
                    psXmlNode5.addAttribute("name", pvDisplayOptionArray[i].getRulerName(n4));
                    if (pvDisplayOptionArray[i].getRulerMode(n4) == 1) {
                        psXmlNode5.addAttribute("mode", "partitioned");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerArrow(n4)) {
                        psXmlNode5.addAttribute("arrow", "show");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerName(n4)) {
                        psXmlNode5.addAttribute("label", "show");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerNumbers(n4)) {
                        psXmlNode5.addAttribute("numbers", "hide");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerHashingsNormal(n4)) {
                        psXmlNode5.addAttribute("hashsNormal", "show");
                    }
                    if (pvDisplayOptionArray[i].isShowingRulerHashingsUp(n4)) {
                        psXmlNode5.addAttribute("hashsUp", "show");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerTicksMajor(n4)) {
                        psXmlNode5.addAttribute("ticksMajor", "hide");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRulerTicksMinor(n4)) {
                        psXmlNode5.addAttribute("ticksMinor", "hide");
                    }
                    if (!pvDisplayOptionArray[i].isShowingRuler(n4)) {
                        psXmlNode5.addAttribute("visible", "hide");
                    }
                    psXmlNode5.addChild("minValue", pvDisplayOptionArray[i].getRulerMinValue(n4));
                    psXmlNode5.addChild("maxValue", pvDisplayOptionArray[i].getRulerMaxValue(n4));
                    psXmlNode5.addChild("minorUnit", pvDisplayOptionArray[i].getRulerMinorHashUnit(n4));
                    psXmlNode5.addChild("majorUnit", pvDisplayOptionArray[i].getRulerMajorHashUnit(n4));
                    psXmlNode5.addChild("minorHashings", pvDisplayOptionArray[i].getRulerNumMinorHashings(n4));
                    psXmlNode5.addChild("majorHashings", pvDisplayOptionArray[i].getRulerNumMajorHashings(n4));
                    PsXmlLoader.addColor(psXmlNode5, "color", pvDisplayOptionArray[i].getRulerColor(n4));
                    if (pvDisplayOptionArray[i].getRulerSize(n4) == 0.0) continue;
                    psXmlNode5.addChild("thickness", pvDisplayOptionArray[i].getRulerSize(n4));
                }
            }
            if (pvDisplayOptionArray[i].getBndBoxColor() != null || pvDisplayOptionArray[i].getBndBoxSize() != 0.0 || pvDisplayOptionArray[i].getOption(12)) {
                psXmlNode = ((PsXmlNode)object).addChild("bndbox");
                if (pvDisplayOptionArray[i].getOption(12)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                PsXmlLoader.addColor(psXmlNode, "color", pvDisplayOptionArray[i].getBndBoxColor());
                if (pvDisplayOptionArray[i].getBndBoxSize() != 0.0) {
                    psXmlNode.addChild("thickness", pvDisplayOptionArray[i].getBndBoxSize());
                }
            }
            if (pvDisplayOptionArray[i].getBoxRatio() != null || pvDisplayOptionArray[i].getOption(35)) {
                psXmlNode = PsXmlLoader.addVector((PsXmlNode)object, "boxRatio", pvDisplayOptionArray[i].getBoxRatio(), false);
                if (pvDisplayOptionArray[i].getOption(35)) {
                    psXmlNode.addAttribute("visible", "show");
                }
            }
            if (pvDisplayOptionArray[i].getOption(36) || !pvDisplayOptionArray[i].getOption(45)) {
                psXmlNode = ((PsXmlNode)object).addChild("clipRange");
                objectArray = new String[]{"X", "Y", "Z"};
                if (!pvDisplayOptionArray[i].getOption(45)) {
                    psXmlNode.addAttribute("autoBounds", "hide");
                }
                if (pvDisplayOptionArray[i].getClipBoundsType() != -1) {
                    psXmlNode.addAttribute("select", (String)objectArray[pvDisplayOptionArray[i].getClipBoundsType()]);
                }
                if (pvDisplayOptionArray[i].getOption(36)) {
                    psXmlNode.addAttribute("visible", "show");
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    double[] dArray = pvDisplayOptionArray[i].getClipBounds(n3);
                    if (dArray == null || dArray[0] == Double.NEGATIVE_INFINITY && dArray[1] == Double.MAX_VALUE) continue;
                    psXmlNode5 = PsXmlLoader.addVector(psXmlNode, "range", new PdVector(dArray), false);
                    psXmlNode5.addAttribute("type", (String)objectArray[n3]);
                }
            }
            psXmlNode = ((PsXmlNode)object).addChild("cameras");
            int n5 = pvDisplayOptionArray[i].getCurrentCamera();
            if (n5 < 0 || n5 >= PvCameraIf.CAMERA_NAME.length) {
                PsDebug.warning("unknown camera type = " + n5);
            } else {
                psXmlNode.addAttribute("select", PvCameraIf.CAMERA_NAME[n5]);
            }
            n3 = pvDisplayOptionArray[i].getNumCameras();
            for (n4 = 0; n4 < n3; ++n4) {
                psXmlNode5 = psXmlNode.addChild("camera");
                psXmlNode5.addAttribute("name", pvDisplayOptionArray[i].getCameraName(n4));
                if (pvDisplayOptionArray[i].isEnabledCameraSceneRatio(n4)) {
                    psXmlNode5.addAttribute("sceneRatio", "show");
                }
                if ((n2 = pvDisplayOptionArray[i].getCameraProjection(n4)) < 0 || n2 >= PvCameraIf.CAMERA_NAME.length) {
                    PsDebug.warning("unknown camera type = " + n2);
                } else {
                    psXmlNode5.addAttribute("projection", PvCameraIf.CAMERA_NAME[n2]);
                }
                PsXmlLoader.addVector(psXmlNode5, "position", pvDisplayOptionArray[i].getCameraPosition(n4), true);
                PsXmlLoader.addVector(psXmlNode5, "interest", pvDisplayOptionArray[i].getCameraInterest(n4), true);
                psXmlNode5.addChild("fieldOfView", pvDisplayOptionArray[i].getCameraAngle(n4));
                psXmlNode5.addChild("roll", pvDisplayOptionArray[i].getCameraRoll(n4));
                psXmlNode4 = psXmlNode5.addChild("clipping");
                if (pvDisplayOptionArray[i].isEnabledCameraClip(n4)) {
                    psXmlNode4.addAttribute("enable", "show");
                } else {
                    psXmlNode4.addAttribute("enable", "hide");
                }
                psXmlNode4.addChild("near", pvDisplayOptionArray[i].getCameraNearClip(n4));
                psXmlNode4.addChild("far", pvDisplayOptionArray[i].getCameraFarClip(n4));
            }
            PsXmlNode psXmlNode6 = ((PsXmlNode)object).addChild("lights");
            int n6 = pvDisplayOptionArray[i].getLightingModel();
            switch (n6) {
                case 0: {
                    psXmlNode6.addAttribute("lightingModel", "Material");
                    break;
                }
                case 1: {
                    psXmlNode6.addAttribute("lightingModel", "Light");
                    break;
                }
                default: {
                    PsDebug.warning("unknown lighting model = " + n6);
                }
            }
            n2 = pvDisplayOptionArray[i].getNumLights();
            if (n2 > 0) {
                psXmlNode6.addAttribute("select", String.valueOf(pvDisplayOptionArray[i].getSelectedLight()));
            }
            for (int j = 0; j < n2; ++j) {
                psXmlNode3 = psXmlNode6.addChild("light");
                string = pvDisplayOptionArray[i].getLightName(j);
                if (string != null && !string.equalsIgnoreCase("")) {
                    psXmlNode3.addAttribute("name", string);
                }
                int n7 = pvDisplayOptionArray[i].getLightType(j);
                switch (n7) {
                    case 0: {
                        psXmlNode3.addAttribute("type", "ambient");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("type", "direction");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("type", "point");
                        break;
                    }
                    case 3: {
                        psXmlNode3.addAttribute("type", "spot");
                        break;
                    }
                    case 4: {
                        psXmlNode3.addAttribute("type", "shadow");
                        break;
                    }
                    case 5: {
                        psXmlNode3.addAttribute("type", "head");
                        break;
                    }
                    case 6: {
                        psXmlNode3.addAttribute("type", "sky");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light type = " + n7);
                    }
                }
                if (pvDisplayOptionArray[i].isLightHighlight(j)) {
                    psXmlNode3.addAttribute("highlight", "on");
                } else {
                    psXmlNode3.addAttribute("highlight", "off");
                }
                n = pvDisplayOptionArray[i].getLightReference(j);
                switch (n) {
                    case 1: {
                        psXmlNode3.addAttribute("reference", "camera");
                        break;
                    }
                    case 0: {
                        psXmlNode3.addAttribute("reference", "scene");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light reference = " + n);
                    }
                }
                int n8 = pvDisplayOptionArray[i].getLightShading(j);
                switch (n8) {
                    case 0: {
                        psXmlNode3.addAttribute("shading", "symmetric");
                        break;
                    }
                    case 1: {
                        psXmlNode3.addAttribute("shading", "halfSphere");
                        break;
                    }
                    case 2: {
                        psXmlNode3.addAttribute("shading", "fullSphere");
                        break;
                    }
                    default: {
                        PsDebug.warning("unknown light shading = " + n8);
                    }
                }
                if (pvDisplayOptionArray[i].isLightSwitchedOn(j)) {
                    psXmlNode3.addAttribute("switch", "on");
                } else {
                    psXmlNode3.addAttribute("switch", "off");
                }
                if (pvDisplayOptionArray[i].isLightVisible(j)) {
                    psXmlNode3.addAttribute("visible", "show");
                } else {
                    psXmlNode3.addAttribute("visible", "hide");
                }
                PsXmlLoader.addVector(psXmlNode3, "position", pvDisplayOptionArray[i].getLightPosition(j), true);
                PsXmlLoader.addVector(psXmlNode3, "interest", pvDisplayOptionArray[i].getLightInterest(j), true);
                PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[i].getLightColor(j));
                psXmlNode3.addChild("intensity", pvDisplayOptionArray[i].getLightIntensity(j));
                psXmlNode3.addChild("exponent", pvDisplayOptionArray[i].getLightExponent(j));
                psXmlNode3.addChild("angle", pvDisplayOptionArray[i].getLightAngle(j));
                psXmlNode3.addChild("corona", pvDisplayOptionArray[i].getLightCorona(j));
                psXmlNode3.addChild("falloff", pvDisplayOptionArray[i].getLightFalloff(j));
            }
            psXmlNode4 = ((PsXmlNode)object).addChild("transform");
            int n9 = pvDisplayOptionArray[i].getMajorMode();
            string = "rotate";
            switch (n9) {
                case 0: {
                    string = "rotate";
                    break;
                }
                case 17: {
                    string = "rotate-xy";
                    break;
                }
                case 1: {
                    string = "scale";
                    break;
                }
                case 3: {
                    string = "translate";
                    break;
                }
                case 4: {
                    string = "translate-z";
                    break;
                }
                case 6: {
                    string = "initial";
                    break;
                }
                case 5: {
                    string = "pick";
                    break;
                }
                default: {
                    PsDebug.warning("unknown major mode = " + n9);
                }
            }
            psXmlNode4.addAttribute("majorMode", string);
            if (pvDisplayOptionArray[i].getOption(31)) {
                psXmlNode4.addAttribute("localTransform", "show");
            }
            if (pvDisplayOptionArray[i].getOption(32)) {
                psXmlNode4.addAttribute("directSelect", "show");
            }
            switch (pvDisplayOptionArray[i].getTransformMode()) {
                case 0: {
                    psXmlNode4.addAttribute("mode", "camera");
                    break;
                }
                case 1: {
                    psXmlNode4.addAttribute("mode", "model");
                    break;
                }
                case 2: {
                    psXmlNode4.addAttribute("mode", "ambient");
                    break;
                }
                default: {
                    PsDebug.warning("unknown transformation mode = " + pvDisplayOptionArray[i].getTransformMode());
                }
            }
            psXmlNode3 = ((PsXmlNode)object).addChild("background");
            PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[i].getBackgroundColor());
            boolean bl4 = pvDisplayOptionArray[i].getOption(10);
            String string2 = pvDisplayOptionArray[i].getBackgroundImageFile();
            if (bl4 && string2 != null) {
                if (bl4) {
                    psXmlNode3.addAttribute("image", "show");
                }
                if ((n = pvDisplayOptionArray[i].getBackgroundImageFit()) == 0) {
                    psXmlNode3.addAttribute("imageFit", "center");
                } else if (n == 1) {
                    psXmlNode3.addAttribute("imageFit", "fit");
                } else if (n == 2) {
                    psXmlNode3.addAttribute("imageFit", "resize");
                } else if (n == 3) {
                    psXmlNode3.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown background imageFit type = " + n);
                }
                PsXmlNode psXmlNode7 = psXmlNode3.addChild("image");
                psXmlNode7.addChild("url", string2);
            }
            PsXmlNode psXmlNode8 = ((PsXmlNode)object).addChild("foreground");
            PsXmlLoader.addColor(psXmlNode8, "color", pvDisplayOptionArray[i].getForegroundColor());
            bl4 = pvDisplayOptionArray[i].getOption(19);
            string2 = pvDisplayOptionArray[i].getForegroundImageFile();
            if (bl4 && string2 != null) {
                int n10;
                if (bl4) {
                    psXmlNode8.addAttribute("image", "show");
                }
                if ((n10 = pvDisplayOptionArray[i].getForegroundImageFit()) == 0) {
                    psXmlNode8.addAttribute("imageFit", "center");
                } else if (n10 == 1) {
                    psXmlNode8.addAttribute("imageFit", "fit");
                } else if (n10 == 2) {
                    psXmlNode8.addAttribute("imageFit", "resize");
                } else if (n10 == 3) {
                    psXmlNode8.addAttribute("imageFit", "tesselate");
                } else {
                    PsDebug.warning("unknown foreground imageFit type = " + n10);
                }
                serializable2 = psXmlNode8.addChild("image");
                ((PsXmlNode)serializable2).addChild("url", string2);
            }
            PsXmlNode psXmlNode9 = ((PsXmlNode)object).addChild("window");
            serializable2 = pvDisplayOptionArray[i].getWindowPosition();
            if (serializable2 != null) {
                psXmlNode9.addChild("x", ((Point)serializable2).x / this.m_monFac);
                psXmlNode9.addChild("y", ((Point)serializable2).y / this.m_monFac);
            }
            if ((dimension = pvDisplayOptionArray[i].getWindowSize()) == null) continue;
            psXmlNode9.addChild("width", dimension.width / this.m_monFac);
            psXmlNode9.addChild("height", dimension.height / this.m_monFac);
        }
        return psXmlSrc;
    }
}

