/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgBndElementSet;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgFaceStar;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgTetraSet
extends PgPointSet {
    public static final int[][] LOCAL_EDGE_TO_VERTEX = new int[][]{{1, 2}, {0, 2}, {0, 1}, {0, 3}, {1, 3}, {2, 3}};
    public static final int[][] LOCAL_FACE_TO_EDGE = new int[][]{{5, 4, 0}, {1, 3, 5}, {2, 4, 3}, {0, 2, 1}};
    public static final int[][] FACE_TO_VERTEX = new int[][]{{1, 2, 3}, {3, 2, 0}, {3, 0, 1}, {0, 2, 1}};
    protected boolean m_bShowTetraLabels;
    protected static final int m_dimOfTetras = 4;
    protected int m_numTetras;
    protected int m_maxNumTetras;
    protected PiVector[] m_tetra;
    protected Color[] m_tetraColor;
    protected PiVector[] m_neighbour;
    protected PgBndElementSet[] m_bndList;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected boolean m_bShowTetraTexture;
    protected PdVector[][] m_tetraTexture;
    protected boolean m_bShowEdges;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeColorFromTetras;
    protected boolean m_bShowEdgeColorFromVertices;
    protected PdColor m_globalEdgeColor;
    protected PuDouble m_globalEdgeSize;
    protected PuDouble m_scaleTetraPaint;
    protected boolean m_bShowTetras;
    protected boolean m_bShowTaggedTetras;
    protected boolean m_bShowTetraColors;
    protected PdColor m_globalTetraColor;
    protected PdColor m_globalTetraTagColor;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bShowSmoothTetraColors;
    protected boolean m_bShowTetraColorFromVertices;
    protected int m_numFaces;
    protected PiVector[] m_face;
    protected Color[] m_faceColor;
    protected boolean m_bShowSmallTets = false;
    protected boolean m_bQuadsForTets = true;
    static /* synthetic */ Class class$jv$geom$PgTetraSet;

    public PgTetraSet() {
        this(3);
        this.m_bShowVertices = true;
    }

    public PgTetraSet(int n) {
        super(n);
        this.setType(34);
        this.setTag(7);
        this.addGeometryItem("Tetra");
        this.setDimOfSimplex(2);
        this.m_tetra = new PiVector[0];
        this.m_neighbour = null;
        this.m_tetraTexture = null;
        this.m_globalTetraColor = new PdColor(PsConfig.getMessage(24017), this);
        this.m_globalTetraTagColor = new PdColor(PsConfig.getMessage(24019), this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage(24023), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage(24025), this);
        this.m_scaleTetraPaint = new PuDouble(PsConfig.getMessage(true, 24000, "Tetrahedron Scaling"), this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage(24026), this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage(24027), this);
        if (this.getClass() == (class$jv$geom$PgTetraSet == null ? (class$jv$geom$PgTetraSet = PgTetraSet.class$("jv.geom.PgTetraSet")) : class$jv$geom$PgTetraSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowTetraLabels = false;
        this.m_bShowVertices = false;
        this.setMaxNumTetras(0);
        this.m_bShowTetras = true;
        this.m_bShowTaggedTetras = true;
        this.m_tetraColor = null;
        this.m_bShowTetraColors = false;
        this.m_globalTetraColor.setColor(new Color(255, 225, 0));
        this.m_globalTetraTagColor.setColor(Color.magenta);
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothTetraColors = false;
        this.m_bShowTetraColorFromVertices = false;
        this.m_bShowEdges = true;
        this.m_bShowEdgeColors = false;
        this.m_bShowSmoothEdgeColors = false;
        this.m_bShowEdgeColorFromTetras = false;
        this.m_bShowEdgeColorFromVertices = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_scaleTetraPaint.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_scaleTetraPaint.setDefValue(0.5);
        this.m_scaleTetraPaint.init();
        this.m_bndList = null;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_tetraTexture = null;
        this.m_bShowTetraTexture = false;
        this.m_dimOfTextures = 3;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(34);
        pgJvxSrc.showElementLabels(this.isShowingTetraLabels());
        pgJvxSrc.showTaggedElements(this.isShowingTaggedTetras());
        pgJvxSrc.showElements(this.isShowingTetras());
        pgJvxSrc.setNumElements(this.getNumTetras());
        pgJvxSrc.setElements(this.getTetras());
        pgJvxSrc.setNeighbours(this.getNeighbours());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothTetraColors());
        pgJvxSrc.showElementColorFromVertices(this.isShowingTetraFromVertexColors());
        pgJvxSrc.showElementColors(this.isShowingTetraColors());
        pgJvxSrc.setGlobalElementColor(this.getGlobalTetraColor());
        pgJvxSrc.setGlobalElementTagColor(this.getGlobalTetraTagColor());
        pgJvxSrc.setDimOfTextures(this.getDimOfTextures());
        if (this.hasTetraTextures()) {
            pgJvxSrc.showElementTexture(this.isShowingTetraTexture());
            pgJvxSrc.setElementTextures(this.getTetraTextures());
        } else {
            pgJvxSrc.showElementTexture(false);
        }
        pgJvxSrc.showEdges(this.isShowingEdges());
        pgJvxSrc.showEdgeColors(this.isShowingEdgeColors());
        pgJvxSrc.showEdgeColorFromElements(this.isShowingEdgeColorFromTetras());
        pgJvxSrc.showEdgeColorFromVertices(this.isShowingEdgeColorFromVertices());
        pgJvxSrc.showSmoothEdgeColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgJvxSrc.showBoundaries(this.isShowingBoundaries());
        pgJvxSrc.setGlobalBndColor(this.getGlobalBndColor());
        pgJvxSrc.setGlobalBndTagColor(this.getGlobalBndTagColor());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showTetraLabels(pgJvxSrc.isShowingElementLabels());
        this.showTaggedTetras(pgJvxSrc.isShowingTaggedElements());
        this.showTetras(pgJvxSrc.isShowingElements());
        this.setNumTetras(pgJvxSrc.getNumElements());
        this.setTetras(pgJvxSrc.getElements());
        if (pgJvxSrc.getNeighbours() != null) {
            this.setNeighbours(pgJvxSrc.getNeighbours());
        } else if (PsJavaView.m_bAutoNeighbour) {
            this.makeNeighbour();
        } else {
            this.setNeighbours(null);
        }
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothTetraColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showTetraFromVertexColors(pgJvxSrc.isShowingElementColorFromVertices());
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalTetraColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalTetraTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        this.showTetraColors(pgJvxSrc.isShowingElementColors());
        this.setDimOfTextures(pgJvxSrc.getDimOfTextures());
        this.setTetraTextures(pgJvxSrc.getElementTextures());
        this.showTetraTexture(pgJvxSrc.isShowingElementTexture());
        this.showEdges(pgJvxSrc.isShowingEdges());
        this.showEdgeColors(pgJvxSrc.isShowingEdgeColors());
        this.showEdgeColorFromTetras(pgJvxSrc.isShowingEdgeColorFromElements());
        this.showEdgeColorFromVertices(pgJvxSrc.isShowingEdgeColorFromVertices());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothEdgeColors());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        if (pgJvxSrc.getNumVectorFields() > 0) {
            int n = pgJvxSrc.getNumVectorFields();
            for (int i = 0; i < n; ++i) {
                if (!pgJvxSrc.isVectorElementBased(i)) continue;
                PgVectorField pgVectorField = this.getVectorField(i);
                PdVector[] pdVectorArray = pgJvxSrc.getVectors(i);
                if (pdVectorArray == null) {
                    PsDebug.warning("missing vectors in vector field[" + i + "].");
                    return;
                }
                int n2 = pdVectorArray.length;
                pgVectorField.setGeometry(this);
                pgVectorField.setBasedOn(1);
                pgVectorField.setNumVectors(n2);
                pgVectorField.setVectorColors(pgJvxSrc.getVectorFieldColors(i));
                pgVectorField.setVectors(pdVectorArray);
            }
        }
    }

    public boolean applyModelingMatrix() {
        if (!this.hasModelMatrix()) {
            return false;
        }
        if (this.hasBoundary()) {
            int n = this.getNumBoundaries();
            for (int i = 0; i < n; ++i) {
                this.m_bndList[i].setModelMatrix(this.m_modelMatrix);
                this.m_bndList[i].applyModelingMatrix();
            }
        }
        return super.applyModelingMatrix();
    }

    public Object clone() {
        PgTetraSet pgTetraSet = (PgTetraSet)super.clone();
        if (pgTetraSet == null) {
            return null;
        }
        pgTetraSet.m_globalTetraColor = (PdColor)this.m_globalTetraColor.clone();
        pgTetraSet.m_globalTetraTagColor = (PdColor)this.m_globalTetraTagColor.clone();
        pgTetraSet.m_globalTetraColor.setParent(pgTetraSet);
        pgTetraSet.m_globalTetraTagColor.setParent(pgTetraSet);
        pgTetraSet.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        pgTetraSet.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        pgTetraSet.m_globalBndColor.setParent(pgTetraSet);
        pgTetraSet.m_globalBndTagColor.setParent(pgTetraSet);
        pgTetraSet.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgTetraSet.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgTetraSet.m_globalEdgeSize.setParent(pgTetraSet);
        pgTetraSet.m_globalEdgeColor.setParent(pgTetraSet);
        if (this.m_tetra != null) {
            pgTetraSet.m_tetra = (PiVector[])P_Vector.clone(this.m_tetra);
        }
        if (this.m_tetraColor != null) {
            pgTetraSet.m_tetraColor = (Color[])this.m_tetraColor.clone();
        }
        if (this.m_tetraTexture != null) {
            pgTetraSet.m_tetraTexture = (PdVector[][])P_Vector.clone(this.m_tetraTexture);
        }
        if (this.m_neighbour != null) {
            pgTetraSet.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_bndList != null) {
            pgTetraSet.m_bndList = null;
            int n = this.getNumBoundaries();
            if (n > 0) {
                PgBndElementSet[] pgBndElementSetArray = (PgBndElementSet[])this.m_bndList.clone();
                for (int i = 0; i < n; ++i) {
                    pgBndElementSetArray[i] = (PgBndElementSet)pgBndElementSetArray[i].clone();
                }
                pgTetraSet.setBoundary(pgBndElementSetArray);
            }
        }
        return pgTetraSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgTetraSet)) {
            return;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)psObject;
        this.m_bShowTetraLabels = pgTetraSet.m_bShowTetraLabels;
        this.m_bShowBoundaries = pgTetraSet.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgTetraSet.m_bShowTaggedBoundaries;
        this.m_bShowTetraTexture = pgTetraSet.m_bShowTetraTexture;
        this.m_bShowEdges = pgTetraSet.m_bShowEdges;
        this.m_bShowEdgeColors = pgTetraSet.m_bShowEdgeColors;
        this.m_bShowTetras = pgTetraSet.m_bShowTetras;
        this.m_bShowTaggedTetras = pgTetraSet.m_bShowTaggedTetras;
        this.m_bShowTetraColors = pgTetraSet.m_bShowTetraColors;
        this.m_globalBndColor.copy(pgTetraSet.m_globalBndColor);
        this.m_globalBndTagColor.copy(pgTetraSet.m_globalBndTagColor);
        this.m_globalEdgeColor.copy(pgTetraSet.m_globalEdgeColor);
        this.m_globalEdgeSize.copy(pgTetraSet.m_globalEdgeSize);
        this.m_globalTetraColor.copy(pgTetraSet.m_globalTetraColor);
        this.m_globalTetraTagColor.copy(pgTetraSet.m_globalTetraTagColor);
        this.copyTetraSet(pgTetraSet);
        int n = this.getNumVectorFields();
        for (int i = 0; i < n; ++i) {
            PgVectorField pgVectorField = this.getVectorField(i);
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setGeometry(this);
        }
    }

    public void copyTetraSet(PgTetraSet pgTetraSet) {
        this.setNumTetras(pgTetraSet.getNumTetras());
        PiVector.copy(this.m_tetra, 0, pgTetraSet.getTetras(), 0, this.m_numTetras);
        PiVector[] piVectorArray = pgTetraSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numTetras);
        } else {
            this.m_neighbour = null;
        }
        if (pgTetraSet.m_tetraColor != null) {
            this.assureTetraColors();
            PdColor.copy(this.m_tetraColor, 0, pgTetraSet.getTetraColors(), 0, this.m_numTetras);
        } else {
            this.m_tetraColor = null;
        }
        if (pgTetraSet.m_tetraTexture != null) {
            this.assureTetraTextures();
            for (int i = 0; i < this.m_numTetras; ++i) {
                PdVector.copy(this.m_tetraTexture[i], 0, pgTetraSet.m_tetraTexture[i], 0, pgTetraSet.m_tetraTexture[i].length);
            }
        } else {
            this.m_tetraTexture = null;
        }
        if (pgTetraSet.hasBoundary()) {
            PgBndElementSet[] pgBndElementSetArray = pgTetraSet.getBoundaries();
            this.assureBoundary(pgBndElementSetArray.length);
            for (int i = 0; i < this.m_bndList.length; ++i) {
                this.m_bndList[i].copy(pgBndElementSetArray[i]);
            }
        } else {
            this.m_bndList = null;
        }
    }

    public void copyConnectivity(PgTetraSet pgTetraSet) {
        this.setNumTetras(pgTetraSet.getNumTetras());
        PiVector.copy(this.m_tetra, 0, pgTetraSet.getTetras(), 0, this.m_numTetras);
        PiVector[] piVectorArray = pgTetraSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numTetras);
        } else {
            this.m_neighbour = null;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgTetraSet *********\n");
        stringBuffer.append("\t m_numTetras    = " + this.m_numTetras + " (max = " + this.m_maxNumTetras + ")\n");
        stringBuffer.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        stringBuffer.append("\t ******* m_tetra *******\n");
        if (this.m_tetra != null) {
            for (n = 0; n < this.m_numTetras; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_tetra[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_tetra = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            for (n = 0; n < this.m_numTetras; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        stringBuffer.append("\t ******* m_tetraTexture *******\n");
        if (this.m_tetraTexture != null && this.m_numTetras > 0) {
            for (n = 0; n < this.m_numTetras; ++n) {
                if (this.m_tetraTexture[n] == null) {
                    stringBuffer.append("\t [" + n + "] = null");
                    continue;
                }
                for (int i = 0; i < this.m_tetraTexture[n].length; ++i) {
                    stringBuffer.append("\t [" + n + "][" + i + "] = " + this.m_tetraTexture[n][i].toShortString());
                }
            }
        } else {
            stringBuffer.append("\t m_tetraTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == null || object == this) {
            return super.update(object);
        }
        if (object == this.m_globalBndColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_scaleTetraPaint) {
            return super.update(null);
        }
        if (object == this.m_globalTetraColor) {
            return super.update(null);
        }
        if (object == this.m_globalTetraTagColor) {
            return super.update(null);
        }
        return super.update(object);
    }

    public int addTetra(PiVector piVector) {
        if (piVector == null || piVector.getSize() != 4) {
            PsDebug.warning("argument tetrahedron too small.");
            return -1;
        }
        int n = this.getNumTetras();
        if (this.m_numTetras == this.m_maxNumTetras) {
            this.setMaxNumTetras((int)((double)(this.m_numTetras + 1) * 1.2));
        }
        this.setNumTetras(n + 1);
        this.setTetra(n, piVector);
        if (this.m_tetraColor != null) {
            this.m_tetraColor[n] = this.m_globalTetraColor.getColor();
        }
        return n;
    }

    public Color getGlobalTetraColor() {
        return this.m_globalTetraColor.getColor();
    }

    public Color getGlobalTetraTagColor() {
        return this.m_globalTetraTagColor.getColor();
    }

    public void setGlobalTetraColor(Color color) {
        this.m_globalTetraColor.setColor(color);
    }

    public void setGlobalTetraTagColor(Color color) {
        this.m_globalTetraTagColor.setColor(color);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public PiVector[] getTetras() {
        return this.m_tetra;
    }

    public Color[] getTetraColors() {
        return this.m_tetraColor;
    }

    public PdVector[] getTetraTexture(int n) {
        if (!this.hasTetraTextures()) {
            PsDebug.warning("missing tetrahedron textures");
            return null;
        }
        if (n < 0 || this.m_numTetras <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        return this.m_tetraTexture[n];
    }

    public PdVector[][] getTetraTextures() {
        return this.m_tetraTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasTetraTextures()) {
            return null;
        }
        int n = this.getNumTetraIndices();
        PdVector[] pdVectorArray = new PdVector[n];
        n = 0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            for (int j = 0; j < 4; ++j) {
                pdVectorArray[n++] = this.m_tetraTexture[i][j];
            }
        }
        return pdVectorArray;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public int getNumBoundaries() {
        this.removeDeletedBoundaries();
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public boolean hasBoundary() {
        return this.getNumBoundaries() > 0;
    }

    public PgBndElementSet[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
            return this.m_bndList;
        }
        this.removeDeletedBoundaries();
        return this.m_bndList;
    }

    public void removeBoundaries() {
        if (this.m_bndList == null) {
            return;
        }
        for (int i = 0; i < this.m_bndList.length; ++i) {
            this.m_bndList[i].setTetraSet(null);
        }
        this.m_bndList = null;
    }

    public int removeDeletedBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_bndList.length; ++i) {
            if (this.m_bndList[i].hasTag(2)) continue;
            ++n;
        }
        if (n == this.m_bndList.length) {
            return 0;
        }
        PgBndElementSet[] pgBndElementSetArray = this.m_bndList;
        this.m_bndList = new PgBndElementSet[n];
        int n2 = 0;
        for (int i = 0; i < pgBndElementSetArray.length; ++i) {
            if (pgBndElementSetArray[i].hasTag(2)) {
                pgBndElementSetArray[i].setTetraSet(null);
                continue;
            }
            this.m_bndList[n2++] = pgBndElementSetArray[i];
        }
        return pgBndElementSetArray.length - n;
    }

    public void setBoundary(PgBndElementSet[] pgBndElementSetArray) {
        if (pgBndElementSetArray == null) {
            this.removeBoundaries();
            return;
        }
        this.m_bndList = new PgBndElementSet[pgBndElementSetArray.length];
        for (int i = 0; i < pgBndElementSetArray.length; ++i) {
            this.m_bndList[i] = pgBndElementSetArray[i];
            this.m_bndList[i].setTetraSet(this);
        }
        this.removeDeletedBoundaries();
    }

    public void assureBoundary(int n) {
        int n2;
        if (this.m_bndList != null && this.m_bndList.length == n) {
            return;
        }
        PgBndElementSet[] pgBndElementSetArray = this.m_bndList;
        this.m_bndList = new PgBndElementSet[n];
        int n3 = 0;
        if (pgBndElementSetArray != null) {
            n3 = pgBndElementSetArray.length;
            for (n2 = 0; n2 < Math.min(n3, n); ++n2) {
                this.m_bndList[n2] = pgBndElementSetArray[n2];
                this.m_bndList[n2].clearTag(2);
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.m_bndList[n2] = new PgBndElementSet(this.m_dim);
            this.m_bndList[n2].setName("Boundary_" + String.valueOf(n2));
            this.m_bndList[n2].setTetraSet(this);
            this.m_bndList[n2].setDimOfVectors(this.getDimOfVectors());
        }
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromTetras() {
        return this.m_bShowEdgeColorFromTetras;
    }

    public void showEdgeColorFromTetras(boolean bl) {
        this.m_bShowEdgeColorFromTetras = bl;
        if (bl && this.m_bShowEdgeColorFromVertices) {
            this.m_bShowEdgeColorFromVertices = false;
        }
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromVertices() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeColorFromVertices(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
        if (bl && this.m_bShowEdgeColorFromTetras) {
            this.m_bShowEdgeColorFromTetras = false;
        }
    }

    public boolean isShowingTetraLabels() {
        return this.m_bShowTetraLabels;
    }

    public boolean isShowingTetras() {
        return this.m_bShowTetras;
    }

    public boolean isShowingTaggedTetras() {
        return this.m_bShowTaggedTetras;
    }

    public boolean isShowingTetraTexture() {
        return this.m_bShowTetraTexture;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public boolean isShowingTetraColors() {
        return this.m_bShowTetraColors;
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public boolean isShowingSmoothTetraColors() {
        return this.m_bShowSmoothTetraColors;
    }

    public void showSmoothTetraColors(boolean bl) {
        this.m_bShowSmoothTetraColors = bl;
    }

    public boolean isShowingTetraColorFromVertices() {
        return this.m_bShowTetraColorFromVertices;
    }

    public void showTetraColorFromVertices(boolean bl) {
        this.m_bShowTetraColorFromVertices = bl;
    }

    public boolean isShowingTetraFromVertexColors() {
        return this.isShowingTetraColorFromVertices();
    }

    public void showTetraFromVertexColors(boolean bl) {
        this.showTetraColorFromVertices(bl);
    }

    public void showTetraLabels(boolean bl) {
        this.m_bShowTetraLabels = bl;
    }

    public void showTetras(boolean bl) {
        this.m_bShowTetras = bl;
    }

    public void showTaggedTetras(boolean bl) {
        this.m_bShowTaggedTetras = bl;
    }

    public void showTetraTexture(boolean bl) {
        this.m_bShowTetraTexture = bl;
        if (bl && this.isShowingVertexTexture()) {
            this.showVertexTexture(false);
        }
    }

    public void showVertexTexture(boolean bl) {
        if (bl && this.isShowingTetraTexture()) {
            this.showTetraTexture(false);
        }
        super.showVertexTexture(bl);
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void showTaggedBoundaries(boolean bl) {
        this.m_bShowTaggedBoundaries = bl;
    }

    public void showTetraColors(boolean bl) {
        this.m_bShowTetraColors = bl;
    }

    private int computeNumFaces() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numTetras * 4;
        } else {
            for (int i = 0; i < this.m_numTetras; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.m_neighbour[i].m_data[j] >= i) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumFaces() {
        this.m_numFaces = this.computeNumFaces();
        return this.m_numFaces;
    }

    public void setNumFaces(int n) {
        if (this.m_numFaces == n) {
            return;
        }
        this.m_face = PiVector.realloc(this.m_face, n, 3);
        this.m_numFaces = n;
        if (this.hasTetraColors()) {
            this.assureFaceColors();
        }
    }

    protected void assureFaceColors() {
        if (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces) {
            this.m_faceColor = PdColor.realloc(this.m_faceColor, this.m_numFaces);
        }
    }

    public int getMaxNumTetras() {
        return this.m_maxNumTetras;
    }

    public void setMaxNumTetras(int n) {
        if (this.m_maxNumTetras == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumTetras = n;
            return;
        }
        this.m_tetra = PiVector.realloc(this.m_tetra, n, 4);
        if (this.m_maxNumTetras < n) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, n, 4);
            for (int i = this.m_maxNumTetras; i < n; ++i) {
                this.m_neighbour[i].setConstant(-1);
            }
        }
        this.m_maxNumTetras = n;
        this.assureNeighbours();
        if (this.m_tetraColor != null) {
            this.assureTetraColors();
        }
        if (this.m_tetraTexture != null) {
            this.assureTetraTextures();
        }
        if (this.m_maxNumTetras < this.m_numTetras) {
            this.m_numTetras = this.m_maxNumTetras;
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setMaxNumVectors(this.m_maxNumTetras);
            }
        }
    }

    public int getNumTetras() {
        return this.m_numTetras;
    }

    public int getNumTetraIndices() {
        return 4 * this.m_numTetras;
    }

    public void setNumTetras(int n) {
        if (this.m_numTetras == n) {
            return;
        }
        if (n > this.m_maxNumTetras || n < this.m_maxNumTetras / 2 && n < this.m_maxNumTetras - 100) {
            this.setMaxNumTetras(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numTetras = n;
            return;
        }
        if (this.m_neighbour != null) {
            int n2;
            if (n < this.m_numTetras) {
                for (n2 = 0; n2 < n; ++n2) {
                    for (int i = this.m_neighbour[n2].getSize() - 1; i >= 0; --i) {
                        if (this.m_neighbour[n2].m_data[i] < n) continue;
                        this.m_neighbour[n2].m_data[i] = -1;
                    }
                }
            } else {
                for (n2 = this.m_numTetras; n2 < n; ++n2) {
                    this.m_neighbour[n2].setConstant(-1);
                }
            }
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n);
            }
        }
        this.m_numTetras = n;
    }

    public int getDimOfTetras() {
        return 4;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.hasBoundary()) {
            for (int i = 0; i < this.m_bndList.length; ++i) {
                if (this.m_bndList[i] == null) continue;
                this.m_bndList[i].setDimOfVectors(n);
            }
        }
    }

    protected void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumTetras) {
            for (n = 0; n < this.m_maxNumTetras; ++n) {
                if (this.m_neighbour[n].m_data != null && this.m_tetra[n].m_data != null && this.m_neighbour[n].m_data.length == this.m_tetra[n].m_data.length) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumTetras, 4);
        if (bl) {
            for (n = 0; n < this.m_maxNumTetras; ++n) {
                this.m_neighbour[n].setConstant(-1);
            }
        }
    }

    public boolean hasTetraColors() {
        return this.m_tetraColor != null && this.m_tetraColor.length == this.m_maxNumTetras;
    }

    public boolean hasTetraTextures() {
        return this.m_tetraTexture != null && this.m_tetraTexture.length == this.m_maxNumTetras;
    }

    public void assureTetraColors() {
        if (this.m_tetraColor == null || this.m_tetraColor.length != this.m_maxNumTetras) {
            this.m_tetraColor = PdColor.realloc(this.m_tetraColor, this.m_maxNumTetras);
        }
    }

    public void assureTetraTextures() {
        if (this.m_tetraTexture == null) {
            this.m_tetraTexture = new PdVector[this.m_maxNumTetras][];
        }
        if (this.m_tetraTexture.length != this.m_maxNumTetras) {
            PdVector[][] pdVectorArrayArray = new PdVector[this.m_maxNumTetras][];
            int n = this.m_tetraTexture.length;
            if (n > this.m_maxNumTetras) {
                n = this.m_maxNumTetras;
            }
            for (int i = 0; i < n; ++i) {
                pdVectorArrayArray[i] = this.m_tetraTexture[i];
            }
            this.m_tetraTexture = pdVectorArrayArray;
        }
        for (int i = 0; i < this.m_maxNumTetras; ++i) {
            this.m_tetraTexture[i] = PdVector.realloc(this.m_tetraTexture[i], this.m_tetra[i].getSize(), this.m_dimOfTextures);
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        PdVector[] pdVectorArray = new PdVector[]{};
        int n = this.m_numVertices;
        int n2 = this.m_numTetras;
        if (this.m_bShowSmallTets) {
            double d = this.m_scaleTetraPaint.getValue();
            pdVectorArray = (PdVector[])this.m_vertex.clone();
            this.setNumVertices(4 * n2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.m_vertex[4 * i + j] = PdVector.blendNew(0.25 + 0.75 * d, pdVectorArray[this.m_tetra[i].m_data[j]], 0.25 - 0.25 * d, pdVectorArray[this.m_tetra[i].m_data[(j + 1) % 4]]);
                    this.m_vertex[4 * i + j].blendBase(this.m_vertex[4 * i + j], 0.25 - 0.25 * d, pdVectorArray[this.m_tetra[i].m_data[(j + 2) % 4]]);
                    this.m_vertex[4 * i + j].blendBase(this.m_vertex[4 * i + j], 0.25 - 0.25 * d, pdVectorArray[this.m_tetra[i].m_data[(j + 3) % 4]]);
                }
            }
        }
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(84, this.isShowingTetraLabels());
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(104, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(94, this.m_bShowEdgeColors);
        pvGeometryIf.setState(95, this.m_bShowEdgeColorFromTetras);
        pvGeometryIf.setState(96, this.m_bShowEdgeColorFromVertices);
        if (this.m_globalEdgeColor != null) {
            pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
        }
        if (this.m_globalEdgeSize != null) {
            pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
        }
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_globalBndColor != null) {
            pvGeometryIf.setGlobalBndColor(this.m_globalBndColor.getColor());
        }
        if (this.m_globalBndTagColor != null) {
            pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
        }
        pvGeometryIf.setState(56, this.m_bShowTetras);
        pvGeometryIf.setState(57, this.m_bShowTaggedTetras);
        pvGeometryIf.setState(103, this.isShowingSmoothLighting());
        pvGeometryIf.setState(105, this.isShowingSmoothTetraColors());
        pvGeometryIf.setState(106, this.isShowingTetraFromVertexColors());
        pvGeometryIf.setState(98, this.m_bShowTetraColors);
        if (this.m_globalTetraColor != null) {
            pvGeometryIf.setGlobalElementColor(this.m_globalTetraColor.getColor());
        }
        if (this.m_globalTetraTagColor != null) {
            pvGeometryIf.setGlobalElementTagColor(this.m_globalTetraTagColor.getColor());
        }
        if (this.m_bShowSmallTets) {
            int n3;
            this.m_face = new PiVector[n2 * 4];
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_face[4 * n3 + 0] = new PiVector(4 * n3, 4 * n3 + 1, 4 * n3 + 2);
                this.m_face[4 * n3 + 1] = new PiVector(4 * n3, 4 * n3 + 2, 4 * n3 + 3);
                this.m_face[4 * n3 + 2] = new PiVector(4 * n3, 4 * n3 + 3, 4 * n3 + 1);
                this.m_face[4 * n3 + 3] = new PiVector(4 * n3 + 3, 4 * n3 + 2, 4 * n3 + 1);
            }
            this.m_numFaces = 4 * n2;
            if (this.hasTetraColors() && (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces)) {
                this.assureFaceColors();
            }
            if (this.hasTetraColors()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    for (int i = 0; i < 4; ++i) {
                        this.m_faceColor[4 * n3 + i] = this.getTetraColor(n3);
                    }
                }
            }
        } else {
            if (this.hasTetraColors() && (this.m_faceColor == null || this.m_faceColor.length != this.m_numFaces)) {
                this.assureFaceColors();
            }
            this.computeFaces();
        }
        if (this.m_bQuadsForTets) {
            pvGeometryIf.setGlobalBndSize(this.m_scaleTetraPaint.getValue());
            pvGeometryIf.setNumElements(n2);
            pvGeometryIf.setElements(this.m_tetra);
            pvGeometryIf.setElementColors(this.m_tetraColor);
        } else {
            pvGeometryIf.setNumElements(this.m_numFaces);
            pvGeometryIf.setElements(this.m_face);
            pvGeometryIf.setElementColors(this.m_faceColor);
        }
        if (this.m_bShowSmallTets) {
            this.setNumVertices(n);
            this.setVertices(pdVectorArray);
        }
    }

    public void makeCubeTetraTexture(int n, int n2, int n3) {
        if (n < 2 || n2 < 2 || n3 < 2) {
            PsDebug.warning("discretization smaller than 2.");
            return;
        }
        this.assureTetraTextures();
        int n4 = 3;
        PdVector[] pdVectorArray = PdVector.realloc(null, 8, n4);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = 0;
        for (int i = 1; i < n; ++i) {
            double d4 = d;
            d = (double)i / ((double)n - 1.0);
            for (int j = 1; j < n2; ++j) {
                double d5 = d2;
                d2 = (double)j / ((double)n2 - 1.0);
                for (int k = 1; k < n3; ++k) {
                    double d6 = d3;
                    d3 = (double)k / ((double)n3 - 1.0);
                    pdVectorArray[0].set(d6, d5, d4);
                    pdVectorArray[1].set(d3, d5, d4);
                    pdVectorArray[2].set(d3, d2, d4);
                    pdVectorArray[3].set(d6, d2, d4);
                    pdVectorArray[4].set(d6, d5, d);
                    pdVectorArray[5].set(d3, d5, d);
                    pdVectorArray[6].set(d3, d2, d);
                    pdVectorArray[7].set(d6, d2, d);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[5]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[4]);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[5]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[1]);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[2]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[1]);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[2]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[3]);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[7]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[3]);
                    this.m_tetraTexture[n5++][0].copy(pdVectorArray[0]);
                    this.m_tetraTexture[n5++][1].copy(pdVectorArray[6]);
                    this.m_tetraTexture[n5++][2].copy(pdVectorArray[7]);
                    this.m_tetraTexture[n5++][3].copy(pdVectorArray[4]);
                }
            }
        }
    }

    public void makeCubeConn(int n, int n2, int n3) {
        if (n < 2 || n2 < 2 || n3 < 2) {
            PsDebug.warning("discretization smaller than 2.");
            return;
        }
        this.setNumTetras(6 * (n - 1) * (n2 - 1) * (n3 - 1));
        int n4 = 0;
        int[] nArray = new int[8];
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                for (int k = 0; k < n3 - 1; ++k) {
                    nArray[0] = (i + 0) * n2 * n3 + (j + 0) * n3 + (k + 0);
                    nArray[1] = (i + 0) * n2 * n3 + (j + 0) * n3 + (k + 1);
                    nArray[2] = (i + 0) * n2 * n3 + (j + 1) * n3 + (k + 1);
                    nArray[3] = (i + 0) * n2 * n3 + (j + 1) * n3 + (k + 0);
                    nArray[4] = (i + 1) * n2 * n3 + (j + 0) * n3 + (k + 0);
                    nArray[5] = (i + 1) * n2 * n3 + (j + 0) * n3 + (k + 1);
                    nArray[6] = (i + 1) * n2 * n3 + (j + 1) * n3 + (k + 1);
                    nArray[7] = (i + 1) * n2 * n3 + (j + 1) * n3 + (k + 0);
                    this.m_tetra[n4++].set(nArray[0], nArray[6], nArray[5], nArray[4]);
                    this.m_tetra[n4++].set(nArray[0], nArray[1], nArray[5], nArray[6]);
                    this.m_tetra[n4++].set(nArray[0], nArray[6], nArray[2], nArray[1]);
                    this.m_tetra[n4++].set(nArray[0], nArray[3], nArray[2], nArray[6]);
                    this.m_tetra[n4++].set(nArray[0], nArray[6], nArray[7], nArray[3]);
                    this.m_tetra[n4++].set(nArray[0], nArray[4], nArray[7], nArray[6]);
                }
            }
        }
        this.makeNeighbour();
    }

    public void flipOrientation() {
        int n;
        super.flipOrientation();
        for (n = 0; n < this.m_numTetras; ++n) {
            this.m_tetra[n].invert();
            int n2 = 4;
            int n3 = n2 - 4;
            int n4 = n2 - 4 >> 1;
            int n5 = n3 + n2 >> 1;
            for (int i = n4 + 1; i < n5; ++i) {
                int n6 = (n3 - i + n2) % n2;
                if (n6 == i) continue;
                int n7 = this.m_neighbour[n].m_data[i];
                this.m_neighbour[n].m_data[i] = this.m_neighbour[n].m_data[n6];
                this.m_neighbour[n].m_data[n6] = n7;
            }
        }
        if (this.m_tetraTexture != null) {
            for (n = 0; n < this.m_numTetras; ++n) {
                PuData.invert(this.m_tetraTexture[n]);
            }
        }
    }

    public static PiVector getVertexValence(PgTetraSet pgTetraSet) {
        int n = pgTetraSet.getNumVertices();
        int n2 = pgTetraSet.getNumTetras();
        PiVector[] piVectorArray = pgTetraSet.getTetras();
        PiVector[] piVectorArray2 = pgTetraSet.getNeighbours();
        PiVector piVector = new PiVector(n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (piVectorArray2[i].m_data[j] > i) continue;
                int n3 = piVectorArray[i].m_data[(j + 1) % 4];
                piVector.m_data[n3] = piVector.m_data[n3] + 1;
                int n4 = piVectorArray[i].m_data[(j + 2) % 4];
                piVector.m_data[n4] = piVector.m_data[n4] + 1;
            }
        }
        return piVector;
    }

    public void buildCube(PdVector[] pdVectorArray, int n, int n2, int n3) {
        if (pdVectorArray == null || pdVectorArray.length < 8) {
            PsDebug.error("no initial vertices or wrong number", this);
            return;
        }
        if (n < 2 || n2 < 2 || n3 < 2) {
            PsDebug.warning("discretization smaller than 2.");
            return;
        }
        this.setNumVertices(n * n2 * n3);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdVector pdVector6 = new PdVector(this.m_dim);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            double d = (double)i / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[4]);
            pdVector2.blend(1.0 - d, pdVectorArray[1], d, pdVectorArray[5]);
            pdVector3.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[6]);
            pdVector4.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[7]);
            for (int j = 0; j < n2; ++j) {
                double d2 = (double)j / ((double)n2 - 1.0);
                pdVector5.blend(1.0 - d2, pdVector, d2, pdVector3);
                pdVector6.blend(1.0 - d2, pdVector2, d2, pdVector4);
                for (int k = 0; k < n3; ++k) {
                    double d3 = (double)k / ((double)n3 - 1.0);
                    this.m_vertex[n4++].blend(1.0 - d3, pdVector5, d3, pdVector6);
                }
            }
        }
        this.makeCubeConn(n, n2, n3);
    }

    public int getNumUnusedVertices() {
        int n;
        int n2;
        boolean[] blArray = new boolean[this.m_numVertices];
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 0; n2 < this.m_numTetras; ++n2) {
            for (n = 0; n < 4; ++n) {
                blArray[this.m_tetra[n2].m_data[n]] = false;
            }
        }
        n2 = 0;
        for (n = 0; n < this.m_numVertices; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        return n2;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        for (n2 = 0; n2 < this.m_numTetras; ++n2) {
            for (n = 0; n < 4; ++n) {
                nArray[this.m_tetra[n2].m_data[n]] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] != n3) continue;
            nArray[n2] = n5++;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
            this.m_vertex[nArray[n2]] = this.m_vertex[n2];
        }
        for (n2 = 0; n2 < this.m_numTetras; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.m_tetra[n2].m_data[n] = nArray[this.m_tetra[n2].m_data[n]];
            }
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexNormal[nArray[n2]] = this.m_vertexNormal[n2];
            }
        }
        if (this.m_vertexColor != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexColor[nArray[n2]] = this.m_vertexColor[n2];
            }
        }
        if (this.m_vertexTexture != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexTexture[nArray[n2]] = this.m_vertexTexture[n2];
            }
        }
        int n6 = this.getNumVectorFields();
        for (n2 = 0; n2 < n6; ++n2) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n4 || nArray[n] >= n) continue;
                pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
            }
            pgVectorField.setNumVectors(n5);
        }
        if (this.m_bndList != null) {
            for (n2 = 0; n2 < this.m_bndList.length; ++n2) {
                if (this.m_bndList[n2].hasTag(2)) continue;
                int n7 = this.m_bndList[n2].getNumVertices();
                boolean bl = true;
                for (n = 0; n < n7; ++n) {
                    if (this.m_bndList[n2].m_vertexInd.m_data[n] != -1 && this.m_bndList[n2].m_vertexInd.m_data[n] < this.m_numVertices) continue;
                    this.m_bndList[n2].setTag(2);
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n = 0; n < n7; ++n) {
                    this.m_bndList[n2].m_vertexInd.m_data[n] = nArray[this.m_bndList[n2].m_vertexInd.m_data[n]];
                }
                this.m_bndList[n2].assignVertices();
            }
        }
        PsDebug.notify("number of deleted vertices = " + (this.m_numVertices - n5));
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public int[] removeMarkedVertices() {
        int n;
        int n2;
        int n3 = -1;
        int[] nArray = super.removeMarkedVertices();
        block0: for (n2 = 0; n2 < this.m_numTetras; ++n2) {
            for (n = 0; n < 4; ++n) {
                if (nArray[this.m_tetra[n2].m_data[n]] == n3) {
                    this.m_tetra[n2].setTag(2);
                    continue block0;
                }
                this.m_tetra[n2].m_data[n] = nArray[this.m_tetra[n2].m_data[n]];
            }
        }
        if (this.m_bndList != null) {
            for (n2 = 0; n2 < this.m_bndList.length; ++n2) {
                if (this.m_bndList[n2].hasTag(2)) continue;
                n = this.m_bndList[n2].getNumVertices();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    if (nArray[this.m_bndList[n2].m_vertexInd.m_data[i]] == n3) continue;
                    this.m_bndList[n2].m_vertexInd.m_data[n4++] = nArray[this.m_bndList[n2].m_vertexInd.m_data[i]];
                }
                if (n4 >= n) continue;
                this.m_bndList[n2].setNumVertices(n4);
            }
        }
        this.removeMarkedTetras();
        return nArray;
    }

    public int[] removeTetra(int n) {
        this.m_tetra[n].setTag(2);
        return this.removeMarkedTetras();
    }

    public int[] removeMarkedTetras() {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        int n5 = -1;
        PiVector piVector = new PiVector(this.m_numTetras);
        int[] nArray = piVector.m_data;
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            nArray[n3] = this.m_tetra[n3].hasTag(2) ? n5 : n4;
        }
        int n6 = 0;
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            if (nArray[n3] != n4) continue;
            nArray[n3] = n6++;
        }
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            if (nArray[n3] == n5) continue;
            for (n2 = 0; n2 < this.m_tetra[n3].m_data.length; ++n2) {
                if (this.m_neighbour[n3].m_data[n2] <= -1) continue;
                this.m_neighbour[n3].m_data[n2] = nArray[this.m_neighbour[n3].m_data[n2]];
            }
        }
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
            this.m_tetra[nArray[n3]].copy(this.m_tetra[n3]);
            this.m_neighbour[nArray[n3]].copy(this.m_neighbour[n3]);
        }
        if (this.m_tetraColor != null) {
            for (n3 = 0; n3 < this.m_numTetras; ++n3) {
                if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
                this.m_tetraColor[nArray[n3]] = this.m_tetraColor[n3];
            }
        }
        if (this.m_tetraTexture != null) {
            for (n3 = 0; n3 < this.m_numTetras; ++n3) {
                if (nArray[n3] == n5 || nArray[n3] >= n3) continue;
                this.m_tetraTexture[nArray[n3]] = PdVector.copyNew(this.m_tetraTexture[n3]);
            }
        }
        if (this.m_bndList != null) {
            n = 0;
            block7: for (n3 = 0; n3 < this.m_bndList.length; ++n3) {
                if (this.m_bndList[n3].hasTag(2)) continue;
                int n7 = this.m_bndList[n3].getNumElements();
                int n8 = 0;
                for (n2 = 0; n2 < n7; ++n2) {
                    if (nArray[this.m_bndList[n3].m_tetraInd.m_data[n2]] == n5) {
                        this.m_bndList[n3].setTag(2);
                        n = 1;
                        continue block7;
                    }
                    this.m_bndList[n3].m_tetraInd.m_data[n8++] = nArray[this.m_bndList[n3].m_tetraInd.m_data[n2]];
                }
            }
            if (n != 0) {
                this.removeDeletedBoundaries();
            }
        }
        n = this.getNumVectorFields();
        for (n3 = 0; n3 < n; ++n3) {
            PgVectorField pgVectorField = this.getVectorField(n3);
            if (pgVectorField.getBasedOn() == 0) continue;
            for (n2 = 0; n2 < this.m_numTetras; ++n2) {
                if (nArray[n2] == n5 || nArray[n2] >= n2) continue;
                pgVectorField.setVector(nArray[n2], pgVectorField.getVector(n2));
            }
            pgVectorField.setNumVectors(n6);
        }
        PsDebug.notify("number of deleted tetras = " + (this.m_numTetras - n6));
        this.setNumTetras(n6);
        this.setMaxNumTetras(n6);
        return nArray;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        int n;
        int n2;
        int n3 = this.m_numVertices;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgTetraSet)) {
            return false;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)pgGeometryIf;
        int n4 = this.m_numTetras;
        int n5 = this.m_numTetras + pgTetraSet.m_numTetras;
        this.setNumTetras(n5);
        PiVector.copy(this.m_tetra, n4, pgTetraSet.m_tetra, 0, pgTetraSet.m_numTetras);
        for (n2 = 0; n2 < pgTetraSet.m_numTetras; ++n2) {
            n = 0;
            while (n < 4) {
                int n6 = n++;
                this.m_tetra[n4 + n2].m_data[n6] = this.m_tetra[n4 + n2].m_data[n6] + n3;
            }
        }
        if (pgTetraSet.m_neighbour != null) {
            PiVector.copy(this.m_neighbour, n4, pgTetraSet.m_neighbour, 0, pgTetraSet.m_numTetras);
            for (n2 = 0; n2 < pgTetraSet.m_numTetras; ++n2) {
                for (n = 0; n < 4; ++n) {
                    if (pgTetraSet.m_neighbour[n2].m_data[n] <= -1) continue;
                    int n7 = n;
                    this.m_neighbour[n4 + n2].m_data[n7] = this.m_neighbour[n4 + n2].m_data[n7] + n4;
                }
            }
        }
        Color color = this.getGlobalTetraColor();
        Color color2 = pgTetraSet.getGlobalTetraColor();
        boolean bl2 = color.getRGB() != color2.getRGB() || this.hasTetraColors() || pgTetraSet.hasTetraColors();
        boolean bl3 = color.getRGB() == color2.getRGB() && !this.isShowingTetraColors() && !pgTetraSet.isShowingTetraColors();
        boolean bl4 = bl2 && !this.isShowingTetraColors();
        boolean bl5 = bl = bl2 && !pgTetraSet.isShowingTetraColors();
        if (!bl3) {
            this.showTetraColors(true);
        }
        if (bl2) {
            this.assureTetraColors();
            if (bl4) {
                for (n2 = 0; n2 < n4; ++n2) {
                    this.setTetraColor(n2, color);
                }
            }
            if (bl) {
                for (n2 = n4; n2 < n5; ++n2) {
                    this.setTetraColor(n2, color2);
                }
            } else {
                PdColor.copy(this.m_tetraColor, n4, pgTetraSet.m_tetraColor, 0, pgTetraSet.m_numTetras);
            }
        }
        if (pgTetraSet.m_tetraTexture != null) {
            this.assureTetraTextures();
            for (n2 = 0; n2 < pgTetraSet.m_numTetras; ++n2) {
                PdVector.copy(this.m_tetraTexture[n4 + n2], 0, pgTetraSet.m_tetraTexture[n2], 0, 4);
            }
        }
        if (pgTetraSet.m_bndList != null) {
            PgBndElementSet[] pgBndElementSetArray = this.getBoundaries();
            this.m_bndList = new PgBndElementSet[pgBndElementSetArray.length + pgTetraSet.m_bndList.length];
            for (n2 = 0; n2 < pgBndElementSetArray.length; ++n2) {
                this.m_bndList[n2] = pgBndElementSetArray[n2];
            }
            for (n2 = 0; n2 < pgTetraSet.m_bndList.length; ++n2) {
                this.m_bndList[pgBndElementSetArray.length + n2] = pgTetraSet.m_bndList[n2];
            }
            for (n2 = pgBndElementSetArray.length; n2 < this.m_bndList.length; ++n2) {
                int n8 = this.m_bndList[n2].getNumVertices();
                if (this.m_bndList[n2].m_vertexInd != null) {
                    n = 0;
                    while (n < n8) {
                        int n9 = n++;
                        this.m_bndList[n2].m_vertexInd.m_data[n9] = this.m_bndList[n2].m_vertexInd.m_data[n9] + n3;
                    }
                }
                if (this.m_bndList[n2].m_tetraInd != null) {
                    n = 0;
                    while (n < n8 - 1) {
                        int n10 = n++;
                        this.m_bndList[n2].m_tetraInd.m_data[n10] = this.m_bndList[n2].m_tetraInd.m_data[n10] + n4;
                    }
                }
                this.m_bndList[n2].setTetraSet(this);
                this.m_bndList[n2].assignVertices();
            }
        }
        return true;
    }

    public int getTetraWithEdge(int n, int n2) {
        for (int i = 0; i < this.m_numTetras; ++i) {
            int[] nArray = this.m_tetra[i].m_data;
            for (int j = 0; j < 3; ++j) {
                for (int k = j + 1; k < 4; ++k) {
                    if ((nArray[j] != n || nArray[k] != n2) && (nArray[j] != n2 || nArray[k] != n)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public void clearTagTetra(int n, int n2) {
        if (n < 0 || n > this.m_numTetras - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_tetra[n].clearTag(n2);
    }

    public boolean hasTagTetra(int n, int n2) {
        if (n < 0 || n > this.m_numTetras - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_tetra[n].hasTag(n2);
    }

    public void setTagTetra(int n, int n2) {
        if (n < 0 || n > this.m_numTetras - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_tetra[n].setTag(n2);
    }

    public PdVector[] getTetraVertices(int n) {
        if (n < 0 || this.m_numTetras <= n) {
            PsDebug.warning("elemInd out of bounds, elemInd = " + n);
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[4];
        for (int i = 0; i < 4; ++i) {
            pdVectorArray[i] = this.m_vertex[this.m_tetra[n].m_data[i]];
        }
        return pdVectorArray;
    }

    public PiVector getTetra(int n) {
        if (n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_tetra[n];
    }

    public PiVector getNeighbour(int n) {
        if (this.m_neighbour == null || n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public Color getTetraColor(int n) {
        if (this.m_tetraColor == null || n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_tetraColor[n];
    }

    public boolean setTetraVertices(int n, PdVector[] pdVectorArray) {
        PiVector piVector = this.m_tetra[n];
        if (4 != pdVectorArray.length) {
            PsDebug.warning("tetra and array have different length");
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            this.setVertex(piVector.m_data[i], pdVectorArray[i]);
        }
        return true;
    }

    public void setTetra(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numTetras) {
            this.setNumTetras(n + 1);
        }
        this.m_tetra[n].set(n2, n3, n4, n5);
    }

    public boolean setTetra(int n, int[] nArray) {
        if (n >= this.m_numTetras) {
            this.setNumTetras(n + 1);
        }
        if (4 != nArray.length) {
            PsDebug.warning("tetra and array have different length");
            return false;
        }
        this.m_tetra[n].copy(nArray, 4);
        return true;
    }

    public boolean setTetra(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numTetras) {
            PsDebug.warning("index=" + n + " > " + this.m_numTetras + "=m_numTetras, bad programming style");
            this.setNumTetras(n + 1);
        }
        this.m_tetra[n].copy(piVector);
        return true;
    }

    public boolean setNeighbour(int n, PiVector piVector) {
        if (n < 0 || n >= this.m_numTetras) {
            PsDebug.warning("tetra index out of range, ind = " + n);
            return false;
        }
        if (piVector == null || piVector.getSize() != 4) {
            PsDebug.warning("size of given neighbour array does not match size of existing tetra, elemInd = " + n);
            return false;
        }
        this.m_neighbour[n].copyArray(piVector);
        return true;
    }

    public boolean setTetraColor(int n, Color color) {
        if (n < 0 || n >= this.m_numTetras) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_tetraColor == null || n >= this.m_tetraColor.length) {
            this.assureTetraColors();
        }
        this.m_tetraColor[n] = color;
        return true;
    }

    public boolean setTetraTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n >= this.m_numTetras) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_tetraTexture == null || n >= this.m_tetraTexture.length) {
            this.assureTetraTextures();
        }
        this.m_tetraTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public void setTetras(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numTetras == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numTetras) {
            PsDebug.warning("void length of tetra array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_tetra = piVectorArray;
            if (this.m_maxNumTetras != piVectorArray.length) {
                this.setMaxNumTetras(piVectorArray.length);
            }
            return;
        }
        PiVector.copy(this.m_tetra, 0, piVectorArray, 0, this.m_numTetras);
    }

    public void removeTetraColors() {
        this.setTetraColors(null);
    }

    public void setTetraColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_tetraColor = null;
            return;
        }
        if (colorArray.length < this.m_numTetras) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_tetraColor = colorArray;
            return;
        }
        this.assureTetraColors();
        PdColor.copy(this.m_tetraColor, 0, colorArray, 0, this.m_numTetras);
    }

    public void setTetraTextures(PdVector[][] pdVectorArray) {
        int n;
        if (pdVectorArray == null) {
            this.m_tetraTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numTetras) {
            PsDebug.warning("void length of tex array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_tetraTexture = pdVectorArray;
            return;
        }
        for (n = 0; n < this.m_numTetras; ++n) {
            if (pdVectorArray[n] != null && pdVectorArray[n].length == 4) continue;
            PsDebug.warning("void length of texCoords[" + n + "]");
            return;
        }
        this.assureTetraTextures();
        for (n = 0; n < this.m_numTetras; ++n) {
            PdVector.copy(this.m_tetraTexture[n], 0, pdVectorArray[n], 0, 4);
        }
    }

    public void setTetraTexturesFromList(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_tetraTexture = null;
            return;
        }
        if (pdVectorArray.length < this.getNumTetraIndices()) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureTetraTextures();
        int n = 0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m_tetraTexture[i][j].copy(pdVectorArray[n++]);
            }
        }
    }

    public void removeTexture() {
        this.setTetraTextures(null);
        this.showTetraTexture(false);
        super.removeTexture();
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numTetras) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_neighbour = piVectorArray;
            return;
        }
        this.assureNeighbours();
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numTetras);
    }

    public int getNeighbourLocInd(int n, int n2, int n3) {
        PsDebug.warning("Method with elementSet signature called in tetraSet.");
        return -1;
    }

    public int getOppVertexInd(int n, int n2) {
        int n3 = this.getOppVertexLocInd(n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n].m_data[n2];
        if (n4 < 0) {
            return -1;
        }
        return this.m_tetra[n4].m_data[n3];
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            return -2;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.m_neighbour[n3].m_data[i] != n) continue;
            return i;
        }
        PsDebug.error("cannot find opp vertex of (" + n2 + ") in tetra[" + n + "]");
        return -1;
    }

    public int getOtherVertexLocInd(int n, int n2, int n3, int n4) {
        for (int i = 1; i < 4; ++i) {
            if (this.m_tetra[n].m_data[0] != n2 || this.m_tetra[n].m_data[i] != n3 || this.m_tetra[n].m_data[(i + 1) % 4] != n4) continue;
            return (i + 3) % 4;
        }
        if (this.m_tetra[n].m_data[1] == n2 && this.m_tetra[n].m_data[2] == n3 && this.m_tetra[n].m_data[3] == n4) {
            return 0;
        }
        PsDebug.error("cannot find element (" + n2 + "," + n3 + "," + n4 + ") in tetra[" + n + "]", this);
        return -1;
    }

    public double getVolumeOfTetra(int n) {
        PdVector[] pdVectorArray = this.getTetraVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            return 0.0;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        double d = Math.abs(PuVectorGeom.distOfPointToPlane(pdVectorArray[3], pdVectorArray[0], pdVector));
        double d2 = PdVector.area(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        return d2 * d / 3.0;
    }

    public double getVolumeOfNdTetra(int n) {
        PdVector[] pdVectorArray = this.getTetraVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            return 0.0;
        }
        PdVector pdVector = PdVector.subNew(pdVectorArray[1], pdVectorArray[0]);
        PdVector pdVector2 = PdVector.subNew(pdVectorArray[2], pdVectorArray[0]);
        PdVector pdVector3 = PdVector.subNew(pdVectorArray[3], pdVectorArray[0]);
        PdMatrix pdMatrix = new PdMatrix(new double[][]{pdVector.m_data, pdVector2.m_data, pdVector3.m_data});
        PdMatrix pdMatrix2 = new PdMatrix(4, 3);
        pdMatrix2.transpose(pdMatrix);
        PdMatrix pdMatrix3 = new PdMatrix();
        pdMatrix3.mult(pdMatrix, pdMatrix2);
        double d = Math.abs(pdMatrix3.det());
        double d2 = Math.sqrt(d) / 6.0;
        return d2;
    }

    public double getVolume2() {
        double d = 0.0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            d += this.getVolumeOfNdTetra(i);
        }
        return d;
    }

    public double getVolume() {
        double d = 0.0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            d += this.getVolumeOfTetra(i);
        }
        return d;
    }

    public double getArea() {
        double d = 0.0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            PdVector[] pdVectorArray = this.getTetraVertices(i);
            for (int j = 0; j < 4; ++j) {
                if (this.m_neighbour[i].m_data[j] > -1) continue;
                d += PdVector.area(pdVectorArray[(j + 1) % 4], pdVectorArray[(j + 2) % 4], pdVectorArray[(j + 3) % 4]);
            }
        }
        return d;
    }

    public double getEdgeLength(int n, int n2, int n3) {
        int[] nArray = this.m_tetra[n].m_data;
        double d = PdVector.dist(this.m_vertex[nArray[n2]], this.m_vertex[nArray[n3]]);
        return d;
    }

    public void computeCone(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCone(n, n2, d, d2);
        PsDebug.warning("No tetrahedra generated in computeCone method.");
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCylinder(n, n2, d, d2);
        PsDebug.warning("No tetrahedra generated in computeCylinder method.");
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSphere(n, n2, d);
        PsDebug.warning("No tetrahedra generated in computeSphere method.");
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeTorus(n, n2, d, d2);
        PsDebug.warning("No tetrahedra generated in computeTorus method.");
    }

    public int getNumBoundaryFaces() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numTetras * 4;
        } else {
            for (int i = 0; i < this.m_numTetras; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.m_neighbour[i].m_data[j] != -1) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            n = this.m_numTetras * 6;
        } else {
            PgEdgeStar[] pgEdgeStarArray = this.makeEdgeStars();
            n = pgEdgeStarArray.length;
        }
        return n;
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(14)) continue;
            ++n;
        }
        return n;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgTetraSet) || !(pgGeometry2 instanceof PgTetraSet)) {
            return false;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)pgGeometry;
        PgTetraSet pgTetraSet2 = (PgTetraSet)pgGeometry2;
        if (pgTetraSet.m_numTetras != pgTetraSet2.m_numTetras) {
            PsDebug.warning("unequal number of tetras");
            return false;
        }
        double d4 = Math.abs(d);
        PgTetraSet pgTetraSet3 = d4 > (d3 = Math.abs(d2)) ? pgTetraSet : pgTetraSet2;
        this.m_bShowTetraLabels = pgTetraSet3.m_bShowTetraLabels;
        this.m_bShowBoundaries = pgTetraSet3.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgTetraSet3.m_bShowTaggedBoundaries;
        this.m_bShowTetraTexture = pgTetraSet3.m_bShowTetraTexture;
        this.m_bShowEdges = pgTetraSet3.m_bShowEdges;
        this.m_bShowEdgeColors = pgTetraSet3.m_bShowEdgeColors;
        this.m_bShowTetras = pgTetraSet3.m_bShowTetras;
        this.m_bShowTaggedTetras = pgTetraSet3.m_bShowTaggedTetras;
        this.m_bShowTetraColors = pgTetraSet3.m_bShowTetraColors;
        this.m_globalBndColor.blend(d4, pgTetraSet.m_globalBndColor, d3, pgTetraSet2.m_globalBndColor);
        this.m_globalBndTagColor.blend(d4, pgTetraSet.m_globalBndTagColor, d3, pgTetraSet2.m_globalBndTagColor);
        this.m_globalEdgeColor.blend(d4, pgTetraSet.m_globalEdgeColor, d3, pgTetraSet2.m_globalEdgeColor);
        this.m_globalEdgeSize.blend(d4, pgTetraSet.m_globalEdgeSize, d3, pgTetraSet2.m_globalEdgeSize);
        this.m_globalTetraColor.blend(d4, pgTetraSet.m_globalTetraColor, d3, pgTetraSet2.m_globalTetraColor);
        this.m_globalTetraTagColor.blend(d4, pgTetraSet.m_globalTetraTagColor, d3, pgTetraSet2.m_globalTetraTagColor);
        this.setNumTetras(pgTetraSet3.getNumTetras());
        for (n = 0; n < this.m_numTetras; ++n) {
            this.m_tetra[n].copy(pgTetraSet3.m_tetra[n]);
        }
        if (pgTetraSet3.m_neighbour != null) {
            for (n = 0; n < this.m_numTetras; ++n) {
                this.m_neighbour[n].copy(pgTetraSet3.m_neighbour[n]);
            }
        }
        if (pgTetraSet.m_tetraColor != null && pgTetraSet2.m_tetraColor != null) {
            this.assureTetraColors();
            for (n = 0; n < this.m_numTetras; ++n) {
                this.m_tetraColor[n] = PdColor.blend(d4, pgTetraSet.m_tetraColor[n], d3, pgTetraSet2.m_tetraColor[n]);
            }
        } else {
            this.m_tetraColor = null;
        }
        if (pgTetraSet.m_tetraTexture != null && pgTetraSet2.m_tetraTexture != null) {
            this.assureTetraTextures();
            for (n = 0; n < this.m_numTetras; ++n) {
                int n2 = pgTetraSet3.m_tetra[n].getSize();
                for (int i = 0; i < n2; ++i) {
                    this.m_tetraTexture[n][i].blend(d4, pgTetraSet.m_tetraTexture[n][i], d3, pgTetraSet2.m_tetraTexture[n][i]);
                }
            }
        } else {
            this.m_tetraTexture = null;
        }
        if (pgTetraSet.hasBoundary() && pgTetraSet2.hasBoundary()) {
            this.assureBoundary(pgTetraSet3.m_bndList.length);
            for (n = 0; n < this.m_bndList.length; ++n) {
                this.m_bndList[n].blend(d, pgTetraSet.m_bndList[n], d2, pgTetraSet2.m_bndList[n]);
            }
        } else {
            this.m_bndList = null;
        }
        return true;
    }

    public boolean checkNeighbour(boolean bl) {
        if (this.m_neighbour == null) {
            PsDebug.warning("missing neighbour information");
            return false;
        }
        int n = -1;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.m_numTetras; ++i) {
            if (!bl2 && stringBuffer.length() > 50000) {
                stringBuffer.append("---- message exceeded max message size, message truncated -----\n");
                break;
            }
            for (int j = 0; j < 4; ++j) {
                int n2;
                int n3;
                int n4 = this.m_neighbour[i].m_data[j];
                if (n4 == -1) continue;
                if (n4 == i) {
                    bl2 = false;
                    stringBuffer.append("tetrahedron has itself as neighbour\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_tetra[i].m_data[j] + "\n");
                    for (n3 = 0; n3 < 4; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n3 + "] = " + this.m_tetra[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                if (n4 >= this.m_numTetras) {
                    bl2 = false;
                    stringBuffer.append(PsConfig.getMessage(33014) + "\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_tetra[i].m_data[j] + " >= m_numTetras.\n");
                    for (n3 = 0; n3 < 4; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n3 + "] = " + this.m_tetra[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                n3 = 0;
                for (n2 = 0; n2 < 4; ++n2) {
                    if (this.m_neighbour[n4].m_data[n2] != i) continue;
                    n3 = 1;
                    n = n2;
                    break;
                }
                if (n3 != 0) continue;
                bl2 = false;
                stringBuffer.append(PsConfig.getMessage(33015) + "\n");
                stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_tetra[i].m_data[j] + "\n");
                for (n2 = 0; n2 < 4; ++n2) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n2 + "] = " + this.m_tetra[i].m_data[n2] + ", " + PsConfig.getMessage(33016) + "[" + i + "][" + n2 + "] = " + this.m_neighbour[i].m_data[n2] + "\n");
                }
                if (n3 == 1) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n4 + " " + PsConfig.getMessage(33013) + " = " + this.m_tetra[n4].m_data[n] + "\n");
                } else {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n4 + " " + PsConfig.getMessage(33017) + "\n");
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n4 + "][" + n2 + "] = " + this.m_tetra[n4].m_data[n2] + ", " + PsConfig.getMessage(33016) + "[" + n4 + "][" + n2 + "] = " + this.m_neighbour[n4].m_data[n2] + "\n");
                }
            }
        }
        if (bl) {
            if (!bl2) {
                PsDebug.message(stringBuffer.toString());
            } else {
                PsDebug.message(PsConfig.getMessage(33018));
            }
        }
        return bl2;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        if (pdVector == null || pdVector.getSize() != 3 || pdVector2 == null || pdVector2.getSize() != 3) {
            PsDebug.warning("missing or wrong dimension of ray");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PgGeometry.convertWorldToModel(this, pdVector, pdVector2, pdVector3, pdVector4);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MIN_VALUE;
        PdVector pdVector7 = new PdVector(this.m_dim);
        PdVector pdVector8 = new PdVector(this.m_dim);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        for (int i = 0; i < this.m_numTetras; ++i) {
            PdVector[] pdVectorArray = this.getTetraVertices(i);
            if (pdVectorArray.length < 3) continue;
            for (int j = 1; j < pdVectorArray.length - 1; ++j) {
                double d2;
                if (!pdVector5.normalOfPlane(pdVectorArray[0], pdVectorArray[j], pdVectorArray[j + 1]) || (d2 = PuVectorGeom.intersectionOfLineAndPlane(pdVector7, pdVector3, pdVector4, pdVectorArray[0], pdVector5)) >= d) continue;
                PdBary.getBary(pdBary, pdVector7, pdVectorArray[0], pdVectorArray[j], pdVectorArray[j + 1]);
                if (!pdBary.isInside()) continue;
                d = d2;
                n2 = i;
                n3 = j;
                pdBary2.copy(pdBary);
                pdBary2.setElementInd(n2);
                pdVector6.copy(pdVector5);
                pdVector8.copy(pdVector7);
                if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                    n = this.m_tetra[i].getEntry(0);
                    continue;
                }
                if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                    n = this.m_tetra[i].getEntry(j);
                    continue;
                }
                if (!(Math.abs(1.0 - pdBary.getEntry(2)) < 0.1)) continue;
                n = this.m_tetra[i].getEntry(j + 1);
            }
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector8);
        pvPickEvent.setDistance(d);
        pvPickEvent.setHorDistance(0.0);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector6);
        return pvPickEvent;
    }

    public boolean makeTetraColorsFromXYZ() {
        int n;
        if (this.m_numTetras == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureTetraColors();
        Color[] colorArray = this.getTetraColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (n = 0; n < this.m_dim; ++n) {
            if (!(dArray[n] < 1.0E-10)) continue;
            dArray[n] = 1.0;
        }
        n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        for (int i = 0; i < this.m_numTetras; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_tetra[i].m_data), pdVectorArray[0]);
            for (int j = 0; j < n; ++j) {
                fArray[j] = (float)(pdVector.m_data[j] / dArray[j]);
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public boolean makeTetraColorsFromZ() {
        if (this.m_numTetras == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureTetraColors();
        Color[] colorArray = this.getTetraColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numTetras; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_tetra[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(f2, 0.0f, 1.0f - f2);
        }
        return true;
    }

    public boolean makeTetraColorsFromZHue() {
        if (this.m_numTetras == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureTetraColors();
        Color[] colorArray = this.getTetraColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numTetras; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_tetra[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public boolean makeTetraFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numTetras == 0) {
            return true;
        }
        this.assureTetraColors();
        for (int i = 0; i < this.m_numTetras; ++i) {
            int n = this.m_tetra[i].getSize();
            if (n == 0) continue;
            if (n == 1) {
                this.setTetraColor(i, this.m_vertexColor[this.m_tetra[i].m_data[0]]);
                continue;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n2 = this.m_vertexColor[this.m_tetra[i].m_data[j]].getRGB();
                f += (float)(n2 >> 16 & 0xFF);
                f2 += (float)(n2 >> 8 & 0xFF);
                f3 += (float)(n2 & 0xFF);
            }
            this.setTetraColor(i, new Color((int)(f /= (float)n), (int)(f2 /= (float)n), (int)(f3 /= (float)n)));
        }
        return true;
    }

    public boolean makeVertexFromTetraColors() {
        int n;
        if (!this.hasTetraColors()) {
            PsDebug.warning("missing tetra colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numTetras == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        for (n = 0; n < this.m_numTetras; ++n) {
            int n2 = this.m_tetra[n].getSize();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.m_tetra[n].m_data[i];
                int n4 = this.m_tetraColor[n].getRGB();
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + (n4 >> 16 & 0xFF);
                int[] nArray4 = nArray[n3];
                nArray4[1] = nArray4[1] + (n4 >> 8 & 0xFF);
                int[] nArray5 = nArray[n3];
                nArray5[2] = nArray5[2] + (n4 & 0xFF);
                int n5 = n3;
                nArray2[n5] = nArray2[n5] + 1;
            }
        }
        this.assureVertexColors();
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
                continue;
            }
            this.setVertexColor(n, Color.black);
        }
        return true;
    }

    public boolean makeTetraFromVertexTexture() {
        if (!this.hasVertexTextures()) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        PdVector[] pdVectorArray = this.getVertexTextures();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        this.assureTetraTextures();
        for (int i = 0; i < this.m_numTetras; ++i) {
            int n = this.m_tetra[i].getSize();
            for (int j = 0; j < n; ++j) {
                this.m_tetraTexture[i][j] = PdVector.copyNew(this.m_vertexTexture[this.m_tetra[i].m_data[j]]);
            }
        }
        this.showTetraTexture(true);
        this.showVertexTexture(false);
        this.setVertexTextures(null);
        return true;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Object object;
        PiVector[] piVectorArray;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)super.reflect(pdMatrix, bl, bl2);
        if (!bl) {
            piVectorArray = pgTetraSet.getTetras();
            for (int i = 0; i < this.m_numTetras; ++i) {
                piVectorArray[i].invert();
            }
            object = pgTetraSet.getNeighbours();
            if (object != null) {
                for (n3 = 0; n3 < this.m_numTetras; ++n3) {
                    object[n3].invert();
                    n2 = object[n3].getSize();
                    for (n = 3; n < n2; ++n) {
                        object[n3].shift(1);
                    }
                }
            }
        }
        if (!bl && this.hasTetraTextures()) {
            piVectorArray = pgTetraSet.getTetraTextures();
            for (n3 = 0; n3 < this.m_numTetras; ++n3) {
                n2 = ((PiVector)piVectorArray[n3]).length;
                n = n2 / 2;
                for (int i = 0; i < n; ++i) {
                    object = piVectorArray[n3][i];
                    piVectorArray[n3][i] = piVectorArray[n3][n2 - 1 - i];
                    piVectorArray[n3][n2 - 1 - i] = object;
                }
            }
        }
        return pgTetraSet;
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return false;
        }
        for (int i = 0; i < this.m_numTetras; ++i) {
            int n = this.m_tetra[i].getSize();
            for (int j = 0; j < n; ++j) {
                if (this.m_neighbour[i].m_data[j] != -1) continue;
                this.m_vertexNormal[this.m_tetra[i].m_data[(j + 1) % n]].setConstant(0.0);
                this.m_vertexNormal[this.m_tetra[i].m_data[(j + 2) % n]].setConstant(0.0);
                this.m_vertexNormal[this.m_tetra[i].m_data[(j + 3) % n]].setConstant(0.0);
            }
        }
        return true;
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 3);
        nArray2[nArray.length] = this.getNumEdges();
        nArray2[nArray.length + 1] = this.getNumFaces();
        nArray2[nArray.length + 2] = this.getNumTetras();
        return nArray2;
    }

    public boolean checkNeighbour() {
        if (this.m_neighbour == null) {
            PsDebug.warning("Missing neighbour information.");
            return false;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.m_numTetras; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = this.m_neighbour[i].m_data[j];
                if (n5 == -1) continue;
                if (n5 == i) {
                    bl = false;
                    stringBuffer.append("\n\tTetrahedron has itself as neighbour\n");
                    stringBuffer.append("\t\tTetrahedron " + i + " (" + this.m_tetra[i].m_data[0] + ", " + this.m_tetra[i].m_data[1] + ", " + this.m_tetra[i].m_data[2] + ", " + this.m_tetra[i].m_data[3] + ") with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", " + this.m_neighbour[i].m_data[3] + ".\n");
                    continue;
                }
                int n6 = -1;
                for (int k = 0; k < 4 && n6 == -1; ++k) {
                    if (this.m_neighbour[n5].m_data[k] != i) continue;
                    n6 = k;
                    break;
                }
                if (n6 == -1) {
                    bl = false;
                    stringBuffer.append("\n\tTwo adjacent tetrahedrons do not reference each other.\n\t\tTetrahedron " + i + " (" + this.m_tetra[i].m_data[0] + ", " + this.m_tetra[i].m_data[1] + ", " + this.m_tetra[i].m_data[2] + ", " + this.m_tetra[i].m_data[3] + ") with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", " + this.m_neighbour[i].m_data[3] + " at face opposite to vertex " + this.m_tetra[i].m_data[j] + ".\n\t\tTetrahedron " + n5 + " (" + this.m_tetra[n5].m_data[0] + ", " + this.m_tetra[n5].m_data[1] + ", " + this.m_tetra[n5].m_data[2] + ", " + this.m_tetra[n5].m_data[3] + ") with neighbours " + this.m_neighbour[n5].m_data[0] + ", " + this.m_neighbour[n5].m_data[1] + ", " + this.m_neighbour[n5].m_data[2] + ", " + this.m_neighbour[n5].m_data[3] + " does not reference back.\n");
                    continue;
                }
                int[] nArray = new int[]{-1, -1, -1, -1};
                block3: for (n4 = 0; n4 < 4; ++n4) {
                    n3 = this.m_tetra[i].m_data[n4];
                    for (n2 = 0; n2 < 4; ++n2) {
                        if (nArray[n2] == -1) {
                            nArray[n2] = n3;
                            continue block3;
                        }
                        if (n3 >= nArray[n2]) continue;
                        for (n = 3; n > n2; --n) {
                            nArray[n] = nArray[n - 1];
                        }
                        nArray[n2] = n3;
                        continue block3;
                    }
                }
                if (nArray[3] == -1) {
                    bl = false;
                    stringBuffer.append("\n\tTetrahedron with double vertex found.\n\t\tTetrahedron " + i + " (" + this.m_tetra[i].m_data[0] + ", " + this.m_tetra[i].m_data[1] + ", " + this.m_tetra[i].m_data[2] + ", " + this.m_tetra[i].m_data[3] + ").\n");
                    continue;
                }
                n4 = 0;
                block6: for (n3 = 0; n3 < 4; ++n3) {
                    n2 = this.m_tetra[n5].m_data[n3];
                    for (n = 0; n < 4; ++n) {
                        if (n2 != nArray[n]) continue;
                        ++n4;
                        nArray[n] = -1;
                        continue block6;
                    }
                }
                if (n4 == 4) {
                    bl = false;
                    stringBuffer.append("\n\tTwo identical tetrahedrons found.\n\t\tTetrahedron " + i + " (" + this.m_tetra[i].m_data[0] + ", " + this.m_tetra[i].m_data[1] + ", " + this.m_tetra[i].m_data[2] + ", " + this.m_tetra[i].m_data[3] + ").\n\t\tTetrahedron " + n5 + " (" + this.m_tetra[n5].m_data[0] + ", " + this.m_tetra[n5].m_data[1] + ", " + this.m_tetra[n5].m_data[2] + ", " + this.m_tetra[n5].m_data[3] + ").\n");
                    continue;
                }
                if (n4 >= 3) continue;
                bl = false;
                stringBuffer.append("\n\tTwo adjacent tetrahedrons reference each other but have no common face.\n\t\tTetrahedron " + i + " (" + this.m_tetra[i].m_data[0] + ", " + this.m_tetra[i].m_data[1] + ", " + this.m_tetra[i].m_data[2] + ", " + this.m_tetra[i].m_data[3] + ")  with neighbours " + this.m_neighbour[i].m_data[0] + ", " + this.m_neighbour[i].m_data[1] + ", " + this.m_neighbour[i].m_data[2] + ", " + this.m_neighbour[i].m_data[3] + ".\n\t\tTetrahedron " + n5 + " (" + this.m_tetra[n5].m_data[0] + ", " + this.m_tetra[n5].m_data[1] + ", " + this.m_tetra[n5].m_data[2] + ", " + this.m_tetra[n5].m_data[3] + ")  with neighbours " + this.m_neighbour[n5].m_data[0] + ", " + this.m_neighbour[n5].m_data[1] + ", " + this.m_neighbour[n5].m_data[2] + ", " + this.m_neighbour[n5].m_data[3] + ".\n");
            }
        }
        if (!bl) {
            PsDebug.warning(stringBuffer.toString());
        }
        return bl;
    }

    public void computeBox(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6) {
        PdVector[] pdVectorArray = PdVector.realloc(null, 8, this.m_dim);
        pdVectorArray[0].set(d, d2, d3);
        pdVectorArray[1].set(d, d2, d6);
        pdVectorArray[2].set(d, d5, d3);
        pdVectorArray[3].set(d, d5, d6);
        pdVectorArray[4].set(d4, d2, d3);
        pdVectorArray[5].set(d4, d2, d6);
        pdVectorArray[6].set(d4, d5, d3);
        pdVectorArray[7].set(d4, d5, d6);
        this.buildCube(pdVectorArray, n, n2, n3);
    }

    public PgElementSet getSurface(PgElementSet pgElementSet) {
        PgElementSet pgElementSet2 = pgElementSet == null ? new PgElementSet(this.m_dim) : pgElementSet;
        pgElementSet2.copy(this);
        pgElementSet2.setNumElements(this.m_numFaces);
        pgElementSet2.setElements(this.m_face);
        pgElementSet2.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgElementSet2.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgElementSet2.setGlobalElementColor(this.getGlobalTetraColor());
        pgElementSet2.makeElementNormals();
        return pgElementSet2;
    }

    public PgEdgeStar[] makeEdgeStars() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_numTetras < 1) {
            return null;
        }
        int n5 = 0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            int n6 = this.m_tetra[i].getSize();
            for (int j = 0; j < n6; ++j) {
                if (this.m_tetra[i].m_data[j] < n5) continue;
                n5 = this.m_tetra[i].m_data[j] + 1;
            }
        }
        Vector[] vectorArray = new Vector[n5];
        PgEdgeStar pgEdgeStar = null;
        int[] nArray = new int[2];
        int n7 = 6;
        int n8 = 0;
        for (int i = 0; i < this.m_numTetras; ++i) {
            for (n4 = 0; n4 < n7; ++n4) {
                nArray[0] = this.m_tetra[i].m_data[LOCAL_EDGE_TO_VERTEX[n4][0]];
                nArray[1] = this.m_tetra[i].m_data[LOCAL_EDGE_TO_VERTEX[n4][1]];
                if (nArray[0] > nArray[1]) {
                    n3 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n3;
                }
                n3 = 0;
                if (vectorArray[nArray[0]] == null) {
                    vectorArray[nArray[0]] = new Vector();
                } else {
                    n2 = vectorArray[nArray[0]].size();
                    for (n = 0; n < n2; ++n) {
                        pgEdgeStar = (PgEdgeStar)vectorArray[nArray[0]].elementAt(n);
                        if (pgEdgeStar.getVertexInd(1) != nArray[1]) continue;
                        n3 = 1;
                        pgEdgeStar.addElement(i, n4);
                        break;
                    }
                }
                if (n3 != 0) continue;
                ++n8;
                pgEdgeStar = new PgEdgeStar(nArray[0], nArray[1]);
                pgEdgeStar.setMaxValence(10);
                pgEdgeStar.addElement(i, n4);
                vectorArray[nArray[0]].addElement(pgEdgeStar);
            }
        }
        PgEdgeStar[] pgEdgeStarArray = new PgEdgeStar[n8];
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (vectorArray[n3] == null) continue;
            n2 = vectorArray[n3].size();
            for (n = 0; n < n2; ++n) {
                pgEdgeStarArray[n4] = (PgEdgeStar)vectorArray[n3].elementAt(n);
                ++n4;
            }
        }
        if (n4 != n8) {
            PsDebug.warning("numEdgeStars is wrong, edge list is void");
            PsDebug.warning("\t numEdgeStars = " + n8 + ", countEdges = " + n4);
        }
        return pgEdgeStarArray;
    }

    private PgFaceStar[] makeFaceStars() {
        int n;
        int n2;
        int n3;
        if (this.m_numTetras < 1) {
            return null;
        }
        PgFaceStar pgFaceStar = null;
        PiVector piVector = new PiVector(3);
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                if (this.m_tetra[n3].m_data[n2] < n5) continue;
                n5 = this.m_tetra[n3].m_data[n2] + 1;
            }
        }
        Vector[] vectorArray = new Vector[n5];
        for (n3 = 0; n3 < this.m_numTetras; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                piVector.set(this.m_tetra[n3].m_data[(n2 + 1) % 4], this.m_tetra[n3].m_data[(n2 + 2) % 4], this.m_tetra[n3].m_data[(n2 + 3) % 4]);
                piVector.sort();
                boolean bl = false;
                if (vectorArray[piVector.m_data[0]] == null) {
                    vectorArray[piVector.m_data[0]] = new Vector();
                } else {
                    int n6 = vectorArray[piVector.m_data[0]].size();
                    for (n = 0; n < n6; ++n) {
                        pgFaceStar = (PgFaceStar)vectorArray[piVector.m_data[0]].elementAt(n);
                        if (pgFaceStar.getVertexInd(1) != piVector.m_data[1] || pgFaceStar.getVertexInd(2) != piVector.m_data[2]) continue;
                        bl = true;
                        pgFaceStar.addElement(n3, n2);
                        break;
                    }
                }
                if (bl) continue;
                ++n4;
                pgFaceStar = new PgFaceStar(piVector.m_data[0], piVector.m_data[1], piVector.m_data[2]);
                pgFaceStar.addElement(n3, n2);
                vectorArray[piVector.m_data[0]].addElement(pgFaceStar);
            }
        }
        PgFaceStar[] pgFaceStarArray = new PgFaceStar[n4];
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (vectorArray[n3] == null) continue;
            int n8 = vectorArray[n3].size();
            for (n = 0; n < n8; ++n) {
                if (pgFaceStarArray[n7] != null) {
                    pgFaceStarArray[n7].copy((PgFaceStar)vectorArray[n3].elementAt(n));
                } else {
                    pgFaceStarArray[n7] = (PgFaceStar)vectorArray[n3].elementAt(n);
                }
                ++n7;
            }
        }
        if (n7 != n4) {
            PsDebug.warning("numFaceStars is wrong, face list is void");
            PsDebug.warning("\t numFaceStars = " + n4 + ", countEdges = " + n7);
        }
        return pgFaceStarArray;
    }

    private void computeFaces() {
        int n;
        int n2 = this.computeNumFaces();
        this.setNumFaces(n2);
        int n3 = 0;
        for (n = 0; n < this.m_numTetras; ++n) {
            int[] nArray = this.m_tetra[n].m_data;
            for (int i = 0; i < 4; ++i) {
                if (this.m_neighbour != null && this.m_neighbour[n].getEntry(i) > n) continue;
                if (n3 == n2) {
                    PsDebug.warning("found too many faces");
                }
                this.m_face[n3++].set(nArray[(i + 1) % 4], nArray[(i + 2) % 4], nArray[(i + 3) % 4]);
            }
        }
        if (this.hasTetraColors()) {
            n3 = 0;
            for (n = 0; n < this.m_numTetras; ++n) {
                for (int i = 0; i < 4; ++i) {
                    if (this.m_neighbour != null && this.m_neighbour[n].getEntry(i) > n) continue;
                    if (n3 == n2) {
                        PsDebug.warning("found too many faces");
                    }
                    this.m_faceColor[n3++] = this.m_neighbour == null || this.m_neighbour[n].getEntry(i) < 0 ? this.m_tetraColor[n] : PdColor.blend(0.5, this.m_tetraColor[n], 0.5, this.m_tetraColor[this.m_neighbour[n].getEntry(i)]);
                }
            }
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numTetras < 1) {
            return true;
        }
        this.assureNeighbours();
        PgFaceStar[] pgFaceStarArray = this.makeFaceStars();
        if (pgFaceStarArray == null) {
            PsDebug.notify("missing face list");
            return false;
        }
        int n = 0;
        for (int i = 0; i < pgFaceStarArray.length; ++i) {
            PiVector piVector = pgFaceStarArray[i].getElementInd();
            if (piVector == null) continue;
            int n2 = pgFaceStarArray[i].getValence();
            if (n2 > n) {
                n = n2;
            }
            if (n2 == 1) {
                this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].m_neighbourLocInd.m_data[0]] = -1;
                continue;
            }
            if (n2 == 2) {
                this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].m_neighbourLocInd.m_data[0]] = piVector.m_data[1];
                this.m_neighbour[piVector.m_data[1]].m_data[pgFaceStarArray[i].m_neighbourLocInd.m_data[1]] = piVector.m_data[0];
                continue;
            }
            this.m_neighbour[piVector.m_data[0]].m_data[pgFaceStarArray[i].m_neighbourLocInd.m_data[0]] = piVector.m_data[1];
            this.m_neighbour[piVector.m_data[1]].m_data[pgFaceStarArray[i].m_neighbourLocInd.m_data[1]] = piVector.m_data[0];
        }
        if (n > 2) {
            PsDebug.warning("Valence of tetra face is too high, valence = " + n);
        }
        return true;
    }

    public void markBoundary() {
        int n;
        for (n = 0; n < this.m_numVertices; ++n) {
            this.m_vertex[n].clearTag(14);
        }
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_tetra.length) {
            PsDebug.warning("void neighbour connectivity");
            return;
        }
        for (n = 0; n < this.m_numTetras; ++n) {
            for (int i = 0; i < 4; ++i) {
                if (this.m_neighbour[n].m_data[i] >= 0) continue;
                this.m_vertex[this.m_tetra[n].m_data[(i + 1) % 4]].setTag(14);
                this.m_vertex[this.m_tetra[n].m_data[(i + 2) % 4]].setTag(14);
                this.m_vertex[this.m_tetra[n].m_data[(i + 3) % 4]].setTag(14);
            }
        }
    }

    public int getEdgeVertex0(int n, int n2) {
        return this.m_tetra[n].m_data[LOCAL_EDGE_TO_VERTEX[n2][0]];
    }

    public int getEdgeVertex1(int n, int n2) {
        return this.m_tetra[n].m_data[LOCAL_EDGE_TO_VERTEX[n2][1]];
    }

    public PiVector getFace(int n, int n2) {
        PiVector piVector = this.m_tetra[n];
        PiVector piVector2 = new PiVector(3);
        for (int i = 0; i < 3; ++i) {
            int n3 = FACE_TO_VERTEX[n2][i];
            piVector2.m_data[i] = piVector.m_data[n3];
        }
        return piVector2;
    }

    public int addElement(PiVector piVector) {
        if (piVector.getSize() == 4) {
            this.addTetra(piVector);
        }
        return this.m_numTetras - 1;
    }

    public PdVector getCenterOfTetra(int n) {
        PdVector pdVector = new PdVector(this.getDimOfVertices());
        PiVector piVector = this.getTetra(n);
        for (int i = 0; i < 4; ++i) {
            pdVector.add(this.getVertex(piVector.m_data[i]));
        }
        pdVector.multScalar(0.25);
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

