/*
 * Decompiled with CFR 0.152.
 */
package jv.function;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Parser;
import jv.thirdParty.expr.Syntax_error;
import jv.thirdParty.expr.Variable;

public class PuComplexFunction
extends PsObject {
    protected int m_numVariables;
    protected int m_numFunctions;
    protected int m_numParameters;
    protected Expr[] m_expr;
    protected String[] m_exprString;
    protected String[] m_defExprString;
    protected String[] m_exprName;
    protected String[] m_varName;
    protected Variable[] m_var;
    protected Hashtable m_parm;
    protected Vector m_slider;
    static /* synthetic */ Class class$jv$function$PuComplexFunction;

    public PuComplexFunction() {
        this(1, 1);
    }

    public PuComplexFunction(int n, int n2) {
        int n3;
        this.setTag(4);
        this.setNumVariables(n);
        if (this.m_numVariables >= 3) {
            for (n3 = 0; n3 < this.m_numVariables; ++n3) {
                this.m_varName[n3] = "z" + String.valueOf(n3);
            }
        } else {
            switch (this.m_numVariables) {
                case 2: {
                    this.m_varName[1] = "w";
                }
                case 1: {
                    this.m_varName[0] = "z";
                }
            }
        }
        this.setVariables(this.m_varName);
        for (n3 = 0; n3 < this.m_numVariables; ++n3) {
            this.m_var[n3].setComplex(true);
        }
        Variable.make("PI").setValue(Math.PI);
        Variable.make("Pi").setValue(Math.PI);
        Variable.make("pi").setValue(Math.PI);
        Variable.make("i").setComplexValue(0.0, 1.0);
        Variable.make("I").setComplexValue(0.0, 1.0);
        this.setNumFunctions(n2);
        if (this.m_numFunctions >= 3) {
            for (n3 = 0; n3 < this.m_numFunctions; ++n3) {
                this.m_exprName[n3] = "F[" + String.valueOf(n3) + "]";
            }
        } else {
            switch (this.m_numFunctions) {
                case 2: {
                    this.m_exprName[1] = "g";
                }
                case 1: {
                    this.m_exprName[0] = "f";
                }
            }
        }
        this.setExpressionNames(this.m_exprName);
        if (this.getClass() == (class$jv$function$PuComplexFunction == null ? (class$jv$function$PuComplexFunction = PuComplexFunction.class$("jv.function.PuComplexFunction")) : class$jv$function$PuComplexFunction)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        for (int i = 0; i < this.m_numFunctions; ++i) {
            if (this.m_defExprString[i] != null) {
                this.setExpression(i, this.m_defExprString[i]);
                continue;
            }
            if (i >= this.m_numVariables) continue;
            this.setExpression(i, this.m_varName[i]);
        }
        if (this.m_slider != null) {
            Enumeration enumeration = this.m_slider.elements();
            while (enumeration.hasMoreElements()) {
                PuDouble puDouble = (PuDouble)enumeration.nextElement();
                puDouble.init();
                this.setParameter(puDouble.getSymbol(), puDouble.getValue());
            }
        }
    }

    public Object clone() {
        PuComplexFunction puComplexFunction = (PuComplexFunction)super.clone();
        if (puComplexFunction == null) {
            return null;
        }
        puComplexFunction.setNumVariables(0);
        puComplexFunction.setNumFunctions(0);
        if (this.m_slider != null) {
            puComplexFunction.m_slider = (Vector)this.m_slider.clone();
            puComplexFunction.m_slider.removeAllElements();
            Enumeration enumeration = this.getParameters();
            while (enumeration.hasMoreElements()) {
                puComplexFunction.addParameter((PuDouble)enumeration.nextElement());
            }
        }
        puComplexFunction.copy(this);
        return puComplexFunction;
    }

    public void copy(PsObject psObject) {
        Enumeration enumeration;
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PuComplexFunction)) {
            return;
        }
        PuComplexFunction puComplexFunction = (PuComplexFunction)psObject;
        this.setNumVariables(puComplexFunction.getNumVariables());
        this.setVariables(puComplexFunction.getVariables());
        this.setNumFunctions(puComplexFunction.getNumFunctions());
        this.setExpressions(puComplexFunction.getExpressions());
        this.setExpressionNames(puComplexFunction.getExpressionNames());
        if (puComplexFunction.getNumParameters() > 0) {
            enumeration = puComplexFunction.m_parm.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Variable variable = (Variable)puComplexFunction.m_parm.get(string);
                if (variable == null) continue;
                this.addParameter(string, variable.getValue());
            }
        }
        if (this.m_slider != null) {
            this.m_slider.removeAllElements();
        }
        if (this.m_slider != null) {
            enumeration = this.getParameters();
            while (enumeration.hasMoreElements()) {
                this.addParameter((PuDouble)enumeration.nextElement());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PuFunction ***********\n");
        stringBuffer.append("\t m_numVariables    = " + this.getNumVariables() + "\n");
        stringBuffer.append("\t m_numParameters   = " + this.getNumParameters() + "\n");
        stringBuffer.append("\t m_numFunctions    = " + this.getNumFunctions() + "\n");
        int n = this.getNumFunctions();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t\t f[" + String.valueOf(i) + "] = " + this.getExpression(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this || object == this.getInspector("Info")) {
            return super.update(object);
        }
        if (this.m_slider != null && this.m_slider.contains(object)) {
            Variable variable = null;
            if (object instanceof PuDouble) {
                PuDouble puDouble = (PuDouble)object;
                this.setParameter(puDouble.getSymbol(), puDouble.getValue());
                variable = (Variable)this.m_parm.get(puDouble.getSymbol());
            }
            if (this.m_expr == null || variable == null) {
                return true;
            }
            boolean bl = false;
            for (int i = 0; i < this.m_expr.length; ++i) {
                if (!this.m_expr[i].contains(variable)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return true;
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public void addParameter(PuDouble puDouble) {
        if (puDouble == null) {
            return;
        }
        if (this.m_slider == null) {
            this.m_slider = new Vector();
        }
        if (this.m_slider.contains(puDouble)) {
            PsDebug.warning("parameter already registered in list, parm = " + puDouble.getName());
            return;
        }
        this.m_slider.addElement(puDouble);
        this.addParameter(puDouble.getSymbol(), puDouble.getValue());
        puDouble.addUpdateListener(this);
    }

    public PuDouble getParameter(String string) {
        if (string == null) {
            PsDebug.warning("missing symbol");
            return null;
        }
        if (this.m_slider == null || this.m_slider.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.m_slider.elements();
        while (enumeration.hasMoreElements()) {
            PuDouble puDouble = (PuDouble)enumeration.nextElement();
            if (!string.equals(puDouble.getSymbol())) continue;
            return puDouble;
        }
        return null;
    }

    public Enumeration getParameters() {
        if (this.m_slider == null) {
            return null;
        }
        return this.m_slider.elements();
    }

    public int getNumParameters() {
        return this.m_numParameters;
    }

    public void addParameter(String string, double d) {
        Variable variable;
        if (string == null) {
            PsDebug.warning("missing symbol");
            return;
        }
        if (this.m_parm == null) {
            this.m_parm = new Hashtable();
        }
        if ((variable = (Variable)this.m_parm.get(string)) != null) {
            return;
        }
        variable = Variable.make(string);
        variable.setValue(d);
        this.m_parm.put(string, variable);
        ++this.m_numParameters;
    }

    public void setParameter(String string, double d) {
        if (string == null) {
            PsDebug.warning("missing symbol");
            return;
        }
        if (this.m_parm == null) {
            PsDebug.warning("empty parameter list");
            return;
        }
        Variable variable = (Variable)this.m_parm.get(string);
        if (variable == null) {
            PsDebug.warning("missing parameter, symbol not registered, symbol = " + string);
            return;
        }
        variable.setValue(d);
    }

    public int getNumVariables() {
        return this.m_numVariables;
    }

    public void setNumVariables(int n) {
        if (n == this.m_numVariables) {
            return;
        }
        this.m_numVariables = n;
        this.m_varName = new String[n];
        this.m_var = new Variable[n];
    }

    public String[] getVariables() {
        return this.m_varName;
    }

    public void setVariables(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length != this.getNumVariables()) {
            PsDebug.warning("length of array does not match number of variables");
            return;
        }
        for (int i = 0; i < this.m_numVariables; ++i) {
            this.m_var[i] = Variable.make(stringArray[i]);
            this.m_varName[i] = stringArray[i];
        }
    }

    public int getNumFunctions() {
        return this.m_numFunctions;
    }

    public void setNumFunctions(int n) {
        if (n == this.m_numFunctions) {
            return;
        }
        this.m_numFunctions = n;
        this.m_expr = new Expr[this.m_numFunctions];
        this.m_exprName = new String[this.m_numFunctions];
        this.m_exprString = new String[this.m_numFunctions];
        this.m_defExprString = new String[this.m_numFunctions];
    }

    public String getExpressionName() {
        return this.getExpressionName(0);
    }

    public void setExpressionName(String string) {
        this.setExpressionName(0, string);
    }

    public String getExpressionName(int n) {
        if (n >= this.m_numFunctions) {
            PsDebug.warning("index=" + n + " out of range");
            return null;
        }
        return this.m_exprName[n];
    }

    public void setExpressionName(int n, String string) {
        if (n < 0 || this.m_numFunctions <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_exprName[n] = string;
    }

    public String[] getExpressionNames() {
        return this.m_exprName;
    }

    public void setExpressionNames(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.m_numFunctions) {
            PsDebug.warning("argument array does not match m_numFunctions.");
            return;
        }
        for (int i = 0; i < this.m_numFunctions; ++i) {
            this.m_exprName[i] = stringArray[i];
        }
    }

    public String[] getExpressions() {
        return this.m_exprString;
    }

    public String getExpression() {
        return this.getExpression(0);
    }

    public String getExpression(int n) {
        if (n >= this.m_numFunctions) {
            PsDebug.warning("index=" + n + " out of range");
            return null;
        }
        return this.m_exprString[n];
    }

    public boolean setExpression(String string) {
        return this.setExpression(0, string);
    }

    public boolean setExpression(int n, String string) {
        if (n < 0 || this.m_numFunctions <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (string == null) {
            this.m_expr[n] = null;
            this.m_exprString[n] = null;
            return true;
        }
        string = string.trim();
        try {
            this.m_expr[n] = Parser.parse(string);
        }
        catch (Syntax_error syntax_error) {
            PsDebug.warning("Syntax error parsing string s[" + n + "]=" + string + "\n\tSyntax error: " + syntax_error);
            return false;
        }
        this.m_exprString[n] = string;
        return true;
    }

    public boolean setDefExpression(int n, String string) {
        if (n < 0 || this.m_numFunctions <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (string != null) {
            string = string.trim();
        }
        this.m_defExprString[n] = string;
        return true;
    }

    public boolean setExpressions(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing or empty expression array");
            return false;
        }
        if (this.m_numFunctions != stringArray.length) {
            PsDebug.warning("length of expression array does not match number of functions = " + String.valueOf(this.m_numFunctions) + ".");
            return false;
        }
        for (int i = 0; i < this.m_numFunctions; ++i) {
            this.setExpression(i, stringArray[i]);
        }
        return true;
    }

    public PuComplex eval(PuComplex puComplex) {
        return this.eval(0, puComplex);
    }

    public PuComplex eval(int n, PuComplex puComplex) {
        if (n < 0 || this.m_numFunctions <= n) {
            PsDebug.warning("index out of bounds, number of functions = " + String.valueOf(this.m_numFunctions) + ".");
            return PuComplex.ZERO;
        }
        if (this.m_numVariables != 1) {
            PsDebug.warning("number of arguments must match number of variables = " + String.valueOf(this.m_numVariables) + ".");
            return PuComplex.ZERO;
        }
        if (this.m_expr[n] == null) {
            PsDebug.warning("missing function expression, ind = " + String.valueOf(n));
            return PuComplex.ZERO;
        }
        this.m_var[0].setComplexValue(puComplex);
        return this.m_expr[n].getComplexValue();
    }

    public PuComplex eval(PuComplex[] puComplexArray) {
        return this.eval(0, puComplexArray);
    }

    public PuComplex eval(int n, PuComplex[] puComplexArray) {
        if (n < 0 || this.m_numFunctions <= n) {
            PsDebug.warning("index out of bounds, number of functions = " + String.valueOf(this.m_numFunctions) + ".");
            return PuComplex.ZERO;
        }
        if (this.m_numVariables != puComplexArray.length) {
            PsDebug.warning("number of arguments must match number of variables = " + String.valueOf(this.m_numVariables) + ".");
            return PuComplex.ZERO;
        }
        if (this.m_expr[n] == null) {
            PsDebug.warning("missing function expression, ind = " + String.valueOf(n));
            return PuComplex.ZERO;
        }
        for (int i = 0; i < this.m_numVariables; ++i) {
            this.m_var[i].setComplexValue(puComplexArray[i]);
        }
        return this.m_expr[n].getComplexValue();
    }

    public boolean eval(PuComplex[] puComplexArray, PuComplex puComplex) {
        if (puComplexArray == null) {
            PsDebug.warning("missing result array", this);
            return false;
        }
        if (puComplexArray.length != this.m_numFunctions) {
            PsDebug.warning("length of result array is not equal to number of functions = " + String.valueOf(this.m_numFunctions) + ".");
            return false;
        }
        if (this.m_numVariables != 1) {
            PsDebug.warning("number of arguments must match number of variables = " + String.valueOf(this.m_numVariables) + ".");
            return false;
        }
        this.m_var[0].setComplexValue(puComplex);
        for (int i = 0; i < this.m_numFunctions; ++i) {
            puComplexArray[i] = this.m_expr[i].getComplexValue();
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

