/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;
import jvx.volume.PgCubeSet;
import jvx.volume.PwTetraSet;

public class PwCubeSet
extends PjWorkshop {
    protected PgCubeSet m_cubeSet;
    public static final int[][] FACE_AT_EDGE = new int[][]{{2, 4}, {3, 4}, {2, 5}, {3, 5}, {0, 4}, {1, 4}, {0, 5}, {1, 5}, {0, 2}, {1, 2}, {0, 3}, {1, 3}};
    public static final int SPLIT_PARALLEL = 0;
    public static final int SPLIT_STAR = 1;
    public static int m_refineToEightType = 1;
    public static final int SPLIT_TO_SIX = 0;
    public static final int SPLIT_TO_TWELVE = 1;
    public int m_tetSplittingMode = 1;
    public boolean m_bRefineBeforeSplitting = false;
    public boolean m_bAddCubeAlignedFrameField = false;
    public boolean m_bAddTetAlignedFrameField = true;
    public boolean m_bOrthonormalizeFrame = true;
    public boolean m_bAddTexturePerCube = false;
    public boolean m_bAddBoundaryElementSet = false;
    public boolean m_bAddRotationField = false;
    static /* synthetic */ Class class$jvx$volume$PwCubeSet;

    public PwCubeSet() {
        super("CubeSet Refinement");
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwCubeSet == null ? (class$jvx$volume$PwCubeSet = PwCubeSet.class$("jvx.volume.PwCubeSet")) : class$jvx$volume$PwCubeSet)) {
            this.init();
        }
    }

    public void init() {
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_cubeSet = (PgCubeSet)pgGeometry;
    }

    public static PgElementSet convertToElementSet(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        PgElementSet pgElementSet = new PgElementSet(pgCubeSet.getDimOfVertices());
        int n3 = pgCubeSet.getNumVertices();
        pgElementSet.setNumVertices(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            pgElementSet.setVertex(n2, PdVector.copyNew((PdVector)pgCubeSet.getVertex(n2)));
        }
        n2 = pgCubeSet.getNumCubes();
        pgElementSet.setDimOfElements(8);
        pgElementSet.setNumElements(n2);
        for (n = 0; n < n2; ++n) {
            pgElementSet.setElement(n, PiVector.copyNew((PiVector)pgCubeSet.getCube(n)));
        }
        if (pgCubeSet.hasCubeColors()) {
            pgElementSet.assureElementColors();
            for (n = 0; n < n2; ++n) {
                pgElementSet.setElementColor(n, pgCubeSet.getCubeColor(n));
            }
            pgElementSet.showElementColors(pgCubeSet.isShowingCubeColors());
        }
        return pgElementSet;
    }

    public static PgVectorField[] addAlignedFrameField(PgCubeSet pgCubeSet, boolean bl) {
        int n = pgCubeSet.getNumCubes();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        for (int i = 0; i < 3; ++i) {
            pgVectorFieldArray[i] = new PgVectorField(3, 1);
            pgVectorFieldArray[i].setGeometry((PgPointSet)pgCubeSet);
            pgVectorFieldArray[i].setBasedOn(1);
            pgVectorFieldArray[i].setNumVectors(n);
            for (int j = 0; j < n; ++j) {
                PiVector piVector = pgCubeSet.getCube(j);
                int n2 = pgCubeSet.getDimOfVertices();
                PdVector pdVector = new PdVector(n2);
                for (int k = 0; k < 4; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int n3 = i2;
                        pdVector.m_data[n3] = pdVector.m_data[n3] + pgCubeSet.getVertex((int)piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[4 * i + k][1]]).m_data[i2];
                        int n4 = i2;
                        pdVector.m_data[n4] = pdVector.m_data[n4] - pgCubeSet.getVertex((int)piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[4 * i + k][0]]).m_data[i2];
                    }
                }
                pdVector.normalize();
                pgVectorFieldArray[i].setVector(j, pdVector);
            }
            pgVectorFieldArray[i].setName("Field" + i);
            if (i == 0) {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(191, 0, 0));
            } else if (i == 1) {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(0, 127, 0));
            } else {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(0, 0, 191));
            }
            pgVectorFieldArray[i].setGlobalVectorSize(2.0);
            if (bl) {
                pgCubeSet.addVectorField(pgVectorFieldArray[i]);
            }
            pgVectorFieldArray[i].showIndividualMaterial(true);
        }
        return pgVectorFieldArray;
    }

    public static void makeOrientation(PgCubeSet pgCubeSet) {
        int n;
        int n2 = pgCubeSet.getNumCubes();
        if (n2 < 1) {
            return;
        }
        if (pgCubeSet.getNeighbours() == null) {
            return;
        }
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
            blArray2[n] = false;
            nArray[n] = -1;
        }
        nArray[0] = 0;
        blArray2[0] = true;
        int n3 = 1;
        blArray[nArray[n]] = true;
        int n4 = 1;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            if (n == n3) {
                while (blArray[n4]) {
                    ++n4;
                }
                nArray[n] = n4;
                blArray2[n4] = true;
                ++n3;
            }
            int n6 = nArray[n];
            PiVector piVector = pgCubeSet.getCube(n6);
            PiVector piVector2 = pgCubeSet.getNeighbour(n6);
            for (int i = 0; i < 6; ++i) {
                boolean bl;
                int n7 = piVector2.m_data[i];
                if (piVector2.m_data[i] == -1 || blArray[n7]) continue;
                PiVector piVector3 = pgCubeSet.getNeighbour(n7);
                int n8 = piVector3.getIndexOf(n6);
                PiVector piVector4 = new PiVector(piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][0]], piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][1]], piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][2]], piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][3]]);
                PiVector piVector5 = pgCubeSet.getCube(n7);
                PiVector piVector6 = new PiVector(piVector5.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n8][0]], piVector5.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n8][1]], piVector5.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n8][2]], piVector5.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n8][3]]);
                int n9 = piVector6.getIndexOf(piVector4.m_data[0]);
                boolean bl2 = bl = piVector6.m_data[(n9 + 1) % 4] == piVector4.m_data[3];
                if (!bl) {
                    ++n5;
                    PwCubeSet.flipCube(pgCubeSet, n7);
                }
                if (blArray2[n7]) continue;
                nArray[n3] = n7;
                ++n3;
                blArray2[n7] = true;
            }
            blArray[n6] = true;
        }
    }

    public static void flipCube(PgCubeSet pgCubeSet, int n) {
        int n2;
        PiVector piVector = pgCubeSet.getCube(n);
        for (int i = 0; i < 4; ++i) {
            n2 = piVector.m_data[2 * i];
            piVector.m_data[2 * i] = piVector.m_data[2 * i + 1];
            piVector.m_data[2 * i + 1] = n2;
        }
        PiVector piVector2 = pgCubeSet.getNeighbour(n);
        n2 = piVector2.m_data[0];
        piVector2.m_data[0] = piVector2.m_data[1];
        piVector2.m_data[1] = n2;
    }

    public static PgTetraSet splitToTetrahedra(PgCubeSet pgCubeSet) {
        PdVector[] pdVectorArray;
        int n;
        PgTetraSet pgTetraSet = new PgTetraSet(pgCubeSet.getDimOfVertices());
        pgTetraSet.copy((PsObject)pgCubeSet);
        int n2 = pgCubeSet.getNumCubes();
        pgTetraSet.setNumTetras(n2 * 6);
        boolean bl = pgCubeSet.hasCubeTextures();
        if (bl) {
            pgTetraSet.setDimOfTextures(pgCubeSet.getDimOfTextures());
            pgTetraSet.assureTetraTextures();
        }
        for (n = 0; n < n2; ++n) {
            PiVector piVector = pgCubeSet.getCube(n);
            pgTetraSet.setTetra(n * 6 + 0, new PiVector(piVector.m_data[0], piVector.m_data[1], piVector.m_data[3], piVector.m_data[7]));
            pgTetraSet.setTetra(n * 6 + 1, new PiVector(piVector.m_data[0], piVector.m_data[3], piVector.m_data[2], piVector.m_data[7]));
            pgTetraSet.setTetra(n * 6 + 2, new PiVector(piVector.m_data[0], piVector.m_data[2], piVector.m_data[6], piVector.m_data[7]));
            pgTetraSet.setTetra(n * 6 + 3, new PiVector(piVector.m_data[0], piVector.m_data[6], piVector.m_data[4], piVector.m_data[7]));
            pgTetraSet.setTetra(n * 6 + 4, new PiVector(piVector.m_data[0], piVector.m_data[4], piVector.m_data[5], piVector.m_data[7]));
            pgTetraSet.setTetra(n * 6 + 5, new PiVector(piVector.m_data[0], piVector.m_data[5], piVector.m_data[1], piVector.m_data[7]));
            if (!bl) continue;
            pdVectorArray = pgCubeSet.getCubeTexture(n);
            pgTetraSet.setTetraTexture(n * 6 + 0, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[1]), PdVector.copyNew((PdVector)pdVectorArray[3]), PdVector.copyNew((PdVector)pdVectorArray[7])});
            pgTetraSet.setTetraTexture(n * 6 + 1, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[3]), PdVector.copyNew((PdVector)pdVectorArray[2]), PdVector.copyNew((PdVector)pdVectorArray[7])});
            pgTetraSet.setTetraTexture(n * 6 + 2, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[2]), PdVector.copyNew((PdVector)pdVectorArray[6]), PdVector.copyNew((PdVector)pdVectorArray[7])});
            pgTetraSet.setTetraTexture(n * 6 + 3, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[6]), PdVector.copyNew((PdVector)pdVectorArray[4]), PdVector.copyNew((PdVector)pdVectorArray[7])});
            pgTetraSet.setTetraTexture(n * 6 + 4, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[4]), PdVector.copyNew((PdVector)pdVectorArray[5]), PdVector.copyNew((PdVector)pdVectorArray[7])});
            pgTetraSet.setTetraTexture(n * 6 + 5, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[0]), PdVector.copyNew((PdVector)pdVectorArray[5]), PdVector.copyNew((PdVector)pdVectorArray[1]), PdVector.copyNew((PdVector)pdVectorArray[7])});
        }
        n = pgCubeSet.getNumVectorFields();
        pgTetraSet.removeAllVectorFields();
        for (int i = 0; i < n; ++i) {
            PgVectorField pgVectorField;
            pdVectorArray = pgCubeSet.getVectorField(i);
            if (pdVectorArray.getBasedOn() == 1) {
                pgVectorField = new PgVectorField(pdVectorArray.getDimOfVectors());
                pgVectorField.setBasedOn(1);
                pgVectorField.setNumVectors(6 * n2);
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < 6; ++k) {
                        pgVectorField.setVector(6 * j + k, PdVector.copyNew((PdVector)pdVectorArray.getVector(j)));
                    }
                }
            } else {
                pgVectorField = (PgVectorField)pdVectorArray.clone();
            }
            pgVectorField.setName(pdVectorArray.getName());
            pgVectorField.showIndividualMaterial(pdVectorArray.isShowingIndividualMaterial());
            pgVectorField.setGlobalVectorColor(pdVectorArray.getGlobalVectorColor());
            pgVectorField.setGlobalVectorSize(pdVectorArray.getGlobalVectorSize());
            pgVectorField.setGlobalVectorLength(pdVectorArray.getGlobalVectorLength());
            pgVectorField.setGeometry((PgPointSet)pgTetraSet);
            pgTetraSet.addVectorField(pgVectorField);
        }
        pgTetraSet.makeNeighbour();
        return pgTetraSet;
    }

    public static PgVectorField[] addFrameByCubeEdges(PgTetraSet pgTetraSet, boolean bl) {
        int n;
        int n2 = pgTetraSet.getNumTetras();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        int n3 = n2 / 6;
        if (n3 * 6 != n2) {
            PsDebug.warning((String)"Number of tetrahedra is not a multiple of six, this tetraSet is not a cube set split to tetrahedra.");
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            pgVectorFieldArray[i] = new PgVectorField(3, 1);
            pgVectorFieldArray[i].setGeometry((PgPointSet)pgTetraSet);
            pgVectorFieldArray[i].setBasedOn(1);
            pgVectorFieldArray[i].setNumVectors(n2);
            pgVectorFieldArray[i].setName("Field" + i);
        }
        int[][][] nArrayArray = new int[][][]{new int[][]{{0, 1}, {1, 2}, {2, 3}}, new int[][]{{2, 1}, {0, 2}, {1, 3}}, new int[][]{{2, 3}, {0, 1}, {1, 2}}, new int[][]{{1, 3}, {2, 1}, {0, 2}}, new int[][]{{1, 2}, {2, 3}, {0, 1}}, new int[][]{{0, 2}, {1, 3}, {2, 1}}};
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < 6; ++i) {
                PiVector piVector = pgTetraSet.getTetra(n * 6 + i);
                for (int j = 0; j < 3; ++j) {
                    PdVector pdVector = PdVector.subNew((PdVector)pgTetraSet.getVertex(piVector.m_data[nArrayArray[i][j][1]]), (PdVector)pgTetraSet.getVertex(piVector.m_data[nArrayArray[i][j][0]]));
                    pdVector.normalize();
                    pgVectorFieldArray[j].setVector(6 * n + i, pdVector);
                }
            }
        }
        pgVectorFieldArray[0].setGlobalVectorColor(new Color(191, 0, 0));
        pgVectorFieldArray[1].setGlobalVectorColor(new Color(0, 127, 0));
        pgVectorFieldArray[2].setGlobalVectorColor(new Color(0, 0, 191));
        for (n = 0; n < 3; ++n) {
            pgVectorFieldArray[n].setGlobalVectorSize(2.0);
            if (bl) {
                pgTetraSet.addVectorField(pgVectorFieldArray[n]);
            }
            pgVectorFieldArray[n].showIndividualMaterial(true);
        }
        return pgVectorFieldArray;
    }

    public static PgTetraSet splitTo12Tetrahedra(PgCubeSet pgCubeSet) {
        int n;
        PgVectorField pgVectorField;
        int n2;
        int n3;
        PgTetraSet pgTetraSet = new PgTetraSet(pgCubeSet.getDimOfVertices());
        pgTetraSet.copy((PsObject)pgCubeSet);
        int n4 = pgTetraSet.getNumVertices();
        int n5 = pgCubeSet.getNumCubes();
        int n6 = n4 + n5;
        pgTetraSet.setNumVertices(n6);
        for (n3 = 0; n3 < n5; ++n3) {
            pgTetraSet.setVertex(n4 + n3, PgGeometry.getCenterOfElement(null, (PdVector[])pgCubeSet.getVertices(), (int[])pgCubeSet.getCube((int)n3).m_data));
        }
        pgTetraSet.setNumTetras(n5 * 12);
        n3 = pgCubeSet.hasCubeTextures() ? 1 : 0;
        if (n3 != 0) {
            pgTetraSet.setDimOfTextures(pgCubeSet.getDimOfTextures());
            pgTetraSet.assureTetraTextures();
        }
        PiVector piVector = new PiVector(4);
        for (n2 = 0; n2 < n5; ++n2) {
            PiVector piVector2 = pgCubeSet.getCube(n2);
            pgVectorField = null;
            if (n3 != 0) {
                PdVector[] pdVectorArray = pgCubeSet.getCubeTexture(n2);
                pgVectorField = PdVector.copyNew((PdVector)pdVectorArray[0]);
                for (n = 1; n < 8; ++n) {
                    pgVectorField.add(pdVectorArray[n]);
                }
                pgVectorField.multScalar(0.125);
            }
            for (int i = 0; i < 6; ++i) {
                for (n = 0; n < 4; ++n) {
                    piVector.m_data[n] = piVector2.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][n]];
                }
                if (piVector.m_data[0] < piVector.m_data[1] && piVector.m_data[0] < piVector.m_data[3] || piVector.m_data[2] < piVector.m_data[1] && piVector.m_data[2] < piVector.m_data[3]) {
                    pgTetraSet.setTetra(n2 * 12 + 2 * i + 0, new PiVector(piVector.m_data[0], piVector.m_data[1], piVector.m_data[2], n4 + n2));
                    pgTetraSet.setTetra(n2 * 12 + 2 * i + 1, new PiVector(piVector.m_data[2], piVector.m_data[3], piVector.m_data[0], n4 + n2));
                    if (n3 == 0) continue;
                    PdVector[] pdVectorArray = pgCubeSet.getCubeTexture(n2);
                    pgTetraSet.setTetraTexture(n2 * 12 + 2 * i + 0, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][0]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][1]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][2]]), PdVector.copyNew((PdVector)pgVectorField)});
                    pgTetraSet.setTetraTexture(n2 * 12 + 2 * i + 1, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][2]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][3]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][0]]), PdVector.copyNew((PdVector)pgVectorField)});
                    continue;
                }
                pgTetraSet.setTetra(n2 * 12 + 2 * i + 0, new PiVector(piVector.m_data[1], piVector.m_data[2], piVector.m_data[3], n4 + n2));
                pgTetraSet.setTetra(n2 * 12 + 2 * i + 1, new PiVector(piVector.m_data[3], piVector.m_data[0], piVector.m_data[1], n4 + n2));
                if (n3 == 0) continue;
                PdVector[] pdVectorArray = pgCubeSet.getCubeTexture(n2);
                pgTetraSet.setTetraTexture(n2 * 12 + 2 * i + 0, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][1]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][2]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][3]]), PdVector.copyNew((PdVector)pgVectorField)});
                pgTetraSet.setTetraTexture(n2 * 12 + 2 * i + 1, new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][3]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][0]]), PdVector.copyNew((PdVector)pdVectorArray[PgCubeSet.LOCAL_FACE_TO_VERTEX[i][1]]), PdVector.copyNew((PdVector)pgVectorField)});
            }
        }
        n2 = pgCubeSet.getNumVectorFields();
        pgTetraSet.removeAllVectorFields();
        for (int i = 0; i < n2; ++i) {
            PgVectorField pgVectorField2;
            pgVectorField = pgCubeSet.getVectorField(i);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField2 = new PgVectorField(pgVectorField.getDimOfVectors());
                pgVectorField2.setBasedOn(1);
                pgVectorField2.setNumVectors(12 * n5);
                for (n = 0; n < n5; ++n) {
                    for (int j = 0; j < 12; ++j) {
                        pgVectorField2.setVector(12 * n + j, PdVector.copyNew((PdVector)pgVectorField.getVector(n)));
                    }
                }
            } else {
                pgVectorField2 = (PgVectorField)pgVectorField.clone();
            }
            pgVectorField2.setName(pgVectorField.getName());
            pgVectorField2.showIndividualMaterial(pgVectorField.isShowingIndividualMaterial());
            pgVectorField2.setGlobalVectorColor(pgVectorField.getGlobalVectorColor());
            pgVectorField2.setGlobalVectorSize(pgVectorField.getGlobalVectorSize());
            pgVectorField2.setGlobalVectorLength(pgVectorField.getGlobalVectorLength());
            pgVectorField2.setGeometry((PgPointSet)pgTetraSet);
            pgTetraSet.addVectorField(pgVectorField2);
        }
        pgTetraSet.makeNeighbour();
        return pgTetraSet;
    }

    public static PgVectorField[] addFrameByCubeEdges12(PgTetraSet pgTetraSet, boolean bl) {
        int n;
        int n2 = pgTetraSet.getNumTetras();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        int n3 = n2 / 12;
        if (n3 * 12 != n2) {
            PsDebug.warning((String)"Number of tetrahedra is not a multiple of twalve, this tetraSet is not a cube set split to tetrahedra.");
        }
        for (n = 0; n < 3; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 1);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgTetraSet);
            pgVectorFieldArray[n].setBasedOn(1);
            pgVectorFieldArray[n].setNumVectors(n2);
            pgVectorFieldArray[n].setName("Field" + n);
        }
        for (n = 0; n < n2; ++n) {
            PiVector piVector = pgTetraSet.getTetra(n);
            PdVector pdVector = PdVector.subNew((PdVector)pgTetraSet.getVertex(piVector.m_data[1]), (PdVector)pgTetraSet.getVertex(piVector.m_data[0]));
            pdVector.normalize();
            pgVectorFieldArray[0].setVector(n, pdVector);
            PdVector pdVector2 = PdVector.subNew((PdVector)pgTetraSet.getVertex(piVector.m_data[2]), (PdVector)pgTetraSet.getVertex(piVector.m_data[1]));
            pdVector2.normalize();
            pgVectorFieldArray[1].setVector(n, pdVector2);
            PdVector pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pgTetraSet.getVertex(piVector.m_data[2]), (double)0.5, (PdVector)pgTetraSet.getVertex(piVector.m_data[0]));
            PdVector pdVector4 = PdVector.subNew((PdVector)pgTetraSet.getVertex(piVector.m_data[3]), (PdVector)pdVector3);
            pdVector4.normalize();
            pgVectorFieldArray[2].setVector(n, pdVector4);
        }
        pgVectorFieldArray[0].setGlobalVectorColor(new Color(191, 0, 0));
        pgVectorFieldArray[1].setGlobalVectorColor(new Color(0, 127, 0));
        pgVectorFieldArray[2].setGlobalVectorColor(new Color(0, 0, 191));
        for (n = 0; n < 3; ++n) {
            pgVectorFieldArray[n].setGlobalVectorSize(2.0);
            if (bl) {
                pgTetraSet.addVectorField(pgVectorFieldArray[n]);
            }
            pgVectorFieldArray[n].showIndividualMaterial(true);
        }
        return pgVectorFieldArray;
    }

    public static int getLocalEdgeIndex(PgCubeSet pgCubeSet, int n, int n2, int n3) {
        PiVector piVector = pgCubeSet.getCube(n);
        for (int i = 0; i < 12; ++i) {
            if ((piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][0]] != n2 || piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][1]] != n3) && (piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][0]] != n3 || piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][1]] != n2)) continue;
            return i;
        }
        return -1;
    }

    public static PgEdgeStar computeEdgeStar(PgCubeSet pgCubeSet, int n, int n2, PgEdgeStar pgEdgeStar) {
        int n3;
        int n4;
        if (pgEdgeStar == null) {
            pgEdgeStar = new PgEdgeStar();
        }
        PiVector piVector = pgCubeSet.getCube(n);
        for (n4 = 0; n4 < 2; ++n4) {
            pgEdgeStar.setEntry(n4, piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n2][n4]]);
        }
        n4 = -2;
        int n5 = n;
        int n6 = -2;
        Vector<PiVector> vector = new Vector<PiVector>();
        while (n4 != n && n4 != -1) {
            if (n4 != -2) {
                n6 = n5;
                n5 = n4;
            }
            n2 = PwCubeSet.getLocalEdgeIndex(pgCubeSet, n5, pgEdgeStar.m_data[0], pgEdgeStar.m_data[1]);
            vector.addElement(new PiVector(n5, n2));
            n3 = pgCubeSet.getNeighbour((int)n5).m_data[FACE_AT_EDGE[n2][0]] == n6 ? FACE_AT_EDGE[n2][1] : FACE_AT_EDGE[n2][0];
            n4 = pgCubeSet.getNeighbour((int)n5).m_data[n3];
            if (vector.size() <= pgCubeSet.getNumCubes()) continue;
            break;
        }
        if (n4 != n) {
            n4 = n5;
            n6 = -1;
            n5 = -1;
            vector = new Vector();
            while (n4 != -1) {
                n6 = n5;
                n5 = n4;
                n2 = PwCubeSet.getLocalEdgeIndex(pgCubeSet, n5, pgEdgeStar.m_data[0], pgEdgeStar.m_data[1]);
                vector.addElement(new PiVector(n5, n2));
                n3 = pgCubeSet.getNeighbour((int)n5).m_data[FACE_AT_EDGE[n2][0]] == n6 ? FACE_AT_EDGE[n2][1] : FACE_AT_EDGE[n2][0];
                n4 = pgCubeSet.getNeighbour((int)n5).m_data[n3];
                if (vector.size() <= pgCubeSet.getNumCubes()) continue;
                break;
            }
        }
        n3 = vector.size();
        pgEdgeStar.setMaxValence(n3);
        for (int i = 0; i < n3; ++i) {
            pgEdgeStar.addElement(((PiVector)vector.elementAt((int)i)).m_data[0], ((PiVector)vector.elementAt((int)i)).m_data[1]);
        }
        return pgEdgeStar;
    }

    public static boolean edgeStarIsClosed(PgCubeSet pgCubeSet, PgEdgeStar pgEdgeStar) {
        if (pgEdgeStar == null || pgEdgeStar.getValence() < 1) {
            PsDebug.warning((String)"No valid edge star!");
            return false;
        }
        int n = pgEdgeStar.getElementInd(0);
        int n2 = PwCubeSet.getLocalEdgeIndex(pgCubeSet, n, pgEdgeStar.m_data[0], pgEdgeStar.m_data[1]);
        PiVector piVector = pgCubeSet.getNeighbour(n);
        return piVector.m_data[FACE_AT_EDGE[n2][0]] != -1 && piVector.m_data[FACE_AT_EDGE[n2][1]] != -1;
    }

    public static void testEdgeStars(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumCubes();
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 12; ++j) {
                PgEdgeStar pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, i, j, null);
                int n3 = pgEdgeStar.getValence();
                d += (double)n3;
                PsDebug.message((String)(pgEdgeStar.m_data[0] + " " + pgEdgeStar.m_data[1] + " - valence: " + n3));
                if (!PwCubeSet.edgeStarIsClosed(pgCubeSet, pgEdgeStar)) continue;
                ++n2;
            }
        }
        PsDebug.message((String)(12 * n + " EdgeStars were computed"));
        PsDebug.message((String)("Closed stars: " + n2 + " - Not closed stars: " + (12 * n - n2)));
        PsDebug.message((String)("Average valence: " + d / (12.0 * (double)n)));
    }

    public static void refineIntoEight(PgCubeSet pgCubeSet) {
        int n;
        PiVector piVector;
        PiVector piVector2;
        int n2;
        int n3;
        int n4 = pgCubeSet.getNumCubes();
        int n5 = pgCubeSet.getNumVertices();
        int[][] nArray = new int[n4][12];
        int[][] nArray2 = new int[n4][6];
        int[] nArray3 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray3[i] = -1;
            for (n3 = 0; n3 < 12; ++n3) {
                nArray[i][n3] = -1;
            }
            for (n3 = 0; n3 < 6; ++n3) {
                nArray2[i][n3] = -1;
            }
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        n3 = n5;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6;
            int n7;
            piVector2 = pgCubeSet.getCube(n2);
            piVector = pgCubeSet.getNeighbour(n2);
            for (n7 = 0; n7 < 6; ++n7) {
                n = piVector.m_data[n7];
                if (n >= n2) continue;
                vector.addElement(new PiVector(piVector2.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n7][0]], piVector2.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n7][1]], piVector2.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n7][2]], piVector2.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n7][3]]));
                nArray2[n2][n7] = n3;
                if (n != -1) {
                    PiVector piVector3 = pgCubeSet.getNeighbour(n);
                    n6 = piVector3.getIndexOf(n2);
                    nArray2[n][n6] = n3;
                }
                ++n3;
            }
            for (n7 = 0; n7 < 12; ++n7) {
                if (nArray[n2][n7] != -1) continue;
                vector.addElement(new PiVector(piVector2.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n7][0]], piVector2.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n7][1]]));
                PgEdgeStar pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, n2, n7, null);
                int n8 = pgEdgeStar.getValence();
                for (n6 = 0; n6 < n8; ++n6) {
                    nArray[pgEdgeStar.getElementInd((int)n6)][pgEdgeStar.getNeighbourLocInd((int)n6)] = n3;
                }
                ++n3;
            }
            PiVector piVector4 = new PiVector(8);
            for (n = 0; n < 8; ++n) {
                piVector4.setEntry(n, piVector2.m_data[n]);
            }
            vector.addElement(piVector4);
            nArray3[n2] = n3++;
        }
        pgCubeSet.setNumVertices(n3);
        for (n2 = n5; n2 < n3; ++n2) {
            piVector2 = (PiVector)vector.elementAt(n2 - n5);
            piVector = PdVector.copyNew((PdVector)pgCubeSet.getVertex(piVector2.m_data[0]));
            int n9 = piVector2.getSize();
            for (n = 1; n < n9; ++n) {
                piVector.add(pgCubeSet.getVertex(piVector2.m_data[n]));
            }
            piVector.multScalar(1.0 / (double)n9);
            pgCubeSet.setVertex(n2, (PdVector)piVector);
        }
        PwCubeSet.refineConnectivity(pgCubeSet, nArray, nArray2, nArray3);
        pgCubeSet.makeNeighbour();
    }

    private static void refineConnectivity(PgCubeSet pgCubeSet, int[][] nArray, int[][] nArray2, int[] nArray3) {
        Object object;
        int n = pgCubeSet.getNumCubes();
        pgCubeSet.setNumCubes(n * 8);
        PiVector[] piVectorArray = new PiVector[8];
        for (int i = 0; i < n; ++i) {
            object = pgCubeSet.getCube((int)i).m_data;
            if (m_refineToEightType == 0) {
                piVectorArray[0] = new PiVector(new int[]{object[0], nArray[i][0], nArray[i][4], nArray2[i][4], nArray[i][8], nArray2[i][2], nArray2[i][0], nArray3[i]});
                piVectorArray[1] = new PiVector(new int[]{nArray[i][0], object[1], nArray2[i][4], nArray[i][5], nArray2[i][2], nArray[i][9], nArray3[i], nArray2[i][1]});
                piVectorArray[2] = new PiVector(new int[]{nArray[i][4], nArray2[i][4], object[2], nArray[i][1], nArray2[i][0], nArray3[i], nArray[i][10], nArray2[i][3]});
                piVectorArray[3] = new PiVector(new int[]{nArray2[i][4], nArray[i][5], nArray[i][1], object[3], nArray3[i], nArray2[i][1], nArray2[i][3], nArray[i][11]});
                piVectorArray[4] = new PiVector(new int[]{nArray[i][8], nArray2[i][2], nArray2[i][0], nArray3[i], object[4], nArray[i][2], nArray[i][6], nArray2[i][5]});
                piVectorArray[5] = new PiVector(new int[]{nArray2[i][2], nArray[i][9], nArray3[i], nArray2[i][1], nArray[i][2], object[5], nArray2[i][5], nArray[i][7]});
                piVectorArray[6] = new PiVector(new int[]{nArray2[i][0], nArray3[i], nArray[i][10], nArray2[i][3], nArray[i][6], nArray2[i][5], object[6], nArray[i][3]});
                piVectorArray[7] = new PiVector(new int[]{nArray3[i], nArray2[i][1], nArray2[i][3], nArray[i][11], nArray2[i][5], nArray[i][7], nArray[i][3], object[7]});
            } else {
                piVectorArray[0] = new PiVector(new int[]{object[0], nArray[i][0], nArray[i][4], nArray2[i][4], nArray[i][8], nArray2[i][2], nArray2[i][0], nArray3[i]});
                piVectorArray[1] = new PiVector(new int[]{nArray3[i], nArray2[i][1], nArray2[i][2], nArray[i][9], nArray2[i][4], nArray[i][5], nArray[i][0], object[1]});
                piVectorArray[2] = new PiVector(new int[]{nArray3[i], nArray2[i][0], nArray2[i][3], nArray[i][10], nArray2[i][4], nArray[i][4], nArray[i][1], object[2]});
                piVectorArray[3] = new PiVector(new int[]{object[3], nArray[i][1], nArray[i][5], nArray2[i][4], nArray[i][11], nArray2[i][3], nArray2[i][1], nArray3[i]});
                piVectorArray[4] = new PiVector(new int[]{nArray3[i], nArray2[i][0], nArray2[i][2], nArray[i][8], nArray2[i][5], nArray[i][6], nArray[i][2], object[4]});
                piVectorArray[5] = new PiVector(new int[]{object[5], nArray[i][2], nArray[i][7], nArray2[i][5], nArray[i][9], nArray2[i][2], nArray2[i][1], nArray3[i]});
                piVectorArray[6] = new PiVector(new int[]{object[6], nArray[i][3], nArray[i][6], nArray2[i][5], nArray[i][10], nArray2[i][3], nArray2[i][0], nArray3[i]});
                piVectorArray[7] = new PiVector(new int[]{nArray3[i], nArray2[i][1], nArray2[i][3], nArray[i][11], nArray2[i][5], nArray[i][7], nArray[i][3], object[7]});
            }
            for (int j = 0; j < 8; ++j) {
                pgCubeSet.setCube(n * j + i, piVectorArray[j]);
            }
        }
        if (pgCubeSet.hasCubeTextures()) {
            PdVector[][] pdVectorArray = pgCubeSet.getCubeTextures();
            object = new PdVector[8 * n][8];
            PdVector[] pdVectorArray2 = new PdVector[12];
            PdVector[] pdVectorArray3 = new PdVector[6];
            for (int i = 0; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < 12; ++n2) {
                    pdVectorArray2[n2] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[i][PgCubeSet.LOCAL_EDGE_TO_VERTEX[n2][0]], (double)0.5, (PdVector)pdVectorArray[i][PgCubeSet.LOCAL_EDGE_TO_VERTEX[n2][1]]);
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    pdVectorArray3[n2] = PdVector.copyNew((PdVector)pdVectorArray[i][PgCubeSet.LOCAL_FACE_TO_VERTEX[n2][0]]);
                    pdVectorArray3[n2].add(pdVectorArray[i][PgCubeSet.LOCAL_FACE_TO_VERTEX[n2][1]]);
                    pdVectorArray3[n2].add(pdVectorArray[i][PgCubeSet.LOCAL_FACE_TO_VERTEX[n2][2]]);
                    pdVectorArray3[n2].add(pdVectorArray[i][PgCubeSet.LOCAL_FACE_TO_VERTEX[n2][3]]);
                    pdVectorArray3[n2].multScalar(0.25);
                }
                PdVector pdVector = PdVector.copyNew((PdVector)pdVectorArray[i][0]);
                for (n2 = 1; n2 < 8; ++n2) {
                    pdVector.add(pdVectorArray[n2][n2]);
                }
                pdVector.multScalar(0.125);
                if (m_refineToEightType == 0) {
                    object[0 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[i][0]), PdVector.copyNew((PdVector)pdVectorArray2[0]), PdVector.copyNew((PdVector)pdVectorArray2[4]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[8]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector)};
                    object[1 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray2[0]), PdVector.copyNew((PdVector)pdVectorArray[i][1]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[5]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray2[9]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1])};
                    object[2 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray2[4]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray[i][2]), PdVector.copyNew((PdVector)pdVectorArray2[1]), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray2[10]), PdVector.copyNew((PdVector)pdVectorArray3[3])};
                    object[3 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[5]), PdVector.copyNew((PdVector)pdVectorArray2[1]), PdVector.copyNew((PdVector)pdVectorArray[i][3]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray2[11])};
                    object[4 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray2[8]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray[i][4]), PdVector.copyNew((PdVector)pdVectorArray2[2]), PdVector.copyNew((PdVector)pdVectorArray2[6]), PdVector.copyNew((PdVector)pdVectorArray3[5])};
                    object[5 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray2[9]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVectorArray2[2]), PdVector.copyNew((PdVector)pdVectorArray[i][5]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[7])};
                    object[6 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray2[10]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray2[6]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray[i][6]), PdVector.copyNew((PdVector)pdVectorArray2[3])};
                    object[7 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray2[11]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[7]), PdVector.copyNew((PdVector)pdVectorArray2[3]), PdVector.copyNew((PdVector)pdVectorArray[i][7])};
                    continue;
                }
                object[0 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[i][0]), PdVector.copyNew((PdVector)pdVectorArray2[0]), PdVector.copyNew((PdVector)pdVectorArray2[4]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[8]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector)};
                object[1 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray2[9]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[5]), PdVector.copyNew((PdVector)pdVectorArray2[0]), PdVector.copyNew((PdVector)pdVectorArray[i][1])};
                object[2 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray2[10]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[4]), PdVector.copyNew((PdVector)pdVectorArray2[1]), PdVector.copyNew((PdVector)pdVectorArray[i][2])};
                object[3 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[i][3]), PdVector.copyNew((PdVector)pdVectorArray2[1]), PdVector.copyNew((PdVector)pdVectorArray2[5]), PdVector.copyNew((PdVector)pdVectorArray3[4]), PdVector.copyNew((PdVector)pdVectorArray2[11]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVector)};
                object[4 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray2[8]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[6]), PdVector.copyNew((PdVector)pdVectorArray2[2]), PdVector.copyNew((PdVector)pdVectorArray[i][4])};
                object[5 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[i][5]), PdVector.copyNew((PdVector)pdVectorArray2[2]), PdVector.copyNew((PdVector)pdVectorArray2[7]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[9]), PdVector.copyNew((PdVector)pdVectorArray3[2]), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVector)};
                object[6 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVectorArray[i][6]), PdVector.copyNew((PdVector)pdVectorArray2[3]), PdVector.copyNew((PdVector)pdVectorArray2[6]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[10]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray3[0]), PdVector.copyNew((PdVector)pdVector)};
                object[7 * n + i] = (int)new PdVector[]{PdVector.copyNew((PdVector)pdVector), PdVector.copyNew((PdVector)pdVectorArray3[1]), PdVector.copyNew((PdVector)pdVectorArray3[3]), PdVector.copyNew((PdVector)pdVectorArray2[11]), PdVector.copyNew((PdVector)pdVectorArray3[5]), PdVector.copyNew((PdVector)pdVectorArray2[7]), PdVector.copyNew((PdVector)pdVectorArray2[3]), PdVector.copyNew((PdVector)pdVectorArray[i][7])};
            }
            pgCubeSet.setCubeTextures((PdVector[][])object);
        }
    }

    public static void orthoNormalizeFrame3D(PgPointSet pgPointSet) {
        if (pgPointSet.getNumVectorFields() < 3) {
            PsDebug.warning((String)"Not enough vector fields to orthonormalize.");
            return;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            pgVectorFieldArray[i] = pgPointSet.getVectorField(i);
            if (i == 0) {
                n = pgVectorFieldArray[i].getNumVectors();
            } else if (n != pgVectorFieldArray[i].getNumVectors()) {
                PsDebug.warning((String)"Vector fields have different number of vectors.");
                return;
            }
            if (pgVectorFieldArray[i].getDimOfVectors() == 3) continue;
            PsDebug.warning((String)("Vector field " + i + " is not 3-dimensional."));
            return;
        }
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            pdVector.add(pgVectorFieldArray[0].getVector(i), pgVectorFieldArray[1].getVector(i));
            pdVector2.sub(pgVectorFieldArray[0].getVector(i), pgVectorFieldArray[1].getVector(i));
            pdVector.normalize();
            pdVector2.normalize();
            pgVectorFieldArray[0].getVector(i).add(pdVector, pdVector2);
            pgVectorFieldArray[0].getVector(i).normalize();
            pgVectorFieldArray[1].getVector(i).sub(pdVector, pdVector2);
            pgVectorFieldArray[1].getVector(i).normalize();
            pdVector3.copy(pgVectorFieldArray[2].getVector(i));
            pgVectorFieldArray[2].getVector(i).cross(pgVectorFieldArray[0].getVector(i), pgVectorFieldArray[1].getVector(i));
            if (PdVector.dot((PdVector)pdVector3, (PdVector)pgVectorFieldArray[2].getVector(i)) < 0.0) {
                pgVectorFieldArray[2].getVector(i).multScalar(-1.0);
            }
            pgVectorFieldArray[2].getVector(i).normalize();
        }
    }

    public void ok() {
        int n;
        PgVectorField pgVectorField;
        int n2;
        int n3;
        PgVectorField pgVectorField2;
        if (this.m_cubeSet == null) {
            super.ok();
            return;
        }
        PgTetraSet pgTetraSet = null;
        if (this.m_bAddCubeAlignedFrameField) {
            PwCubeSet.addAlignedFrameField(this.m_cubeSet, true);
            if (this.m_bOrthonormalizeFrame) {
                PwCubeSet.orthoNormalizeFrame3D(this.m_cubeSet);
            }
        }
        if (this.m_bRefineBeforeSplitting) {
            PwCubeSet.refineIntoEight(this.m_cubeSet);
        }
        if (this.m_bAddTexturePerCube) {
            PwCubeSet.addTexturePerCube(this.m_cubeSet);
        }
        if (this.m_tetSplittingMode == 0) {
            pgTetraSet = PwCubeSet.splitToTetrahedra(this.m_cubeSet);
            if (this.m_bAddTetAlignedFrameField) {
                PwCubeSet.addFrameByCubeEdges(pgTetraSet, true);
                if (this.m_bOrthonormalizeFrame) {
                    PwCubeSet.orthoNormalizeFrame3D((PgPointSet)pgTetraSet);
                }
            }
            if (this.m_bAddRotationField) {
                pgVectorField2 = PwCubeSet.computeRotationField(this.m_cubeSet, false);
                n3 = this.m_cubeSet.getNumCubes();
                n2 = n3 * 6;
                pgVectorField = new PgVectorField(4, 1);
                pgVectorField.setGeometry((PgPointSet)pgTetraSet);
                pgVectorField.setBasedOn(1);
                pgVectorField.setNumVectors(n2);
                pgVectorField.setName("matching");
                for (n = 0; n < n3; ++n) {
                    pgVectorField.setVector(6 * n + 0, new PdVector(pgVectorField2.getVector((int)n).m_data[1], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[4]));
                    pgVectorField.setVector(6 * n + 1, new PdVector(pgVectorField2.getVector((int)n).m_data[3], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[4]));
                    pgVectorField.setVector(6 * n + 2, new PdVector(pgVectorField2.getVector((int)n).m_data[3], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[0]));
                    pgVectorField.setVector(6 * n + 3, new PdVector(pgVectorField2.getVector((int)n).m_data[5], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[0]));
                    pgVectorField.setVector(6 * n + 4, new PdVector(pgVectorField2.getVector((int)n).m_data[5], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[2]));
                    pgVectorField.setVector(6 * n + 5, new PdVector(pgVectorField2.getVector((int)n).m_data[1], 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[2]));
                }
                pgTetraSet.addVectorField(pgVectorField);
            }
        } else {
            pgTetraSet = PwCubeSet.splitTo12Tetrahedra(this.m_cubeSet);
            if (this.m_bAddTetAlignedFrameField) {
                PwCubeSet.addFrameByCubeEdges12(pgTetraSet, true);
                if (this.m_bOrthonormalizeFrame) {
                    PwCubeSet.orthoNormalizeFrame3D((PgPointSet)pgTetraSet);
                }
            }
            if (this.m_bAddRotationField) {
                if (this.m_bAddTetAlignedFrameField) {
                    PsDebug.warning((String)"Rotation Information may be wrong in SplitTo12 Mode for tet aligned frames!");
                }
                pgVectorField2 = PwCubeSet.computeRotationField(this.m_cubeSet, false);
                n3 = this.m_cubeSet.getNumCubes();
                n2 = n3 * 12;
                pgVectorField = new PgVectorField(4, 1);
                pgVectorField.setGeometry((PgPointSet)pgTetraSet);
                pgVectorField.setBasedOn(1);
                pgVectorField.setNumVectors(n2);
                pgVectorField.setName("matching");
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < 6; ++i) {
                        pgVectorField.setVector(12 * n + 2 * i + 0, new PdVector(12.0, 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[i]));
                        pgVectorField.setVector(12 * n + 2 * i + 1, new PdVector(12.0, 12.0, 12.0, pgVectorField2.getVector((int)n).m_data[i]));
                    }
                }
                pgTetraSet.addVectorField(pgVectorField);
            }
        }
        if (pgTetraSet == null) {
            super.ok();
            return;
        }
        pgTetraSet.setName("TetraSet from " + this.m_cubeSet.getName());
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)pgTetraSet);
            this.m_display.update((Object)pgTetraSet);
        }
        if (this.m_bAddBoundaryElementSet && this.m_tetSplittingMode == 1 && this.m_bAddTetAlignedFrameField) {
            PwTetraSet.makeBoundary(pgTetraSet);
            pgVectorField2 = pgTetraSet.getBoundaries()[0];
            n3 = pgVectorField2.getNumElements();
            PiVector piVector = pgVectorField2.getTetraInd();
            pgVectorField = pgVectorField2.getNeighbourLocInd();
            PgVectorField pgVectorField3 = new PgVectorField(2);
            pgVectorField3.setName("Adjacency");
            pgVectorField3.setBasedOn(1);
            pgVectorField3.setNumVectors(n3);
            pgVectorField3.setGeometry((PgPointSet)pgVectorField2);
            PgVectorField pgVectorField4 = pgTetraSet.getVectorField(0);
            PgVectorField pgVectorField5 = pgTetraSet.getVectorField(1);
            PgVectorField pgVectorField6 = new PgVectorField(pgVectorField4.getDimOfVectors());
            PgVectorField pgVectorField7 = new PgVectorField(pgVectorField5.getDimOfVectors());
            pgVectorField6.setName(pgVectorField4.getName());
            pgVectorField7.setName(pgVectorField5.getName());
            pgVectorField6.setBasedOn(1);
            pgVectorField7.setBasedOn(1);
            pgVectorField6.setNumVectors(n3);
            pgVectorField7.setNumVectors(n3);
            pgVectorField6.setGeometry((PgPointSet)pgVectorField2);
            pgVectorField7.setGeometry((PgPointSet)pgVectorField2);
            PgVectorField pgVectorField8 = new PgVectorField(1);
            pgVectorField8.setName("Mapping");
            pgVectorField8.setBasedOn(1);
            pgVectorField8.setNumVectors(n3);
            pgVectorField8.setGeometry((PgPointSet)pgVectorField2);
            for (int i = 0; i < n3; ++i) {
                pgVectorField3.setVector(i, new PdVector((double)piVector.m_data[i], (double)pgVectorField.m_data[i]));
                pgVectorField6.setVector(i, PdVector.copyNew((PdVector)pgVectorField4.getVector(piVector.m_data[i])));
                pgVectorField7.setVector(i, PdVector.copyNew((PdVector)pgVectorField5.getVector(piVector.m_data[i])));
                pgVectorField8.setVector(i, 12.0);
            }
            pgVectorField2.addVectorField(pgVectorField6);
            pgVectorField2.addVectorField(pgVectorField7);
            pgVectorField2.addVectorField(pgVectorField3);
            pgVectorField2.addVectorField(pgVectorField8);
            if (this.m_display != null) {
                this.m_display.addGeometry((PgGeometryIf)pgVectorField2);
                this.m_display.update((Object)pgVectorField2);
            }
        }
        this.m_cubeSet.update((Object)this.m_cubeSet);
        super.ok();
    }

    public static PgVectorField computeRotationField(PgCubeSet pgCubeSet, boolean bl) {
        if (pgCubeSet.getNeighbours() == null) {
            PsDebug.warning((String)"Missing Neighbourhood Information");
            return null;
        }
        int n = pgCubeSet.getNumCubes();
        PgVectorField pgVectorField = new PgVectorField(6, 1);
        pgVectorField.setGeometry((PgPointSet)pgCubeSet);
        pgVectorField.setBasedOn(1);
        pgVectorField.setNumVectors(n);
        pgVectorField.setName("Rotation Field");
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = pgVectorField.getVector(i);
            PiVector piVector = pgCubeSet.getCube(i);
            for (int j = 0; j < 6; ++j) {
                int[] nArray;
                int n2;
                int[] nArray2;
                int n3 = pgCubeSet.getNeighbour((int)i).m_data[j];
                if (n3 == -1) {
                    pdVector.m_data[j] = -1 - j / 2;
                    continue;
                }
                int n4 = PgCubeSet.LOCAL_FACE_TO_VERTEX[j][1];
                int n5 = PgCubeSet.LOCAL_FACE_TO_VERTEX[j][0];
                int n6 = PgCubeSet.LOCAL_FACE_TO_VERTEX[j][3];
                if ((nArray2 = new int[]{n4 - n5, n6 - n5, 7 - Math.abs(nArray2[0]) - Math.abs(nArray2[1])})[2] == 1 && n5 % 2 == 1 || nArray2[2] == 2 && n5 / 2 % 2 == 1 || nArray2[2] == 4 && n5 / 4 % 2 == 1) {
                    nArray2[2] = nArray2[2] * -1;
                }
                PiVector piVector2 = pgCubeSet.getCube(n3);
                int n7 = piVector2.getIndexOf(piVector.m_data[n5]);
                int n8 = piVector2.getIndexOf(piVector.m_data[n4]);
                nArray = new int[]{n8 - n7, (n2 = piVector2.getIndexOf(piVector.m_data[n6])) - n7, 7 - Math.abs(nArray[0]) - Math.abs(nArray[1])};
                if (nArray[2] == 1 && n7 % 2 == 0 || nArray[2] == 2 && n7 / 2 % 2 == 0 || nArray[2] == 4 && n7 / 4 % 2 == 0) {
                    nArray[2] = nArray[2] * -1;
                }
                int n9 = 0;
                for (int k = 0; k < 3; ++k) {
                    int n10 = Math.abs(nArray2[k]) == 1 ? 100 : (Math.abs(nArray2[k]) == 2 ? 10 : 1);
                    int n11 = Math.abs(nArray[k]) == 1 ? 0 : (Math.abs(nArray[k]) == 2 ? 1 : 2);
                    if (nArray2[k] * nArray[k] < 0) {
                        n11 += 3;
                    }
                    n9 += n10 * n11;
                }
                pdVector.m_data[j] = n9;
            }
        }
        if (bl) {
            pgCubeSet.addVectorField(pgVectorField);
        }
        return pgVectorField;
    }

    public static void addTexturePerCube(PgCubeSet pgCubeSet) {
        pgCubeSet.setDimOfTextures(3);
        pgCubeSet.assureCubeTextures();
        int n = pgCubeSet.getNumCubes();
        for (int i = 0; i < n; ++i) {
            PdVector[] pdVectorArray = new PdVector[8];
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        pdVectorArray[4 * i2 + 2 * k + j] = new PdVector((double)j, (double)k, (double)i2);
                    }
                }
            }
            pgCubeSet.setCubeTexture(i, pdVectorArray);
        }
    }

    public static void relaxVertices(PgCubeSet pgCubeSet, boolean bl) {
        int n;
        PiVector piVector;
        int n2;
        int n3 = pgCubeSet.getNumVertices();
        int n4 = pgCubeSet.getNumCubes();
        PiVector piVector2 = new PiVector(n3);
        piVector2.setConstant(0);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)n3, (int)pgCubeSet.getDimOfVertices());
        PdVector pdVector = new PdVector(pgCubeSet.getDimOfVertices());
        PdVector pdVector2 = new PdVector(pgCubeSet.getDimOfVertices());
        PdVector pdVector3 = new PdVector(pgCubeSet.getDimOfVertices());
        double d = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            piVector = pgCubeSet.getCube(n2);
            for (n = 0; n < 12; ++n) {
                d += PdVector.dist((PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n][0]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n][1]]));
            }
        }
        d /= 12.0 * (double)n4;
        for (n2 = 0; n2 < n4; ++n2) {
            piVector = pgCubeSet.getCube(n2);
            pdVector = PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pgCubeSet.getVertices(), (int[])piVector.m_data);
            for (n = 0; n < 3; ++n) {
                pdVector2.setConstant(0.0);
                for (int i = 0; i < 4; ++i) {
                    pdVector2.add(pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][1]]));
                    pdVector2.sub(pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][0]]));
                }
                double d2 = pdVector2.length() / 4.0;
                if (bl) {
                    d2 = d;
                }
                pdVector2.normalize();
                for (int i = 0; i < 4; ++i) {
                    double d3 = PdVector.dist((PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][0]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][1]]));
                    if (d3 == 0.0) {
                        d3 = 1.0;
                    }
                    double d4 = PdVector.dot((PdVector)PdVector.subNew((PdVector)pdVector, (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][0]])), (PdVector)pdVector2);
                    pdVector3.blend((d3 - d4) / d3, pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][0]]), d4 / d3, pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][1]]));
                    pdVectorArray[piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][0]]].add(PdVector.blendNew((double)1.0, (PdVector)pdVector3, (double)(-d2 / 2.0), (PdVector)pdVector2));
                    pdVectorArray[piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n * 4 + i][1]]].add(PdVector.blendNew((double)1.0, (PdVector)pdVector3, (double)(d2 / 2.0), (PdVector)pdVector2));
                }
            }
            for (n = 0; n < 8; ++n) {
                int n5 = piVector.m_data[n];
                piVector2.m_data[n5] = piVector2.m_data[n5] + 1;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (pgCubeSet.hasTagVertex(n2, 1) || piVector2.m_data[n2] == 0) continue;
            pdVectorArray[n2].multScalar(1.0 / (3.0 * (double)piVector2.m_data[n2]));
            pgCubeSet.getVertex(n2).copy(pdVectorArray[n2]);
        }
    }

    public static PgCubeSet guessCubes(PgElementSet pgElementSet) {
        int n;
        int n2;
        PiVector[] piVectorArray;
        int n3 = pgElementSet.getNumVertices();
        int n4 = pgElementSet.getNumElements();
        PiVector piVector = new PiVector(n3);
        piVector.setConstant(0);
        for (int i = 0; i < n4; ++i) {
            piVectorArray = pgElementSet.getElement(i);
            if (piVectorArray.getSize() != 4) continue;
            for (n2 = 0; n2 < 4; ++n2) {
                int n5 = piVectorArray.m_data[n2];
                piVector.m_data[n5] = piVector.m_data[n5] + 1;
            }
        }
        PiVector[] piVectorArray2 = new PiVector[n3];
        piVectorArray = new PiVector[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            piVectorArray2[n2] = new PiVector(piVector.m_data[n2]);
            piVectorArray[n2] = new PiVector(0);
        }
        piVector.setConstant(0);
        for (n2 = 0; n2 < n4; ++n2) {
            PiVector piVector2 = pgElementSet.getElement(n2);
            if (piVector2.getSize() != 4) continue;
            for (int i = 0; i < 4; ++i) {
                int n6;
                piVectorArray2[piVector2.m_data[i]].m_data[piVector.m_data[piVector2.m_data[i]]] = n2;
                int n7 = piVector2.m_data[i];
                piVector.m_data[n7] = piVector.m_data[n7] + 1;
                if (piVectorArray[piVector2.m_data[i]].getIndexOf(piVector2.m_data[(i + 1) % 4]) < 0) {
                    n6 = piVectorArray[piVector2.m_data[i]].getSize();
                    piVectorArray[piVector2.m_data[i]].setSize(n6 + 1);
                    piVectorArray[piVector2.m_data[i]].m_data[n6] = piVector2.m_data[(i + 1) % 4];
                }
                if (piVectorArray[piVector2.m_data[(i + 1) % 4]].getIndexOf(piVector2.m_data[i]) >= 0) continue;
                n6 = piVectorArray[piVector2.m_data[(i + 1) % 4]].getSize();
                piVectorArray[piVector2.m_data[(i + 1) % 4]].setSize(n6 + 1);
                piVectorArray[piVector2.m_data[(i + 1) % 4]].m_data[n6] = piVector2.m_data[i];
            }
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        for (int i = 0; i < n4; ++i) {
            PiVector piVector3 = pgElementSet.getElement(i);
            if (piVector3.getSize() != 4) continue;
            PiVector piVector4 = piVectorArray[piVector3.m_data[0]];
            n = piVector4.getSize();
            for (int j = 0; j < n; ++j) {
                if (piVector4.m_data[j] == piVector3.m_data[1] || piVector4.m_data[j] == piVector3.m_data[3]) continue;
                PiVector piVector5 = piVectorArray2[piVector4.m_data[j]];
                int n8 = piVector5.getSize();
                for (int k = 0; k < n8; ++k) {
                    PiVector piVector6;
                    if (piVector5.m_data[k] < i || (piVector6 = pgElementSet.getElement(piVector5.m_data[k])).getIndexOf(piVector3.m_data[0]) != -1) continue;
                    int n9 = piVector6.getIndexOf(piVector4.m_data[j]);
                    PiVector piVector7 = null;
                    if (piVectorArray[piVector3.m_data[2]].getIndexOf(piVector6.m_data[(n9 + 2) % 4]) != -1 && piVectorArray[piVector3.m_data[1]].getIndexOf(piVector6.m_data[(n9 + 1) % 4]) != -1 && piVectorArray[piVector3.m_data[3]].getIndexOf(piVector6.m_data[(n9 + 3) % 4]) != -1) {
                        piVector7 = new PiVector(new int[]{piVector3.m_data[0], piVector6.m_data[n9], piVector3.m_data[1], piVector6.m_data[(n9 + 1) % 4], piVector3.m_data[3], piVector6.m_data[(n9 + 3) % 4], piVector3.m_data[2], piVector6.m_data[(n9 + 2) % 4]});
                    }
                    if (piVectorArray[piVector3.m_data[2]].getIndexOf(piVector6.m_data[(n9 + 2) % 4]) != -1 && piVectorArray[piVector3.m_data[1]].getIndexOf(piVector6.m_data[(n9 + 3) % 4]) != -1 && piVectorArray[piVector3.m_data[3]].getIndexOf(piVector6.m_data[(n9 + 1) % 4]) != -1) {
                        piVector7 = new PiVector(new int[]{piVector3.m_data[0], piVector6.m_data[n9], piVector3.m_data[1], piVector6.m_data[(n9 + 3) % 4], piVector3.m_data[3], piVector6.m_data[(n9 + 1) % 4], piVector3.m_data[2], piVector6.m_data[(n9 + 2) % 4]});
                    }
                    if (piVector7 == null) continue;
                    vector.addElement(piVector7);
                }
            }
        }
        PgCubeSet pgCubeSet = new PgCubeSet(pgElementSet.getDimOfVertices());
        pgCubeSet.copy((PsObject)pgElementSet);
        pgCubeSet.setName("Cube Set from " + pgElementSet.getName());
        int n10 = vector.size();
        PiVector[] piVectorArray3 = new PiVector[n10];
        for (n = 0; n < n10; ++n) {
            piVectorArray3[n] = (PiVector)vector.elementAt(n);
        }
        pgCubeSet.setNumCubes(n10);
        pgCubeSet.setCubes(piVectorArray3);
        PwCubeSet.removeDuplicateCubes(pgCubeSet);
        pgCubeSet.makeNeighbour();
        PwCubeSet.makeOrientation(pgCubeSet);
        return pgCubeSet;
    }

    public static void removeDuplicateCubes(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        int n3 = pgCubeSet.getNumCubes();
        int n4 = pgCubeSet.getNumVertices();
        PiVector piVector = new PiVector(n4);
        piVector.setConstant(0);
        for (int i = 0; i < n3; ++i) {
            PiVector piVector2 = pgCubeSet.getCube(i);
            int n5 = piVector2.m_data[0];
            for (n2 = 1; n2 < 8; ++n2) {
                if (piVector2.m_data[n2] >= n5) continue;
                n5 = piVector2.m_data[n2];
            }
            int n6 = n5;
            piVector.m_data[n6] = piVector.m_data[n6] + 1;
        }
        PiVector[] piVectorArray = new PiVector[n4];
        for (n = 0; n < n4; ++n) {
            piVectorArray[n] = new PiVector(piVector.m_data[n]);
        }
        piVector.setConstant(0);
        n = 0;
        while (n < n3) {
            PiVector piVector3 = pgCubeSet.getCube(n);
            n2 = piVector3.m_data[0];
            for (int i = 1; i < 8; ++i) {
                if (piVector3.m_data[i] >= n2) continue;
                n2 = piVector3.m_data[i];
            }
            piVectorArray[n2].m_data[piVector.m_data[n2]] = n++;
            int n7 = n2;
            piVector.m_data[n7] = piVector.m_data[n7] + 1;
        }
        for (n = 0; n < n4; ++n) {
            if (piVector.m_data[n] < 2) continue;
            int n8 = piVector.m_data[n];
            for (n2 = 0; n2 < n8 - 1; ++n2) {
                PiVector piVector4 = pgCubeSet.getCube(piVectorArray[n].m_data[n2]);
                for (int i = n2 + 1; i < n8; ++i) {
                    PiVector piVector5 = pgCubeSet.getCube(piVectorArray[n].m_data[i]);
                    boolean bl = true;
                    for (int j = 0; j < 8; ++j) {
                        if (piVector5.getIndexOf(piVector4.m_data[j]) >= 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    piVector5.setTag(2);
                }
            }
        }
        pgCubeSet.removeMarkedCubes();
    }

    public static PdVector computeCubeDihedralAngles(PgCubeSet pgCubeSet, int n) {
        int n2;
        int n3;
        PdVector pdVector = new PdVector(12);
        PiVector piVector = pgCubeSet.getCube(n);
        PdVector[] pdVectorArray = new PdVector[6];
        for (n3 = 0; n3 < 6; ++n3) {
            pdVectorArray[n3] = new PdVector(3);
            for (n2 = 0; n2 < 4; ++n2) {
                pdVectorArray[n3].add(PdVector.crossNew((PdVector)PdVector.subNew((PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n3][(n2 + 2) % 4]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n3][(n2 + 1) % 4]])), (PdVector)PdVector.subNew((PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n3][(n2 + 0) % 4]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n3][(n2 + 1) % 4]]))));
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            for (int i = n2 + 1; i < 6; ++i) {
                if (n2 / 2 == i / 2) continue;
                double d = PdVector.angle((PdVector)pdVectorArray[n2], (PdVector)pdVectorArray[i]);
                pdVector.m_data[n3] = 180.0 - d;
                ++n3;
            }
        }
        return pdVector;
    }

    public static PiVector countDihedralAnglesByBins(PgCubeSet pgCubeSet, PdVector pdVector) {
        int n = pdVector.getSize();
        PiVector piVector = new PiVector(n + 1);
        int n2 = pgCubeSet.getNumCubes();
        for (int i = 0; i < n2; ++i) {
            PdVector pdVector2 = PwCubeSet.computeCubeDihedralAngles(pgCubeSet, i);
            int n3 = 0;
            for (int j = 0; j < 12; ++j) {
                for (n3 = 0; n3 < n && pdVector2.m_data[j] > pdVector.m_data[n3]; ++n3) {
                }
                int n4 = n3;
                piVector.m_data[n4] = piVector.m_data[n4] + 1;
            }
        }
        return piVector;
    }

    public static double[] computeAllDihedralAngles(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumCubes();
        double[] dArray = new double[12 * n];
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = PwCubeSet.computeCubeDihedralAngles(pgCubeSet, i);
            for (int j = 0; j < 12; ++j) {
                dArray[i * 12 + j] = pdVector.m_data[j];
            }
        }
        return dArray;
    }

    public static void countEdgeValences(PgCubeSet pgCubeSet, PiVector piVector, PiVector piVector2) {
        int n;
        int n2;
        int n3 = pgCubeSet.getNumCubes();
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 12; ++n) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, n2, n, null);
                int n4 = pgEdgeStar.getValence();
                boolean bl = false;
                if (pgCubeSet.getNeighbour((int)n2).m_data[FACE_AT_EDGE[n][0]] == -1 || pgCubeSet.getNeighbour((int)n2).m_data[FACE_AT_EDGE[n][1]] == -1) {
                    bl = true;
                }
                if (bl) {
                    if (piVector2.getSize() < n4 + 1) {
                        piVector2.setSize(n4 + 1);
                    }
                    int n5 = n4;
                    piVector2.m_data[n5] = piVector2.m_data[n5] + 1;
                    continue;
                }
                if (piVector.getSize() < n4 + 1) {
                    piVector.setSize(n4 + 1);
                }
                int n6 = n4;
                piVector.m_data[n6] = piVector.m_data[n6] + 1;
            }
        }
        for (n2 = 3; n2 < piVector2.getSize(); ++n2) {
            n = piVector2.m_data[n2] / 2;
            int n7 = n2;
            piVector.m_data[n7] = piVector.m_data[n7] - (n2 - 2) * n;
            int n8 = n2;
            piVector2.m_data[n8] = piVector2.m_data[n8] + (n2 - 2) * n;
        }
        for (n2 = 2; n2 < piVector.getSize(); ++n2) {
            int n9 = n2;
            piVector.m_data[n9] = piVector.m_data[n9] / n2;
        }
        for (n2 = 2; n2 < piVector2.getSize(); ++n2) {
            int n10 = n2;
            piVector2.m_data[n10] = piVector2.m_data[n10] / n2;
        }
    }

    public static PgPolygonSet[] ExtractSingularities(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        PgPolygonSet[] pgPolygonSetArray = new PgPolygonSet[2];
        for (n2 = 0; n2 < 2; ++n2) {
            pgPolygonSetArray[n2] = new PgPolygonSet(3);
            pgPolygonSetArray[n2].copy((PsObject)pgCubeSet);
        }
        n2 = pgCubeSet.getNumCubes();
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (n = 0; n < n2; ++n) {
            PiVector piVector = pgCubeSet.getCube(n);
            for (int i = 0; i < 12; ++i) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, n, i, null);
                int n3 = pgEdgeStar.getValence();
                boolean bl = true;
                for (int j = 0; j < n3; ++j) {
                    if (pgEdgeStar.getElementInd()[j] >= n) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (PwCubeSet.edgeStarIsClosed(pgCubeSet, pgEdgeStar)) {
                    if (n3 == 4) continue;
                    pgPolygonSetArray[0].addPolygon(new PiVector(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][0]], piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][1]]));
                    continue;
                }
                if (n3 == 2) continue;
                pgPolygonSetArray[1].addPolygon(new PiVector(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][0]], piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[i][1]]));
            }
        }
        pgPolygonSetArray[0].setName("Inner Singularities");
        pgPolygonSetArray[1].setName("Boundary Singularities");
        for (n = 0; n < 2; ++n) {
            pgPolygonSetArray[n].removeUnusedVertices();
            PwCleanMesh.joinPolygons(pgPolygonSetArray[n]);
        }
        return pgPolygonSetArray;
    }

    public static void selectSingularVertices(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumCubes();
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgCubeSet.getCube(i);
            for (int j = 0; j < 12; ++j) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, i, j, null);
                int n2 = pgEdgeStar.getValence();
                boolean bl = true;
                for (int k = 0; k < n2; ++k) {
                    if (pgEdgeStar.getElementInd()[k] >= i) continue;
                    bl = false;
                    break;
                }
                if (!bl || (!PwCubeSet.edgeStarIsClosed(pgCubeSet, pgEdgeStar) || n2 == 4) && (PwCubeSet.edgeStarIsClosed(pgCubeSet, pgEdgeStar) || n2 == 2)) continue;
                pgCubeSet.setTagVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][0]], 1);
                pgCubeSet.setTagVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][1]], 1);
            }
        }
    }

    public static void selectSingularInner2Vertices(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumCubes();
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgCubeSet.getCube(i);
            for (int j = 0; j < 12; ++j) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, i, j, null);
                int n2 = pgEdgeStar.getValence();
                boolean bl = true;
                for (int k = 0; k < n2; ++k) {
                    if (pgEdgeStar.getElementInd()[k] >= i) continue;
                    bl = false;
                    break;
                }
                if (!bl || !PwCubeSet.edgeStarIsClosed(pgCubeSet, pgEdgeStar) || n2 != 2) continue;
                pgCubeSet.setTagVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][0]], 1);
                pgCubeSet.setTagVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][1]], 1);
            }
        }
    }

    public static double[] computeAllEdgeLengths(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        int n3;
        int n4;
        PgPolygonSet[] pgPolygonSetArray = new PgPolygonSet[2];
        for (n4 = 0; n4 < 2; ++n4) {
            pgPolygonSetArray[n4] = new PgPolygonSet(3);
            pgPolygonSetArray[n4].copy((PsObject)pgCubeSet);
        }
        n4 = pgCubeSet.getNumCubes();
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < 12; ++n3) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, i, n3, null);
                int n6 = pgEdgeStar.getValence();
                n2 = 1;
                for (n = 0; n < n6; ++n) {
                    if (pgEdgeStar.getElementInd()[n] >= i) continue;
                    n2 = 0;
                    break;
                }
                if (n2 == 0) continue;
                ++n5;
            }
        }
        double[] dArray = new double[n5];
        n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            PiVector piVector = pgCubeSet.getCube(n3);
            for (n2 = 0; n2 < 12; ++n2) {
                pgEdgeStar = PwCubeSet.computeEdgeStar(pgCubeSet, n3, n2, null);
                n = pgEdgeStar.getValence();
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    if (pgEdgeStar.getElementInd()[i] >= n3) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                dArray[n5] = PdVector.dist((PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n2][0]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[n2][1]]));
                ++n5;
            }
        }
        return dArray;
    }

    public static double computeCubeVolume(PgCubeSet pgCubeSet, int n) {
        double d = 0.0;
        PiVector piVector = pgCubeSet.getCube(n);
        PiVector piVector2 = new PiVector(3);
        for (int i = 0; i < 8; ++i) {
            int n2 = 0;
            for (int j = 0; j < 12; ++j) {
                if (PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][0] == i) {
                    piVector2.m_data[n2] = PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][1];
                    ++n2;
                } else if (PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][1] == i) {
                    piVector2.m_data[n2] = PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][0];
                    ++n2;
                }
                if (n2 == 3) break;
            }
            d += Math.abs(PdVector.dot((PdVector)PdVector.subNew((PdVector)pgCubeSet.getVertex(piVector.m_data[piVector2.m_data[0]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[i])), (PdVector)PdVector.crossNew((PdVector)PdVector.subNew((PdVector)pgCubeSet.getVertex(piVector.m_data[piVector2.m_data[1]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[i])), (PdVector)PdVector.subNew((PdVector)pgCubeSet.getVertex(piVector.m_data[piVector2.m_data[2]]), (PdVector)pgCubeSet.getVertex(piVector.m_data[i]))))) / 8.0;
        }
        return d;
    }

    public static double[] computeAllCubeVolumes(PgCubeSet pgCubeSet) {
        int n = pgCubeSet.getNumCubes();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = PwCubeSet.computeCubeVolume(pgCubeSet, i);
        }
        return dArray;
    }

    public static PgCubeSet[] splitToLayers(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        int n3 = pgCubeSet.getNumCubes();
        PiVector piVector = new PiVector(n3);
        piVector.setConstant(-1);
        int n4 = 0;
        boolean bl = true;
        int n5 = 0;
        int n6 = pgCubeSet.getNumVertices();
        boolean[] blArray = new boolean[n6];
        int n7 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            if (pgCubeSet.hasTagVertex(n2, 1)) {
                blArray[n2] = true;
                ++n7;
                continue;
            }
            blArray[n2] = false;
        }
        if (n7 == 0) {
            PsDebug.warning((String)"No selected vertices found - stop splitting cubeSet to layers.");
            return null;
        }
        while (bl && n4 < n3) {
            PiVector piVector2;
            bl = false;
            block2: for (n2 = 0; n2 < n3; ++n2) {
                if (piVector.m_data[n2] != -1) continue;
                piVector2 = pgCubeSet.getCube(n2);
                for (n = 0; n < 8; ++n) {
                    if (!blArray[piVector2.m_data[n]]) continue;
                    bl = true;
                    piVector.m_data[n2] = n5;
                    ++n4;
                    continue block2;
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (piVector.m_data[n2] == -1) continue;
                piVector2 = pgCubeSet.getCube(n2);
                for (n = 0; n < 8; ++n) {
                    blArray[piVector2.m_data[n]] = true;
                }
            }
            if (!bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (piVector.m_data[n2] != -1) continue;
                    piVector.m_data[n2] = n5;
                }
            }
            ++n5;
        }
        PgCubeSet[] pgCubeSetArray = new PgCubeSet[n5];
        for (int i = 0; i < n5; ++i) {
            pgCubeSetArray[i] = (PgCubeSet)((Object)pgCubeSet.clone());
            for (n = 0; n < n3; ++n) {
                if (piVector.m_data[n] == i) continue;
                pgCubeSetArray[i].setTagCube(n, 2);
            }
            pgCubeSetArray[i].removeMarkedCubes();
            pgCubeSetArray[i].removeUnusedVertices();
            pgCubeSetArray[i].makeNeighbour();
            pgCubeSetArray[i].setName(pgCubeSet.getName() + " Layer " + i);
        }
        return pgCubeSetArray;
    }

    public static void addBoundaryLayer(PgCubeSet pgCubeSet) {
        int n;
        int n2;
        int n3 = pgCubeSet.getNumVertices();
        int n4 = pgCubeSet.getNumCubes();
        pgCubeSet.setNumVertices(2 * n3);
        for (int i = 0; i < n3; ++i) {
            pgCubeSet.setVertex(i + n3, PdVector.copyNew((PdVector)pgCubeSet.getVertex(i)));
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        for (n2 = 0; n2 < n4; ++n2) {
            PiVector piVector = pgCubeSet.getCube(n2);
            PiVector piVector2 = pgCubeSet.getNeighbour(n2);
            for (n = 0; n < 6; ++n) {
                if (piVector2.m_data[n] != -1) continue;
                PiVector piVector3 = new PiVector(8);
                piVector3.m_data[0] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][0]];
                piVector3.m_data[1] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][0]] + n3;
                piVector3.m_data[2] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][1]];
                piVector3.m_data[3] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][1]] + n3;
                piVector3.m_data[4] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][3]];
                piVector3.m_data[5] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][3]] + n3;
                piVector3.m_data[6] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][2]];
                piVector3.m_data[7] = piVector.m_data[PgCubeSet.LOCAL_FACE_TO_VERTEX[n][2]] + n3;
                vector.addElement(piVector3);
            }
        }
        n2 = vector.size();
        pgCubeSet.setNumCubes(n4 + n2);
        for (n = 0; n < n2; ++n) {
            pgCubeSet.setCube(n4 + n, (PiVector)vector.elementAt(n));
        }
        pgCubeSet.removeUnusedVertices();
        pgCubeSet.makeNeighbour();
        PwCubeSet.makeOrientation(pgCubeSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

