/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jvx.geom.PgPointSetOnElementSet;
import jvx.numeric.PnVertexRK;
import jvx.project.PjWorkshop;

public class PwSeeds
extends PjWorkshop
implements PsTimeListenerIf {
    protected PgElementSet m_elementSet;
    private PgVectorField m_vectorField;
    private PgPointSetOnElementSet m_seeds;
    private PnVertexRK m_solver;
    private PsAnimation m_animation = new PsAnimation();
    private boolean m_bFirstOrder = false;
    protected PuInteger m_vectorFieldIndex;
    protected PuInteger m_numSeeds;
    protected PuDouble m_stepSize;
    private static final double NUMFRAMES = 40.0;
    private static final int INITIAL_NUM_SEEDS = 1000;
    static /* synthetic */ Class class$jvx$vector$PwSeeds;

    public PwSeeds() {
        super("Seeds");
        this.m_animation.setName("Seeds");
        this.m_animation.addTimeListener((PsTimeListenerIf)this);
        this.m_animation.setTimeInterval(0.0, 400.0, 10.0, 20.0);
        this.m_animation.setRepeat(1);
        this.m_vectorFieldIndex = new PuInteger("Vector field", (PsUpdateIf)this);
        this.m_numSeeds = new PuInteger("Number seeds", (PsUpdateIf)this);
        this.m_stepSize = new PuDouble("Step size", (PsUpdateIf)this);
        this.m_numSeeds.setDefBounds(100, 50000, 100, 1000);
        this.m_numSeeds.setDefValue(10000);
        this.m_numSeeds.init();
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwSeeds == null ? (class$jvx$vector$PwSeeds = PwSeeds.class$("jvx.vector.PwSeeds")) : class$jvx$vector$PwSeeds)) {
            this.init();
        }
    }

    public void init() {
        if (this.m_seeds != null) {
            PwSeeds.setToRandomPosition(this.m_seeds);
            this.m_seeds.update(null);
        }
        this.m_stepSize.setDefBounds(1.0E-10, 1.0, 0.01, 0.1);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        super.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry is no PgElementSet");
            return;
        }
        if (((PgElementSet)pgGeometry).getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated - aborted.");
            return;
        }
        while (this.m_animation.isRunning()) {
            this.m_animation.stop();
        }
        this.removeGeometry();
        super.setGeometry(pgGeometry);
        this.m_elementSet = (PgElementSet)pgGeometry;
        this.m_elementSet.setGlobalVectorColor(Color.black);
        this.m_elementSet.setGlobalElementColor(Color.white);
        this.m_elementSet.showVectorFields(false);
        this.m_elementSet.showEdges(false);
        this.m_elementSet.showElementTexture(false);
        this.m_elementSet.update(null);
        this.m_solver = new PnVertexRK(this.m_elementSet);
        this.setStepSize(0.1);
        this.setFirstOrder(false);
        this.setVectorFieldIndex(0);
        this.m_vectorFieldIndex.setBounds(0, this.m_elementSet.getNumVectorFields() - 1);
        this.m_seeds = new PgPointSetOnElementSet(this.m_elementSet);
        this.setNumSeeds(1000);
        this.m_seeds.setName("Seeds");
        this.m_seeds.setGlobalVertexSize(2.0);
        this.m_seeds.setGlobalVertexColor(Color.red);
        this.m_seeds.showVertexOutline(false);
        this.m_seeds.showVertices(true);
    }

    public boolean hasAnimation() {
        return this.m_animation != null;
    }

    public PsAnimation getAnimation() {
        return this.m_animation;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_animation = psAnimation;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_elementSet == null) {
            return false;
        }
        int n = this.m_seeds.getNumVertices();
        PdBary[] pdBaryArray = this.m_seeds.getVertexBary();
        for (int i = 0; i < n; ++i) {
            this.m_solver.solve(pdBaryArray[i], this.m_stepSize.getValue(), 1, pdBaryArray[i]);
        }
        this.m_seeds.computeVertices();
        this.m_seeds.update(null);
        return true;
    }

    public int getVectorFieldIndex() {
        return this.m_vectorFieldIndex.getValue();
    }

    public void setVectorFieldIndex(int n) {
        if (this.m_elementSet == null) {
            return;
        }
        int n2 = this.m_elementSet.getNumVectorFields();
        if (n < 0 || n >= n2) {
            return;
        }
        this.m_vectorFieldIndex.setValue(n);
        this.m_vectorField = this.m_elementSet.getVectorField(n);
        this.m_solver.setVectorField(this.m_vectorField);
        this.update(null);
    }

    public int getNumSeeds() {
        return this.m_numSeeds.getValue();
    }

    public void setNumSeeds(int n) {
        this.m_numSeeds.setValue(n);
        if (this.m_elementSet == null) {
            return;
        }
        int n2 = this.m_seeds.getNumVertices();
        this.m_seeds.setNumVertices(n);
        if (n > n2) {
            PwSeeds.setToRandomPosition(this.m_seeds, n2, n);
        }
        this.m_seeds.update(null);
    }

    public double getStepSize() {
        return this.m_stepSize.getValue();
    }

    public void setStepSize(double d) {
        this.m_stepSize.setValue(d);
    }

    public boolean usesFirstOrder() {
        return this.m_bFirstOrder;
    }

    public void setFirstOrder(boolean bl) {
        if (this.m_elementSet == null) {
            return;
        }
        this.m_bFirstOrder = bl;
        this.m_solver.setFirstOrder(this.m_bFirstOrder);
    }

    public void ok() {
        while (this.m_animation.isRunning()) {
            this.m_animation.stop();
        }
        this.m_animation.removeTimeListener((PsTimeListenerIf)this);
        super.ok();
    }

    public void reset() {
        while (this.m_animation.isRunning()) {
            this.m_animation.stop();
        }
        this.m_animation.removeTimeListener((PsTimeListenerIf)this);
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.m_geom.update((Object)this.m_geom);
        }
        super.reset();
    }

    public void cancel() {
        while (this.m_animation.isRunning()) {
            this.m_animation.stop();
        }
        this.m_animation.removeTimeListener((PsTimeListenerIf)this);
        this.removeSeeds();
        super.cancel();
    }

    public void removeSeeds() {
        if (this.m_display == null) {
            return;
        }
        if (this.m_seeds == null) {
            return;
        }
        this.m_display.removeGeometry((PgGeometryIf)this.m_seeds);
        this.m_display.update(null);
        this.m_seeds = null;
    }

    public void removeGeometry() {
        super.removeGeometry();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
        if (this.m_display != null) {
            this.m_display.setBackgroundColor(Color.white);
            this.m_display.setEnabledZBuffer(true);
        }
        if (this.m_display != null && this.m_seeds != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_seeds);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_numSeeds) {
            this.setNumSeeds(this.m_numSeeds.getValue());
        } else if (object == this.m_stepSize) {
            this.setStepSize(this.m_stepSize.getValue());
        } else if (object == this.m_vectorFieldIndex) {
            this.setVectorFieldIndex(this.m_vectorFieldIndex.getValue());
        } else if (object != this) {
            return super.update(object);
        }
        return true;
    }

    public static void setToRandomPosition(PgPointSetOnElementSet pgPointSetOnElementSet, int n, int n2) {
        int n3;
        if (pgPointSetOnElementSet == null) {
            PsDebug.warning((String)"missing seeds objects");
            return;
        }
        PgElementSet pgElementSet = pgPointSetOnElementSet.getGeometry();
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing base surface of seeds");
            return;
        }
        int n4 = pgElementSet.getNumElements();
        double[] dArray = new double[n4];
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = pgElementSet.getAreaOfElement(n3);
            d += dArray[n3];
        }
        if (d < 1.0E-10) {
            PsDebug.warning((String)"Surface has zero surface area, cannot distribute seeds");
            return;
        }
        n3 = 0;
        while (n3 < n4) {
            int n5 = n3++;
            dArray[n5] = dArray[n5] / d;
        }
        n3 = n2 - n;
        int n6 = -1;
        double d2 = 1.0;
        PdBary[] pdBaryArray = pgPointSetOnElementSet.getVertexBary();
        for (int i = n; i < n2; ++i) {
            double d3;
            d2 -= 1.0;
            while (d2 <= 0.0) {
                if (++n6 == n4) {
                    n6 = 0;
                }
                d2 += dArray[n6] * (double)n3;
            }
            double d4 = Math.random();
            if (d4 + (d3 = Math.random()) > 1.0) {
                d4 = 1.0 - d4;
                d3 = 1.0 - d3;
            }
            pdBaryArray[i].set(n6, d4, d3, 1.0 - d4 - d3);
        }
        pgPointSetOnElementSet.computeVertices();
    }

    public static void setToRandomPosition(PgPointSetOnElementSet pgPointSetOnElementSet) {
        PwSeeds.setToRandomPosition(pgPointSetOnElementSet, 0, pgPointSetOnElementSet.getNumVertices());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

