/*
 * Decompiled with CFR 0.152.
 */
package jvx.primitive;

import jv.function.PuFunction;
import jv.geom.PgPolygon;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.primitive.PuIntervalDescr;

public class PgCurveF
extends PgPolygon {
    protected PuIntervalDescr m_intervalDescr;
    protected PuFunction m_function;
    static /* synthetic */ Class class$jvx$primitive$PgCurveF;

    public PgCurveF() {
        this(2);
    }

    public PgCurveF(int n) {
        super(n);
        this.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Curve"));
        this.setTag(10);
        this.m_intervalDescr = new PuIntervalDescr();
        this.m_intervalDescr.setParent((PsUpdateIf)this);
        this.m_intervalDescr.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Interval"));
        this.m_function = new PuFunction(1, n);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Parametrization"));
        if (((Object)((Object)this)).getClass() == (class$jvx$primitive$PgCurveF == null ? (class$jvx$primitive$PgCurveF = PgCurveF.class$("jvx.primitive.PgCurveF")) : class$jvx$primitive$PgCurveF)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showVertices(false);
        this.m_intervalDescr.init();
        this.m_function.init();
    }

    public void computeSample() {
        this.m_intervalDescr.setMaxSize(-10.0, 10.0);
        this.m_intervalDescr.setSize(-Math.PI, Math.PI);
        this.m_intervalDescr.setDiscr(30);
        this.m_function.setVariables(new String[]{"u"});
        this.m_function.setExpression(0, "cos(u)");
        this.m_function.setExpression(1, "sin(2*u)");
        this.compute();
    }

    public Object clone() {
        PgCurveF pgCurveF = (PgCurveF)((Object)super.clone());
        pgCurveF.m_intervalDescr = (PuIntervalDescr)((Object)this.m_intervalDescr.clone());
        pgCurveF.m_intervalDescr.setParent((PsUpdateIf)pgCurveF);
        pgCurveF.m_function = (PuFunction)this.m_function.clone();
        pgCurveF.m_function.setParent((PsUpdateIf)pgCurveF);
        return pgCurveF;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgCurveF)) {
            return;
        }
        PgCurveF pgCurveF = (PgCurveF)psObject;
        this.m_intervalDescr.copy(pgCurveF.m_intervalDescr);
        this.m_function.copy((PsObject)pgCurveF.m_function);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgCurveF *********\n");
        stringBuffer.append(this.m_intervalDescr.toString());
        stringBuffer.append(this.m_function.toString());
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this || object == this.getInspector("Info")) {
            this.compute();
            return super.update(object);
        }
        if (object == this.m_intervalDescr) {
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public PuIntervalDescr getInterval() {
        return this.m_intervalDescr;
    }

    public boolean setInterval(PuIntervalDescr puIntervalDescr) {
        if (puIntervalDescr == null) {
            PsDebug.warning((String)"missing interval descr.");
            return false;
        }
        this.m_intervalDescr.copy(puIntervalDescr);
        return true;
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing argument function.");
            return false;
        }
        if (puFunction.getNumFunctions() != this.getDimOfVertices()) {
            PsDebug.warning((String)"number of functions differs from dimension of vertices.");
            return false;
        }
        this.m_function.copy((PsObject)puFunction);
        return true;
    }

    public void compute() {
        int n = this.m_intervalDescr.getDiscr();
        this.setNumVertices(n);
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        double[] dArray = new double[1];
        for (int i = 0; i < n; ++i) {
            dArray[0] = this.m_intervalDescr.eval(i);
            this.m_function.eval(pdVector.m_data, dArray);
            this.setVertex(i, pdVector);
        }
        this.makeVertexNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

