/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.util.Random;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnJacobi;

public class PnLanczos {
    protected PnMatrixVectorProductIf m_multiply;
    protected PdVector[] m_lanczosVectors;

    public PnLanczos(PnMatrixVectorProductIf pnMatrixVectorProductIf) {
        this.m_multiply = pnMatrixVectorProductIf;
    }

    public void tridiagonalize(PdVector pdVector, PdVector pdVector2, int n) {
        this.m_lanczosVectors = new PdVector[n];
        for (int i = 0; i < n; ++i) {
            this.m_lanczosVectors[i] = new PdVector(this.m_multiply.getDimension());
        }
        PdVector pdVector3 = new PdVector(this.m_multiply.getDimension());
        Random random = new Random(34687L);
        for (int i = 0; i < pdVector3.m_data.length; ++i) {
            pdVector3.m_data[i] = random.nextDouble();
        }
        pdVector3.normalize();
        this.m_lanczosVectors[0] = pdVector3;
        double[] dArray = pdVector.m_data;
        double[] dArray2 = pdVector2.m_data;
        for (int i = 0; i < n; ++i) {
            PdVector pdVector4 = this.m_multiply.run(this.m_lanczosVectors[i]);
            if (i > 0) {
                pdVector4.blendBase(pdVector4, -dArray2[i - 1], this.m_lanczosVectors[i - 1]);
            }
            dArray[i] = PdVector.dot((PdVector)pdVector4, (PdVector)this.m_lanczosVectors[i]);
            if (i == n - 1) break;
            pdVector4.blendBase(pdVector4, -dArray[i], this.m_lanczosVectors[i]);
            dArray2[i] = pdVector4.length();
            pdVector4.multScalar(1.0 / dArray2[i]);
            for (int j = 0; j < i + 1; ++j) {
                pdVector4.orthogonalize(this.m_lanczosVectors[j]);
            }
            pdVector4.normalize();
            this.m_lanczosVectors[i + 1] = pdVector4;
        }
    }

    public PdVector getRitzVector(PdVector pdVector) {
        PdVector pdVector2 = new PdVector(this.m_multiply.getDimension());
        for (int i = 0; i < pdVector2.m_data.length; ++i) {
            for (int j = 0; j < pdVector.m_data.length; ++j) {
                int n = i;
                pdVector2.m_data[n] = pdVector2.m_data[n] + pdVector.m_data[j] * this.m_lanczosVectors[j].m_data[i];
            }
        }
        return pdVector2;
    }

    public void computeEigenpairs(PdVector pdVector, PdVector[] pdVectorArray, int n) {
        this.computeEigenpairs(pdVector, pdVectorArray, n, 0, 3 * n);
    }

    public void computeEigenpairs(PdVector pdVector, PdVector[] pdVectorArray, int n, int n2, int n3) {
        if (pdVector.getSize() < n + n2) {
            pdVector.setSize(n + n2);
        }
        if (n3 > this.m_multiply.getDimension()) {
            n3 = this.m_multiply.getDimension();
        }
        PdVector pdVector2 = new PdVector(n3);
        PdVector pdVector3 = new PdVector(n3);
        this.tridiagonalize(pdVector2, pdVector3, n3);
        PdMatrix pdMatrix = new PdMatrix(n3);
        pdMatrix.m_data[0][0] = pdVector2.m_data[0];
        for (int i = 1; i < n3; ++i) {
            pdMatrix.m_data[i][i] = pdVector2.m_data[i];
            double d = pdVector3.m_data[i - 1];
            pdMatrix.m_data[i - 1][i] = d;
            pdMatrix.m_data[i][i - 1] = d;
        }
        PdVector pdVector4 = new PdVector(n3);
        PdVector[] pdVectorArray2 = new PdVector[n3];
        for (int i = 0; i < pdVectorArray2.length; ++i) {
            pdVectorArray2[i] = new PdVector(n3);
        }
        PnJacobi.computeEigenvectors(pdMatrix, n3, pdVector4, pdVectorArray2);
        int[] nArray = new int[n3];
        PnLanczos.sortByMagnitude(pdVector4, nArray);
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[n3 - 1 - i];
            pdVector.m_data[i + n2] = pdVector4.m_data[n4];
            pdVectorArray[i + n2] = this.getRitzVector(pdVectorArray2[n4]);
        }
    }

    protected static void sortByMagnitude(PdVector pdVector, int[] nArray) {
        PdVector pdVector2 = (PdVector)pdVector.clone();
        for (int i = 0; i < pdVector.getSize(); ++i) {
            if (!(pdVector2.m_data[i] < 0.0)) continue;
            pdVector2.m_data[i] = -pdVector2.m_data[i];
        }
        PuMath.heapsort((int)pdVector.getSize(), (double[])pdVector2.m_data, (int[])nArray);
    }

    public static interface PnMatrixVectorProductIf {
        public PdVector run(PdVector var1);

        public int getDimension();
    }
}

