/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jvx.loader.PsU3dBlock;
import jvx.loader.encoder;

class PsU3dBaseMeshContinuationBlock
extends PsU3dBlock {
    public boolean m_bHasVertexNormals = true;
    public boolean[] m_bUseDiffuseColor;
    public boolean[] m_bUseSpecularColor;
    public int[] m_textureLayerCount;
    public String m_name;
    public int m_chainIndex = 0;
    public int m_faceCount = 0;
    public int m_positionCount = 0;
    public int m_normalCount = 0;
    public int m_diffuseColorCount = 0;
    public int m_specularColorCount = 0;
    public int m_textureCoordCount = 0;
    public float[][] m_basePosition;
    public float[][] m_baseNormal;
    public float[][] m_diffuseColor;
    public float[][] m_specularColor;
    public float[][] m_textureCoord;
    public int[] m_baseShadingID;
    public int[][] m_basePositionIndex;
    public int[][] m_baseNormalIndex;
    public int[][] m_baseDiffuseColorIndex;
    public int[][] m_baseSpecularColorIndex;
    public int[][][] m_baseTextureCoordIndex;
    private int[] m_compressedData;

    public PsU3dBaseMeshContinuationBlock() {
        this.m_blockType = -197;
    }

    public void computeSize() {
        this.m_dataSize = this.m_name.length() + 2 + 28;
        this.m_dataSize += 12 * this.m_positionCount;
        this.m_dataSize += 12 * this.m_normalCount;
        this.m_dataSize += 16 * this.m_diffuseColorCount;
        this.m_dataSize += 16 * this.m_specularColorCount;
        this.m_dataSize += 16 * this.m_textureCoordCount;
        this.encode();
        this.m_dataSize += 4 * this.m_compressedData.length;
    }

    private void encode() {
        encoder encoder2 = new encoder();
        for (int i = 0; i < this.m_faceCount; ++i) {
            encoder2.writeCompressedU32(-1, this.m_baseShadingID[i]);
            for (int j = 0; j < 3; ++j) {
                encoder2.writeCompressedU32(this.m_positionCount, this.m_basePositionIndex[i][j]);
                if (this.m_bHasVertexNormals) {
                    encoder2.writeCompressedU32(this.m_normalCount, this.m_baseNormalIndex[i][j]);
                }
                if (this.m_bUseDiffuseColor[this.m_baseShadingID[i]]) {
                    encoder2.writeCompressedU32(this.m_diffuseColorCount, this.m_baseDiffuseColorIndex[i][j]);
                }
                if (this.m_bUseSpecularColor[this.m_baseShadingID[i]]) {
                    encoder2.writeCompressedU32(this.m_specularColorCount, this.m_baseSpecularColorIndex[i][j]);
                }
                for (int k = 0; k < this.m_textureLayerCount[this.m_baseShadingID[i]]; ++k) {
                    encoder2.writeCompressedU32(this.m_textureCoordCount, this.m_baseTextureCoordIndex[i][j][k]);
                }
            }
        }
        encoder2.finalize();
        this.m_compressedData = encoder2.getCompressedData();
    }

    public void write(DataOutputStream dataOutputStream) {
        int n;
        int n2;
        super.write(dataOutputStream);
        int n3 = this.writeString(dataOutputStream, this.m_name);
        this.writeUInt32(dataOutputStream, this.m_chainIndex);
        this.writeUInt32(dataOutputStream, this.m_faceCount);
        this.writeUInt32(dataOutputStream, this.m_positionCount);
        this.writeUInt32(dataOutputStream, this.m_normalCount);
        this.writeUInt32(dataOutputStream, this.m_diffuseColorCount);
        this.writeUInt32(dataOutputStream, this.m_specularColorCount);
        this.writeUInt32(dataOutputStream, this.m_textureCoordCount);
        for (n2 = 0; n2 < this.m_positionCount; ++n2) {
            for (n = 0; n < 3; ++n) {
                this.writeFloat32(dataOutputStream, this.m_basePosition[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.m_normalCount; ++n2) {
            for (n = 0; n < 3; ++n) {
                this.writeFloat32(dataOutputStream, this.m_baseNormal[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.m_diffuseColorCount; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.writeFloat32(dataOutputStream, this.m_diffuseColor[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.m_specularColorCount; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.writeFloat32(dataOutputStream, this.m_specularColor[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.m_textureCoordCount; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.writeFloat32(dataOutputStream, this.m_textureCoord[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.m_compressedData.length; ++n2) {
            this.writeUInt32(dataOutputStream, this.m_compressedData[n2]);
        }
        this.writePaddingBytes(dataOutputStream, n3);
    }
}

