/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import jv.loader.PgAbstractLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jvx.loader.PgU3dSrc;
import jvx.loader.PsU3dBaseMeshContinuationBlock;
import jvx.loader.PsU3dLitTextureShaderBlock;
import jvx.loader.PsU3dMaterialResourceBlock;
import jvx.loader.PsU3dMeshDeclarationBlock;
import jvx.loader.PsU3dModelNodeBlock;
import jvx.loader.PsU3dModifierChainBlock;
import jvx.loader.PsU3dShadingModifierBlock;
import jvx.loader.PsU3dViewNodeBlock;
import jvx.loader.PsU3dViewResourceBlock;

public final class PgU3dLoader
extends PgAbstractLoader {
    private static boolean m_bStoreElementColorsAtVertices = true;
    private static boolean m_bStoreElementColorsInShaders = false;

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        return false;
    }

    public boolean write(DataOutputStream dataOutputStream, PgJvxSrc[] pgJvxSrcArray) {
        if (dataOutputStream == null) {
            PsDebug.warning((String)"missing data output stream writer");
            return false;
        }
        PgU3dSrc pgU3dSrc = new PgU3dSrc();
        PgU3dLoader.addView(pgU3dSrc, (PgLoaderIf)this);
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            if (pgJvxSrcArray[i].getType() != 33) continue;
            PgU3dLoader.addElementSet(pgU3dSrc, pgJvxSrcArray[i], i);
        }
        pgU3dSrc.write(dataOutputStream);
        return true;
    }

    protected static void addView(PgU3dSrc pgU3dSrc, PgLoaderIf pgLoaderIf) {
        PvDisplayOption pvDisplayOption = pgLoaderIf.getDisplayOption();
        PsU3dViewNodeBlock psU3dViewNodeBlock = new PsU3dViewNodeBlock();
        PsU3dViewResourceBlock psU3dViewResourceBlock = new PsU3dViewResourceBlock();
        psU3dViewNodeBlock.m_name = "camera";
        psU3dViewNodeBlock.m_parentNodeCount = 1;
        psU3dViewNodeBlock.m_parentNodeName = new String[]{""};
        PdMatrix pdMatrix = pvDisplayOption.getCameraMatrix(0);
        psU3dViewNodeBlock.m_parentNodeTransform = new float[][][]{new float[][]{{(float)pdMatrix.m_data[0][0], (float)pdMatrix.m_data[0][1], (float)pdMatrix.m_data[0][2], (float)pdMatrix.m_data[0][3]}, {(float)pdMatrix.m_data[1][0], (float)pdMatrix.m_data[1][1], (float)pdMatrix.m_data[1][2], (float)pdMatrix.m_data[1][3]}, {(float)pdMatrix.m_data[2][0], (float)pdMatrix.m_data[2][1], (float)pdMatrix.m_data[2][2], (float)pdMatrix.m_data[2][3]}, {(float)pdMatrix.m_data[3][0], (float)pdMatrix.m_data[3][1], (float)pdMatrix.m_data[3][2], (float)pdMatrix.m_data[3][3]}}};
        psU3dViewNodeBlock.m_resourceName = "cameraResource";
        psU3dViewNodeBlock.m_viewNodeAttributes = 1;
        psU3dViewNodeBlock.m_viewNearClip = (float)pvDisplayOption.getCameraNearClip(0);
        psU3dViewNodeBlock.m_viewFarClip = (float)pvDisplayOption.getCameraFarClip(0);
        psU3dViewNodeBlock.m_viewProjection = (float)pvDisplayOption.getCameraAngle(0);
        psU3dViewNodeBlock.m_viewPortWidth = 1.0f;
        psU3dViewNodeBlock.m_viewPortHeight = 1.0f;
        psU3dViewNodeBlock.m_viewPortVerticalPos = 0.0f;
        psU3dViewNodeBlock.m_viewPortHorizontalPos = 0.0f;
        psU3dViewNodeBlock.m_backdropCount = 0;
        psU3dViewNodeBlock.m_overlayCount = 0;
        psU3dViewResourceBlock.m_name = "cameraResource";
        psU3dViewResourceBlock.m_passCount = 1;
        psU3dViewResourceBlock.m_rootNodeName = new String[]{""};
        psU3dViewResourceBlock.m_renderAttributes = new int[]{0};
        psU3dViewResourceBlock.m_fogMode = new int[]{1};
        psU3dViewResourceBlock.m_fogColorRed = new float[]{0.0f};
        psU3dViewResourceBlock.m_fogColorGreen = new float[]{0.0f};
        psU3dViewResourceBlock.m_fogColorBlue = new float[]{1.0f};
        psU3dViewResourceBlock.m_fogColorAlpha = new float[]{0.5f};
        psU3dViewResourceBlock.m_fogNearValue = new float[]{0.0f};
        psU3dViewResourceBlock.m_fogFarValue = new float[]{1.0f};
        PsU3dModifierChainBlock psU3dModifierChainBlock = new PsU3dModifierChainBlock();
        psU3dModifierChainBlock.m_name = "camera";
        psU3dModifierChainBlock.m_type = 0;
        psU3dModifierChainBlock.m_attributes = 0;
        psU3dModifierChainBlock.setNumModifiers(1);
        psU3dModifierChainBlock.m_modifierDeclaration[0] = psU3dViewNodeBlock;
        pgU3dSrc.m_palette[7].put("cameraNode", psU3dModifierChainBlock);
        pgU3dSrc.m_palette[2].put("cameraResource", psU3dViewResourceBlock);
    }

    public static void storeElementColorsAtVertices(boolean bl) {
        m_bStoreElementColorsAtVertices = bl;
    }

    public static void storeElementColorsInShaders(boolean bl) {
        m_bStoreElementColorsInShaders = bl;
    }

    protected static void addElementSet(PgU3dSrc pgU3dSrc, PgJvxSrc pgJvxSrc, int n) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        boolean bl2 = false;
        if (m_bStoreElementColorsInShaders) {
            bl2 = true;
        }
        int n6 = pgJvxSrc.getNumVertices();
        int n7 = n5 = pgJvxSrc.getNumElements();
        int[] nArray = null;
        if (pgJvxSrc.getDimOfElements() != 3) {
            n7 = 0;
            nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = pgJvxSrc.getElement(i).getSize();
                if (nArray[i] <= 2) continue;
                n7 += nArray[i] - 2;
            }
        }
        String string = "" + n + "-" + pgJvxSrc.getName();
        PsU3dMeshDeclarationBlock psU3dMeshDeclarationBlock = new PsU3dMeshDeclarationBlock();
        PsU3dBaseMeshContinuationBlock psU3dBaseMeshContinuationBlock = new PsU3dBaseMeshContinuationBlock();
        psU3dMeshDeclarationBlock.m_name = string;
        psU3dBaseMeshContinuationBlock.m_name = string;
        if (pgJvxSrc.getVertexNormals() == null) {
            psU3dMeshDeclarationBlock.m_meshAttributes = 1;
            psU3dBaseMeshContinuationBlock.m_bHasVertexNormals = false;
            psU3dMeshDeclarationBlock.m_normalCount = 0;
            psU3dBaseMeshContinuationBlock.m_normalCount = 0;
        } else {
            psU3dMeshDeclarationBlock.m_meshAttributes = 0;
            psU3dBaseMeshContinuationBlock.m_bHasVertexNormals = true;
            psU3dMeshDeclarationBlock.m_normalCount = n6;
            psU3dBaseMeshContinuationBlock.m_normalCount = n6;
        }
        psU3dMeshDeclarationBlock.m_faceCount = n7;
        psU3dBaseMeshContinuationBlock.m_faceCount = n7;
        psU3dMeshDeclarationBlock.m_positionCount = n6;
        psU3dBaseMeshContinuationBlock.m_positionCount = n6;
        boolean bl3 = bl = pgJvxSrc.getElementColors() != null;
        if (m_bStoreElementColorsAtVertices) {
            if (bl) {
                psU3dMeshDeclarationBlock.m_diffuseColorCount = n5;
                psU3dBaseMeshContinuationBlock.m_diffuseColorCount = n5;
            } else {
                psU3dMeshDeclarationBlock.m_diffuseColorCount = 1;
                psU3dBaseMeshContinuationBlock.m_diffuseColorCount = 1;
            }
            psU3dMeshDeclarationBlock.m_specularColorCount = 0;
            psU3dBaseMeshContinuationBlock.m_specularColorCount = 0;
        } else {
            psU3dMeshDeclarationBlock.m_diffuseColorCount = 0;
            psU3dBaseMeshContinuationBlock.m_diffuseColorCount = 0;
            psU3dMeshDeclarationBlock.m_specularColorCount = 0;
            psU3dBaseMeshContinuationBlock.m_specularColorCount = 0;
        }
        psU3dMeshDeclarationBlock.m_textureCoordCount = 0;
        psU3dBaseMeshContinuationBlock.m_textureCoordCount = 0;
        psU3dMeshDeclarationBlock.m_shadingCount = bl2 ? n5 : 1;
        psU3dMeshDeclarationBlock.m_shadingAttributes = m_bStoreElementColorsAtVertices ? new int[]{1} : new int[]{0};
        psU3dMeshDeclarationBlock.m_textureLayerCount = new int[]{0};
        psU3dBaseMeshContinuationBlock.m_textureLayerCount = new int[]{0};
        if (bl2) {
            psU3dMeshDeclarationBlock.m_shadingAttributes = new int[n5];
            psU3dMeshDeclarationBlock.m_textureLayerCount = new int[n5];
            psU3dBaseMeshContinuationBlock.m_textureLayerCount = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                psU3dMeshDeclarationBlock.m_shadingAttributes[n4] = 0;
                psU3dMeshDeclarationBlock.m_textureLayerCount[n4] = 0;
                psU3dBaseMeshContinuationBlock.m_textureLayerCount[n4] = 0;
            }
        }
        psU3dMeshDeclarationBlock.m_originalShadingID = new int[]{0};
        if (bl2) {
            psU3dMeshDeclarationBlock.m_originalShadingID = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                psU3dMeshDeclarationBlock.m_originalShadingID[n4] = n4;
            }
        }
        psU3dMeshDeclarationBlock.m_minimumResolution = n6;
        psU3dMeshDeclarationBlock.m_maximumResolution = n6;
        psU3dMeshDeclarationBlock.m_positionQualityFactor = 1;
        psU3dMeshDeclarationBlock.m_normalQualityFactor = 1;
        psU3dMeshDeclarationBlock.m_textureCoordQualityFactor = 1;
        psU3dMeshDeclarationBlock.m_positionInverseQuant = 1.0f;
        psU3dMeshDeclarationBlock.m_normalInverseQuant = 1.0f;
        psU3dMeshDeclarationBlock.m_textureCoordInverseQuant = 1.0f;
        psU3dMeshDeclarationBlock.m_diffuseColorInverseQuant = 1.0f;
        psU3dMeshDeclarationBlock.m_specularColorInverseQuant = 1.0f;
        psU3dMeshDeclarationBlock.m_normalCreaseParameter = 1.0f;
        psU3dMeshDeclarationBlock.m_normalUpdateParameter = 1.0f;
        psU3dMeshDeclarationBlock.m_normalToleranceParameter = 1.0f;
        psU3dMeshDeclarationBlock.m_boneCount = 0;
        psU3dBaseMeshContinuationBlock.m_basePosition = new float[n6][3];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                psU3dBaseMeshContinuationBlock.m_basePosition[n4][n3] = (float)pgJvxSrc.getVertex((int)n4).m_data[n3];
            }
        }
        if (psU3dBaseMeshContinuationBlock.m_bHasVertexNormals) {
            psU3dBaseMeshContinuationBlock.m_baseNormal = new float[n6][3];
            for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    psU3dBaseMeshContinuationBlock.m_baseNormal[n4][n3] = (float)pgJvxSrc.getVertexNormals()[n4].m_data[n3];
                }
            }
        }
        if (m_bStoreElementColorsAtVertices) {
            if (bl) {
                psU3dBaseMeshContinuationBlock.m_diffuseColor = new float[n5][4];
            } else {
                psU3dBaseMeshContinuationBlock.m_diffuseColor = new float[1][4];
                psU3dBaseMeshContinuationBlock.m_diffuseColor[0] = PgU3dLoader.getRGBA(pgJvxSrc.getGlobalElementColor());
            }
        }
        psU3dBaseMeshContinuationBlock.m_baseShadingID = new int[n7];
        psU3dBaseMeshContinuationBlock.m_basePositionIndex = new int[n7][3];
        if (m_bStoreElementColorsAtVertices) {
            psU3dBaseMeshContinuationBlock.m_baseDiffuseColorIndex = new int[n7][3];
        }
        if (psU3dBaseMeshContinuationBlock.m_bHasVertexNormals) {
            psU3dBaseMeshContinuationBlock.m_baseNormalIndex = new int[n7][3];
        }
        n4 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = nArray == null ? 1 : (nArray[n2] > 2 ? nArray[n2] - 2 : 0);
            if (m_bStoreElementColorsAtVertices && bl) {
                psU3dBaseMeshContinuationBlock.m_diffuseColor[n2] = PgU3dLoader.getRGBA(pgJvxSrc.getElementColors()[n2]);
            }
            for (int i = 0; i < n3; ++i) {
                psU3dBaseMeshContinuationBlock.m_baseShadingID[n4] = bl2 ? n2 : 0;
                psU3dBaseMeshContinuationBlock.m_basePositionIndex[n4][0] = pgJvxSrc.getElement((int)n2).m_data[0];
                if (psU3dBaseMeshContinuationBlock.m_bHasVertexNormals) {
                    psU3dBaseMeshContinuationBlock.m_baseNormalIndex[n4][0] = pgJvxSrc.getElement((int)n2).m_data[0];
                }
                if (m_bStoreElementColorsAtVertices) {
                    psU3dBaseMeshContinuationBlock.m_baseDiffuseColorIndex[n4][0] = bl ? n2 : 0;
                }
                for (int j = 1; j < 3; ++j) {
                    psU3dBaseMeshContinuationBlock.m_basePositionIndex[n4][j] = pgJvxSrc.getElement((int)n2).m_data[j + i];
                    if (psU3dBaseMeshContinuationBlock.m_bHasVertexNormals) {
                        psU3dBaseMeshContinuationBlock.m_baseNormalIndex[n4][j] = pgJvxSrc.getElement((int)n2).m_data[j + i];
                    }
                    if (!m_bStoreElementColorsAtVertices) continue;
                    psU3dBaseMeshContinuationBlock.m_baseDiffuseColorIndex[n4][j] = bl ? n2 : 0;
                }
                ++n4;
            }
        }
        if (m_bStoreElementColorsAtVertices) {
            psU3dBaseMeshContinuationBlock.m_bUseDiffuseColor = new boolean[]{true};
            psU3dBaseMeshContinuationBlock.m_bUseSpecularColor = new boolean[]{false};
        } else {
            psU3dBaseMeshContinuationBlock.m_bUseDiffuseColor = new boolean[]{false};
            psU3dBaseMeshContinuationBlock.m_bUseSpecularColor = new boolean[]{false};
        }
        if (bl2) {
            psU3dBaseMeshContinuationBlock.m_bUseDiffuseColor = new boolean[n5];
            psU3dBaseMeshContinuationBlock.m_bUseSpecularColor = new boolean[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                psU3dBaseMeshContinuationBlock.m_bUseDiffuseColor[n2] = false;
                psU3dBaseMeshContinuationBlock.m_bUseSpecularColor[n2] = false;
            }
        }
        pgU3dSrc.m_palette[0].put("ModelResource-" + string, psU3dBaseMeshContinuationBlock);
        PsU3dModifierChainBlock psU3dModifierChainBlock = new PsU3dModifierChainBlock();
        psU3dModifierChainBlock.setNumModifiers(1);
        psU3dModifierChainBlock.m_type = 1;
        psU3dModifierChainBlock.m_attributes = 0;
        psU3dModifierChainBlock.m_modifierDeclaration[0] = psU3dMeshDeclarationBlock;
        psU3dModifierChainBlock.m_name = string;
        pgU3dSrc.m_palette[7].put("Declaration-" + string, psU3dModifierChainBlock);
        PsU3dModelNodeBlock psU3dModelNodeBlock = new PsU3dModelNodeBlock();
        psU3dModelNodeBlock.setNumParents(1);
        psU3dModelNodeBlock.m_name = string;
        psU3dModelNodeBlock.m_resourceName = string;
        psU3dModelNodeBlock.m_modelVisibility = 3;
        psU3dModelNodeBlock.m_parentNodeName[0] = "";
        psU3dModelNodeBlock.m_parentNodeTransform[0] = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        PsU3dShadingModifierBlock psU3dShadingModifierBlock = new PsU3dShadingModifierBlock();
        psU3dShadingModifierBlock.m_name = string;
        psU3dShadingModifierBlock.m_chainIndex = 1;
        psU3dShadingModifierBlock.m_attributes = 1;
        psU3dShadingModifierBlock.m_shaderListCount = bl2 ? n5 : 1;
        if (m_bStoreElementColorsInShaders) {
            int n8;
            if (bl2) {
                psU3dShadingModifierBlock.m_shaderCount = new int[n5];
                psU3dShadingModifierBlock.m_shaderName = new String[n5][1];
                n8 = n5;
            } else {
                psU3dShadingModifierBlock.m_shaderCount = new int[]{n7};
                psU3dShadingModifierBlock.m_shaderName = new String[1][n7];
                n8 = n7;
            }
            for (int i = 0; i < n8; ++i) {
                if (bl2) {
                    psU3dShadingModifierBlock.m_shaderCount[i] = 1;
                    psU3dShadingModifierBlock.m_shaderName[i][0] = "S" + string + i;
                } else {
                    psU3dShadingModifierBlock.m_shaderName[0][i] = "S" + string + i;
                }
                PsU3dLitTextureShaderBlock psU3dLitTextureShaderBlock = new PsU3dLitTextureShaderBlock();
                psU3dLitTextureShaderBlock.m_attributes = 1;
                psU3dLitTextureShaderBlock.m_name = "S" + string + i;
                psU3dLitTextureShaderBlock.m_materialName = "M" + string + i;
                pgU3dSrc.m_palette[4].put("Shader-" + string + i, psU3dLitTextureShaderBlock);
                PsU3dMaterialResourceBlock psU3dMaterialResourceBlock = new PsU3dMaterialResourceBlock();
                psU3dMaterialResourceBlock.m_name = "M" + string + i;
                psU3dMaterialResourceBlock.m_ambientRed = 0.75f;
                psU3dMaterialResourceBlock.m_ambientGreen = 0.75f;
                psU3dMaterialResourceBlock.m_ambientBlue = 0.75f;
                if (bl2) {
                    psU3dMaterialResourceBlock.m_diffuseRed = PgU3dLoader.getRGBA(pgJvxSrc.getElementColors()[i])[0];
                    psU3dMaterialResourceBlock.m_diffuseGreen = PgU3dLoader.getRGBA(pgJvxSrc.getElementColors()[i])[1];
                    psU3dMaterialResourceBlock.m_diffuseBlue = PgU3dLoader.getRGBA(pgJvxSrc.getElementColors()[i])[2];
                } else if (i < n7 - 1) {
                    psU3dMaterialResourceBlock.m_diffuseRed = 1.0f;
                    psU3dMaterialResourceBlock.m_diffuseGreen = (float)(1.0 * (double)i / ((double)n7 - 2.0));
                    psU3dMaterialResourceBlock.m_diffuseBlue = 0.0f;
                } else {
                    psU3dMaterialResourceBlock.m_diffuseRed = 0.0f;
                    psU3dMaterialResourceBlock.m_diffuseGreen = 0.0f;
                    psU3dMaterialResourceBlock.m_diffuseBlue = 1.0f;
                }
                psU3dMaterialResourceBlock.m_specularRed = 0.0f;
                psU3dMaterialResourceBlock.m_specularGreen = 0.0f;
                psU3dMaterialResourceBlock.m_specularBlue = 0.0f;
                psU3dMaterialResourceBlock.m_emissiveRed = 0.0f;
                psU3dMaterialResourceBlock.m_emissiveGreen = 0.0f;
                psU3dMaterialResourceBlock.m_emissiveBlue = 0.0f;
                psU3dMaterialResourceBlock.m_reflectivity = 0.0f;
                psU3dMaterialResourceBlock.m_opacity = 1.0f;
                pgU3dSrc.m_palette[5].put("Material-" + string + i, psU3dMaterialResourceBlock);
            }
        } else {
            psU3dShadingModifierBlock.m_shaderCount = new int[]{1};
            psU3dShadingModifierBlock.m_shaderName = new String[][]{{"S" + string}};
            PsU3dLitTextureShaderBlock psU3dLitTextureShaderBlock = new PsU3dLitTextureShaderBlock();
            psU3dLitTextureShaderBlock.m_attributes = m_bStoreElementColorsAtVertices ? 5 : 1;
            psU3dLitTextureShaderBlock.m_name = "S" + string;
            psU3dLitTextureShaderBlock.m_materialName = "M" + string;
            pgU3dSrc.m_palette[4].put("Shader-" + string, psU3dLitTextureShaderBlock);
            PsU3dMaterialResourceBlock psU3dMaterialResourceBlock = new PsU3dMaterialResourceBlock();
            psU3dMaterialResourceBlock.m_name = "M" + string;
            psU3dMaterialResourceBlock.m_ambientRed = 0.75f;
            psU3dMaterialResourceBlock.m_ambientGreen = 0.75f;
            psU3dMaterialResourceBlock.m_ambientBlue = 0.75f;
            psU3dMaterialResourceBlock.m_diffuseRed = 1.0f;
            psU3dMaterialResourceBlock.m_diffuseGreen = 1.0f;
            psU3dMaterialResourceBlock.m_diffuseBlue = 1.0f;
            psU3dMaterialResourceBlock.m_specularRed = 0.0f;
            psU3dMaterialResourceBlock.m_specularGreen = 0.0f;
            psU3dMaterialResourceBlock.m_specularBlue = 0.0f;
            psU3dMaterialResourceBlock.m_emissiveRed = 0.0f;
            psU3dMaterialResourceBlock.m_emissiveGreen = 0.0f;
            psU3dMaterialResourceBlock.m_emissiveBlue = 0.0f;
            psU3dMaterialResourceBlock.m_reflectivity = 0.0f;
            psU3dMaterialResourceBlock.m_opacity = 1.0f;
            pgU3dSrc.m_palette[5].put("Material-" + string, psU3dMaterialResourceBlock);
        }
        PsU3dModifierChainBlock psU3dModifierChainBlock2 = new PsU3dModifierChainBlock();
        psU3dModifierChainBlock2.setNumModifiers(2);
        psU3dModifierChainBlock2.m_type = 0;
        psU3dModifierChainBlock2.m_attributes = 0;
        psU3dModifierChainBlock2.m_modifierDeclaration[0] = psU3dModelNodeBlock;
        psU3dModifierChainBlock2.m_modifierDeclaration[1] = psU3dShadingModifierBlock;
        psU3dModifierChainBlock2.m_name = string;
        pgU3dSrc.m_palette[7].put("ModelNode+Shader-" + string, psU3dModifierChainBlock2);
    }

    private static float[] getRGBA(Color color) {
        float[] fArray = new float[]{(float)(1.0 * (double)color.getRed() / 255.0), (float)(1.0 * (double)color.getGreen() / 255.0), (float)(1.0 * (double)color.getBlue() / 255.0), 1.0f};
        return fArray;
    }
}

