/*
 * Decompiled with CFR 0.152.
 */
package jvx.imageDisplay;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public abstract class PiImageSource
extends PsObject {
    protected Image m_image;
    protected int m_imageHeight;
    protected int m_imageWidth;
    protected PuInteger m_blockSize;
    protected PiVector m_pix;
    private MemoryImageSource m_mis;
    protected PdVector m_domainBounds;
    protected PdVector m_currentPosition;
    static /* synthetic */ Class class$jvx$imageDisplay$PiImageSource;

    public PiImageSource() {
        this.setName("Image Source");
        this.m_pix = new PiVector();
        this.m_blockSize = new PuInteger("Block Size", (PsUpdateIf)this);
        this.m_domainBounds = new PdVector(-1.0, -1.0, 1.0, 1.0);
        this.m_currentPosition = new PdVector(0.0, 0.0);
        if (((Object)((Object)this)).getClass() == (class$jvx$imageDisplay$PiImageSource == null ? (class$jvx$imageDisplay$PiImageSource = PiImageSource.class$("jvx.imageDisplay.PiImageSource")) : class$jvx$imageDisplay$PiImageSource)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pix.setSize(0);
        this.m_imageWidth = 0;
        this.m_imageHeight = 0;
        this.m_image = null;
        this.m_blockSize.setDefBounds(1, 10, 1, 2);
        this.m_blockSize.setDefValue(1);
        this.m_blockSize.init();
    }

    public boolean update(Object object) {
        if (object == this.m_blockSize) {
            this.compute();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    protected boolean setImageSize(int n, int n2) {
        if (n <= 0 || n2 <= 0 || n == this.m_imageWidth && n2 == this.m_imageHeight) {
            return false;
        }
        this.m_imageWidth = n;
        this.m_imageHeight = n2;
        this.m_pix.setSize(this.m_imageWidth * this.m_imageHeight);
        return true;
    }

    public Image getImage() {
        return this.m_image;
    }

    public Image createImage(Component component, int n, int n2) {
        if (!this.setImageSize(n, n2)) {
            return this.m_image;
        }
        this.m_mis = new MemoryImageSource(this.m_imageWidth, this.m_imageHeight, this.m_pix.m_data, 0, this.m_imageWidth);
        this.m_mis.setAnimated(true);
        this.m_image = component != null ? component.createImage(this.m_mis) : Toolkit.getDefaultToolkit().createImage(this.m_mis);
        return this.m_image;
    }

    protected void refreshImage() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        this.m_mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
    }

    public abstract void compute();

    public void computeColors() {
        this.refreshImage();
    }

    public int getImagePosition(double d, double d2) {
        double d3 = this.m_domainBounds.m_data[0];
        double d4 = this.m_domainBounds.m_data[2];
        double d5 = this.m_domainBounds.m_data[1];
        double d6 = this.m_domainBounds.m_data[3];
        if (d < d3 || d > d4 || d2 < d5 || d2 > d6) {
            return -1;
        }
        double d7 = d6 - d5;
        int n = (int)((double)(this.m_imageHeight - 1) * (d2 - d5) / d7 + 0.5);
        double d8 = d4 - d3;
        int n2 = (int)((double)(this.m_imageWidth - 1) * (d - d3) / d8 + 0.5);
        int n3 = n * this.m_imageWidth + n2;
        if (n3 < 0 || n3 >= this.m_pix.m_data.length) {
            return -1;
        }
        return n3;
    }

    public PdVector getDomainPosition(Point point) {
        double d = this.m_domainBounds.m_data[0];
        double d2 = this.m_domainBounds.m_data[2];
        double d3 = this.m_domainBounds.m_data[1];
        double d4 = this.m_domainBounds.m_data[3];
        double d5 = d2 - d;
        double d6 = d4 - d3;
        double d7 = d + d5 * (double)point.x / ((double)this.m_imageWidth - 1.0);
        double d8 = d3 + d6 * (double)point.y / ((double)this.m_imageHeight - 1.0);
        return new PdVector(d7, d8);
    }

    public PdVector getDomainBounds() {
        return this.m_domainBounds;
    }

    public void setDomainBounds(PdVector pdVector) {
        if (pdVector == null || pdVector.getSize() != 4) {
            PsDebug.warning((String)"missing domain bounds vector or size != 4.");
        }
        this.m_domainBounds.copy(pdVector);
    }

    public void setDomainBounds(double[] dArray) {
        if (dArray == null || dArray.length != 4) {
            PsDebug.warning((String)"missing domain bounds vector or size != 4.");
        }
        this.m_domainBounds.set(dArray);
    }

    public void setDomainBounds(double d, double d2, double d3, double d4) {
        this.m_domainBounds.set(d, d2, d3, d4);
    }

    public int getBlockSize() {
        return this.m_blockSize.getValue();
    }

    public void setBlockSize(int n) {
        this.m_blockSize.setValue(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

