/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jvx.gui.PuHistogram;

public final class PuHistogram_IP
extends PsPanel
implements ItemListener {
    protected PuHistogram m_histogram;
    protected PuHistogramCanvas m_pHistogram;
    protected Choice m_cClassType;
    protected Choice m_cCountType;
    protected Checkbox m_cSampleBnd;
    protected Checkbox m_cShowTitle;
    protected Checkbox m_cShowLabels;
    protected Checkbox m_cShowTicks;
    protected Checkbox m_cShowCounts;
    private Panel m_pSlider;
    private PdVector_IP m_pXMinMax;
    private PdVector m_xMinMax;
    private PdVector_IP m_pYMinMax;
    private PdVector m_yMinMax;
    static /* synthetic */ Class class$jvx$gui$PuHistogram_IP;

    public PuHistogram_IP() {
        if (this.getClass() == (class$jvx$gui$PuHistogram_IP == null ? (class$jvx$gui$PuHistogram_IP = PuHistogram_IP.class$("jvx.gui.PuHistogram_IP")) : class$jvx$gui$PuHistogram_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.m_pHistogram = new PuHistogramCanvas();
        ((Container)((Object)this)).add(this.m_pHistogram, "Center");
        this.m_pSlider = new Panel(new GridLayout(4, 1));
        Panel panel = new Panel(new GridLayout(1, 5));
        this.m_cSampleBnd = new Checkbox("Use Bounds");
        this.m_cSampleBnd.addItemListener(this);
        panel.add(this.m_cSampleBnd);
        this.m_cShowTitle = new Checkbox("Show Title");
        this.m_cShowTitle.addItemListener(this);
        panel.add(this.m_cShowTitle);
        this.m_cShowLabels = new Checkbox("Axis Labels");
        this.m_cShowLabels.addItemListener(this);
        panel.add(this.m_cShowLabels);
        this.m_cShowTicks = new Checkbox("Axis Ticks");
        this.m_cShowTicks.addItemListener(this);
        panel.add(this.m_cShowTicks);
        this.m_cShowCounts = new Checkbox("Bin Counts");
        this.m_cShowCounts.addItemListener(this);
        panel.add(this.m_cShowCounts);
        this.m_pSlider.add(panel);
        this.m_pXMinMax = new PdVector_IP();
        this.m_pXMinMax.setTitle("Bounds of Samples");
        this.m_pXMinMax.setParent((PsUpdateIf)this);
        this.m_xMinMax = new PdVector(2);
        this.m_pXMinMax.setVector(this.m_xMinMax);
        this.m_pSlider.add((Component)this.m_pXMinMax);
        this.m_pYMinMax = new PdVector_IP();
        this.m_pYMinMax.setTitle("Bounds of Counts");
        this.m_pYMinMax.setParent((PsUpdateIf)this);
        this.m_yMinMax = new PdVector(2);
        this.m_pYMinMax.setVector(this.m_yMinMax);
        Panel panel2 = new Panel(new GridLayout(1, 4));
        panel2.add(new Label("Number of Bins"));
        this.m_cClassType = new Choice();
        this.m_cClassType.addItemListener(this);
        this.m_cClassType.add("Manual");
        this.m_cClassType.add("Sturges' rule");
        panel2.add(this.m_cClassType);
        panel2.add(new Label("Counting"));
        this.m_cCountType = new Choice();
        this.m_cCountType.addItemListener(this);
        this.m_cCountType.add("Absolute");
        this.m_cCountType.add("Relative");
        panel2.add(this.m_cCountType);
        this.m_pSlider.add(panel2);
        ((Container)((Object)this)).add(this.m_pSlider, "South");
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_histogram = (PuHistogram)psUpdateIf;
        String string = this.m_histogram.getName();
        String string2 = this.m_histogram.getSymbol();
        if (string2 != null) {
            string = string + " (" + string2 + ")";
        }
        this.setTitle(string);
        this.m_pSlider.add((Component)this.m_histogram.m_numBins.getInfoPanel());
        this.m_pSlider.validate();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_histogram == null) {
            PsDebug.warning((String)"missing double");
            return true;
        }
        if (object == this.m_histogram) {
            boolean bl = this.m_histogram.isEnabledSampleBnd();
            PsPanel.setState((Checkbox)this.m_cSampleBnd, (boolean)bl);
            PsPanel.setEnabled((Component)this.m_pXMinMax, (boolean)bl);
            PsPanel.setState((Checkbox)this.m_cShowTitle, (boolean)this.m_histogram.isEnabledShowTitle());
            PsPanel.setState((Checkbox)this.m_cShowLabels, (boolean)this.m_histogram.isEnabledShowAxisLabels());
            PsPanel.setState((Checkbox)this.m_cShowTicks, (boolean)this.m_histogram.isEnabledShowAxisTicks());
            PsPanel.setState((Checkbox)this.m_cShowCounts, (boolean)this.m_histogram.isEnabledShowCounts());
            if (this.m_histogram.m_bUseSampleBnd) {
                this.m_xMinMax.copy(this.m_histogram.m_sampleBnd);
            } else {
                this.m_xMinMax.set(this.m_histogram.m_sampleMin, this.m_histogram.m_sampleMax);
            }
            this.m_pXMinMax.update((Object)this.m_xMinMax);
            if (this.m_histogram.m_bUseCountBnd) {
                this.m_yMinMax.copy(this.m_histogram.m_countBnd);
            } else {
                this.m_yMinMax.set(this.m_histogram.m_countMin, this.m_histogram.m_countMax);
            }
            this.m_pYMinMax.update((Object)this.m_yMinMax);
            if (((Component)((Object)this)).isEnabled() != this.m_histogram.m_enabled) {
                ((Component)((Object)this)).setEnabled(this.m_histogram.m_enabled);
            }
            this.m_pHistogram.repaint();
            return true;
        }
        if (object == this.m_pXMinMax) {
            this.m_histogram.setSampleBnd(this.m_xMinMax.getEntry(0), this.m_xMinMax.getEntry(1));
            return this.m_histogram.update((Object)this.m_histogram);
        }
        if (object == this.m_pYMinMax) {
            this.m_histogram.m_countMin = this.m_yMinMax.getEntry(0);
            this.m_histogram.m_countMax = this.m_yMinMax.getEntry(1);
            return this.m_histogram.update((Object)this.m_histogram);
        }
        return super.update(object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cClassType) {
            this.m_histogram.setClassType(this.m_cClassType.getSelectedIndex());
        } else if (object == this.m_cCountType) {
            this.m_histogram.setCountType(this.m_cCountType.getSelectedIndex());
        } else if (object == this.m_cSampleBnd) {
            this.m_histogram.setEnabledSampleBnd(this.m_cSampleBnd.getState());
        } else if (object == this.m_cShowTitle) {
            this.m_histogram.setEnabledShowTitle(this.m_cShowTitle.getState());
        } else if (object == this.m_cShowLabels) {
            this.m_histogram.setEnabledShowAxisLabels(this.m_cShowLabels.getState());
        } else if (object == this.m_cShowTicks) {
            this.m_histogram.setEnabledShowAxisTicks(this.m_cShowTicks.getState());
        } else if (object == this.m_cShowCounts) {
            this.m_histogram.setEnabledShowCounts(this.m_cShowCounts.getState());
        } else {
            return;
        }
        this.m_histogram.update((Object)this.m_histogram);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class PuHistogramCanvas
    extends Canvas {
        protected final int PREF_WIDTH = 400;
        protected final int PREF_HEIGHT = 300;

        protected PuHistogramCanvas() {
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            super.paint(graphics);
            int n5 = PsConfig.getMonitorScale();
            Dimension dimension = super.getSize();
            int n6 = dimension.width;
            int n7 = dimension.height;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n6 - 1, n7 - 1);
            graphics.setColor(Color.black);
            if (PuHistogram_IP.this.m_histogram.m_bShowBorder) {
                graphics.drawRect(0, 0, n6 - 1, n7 - 1);
            }
            if (PuHistogram_IP.this.m_histogram == null) {
                return;
            }
            int[] nArray = PuHistogram_IP.this.m_histogram.m_margins;
            double[] dArray = PuHistogram_IP.this.m_histogram.m_binCount;
            double d = PuHistogram_IP.this.m_histogram.m_sampleMin;
            double d2 = PuHistogram_IP.this.m_histogram.m_sampleMax;
            double d3 = PuHistogram_IP.this.m_histogram.m_countMax;
            int n8 = n7;
            int n9 = 0;
            int n10 = nArray[0] * n5;
            int n11 = nArray[1] * n5;
            int n12 = nArray[2] * n5;
            int n13 = nArray[3] * n5;
            graphics.setFont(PuHistogram.DEFAULT_FONT_LABELS);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n14 = PuHistogram_IP.this.m_histogram.m_samples.getSize();
            if (n14 == 0) {
                String string = "missing samples";
                graphics.setFont(PuHistogram.DEFAULT_FONT_TITLE);
                int n15 = fontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n6 / 2 - n15, n7 / 2);
                return;
            }
            int n16 = PuHistogram_IP.this.m_histogram.getNumBins();
            if (n16 == 0) {
                return;
            }
            double d4 = (double)(n6 - n11 - n13) / (double)n16;
            double d5 = (double)(n7 - n12 - n10) / d3;
            graphics.drawLine(n9 + n11, n8 - n10, n6 - n13, n8 - n10);
            graphics.drawLine(n9 + n11, n8 - n10, n9 + n11, n12);
            if (PuHistogram_IP.this.m_histogram.isEnabledShowAxisTicks()) {
                n4 = 5;
                double d6 = d3 / (double)(n4 - 1);
                if (PuHistogram_IP.this.m_histogram.getCountType() == 0) {
                    d6 = (int)Math.floor((d3 + (double)n4 - 2.0) / (double)(n4 - 1));
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = (int)((double)(n3 * (n8 - n10 - n12)) / ((double)n4 - 1.0));
                    graphics.drawLine(n9 + n11 - 2 * n5, n8 - n10 - n2, n9 + n11, n8 - n10 - n2);
                    String string = PuString.toString((double)((double)n3 * d6), (int)2);
                    int n17 = fontMetrics.stringWidth(string);
                    graphics.drawString(string, n9 + n11 - n17 - 4 * n5, n8 - n10 - n2 + 3 * n5);
                    int n18 = (int)((double)(n3 * (n6 - n11 - n13)) / ((double)n4 - 1.0));
                    graphics.drawLine(n9 + n11 + n18, n8 - n10, n9 + n11 + n18, n8 - n10 + 5 * n5);
                    String string2 = PuString.toString((double)(d + (double)n3 * (d2 - d) / (double)(n4 - 1)), (int)2);
                    n = fontMetrics.stringWidth(string2) / 2;
                    graphics.drawString(string2, n9 + n11 + n18 - n, n8 - n10 + 15 * n5);
                }
            }
            int n19 = n9 + n11;
            for (int i = 0; i < n16; ++i) {
                n3 = (int)((double)(i + 1) * d4 + (double)n9 + (double)n11);
                n2 = n12 + (int)((d3 - dArray[i]) * d5);
                int n20 = n8 - n10 - n2;
                if (n20 > 1) {
                    graphics.setColor(PuHistogram_IP.this.m_histogram.m_fillColor);
                    graphics.fillRect(n19, n2, n3 - n19, n20);
                    graphics.setColor(Color.black);
                    graphics.drawRect(n19, n2, n3 - n19, n20);
                }
                if (PuHistogram_IP.this.m_histogram.isEnabledShowCounts() && (dArray[i] > 0.0 || PuHistogram_IP.this.m_histogram.m_bShowZeroCounts)) {
                    String string = PuString.toString((double)dArray[i], (int)2);
                    n4 = fontMetrics.stringWidth(string);
                    graphics.drawString(string, n19 + (int)((d4 - (double)n4) / 2.0), n2 - 1 * n5);
                }
                n19 = n3;
            }
            graphics.setFont(PuHistogram.DEFAULT_FONT_LABELS);
            fontMetrics = graphics.getFontMetrics();
            if (PuHistogram_IP.this.m_histogram.isEnabledShowAxisLabels()) {
                String string = PuHistogram_IP.this.m_histogram.m_xLabel;
                if (string == null) {
                    string = "missing x-label";
                }
                n3 = fontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n11 + (n6 - n11 - n13) / 2 - n3, n8 - 8 * n5);
            }
            if (PuHistogram_IP.this.m_histogram.isEnabledShowAxisLabels()) {
                String string = PuHistogram_IP.this.m_histogram.m_yLabel;
                if (string == null) {
                    string = "missing y-label";
                }
                n3 = 3 * fontMetrics.getHeight() / 4;
                n2 = string.length();
                int n21 = n2 * n3 / 2;
                int n22 = (n8 - n10 + n12) / 2;
                char[] cArray = new char[1];
                for (int i = 0; i < n2; ++i) {
                    cArray[0] = n = string.charAt(i);
                    String string3 = new String(cArray);
                    int n23 = fontMetrics.stringWidth(string3) / 2;
                    graphics.drawString(string3, 12 * n5 - n23, n22 - n21 + i * n3);
                }
            }
            if (PuHistogram_IP.this.m_histogram.isEnabledShowTitle()) {
                String string = PuHistogram_IP.this.m_histogram.m_title;
                if (string == null) {
                    string = "missing title";
                }
                graphics.setFont(PuHistogram.DEFAULT_FONT_TITLE);
                n3 = fontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n11 + (n6 - n11 - n13) / 2 - n3, n12 - 15 * n5);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

