/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwModel;
import jvx.project.PjWorkshop;

public class PwExplode
extends PjWorkshop
implements PsTimeListenerIf {
    public PsAnimation m_anim = new PsAnimation();
    private PdVector[] m_expDirection;
    private PdVector[] m_elCenter;
    private PdVector[] m_direction1;
    private PdVector[] m_direction2;
    private PdVector[] m_rotationAxis;
    private PdVector[] m_relCoord;
    private PdVector m_initialSpeed;
    private PdVector m_rotation;
    private double m_speed;
    private double m_gravity = 0.00981;
    private double m_rotationSpeed;
    private double m_normalAberration = 0.05;
    private double m_geomSize;
    private double m_insideTime = 50.0;

    public PwExplode() {
        super(PsConfig.getMessage((int)48016));
        this.m_anim.setName(PsConfig.getMessage((int)48003));
        this.m_anim.setRepeat(0);
        this.m_anim.setSpeedType(0);
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 50.0, 1.0, 5.0);
    }

    public void reset() {
        PdVector pdVector;
        PdMatrix pdMatrix;
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_geomSize = this.m_geom.getDiameter();
        this.m_speed = 0.2 * this.m_geomSize;
        this.m_gravity = 0.00981;
        PvDisplay pvDisplay = (PvDisplay)this.getDisplay();
        if (pvDisplay != null) {
            pdMatrix = new PdMatrix(4);
            pdMatrix = pvDisplay.getTransMatrix(128);
            PdVector pdVector2 = new PdVector(0.0, -1.0, 0.0, 0.0);
            pdVector2.leftMultMatrix(pdMatrix);
            pdVector = new PdVector(pdVector2.m_data[0], pdVector2.m_data[1], pdVector2.m_data[2]);
            double d = 10.0 * pdVector.length();
            double d2 = this.m_speed / (this.m_gravity * this.m_geomSize);
            this.m_insideTime = d2 + Math.sqrt(d2 * d2 + 2.0 * d / (this.m_gravity * this.m_geomSize));
        }
        this.m_rotationSpeed = 0.5;
        pdMatrix = (PgElementSet)this.m_geom;
        pdMatrix.showBoundaries(false);
        PwModel.shrink((PgElementSet)pdMatrix, 1.0);
        pdMatrix.makeElementNormals();
        int n = pdMatrix.getNumElements();
        this.m_expDirection = new PdVector[n];
        pdVector = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            do {
                pdVector.m_data[0] = Math.random();
                pdVector.m_data[1] = Math.random();
                pdVector.m_data[2] = Math.random();
            } while (pdVector.sqrLength() < 0.01);
            pdVector.normalize();
            this.m_expDirection[i] = PdVector.blendNew((double)(1.0 - this.m_normalAberration), (PdVector)pdMatrix.getElementNormal(i), (double)this.m_normalAberration, (PdVector)pdVector);
        }
        this.m_elCenter = new PdVector[n];
        this.m_initialSpeed = new PdVector(n);
        this.m_rotation = new PdVector(n);
        this.m_rotationAxis = new PdVector[n];
        this.m_direction1 = new PdVector[n];
        this.m_direction2 = new PdVector[n];
        this.m_relCoord = new PdVector[pdMatrix.getNumVertices()];
        PdVector pdVector3 = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            int n2;
            this.m_initialSpeed.m_data[i] = Math.random() * this.m_speed;
            this.m_rotation.m_data[i] = Math.random() * this.m_rotationSpeed;
            this.m_elCenter[i] = new PdVector(3);
            this.m_elCenter[i].setConstant(0.0);
            PiVector piVector = pdMatrix.getElement(i);
            for (n2 = 0; n2 < piVector.getSize(); ++n2) {
                this.m_elCenter[i].add(pdMatrix.getVertex(piVector.m_data[n2]));
            }
            this.m_elCenter[i].multScalar(1.0 / (double)piVector.getSize());
            this.m_rotationAxis[i] = new PdVector(3);
            do {
                this.m_rotationAxis[i].m_data[0] = Math.random();
                this.m_rotationAxis[i].m_data[1] = Math.random();
                this.m_rotationAxis[i].m_data[2] = Math.random();
            } while (this.m_rotationAxis[i].sqrLength() < 0.01);
            this.m_rotationAxis[i].normalize();
            this.m_direction1[i] = PdVector.normalToVectorNew((PdVector)this.m_rotationAxis[i]);
            this.m_direction2[i] = PdVector.crossNew((PdVector)this.m_rotationAxis[i], (PdVector)this.m_direction1[i]);
            for (n2 = 0; n2 < piVector.getSize(); ++n2) {
                int n3 = piVector.m_data[n2];
                pdVector3 = PdVector.subNew((PdVector)pdMatrix.getVertex(n3), (PdVector)this.m_elCenter[i]);
                this.m_relCoord[n3] = new PdVector(3);
                this.m_relCoord[n3].m_data[0] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_rotationAxis[i]);
                this.m_relCoord[n3].m_data[1] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_direction1[i]);
                this.m_relCoord[n3].m_data[2] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_direction2[i]);
            }
        }
    }

    public boolean hasAnimation() {
        return true;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setSpeed(double d) {
        this.m_speed = d;
    }

    public double getSpeed() {
        return this.m_speed;
    }

    public void setGravity(double d) {
        this.m_gravity = d;
    }

    public double getGravity() {
        return this.m_gravity;
    }

    public void setRotationSpeed(double d) {
        this.m_rotationSpeed = d;
    }

    public double getRotationSpeed() {
        return this.m_rotationSpeed;
    }

    public String getName() {
        return PsConfig.getMessage((int)48004);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        return this.setTime(psTimeEvent.getTime());
    }

    public boolean setTime(double d) {
        d *= this.m_insideTime / 50.0;
        PvDisplay pvDisplay = (PvDisplay)this.getDisplay();
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix = pvDisplay.getTransMatrix(128);
        PdVector pdVector = new PdVector(0.0, -1.0, 0.0, 0.0);
        pdVector.leftMultMatrix(pdMatrix);
        PdVector pdVector2 = new PdVector(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
        pdVector2.normalize();
        pdVector2.multScalar(this.m_geomSize);
        int n = 3;
        PdVector pdVector3 = new PdVector(n);
        PdVector pdVector4 = new PdVector(n);
        int n2 = ((PgElementSet)this.m_geom).getNumElements();
        for (int i = 0; i < n2; ++i) {
            pdVector4.blendBase(this.m_elCenter[i], d * this.m_initialSpeed.m_data[i], this.m_expDirection[i]);
            pdVector4.blendBase(pdVector4, d * d * this.m_gravity / 2.0, pdVector2);
            PiVector piVector = this.m_geom.getElement(i);
            int n3 = piVector.getSize();
            double d2 = this.m_rotation.m_data[i] * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            for (int j = 0; j < n3; ++j) {
                int n4 = piVector.m_data[j];
                pdVector3.blendBase(pdVector4, this.m_relCoord[n4].m_data[0], this.m_rotationAxis[i]);
                pdVector3.blendBase(pdVector3, d3 * this.m_relCoord[n4].m_data[1] - d4 * this.m_relCoord[n4].m_data[2], this.m_direction1[i]);
                pdVector3.blendBase(pdVector3, d4 * this.m_relCoord[n4].m_data[1] + d3 * this.m_relCoord[n4].m_data[2], this.m_direction2[i]);
                this.m_geom.setVertex(n4, pdVector3);
            }
        }
        return this.m_geom.update((Object)this.m_geom);
    }

    public void cancel() {
        this.m_anim.stop();
        super.cancel();
    }

    public void close() {
        this.m_anim.stop();
        this.m_anim.removeTimeListener((PsTimeListenerIf)this);
        super.close();
    }
}

