/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PiVector;

public class PgPointSetOnElementSet
extends PgPointSet {
    protected PgElementSet m_geom;
    protected static final int m_dimOfElements = 3;
    protected PdBary[] m_vertexBary;
    static /* synthetic */ Class class$jvx$geom$PgPointSetOnElementSet;

    public PgPointSetOnElementSet(PgElementSet pgElementSet) {
        super(pgElementSet.getDimOfVertices());
        this.m_geom = pgElementSet;
        this.m_vertexBary = new PdBary[0];
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgPointSetOnElementSet == null ? (class$jvx$geom$PgPointSetOnElementSet = PgPointSetOnElementSet.class$("jvx.geom.PgPointSetOnElementSet")) : class$jvx$geom$PgPointSetOnElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return;
        }
        this.m_geom = pgElementSet;
    }

    public Object clone() {
        PgPointSetOnElementSet pgPointSetOnElementSet = (PgPointSetOnElementSet)((Object)super.clone());
        if (pgPointSetOnElementSet == null) {
            return null;
        }
        if (this.m_geom != null) {
            pgPointSetOnElementSet.setGeometry(this.m_geom);
        }
        if (this.m_vertexBary != null) {
            pgPointSetOnElementSet.m_vertexBary = (PdBary[])P_Vector.clone((P_Vector[])this.m_vertexBary);
        }
        return pgPointSetOnElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPointSetOnElementSet)) {
            return;
        }
        PgPointSetOnElementSet pgPointSetOnElementSet = (PgPointSetOnElementSet)psObject;
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pgPointSetOnElementSet.getVertexBary(), (int)0, (int)this.m_numVertices);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPointSetOnElementSet)) {
            return false;
        }
        PgPointSetOnElementSet pgPointSetOnElementSet = (PgPointSetOnElementSet)pgGeometryIf;
        if (pgPointSetOnElementSet.m_geom != this.m_geom) {
            return false;
        }
        int n2 = pgPointSetOnElementSet.getNumVertices();
        PdBary.copy((PdBary[])this.m_vertexBary, (int)n, (PdBary[])pgPointSetOnElementSet.m_vertexBary, (int)0, (int)n2);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPointSetOnElementSet) || !(pgGeometry2 instanceof PgPointSetOnElementSet)) {
            return false;
        }
        PgPointSetOnElementSet pgPointSetOnElementSet = (PgPointSetOnElementSet)pgGeometry;
        PgPointSetOnElementSet pgPointSetOnElementSet2 = (PgPointSetOnElementSet)pgGeometry2;
        int n = pgPointSetOnElementSet.getNumVertices();
        for (int i = 0; i < n; ++i) {
            pgPointSetOnElementSet.m_vertexBary[i].blend(d, pgPointSetOnElementSet.m_vertexBary[i], d2, pgPointSetOnElementSet2.m_vertexBary[i]);
        }
        return true;
    }

    public void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        if (this.isEnabledInstanceSharing()) {
            return;
        }
        this.m_vertexBary = PdBary.realloc((PdBary[])this.m_vertexBary, (int)n, (int)3);
    }

    public PdBary[] getVertexBary() {
        return this.m_vertexBary;
    }

    public void setVertexBary(PdBary[] pdBaryArray) {
        if ((pdBaryArray == null || pdBaryArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdBaryArray == null || pdBaryArray.length == 0 || pdBaryArray.length < this.m_numVertices) {
            PsDebug.warning((String)"void length of argument vertexBary array");
            return;
        }
        if (pdBaryArray[0] == null || this.m_geom != null && pdBaryArray[0].getSize() != this.m_geom.getDimOfElements()) {
            PsDebug.warning((String)"wrong dimension at least of first argument vertexBary.");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_vertexBary = pdBaryArray;
            return;
        }
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pdBaryArray, (int)0, (int)this.m_numVertices);
    }

    public PdBary getVertexBary(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return null;
        }
        return this.m_vertexBary[n];
    }

    public int getVertexElemInd(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_vertexBary[n].m_elementInd;
    }

    public void setVertexBary(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return;
        }
        if (n2 < 0 || this.m_geom != null && n2 >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
            return;
        }
        if (this.m_geom != null) {
            PiVector piVector = this.m_geom.getElement(n2);
            pdBary.getVertex(this.m_vertex[n], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
        this.m_vertexBary[n].copy(pdBary);
        this.m_vertexBary[n].setElementInd(n2);
    }

    public void setVertexBary(int n, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        this.setVertexBary(n, pdBary.getElementInd(), pdBary);
    }

    public void computeVertices() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (this.m_numVertices == 0) {
            return;
        }
        for (int i = 0; i < this.m_numVertices; ++i) {
            int n = this.m_vertexBary[i].getElementInd();
            if (n == -1) {
                PsDebug.warning((String)("Missing element index in vertexBary[" + i + "]"));
                return;
            }
            PiVector piVector = this.m_geom.getElement(n);
            this.m_vertexBary[i].getVertex(this.m_vertex[i], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

