/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwSmoothPolySet
extends PjWorkshop
implements Runnable {
    protected PgPolygonSet m_polySet;
    protected PuDouble m_weightRepell;
    protected PuDouble m_weightAttract;
    protected PuDouble m_weightUnify;
    protected PuDouble m_weightStraight;
    protected PuDouble m_weightStraightEnd;
    protected PuDouble m_weightStarSpring;
    protected PuDouble m_weightSmooth;
    protected boolean m_bKeepSelected = true;
    protected PiVector[] m_nodeStar;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwSmoothPolySet() {
        super(PsConfig.getMessage((boolean)true, (int)54000, (String)"Smooth PolygonSet"));
        double repell = 1.0;
        double attract = 1.0;
        double unify = 1.0;
        double straighten = 0.0;
        double straightenEnd = 0.0;
        double starSpring = 1.0;
        double smooth = 0.1;
        this.m_weightRepell = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Repell All"));
        this.m_weightRepell.addUpdateListener((PsUpdateIf)this);
        this.m_weightRepell.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightRepell.setDefValue(repell);
        this.m_weightRepell.init();
        this.m_weightRepell.setValue(repell);
        this.m_weightAttract = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Attract Neighbour"));
        this.m_weightAttract.addUpdateListener((PsUpdateIf)this);
        this.m_weightAttract.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightAttract.setDefValue(attract);
        this.m_weightAttract.init();
        this.m_weightAttract.setValue(attract);
        this.m_weightUnify = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Unify Edge Length"));
        this.m_weightUnify.addUpdateListener((PsUpdateIf)this);
        this.m_weightUnify.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightUnify.setDefValue(unify);
        this.m_weightUnify.init();
        this.m_weightUnify.setValue(unify);
        this.m_weightStraight = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Straighten Polygons"));
        this.m_weightStraight.addUpdateListener((PsUpdateIf)this);
        this.m_weightStraight.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStraight.setDefValue(straighten);
        this.m_weightStraight.init();
        this.m_weightStraight.setValue(straighten);
        this.m_weightStraightEnd = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Straighten Polygon Ends"));
        this.m_weightStraightEnd.addUpdateListener((PsUpdateIf)this);
        this.m_weightStraightEnd.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStraightEnd.setDefValue(straightenEnd);
        this.m_weightStraightEnd.init();
        this.m_weightStraightEnd.setValue(straightenEnd);
        this.m_weightStarSpring = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Planar Star Springs"));
        this.m_weightStarSpring.addUpdateListener((PsUpdateIf)this);
        this.m_weightStarSpring.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStarSpring.setDefValue(starSpring);
        this.m_weightStarSpring.init();
        this.m_weightStarSpring.setValue(starSpring);
        this.m_weightSmooth = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Step Size"));
        this.m_weightSmooth.addUpdateListener((PsUpdateIf)this);
        this.m_weightSmooth.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_weightSmooth.setDefValue(smooth);
        this.m_weightSmooth.init();
        this.m_weightSmooth.setValue(smooth);
        if (this.getClass() == PwSmoothPolySet.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgPolygonSet geom) {
        super.setGeometry((PgGeometry)geom);
        this.m_polySet = geom;
        this.computeNodeStars();
    }

    protected void computeNodeStars() {
        int nov = this.m_polySet.getNumVertices();
        int nop = this.m_polySet.getNumPolygons();
        PiVector valence = new PiVector(nov);
        PiVector nodeIndex = new PiVector(nov);
        nodeIndex.setConstant(-1);
        int numNodes = 0;
        int i = 0;
        while (i < nop) {
            PiVector poly = this.m_polySet.getPolygon(i);
            int polySize = poly.getSize();
            int j = 0;
            while (j < polySize - 1) {
                int n = poly.m_data[j];
                valence.m_data[n] = valence.m_data[n] + 1;
                if (valence.m_data[poly.m_data[j]] == 3) {
                    nodeIndex.m_data[poly.m_data[j]] = numNodes++;
                }
                int n2 = poly.m_data[j + 1];
                valence.m_data[n2] = valence.m_data[n2] + 1;
                if (valence.m_data[poly.m_data[j + 1]] == 3) {
                    nodeIndex.m_data[poly.m_data[j + 1]] = numNodes++;
                }
                ++j;
            }
            ++i;
        }
        this.m_nodeStar = new PiVector[numNodes];
        i = 0;
        while (i < nov) {
            if (nodeIndex.m_data[i] != -1) {
                this.m_nodeStar[nodeIndex.m_data[i]] = new PiVector(valence.m_data[i]);
            }
            ++i;
        }
        PiVector currIndex = new PiVector(numNodes);
        int i2 = 0;
        while (i2 < nop) {
            PiVector poly = this.m_polySet.getPolygon(i2);
            int polySize = poly.getSize();
            int j = 0;
            while (j < polySize - 1) {
                if (nodeIndex.m_data[poly.m_data[j + 1]] != -1) {
                    this.m_nodeStar[nodeIndex.m_data[poly.m_data[j + 1]]].m_data[currIndex.m_data[nodeIndex.m_data[poly.m_data[j + 1]]]] = poly.m_data[j];
                    int n = nodeIndex.m_data[poly.m_data[j + 1]];
                    currIndex.m_data[n] = currIndex.m_data[n] + 1;
                }
                if (nodeIndex.m_data[poly.m_data[j]] != -1) {
                    this.m_nodeStar[nodeIndex.m_data[poly.m_data[j]]].m_data[currIndex.m_data[nodeIndex.m_data[poly.m_data[j]]]] = poly.m_data[j + 1];
                    int n = nodeIndex.m_data[poly.m_data[j]];
                    currIndex.m_data[n] = currIndex.m_data[n] + 1;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void setNodeLinks(PiVector[] link) {
        this.m_nodeStar = link;
    }

    public void reset() {
        super.reset();
        if (this.m_polySet != null && this.m_geomSave != null) {
            this.m_polySet.copy((PsObject)this.m_geomSave);
            this.m_polySet.update((Object)this.m_polySet);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_weightRepell || event == this.m_weightAttract || event == this.m_weightUnify || event == this.m_weightStraight || event == this.m_weightStraightEnd || event == this.m_weightStarSpring || event == this.m_weightSmooth) {
            return true;
        }
        return super.update(event);
    }

    public void smoothStep() {
        int j;
        int j2;
        int polySize;
        int nop = this.m_polySet.getNumPolygons();
        int nov = this.m_polySet.getNumVertices();
        int dim = this.m_polySet.getDimOfVertices();
        double wRepell = this.m_weightRepell.getValue();
        wRepell /= (double)(nov - 1);
        double wAttract = this.m_weightAttract.getValue();
        double wUnify = this.m_weightUnify.getValue();
        double wNodeSprings = this.m_weightStarSpring.getValue();
        double wStraightness = this.m_weightStraight.getValue();
        double wStraightnessEnd = this.m_weightStraightEnd.getValue();
        double stepSize = this.m_weightSmooth.getValue();
        int numNodes = 0;
        int numEdges = 0;
        double avgLength = 0.0;
        PiVector valence = new PiVector(nov);
        boolean[] bNode = new boolean[nov];
        int i = 0;
        while (i < nov) {
            bNode[i] = false;
            ++i;
        }
        i = 0;
        while (i < nop) {
            PiVector poly = this.m_polySet.getPolygon(i);
            if (!bNode[poly.m_data[0]]) {
                ++numNodes;
            }
            bNode[poly.m_data[0]] = true;
            int polySize2 = poly.getSize();
            if (!bNode[poly.m_data[polySize2 - 1]]) {
                ++numNodes;
            }
            bNode[poly.m_data[polySize2 - 1]] = true;
            numEdges += polySize2 - 1;
            avgLength += this.m_polySet.getLengthOfPolygon(i);
            int j3 = 0;
            while (j3 < polySize2) {
                int n = poly.m_data[j3];
                valence.m_data[n] = valence.m_data[n] + 1;
                ++j3;
            }
            ++i;
        }
        avgLength /= (double)numEdges;
        PdVector[] force = PdVector.realloc(null, (int)nov, (int)dim);
        PdVector diff = new PdVector(dim);
        double dist = 0.0;
        int i2 = 0;
        while (i2 < nov) {
            if (wRepell != 0.0) {
                int j4 = i2 + 1;
                while (j4 < nov) {
                    diff.sub(this.m_polySet.getVertex(j4), this.m_polySet.getVertex(i2));
                    dist = diff.sqrLength();
                    if (diff.normalize()) {
                        if (dist < 1.0E-10) {
                            dist = 1.0E-10;
                        }
                        diff.multScalar(wRepell / dist);
                        force[i2].sub(diff);
                        force[j4].add(diff);
                    }
                    ++j4;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nop) {
            PiVector poly = this.m_polySet.getPolygon(i2);
            polySize = poly.getSize();
            j2 = 0;
            while (j2 < polySize - 1) {
                diff.sub(this.m_polySet.getVertex(poly.m_data[j2 + 1]), this.m_polySet.getVertex(poly.m_data[j2]));
                diff.multScalar(wAttract);
                force[poly.m_data[j2]].add(diff);
                force[poly.m_data[j2 + 1]].sub(diff);
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nop) {
            PiVector poly = this.m_polySet.getPolygon(i2);
            polySize = poly.getSize();
            j2 = 0;
            while (j2 < polySize - 1) {
                diff.sub(this.m_polySet.getVertex(poly.m_data[j2 + 1]), this.m_polySet.getVertex(poly.m_data[j2]));
                dist = diff.length();
                if (diff.normalize()) {
                    diff.multScalar(wUnify * (dist - avgLength));
                    force[poly.m_data[j2]].add(diff);
                    force[poly.m_data[j2 + 1]].sub(diff);
                }
                ++j2;
            }
            ++i2;
        }
        int numNodeStars = 0;
        if (this.m_nodeStar != null && this.m_nodeStar.length > 0) {
            numNodeStars = this.m_nodeStar.length;
        }
        int i3 = 0;
        while (i3 < numNodeStars) {
            PiVector star = this.m_nodeStar[i3];
            int starSize = star.getSize();
            j = 0;
            while (j < starSize - 1) {
                int k = j + 1;
                while (k < starSize) {
                    diff.sub(this.m_polySet.getVertex(star.m_data[k]), this.m_polySet.getVertex(star.m_data[j]));
                    dist = diff.length();
                    if (diff.normalize()) {
                        double angle = Math.PI * 2 * (double)(k - j) / (1.0 * (double)starSize);
                        double d = Math.sqrt((1.0 - Math.cos(angle)) * (1.0 - Math.cos(angle)) + Math.sin(angle) * Math.sin(angle));
                        diff.multScalar(wNodeSprings * ((d *= avgLength) - dist));
                        force[star.m_data[j]].sub(diff);
                        force[star.m_data[k]].add(diff);
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nop) {
            PiVector poly = this.m_polySet.getPolygon(i3);
            int polySize3 = poly.getSize();
            if (polySize3 >= 4) {
                j = 2;
                while (j < polySize3 - 2) {
                    diff.blend(-0.5, this.m_polySet.getVertex(poly.m_data[j - 2]), -0.5, this.m_polySet.getVertex(poly.m_data[j + 2]));
                    diff.add(this.m_polySet.getVertex(poly.m_data[j - 1]));
                    diff.add(this.m_polySet.getVertex(poly.m_data[j + 1]));
                    diff.sub(this.m_polySet.getVertex(poly.m_data[j]));
                    diff.multScalar(wStraightness);
                    force[poly.m_data[j]].add(diff);
                    ++j;
                }
                diff.blend(-0.5, this.m_polySet.getVertex(poly.m_data[1]), -0.5, this.m_polySet.getVertex(poly.m_data[3]));
                diff.add(this.m_polySet.getVertex(poly.m_data[2]));
                diff.multScalar(wStraightnessEnd);
                force[poly.m_data[1]].add(diff);
                diff.blend(-0.5, this.m_polySet.getVertex(poly.m_data[polySize3 - 4]), -0.5, this.m_polySet.getVertex(poly.m_data[polySize3 - 2]));
                diff.add(this.m_polySet.getVertex(poly.m_data[polySize3 - 3]));
                diff.multScalar(wStraightnessEnd);
                force[poly.m_data[polySize3 - 2]].add(diff);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nov) {
            if (!this.m_bKeepSelected || !this.m_polySet.hasTagVertex(i3, 1)) {
                force[i3].multScalar(stepSize);
                this.m_polySet.getVertex(i3).add(force[i3]);
            }
            ++i3;
        }
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
            PsDebug.notify((String)"Thread stopped");
        }
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            this.smoothStep();
            this.m_polySet.update((Object)this.m_polySet);
        }
        this.m_bStopped = true;
    }
}

