/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.project.PjWorkshop;

public class PwRegularizeFaces
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_elementSet;
    protected PuDouble m_edgeLength = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Edge Length"));
    protected boolean m_bKeepSelected = true;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwRegularizeFaces() {
        super(PsConfig.getMessage((boolean)true, (int)54000, (String)"Regularize Elements"));
        this.m_edgeLength.addUpdateListener((PsUpdateIf)this);
        this.m_edgeLength.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_edgeLength.setDefValue(1.0);
        this.m_edgeLength.init();
        this.m_edgeLength.setValue(1.0);
        if (this.getClass() == PwRegularizeFaces.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgElementSet geom) {
        super.setGeometry((PgGeometry)geom);
        this.m_elementSet = geom;
    }

    public void reset() {
        super.reset();
        if (this.m_elementSet != null && this.m_geomSave != null) {
            this.m_elementSet.copy((PsObject)this.m_geomSave);
            this.m_elementSet.update((Object)this.m_elementSet);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_edgeLength) {
            return true;
        }
        return super.update(event);
    }

    public void regularizeStep() {
        int dim = this.m_elementSet.getDimOfVertices();
        if (dim != 3) {
            PsDebug.message((String)("Regularizing not implemented for dimension " + dim + "."));
            return;
        }
        if (!this.m_elementSet.hasElementNormals()) {
            this.m_elementSet.makeElementNormals();
        }
        double edgeLength = this.m_edgeLength.getValue();
        int noe = this.m_elementSet.getNumElements();
        int nov = this.m_elementSet.getNumVertices();
        PdVector[] newVertex = PdVector.realloc(null, (int)nov, (int)dim);
        PiVector numIncidentElements = new PiVector(nov);
        numIncidentElements.setConstant(0);
        PdVector frameX = new PdVector(dim);
        PdVector frameY = new PdVector(dim);
        PdVector center = new PdVector(dim);
        PdVector direction = new PdVector(dim);
        double dist = 1.0;
        int i = 0;
        while (i < noe) {
            PiVector element = this.m_elementSet.getElement(i);
            int elSize = element.getSize();
            PdVector normal = this.m_elementSet.getElementNormal(i);
            center.setConstant(0.0);
            int j = 0;
            while (j < elSize) {
                center.add(this.m_elementSet.getVertex(element.m_data[j]));
                ++j;
            }
            center.multScalar(1.0 / (double)elSize);
            frameX.setConstant(0.0);
            j = 0;
            while (j < elSize) {
                direction.sub(this.m_elementSet.getVertex(element.m_data[j]), center);
                direction.add(-PdVector.dot((PdVector)normal, (PdVector)direction), normal);
                PuVectorGeom.rotatePointAroundVector((PdVector)direction, (PdVector)direction, (PdVector)normal, (double)((double)(-j) * Math.PI * 2.0 / (double)elSize));
                frameX.add(direction);
                ++j;
            }
            frameX.normalize();
            frameY.cross(normal, frameX);
            dist = edgeLength / 2.0 / Math.sin(Math.PI / (double)elSize);
            frameX.multScalar(dist);
            frameY.multScalar(dist);
            j = 0;
            while (j < elSize) {
                newVertex[element.m_data[j]].add(center);
                newVertex[element.m_data[j]].add(Math.cos((double)j * Math.PI * 2.0 / (double)elSize), frameX);
                newVertex[element.m_data[j]].add(Math.sin((double)j * Math.PI * 2.0 / (double)elSize), frameY);
                int n = element.m_data[j];
                numIncidentElements.m_data[n] = numIncidentElements.m_data[n] + 1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            if (numIncidentElements.m_data[i] != 0) {
                newVertex[i].multScalar(1.0 / (double)numIncidentElements.m_data[i]);
                double w = 1.0;
                this.m_elementSet.getVertex(i).blend(1.0 - w, this.m_elementSet.getVertex(i), w, newVertex[i]);
            }
            ++i;
        }
        this.m_elementSet.makeElementNormals();
        this.m_elementSet.makeVertexNormals();
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
            PsDebug.notify((String)"Thread stopped");
        }
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            this.regularizeStep();
            this.m_elementSet.update((Object)this.m_elementSet);
        }
        this.m_bStopped = true;
    }
}

