/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import devSmoothing.PwPlanarizer;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jvx.gui.PuColorBar;
import jvx.project.PjWorkshop_IP;

public class PwPlanarizer_IP
extends PjWorkshop_IP
implements Runnable {
    protected PwPlanarizer m_pwPlanarizer;
    private Button m_stepButton;
    private Button m_startButton;
    private TextField m_errorField;
    private boolean m_running;

    public PwPlanarizer_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Planarize Elements"));
        if (this.getClass() == PwPlanarizer_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PwPlanarizer)) {
            PsDebug.warning((String)"Parent has to be of type PwPlanarizer");
            return;
        }
        super.setParent(parent);
        this.m_pwPlanarizer = (PwPlanarizer)parent;
        this.makeLayout();
    }

    public Dimension getDialogSize() {
        return new Dimension(600, 400);
    }

    public String getNotice() {
        return "Planarizes all elements. Click 'start' to start the iterationprocess or 'step' to just do one step. Vertices which are marked will be heldfix. The error shows a distance measure of all elements from being coplanar.";
    }

    public void makeLayout() {
        this.removeAll();
        this.add((Component)this.m_pwPlanarizer.m_stepSize.getInfoPanel());
        this.add((Component)this.m_pwPlanarizer.m_numSteps.getInfoPanel());
        Panel p = new Panel();
        this.m_stepButton = new Button("Step");
        p.add(this.m_stepButton);
        this.m_stepButton.addActionListener((ActionListener)((Object)this));
        this.m_startButton = new Button("Start");
        p.add(this.m_startButton);
        this.m_startButton.addActionListener((ActionListener)((Object)this));
        this.add(p);
        p = new Panel(new GridLayout(1, 2));
        p.add(new Label("Error:"));
        this.m_errorField = new TextField();
        p.add(this.m_errorField);
        this.m_errorField.setEditable(false);
        this.m_errorField.setText("" + this.m_pwPlanarizer.m_error);
        this.add(p);
        this.addSubTitle("Show Planarity");
        this.add((Component)this.m_pwPlanarizer.m_dyer.getColorBar().getInfoPanel());
    }

    public boolean update(Object event) {
        if (this.m_pwPlanarizer == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwPlanarizer) {
            this.m_errorField.setText("" + this.m_pwPlanarizer.m_error);
            PuColorBar bar = this.m_pwPlanarizer.m_dyer.getColorBar();
            bar.update((Object)bar);
            return true;
        }
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_pwPlanarizer == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_stepButton) {
            this.m_pwPlanarizer.step();
            this.m_pwPlanarizer.m_geom.update((Object)this.m_pwPlanarizer.m_geom);
            this.m_pwPlanarizer.update((Object)this.m_pwPlanarizer);
        } else if (source == this.m_startButton) {
            if (this.m_running) {
                this.m_pwPlanarizer.m_stop = true;
            } else {
                new Thread(this).start();
            }
        }
    }

    @Override
    public void run() {
        if (this.m_running) {
            return;
        }
        this.m_running = true;
        try {
            Color c = this.m_startButton.getBackground();
            this.m_startButton.setBackground(Color.red);
            this.m_startButton.setLabel("Stop");
            this.m_pwPlanarizer.start();
            this.m_startButton.setLabel("Start");
            this.m_startButton.setBackground(c);
        }
        catch (RuntimeException e) {
            this.m_running = false;
            throw e;
        }
        this.m_running = false;
    }
}

