/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import dev.geom.PuGeometryDyer;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwPlanarizer
extends PjWorkshop {
    protected PgElementSet m_geom;
    protected PuDouble m_stepSize = new PuDouble("Step Size");
    protected PuInteger m_numSteps = new PuInteger("Num Steps");
    protected double m_error;
    public boolean m_stop;
    private boolean m_showPlanarity;
    private double m_min;
    private double m_max;
    public PuGeometryDyer m_dyer = new PuGeometryDyer(true, true);

    public PwPlanarizer() {
        super("Planarizer workshop");
        if (((Object)((Object)this)).getClass() == PwPlanarizer.class) {
            this.init();
        }
    }

    public PwPlanarizer(PgElementSet geom) {
        this();
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
        this.m_stepSize.setDefBounds(0.0, 10.0, 0.1, 0.1);
        this.m_stepSize.setDefValue(0.25);
        this.m_stepSize.init();
        this.m_numSteps.setDefBounds(0, 40960, 1, 1);
        this.m_numSteps.setDefValue(10240);
        this.m_numSteps.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        this.m_dyer.setGeometry((PgPointSet)this.m_geom, 1);
        this.computeError();
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Planarizer workshop";
    }

    public double start() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set.");
            return 0.0;
        }
        this.m_stop = false;
        int numSteps = this.m_numSteps.getValue();
        double stepSize = this.m_stepSize.getValue();
        double error = 0.0;
        int i = 0;
        while (i < numSteps) {
            boolean update;
            if (this.m_stop) break;
            error = this.step(stepSize);
            int updateInterval = 48;
            boolean bl = update = i % 48 == 0;
            if (update) {
                this.updatePlanarityColors(false);
                this.m_geom.update((Object)this.m_geom);
                this.update((Object)this);
            }
            Thread.yield();
            ++i;
        }
        this.m_geom.update((Object)this.m_geom);
        this.update((Object)this);
        return error;
    }

    public double step() {
        return this.step(this.m_stepSize.getValue());
    }

    public double step(double stepSize) {
        PdVector[] vec = this.computeVectors();
        int numV = this.m_geom.getNumVertices();
        double error = 0.0;
        int v = 0;
        while (v < numV) {
            if (!this.m_geom.hasTagVertex(v, 1)) {
                this.m_geom.getVertex(v).blendBase(this.m_geom.getVertex(v), stepSize, vec[v]);
            }
            error += vec[v].sqrLength();
            ++v;
        }
        this.m_error = Math.sqrt(error);
        return error;
    }

    private PdVector[] computeVectors() {
        int numV = this.m_geom.getNumVertices();
        PdVector[] vec = new PdVector[numV];
        int v = 0;
        while (v < numV) {
            vec[v] = new PdVector(3);
            ++v;
        }
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            double dot;
            PiVector element = this.m_geom.getElement(e);
            int dim = this.m_geom.getDimOfElement(e);
            if (dim == 4) {
                PdVector v0 = this.m_geom.getVertex(element.m_data[0]);
                PdVector v1 = this.m_geom.getVertex(element.m_data[1]);
                PdVector v2 = this.m_geom.getVertex(element.m_data[2]);
                PdVector v3 = this.m_geom.getVertex(element.m_data[3]);
                PdVector normal = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)v2, (PdVector)v0), (PdVector)PdVector.subNew((PdVector)v3, (PdVector)v1));
                normal.normalize();
                PdVector center = PdVector.addNew((PdVector)v0, (PdVector)v1);
                center.add(v2);
                center.add(v3);
                center.multScalar(0.25);
                int i = 0;
                while (i < 4) {
                    dot = PdVector.subNew((PdVector)this.m_geom.getVertex(element.m_data[i]), (PdVector)center).dot(normal);
                    vec[element.m_data[i]].blendBase(vec[element.m_data[i]], -dot, normal);
                    ++i;
                }
            } else if (dim > 4) {
                int i = 0;
                while (i < dim) {
                    PdVector v0 = this.m_geom.getVertex(element.m_data[i]);
                    PdVector v1 = this.m_geom.getVertex(element.m_data[(i + 1) % dim]);
                    PdVector v2 = this.m_geom.getVertex(element.m_data[(i + dim / 2) % dim]);
                    PdVector v3 = this.m_geom.getVertex(element.m_data[(dim + i - 1) % dim]);
                    PdVector normal = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)v2, (PdVector)v0), (PdVector)PdVector.subNew((PdVector)v3, (PdVector)v1));
                    normal.normalize();
                    PdVector center = PdVector.addNew((PdVector)v0, (PdVector)v1);
                    center.add(v2);
                    center.add(v3);
                    center.multScalar(0.25);
                    dot = PdVector.subNew((PdVector)v0, (PdVector)center).dot(normal);
                    vec[element.m_data[i]].blendBase(vec[element.m_data[i]], -dot, normal);
                    ++i;
                }
            }
            ++e;
        }
        return vec;
    }

    private void computeError() {
        PdVector[] vec = this.computeVectors();
        int numV = this.m_geom.getNumVertices();
        double error = 0.0;
        int v = 0;
        while (v < numV) {
            error += vec[v].sqrLength();
            ++v;
        }
        this.m_error = Math.sqrt(error / (double)numV);
        this.updatePlanarityColors(true);
    }

    public boolean getShowPlanarity() {
        return this.m_showPlanarity;
    }

    private void updatePlanarityColors(boolean updateBounds) {
        if (updateBounds) {
            this.m_dyer.setValuesAndBounds(this.computePlanarity());
        } else {
            this.m_dyer.setValues(this.computePlanarity());
        }
        this.m_dyer.makeColors();
    }

    private PdVector computePlanarity() {
        int numE = this.m_geom.getNumElements();
        PdVector planarity = new PdVector(numE);
        int e = 0;
        while (e < numE) {
            double dot;
            double elementPlanarity = 0.0;
            PiVector element = this.m_geom.getElement(e);
            int dim = this.m_geom.getDimOfElement(e);
            if (dim == 4) {
                PdVector v0 = this.m_geom.getVertex(element.m_data[0]);
                PdVector v1 = this.m_geom.getVertex(element.m_data[1]);
                PdVector v2 = this.m_geom.getVertex(element.m_data[2]);
                PdVector v3 = this.m_geom.getVertex(element.m_data[3]);
                PdVector normal = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)v2, (PdVector)v0), (PdVector)PdVector.subNew((PdVector)v3, (PdVector)v1));
                normal.normalize();
                PdVector center = PdVector.addNew((PdVector)v0, (PdVector)v1);
                center.add(v2);
                center.add(v3);
                center.multScalar(0.25);
                int i = 0;
                while (i < 4) {
                    dot = PdVector.subNew((PdVector)this.m_geom.getVertex(element.m_data[i]), (PdVector)center).dot(normal);
                    elementPlanarity += Math.abs(dot);
                    ++i;
                }
            } else if (dim > 4) {
                int i = 0;
                while (i < dim) {
                    PdVector v0 = this.m_geom.getVertex(element.m_data[i]);
                    PdVector v1 = this.m_geom.getVertex(element.m_data[(i + 1) % dim]);
                    PdVector v2 = this.m_geom.getVertex(element.m_data[(i + dim / 2) % dim]);
                    PdVector v3 = this.m_geom.getVertex(element.m_data[(dim + i - 1) % dim]);
                    PdVector normal = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)v2, (PdVector)v0), (PdVector)PdVector.subNew((PdVector)v3, (PdVector)v1));
                    normal.normalize();
                    PdVector center = PdVector.addNew((PdVector)v0, (PdVector)v1);
                    center.add(v2);
                    center.add(v3);
                    center.multScalar(0.25);
                    dot = PdVector.subNew((PdVector)v0, (PdVector)center).dot(normal);
                    elementPlanarity += Math.abs(dot);
                    ++i;
                }
            }
            planarity.m_data[e] = elementPlanarity / (double)dim;
            ++e;
        }
        return planarity;
    }
}

