/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import devSmoothing.PwCentroidRegularization;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.rsrc.PsJavaView;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop_IP;

public class PwCentroidRegularization_IP
extends PjWorkshop_IP
implements Runnable,
ItemListener {
    protected Button m_smoothThales;
    protected Button m_smoothCentroid;
    protected Button m_flipEdges;
    protected Button m_markBoundary;
    protected Button m_markCurved;
    protected PuDouble m_curvedThreshold;
    protected Button m_markSmallAngles;
    protected PuDouble m_smallAnglesThreshold;
    protected Button m_printStats;
    protected Button m_project;
    private PwCentroidRegularization m_pwSmoother;
    private Object m_eventSource;
    private Choice m_targetChoice;
    private PgElementSet[] m_targets;

    public PwCentroidRegularization_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Mesh Regularization"));
        this.setPreferredSize(450, 500);
        if (this.getClass() == PwCentroidRegularization_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pwSmoother = (PwCentroidRegularization)parent;
        this.add((Component)this.m_pwSmoother.m_stepSize.getInfoPanel());
        this.m_flipEdges = new Button("Flip edges");
        this.m_flipEdges.addActionListener((ActionListener)((Object)this));
        this.m_printStats = new Button("Print statistics");
        this.m_printStats.addActionListener((ActionListener)((Object)this));
        this.m_markBoundary = new Button("Mark Boundary Vertices");
        this.m_markBoundary.addActionListener((ActionListener)((Object)this));
        this.m_markCurved = new Button("Only flat vertices");
        this.m_markCurved.addActionListener((ActionListener)((Object)this));
        this.m_markSmallAngles = new Button("Only large angles");
        this.m_markSmallAngles.addActionListener((ActionListener)((Object)this));
        this.m_curvedThreshold = new PuDouble("Threshold", (PsUpdateIf)this);
        this.m_curvedThreshold.clearTag(10);
        this.m_curvedThreshold.setEnabledConfigButton(false);
        this.m_curvedThreshold.setDefValue(5.0);
        this.m_curvedThreshold.setDefBounds(0.0, 90.0, 1.0, 10.0);
        this.m_curvedThreshold.init();
        this.m_smallAnglesThreshold = new PuDouble("Threshold", (PsUpdateIf)this);
        this.m_smallAnglesThreshold.setEnabledConfigButton(false);
        this.m_smallAnglesThreshold.setDefBounds(0.0, 180.0, 0.1, 1.0);
        this.m_smallAnglesThreshold.setDefValue(179.0);
        this.m_smallAnglesThreshold.init();
        Panel panel = new Panel(new GridLayout(1, 3, 3, 3));
        panel.add((Component)this.m_pwSmoother.m_fixMarked.getInfoPanel());
        panel.add((Component)this.m_pwSmoother.m_onlyTangential.getInfoPanel());
        panel.add((Component)this.m_pwSmoother.m_autoProject.getInfoPanel());
        this.add(panel);
        this.add((Component)this.m_pwSmoother.m_smoothingIterations.getInfoPanel());
        this.add((Component)this.m_pwSmoother.m_projectionIterations.getInfoPanel());
        panel = new Panel(new GridLayout(1, 2, 3, 3));
        this.m_smoothCentroid = new Button("Smooth");
        this.m_smoothCentroid.addActionListener((ActionListener)((Object)this));
        panel.add(this.m_smoothCentroid);
        this.add(panel);
        this.add(new Panel());
        panel = new Panel(new GridLayout(3, 2, 3, 3));
        panel.add(this.m_flipEdges);
        panel.add(this.m_markBoundary);
        this.m_project = new Button("Project");
        this.m_project.addActionListener((ActionListener)((Object)this));
        panel.add(this.m_project);
        this.m_targetChoice = new Choice();
        this.m_targetChoice.addItemListener(this);
        panel.add(this.m_targetChoice);
        panel.add(this.m_printStats);
        this.add(panel);
        panel = new Panel(new GridLayout(2, 2, 3, 3));
        panel.add(this.m_markCurved);
        panel.add((Component)this.m_curvedThreshold.getInfoPanel());
        panel.add(this.m_markSmallAngles);
        panel.add((Component)this.m_smallAnglesThreshold.getInfoPanel());
        this.add(panel);
        this.update(this);
    }

    public int getDialogButtons() {
        return 13;
    }

    public Dimension getDialogSize() {
        return new Dimension(450, 500);
    }

    public String getNotice() {
        return "Improve mesh regularity by moving points and optionally by edge flips.\nSMOOTHING STEPS: The number of smoothing steps once the smoothing button is pressed.\nITERATIONS: Iterate the smoothing and projection this many times.\nPROJECT: Project each vertex back onto the original surface (if workshop backup is enabled) or onto another geometry. Target must be triangulated.\nFLIP EDGES:  Flip edges if the regularity of vertex valences is increased. (In case of ties, draw the edge of each edge star between the vertices with the larger opening angles.)\n";
    }

    public boolean update(Object event) {
        if (event == this.m_pwSmoother) {
            this.fillProjectionTargets();
            return true;
        }
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        if (!(this.m_pwSmoother.getGeometry() instanceof PgElementSet)) {
            return;
        }
        PgElementSet geom = (PgElementSet)this.m_pwSmoother.getGeometry();
        Object source = event.getSource();
        if (source == this.m_flipEdges) {
            int flips = PwCentroidRegularization.flipEdges((PgElementSet)this.m_pwSmoother.getGeometry());
            PsDebug.showStatus((String)("numFlips: " + flips));
            this.updateGeom();
        } else if (source == this.m_smoothThales || event.getSource() == this.m_smoothCentroid || event.getSource() == this.m_project) {
            this.m_eventSource = source;
            new Thread(this).start();
        } else if (source == this.m_printStats) {
            this.printStatistics();
        } else if (source == this.m_markBoundary) {
            PwCentroidRegularization_IP.markBoundaryVertices(geom);
            geom.update((Object)geom);
        } else if (source == this.m_markCurved) {
            this.markCurvedVertices(geom);
            geom.update((Object)geom);
        } else if (source == this.m_markSmallAngles) {
            this.markLargeAngles(geom);
            geom.update((Object)geom);
        } else {
            super.actionPerformed(event);
        }
    }

    private void fillProjectionTargets() {
        this.m_targetChoice.removeAll();
        PgGeometryIf[] geometries = this.m_pwSmoother.getDisplay().getGeometries();
        Vector<PgGeometryIf> geoms = new Vector<PgGeometryIf>();
        int i = 0;
        while (i < geometries.length) {
            if (geometries[i] instanceof PgElementSet && (geometries[i] != this.m_pwSmoother.getGeometry() || PsJavaView.isEnabledWorkshopBackup())) {
                geoms.addElement(geometries[i]);
            }
            ++i;
        }
        this.m_targets = new PgElementSet[geoms.size()];
        i = 0;
        while (i < geoms.size()) {
            this.m_targets[i] = (PgElementSet)geoms.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < this.m_targets.length) {
            this.m_targetChoice.add(this.m_targets[i].getName());
            ++i;
        }
        int selectedIndex = this.m_targetChoice.getSelectedIndex();
        this.m_pwSmoother.setTarget(selectedIndex == -1 ? null : this.m_targets[selectedIndex]);
    }

    private void markCurvedVertices(PgElementSet geom) {
        PbVector flat = new PbVector(geom.getNumVertices());
        double cos = Math.cos(this.m_curvedThreshold.getValue() * Math.PI / 180.0);
        flat.setConstant(true);
        int i = 0;
        while (i < geom.getNumElements()) {
            PiVector elem = geom.getElement(i);
            PiVector neigh = geom.getNeighbour(i);
            PdVector iNormal = geom.getElementNormal(i);
            int j = 0;
            while (j < elem.getSize()) {
                if (neigh.getEntry(j) == -1 || iNormal.dot(geom.getElementNormal(neigh.getEntry(j))) < cos) {
                    flat.m_data[elem.getEntry((int)((j + 1) % elem.getSize()))] = false;
                    flat.m_data[elem.getEntry((int)((j + 2) % elem.getSize()))] = false;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < geom.getNumVertices()) {
            if (!flat.m_data[i]) {
                geom.setTagVertex(i, 1);
            }
            ++i;
        }
    }

    private void markLargeAngles(PgElementSet geom) {
        PbVector large = new PbVector(geom.getNumVertices());
        double cos = Math.cos(this.m_smallAnglesThreshold.getValue() * Math.PI / 180.0);
        int i = 0;
        while (i < geom.getNumElements()) {
            PiVector elem = geom.getElement(i);
            int j = 0;
            while (j < elem.getSize()) {
                PdVector edge2;
                int v0 = elem.getEntry(j);
                int v1 = elem.getEntry((j + 1) % elem.getSize());
                int v2 = elem.getEntry((j + 2) % elem.getSize());
                PdVector edge1 = PdVector.subNew((PdVector)geom.getVertex(v0), (PdVector)geom.getVertex(v1));
                double dot = PdVector.dot((PdVector)edge1, (PdVector)(edge2 = PdVector.subNew((PdVector)geom.getVertex(v2), (PdVector)geom.getVertex(v1)))) / edge1.length() / edge2.length();
                if (dot < cos) {
                    large.m_data[v1] = true;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < geom.getNumVertices()) {
            if (!large.m_data[i]) {
                geom.setTagVertex(i, 1);
            }
            ++i;
        }
    }

    private static void markBoundaryVertices(PgElementSet geom) {
        PgVertexStar star = new PgVertexStar();
        int[] elemAtVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        int v = 0;
        while (v < geom.getNumVertices()) {
            star.makeVertexStar(geom, v, elemAtVertex[v]);
            if (!star.isClosed()) {
                geom.setTagVertex(v, 1);
            }
            ++v;
        }
    }

    @Override
    public void run() {
        this.m_smoothCentroid.setEnabled(false);
        if (this.m_eventSource == this.m_smoothThales) {
            this.m_pwSmoother.smoothThalesCircle(true);
        }
        if (this.m_eventSource == this.m_smoothCentroid) {
            this.m_pwSmoother.smoothCentroid(true);
        }
        if (this.m_eventSource == this.m_project) {
            this.m_pwSmoother.project();
            this.updateGeom();
        }
        this.m_smoothCentroid.setEnabled(true);
    }

    private void updateGeom() {
        this.m_pwSmoother.getGeometry().update((Object)this.m_pwSmoother.getGeometry());
    }

    private void printStatistics() {
        PgElementSet geom = (PgElementSet)this.m_pwSmoother.getGeometry();
        PdVector edgeLen = new PdVector();
        int[] extremeLen = PwCentroidRegularization_IP.getEdgeLengths(geom, edgeLen, false);
        PdVector vertAng = new PdVector();
        int[] extremeAng = PwCentroidRegularization_IP.getVertexAngles(geom, vertAng, false);
        PsDebug.message((String)("Statistics of " + geom.getName()));
        PsDebug.message((String)("Average edge length:   " + (float)edgeLen.average()));
        PsDebug.message((String)("Edge length variance:  " + (float)edgeLen.variance()));
        PsDebug.message((String)("Edge length range:     " + (float)edgeLen.min() + " (elem " + extremeLen[0] + ") -- " + (float)edgeLen.max() + " (elem " + extremeLen[1] + ")"));
        PsDebug.message((String)("Average vertex angle:  " + (float)vertAng.average()));
        PsDebug.message((String)("Vertex angle variance: " + (float)vertAng.variance()));
        PsDebug.message((String)("Vertex angle range:    " + (float)vertAng.min() + " (elem " + extremeAng[0] + ") -- " + (float)vertAng.max() + " (elem " + extremeAng[1] + ")\n"));
    }

    private static int[] getEdgeLengths(PgElementSet geom, PdVector edgeLength, boolean bUseBoundaryEdges) {
        int numEdges = geom.getNumEdges();
        if (edgeLength == null) {
            edgeLength = new PdVector();
        }
        edgeLength.setSize(numEdges);
        int numElements = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PiVector[] neighbour = geom.getNeighbours();
        int maxInd = -1;
        int minInd = -1;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int ind = 0;
        int i = 0;
        while (i < numElements) {
            int elemLen = element[i].getSize();
            int j = 0;
            while (j < elemLen) {
                if (neighbour == null && bUseBoundaryEdges || neighbour != null && neighbour[i].m_data[j] < i) {
                    double len = geom.getEdgeLength(i, j);
                    edgeLength.setEntry(ind, len);
                    ++ind;
                    if (len > max) {
                        maxInd = i;
                        max = len;
                    }
                    if (len < min) {
                        minInd = i;
                        min = len;
                    }
                }
                ++j;
            }
            ++i;
        }
        edgeLength.setSize(ind);
        return new int[]{minInd, maxInd};
    }

    private static int[] getVertexAngles(PgElementSet geom, PdVector vertexAngle, boolean bUseBoundaryVertices) {
        int numAngles = geom.getNumElementIndices();
        if (vertexAngle == null) {
            vertexAngle = new PdVector();
        }
        vertexAngle.setSize(numAngles);
        int numElements = geom.getNumElements();
        PiVector[] element = geom.getElements();
        PdVector[] vertex = geom.getVertices();
        int maxInd = -1;
        int minInd = -1;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        geom.markBoundary();
        int ind = 0;
        int i = 0;
        while (i < numElements) {
            PiVector elem = element[i];
            int elemLen = elem.getSize();
            int j = 0;
            while (j < elemLen) {
                int p = elem.getEntry(j % elemLen);
                if (bUseBoundaryVertices || !vertex[p].hasTag(14)) {
                    int r;
                    int q = elem.getEntry((j - 1 + elemLen) % elemLen);
                    double angle = PdVector.angle((PdVector)vertex[p], (PdVector)vertex[q], (PdVector)vertex[r = elem.getEntry((j + 1) % elemLen)]);
                    if (angle > max) {
                        maxInd = i;
                        max = angle;
                    }
                    if (angle < min) {
                        minInd = i;
                        min = angle;
                    }
                    vertexAngle.setEntry(ind, angle);
                    ++ind;
                }
                ++j;
            }
            ++i;
        }
        vertexAngle.setSize(ind);
        return new int[]{minInd, maxInd};
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_targetChoice) {
            int selectedIndex = this.m_targetChoice.getSelectedIndex();
            this.m_pwSmoother.setTarget(selectedIndex == -1 ? null : this.m_targets[selectedIndex]);
        }
    }
}

