/*
 * Decompiled with CFR 0.152.
 */
package devSmoothing;

import devProjection.PnProjection;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.rsrc.PsJavaView;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwCentroidRegularization
extends PjWorkshop {
    protected PuBoolean m_onlyTangential;
    protected PuBoolean m_fixMarked;
    protected PuDouble m_stepSize = new PuDouble("Step size", (PsUpdateIf)this);
    protected PuInteger m_projectionIterations;
    protected PuInteger m_smoothingIterations;
    protected PuBoolean m_autoProject;
    protected PgElementSet m_target;

    public PwCentroidRegularization() {
        super("PwMeshRegularization");
        this.m_fixMarked = new PuBoolean("Fix marked points", (PsUpdateIf)this, true);
        this.m_onlyTangential = new PuBoolean("Only tangential", (PsUpdateIf)this, true);
        this.m_autoProject = new PuBoolean("Auto project", (PsUpdateIf)this, true);
        this.m_smoothingIterations = new PuInteger("Smoothing steps", (PsUpdateIf)this);
        this.m_projectionIterations = new PuInteger("Iterations", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PwCentroidRegularization.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_stepSize.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        this.m_smoothingIterations.setDefBounds(0, 100, 1, 10);
        this.m_smoothingIterations.setDefValue(20);
        this.m_smoothingIterations.init();
        this.m_projectionIterations.setDefBounds(0, 100, 1, 10);
        this.m_projectionIterations.setDefValue(1);
        this.m_projectionIterations.init();
        this.m_autoProject.init();
        if (PsJavaView.m_bLargeModel) {
            this.m_stepSize.setDefValue(0.5);
            this.m_stepSize.init();
            this.m_smoothingIterations.setDefValue(1);
            this.m_smoothingIterations.init();
            this.m_onlyTangential.setState(false);
            this.m_autoProject.setState(false);
        }
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
    }

    public boolean update(Object event) {
        if (event == this.m_stepSize || event == this.m_fixMarked || event == this.m_onlyTangential) {
            return true;
        }
        if (event == this.m_fixMarked) {
            return true;
        }
        if (event == this.m_onlyTangential) {
            return true;
        }
        if (event == this.m_autoProject) {
            return true;
        }
        if (event == this.m_smoothingIterations) {
            return true;
        }
        if (event == this.m_projectionIterations) {
            return true;
        }
        return super.update(event);
    }

    public void setTarget(PgElementSet target) {
        this.m_target = target;
    }

    public void setStepSize(double stepSize) {
        this.m_stepSize.setValue(stepSize);
    }

    public void setOnlyTangential(boolean onlyTangential) {
        this.m_onlyTangential.setState(onlyTangential);
    }

    public void setFixMarked(boolean fixMarked) {
        this.m_fixMarked.setState(fixMarked);
    }

    public void setProjectionIterations(int projectionIterations) {
        this.m_projectionIterations.setValue(projectionIterations);
    }

    public void setSmoothingIterations(int smoothingIterations) {
        this.m_smoothingIterations.setValue(smoothingIterations);
    }

    public void setAutoProject(boolean autoProject) {
        this.m_autoProject.setState(autoProject);
    }

    public void smoothCentroid(boolean updateGeometry) {
        int i = 0;
        while (i < this.m_projectionIterations.getValue()) {
            int j = 0;
            while (j < this.m_smoothingIterations.getValue()) {
                this.smoothCentroidStep();
                if (updateGeometry) {
                    this.m_geom.update((Object)this.m_geom);
                }
                ++j;
            }
            if (this.m_autoProject.getState()) {
                this.project();
            }
            if (updateGeometry) {
                this.m_geom.update((Object)this.m_geom);
            }
            ++i;
        }
    }

    public void smoothCentroidStep() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        PiVector elemAtVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        double stepSize = this.m_stepSize.getValue();
        PdVector[] vertices = PdVector.copyNew((PdVector[])geom.getVertices());
        PdVector[] normals = PdVector.copyNew((PdVector[])geom.getVertexNormals());
        PdVector[] bndNormals = new PdVector[geom.getNumVertices()];
        PgVertexStar star = new PgVertexStar();
        boolean[] boundary = new boolean[geom.getNumVertices()];
        int v = 0;
        while (v < geom.getNumVertices()) {
            star.makeVertexStar(geom, v, elemAtVertex.m_data[v]);
            if (!star.isClosed()) {
                boundary[v] = true;
            }
            ++v;
        }
        v = 0;
        while (v < geom.getNumVertices()) {
            if (!this.m_fixMarked.getState() || !geom.hasTagVertex(v, 1)) {
                star.makeVertexStar(geom, v, elemAtVertex.m_data[v]);
                PiVector link = star.getLink();
                PdVector center = new PdVector(3);
                PdVector avgNormal = PdVector.copyNew((PdVector)geom.getVertexNormal(v));
                double weight = 0.0;
                int j = 0;
                while (j < link.getSize()) {
                    int w = link.getEntry(j);
                    weight += geom.getVertex(w).dist(geom.getVertex(v));
                    center.add(geom.getVertex(w).dist(geom.getVertex(v)), geom.getVertex(w));
                    avgNormal.add(geom.getVertexNormal(w));
                    ++j;
                }
                center.multScalar(1.0 / weight);
                avgNormal.setLength(1.0);
                normals[v] = avgNormal;
                vertices[v].blend(1.0 - stepSize, vertices[v], stepSize, center);
                if (!star.isClosed()) {
                    bndNormals[v] = PdVector.subNew((PdVector)geom.getVertex(link.getFirstEntry()), (PdVector)geom.getVertex(link.getLastEntry()));
                }
            }
            ++v;
        }
        geom.makeVertexNormals();
        int i = 0;
        while (i < geom.getNumVertices()) {
            PdVector dir = PdVector.subNew((PdVector)vertices[i], (PdVector)geom.getVertex(i));
            if (this.m_onlyTangential.getState()) {
                dir.orthogonalPart(dir, normals[i]);
                if (bndNormals[i] != null) {
                    PdVector cross = PdVector.crossNew((PdVector)normals[i], (PdVector)bndNormals[i]);
                    cross.normalize();
                    dir.orthogonalPart(dir, cross);
                    dir.multScalar(1.0);
                }
            }
            geom.getVertex(i).add(dir);
            ++i;
        }
        geom.makeElementNormals();
        geom.update((Object)geom);
    }

    protected void smoothThalesCircle(boolean updateGeometry) {
        int i = 0;
        while (i < this.m_projectionIterations.getValue()) {
            int j = 0;
            while (j < this.m_smoothingIterations.getValue()) {
                this.smoothThalesCircleStep();
                if (updateGeometry) {
                    this.m_geom.update((Object)this.m_geom);
                }
                ++j;
            }
            if (this.m_autoProject.getState()) {
                this.project();
            }
            if (updateGeometry) {
                this.m_geom.update((Object)this.m_geom);
            }
            ++i;
        }
    }

    public void smoothThalesCircleStep() {
        PgElementSet geom = (PgElementSet)this.m_geom;
        geom.makeVertexNormals();
        PdVector[] normals = geom.getVertexNormals();
        double stepSize = this.m_stepSize.getValue();
        PdVector[] vertices = PdVector.copyNew((PdVector[])geom.getVertices());
        PdVector midPoint = new PdVector(3);
        PdVector directionToMidpoint = new PdVector(3);
        int e = 0;
        while (e < geom.getNumElements()) {
            PiVector elem = geom.getElement(e);
            int size = elem.getSize();
            int j = 0;
            while (j < size) {
                int ind1 = elem.getEntry(j);
                if (!geom.hasTagVertex(ind1, 1)) {
                    int ind0 = elem.getEntry((j - 1 + size) % size);
                    int ind2 = elem.getEntry((j + 1) % size);
                    PdVector v0 = geom.getVertex(ind0);
                    PdVector v1 = geom.getVertex(ind1);
                    PdVector v2 = geom.getVertex(ind2);
                    midPoint.blend(0.5, v0, 0.5, v2);
                    double radius = v0.dist(v2) / 2.0;
                    directionToMidpoint.sub(midPoint, v1);
                    directionToMidpoint.add(-normals[ind1].dot(directionToMidpoint), normals[ind1]);
                    vertices[ind1].add(stepSize * (midPoint.dist(v1) - radius), directionToMidpoint);
                }
                ++j;
            }
            ++e;
        }
        geom.setVertices(vertices);
        geom.makeElementNormals();
        geom.update((Object)geom);
    }

    public static int flipEdges(PgElementSet geom) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"valid for triangulations only");
            return -1;
        }
        if (geom.hasElementTextures()) {
            PsDebug.warning((String)"flip edges not valid when surface has element textures");
            return -1;
        }
        PiVector valence = PgElementSet.getVertexValence((PgElementSet)geom);
        PdVector[] p = new PdVector[4];
        boolean bFlip = true;
        double[] angle = new double[4];
        int numFlips = 0;
        int numPasses = 0;
        PiVector butterfly = new PiVector(4);
        while (bFlip) {
            if (++numPasses > 1) {
                return numFlips;
            }
            bFlip = false;
            int i = 0;
            while (i < geom.getNumElements()) {
                boolean bVoid = false;
                butterfly.setConstant(-1);
                butterfly.setEntry(0, i);
                int k = 1;
                while (k < 4) {
                    if (geom.getNeighbours()[i].m_data[k - 1] != -1 && butterfly.getIndexOf(geom.getNeighbours()[i].m_data[k - 1]) > -1) {
                        bVoid = true;
                        break;
                    }
                    butterfly.setEntry(k, geom.getNeighbours()[i].m_data[k - 1]);
                    ++k;
                }
                if (!bVoid) {
                    k = 0;
                    while (k < 3) {
                        int otherElem = geom.getNeighbours()[i].m_data[k];
                        if (otherElem != -1 && otherElem <= i) {
                            int ind01 = (k + 1) % 3;
                            int ind02 = (k + 2) % 3;
                            int ind10 = geom.getOppVertexLocInd(i, k);
                            int ind11 = (ind10 + 1) % 3;
                            int ind12 = (ind10 + 2) % 3;
                            if (geom.getElements()[i].m_data[ind01] == geom.getElements()[otherElem].m_data[ind11]) {
                                ind11 = (ind10 + 2) % 3;
                                ind12 = (ind10 + 1) % 3;
                            }
                            if (!(geom.getElements()[i].m_data[k] == geom.getElements()[otherElem].m_data[ind10] || geom.getVertices()[geom.getElements()[i].m_data[ind01]].hasTag(1) && geom.getVertices()[geom.getElements()[i].m_data[ind02]].hasTag(1))) {
                                int otherNeigh1 = geom.getNeighbours()[otherElem].m_data[ind11];
                                int otherNeigh2 = geom.getNeighbours()[otherElem].m_data[ind12];
                                if (!(otherNeigh1 > -1 && otherNeigh1 == otherNeigh2 || otherNeigh1 > -1 && butterfly.getIndexOf(otherNeigh1) > -1 || otherNeigh2 > -1 && butterfly.getIndexOf(otherNeigh2) > -1 || valence.getEntry(geom.getElements()[i].m_data[ind01]) <= 4 || valence.getEntry(geom.getElements()[i].m_data[ind02]) <= 4)) {
                                    int ind0 = geom.getElements()[i].m_data[k];
                                    int ind1 = geom.getElements()[i].m_data[ind01];
                                    int ind2 = geom.getElements()[i].m_data[ind02];
                                    int ind3 = geom.getElements()[otherElem].m_data[ind10];
                                    p[0] = geom.getVertices()[ind0];
                                    p[1] = geom.getVertices()[ind1];
                                    p[2] = geom.getVertices()[ind3];
                                    p[3] = geom.getVertices()[ind2];
                                    if (!(geom.hasTagVertex(ind0, 1) && geom.hasTagVertex(ind3, 1) || geom.hasTagVertex(ind1, 1) && geom.hasTagVertex(ind2, 1))) {
                                        boolean flip;
                                        PdVector.angle((double[])angle, (PdVector[])p);
                                        boolean bl = flip = valence.m_data[ind0] + valence.m_data[ind3] + 2 < valence.m_data[ind1] + valence.m_data[ind2];
                                        if (valence.m_data[ind0] + valence.m_data[ind3] + 2 == valence.m_data[ind1] + valence.m_data[ind2]) {
                                            flip |= angle[0] + angle[2] > angle[1] + angle[3];
                                        }
                                        if (valence.m_data[ind0] + valence.m_data[ind3] + 2 == valence.m_data[ind1] + valence.m_data[ind2]) {
                                            int numRegularNow = 0;
                                            if (valence.m_data[ind0] == 6) {
                                                ++numRegularNow;
                                            }
                                            if (valence.m_data[ind1] == 6) {
                                                ++numRegularNow;
                                            }
                                            if (valence.m_data[ind2] == 6) {
                                                ++numRegularNow;
                                            }
                                            if (valence.m_data[ind3] == 6) {
                                                ++numRegularNow;
                                            }
                                            int numRegularFlipped = 0;
                                            if (valence.m_data[ind0] == 5) {
                                                ++numRegularFlipped;
                                            }
                                            if (valence.m_data[ind1] == 7) {
                                                ++numRegularFlipped;
                                            }
                                            if (valence.m_data[ind2] == 7) {
                                                ++numRegularFlipped;
                                            }
                                            if (valence.m_data[ind3] == 5) {
                                                ++numRegularFlipped;
                                            }
                                            flip |= numRegularFlipped > numRegularNow;
                                        }
                                        if (flip) {
                                            ++numFlips;
                                            bFlip = true;
                                            int n = ind0;
                                            valence.m_data[n] = valence.m_data[n] + 1;
                                            int n2 = ind1;
                                            valence.m_data[n2] = valence.m_data[n2] - 1;
                                            int n3 = ind2;
                                            valence.m_data[n3] = valence.m_data[n3] - 1;
                                            int n4 = ind3;
                                            valence.m_data[n4] = valence.m_data[n4] + 1;
                                            int nb = geom.getNeighbours()[i].m_data[ind01];
                                            if (nb > -1) {
                                                geom.getNeighbours()[nb].m_data[geom.getOppVertexLocInd((int)i, (int)ind01)] = otherElem;
                                            }
                                            if ((nb = geom.getNeighbours()[otherElem].m_data[ind11]) > -1) {
                                                geom.getNeighbours()[nb].m_data[geom.getOppVertexLocInd((int)otherElem, (int)ind11)] = i;
                                            }
                                            geom.getElements()[i].m_data[ind02] = geom.getElements()[otherElem].m_data[ind10];
                                            geom.getElements()[otherElem].m_data[ind12] = geom.getElements()[i].m_data[k];
                                            geom.getNeighbours()[i].m_data[k] = geom.getNeighbours()[otherElem].m_data[ind11];
                                            geom.getNeighbours()[otherElem].m_data[ind10] = geom.getNeighbours()[i].m_data[ind01];
                                            geom.getNeighbours()[i].m_data[ind01] = otherElem;
                                            geom.getNeighbours()[otherElem].m_data[ind11] = i;
                                        }
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        if (geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        if (geom.hasVertexNormals()) {
            geom.makeVertexNormals();
        }
        return numFlips;
    }

    public void project() {
        if (this.m_target == null) {
            PsDebug.warning((String)"No target set");
            return;
        }
        PgElementSet onto = this.m_target == this.m_geom ? (PgElementSet)this.getSavedGeometry() : this.m_target;
        PnProjection.projectPointSetOntoElementSet((PgPointSet)this.m_geom, onto, false);
    }
}

