/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devShootLines.PnVectorFieldLineDir;
import devShootLines.PwShootLines;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jvx.geom.PgPointSetOnElementSet;
import jvx.geom.PwBary;
import jvx.project.PjWorkshop;

public class PwShootPoints
extends PjWorkshop {
    protected PgElementSet m_geom = null;
    private PgPointSetOnElementSet m_points;
    protected PgVectorField m_field;
    public PuDouble m_stepSize;
    PdBary m_out = new PdBary(3);

    public PwShootPoints(String name) {
        super(name);
        this.m_stepSize = new PuDouble("Step size");
        this.m_stepSize.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        if (((Object)((Object)this)).getClass() == PwShootPoints.class) {
            this.init();
        }
    }

    public PwShootPoints(String name, PgElementSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        this.save();
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
    }

    public void save() {
        if (this.m_geom == null) {
            return;
        }
        this.m_geomSave.copy((PsObject)this.m_geom);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "ShootPoints workshop";
    }

    public void setPoints(PgPointSetOnElementSet points) {
        this.m_points = points;
    }

    public PgVectorField getField() {
        return this.m_field;
    }

    public void setField(PgVectorField field) {
        this.m_field = field;
    }

    public void shoot(double len) {
        if (this.m_geom == null || this.m_points == null || this.m_field == null) {
            PsDebug.warning((String)"Geometry, vector field or points are null.");
            return;
        }
        int num = this.m_points.getNumVertices();
        int i = 0;
        while (i < num) {
            PnVectorFieldLineDir ld = new PnVectorFieldLineDir();
            ld.setGeometry(this.m_geom);
            ld.setVectorField(this.m_field);
            PdBary point = this.m_points.getVertexBary(i);
            ld.initializeDirection(point.getElementInd(), false);
            boolean success = PwShootLines.shootLine(this.m_geom, point, ld, len, null, this.m_out);
            System.err.println(success + ": " + PwBary.getVertex(null, (PgElementSet)this.m_geom, (PdBary)this.m_out).toShortString());
            this.m_points.setVertexBary(i, this.m_out);
            ++i;
        }
        this.m_points.update((Object)this.m_points);
    }

    public void step() {
        this.shoot(this.m_stepSize.getValue());
    }
}

