/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devShootLines.PnFrameFieldLineDir;
import devShootLines.PnGeodesicLineDir;
import devShootLines.PnLineDirIf;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgPolygonSetOnElementSet;
import jvx.geom.PwBary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwShapeOperator;
import jvx.project.PjWorkshop;

public class PwShootLines
extends PjWorkshop
implements PvPickListenerIf,
MouseListener {
    public static final int NUM_METHODS = 2;
    public static final int METHOD_GEODESIC = 0;
    public static final int METHOD_PRINCIPAL_CURVATURE = 1;
    public static final String[] METHODNAMES = new String[]{"Geodesic", "Principal curvatures"};
    private static final int DEFAULT_METHOD = 0;
    protected int m_methodInd;
    public static final int MAX_POLYGON_LEN = 2048;
    protected PgElementSet m_geom = null;
    protected PnLineDirIf m_lineDir;
    protected PdBary m_initialBary;
    protected PgPolygonOnElementSet m_poly;
    protected PgPolygonSetOnElementSet m_polySet;
    protected static int m_polyNo;
    protected boolean m_firstTime;
    private boolean m_pickInitial;

    public PwShootLines(String name) {
        super(name);
        this.setMethod(0);
        if (this.getClass() == PwShootLines.class) {
            this.init();
        }
    }

    public PwShootLines(String name, PgElementSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setDisplay(PvDisplayIf display) {
        if (this.m_display != null && this.m_polySet != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_polySet);
        }
        super.setDisplay(display);
        display.addPickListener((PvPickListenerIf)this);
        ((Component)display).addMouseListener(this);
        if (this.m_display != null && this.m_polySet != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polySet);
        }
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an element set.");
            return;
        }
        if (!PwShootLines.preprocessGeometry((PgElementSet)geom)) {
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        this.save();
        if (this.m_display != null && this.m_polySet != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_polySet);
        }
        this.m_polySet = new PgPolygonSetOnElementSet(this.m_geom);
        this.m_polySet.setName("Polygons");
        this.m_polySet.showVertices(false);
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polySet);
        }
        if (this.m_methodInd >= 0) {
            this.setMethod(this.m_methodInd);
        }
        this.update(this);
    }

    private static boolean preprocessGeometry(PgElementSet geom) {
        if (!PwCleanMesh.checkManifold((PgElementSet)geom, (boolean)false)) {
            PsDebug.warning((String)"Geometry must be manifold.");
            return false;
        }
        PgElementSet.triangulate((PgElementSet)geom);
        PwCleanMesh.makeOrientation((PgElementSet)geom);
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        geom.setEnabledEdges(true);
        geom.makeEdgeStars();
        geom.setGlobalVectorLength(Math.sqrt(geom.getArea() / (double)geom.getNumElements()) / 2.0);
        return true;
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
    }

    public void save() {
        if (this.m_geom == null) {
            return;
        }
        this.m_geomSave.copy((PsObject)this.m_geom);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "ShootLines2 workshop";
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (this.m_lineDir == null) {
            PsDebug.warning((String)"No line dir method set.");
            return;
        }
        int e = pos.getElementInd();
        PdBary bary = pos.getBary();
        bary.setElementInd(e);
        this.setFirstLinePoint(bary);
        this.m_polySet.update((Object)this.m_polySet);
        this.m_poly.update((Object)this.m_poly);
        this.m_pickInitial = true;
    }

    public void dragInitial(PvPickEvent pos) {
        if (this.m_initialBary == null) {
            PsDebug.warning((String)"Pick initial point first.");
            return;
        }
        this.m_pickInitial = false;
        int e = pos.getElementInd();
        PdBary bary = pos.getBary();
        bary.setElementInd(e);
        this.dragLineToPoint(bary);
        this.m_poly.update((Object)this.m_poly);
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void setLineDirMethod(PnLineDirIf method) {
        this.m_methodInd = -1;
        this.m_lineDir = method;
    }

    private void setFirstLinePoint(PdBary bary) {
        if (this.m_lineDir == null) {
            PsDebug.warning((String)"No line dir method set.");
            return;
        }
        if (bary.getElementInd() < 0 || bary.m_data.length < 3) {
            return;
        }
        this.m_initialBary = bary;
        this.m_firstTime = true;
        this.initNewPolygon();
        this.m_poly.setVertexBary(0, bary);
        this.m_poly.setVertexBary(1, bary);
    }

    private void initNewPolygon() {
        this.m_display.removeGeometry((PgGeometryIf)this.m_poly);
        if (this.m_poly != null) {
            this.m_polySet.addPolygonBary(this.m_poly);
        }
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_poly.showVertices(false);
        this.m_poly.setGlobalEdgeSize(2.0);
        this.m_poly.setName("Polygon " + m_polyNo++);
        this.m_poly.setNumVertices(2);
        this.m_display.addGeometry((PgGeometryIf)this.m_poly);
    }

    private void dragLineToPoint(PdBary endPointBary) {
        if (this.m_initialBary == null) {
            PsDebug.warning((String)"Call setFirstLinePoint() first");
            return;
        }
        PnLineDirIf lineDir = this.m_lineDir;
        if (endPointBary == null) {
            if (this.m_firstTime) {
                this.m_firstTime = false;
            }
            PwShootLines.updateShootLine(this.m_geom, this.m_poly, lineDir, null, 1000);
        } else {
            if (endPointBary.getElementInd() < 0 || endPointBary.m_data.length < 3) {
                return;
            }
            PdVector endPoint = PwBary.getVertex(null, (PgElementSet)this.m_geom, (PdBary)endPointBary);
            if (this.m_firstTime) {
                this.m_lineDir.initializeDirection(this.m_initialBary, endPoint);
                this.m_firstTime = false;
            }
            PwShootLines.updateShootLine(this.m_geom, this.m_poly, lineDir, endPoint, 2048);
        }
    }

    public static void updateShootLine(PgElementSet geom, PgPolygonOnElementSet poly, PnLineDirIf lineDir, PdVector endPoint, int maxPolygonLen) {
        int vIdx = poly.getNumVertices() - 1;
        PdBary currentVertexBary = PdBary.copyNew((PdBary)poly.getVertexBary(vIdx));
        PdVector currentVertex = PdVector.copyNew((PdVector)poly.getVertex(vIdx));
        int e = currentVertexBary.getElementInd();
        PiVector element = geom.getElement(e);
        int prevE = poly.getVertexBary(vIdx - 1).getElementInd();
        PdBaryDir currentDirBary = lineDir.getDirection(null);
        if (currentDirBary.getElementInd() != e) {
            PsDebug.warning((String)"invalid polygon: it does not end on current element of lineDir");
            return;
        }
        PdVector currentDir = new PdVector(3);
        PdBaryDir.getVector((PdVector)currentDir, (PdBaryDir)currentDirBary, (PdVector)geom.getVertex(element.m_data[0]), (PdVector)geom.getVertex(element.m_data[1]), (PdVector)geom.getVertex(element.m_data[2]));
        boolean shorten = false;
        if (endPoint != null) {
            PdVector lineEndPoint = poly.getVertex(poly.getNumVertices() - 1);
            PdVector destDir = PdVector.subNew((PdVector)endPoint, (PdVector)lineEndPoint);
            boolean bl = shorten = destDir.dot(currentDir) < 0.0;
        }
        if (shorten && poly.getNumVertices() == 2) {
            shorten = false;
            lineDir.reverse();
        }
        PdVector tmp = new PdVector(3);
        boolean stop = false;
        currentDirBary = new PdBaryDir(3);
        currentDir = new PdVector(3);
        if (shorten) {
            lineDir.reverse();
        }
        while (!stop) {
            int locIdx = -1;
            stop = true;
            lineDir.getDirection(currentDirBary);
            PdBaryDir.getVector((PdVector)currentDir, (PdBaryDir)currentDirBary, (PdVector)geom.getVertex(element.m_data[0]), (PdVector)geom.getVertex(element.m_data[1]), (PdVector)geom.getVertex(element.m_data[2]));
            double time = 0.0;
            if (endPoint != null) {
                tmp.sub(endPoint, currentVertex);
                double distEndPoint = currentDir.dot(tmp) / currentDir.length();
                if (distEndPoint < 0.0) {
                    if (vIdx == 1) {
                        time = -distEndPoint;
                        if (shorten) {
                            lineDir.reverse();
                            shorten = false;
                        }
                        currentDirBary.multScalar(-1.0);
                    } else {
                        time = 0.0;
                    }
                } else {
                    time = distEndPoint;
                }
            } else {
                time = Double.MAX_VALUE;
            }
            int i = 0;
            while (i < 3) {
                double t = -currentVertexBary.m_data[i] / currentDirBary.m_data[i];
                if (shorten && geom.getNeighbour((int)e).m_data[i] == prevE && t < time) {
                    time = t;
                    locIdx = i;
                    stop = false;
                }
                if (!shorten && currentDirBary.m_data[i] < 0.0 && t >= 0.0 && t < time) {
                    time = t;
                    locIdx = i;
                    stop = false;
                }
                ++i;
            }
            currentDirBary.multScalar(time);
            currentVertexBary.add(currentDirBary);
            poly.setVertexBary(vIdx, currentVertexBary);
            if (locIdx >= 0) {
                int ne = geom.getNeighbour((int)e).m_data[locIdx];
                if (ne == prevE && !shorten) break;
                if (!shorten) {
                    poly.addVertex(new PdVector(3));
                    poly.setVertexBary(++vIdx, e, currentVertexBary);
                    prevE = e;
                } else {
                    poly.setNumVertices(poly.getNumVertices() - 1);
                    if (--vIdx == 1) {
                        shorten = false;
                        prevE = -1;
                    } else {
                        prevE = poly.getVertexBary(vIdx - 1).getElementInd();
                    }
                }
                PiVector nElement = geom.getElement(ne);
                if (nElement == null) break;
                int idx1 = (locIdx + 1) % 3;
                int nIdx1 = nElement.getIndexOf(element.m_data[idx1]);
                int idx2 = (locIdx + 2) % 3;
                int nIdx2 = nElement.getIndexOf(element.m_data[idx2]);
                PdBary nBary = new PdBary(0.0, 0.0, 0.0);
                nBary.m_data[nIdx1] = currentVertexBary.m_data[idx1];
                nBary.m_data[nIdx2] = currentVertexBary.m_data[idx2];
                currentVertexBary.copy(nBary);
                currentVertexBary.setElementInd(ne);
                currentVertexBary.getVertex(currentVertex, geom.getVertex(nElement.m_data[0]), geom.getVertex(nElement.m_data[1]), geom.getVertex(nElement.m_data[2]));
                e = ne;
                element = nElement;
                if (!lineDir.goToNeighbourElement(locIdx)) {
                    stop = true;
                }
            }
            if (vIdx >= maxPolygonLen) break;
        }
        poly.setVertexBary(vIdx, currentVertexBary);
        if (shorten) {
            lineDir.reverse();
        }
    }

    public static boolean shootLine(PgElementSet geom, PdBary startPoint, PnLineDirIf lineDir, double stepWidth, PgPolygonOnElementSet poly, PdBary outBary) {
        return PwShootLines.shootLine(geom, startPoint, null, lineDir, stepWidth, poly, outBary);
    }

    public static boolean shootLine(PgElementSet geom, PdBary startPoint, PdVector endPoint, PnLineDirIf lineDir, double stepWidth, PgPolygonOnElementSet poly) {
        return PwShootLines.shootLine(geom, startPoint, endPoint, lineDir, stepWidth, poly, null);
    }

    public static boolean shootLine(PgElementSet geom, PdBary startPoint, PdVector endPoint, PnLineDirIf lineDir, double stepWidth, PgPolygonOnElementSet poly, PdBary outBary) {
        PdBary currentVertexBary = outBary;
        if (currentVertexBary == null) {
            currentVertexBary = PdBary.copyNew((PdBary)startPoint);
        } else {
            currentVertexBary.copy(startPoint);
        }
        PdVector currentVertex = new PdVector(3);
        int e = currentVertexBary.getElementInd();
        int prevE = -1;
        PdBaryDir currentDirBary = lineDir.getDirection(null);
        if (currentDirBary.getElementInd() != e) {
            PsDebug.warning((String)"invalid polygon: it does not end on current element of lineDir");
            return false;
        }
        PdVector currentDir = new PdVector(3);
        PdVector tmp = new PdVector(3);
        if (poly != null) {
            poly.addVertex(new PdVector(3));
            poly.setVertexBary(0, currentVertexBary.getElementInd(), currentVertexBary);
        }
        int numV = 1;
        double len = 0.0;
        int num = 0;
        boolean stop = false;
        boolean firstLoop = true;
        while (!stop) {
            PiVector element = geom.getElement(e);
            if (stepWidth < 0.0) {
                currentDirBary.multScalar(-1.0);
                stepWidth = -stepWidth;
            }
            int locIdx = -1;
            stop = true;
            double time = stepWidth - len;
            if (endPoint != null) {
                PwBary.getVertex((PdVector)currentVertex, (PgElementSet)geom, (PdBary)currentVertexBary);
                tmp.sub(endPoint, currentVertex);
                PdBaryDir.getVector((PdVector)currentDir, (PdBaryDir)currentDirBary, (PdVector)geom.getVertex(element.m_data[0]), (PdVector)geom.getVertex(element.m_data[1]), (PdVector)geom.getVertex(element.m_data[2]));
                double distEndPoint = currentDir.dot(tmp) / currentDir.length();
                if (distEndPoint < time) {
                    time = distEndPoint;
                }
            }
            if (time < 0.0) {
                if (firstLoop) {
                    time = -time;
                    lineDir.reverse();
                    currentDirBary.multScalar(-1.0);
                } else {
                    time = 0.0;
                }
            }
            int i = 0;
            while (i < 3) {
                double t = -currentVertexBary.m_data[i] / currentDirBary.m_data[i];
                if (currentDirBary.m_data[i] < 0.0 && t < time) {
                    time = t;
                    locIdx = i;
                    stop = false;
                }
                ++i;
            }
            currentDirBary.multScalar(time);
            currentVertexBary.add(currentDirBary);
            if (poly != null) {
                poly.addVertex(new PdVector(3));
                poly.setVertexBary(numV++, e, currentVertexBary);
            }
            if (locIdx >= 0) {
                int ne = geom.getNeighbour((int)e).m_data[locIdx];
                if (ne < 0) {
                    return false;
                }
                if (ne == prevE) {
                    lineDir.getDirection(currentDirBary);
                    currentDirBary.m_data[locIdx] = 0.0;
                    double x = (Math.abs(currentDirBary.m_data[(locIdx + 1) % 3]) + Math.abs(currentDirBary.m_data[(locIdx + 2) % 3])) / 2.0;
                    if (currentDirBary.m_data[(locIdx + 1) % 3] > 0.0) {
                        currentDirBary.m_data[(locIdx + 1) % 3] = x;
                        currentDirBary.m_data[(locIdx + 2) % 3] = -x;
                    } else {
                        currentDirBary.m_data[(locIdx + 1) % 3] = -x;
                        currentDirBary.m_data[(locIdx + 2) % 3] = x;
                    }
                } else {
                    prevE = e;
                    if (!lineDir.goToNeighbourElement(locIdx)) {
                        PsDebug.warning((String)"Cannot change to neighbour element");
                        return false;
                    }
                    e = ne;
                    PiVector nElement = geom.getElement(e);
                    int idx1 = (locIdx + 1) % 3;
                    int nIdx1 = nElement.getIndexOf(element.m_data[idx1]);
                    int idx2 = (locIdx + 2) % 3;
                    int nIdx2 = nElement.getIndexOf(element.m_data[idx2]);
                    PdBary nBary = new PdBary(0.0, 0.0, 0.0);
                    nBary.m_data[nIdx1] = currentVertexBary.m_data[idx1];
                    nBary.m_data[nIdx2] = currentVertexBary.m_data[idx2];
                    currentVertexBary.copy(nBary);
                    currentVertexBary.setElementInd(e);
                    lineDir.getDirection(currentDirBary);
                }
            }
            len += time;
            if (++num >= 2048) {
                return true;
            }
            firstLoop = false;
        }
        return true;
    }

    public void setMethod(int methodInd) {
        this.m_methodInd = methodInd;
        if (this.m_geom == null) {
            return;
        }
        switch (methodInd) {
            case 0: {
                PnGeodesicLineDir gld = new PnGeodesicLineDir();
                gld.setGeometry(this.m_geom);
                this.m_lineDir = gld;
                break;
            }
            case 1: {
                PnFrameFieldLineDir ld = new PnFrameFieldLineDir();
                ld.setGeometry(this.m_geom);
                int numE = this.m_geom.getNumElements();
                PdVector[] cValues = PdVector.realloc(null, (int)numE, (int)2);
                PgVectorField[] vf = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])cValues, (boolean)true);
                PgFrameField field = PnFrameField.makeFrameFieldFromVectorFields(this.m_geom, vf[0], vf[1], 4);
                PnFrameField.makeCovering(field, cValues, 3);
                ld.setFrameField(field);
                this.m_lineDir = ld;
                break;
            }
            default: {
                this.m_lineDir = null;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent f) {
        if (this.m_display == null) {
            return;
        }
        if (!this.m_pickInitial) {
            return;
        }
        if (this.m_initialBary == null) {
            PsDebug.warning((String)"No point picked.");
            return;
        }
        this.m_pickInitial = false;
        this.dragLineToPoint(null);
        this.m_poly.update((Object)this.m_poly);
        this.setFirstLinePoint(this.m_initialBary);
        this.m_lineDir.reverse();
        this.m_firstTime = false;
        PwShootLines.updateShootLine(this.m_geom, this.m_poly, this.m_lineDir, null, 1000);
        this.m_polySet.update((Object)this.m_polySet);
        this.m_poly.update((Object)this.m_poly);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

