/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devShootLines.PnLineDirIf;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;

public class PnVectorFieldLineDir
implements PnLineDirIf {
    protected PgElementSet m_geom;
    protected PgVectorField m_field;
    protected int m_element;
    protected boolean m_orientation;

    @Override
    public void setGeometry(PgElementSet geom) {
        this.m_geom = geom;
    }

    public void setVectorField(PgVectorField field) {
        this.m_field = field;
    }

    @Override
    public void initializeDirection(PdBary point, PdVector destination) {
        PdVector vec = new PdVector(3);
        int e = point.getElementInd();
        PiVector element = this.m_geom.getElement(e);
        point.getVertex(vec, this.m_geom.getVertex(element.m_data[0]), this.m_geom.getVertex(element.m_data[1]), this.m_geom.getVertex(element.m_data[2]));
        vec.sub(destination);
        vec.multScalar(-1.0);
        this.m_orientation = this.m_field.getVector(e).dot(vec) >= 0.0;
        this.m_element = e;
    }

    @Override
    public void initializeDirection(PdBary point) {
        this.m_orientation = true;
        this.m_element = point.getElementInd();
    }

    public void initializeDirection(int elementInd, boolean orientation) {
        this.m_orientation = orientation;
        this.m_element = elementInd;
    }

    @Override
    public boolean goToNeighbourElement(int neighbIdx) {
        this.m_element = this.m_geom.getNeighbour((int)this.m_element).m_data[neighbIdx];
        return !this.m_geom.hasTagElement(this.m_element, 1);
    }

    @Override
    public void reverse() {
        this.m_orientation = !this.m_orientation;
    }

    @Override
    public void copy(PnLineDirIf lineDir) {
        if (!(lineDir instanceof PnVectorFieldLineDir)) {
            PsDebug.warning((String)"LineDir is no PnVectorFieldLineDir");
            return;
        }
        PnVectorFieldLineDir ld = (PnVectorFieldLineDir)lineDir;
        this.m_geom = ld.m_geom;
        this.m_field = ld.m_field;
        this.m_element = ld.m_element;
        this.m_orientation = ld.m_orientation;
    }

    @Override
    public PdBaryDir getDirection(PdBaryDir newDir) {
        if (newDir == null) {
            newDir = new PdBaryDir(3);
        }
        PwBary.projectOntoElement((PgElementSet)this.m_geom, (int)this.m_element, (PdVector)this.m_field.getVector(this.m_element), (PdBaryDir)newDir);
        if (!this.m_orientation) {
            newDir.multScalar(-1.0);
        }
        newDir.setElementInd(this.m_element);
        return newDir;
    }

    public static PnLineDirIf copyNew(PnVectorFieldLineDir lineDir) {
        PnVectorFieldLineDir newLd = new PnVectorFieldLineDir();
        newLd.copy(lineDir);
        return newLd;
    }
}

