/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devShootLines.PnLineDirIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jvx.geom.PwBary;

public class PnGeodesicLineDir
implements PnLineDirIf {
    protected PgElementSet m_geom;
    protected PdBaryDir m_vector;

    @Override
    public void setGeometry(PgElementSet geom) {
        this.m_geom = geom;
    }

    @Override
    public void initializeDirection(PdBary point, PdVector destination) {
        if (this.m_vector == null) {
            this.m_vector = new PdBaryDir(3);
        }
        PdVector start = PwBary.getVertex(null, (PgElementSet)this.m_geom, (PdBary)point);
        PdVector vector = PdVector.subNew((PdVector)destination, (PdVector)start);
        vector.normalize();
        int e = point.getElementInd();
        PwBary.projectOntoElement((PgElementSet)this.m_geom, (int)e, (PdVector)vector, (PdBaryDir)this.m_vector);
    }

    @Override
    public void initializeDirection(PdBary point) {
        PsDebug.warning((String)"Initialization of geodesics with only 1 point not supported.");
    }

    public void initializeDirection(PdBaryDir dir) {
        this.m_vector = PdBaryDir.copyNew((PdBaryDir)dir);
    }

    @Override
    public PdBaryDir getDirection(PdBaryDir dir) {
        if (dir == null) {
            dir = new PdBaryDir(3);
        }
        dir.copy(this.m_vector);
        return dir;
    }

    @Override
    public boolean goToNeighbourElement(int neighbIdx) {
        return PwBary.changeBarycentricOnEdge((PgElementSet)this.m_geom, (PdBaryDir)this.m_vector, (int)neighbIdx);
    }

    @Override
    public void reverse() {
        this.m_vector.multScalar(-1.0);
    }

    @Override
    public void copy(PnLineDirIf lineDir) {
        if (!(lineDir instanceof PnGeodesicLineDir)) {
            PsDebug.warning((String)"LineDir is no PnGeodesicLineDir");
            return;
        }
        PnGeodesicLineDir ld = (PnGeodesicLineDir)lineDir;
        this.m_geom = ld.m_geom;
        this.m_vector = PdBaryDir.copyNew((PdBaryDir)ld.m_vector);
    }
}

