/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devCovering.PgFrameField;
import devShootLines.PnLineDirIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PwBary;

public class PnFrameFieldLineDir
implements PnLineDirIf {
    protected PgElementSet m_geom;
    protected PgFrameField m_field;
    protected int m_element;
    protected int m_layer;
    protected double m_geodesic;
    protected PdBaryDir m_actVector;

    @Override
    public void setGeometry(PgElementSet geom) {
        this.m_geom = geom;
    }

    public void setFrameField(PgFrameField field) {
        this.m_field = field;
    }

    public void setGeodesic(double geodesic) {
        this.m_geodesic = geodesic;
        this.m_actVector = geodesic > 0.0 ? new PdBaryDir(3) : null;
    }

    @Override
    public void initializeDirection(PdBary point, PdVector destination) {
        PdVector vec = new PdVector(3);
        int e = point.getElementInd();
        PiVector element = this.m_geom.getElement(e);
        point.getVertex(vec, this.m_geom.getVertex(element.m_data[0]), this.m_geom.getVertex(element.m_data[1]), this.m_geom.getVertex(element.m_data[2]));
        vec.sub(destination);
        vec.multScalar(-1.0);
        int layer = 0;
        double maxProduct = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < 4) {
            PdVector v = this.m_field.getField(i % 2).getVector(e);
            double product = v.dot(vec) / v.length();
            if (i >= 2) {
                product = -product;
            }
            if (product > maxProduct) {
                maxProduct = product;
                layer = i;
            }
            ++i;
        }
        this.initializeDirection(e, layer);
    }

    @Override
    public void initializeDirection(PdBary point) {
        this.initializeDirection(point.getElementInd(), 1);
    }

    public void initializeDirection(int elementInd, int layer) {
        this.m_layer = layer;
        this.m_element = elementInd;
        if (this.m_actVector != null) {
            this.getFramefieldDirection(this.m_actVector);
        }
    }

    @Override
    public boolean goToNeighbourElement(int neighbIdx) {
        this.m_layer = (this.m_layer + this.m_field.getCovering().getMatching(this.m_element, neighbIdx)) % 4;
        this.m_element = this.m_geom.getNeighbour((int)this.m_element).m_data[neighbIdx];
        if (this.m_geodesic > 0.0) {
            PwBary.changeBarycentricOnEdge((PgElementSet)this.m_geom, (PdBaryDir)this.m_actVector, (int)neighbIdx);
            PdBaryDir newDir = new PdBaryDir(3);
            this.getFramefieldDirection(newDir);
            newDir.blend(this.m_geodesic, this.m_actVector, 1.0 - this.m_geodesic, newDir);
        }
        return !this.m_geom.hasTagElement(this.m_element, 1);
    }

    @Override
    public void reverse() {
        this.m_layer = (this.m_layer + 2) % 4;
        if (this.m_actVector != null) {
            this.m_actVector.multScalar(-1.0);
        }
    }

    @Override
    public void copy(PnLineDirIf lineDir) {
        if (!(lineDir instanceof PnFrameFieldLineDir)) {
            PsDebug.warning((String)"LineDir is no PnFrameFieldLineDir");
            return;
        }
        PnFrameFieldLineDir ld = (PnFrameFieldLineDir)lineDir;
        this.m_geom = ld.m_geom;
        this.m_field = ld.m_field;
        this.m_element = ld.m_element;
        this.m_layer = ld.m_layer;
        this.m_actVector = ld.m_actVector == null ? null : PdBaryDir.copyNew((PdBaryDir)ld.m_actVector);
    }

    @Override
    public PdBaryDir getDirection(PdBaryDir newDir) {
        if (newDir == null) {
            newDir = new PdBaryDir(3);
        }
        if (this.m_actVector != null) {
            newDir.copy(this.m_actVector);
            return newDir;
        }
        return this.getFramefieldDirection(newDir);
    }

    private PdBaryDir getFramefieldDirection(PdBaryDir newDir) {
        PwBary.projectOntoElement((PgElementSet)this.m_geom, (int)this.m_element, (PdVector)this.m_field.getField(PuMath.modulo((int)this.m_layer, (int)2)).getVector(this.m_element), (PdBaryDir)newDir);
        if (this.m_layer >= 2) {
            newDir.multScalar(-1.0);
        }
        newDir.setElementInd(this.m_element);
        return newDir;
    }

    public static PnFrameFieldLineDir copyNew(PnFrameFieldLineDir lineDir) {
        PnFrameFieldLineDir newLd = new PnFrameFieldLineDir();
        newLd.copy(lineDir);
        return newLd;
    }

    public void setActVector(PdBaryDir vector) {
        this.m_actVector.copy(vector);
    }
}

