/*
 * Decompiled with CFR 0.152.
 */
package devShootLines;

import devShootLines.PwShootPoints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jvx.geom.PgPointSetOnElementSet;
import jvx.geom.PwBary;

public class PjShootPoints
extends PjProject
implements ActionListener {
    protected PjImportModel m_import = new PjImportModel();
    protected PwShootPoints m_pwShootPoints;
    protected PgGeometryIf m_geom;
    private PgPointSet m_points;
    private final PdBary m_out;
    protected final String m_defaultFileName = "models/byu/Brezel_480.byu";

    public PjShootPoints() {
        super("ShootPoints Project");
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_out = new PdBary(3);
        this.m_pwShootPoints = new PwShootPoints("ShootPoints workshop");
        this.m_geom = null;
        if (this.getClass() == PjShootPoints.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void start() {
        this.m_import.setFileName("models/byu/Brezel_480.byu");
        this.m_import.load("models/byu/Brezel_480.byu");
        super.start();
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
        this.m_pwShootPoints.setDisplay(disp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadGeometry(this.m_import.getFileName());
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        int num = geomNew.length;
        int i = 0;
        while (i < num) {
            if (geomNew[i] instanceof PgElementSet) {
                PgElementSet es = (PgElementSet)geomNew[i];
                this.setGeometry((PgGeometryIf)es);
                if (es.getNumVectorFields() > 0) {
                    this.m_pwShootPoints.setField(es.getVectorField(0));
                }
            } else if (geomNew[i] instanceof PgPointSet) {
                this.setPoints((PgPointSet)geomNew[i]);
            }
            ++i;
        }
    }

    private boolean setPoints(PgPointSet geom) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Set geometry first");
            return false;
        }
        if (this.m_points != null) {
            this.removeGeometry((PgGeometryIf)this.m_points);
        }
        int num = geom.getNumVertices();
        PgPointSetOnElementSet points = new PgPointSetOnElementSet((PgElementSet)this.m_geom);
        points.setNumVertices(num);
        int i = 0;
        while (i < num) {
            PwBary.projectOntoElementSet((PgElementSet)((PgElementSet)this.m_geom), (PdVector)geom.getVertex(i), (PdBary)this.m_out);
            points.setVertexBary(i, this.m_out);
            ++i;
        }
        this.m_points = points;
        this.addGeometry((PgGeometryIf)this.m_points);
        this.m_pwShootPoints.setPoints(points);
        return true;
    }

    public boolean setGeometry(PgGeometryIf geomNew) {
        if (!(geomNew instanceof PgGeometry)) {
            PsDebug.warning((String)"Geometry must be an instance of PgGeometry.");
            return false;
        }
        if (this.m_geom != null) {
            this.removeGeometry(this.m_geom);
        }
        this.m_geom = geomNew;
        this.addGeometry(this.m_geom);
        this.selectGeometry(this.m_geom);
        this.m_pwShootPoints.setGeometry((PgGeometry)this.m_geom);
        return true;
    }
}

