/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import devProjection.PwProjection;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jvx.project.PjWorkshop_IP;

public class PwProjection_IP
extends PjWorkshop_IP
implements ItemListener {
    protected PwProjection m_pwProjection = null;
    protected Choice m_projectFromList = new Choice();
    protected Choice m_projectToList = new Choice();
    private Button m_startButton;
    private PgPointSet[] m_geoms;
    protected Checkbox m_projectToXYBox;
    protected Checkbox m_projectToYZBox;
    protected Checkbox m_projectToZXBox;
    protected Checkbox m_projectToSphere;
    protected Checkbox m_keepSelected;
    protected Checkbox m_projectToGeometryBox;

    public PwProjection_IP() {
        CheckboxGroup g = new CheckboxGroup();
        this.m_projectToXYBox = new Checkbox("onto XY plane", false, g);
        this.m_projectToXYBox.addItemListener(this);
        this.m_projectToYZBox = new Checkbox("onto YZ plane", false, g);
        this.m_projectToYZBox.addItemListener(this);
        this.m_projectToZXBox = new Checkbox("onto ZX plane", false, g);
        this.m_projectToZXBox.addItemListener(this);
        this.m_projectToSphere = new Checkbox("onto ZX plane", false, g);
        this.m_projectToSphere.addItemListener(this);
        this.m_projectToGeometryBox = new Checkbox("onto another geometry", true, g);
        this.m_projectToGeometryBox.addItemListener(this);
        this.m_keepSelected = new Checkbox("Keep Selected Vertices", true);
        this.m_keepSelected.addItemListener(this);
        if (this.getClass() == PwProjection_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PwProjection)) {
            PsDebug.warning((String)"Parent has to be of type PwProjection");
            return;
        }
        super.setParent(parent);
        this.m_pwProjection = (PwProjection)parent;
        this.makeLayout();
    }

    private void makeLayout() {
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(new Label("Project geometry:"));
        p.add(this.m_projectFromList);
        this.add(p);
        this.add(this.m_projectToXYBox);
        this.add(this.m_projectToYZBox);
        this.add(this.m_projectToZXBox);
        this.add(this.m_projectToSphere);
        p = new Panel(new GridLayout(2, 2));
        p.add(this.m_projectToGeometryBox);
        p.add(this.m_projectToList);
        p.add((Component)this.m_pwProjection.m_forceBoundaries.assureInspector("Info", "_IP"));
        p.add((Component)this.m_pwProjection.m_localProjectionMethod.assureInspector("Info", "_IP"));
        this.add(p);
        p = new Panel(new FlowLayout());
        p.add(this.m_keepSelected);
        this.add(p);
        this.m_startButton = new Button("Start");
        this.add(this.m_startButton);
        this.m_startButton.addActionListener((ActionListener)((Object)this));
    }

    public boolean update(Object event) {
        if (this.m_pwProjection == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwProjection) {
            this.updateChoices();
            return true;
        }
        return super.update(event);
    }

    private void updateChoices() {
        PgGeometryIf[] geoms = this.m_pwProjection.getDisplay().getGeometries();
        PgGeometryIf activeGeom = this.m_pwProjection.getDisplay().getSelectedGeometry();
        int numGeoms = 0;
        if (geoms != null) {
            numGeoms = geoms.length;
        }
        if (this.m_geoms != null) {
            int i = 0;
            while (i < numGeoms) {
                if (geoms[i] instanceof PgPointSet && geoms[i] != this.m_geoms[i]) break;
                ++i;
            }
            if (i == numGeoms) {
                return;
            }
        }
        boolean setDefaultGeometry = this.m_projectFromList.getItemCount() == 0;
        this.m_geoms = new PgPointSet[numGeoms];
        this.m_projectFromList.removeAll();
        int selInd = -1;
        int j = 0;
        int i = 0;
        while (i < numGeoms) {
            if (geoms[i] instanceof PgPointSet) {
                String name = geoms[i].getName();
                this.m_projectFromList.add(name);
                this.m_projectToList.add(name);
                this.m_geoms[i] = (PgPointSet)geoms[i];
                if (geoms[i] == activeGeom) {
                    selInd = j;
                }
                ++j;
            }
            ++i;
        }
        if (selInd != -1 && setDefaultGeometry) {
            this.m_projectFromList.select(selInd);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_pwProjection == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_startButton) {
            int i = this.m_projectFromList.getSelectedIndex();
            this.m_pwProjection.setGeometry((PgGeometry)this.m_geoms[i]);
            if (this.m_projectToXYBox.getState()) {
                this.m_pwProjection.projectToXyPlane();
            } else if (this.m_projectToYZBox.getState()) {
                this.m_pwProjection.projectToYzPlane();
            } else if (this.m_projectToZXBox.getState()) {
                this.m_pwProjection.projectToZxPlane();
            } else if (this.m_projectToSphere.getState()) {
                this.m_pwProjection.projectToSphere();
            } else {
                int j = this.m_projectToList.getSelectedIndex();
                if (i == j) {
                    PsDebug.warning((String)"Cannot project geometry to itself.");
                    return;
                }
                this.m_pwProjection.setDomainGeometry(this.m_geoms[j]);
                this.m_pwProjection.projectToDomain();
            }
            this.m_geoms[i].update((Object)this.m_geoms[i]);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_projectToXYBox || source == this.m_projectToYZBox || source == this.m_projectToZXBox || source == this.m_projectToGeometryBox || source == this.m_projectToSphere) {
            if (this.m_projectToGeometryBox.getState()) {
                this.m_projectFromList.setEnabled(true);
                this.m_projectToList.setEnabled(true);
                this.m_pwProjection.m_forceBoundaries.setEnabled(true);
                this.m_pwProjection.m_projectIntrinsic.setEnabled(true);
            } else {
                this.m_projectFromList.setEnabled(false);
                this.m_projectToList.setEnabled(false);
                this.m_pwProjection.m_forceBoundaries.setEnabled(false);
                this.m_pwProjection.m_projectIntrinsic.setEnabled(false);
            }
        } else if (source == this.m_keepSelected) {
            this.m_pwProjection.setKeepSelected(this.m_keepSelected.getState());
        }
    }
}

