/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import devProjection.PgIntrinsicPolygon;
import devProjection.PnProjection;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.project.PjWorkshop;

public class PwProjection
extends PjWorkshop {
    protected PgPointSet m_geom = null;
    protected PgPointSet m_domain;
    protected PuBoolean m_forceBoundaries = new PuBoolean("Force boundaries", null, false);
    protected PuBoolean m_localProjectionMethod;
    protected PuBoolean m_projectIntrinsic = new PuBoolean("Project to intrinsic polygon", null, false);
    protected boolean m_bKeepSelectedVertices = true;

    public PwProjection() {
        super("Projection Workshop");
        this.m_localProjectionMethod = new PuBoolean("Local projection", null, false);
        this.m_localProjectionMethod.setEnabled(false);
        if (((Object)((Object)this)).getClass() == PwProjection.class) {
            this.init();
        }
    }

    public PwProjection(String name, PgElementSet geom) {
        this();
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
        this.m_forceBoundaries.init();
        this.m_projectIntrinsic.init();
        this.m_localProjectionMethod.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgPointSet)) {
            PsDebug.warning((String)"Geomerty is not an instance of jv.geom.PgPointSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgPointSet)geom;
        this.save();
    }

    public void setDomainGeometry(PgPointSet domain) {
        this.m_domain = domain;
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public void setKeepSelected(boolean flag) {
        this.m_bKeepSelectedVertices = flag;
    }

    public boolean isKeepingSelected() {
        return this.m_bKeepSelectedVertices;
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
    }

    public void save() {
        if (this.m_geom == null) {
            return;
        }
        if (this.m_geomSave != null) {
            this.m_geomSave.copy((PsObject)this.m_geom);
        }
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Projection workshop";
    }

    public void projectToDomain() {
        PgGeometryIf projGeom = PwProjection.projectGeometry(this.m_geom, this.m_domain, this.m_localProjectionMethod.getState(), this.m_projectIntrinsic.getState(), this.m_forceBoundaries.getState(), this.m_bKeepSelectedVertices);
        if (projGeom != null) {
            this.getDisplay().addGeometry(projGeom);
        }
    }

    public static PgGeometryIf projectGeometry(PgPointSet geom, PgPointSet domain, boolean local, boolean intrinsic, boolean forceBoundaries, boolean bKeepSelectedVertices) {
        if (domain == null) {
            PsDebug.warning((String)"Domain geometry is null");
            return null;
        }
        if (domain instanceof PgElementSet && ((PgElementSet)domain).getDimOfElements() != 3) {
            PsDebug.warning((String)"Element set must be triangulated");
            return null;
        }
        if (!local) {
            if (domain instanceof PgElementSet) {
                PnProjection.projectPointSetOntoElementSet(geom, (PgElementSet)domain, bKeepSelectedVertices);
            } else {
                PsDebug.warning((String)"Can only project onto a PgElementSet with non-local method");
            }
            return null;
        }
        if (geom instanceof PgPolygon) {
            if (domain instanceof PgElementSet) {
                if (intrinsic) {
                    PgPolygon polygon = (PgPolygon)geom;
                    PgIntrinsicPolygon outPoly = new PgIntrinsicPolygon((PgElementSet)domain);
                    new PnProjection().projectPolygonOntoElementSet((PgElementSet)domain, polygon, (PdBary)null, true, outPoly);
                    return outPoly;
                }
                PgPolygon polygon = (PgPolygon)geom;
                PgIntrinsicPolygon outPoly = new PgIntrinsicPolygon((PgElementSet)domain);
                new PnProjection().projectPolygonOntoElementSet((PgElementSet)domain, polygon, null, true, (PgPolygonOnElementSet)outPoly);
                return outPoly;
            }
            if (domain instanceof PgPolygon) {
                PsDebug.warning((String)"Feature is not implemented yet");
            } else {
                PsDebug.warning((String)"Can only project a PgPolygon onto a PgPolygon or PgElementSet");
            }
        } else if (domain instanceof PgElementSet) {
            PsDebug.warning((String)"Feature is not implemented yet. Please unmark 'local projection' checkbox.");
        } else if (domain instanceof PgPolygon) {
            PsDebug.warning((String)"Feature is not implemented yet");
        } else {
            PsDebug.warning((String)"Can only project a PgPointSet onto a PgPolygon or PgElementSet");
        }
        return null;
    }

    public void projectToXyPlane() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return;
        }
        int num = this.m_geom.getNumVertices();
        boolean warningShown = false;
        int v = 0;
        while (v < num) {
            PdVector vertex;
            if (!(this.m_bKeepSelectedVertices && this.m_geom.hasTagVertex(v, 1) || (vertex = this.m_geom.getVertex(v)) == null)) {
                int dim = vertex.getSize();
                if (dim < 3) {
                    if (!warningShown) {
                        PsDebug.warning((String)"Cannot project vertices with dim < 3");
                        warningShown = true;
                    }
                } else {
                    int i = 2;
                    while (i < dim) {
                        vertex.m_data[i] = 0.0;
                        ++i;
                    }
                }
            }
            ++v;
        }
    }

    public void projectToYzPlane() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return;
        }
        int num = this.m_geom.getNumVertices();
        boolean warningShown = false;
        int v = 0;
        while (v < num) {
            PdVector vertex;
            if (!(this.m_bKeepSelectedVertices && this.m_geom.hasTagVertex(v, 1) || (vertex = this.m_geom.getVertex(v)) == null)) {
                int dim = vertex.getSize();
                if (dim < 3) {
                    if (!warningShown) {
                        PsDebug.warning((String)"Cannot project vertices with dim < 3");
                        warningShown = true;
                    }
                } else {
                    vertex.m_data[0] = 0.0;
                    int i = 3;
                    while (i < dim) {
                        vertex.m_data[i] = 0.0;
                        ++i;
                    }
                }
            }
            ++v;
        }
    }

    public void projectToZxPlane() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return;
        }
        int num = this.m_geom.getNumVertices();
        boolean warningShown = false;
        int v = 0;
        while (v < num) {
            PdVector vertex;
            if (!(this.m_bKeepSelectedVertices && this.m_geom.hasTagVertex(v, 1) || (vertex = this.m_geom.getVertex(v)) == null)) {
                int dim = vertex.getSize();
                if (dim < 3) {
                    if (!warningShown) {
                        PsDebug.warning((String)"Cannot project vertices with dim < 3");
                        warningShown = true;
                    }
                } else {
                    vertex.m_data[1] = 0.0;
                    int i = 3;
                    while (i < dim) {
                        vertex.m_data[i] = 0.0;
                        ++i;
                    }
                }
            }
            ++v;
        }
    }

    public void projectToSphere() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return;
        }
        int num = this.m_geom.getNumVertices();
        int v = 0;
        while (v < num) {
            PdVector vertex;
            if (!(this.m_bKeepSelectedVertices && this.m_geom.hasTagVertex(v, 1) || (vertex = this.m_geom.getVertex(v)) == null)) {
                vertex.normalize();
            }
            ++v;
        }
    }
}

