/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import dev.geom.PuElementSetIterator;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPointSetOnElementSet;
import jvx.geom.PgPointSetOnPolygon;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwBoundary;

public class PnProjectionAH {
    public static void convertFromBoundaryToElementSet(PgBndPolygon domain, PdBary[] bary2d, PgBndPolygon polyIn, PdBary[] bary3d) {
        int polyLen = polyIn.getNumVertices() - 1;
        int[] vertInd = polyIn.getVertexInd().m_data;
        int[] targetVertInd = domain.getVertexInd().m_data;
        int[] targetElemInd = domain.getElementInd().m_data;
        int[] targetEdgeInd = domain.getNeighbourLocInd().m_data;
        PgElementSet target = domain.getGeometry();
        PiVector[] elements = target.getElements();
        int i = 0;
        while (i < polyLen) {
            int iv = vertInd[i];
            if (bary3d[iv] == null) {
                bary3d[iv] = new PdBary(3);
            } else if (bary3d[iv].getSize() != 3) {
                bary3d[iv].setSize(3);
            }
            int edgeInd = bary2d[i].m_elementInd;
            int startVertex = targetVertInd[edgeInd];
            int elemInd = targetElemInd[edgeInd];
            int oppVertLocInd = targetEdgeInd[edgeInd];
            int v1Ind = (oppVertLocInd + 1) % 3;
            int v0Ind = (v1Ind + 1) % 3;
            int[] element = elements[elemInd].m_data;
            if (startVertex != element[v0Ind]) {
                int tmp = v0Ind;
                v0Ind = v1Ind;
                v1Ind = tmp;
            }
            bary3d[iv].setElementInd(elemInd);
            bary3d[iv].m_data[v0Ind] = bary2d[i].m_data[0];
            bary3d[iv].m_data[v1Ind] = bary2d[i].m_data[1];
            bary3d[iv].m_data[oppVertLocInd] = 0.0;
            ++i;
        }
    }

    public static PdBary[] projectSurface(PgPointSet geom, PgElementSet domain) {
        int numV = geom.getNumVertices();
        PdBary[] bary = new PdBary[numV];
        int v = 0;
        while (v < numV) {
            PdVector vertex = geom.getVertex(v);
            bary[v] = new PdBary(3);
            PwBary.projectOntoElementSet((PgElementSet)domain, (PdVector)vertex, (PdBary)bary[v]);
            PwBary.getVertex((PdVector)vertex, (PgElementSet)domain, (PdBary)bary[v]);
            ++v;
        }
        return bary;
    }

    public static PdBary[] projectSurface(PgElementSet geom, PgElementSet target, boolean forceBoundaries) {
        int numV = geom.getNumVertices();
        PdBary[] bary = new PdBary[numV];
        PdBary bary2D = new PdBary(2);
        if (forceBoundaries) {
            PwBoundary.makeBoundary((PgElementSet)geom);
            PwBoundary.makeBoundary((PgElementSet)target);
            PgBndPolygon[] bnd = geom.getBoundaries();
            PgBndPolygon[] domainBnd = target.getBoundaries();
            int bndInd = 0;
            while (bndInd < bnd.length) {
                bnd[bndInd].setClosed(true);
                ++bndInd;
            }
            if (domainBnd.length == 0) {
                PsDebug.warning((String)"Domain has no boundaries.");
                return null;
            }
            bndInd = 0;
            while (bndInd < bnd.length) {
                double minDist = Double.MAX_VALUE;
                int targetPolygon = -1;
                int i = 0;
                while (i < domainBnd.length) {
                    double d = PnProjectionAH.projectOntoPolygon(bnd[bndInd].getVertex(0), (PgPolygon)domainBnd[i], bary2D);
                    if (d < minDist) {
                        minDist = d;
                        targetPolygon = i;
                    }
                    ++i;
                }
                int polyLen = bnd[bndInd].getNumVertices();
                PdBary[] bary2DArr = PdBary.realloc(null, (int)polyLen, (int)2);
                PnProjectionAH.projectPolygonOntoPolygon((PgPolygon)bnd[bndInd], (PgPolygon)domainBnd[targetPolygon], bary2DArr);
                PiVector vertInd = bnd[bndInd].getVertexInd();
                int v = 0;
                while (v < polyLen) {
                    int vInd = vertInd.m_data[v];
                    PnProjectionAH.getVertex(geom.getVertex(vInd), bary2DArr[v], (PgPolygon)domainBnd[targetPolygon]);
                    ++v;
                }
                ++bndInd;
            }
        }
        int v = 0;
        while (v < numV) {
            PdVector vertex = geom.getVertex(v);
            bary[v] = new PdBary(3);
            PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)vertex, (PdBary)bary[v]);
            ++v;
        }
        return bary;
    }

    public static PgPointSetOnPolygon[] projectSurface(PgElementSet geom, PgPointSetOnElementSet surfacePoints, PgElementSet target, PgElementSet source, boolean mapBoundaries, int startVertexInd, boolean ignoreOutside) {
        boolean clearAllTags = true;
        boolean tag = false;
        int noe = geom.getNumElements();
        int nov = geom.getNumVertices();
        PiVector[] elements = geom.getElements();
        PdBary[] bary = PdBary.realloc(null, (int)nov, (int)3);
        surfacePoints.setVertexBary(bary);
        int i = 0;
        while (i < noe) {
            elements[i].clearTag(0);
            ++i;
        }
        PdVector[] v = geom.getVertices();
        int i2 = 0;
        while (i2 < nov) {
            v[i2].clearTag(0);
            ++i2;
        }
        PgPointSetOnPolygon[] boundaryPoint = null;
        if (mapBoundaries) {
            boundaryPoint = PnProjectionAH.projectBoundaries(geom, target);
            PgBndPolygon[] bnd = geom.getBoundaries();
            int numBnd = bnd.length;
            int bndInd = 0;
            while (bndInd < numBnd) {
                PgPointSetOnPolygon boundaryPoints = boundaryPoint[bndInd];
                PgBndPolygon poly = bnd[bndInd];
                PiVector vertInd = poly.getVertexInd();
                PnProjectionAH.convertFromBoundaryToElementSet((PgBndPolygon)boundaryPoints.getGeometry(), boundaryPoints.getVertexBary(), poly, bary);
                int polyLen = poly.getNumVertices() - 1;
                int i3 = 0;
                while (i3 < polyLen) {
                    int iv = vertInd.m_data[i3];
                    PdVector vertex = v[iv];
                    vertex.setTag(0);
                    ++i3;
                }
                ++bndInd;
            }
        }
        startVertexInd = startVertexInd >= 0 ? startVertexInd : 0;
        PdVector startVertex = PdVector.copyNew((PdVector)v[startVertexInd]);
        PuElementSetIterator it = new PuElementSetIterator(geom, 0);
        it.init(startVertexInd, 2);
        PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)geom.getVertex(startVertexInd), (PdBary)bary[startVertexInd]);
        while (it.hasNext()) {
            int v0 = it.getNext();
            int startElem = -1;
            startElem = bary[v0].m_elementInd;
            if (startElem == -1) continue;
            if (v0 == 116) {
                v0 += 0;
            }
            PiVector succ = it.getSuccessors();
            v[v0].clearTag(1);
            int n = 0;
            while (n < succ.getSize()) {
                int v1 = succ.getEntry(n);
                if (v1 == 374) {
                    v0 += 0;
                }
                if (bary[v1].m_elementInd == -1) {
                    PdVector normal;
                    PdVector vertex = geom.getVertex(v1);
                    boolean result = PnProjectionAH.projectVertexOntoElementSet(target, vertex, normal = source != null ? geom.getVertexNormal(v1) : null, startElem, bary[v1], ignoreOutside);
                    if (!result) {
                        it.blockEdge(n);
                    }
                }
                ++n;
            }
        }
        v[startVertexInd].copy(startVertex);
        boolean outside = PnProjectionAH.projectVertexOntoElementSet(target, v[startVertexInd], geom.getVertexNormal(startVertexInd), bary[startVertexInd].m_elementInd, bary[startVertexInd], ignoreOutside);
        if (outside) {
            v[startVertexInd].copy(startVertex);
        }
        return boundaryPoint;
    }

    private static PgPointSetOnPolygon[] projectBoundaries(PgElementSet geom, PgElementSet target) {
        boolean bDebug = true;
        PwBoundary.makeBoundary((PgElementSet)geom);
        PgBndPolygon[] bnd = geom.getBoundaries();
        int numBnd = bnd.length;
        PdVector[] bndCenter = new PdVector[numBnd];
        PgPointSetOnPolygon[] boundaryPoints = new PgPointSetOnPolygon[numBnd];
        PwBoundary.makeBoundary((PgElementSet)target);
        PgBndPolygon[] domainBnd = target.getBoundaries();
        PdVector[] domainBndCenter = new PdVector[domainBnd.length];
        int i = 0;
        while (i < domainBnd.length) {
            domainBndCenter[i] = domainBnd[i].getCenterOfGravity();
            ++i;
        }
        int bndInd = 0;
        while (bndInd < numBnd) {
            bnd[bndInd].setClosed(true);
            ++bndInd;
        }
        if (domainBnd.length == 0) {
            PsDebug.warning((String)"Domain has no boundaries.");
            numBnd = 0;
        }
        bndInd = 0;
        while (bndInd < numBnd) {
            PgBndPolygon poly = bnd[bndInd];
            bndCenter[bndInd] = poly.getCenterOfGravity();
            double minDist = Double.MAX_VALUE;
            int targetPolyInd = -1;
            int i2 = 0;
            while (i2 < domainBnd.length) {
                double d = bndCenter[bndInd].dist(domainBndCenter[i2]);
                if (d < minDist) {
                    minDist = d;
                    targetPolyInd = i2;
                }
                ++i2;
            }
            System.out.println("projecting " + bndInd + " onto " + targetPolyInd);
            int polyLen = poly.getNumVertices() - 1;
            PdBary[] bary2d = PdBary.realloc(null, (int)polyLen, (int)2);
            PgBndPolygon targetPoly = domainBnd[targetPolyInd];
            boundaryPoints[bndInd] = new PgPointSetOnPolygon((PgPolygon)targetPoly);
            PnProjectionAH.projectPolygonOntoPolygon((PgPolygon)poly, (PgPolygon)targetPoly, bary2d);
            boundaryPoints[bndInd].setNumVertices(bary2d.length);
            boundaryPoints[bndInd].setVertexBary(bary2d);
            ++bndInd;
        }
        return boundaryPoints;
    }

    private static boolean projectVertexOntoElement(PgElementSet target, PdVector vertex, PdVector vertexNormal, int elemInd, PdBary outBary) {
        PdVector elementNormal = target.getElementNormal(elemInd);
        if (vertexNormal != null && Math.abs(vertexNormal.dot(elementNormal)) > 1.0E-10) {
            PdVector v0 = target.getVertex(target.getElement((int)elemInd).m_data[0]);
            double pn = 0.0;
            int dim = vertex.getSize();
            int i = 0;
            while (i < dim) {
                pn += (vertex.m_data[i] - v0.m_data[i]) * elementNormal.m_data[i];
                ++i;
            }
            double div = elementNormal.dot(vertexNormal);
            if (Math.abs(div) > 1.0E-10) {
                vertex.blendBase(vertex, -pn / div, vertexNormal);
            }
        }
        PwBary.projectOntoElement((PgElementSet)target, (int)elemInd, (PdVector)vertex, (PdBary)outBary);
        boolean done = outBary.isInside();
        if (!done) {
            PnProjectionAH.projectToInside(target, outBary);
        }
        return done;
    }

    public static void projectToInside(PgElementSet target, PdBary inOutBary) {
        int neg1 = 2;
        while (inOutBary.m_data[neg1] >= 0.0) {
            --neg1;
        }
        int neg2 = neg1 - 1;
        while (neg2 != -1 && inOutBary.m_data[neg2] >= 0.0) {
            --neg2;
        }
        PwBary.projectOntoElementEdge((PgElementSet)target, (PdBary)inOutBary, (int)neg1);
        inOutBary.projectToInside();
        int vert = PwBary.liesOnVertex((PdBary)inOutBary);
        if (neg2 != -1 && vert != -1 && vert != neg1 && vert != neg2) {
            PwBary.projectOntoElementEdge((PgElementSet)target, (PdBary)inOutBary, (int)neg2);
            inOutBary.projectToInside();
        }
    }

    public static boolean projectVertexOntoElementSet(PgElementSet target, PdVector vertex, PdVector vertexNormal, int elemInd, PdBary outBary, boolean ignoreOutside) {
        boolean bDebug = true;
        int maxStep = 200;
        PiVector[] elements = target.getElements();
        PiVector[] neighbour = target.getNeighbours();
        PdVector[] elementNormal = target.getElementNormals();
        boolean done = false;
        int initialElem = elemInd;
        PgVertexStar star = new PgVertexStar();
        int prevElemInd = -1;
        PdBary bary = new PdBary(3);
        boolean didProject = false;
        boolean hitBoundary = false;
        PdVector vertexCopy = new PdVector(3);
        int step = 0;
        while (step < 200 && !done) {
            if (elemInd == -1) {
                hitBoundary = true;
                break;
            }
            if (!didProject) {
                vertexCopy.copy(vertex);
                done = PnProjectionAH.projectVertexOntoElement(target, vertexCopy, vertexNormal, elemInd, outBary);
                if (done) break;
            }
            didProject = false;
            int edgeInd = PwBary.liesOnEdge((PdBary)outBary);
            if (edgeInd != -1) {
                double dihedral;
                int nextElemInd = neighbour[elemInd].m_data[edgeInd];
                hitBoundary = nextElemInd == -1;
                if (hitBoundary || prevElemInd == nextElemInd || (dihedral = elementNormal[nextElemInd].dot(elementNormal[elemInd])) < 1.0E-10) break;
                prevElemInd = elemInd;
                elemInd = nextElemInd;
            } else {
                int vertInd = PwBary.liesOnVertex((PdBary)outBary);
                if (vertInd == -1) {
                    PsDebug.error((String)"we should never get here!");
                }
                int[] elem = elements[elemInd].m_data;
                star.makeVertexStar(target, elem[vertInd], elemInd);
                PiVector vertexLocInd = star.getVertexLocInd();
                int[] ie = star.getElement().m_data;
                int nextElementInd = -1;
                boolean liesOnEdge = false;
                boolean alwaysLiesOnCenterVertex = true;
                int numStarElements = star.getSize();
                int i = 0;
                while (i < numStarElements) {
                    int iei = ie[i];
                    if (iei != elemInd) {
                        boolean liesOnCenterVertex;
                        vertexCopy.copy(vertex);
                        done = PnProjectionAH.projectVertexOntoElement(target, vertexCopy, vertexNormal, iei, bary);
                        if (done) {
                            outBary.copy(bary);
                            break;
                        }
                        int onVertex = PwBary.liesOnVertex((PdBary)bary);
                        boolean bl = liesOnCenterVertex = onVertex == vertexLocInd.m_data[i];
                        if (!liesOnCenterVertex) {
                            boolean liesOnOppositeEdge;
                            alwaysLiesOnCenterVertex = false;
                            int onEdge = PwBary.liesOnEdge((PdBary)bary);
                            boolean bl2 = liesOnOppositeEdge = onEdge == vertexLocInd.m_data[i];
                            if (liesOnOppositeEdge || onVertex != -1 && !liesOnCenterVertex) {
                                nextElementInd = iei;
                                outBary.copy(bary);
                                break;
                            }
                            if (!liesOnEdge) {
                                nextElementInd = iei;
                                outBary.copy(bary);
                                liesOnEdge = true;
                            }
                        }
                    }
                    ++i;
                }
                if (alwaysLiesOnCenterVertex) {
                    boolean bl = hitBoundary = !star.isClosed();
                }
                if (done || alwaysLiesOnCenterVertex || liesOnEdge && nextElementInd == prevElemInd) break;
                prevElemInd = elemInd;
                elemInd = nextElementInd;
                didProject = true;
            }
            ++step;
        }
        boolean result = true;
        if (step == 200) {
            PsDebug.warning((String)("too many iterations, elemInd = " + initialElem));
            PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)vertex, (PdBary)outBary);
        } else if (hitBoundary) {
            if (ignoreOutside) {
                outBary.set(-1, 0.0, 0.0, 0.0);
            } else {
                PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)vertex, (PdBary)outBary);
            }
            result = false;
        }
        if (!ignoreOutside && outBary.m_elementInd == -1) {
            PsDebug.warning((String)"wrong output");
            result = false;
        }
        return result;
    }

    public static void projectPolygonOntoPolygon(PgPolygon polygon, PgPolygon domain, PdBary[] bary) {
        int numV = polygon.getNumVertices() - 1;
        int v = 0;
        while (v < numV) {
            PdVector vertex = polygon.getVertex(v);
            PnProjectionAH.projectOntoPolygon(vertex, domain, bary[v]);
            ++v;
        }
    }

    public static double projectOntoPolygon(PdVector vertex, PgPolygon polygon, PdBary bary2D) {
        int numE = polygon.getNumEdges();
        int numV = polygon.getNumVertices();
        double minDist = Double.MAX_VALUE;
        PdBary bary = new PdBary(2);
        PdVector point = new PdVector(3);
        int e = 0;
        while (e < numE) {
            int ne = (e + 1) % numV;
            PdVector v0 = polygon.getVertex(e);
            PdVector v1 = polygon.getVertex(ne);
            PdBary.getBary((PdBary)bary, (PdVector)vertex, (PdVector)v0, (PdVector)v1);
            bary.projectToInside();
            PnProjectionAH.getVertex(point, bary, v0, v1);
            double distance = point.sqrDist(vertex);
            if (distance < minDist) {
                minDist = distance;
                bary2D.copy(bary);
                bary2D.setElementInd(e);
            }
            ++e;
        }
        return minDist;
    }

    public static void getVertex(PdVector p, PdBary bary, PdVector v0, PdVector v1) {
        int dim = v0.getSize();
        double[] b = bary.m_data;
        int i = 0;
        while (i < dim) {
            p.m_data[i] = b[0] * v0.m_data[i] + b[1] * v1.m_data[i];
            ++i;
        }
    }

    public static void getVertex(PdVector p, PdBary bary, PgPolygon polygon) {
        int edgeInd = bary.getElementInd();
        int polyLen = polygon.getNumVertices();
        PnProjectionAH.getVertex(p, bary, polygon.getVertex(edgeInd), polygon.getVertex((edgeInd + 1) % polyLen));
    }
}

